/******/ (() => { // webpackBootstrap
    var __webpack_exports__ = {};
    /*!****************************************************!*\
      !*** ./resources/assets/js/patient_queue/queue.js ***!
      \****************************************************/
    function updateTime() {
      var now = new Date();
      var time = now.toLocaleTimeString([], {
        hour: '2-digit',
        minute: '2-digit'
      });
      var date = now.toLocaleDateString([], {
        weekday: 'long',
        year: 'numeric',
        month: 'long',
        day: 'numeric'
      });
      document.getElementById('clock').textContent = time;
      document.getElementById('date').textContent = date;
    }
    
    setInterval(updateTime, 1000);
    updateTime();
    document.addEventListener("DOMContentLoaded", function () {
      var refreshInterval = 20; // seconds
    
      var timer = refreshInterval;
      var timerEl = document.getElementById("refresh-timer");
      setInterval(function () {
        timer--;
        timerEl.textContent = timer;
    
        if (timer <= 0) {
          fetch("/patient-queue-refresh").then(function (res) {
            return res.text();
          }).then(function (html) {
            document.getElementById("queue-container").innerHTML = html;
            timer = refreshInterval; // reset timer
          })["catch"](function () {
            timer = refreshInterval;
          });
        }
      }, 1000);
    });
    /******/ })()
    ;