-- phpMyAdmin SQL Dump
-- version 5.2.1
-- https://www.phpmyadmin.net/
--
-- Host: localhost
-- Generation Time: Jun 21, 2025 at 06:19 AM
-- Server version: 8.0.31
-- PHP Version: 8.2.27

SET SQL_MODE = "NO_AUTO_VALUE_ON_ZERO";
START TRANSACTION;
SET time_zone = "+00:00";


/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!40101 SET NAMES utf8mb4 */;

--
-- Database: `hms-saas`
--

-- --------------------------------------------------------

--
-- Table structure for table `accountants`
--

CREATE TABLE `accountants` (
  `id` int UNSIGNED NOT NULL,
  `user_id` bigint UNSIGNED NOT NULL,
  `tenant_id` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `accounts`
--

CREATE TABLE `accounts` (
  `id` int UNSIGNED NOT NULL,
  `name` varchar(160) COLLATE utf8mb4_unicode_ci NOT NULL,
  `type` tinyint NOT NULL,
  `description` text COLLATE utf8mb4_unicode_ci,
  `status` tinyint(1) NOT NULL DEFAULT '0',
  `tenant_id` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `addresses`
--

CREATE TABLE `addresses` (
  `id` bigint UNSIGNED NOT NULL,
  `owner_id` int DEFAULT NULL,
  `owner_type` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `address1` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `address2` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `city` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `zip` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `tenant_id` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `admin_testimonials`
--

CREATE TABLE `admin_testimonials` (
  `id` bigint UNSIGNED NOT NULL,
  `name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `position` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `description` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Dumping data for table `admin_testimonials`
--

INSERT INTO `admin_testimonials` (`id`, `name`, `position`, `description`, `created_at`, `updated_at`) VALUES
(1, 'Jasse Lynn', 'Founder of Sassaht', 'Eeque porro quisquam est, qui dolorem ipsum quia dolor sit amet, consectetur,\n                                                adipisci velit, sed quia non numquam eius modi tempora incidunt contact\n                                                me.', '2025-06-21 00:42:23', '2025-06-21 00:42:23'),
(2, 'Thomas James', 'CEO of Sassaht', 'Reasonable porro quisquam est, qui dolorem ipsum quia dolor sit amet,\n                                                consectetur, adipisci velit, sed quia non numquam eius modi tempora incidunt\n                                                looks.', '2025-06-21 00:42:23', '2025-06-21 00:42:23'),
(3, 'Ceathy White', 'Founder of Sassaht', 'On the other hand, we denounce with righteous indignation and dislike men who\n                                                are so beguiled and demoralized by the charms of pleasure of the momen\n                                                words.', '2025-06-21 00:42:23', '2025-06-21 00:42:23');

-- --------------------------------------------------------

--
-- Table structure for table `advanced_payments`
--

CREATE TABLE `advanced_payments` (
  `id` int UNSIGNED NOT NULL,
  `patient_id` bigint UNSIGNED NOT NULL,
  `receipt_no` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `amount` double NOT NULL,
  `date` date NOT NULL,
  `tenant_id` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `ambulances`
--

CREATE TABLE `ambulances` (
  `id` int UNSIGNED NOT NULL,
  `vehicle_number` varchar(160) COLLATE utf8mb4_unicode_ci NOT NULL,
  `vehicle_model` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `year_made` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `driver_name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `driver_license` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `driver_contact` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `note` text COLLATE utf8mb4_unicode_ci,
  `is_available` tinyint(1) NOT NULL DEFAULT '1',
  `vehicle_type` int NOT NULL DEFAULT '1',
  `tenant_id` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `ambulance_calls`
--

CREATE TABLE `ambulance_calls` (
  `id` int UNSIGNED NOT NULL,
  `patient_id` int UNSIGNED NOT NULL,
  `ambulance_id` int UNSIGNED NOT NULL,
  `driver_name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `date` date NOT NULL,
  `amount` double NOT NULL,
  `tenant_id` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `appointments`
--

CREATE TABLE `appointments` (
  `id` bigint UNSIGNED NOT NULL,
  `patient_id` int UNSIGNED NOT NULL,
  `doctor_id` bigint UNSIGNED NOT NULL,
  `department_id` bigint UNSIGNED NOT NULL,
  `opd_date` datetime NOT NULL,
  `problem` text COLLATE utf8mb4_unicode_ci,
  `is_completed` tinyint(1) NOT NULL DEFAULT '0',
  `payment_status` tinyint(1) NOT NULL DEFAULT '0',
  `payment_type` int DEFAULT NULL,
  `custom_field` longtext COLLATE utf8mb4_unicode_ci,
  `tenant_id` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `appointment_transactions`
--

CREATE TABLE `appointment_transactions` (
  `id` bigint UNSIGNED NOT NULL,
  `appointment_id` bigint UNSIGNED NOT NULL,
  `transaction_type` int NOT NULL,
  `transaction_id` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `tenant_id` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `beds`
--

CREATE TABLE `beds` (
  `id` int UNSIGNED NOT NULL,
  `bed_type` int UNSIGNED NOT NULL,
  `bed_id` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `description` text COLLATE utf8mb4_unicode_ci,
  `charge` double NOT NULL,
  `is_available` tinyint(1) NOT NULL DEFAULT '1',
  `tenant_id` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `bed_assigns`
--

CREATE TABLE `bed_assigns` (
  `id` int UNSIGNED NOT NULL,
  `bed_id` int UNSIGNED NOT NULL,
  `ipd_patient_department_id` int UNSIGNED DEFAULT NULL,
  `patient_id` int UNSIGNED NOT NULL,
  `case_id` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `assign_date` datetime NOT NULL,
  `discharge_date` datetime DEFAULT NULL,
  `description` text COLLATE utf8mb4_unicode_ci,
  `status` tinyint(1) NOT NULL DEFAULT '0',
  `tenant_id` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `bed_types`
--

CREATE TABLE `bed_types` (
  `id` int UNSIGNED NOT NULL,
  `title` varchar(160) COLLATE utf8mb4_unicode_ci NOT NULL,
  `description` text COLLATE utf8mb4_unicode_ci,
  `tenant_id` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `bills`
--

CREATE TABLE `bills` (
  `id` int UNSIGNED NOT NULL,
  `bill_id` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `patient_id` int UNSIGNED NOT NULL,
  `bill_date` datetime NOT NULL,
  `amount` decimal(16,2) DEFAULT NULL,
  `tenant_id` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `patient_admission_id` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `status` tinyint(1) DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `bill_items`
--

CREATE TABLE `bill_items` (
  `id` int UNSIGNED NOT NULL,
  `item_name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `bill_id` int UNSIGNED NOT NULL,
  `qty` int UNSIGNED NOT NULL,
  `price` decimal(16,2) NOT NULL,
  `amount` decimal(16,2) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `bill_transactions`
--

CREATE TABLE `bill_transactions` (
  `id` bigint UNSIGNED NOT NULL,
  `transaction_id` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `payment_type` int NOT NULL COMMENT '1 = Stripe, 2 = Manual',
  `amount` decimal(16,2) NOT NULL,
  `bill_id` int UNSIGNED NOT NULL,
  `status` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `meta` text COLLATE utf8mb4_unicode_ci,
  `tenant_id` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `is_manual_payment` int DEFAULT '0',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `birth_reports`
--

CREATE TABLE `birth_reports` (
  `id` int UNSIGNED NOT NULL,
  `patient_id` int UNSIGNED NOT NULL,
  `case_id` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `doctor_id` bigint UNSIGNED NOT NULL,
  `date` datetime NOT NULL,
  `description` text COLLATE utf8mb4_unicode_ci,
  `tenant_id` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `blood_banks`
--

CREATE TABLE `blood_banks` (
  `id` int UNSIGNED NOT NULL,
  `blood_group` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `remained_bags` bigint NOT NULL,
  `tenant_id` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `blood_donations`
--

CREATE TABLE `blood_donations` (
  `id` int UNSIGNED NOT NULL,
  `blood_donor_id` int UNSIGNED NOT NULL,
  `bags` int NOT NULL DEFAULT '1',
  `tenant_id` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `blood_donors`
--

CREATE TABLE `blood_donors` (
  `id` int UNSIGNED NOT NULL,
  `name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `age` int NOT NULL,
  `gender` int NOT NULL,
  `blood_group` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `last_donate_date` datetime NOT NULL,
  `tenant_id` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `blood_issues`
--

CREATE TABLE `blood_issues` (
  `id` bigint UNSIGNED NOT NULL,
  `issue_date` datetime NOT NULL,
  `doctor_id` bigint UNSIGNED NOT NULL,
  `donor_id` int UNSIGNED NOT NULL,
  `patient_id` int UNSIGNED NOT NULL,
  `amount` decimal(10,2) NOT NULL DEFAULT '0.00',
  `remarks` text COLLATE utf8mb4_unicode_ci,
  `tenant_id` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `brands`
--

CREATE TABLE `brands` (
  `id` int UNSIGNED NOT NULL,
  `name` varchar(160) COLLATE utf8mb4_unicode_ci NOT NULL,
  `email` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `phone` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `tenant_id` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `cache`
--

CREATE TABLE `cache` (
  `key` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `value` mediumtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `expiration` int NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `cache_locks`
--

CREATE TABLE `cache_locks` (
  `key` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `owner` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `expiration` int NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `call_logs`
--

CREATE TABLE `call_logs` (
  `id` bigint UNSIGNED NOT NULL,
  `name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `phone` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `date` date DEFAULT NULL,
  `follow_up_date` date DEFAULT NULL,
  `note` text COLLATE utf8mb4_unicode_ci,
  `call_type` int NOT NULL,
  `tenant_id` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `case_handlers`
--

CREATE TABLE `case_handlers` (
  `id` int UNSIGNED NOT NULL,
  `user_id` bigint UNSIGNED NOT NULL,
  `tenant_id` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `categories`
--

CREATE TABLE `categories` (
  `id` int UNSIGNED NOT NULL,
  `name` varchar(160) COLLATE utf8mb4_unicode_ci NOT NULL,
  `is_active` tinyint(1) NOT NULL DEFAULT '0',
  `tenant_id` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `charges`
--

CREATE TABLE `charges` (
  `id` int UNSIGNED NOT NULL,
  `charge_type` int NOT NULL,
  `charge_category_id` int UNSIGNED NOT NULL,
  `code` varchar(160) COLLATE utf8mb4_unicode_ci NOT NULL,
  `standard_charge` double NOT NULL,
  `description` text COLLATE utf8mb4_unicode_ci,
  `tenant_id` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `charge_categories`
--

CREATE TABLE `charge_categories` (
  `id` int UNSIGNED NOT NULL,
  `name` varchar(160) COLLATE utf8mb4_unicode_ci NOT NULL,
  `description` text COLLATE utf8mb4_unicode_ci,
  `charge_type` int NOT NULL,
  `tenant_id` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `currency_settings`
--

CREATE TABLE `currency_settings` (
  `id` bigint UNSIGNED NOT NULL,
  `currency_name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `currency_code` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `currency_icon` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `tenant_id` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `custom_fields`
--

CREATE TABLE `custom_fields` (
  `id` bigint UNSIGNED NOT NULL,
  `module_name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `field_type` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `field_name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `is_required` tinyint(1) NOT NULL,
  `values` text COLLATE utf8mb4_unicode_ci,
  `grid` int NOT NULL DEFAULT '12',
  `tenant_id` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `death_reports`
--

CREATE TABLE `death_reports` (
  `id` int UNSIGNED NOT NULL,
  `patient_id` int UNSIGNED NOT NULL,
  `case_id` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `doctor_id` bigint UNSIGNED NOT NULL,
  `date` datetime NOT NULL,
  `description` text COLLATE utf8mb4_unicode_ci,
  `tenant_id` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `departments`
--

CREATE TABLE `departments` (
  `id` bigint UNSIGNED NOT NULL,
  `name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `is_active` tinyint(1) NOT NULL DEFAULT '0',
  `guard_name` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Dumping data for table `departments`
--

INSERT INTO `departments` (`id`, `name`, `is_active`, `guard_name`, `created_at`, `updated_at`) VALUES
(1, 'Admin', 1, 'web', '2025-06-21 00:42:22', '2025-06-21 00:42:22'),
(2, 'Doctor', 1, 'web', '2025-06-21 00:42:22', '2025-06-21 00:42:22'),
(3, 'Patient', 1, 'web', '2025-06-21 00:42:22', '2025-06-21 00:42:22'),
(4, 'Nurse', 1, 'web', '2025-06-21 00:42:22', '2025-06-21 00:42:22'),
(5, 'Receptionist', 1, 'web', '2025-06-21 00:42:22', '2025-06-21 00:42:22'),
(6, 'Pharmacist', 1, 'web', '2025-06-21 00:42:22', '2025-06-21 00:42:22'),
(7, 'Accountant', 1, 'web', '2025-06-21 00:42:22', '2025-06-21 00:42:22'),
(8, 'Case Manager', 1, 'web', '2025-06-21 00:42:22', '2025-06-21 00:42:22'),
(9, 'Lab Technician', 1, 'web', '2025-06-21 00:42:22', '2025-06-21 00:42:22'),
(10, 'Super Admin', 1, 'web', '2025-06-21 00:42:22', '2025-06-21 00:42:22');

-- --------------------------------------------------------

--
-- Table structure for table `diagnosis_categories`
--

CREATE TABLE `diagnosis_categories` (
  `id` bigint UNSIGNED NOT NULL,
  `name` varchar(160) COLLATE utf8mb4_unicode_ci NOT NULL,
  `description` text COLLATE utf8mb4_unicode_ci,
  `tenant_id` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `doctors`
--

CREATE TABLE `doctors` (
  `id` bigint UNSIGNED NOT NULL,
  `user_id` bigint UNSIGNED NOT NULL,
  `doctor_department_id` bigint UNSIGNED NOT NULL,
  `specialist` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `description` text COLLATE utf8mb4_unicode_ci,
  `appointment_charge` double NOT NULL,
  `google_json_file_path` longtext COLLATE utf8mb4_unicode_ci,
  `tenant_id` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `doctor_departments`
--

CREATE TABLE `doctor_departments` (
  `id` bigint UNSIGNED NOT NULL,
  `title` varchar(160) COLLATE utf8mb4_unicode_ci NOT NULL,
  `description` text COLLATE utf8mb4_unicode_ci,
  `tenant_id` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `doctor_holidays`
--

CREATE TABLE `doctor_holidays` (
  `id` bigint UNSIGNED NOT NULL,
  `name` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `doctor_id` bigint UNSIGNED NOT NULL,
  `date` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `tenant_id` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `doctor_opd_charges`
--

CREATE TABLE `doctor_opd_charges` (
  `id` bigint UNSIGNED NOT NULL,
  `doctor_id` bigint UNSIGNED NOT NULL,
  `standard_charge` double NOT NULL,
  `tenant_id` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `documents`
--

CREATE TABLE `documents` (
  `id` int UNSIGNED NOT NULL,
  `title` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `document_type_id` int NOT NULL,
  `patient_id` int NOT NULL,
  `uploaded_by` bigint UNSIGNED NOT NULL,
  `notes` text COLLATE utf8mb4_unicode_ci,
  `tenant_id` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `document_types`
--

CREATE TABLE `document_types` (
  `id` int UNSIGNED NOT NULL,
  `name` varchar(160) COLLATE utf8mb4_unicode_ci NOT NULL,
  `tenant_id` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `domains`
--

CREATE TABLE `domains` (
  `id` int UNSIGNED NOT NULL,
  `domain` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `tenant_id` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `employee_payrolls`
--

CREATE TABLE `employee_payrolls` (
  `id` int UNSIGNED NOT NULL,
  `sr_no` bigint NOT NULL,
  `payroll_id` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `type` int NOT NULL,
  `owner_id` int NOT NULL,
  `owner_type` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `month` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `year` int NOT NULL,
  `net_salary` double NOT NULL,
  `status` int NOT NULL,
  `basic_salary` double NOT NULL,
  `allowance` double NOT NULL,
  `deductions` double NOT NULL,
  `tenant_id` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `enquiries`
--

CREATE TABLE `enquiries` (
  `id` int UNSIGNED NOT NULL,
  `full_name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `email` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `contact_no` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `type` tinyint DEFAULT NULL,
  `message` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `viewed_by` bigint UNSIGNED DEFAULT NULL,
  `status` tinyint(1) NOT NULL DEFAULT '0',
  `tenant_id` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `event_google_calendars`
--

CREATE TABLE `event_google_calendars` (
  `id` bigint UNSIGNED NOT NULL,
  `user_id` bigint UNSIGNED NOT NULL,
  `google_calendar_list_id` bigint UNSIGNED NOT NULL,
  `google_calendar_id` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `expenses`
--

CREATE TABLE `expenses` (
  `id` bigint UNSIGNED NOT NULL,
  `expense_head` int NOT NULL,
  `name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `invoice_number` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `date` datetime NOT NULL,
  `amount` double NOT NULL,
  `description` text COLLATE utf8mb4_unicode_ci,
  `tenant_id` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `exports`
--

CREATE TABLE `exports` (
  `id` bigint UNSIGNED NOT NULL,
  `completed_at` timestamp NULL DEFAULT NULL,
  `file_disk` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `file_name` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `exporter` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `processed_rows` int UNSIGNED NOT NULL DEFAULT '0',
  `total_rows` int UNSIGNED NOT NULL,
  `successful_rows` int UNSIGNED NOT NULL DEFAULT '0',
  `user_id` bigint UNSIGNED NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `failed_jobs`
--

CREATE TABLE `failed_jobs` (
  `id` bigint UNSIGNED NOT NULL,
  `uuid` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `connection` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `queue` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `payload` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `exception` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `failed_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `faqs`
--

CREATE TABLE `faqs` (
  `id` bigint UNSIGNED NOT NULL,
  `question` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `answer` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Dumping data for table `faqs`
--

INSERT INTO `faqs` (`id`, `question`, `answer`, `created_at`, `updated_at`) VALUES
(1, 'Is My Electronic Health Record Kept Private?', 'Health records are kept totally private and we employ robust encryption methods to protect your personal information. You determine who can see the information in your record.', '2025-06-21 00:42:23', '2025-06-21 00:42:23'),
(2, 'Can Doctor 24x7 Handle My Emergency Situations?', 'Doctor 24×7 is designed to handle non-emergent medical problems. You should NOT use it if you are experiencing a medical emergency.', '2025-06-21 00:42:23', '2025-06-21 00:42:23'),
(3, 'Can I Call Doctor 24x7 Outside Of India?', 'Doctor 24×7 consults are unavailable outside of India. However, if you are travelling outside India, you can use our service from a mobile phone using a SIM card issued in India.', '2025-06-21 00:42:23', '2025-06-21 00:42:23'),
(4, 'Is my electronic health record kept private?', 'Health records are kept totally private and we employ robust encryption methods to protect your personal information. You determine who can see the information in your record.', '2025-06-21 00:42:23', '2025-06-21 00:42:23'),
(5, 'How much does a consult cost?', 'The cost of a Doctor consult varies, depending on your choice of consulting the 1st available Doctor OR requesting a call back from a specific Doctor.', '2025-06-21 00:42:23', '2025-06-21 00:42:23'),
(6, 'Do I Talk to \"real doctors\"?', 'Yes. Doctor 24×7 subscribers only talk to reputed Doctors/Experts attached with top hospitals/private practice who are Licensed practitioners. Each Doctor/Expert on our network is qualified.', '2025-06-21 00:42:23', '2025-06-21 00:42:23');

-- --------------------------------------------------------

--
-- Table structure for table `features`
--

CREATE TABLE `features` (
  `id` bigint UNSIGNED NOT NULL,
  `name` varchar(160) COLLATE utf8mb4_unicode_ci NOT NULL,
  `submenu` int DEFAULT '0',
  `route` longtext COLLATE utf8mb4_unicode_ci,
  `has_parent` int DEFAULT '0',
  `is_default` int DEFAULT '0',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Dumping data for table `features`
--

INSERT INTO `features` (`id`, `name`, `submenu`, `route`, `has_parent`, `is_default`, `created_at`, `updated_at`) VALUES
(1, 'Appointments', 0, '{\"route_name\":[\"appointments.index\",\"appointments.create\",\"appointments.store\",\"appointments.edit\",\"appointments.update\",\"doctors.list\",\"doctor-schedule-list\",\"get.booking.slot\",\"patient.appointment.update\",\"appointments.show\",\"appointments.destroy\",\"appointments.excel\",\"appointment.status\"]}', 0, 0, '2025-06-21 00:42:23', '2025-06-21 00:42:23'),
(2, 'Appointment Calendar', 0, '{\"route_name\":[\"appointment-calendars.index\",\"calendar-list\",\"appointment.details\"]}', 1, 0, '2025-06-21 00:42:23', '2025-06-21 00:42:23'),
(3, 'Blood Banks', 4, '{\"route_name\":[\"blood-banks.index\",\"blood-banks.create\",\"blood-banks.store\",\"blood-banks.edit\",\"blood-banks.update\",\"blood-banks.destroy\",\"blood.banks.excel\"]}', 0, 0, '2025-06-21 00:42:23', '2025-06-21 00:42:23'),
(4, 'Blood Donors', 0, '{\"route_name\":[\"blood-donors.index\",\"blood-donors.create\",\"blood-donors.store\",\"blood-donors.edit\",\"blood-donors.update\",\"blood-donors.destroy\",\"blood.donors.excel\"]}', 3, 0, '2025-06-21 00:42:23', '2025-06-21 00:42:23'),
(5, 'Blood Donations', 0, '{\"route_name\":[\"blood-donations.index\",\"blood-donations.create\",\"blood-donations.store\",\"blood-donations.edit\",\"blood-donations.update\",\"blood-donations.destroy\",\"blood.donations.excel\"]}', 3, 0, '2025-06-21 00:42:23', '2025-06-21 00:42:23'),
(6, 'Blood Issues', 0, '{\"route_name\":[\"blood-issues.index\",\"blood-issues.create\",\"blood-issues.store\",\"blood-issues.edit\",\"blood-issues.update\",\"blood-issues.destroy\",\"blood-issues.list\",\"blood.issues.excel\"]}', 3, 0, '2025-06-21 00:42:23', '2025-06-21 00:42:23'),
(7, 'Documents', 2, '{\"route_name\":[\"documents.index\",\"documents.create\",\"documents.store\",\"documents.edit\",\"documents.update\",\"documents.destroy\",\"document.download\"]}', 0, 0, '2025-06-21 00:42:23', '2025-06-21 00:42:23'),
(8, 'Document Types', 0, '{\"route_name\":[\"document-types.index\",\"document-types.create\",\"document-types.store\",\"document-types.edit\",\"document-types.show\",\"document-types.update\",\"document-types.destroy\"]}', 7, 0, '2025-06-21 00:42:23', '2025-06-21 00:42:23'),
(9, 'Live Consultations', 2, '{\"route_name\":[\"live.consultation.index\",\"live.consultation.create\",\"live.consultation.store\",\"live.consultation.edit\",\"live.consultation.show\",\"live.consultation.update\",\"live.consultation.destroy\",\"live.consultation.list\",\"live.consultation.change.status\",\"live.consultation.get.live.status\",\"zoom.credential\",\"zoom.credential.create\"]}', 0, 0, '2025-06-21 00:42:23', '2025-06-21 00:42:23'),
(10, 'Live Meetings', 0, '{\"route_name\":[\"live.meeting.index\",\"live.meeting.store\",\"live.meeting.change.status\",\"live.meeting.get.live.status\",\"live.meeting.show\",\"live.meeting.edit\",\"live.meeting.update\",\"live.meeting.destroy\"]}', 9, 0, '2025-06-21 00:42:23', '2025-06-21 00:42:23'),
(11, 'Inventory', 4, '{\"route_name\":[\"item-categories.index\",\"item-categories.store\",\"item-categories.edit\",\"item-categories.update\",\"item-categories.destroy\"]}', 0, 0, '2025-06-21 00:42:23', '2025-06-21 00:42:23'),
(12, 'Items', 0, '{\"route_name\":[\"items.index\",\"items.create\",\"items.store\",\"items.edit\",\"items.show\",\"items.update\",\"items.destroy\"]}', 11, 0, '2025-06-21 00:42:23', '2025-06-21 00:42:23'),
(13, 'Item Stocks', 0, '{\"route_name\":[\"item.stock.index\",\"item.stock.create\",\"item.stock.store\",\"item.stock.edit\",\"item.stock.show\",\"item.stock.update\",\"item.stock.destroy\",\"item.stock.download\",\"items.list\"]}', 11, 0, '2025-06-21 00:42:23', '2025-06-21 00:42:23'),
(14, 'Issued Items', 0, '{\"route_name\":[\"issued.item.index\",\"issued.item.create\",\"users.list\",\"item.available.qty\",\"return.issued.item\",\"issued.item.store\",\"issued.item.show\",\"issued.item.destroy\"]}', 11, 0, '2025-06-21 00:42:23', '2025-06-21 00:42:23'),
(15, 'Vaccinations', 2, '{\"route_name\":[\"vaccinated-patients.index\",\"vaccinated-patients.create\",\"vaccinated-patients.store\",\"vaccinated-patients.edit\",\"vaccinated-patients.show\",\"vaccinated-patients.update\",\"vaccinated-patients.destroy\",\"vaccinated-patients.excel\"]}', 0, 0, '2025-06-21 00:42:23', '2025-06-21 00:42:23'),
(16, 'Vaccination', 0, '{\"route_name\":[\"vaccinations.index\",\"vaccinations.create\",\"vaccinations.store\",\"vaccinations.edit\",\"vaccinations.show\",\"vaccinations.update\",\"vaccinations.destroy\",\"vaccinations.excel\"]}', 15, 0, '2025-06-21 00:42:23', '2025-06-21 00:42:23'),
(17, 'SMS / Mail', 2, '{\"route_name\":[\"sms.index\",\"sms.store\",\"sms.show\",\"sms.show.modal\",\"sms.destroy\",\"sms.users.lists\"]}', 0, 0, '2025-06-21 00:42:23', '2025-06-21 00:42:23'),
(18, 'Mail', 0, '{\"route_name\":[\"mail\",\"mail.send\"]}', 17, 0, '2025-06-21 00:42:23', '2025-06-21 00:42:23'),
(19, 'Radiology', 2, '{\"route_name\":[\"radiology.category.index\",\"radiology.category.create\",\"radiology.category.store\",\"radiology.category.edit\",\"radiology.category.update\",\"radiology.category.destroy\"]}', 0, 0, '2025-06-21 00:42:23', '2025-06-21 00:42:23'),
(20, 'Radiology Tests', 0, '{\"route_name\":[\"radiology.test.index\",\"radiology.test.create\",\"radiology.test.store\",\"radiology.test.edit\",\"radiology.test.show\",\"radiology.test.show.modal\",\"radiology.test.update\",\"radiology.test.destroy\",\"radiology.test.standard.charge\",\"radiology.tests.excel\"]}', 19, 0, '2025-06-21 00:42:23', '2025-06-21 00:42:23'),
(21, 'Reports', 4, '{\"route_name\":[\"birth-reports.index\",\"birth-reports.create\",\"birth-reports.store\",\"birth-reports.edit\",\"birth-reports.show\",\"birth-reports.update\",\"birth-reports.destroy\"]}', 0, 0, '2025-06-21 00:42:23', '2025-06-21 00:42:23'),
(22, 'Death Reports', 0, '{\"route_name\":[\"death-reports.index\",\"death-reports.create\",\"death-reports.store\",\"death-reports.edit\",\"death-reports.show\",\"death-reports.update\",\"death-reports.destroy\"]}', 21, 0, '2025-06-21 00:42:23', '2025-06-21 00:42:23'),
(23, 'Investigation Reports', 0, '{\"route_name\":[\"investigation-reports.index\",\"investigation-reports.create\",\"investigation-reports.store\",\"investigation-reports.edit\",\"investigation-reports.show\",\"investigation-reports.update\",\"investigation-reports.destroy\",\"investigation.reports.download\"]}', 21, 0, '2025-06-21 00:42:23', '2025-06-21 00:42:23'),
(24, 'Operation Reports', 0, '{\"route_name\":[\"operation-reports.index\",\"operation-reports.create\",\"operation-reports.store\",\"operation-reports.edit\",\"operation-reports.show\",\"operation-reports.update\",\"operation-reports.destroy\"]}', 21, 0, '2025-06-21 00:42:23', '2025-06-21 00:42:23'),
(25, 'Pathology', 2, '{\"route_name\":[\"pathology.category.index\",\"pathology.category.create\",\"pathology.category.store\",\"pathology.category.edit\",\"pathology.category.show\",\"pathology.category.update\",\"pathology.category.destroy\"]}', 0, 0, '2025-06-21 00:42:23', '2025-06-21 00:42:23'),
(26, 'Pathology Tests', 0, '{\"route_name\":[\"pathology.test.index\",\"pathology.test.create\",\"pathology.test.store\",\"pathology.test.edit\",\"pathology.test.show\",\"pathology.test.show.modal\",\"pathology.test.update\",\"pathology.test.destroy\",\"pathology.test.standard.charge\",\"pathology.tests.excel\"]}', 25, 0, '2025-06-21 00:42:23', '2025-06-21 00:42:23');

-- --------------------------------------------------------

--
-- Table structure for table `feature_subscriptionplan`
--

CREATE TABLE `feature_subscriptionplan` (
  `id` bigint UNSIGNED NOT NULL,
  `feature_id` bigint UNSIGNED NOT NULL,
  `subscription_plan_id` bigint UNSIGNED DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Dumping data for table `feature_subscriptionplan`
--

INSERT INTO `feature_subscriptionplan` (`id`, `feature_id`, `subscription_plan_id`, `created_at`, `updated_at`) VALUES
(1, 1, 1, '2025-06-21 00:42:23', '2025-06-21 00:42:23'),
(2, 3, 1, '2025-06-21 00:42:23', '2025-06-21 00:42:23'),
(3, 7, 1, '2025-06-21 00:42:23', '2025-06-21 00:42:23'),
(4, 9, 1, '2025-06-21 00:42:23', '2025-06-21 00:42:23'),
(5, 11, 1, '2025-06-21 00:42:23', '2025-06-21 00:42:23'),
(6, 15, 1, '2025-06-21 00:42:23', '2025-06-21 00:42:23'),
(7, 17, 1, '2025-06-21 00:42:23', '2025-06-21 00:42:23'),
(8, 19, 1, '2025-06-21 00:42:23', '2025-06-21 00:42:23'),
(9, 21, 1, '2025-06-21 00:42:23', '2025-06-21 00:42:23'),
(10, 25, 1, '2025-06-21 00:42:23', '2025-06-21 00:42:23');

-- --------------------------------------------------------

--
-- Table structure for table `front_services`
--

CREATE TABLE `front_services` (
  `id` bigint UNSIGNED NOT NULL,
  `name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `short_description` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `tenant_id` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Dumping data for table `front_services`
--

INSERT INTO `front_services` (`id`, `name`, `short_description`, `tenant_id`, `created_at`, `updated_at`) VALUES
(1, 'Cardiology', 'image Cardiology Proin gravida nibh vel velit auctor aliquet. Aenean sollicitudin, lorem quis bibendum auctor.', NULL, '2025-06-21 00:42:23', '2025-06-21 00:42:23'),
(2, 'Orthopedics', 'image Cardiology Proin gravida nibh vel velit auctor aliquet. Aenean sollicitudin, lorem quis bibendum auctor.', NULL, '2025-06-21 00:42:23', '2025-06-21 00:42:23'),
(3, 'Pulmonology', 'image Cardiology Proin gravida nibh vel velit auctor aliquet. Aenean sollicitudin, lorem quis bibendum auctor.', NULL, '2025-06-21 00:42:23', '2025-06-21 00:42:23'),
(4, 'Dental Care', 'image Cardiology Proin gravida nibh vel velit auctor aliquet. Aenean sollicitudin, lorem quis bibendum auctor.', NULL, '2025-06-21 00:42:23', '2025-06-21 00:42:23'),
(5, 'Medicine', 'image Cardiology Proin gravida nibh vel velit auctor aliquet. Aenean sollicitudin, lorem quis bibendum auctor.', NULL, '2025-06-21 00:42:23', '2025-06-21 00:42:23'),
(6, 'Ambulance', 'image Cardiology Proin gravida nibh vel velit auctor aliquet. Aenean sollicitudin, lorem quis bibendum auctor.', NULL, '2025-06-21 00:42:23', '2025-06-21 00:42:23'),
(7, 'Ophthalmology', 'image Cardiology Proin gravida nibh vel velit auctor aliquet. Aenean sollicitudin, lorem quis bibendum auctor.', NULL, '2025-06-21 00:42:23', '2025-06-21 00:42:23'),
(8, 'Neurology', 'image Cardiology Proin gravida nibh vel velit auctor aliquet. Aenean sollicitudin, lorem quis bibendum auctor.', NULL, '2025-06-21 00:42:23', '2025-06-21 00:42:23');

-- --------------------------------------------------------

--
-- Table structure for table `front_settings`
--

CREATE TABLE `front_settings` (
  `id` bigint UNSIGNED NOT NULL,
  `key` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `value` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `type` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `tenant_id` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Dumping data for table `front_settings`
--

INSERT INTO `front_settings` (`id`, `key`, `value`, `type`, `tenant_id`, `created_at`, `updated_at`) VALUES
(1, 'about_us_title', 'About For HMS', '1', NULL, '2025-06-21 00:42:23', '2025-06-21 00:42:23'),
(2, 'about_us_description', 'HMS will teach physicians and nurses from around the world the principles of blood management, as well as how to manage their own blood conservation programs. The hospital was chosen based on the reputation its bloodless program has established in the medical community and because of its nationally recognized results.\n\nWe are a group of creative nerds making awesome stuff for Web and Mobile. We just love to contribute to open source technologies. We always try to build something which helps developers to save their time. so they can spend a bit more time with their friends And family.', '1', NULL, '2025-06-21 00:42:23', '2025-06-21 00:42:23'),
(3, 'about_us_mission', 'We are providing advanced emergency services. We have well-equipped emergency and trauma center with facilities.', '1', NULL, '2025-06-21 00:42:23', '2025-06-21 00:42:23'),
(4, 'about_us_image', 'front-assets/img/default_image.jpg', '1', NULL, '2025-06-21 00:42:23', '2025-06-21 00:42:23'),
(5, 'home_page_experience', '10', '2', NULL, '2025-06-21 00:42:23', '2025-06-21 00:42:23'),
(6, 'home_page_title', 'Find Local Specialists Best Services', '2', NULL, '2025-06-21 00:42:23', '2025-06-21 00:42:23'),
(7, 'home_page_description', 'Our medical clinic provides quality care for the entire family while maintaining a personable atmosphere best services.', '2', NULL, '2025-06-21 00:42:23', '2025-06-21 00:42:23'),
(8, 'home_page_image', 'web_front/images/doctors/doctor.png', '2', NULL, '2025-06-21 00:42:23', '2025-06-21 00:42:23'),
(9, 'terms_conditions', 'terms_conditions', '2', NULL, '2025-06-21 00:42:23', '2025-06-21 00:42:23'),
(10, 'privacy_policy', 'privacy_policy', '2', NULL, '2025-06-21 00:42:23', '2025-06-21 00:42:23'),
(11, 'home_page_certified_doctor_image', 'web_front/images/healthcare-doctor/doctor-1.png', '2', NULL, '2025-06-21 00:42:23', '2025-06-21 00:42:23'),
(12, 'home_page_certified_doctor_text', 'Quality Healthcare', '2', NULL, '2025-06-21 00:42:23', '2025-06-21 00:42:23'),
(13, 'home_page_certified_doctor_title', 'Have Certified and High Quality Doctor For You', '2', NULL, '2025-06-21 00:42:23', '2025-06-21 00:42:23'),
(14, 'home_page_certified_doctor_description', 'Our medical clinic provides quality care for the entire family while maintaining a personable atmosphere best services. Our medical clinic provides quality. Our medical clinic provides quality care for the entire family while maintaining lizam a personable atmosphere best services. Our medical clinic provides.', '2', NULL, '2025-06-21 00:42:23', '2025-06-21 00:42:23'),
(15, 'home_page_box_title', 'Free Consulting', '2', NULL, '2025-06-21 00:42:23', '2025-06-21 00:42:23'),
(16, 'home_page_box_description', 'Proin gravida nibh vel velit auctor aliquet.', '2', NULL, '2025-06-21 00:42:23', '2025-06-21 00:42:23'),
(17, 'home_page_step_1_title', 'Check Doctor Profile', '2', NULL, '2025-06-21 00:42:23', '2025-06-21 00:42:23'),
(18, 'home_page_step_1_description', 'Proin gravida nibh vel velit auctor aliquet. Aenean sollicitudin lorem quis bibendum auctor nisi elit.', '2', NULL, '2025-06-21 00:42:23', '2025-06-21 00:42:23'),
(19, 'home_page_step_2_title', 'Request Consulting', '2', NULL, '2025-06-21 00:42:23', '2025-06-21 00:42:23'),
(20, 'home_page_step_2_description', 'Proin gravida nibh vel velit auctor aliquet. Aenean sollicitudin lorem quis bibendum auctor nisi elit.', '2', NULL, '2025-06-21 00:42:23', '2025-06-21 00:42:23'),
(21, 'home_page_step_3_title', 'Receive Consulting', '2', NULL, '2025-06-21 00:42:23', '2025-06-21 00:42:23'),
(22, 'home_page_step_3_description', 'Proin gravida nibh vel velit auctor aliquet. Aenean sollicitudin lorem quis bibendum auctor nisi elit.', '2', NULL, '2025-06-21 00:42:23', '2025-06-21 00:42:23'),
(23, 'home_page_step_4_title', 'Get Your Solution', '2', NULL, '2025-06-21 00:42:23', '2025-06-21 00:42:23'),
(24, 'home_page_step_4_description', 'Proin gravida nibh vel velit auctor aliquet. Aenean sollicitudin lorem quis bibendum auctor nisi elit.', '2', NULL, '2025-06-21 00:42:23', '2025-06-21 00:42:23'),
(25, 'home_page_certified_box_title', 'Certified Doctor', '2', NULL, '2025-06-21 00:42:23', '2025-06-21 00:42:23'),
(26, 'home_page_certified_box_description', 'Proin gravida nibh vel velit auctor aliquet.', '2', NULL, '2025-06-21 00:42:23', '2025-06-21 00:42:23'),
(27, 'appointment_title', 'Contact Now and Get the Best Doctor Service Today', '3', NULL, '2025-06-21 00:42:23', '2025-06-21 00:42:23'),
(28, 'appointment_description', 'Proin gravida nibh vel velit auctor aliquet. Aenean sollicitudin lorem quis bibendum auctor nisi elit consequat ipsum nec sagittis.', '3', NULL, '2025-06-21 00:42:23', '2025-06-21 00:42:23');

-- --------------------------------------------------------

--
-- Table structure for table `google_calendar_integrations`
--

CREATE TABLE `google_calendar_integrations` (
  `id` bigint UNSIGNED NOT NULL,
  `user_id` bigint UNSIGNED NOT NULL,
  `access_token` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `meta` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `last_used_at` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `google_calendar_lists`
--

CREATE TABLE `google_calendar_lists` (
  `id` bigint UNSIGNED NOT NULL,
  `user_id` bigint UNSIGNED NOT NULL,
  `calendar_name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `google_calendar_id` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `meta` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `hospital_schedules`
--

CREATE TABLE `hospital_schedules` (
  `id` bigint UNSIGNED NOT NULL,
  `day_of_week` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `start_time` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `end_time` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `tenant_id` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `hospital_type`
--

CREATE TABLE `hospital_type` (
  `id` bigint UNSIGNED NOT NULL,
  `name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `incomes`
--

CREATE TABLE `incomes` (
  `id` bigint UNSIGNED NOT NULL,
  `income_head` int NOT NULL,
  `name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `invoice_number` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `date` datetime NOT NULL,
  `amount` double NOT NULL,
  `description` text COLLATE utf8mb4_unicode_ci,
  `tenant_id` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `insurances`
--

CREATE TABLE `insurances` (
  `id` int UNSIGNED NOT NULL,
  `name` varchar(160) COLLATE utf8mb4_unicode_ci NOT NULL,
  `service_tax` double NOT NULL,
  `discount` double DEFAULT NULL,
  `remark` text COLLATE utf8mb4_unicode_ci,
  `insurance_no` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `insurance_code` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `hospital_rate` double NOT NULL,
  `total` double NOT NULL,
  `status` tinyint(1) NOT NULL,
  `tenant_id` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `insurance_diseases`
--

CREATE TABLE `insurance_diseases` (
  `id` bigint UNSIGNED NOT NULL,
  `insurance_id` int UNSIGNED NOT NULL,
  `disease_name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `disease_charge` double NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `investigation_reports`
--

CREATE TABLE `investigation_reports` (
  `id` int UNSIGNED NOT NULL,
  `patient_id` int UNSIGNED NOT NULL,
  `date` datetime NOT NULL,
  `title` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `description` text COLLATE utf8mb4_unicode_ci,
  `doctor_id` bigint UNSIGNED NOT NULL,
  `status` int NOT NULL,
  `tenant_id` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `invoices`
--

CREATE TABLE `invoices` (
  `id` int UNSIGNED NOT NULL,
  `invoice_id` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `patient_id` int UNSIGNED NOT NULL,
  `invoice_date` date NOT NULL,
  `amount` double NOT NULL DEFAULT '0',
  `discount` double NOT NULL DEFAULT '0',
  `status` tinyint(1) NOT NULL DEFAULT '0',
  `tenant_id` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `invoice_items`
--

CREATE TABLE `invoice_items` (
  `id` int UNSIGNED NOT NULL,
  `account_id` int UNSIGNED NOT NULL,
  `invoice_id` int UNSIGNED NOT NULL,
  `description` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `quantity` int NOT NULL,
  `price` double NOT NULL,
  `total` double NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `ipd_bills`
--

CREATE TABLE `ipd_bills` (
  `id` bigint UNSIGNED NOT NULL,
  `ipd_patient_department_id` int UNSIGNED NOT NULL,
  `total_charges` double NOT NULL,
  `total_payments` double NOT NULL,
  `gross_total` double NOT NULL,
  `discount_in_percentage` int NOT NULL,
  `tax_in_percentage` int NOT NULL,
  `other_charges` double NOT NULL,
  `net_payable_amount` double NOT NULL,
  `tenant_id` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `ipd_charges`
--

CREATE TABLE `ipd_charges` (
  `id` int UNSIGNED NOT NULL,
  `ipd_patient_department_id` int UNSIGNED NOT NULL,
  `date` date NOT NULL,
  `charge_type_id` int NOT NULL,
  `charge_category_id` int UNSIGNED NOT NULL,
  `charge_id` int UNSIGNED NOT NULL,
  `standard_charge` double DEFAULT NULL,
  `applied_charge` double NOT NULL,
  `tenant_id` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `ipd_consultant_registers`
--

CREATE TABLE `ipd_consultant_registers` (
  `id` int UNSIGNED NOT NULL,
  `ipd_patient_department_id` int UNSIGNED NOT NULL,
  `applied_date` datetime NOT NULL,
  `doctor_id` bigint UNSIGNED NOT NULL,
  `instruction` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `instruction_date` date NOT NULL,
  `tenant_id` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `ipd_diagnoses`
--

CREATE TABLE `ipd_diagnoses` (
  `id` int UNSIGNED NOT NULL,
  `ipd_patient_department_id` int UNSIGNED NOT NULL,
  `report_type` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `report_date` datetime NOT NULL,
  `description` text COLLATE utf8mb4_unicode_ci,
  `tenant_id` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `ipd_patient_departments`
--

CREATE TABLE `ipd_patient_departments` (
  `id` int UNSIGNED NOT NULL,
  `patient_id` int UNSIGNED NOT NULL,
  `ipd_number` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `height` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `weight` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `bp` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `symptoms` text COLLATE utf8mb4_unicode_ci,
  `notes` text COLLATE utf8mb4_unicode_ci,
  `admission_date` datetime NOT NULL,
  `is_discharge` tinyint(1) DEFAULT '0',
  `case_id` int UNSIGNED NOT NULL,
  `is_old_patient` tinyint(1) DEFAULT '0',
  `doctor_id` bigint UNSIGNED DEFAULT NULL,
  `bed_type_id` int UNSIGNED DEFAULT NULL,
  `bed_id` int UNSIGNED NOT NULL,
  `custom_field` longtext COLLATE utf8mb4_unicode_ci,
  `tenant_id` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `bill_status` tinyint(1) NOT NULL DEFAULT '0'
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `ipd_payments`
--

CREATE TABLE `ipd_payments` (
  `id` int UNSIGNED NOT NULL,
  `ipd_patient_department_id` int UNSIGNED NOT NULL,
  `amount` double NOT NULL,
  `date` date NOT NULL,
  `payment_mode` tinyint NOT NULL,
  `notes` text COLLATE utf8mb4_unicode_ci,
  `transaction_id` int DEFAULT NULL,
  `tenant_id` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `ipd_prescriptions`
--

CREATE TABLE `ipd_prescriptions` (
  `id` int UNSIGNED NOT NULL,
  `ipd_patient_department_id` int UNSIGNED NOT NULL,
  `header_note` text COLLATE utf8mb4_unicode_ci,
  `footer_note` text COLLATE utf8mb4_unicode_ci,
  `tenant_id` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `ipd_prescription_items`
--

CREATE TABLE `ipd_prescription_items` (
  `id` int UNSIGNED NOT NULL,
  `ipd_prescription_id` int UNSIGNED NOT NULL,
  `category_id` int UNSIGNED NOT NULL,
  `medicine_id` int UNSIGNED NOT NULL,
  `dosage` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `dose_interval` int NOT NULL,
  `day` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `time` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `instruction` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `tenant_id` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `ipd_timelines`
--

CREATE TABLE `ipd_timelines` (
  `id` int UNSIGNED NOT NULL,
  `ipd_patient_department_id` int UNSIGNED NOT NULL,
  `title` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `date` date NOT NULL,
  `description` text COLLATE utf8mb4_unicode_ci,
  `visible_to_person` tinyint(1) NOT NULL DEFAULT '1',
  `tenant_id` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `issued_items`
--

CREATE TABLE `issued_items` (
  `id` int UNSIGNED NOT NULL,
  `department_id` bigint UNSIGNED NOT NULL,
  `user_id` bigint UNSIGNED NOT NULL,
  `issued_by` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `issued_date` date NOT NULL,
  `return_date` date DEFAULT NULL,
  `item_category_id` int UNSIGNED NOT NULL,
  `item_id` int UNSIGNED NOT NULL,
  `quantity` int NOT NULL,
  `description` text COLLATE utf8mb4_unicode_ci,
  `status` tinyint(1) DEFAULT '0',
  `tenant_id` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `items`
--

CREATE TABLE `items` (
  `id` int UNSIGNED NOT NULL,
  `name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `item_category_id` int UNSIGNED NOT NULL,
  `unit` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `description` text COLLATE utf8mb4_unicode_ci,
  `available_quantity` int NOT NULL DEFAULT '0',
  `tenant_id` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `item_categories`
--

CREATE TABLE `item_categories` (
  `id` int UNSIGNED NOT NULL,
  `name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `tenant_id` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `item_stocks`
--

CREATE TABLE `item_stocks` (
  `id` int UNSIGNED NOT NULL,
  `item_category_id` int UNSIGNED NOT NULL,
  `item_id` int UNSIGNED NOT NULL,
  `supplier_name` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `store_name` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `quantity` int NOT NULL,
  `purchase_price` double NOT NULL,
  `description` text COLLATE utf8mb4_unicode_ci,
  `tenant_id` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `jobs`
--

CREATE TABLE `jobs` (
  `id` bigint UNSIGNED NOT NULL,
  `queue` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `payload` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `attempts` tinyint UNSIGNED NOT NULL,
  `reserved_at` int UNSIGNED DEFAULT NULL,
  `available_at` int UNSIGNED NOT NULL,
  `created_at` int UNSIGNED NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `job_batches`
--

CREATE TABLE `job_batches` (
  `id` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `total_jobs` int NOT NULL,
  `pending_jobs` int NOT NULL,
  `failed_jobs` int NOT NULL,
  `failed_job_ids` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `options` mediumtext COLLATE utf8mb4_unicode_ci,
  `cancelled_at` int DEFAULT NULL,
  `created_at` int NOT NULL,
  `finished_at` int DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `lab_technicians`
--

CREATE TABLE `lab_technicians` (
  `id` bigint UNSIGNED NOT NULL,
  `user_id` bigint UNSIGNED NOT NULL,
  `tenant_id` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `landing_about_us`
--

CREATE TABLE `landing_about_us` (
  `id` bigint UNSIGNED NOT NULL,
  `text_main` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL,
  `card_img_one` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `card_img_two` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `card_img_three` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `main_img_one` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `main_img_two` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `card_one_text` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL,
  `card_two_text` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL,
  `card_three_text` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL,
  `card_one_text_secondary` varchar(135) COLLATE utf8mb4_unicode_ci NOT NULL,
  `card_two_text_secondary` varchar(135) COLLATE utf8mb4_unicode_ci NOT NULL,
  `card_three_text_secondary` varchar(135) COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Dumping data for table `landing_about_us`
--

INSERT INTO `landing_about_us` (`id`, `text_main`, `card_img_one`, `card_img_two`, `card_img_three`, `main_img_one`, `main_img_two`, `card_one_text`, `card_two_text`, `card_three_text`, `card_one_text_secondary`, `card_two_text_secondary`, `card_three_text_secondary`, `created_at`, `updated_at`) VALUES
(1, 'How It Work', 'http://e-hms-saas-filament.test/uploads/19/about_us.png', 'http://e-hms-saas-filament.test/uploads/20/check-circle-regular.svg', 'http://e-hms-saas-filament.test/uploads/21/credit-card-solid.svg', 'http://e-hms-saas-filament.test/uploads/22/12.png', 'http://e-hms-saas-filament.test/uploads/23/14.png', 'Research', 'HMS Customization', 'Cost Effective', 'HMS specialises in developing innovative, efficient and smart healthcare solutions.', 'We offer complete HMS customization solutions. We are staffed by eLearning experts and we know how to get the most from HMS.', 'HMS not only saves time in the hospital but also is cost-effective in decreasing the number of people working on the Paper work.', '2025-06-21 00:42:23', '2025-06-21 00:42:23');

-- --------------------------------------------------------

--
-- Table structure for table `live_consultations`
--

CREATE TABLE `live_consultations` (
  `id` bigint UNSIGNED NOT NULL,
  `doctor_id` bigint UNSIGNED NOT NULL,
  `patient_id` int UNSIGNED NOT NULL,
  `consultation_title` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `consultation_date` datetime NOT NULL,
  `host_video` tinyint(1) NOT NULL,
  `participant_video` tinyint(1) NOT NULL,
  `consultation_duration_minutes` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `type` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `type_number` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_by` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `status` int NOT NULL,
  `description` text COLLATE utf8mb4_unicode_ci,
  `meeting_id` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `meta` text COLLATE utf8mb4_unicode_ci,
  `time_zone` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `password` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `tenant_id` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `platform_type` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `live_meetings`
--

CREATE TABLE `live_meetings` (
  `id` bigint UNSIGNED NOT NULL,
  `consultation_title` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `consultation_date` datetime NOT NULL,
  `consultation_duration_minutes` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `host_video` tinyint(1) NOT NULL,
  `participant_video` tinyint(1) NOT NULL,
  `description` text COLLATE utf8mb4_unicode_ci,
  `created_by` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `meta` text COLLATE utf8mb4_unicode_ci,
  `meeting_id` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `time_zone` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `password` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `status` int NOT NULL,
  `tenant_id` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `live_meetings_candidates`
--

CREATE TABLE `live_meetings_candidates` (
  `id` bigint UNSIGNED NOT NULL,
  `user_id` bigint UNSIGNED NOT NULL,
  `live_meeting_id` bigint UNSIGNED NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `ltu_contributors`
--

CREATE TABLE `ltu_contributors` (
  `id` bigint UNSIGNED NOT NULL,
  `name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `email` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `password` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `avatar` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `role` tinyint DEFAULT NULL,
  `remember_token` varchar(100) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Dumping data for table `ltu_contributors`
--

INSERT INTO `ltu_contributors` (`id`, `name`, `email`, `password`, `avatar`, `role`, `remember_token`, `created_at`, `updated_at`) VALUES
(1, 'Super Admin', 'admin@hms.com', '$2y$12$lVSMWQMfPc.pgLMHpRi.XO9a5UmLYC49Fdlf8diibiHGErH83uOZm', NULL, 1, NULL, '2025-06-21 00:42:22', '2025-06-21 00:42:22');

-- --------------------------------------------------------

--
-- Table structure for table `ltu_invites`
--

CREATE TABLE `ltu_invites` (
  `id` bigint UNSIGNED NOT NULL,
  `email` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `token` varchar(32) COLLATE utf8mb4_unicode_ci NOT NULL,
  `role` tinyint NOT NULL DEFAULT '2',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `ltu_languages`
--

CREATE TABLE `ltu_languages` (
  `id` bigint UNSIGNED NOT NULL,
  `name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `code` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `rtl` tinyint(1) NOT NULL DEFAULT '0'
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Dumping data for table `ltu_languages`
--

INSERT INTO `ltu_languages` (`id`, `name`, `code`, `rtl`) VALUES
(1, 'Afrikaans', 'af', 0),
(2, 'Albanian', 'sq', 0),
(3, 'Amharic', 'am', 0),
(4, 'Arabic', 'ar', 1),
(5, 'Armenian', 'hy', 0),
(6, 'Assamese', 'as', 0),
(7, 'Aymara', 'ay', 0),
(8, 'Azerbaijani', 'az', 0),
(9, 'Bambara', 'bm', 0),
(10, 'Basque', 'eu', 0),
(11, 'Belarusian', 'be', 0),
(12, 'Bengali', 'bn', 0),
(13, 'Bhojpuri', 'bho', 0),
(14, 'Bosnian', 'bs', 0),
(15, 'Bulgarian', 'bg', 0),
(16, 'Catalan', 'ca', 0),
(17, 'Cebuano', 'ceb', 0),
(18, 'Chinese', 'zh', 0),
(19, 'Chinese (Traditional)', 'zh-TW', 0),
(20, 'Corsican', 'co', 0),
(21, 'Croatian', 'hr', 0),
(22, 'Czech', 'cs', 0),
(23, 'Danish', 'da', 0),
(24, 'Divehi', 'dv', 0),
(25, 'Dutch', 'nl', 0),
(26, 'English', 'en', 0),
(27, 'Estonian', 'et', 0),
(28, 'Filipino', 'fil', 0),
(29, 'Finnish', 'fi', 0),
(30, 'French', 'fr', 0),
(31, 'Galician', 'gl', 0),
(32, 'Georgian', 'ka', 0),
(33, 'German', 'de', 0),
(34, 'Greek', 'el', 0),
(35, 'Guarani', 'gn', 0),
(36, 'Gujarati', 'gu', 0),
(37, 'Haitian Creole', 'ht', 0),
(38, 'Hausa', 'ha', 0),
(39, 'Hawaiian', 'haw', 0),
(40, 'Hebrew', 'he', 1),
(41, 'Hindi', 'hi', 0),
(42, 'Hungarian', 'hu', 0),
(43, 'Icelandic', 'is', 0),
(44, 'Igbo', 'ig', 0),
(45, 'Indonesian', 'id', 0),
(46, 'Irish', 'ga', 0),
(47, 'Italian', 'it', 0),
(48, 'Japanese', 'ja', 0),
(49, 'Javanese', 'jv', 0),
(50, 'Kannada', 'kn', 0),
(51, 'Kazakh', 'kk', 0),
(52, 'Khmer', 'km', 0),
(53, 'Kinyarwanda', 'rw', 0),
(54, 'Korean', 'ko', 0),
(55, 'Kurdish', 'ku', 0),
(56, 'Kyrgyz', 'ky', 0),
(57, 'Lao', 'lo', 0),
(58, 'Latin', 'la', 0),
(59, 'Latvian', 'lv', 0),
(60, 'Lingala', 'ln', 0),
(61, 'Lithuanian', 'lt', 0),
(62, 'Macedonian', 'mk', 0),
(63, 'Malay', 'ms', 0),
(64, 'Malayalam', 'ml', 0),
(65, 'Maltese', 'mt', 0),
(66, 'Maori', 'mi', 0),
(67, 'Marathi', 'mr', 0),
(68, 'Mongolian', 'mn', 0),
(69, 'Nepali', 'ne', 0),
(70, 'Norwegian', 'no', 0),
(71, 'Pashto', 'ps', 1),
(72, 'Persian', 'fa', 1),
(73, 'Polish', 'pl', 0),
(74, 'Portuguese', 'pt', 0),
(75, 'Portuguese (Brazil)', 'pt-br', 0),
(76, 'Punjabi', 'pa', 0),
(77, 'Romanian', 'ro', 0),
(78, 'Russian', 'ru', 0),
(79, 'Samoan', 'sm', 0),
(80, 'Serbian', 'sr', 0),
(81, 'Sesotho', 'st', 0),
(82, 'Shona', 'sn', 0),
(83, 'Sindhi', 'sd', 0),
(84, 'Sinhala', 'si', 0),
(85, 'Slovak', 'sk', 0),
(86, 'Slovenian', 'sl', 0),
(87, 'Somali', 'so', 0),
(88, 'Spanish', 'es', 0),
(89, 'Sundanese', 'su', 0),
(90, 'Swahili', 'sw', 0),
(91, 'Swedish', 'sv', 0),
(92, 'Tajik', 'tg', 0),
(93, 'Tamil', 'ta', 0),
(94, 'Telugu', 'te', 0),
(95, 'Thai', 'th', 0),
(96, 'Turkish', 'tr', 0),
(97, 'Turkmen', 'tk', 0),
(98, 'Ukrainian', 'uk', 0),
(99, 'Urdu', 'ur', 0),
(100, 'Uzbek', 'uz', 0),
(101, 'Vietnamese', 'vi', 0),
(102, 'Welsh', 'cy', 0),
(103, 'Xhosa', 'xh', 0),
(104, 'Yiddish', 'yi', 0),
(105, 'Yoruba', 'yo', 0),
(106, 'Zulu', 'zu', 0);

-- --------------------------------------------------------

--
-- Table structure for table `ltu_phrases`
--

CREATE TABLE `ltu_phrases` (
  `id` bigint UNSIGNED NOT NULL,
  `uuid` char(36) COLLATE utf8mb4_unicode_ci NOT NULL,
  `translation_id` bigint UNSIGNED NOT NULL,
  `translation_file_id` bigint UNSIGNED NOT NULL,
  `phrase_id` bigint UNSIGNED DEFAULT NULL,
  `key` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `group` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `value` text COLLATE utf8mb4_unicode_ci,
  `status` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'active',
  `parameters` json DEFAULT NULL,
  `note` text COLLATE utf8mb4_unicode_ci,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Dumping data for table `ltu_phrases`
--

INSERT INTO `ltu_phrases` (`id`, `uuid`, `translation_id`, `translation_file_id`, `phrase_id`, `key`, `group`, `value`, `status`, `parameters`, `note`, `created_at`, `updated_at`) VALUES
(1, '9f34afb5-d91e-4fed-abec-214b9f8e18ec', 1, 1, NULL, 'password', 'auth', 'Password', 'active', NULL, NULL, '2025-06-21 00:42:30', '2025-06-21 00:42:30'),
(2, '9f34afb5-f31e-4461-b228-8b645a7781cc', 1, 1, NULL, 'save', 'auth', 'Save', 'active', NULL, NULL, '2025-06-21 00:42:30', '2025-06-21 00:42:30'),
(3, '9f34afb5-f42e-49f6-af34-cfa4f35d8e3e', 1, 1, NULL, 'full_name', 'auth', 'Full Name', 'active', NULL, NULL, '2025-06-21 00:42:30', '2025-06-21 00:42:30'),
(4, '9f34afb5-f668-4acf-9b1c-ed8225ab8e82', 1, 1, NULL, 'email', 'auth', 'Email', 'active', NULL, NULL, '2025-06-21 00:42:30', '2025-06-21 00:42:30'),
(5, '9f34afb5-fa11-4866-adc6-c7edb739e17f', 1, 1, NULL, 'confirm_password', 'auth', 'Confirm Password', 'active', NULL, NULL, '2025-06-21 00:42:30', '2025-06-21 00:42:30'),
(6, '9f34afb5-fb23-4ea0-9bb0-609d112ef92f', 1, 1, NULL, 'remember_me', 'auth', 'Remember Me', 'active', NULL, NULL, '2025-06-21 00:42:30', '2025-06-21 00:42:30'),
(7, '9f34afb5-ff8e-47d8-8173-c986ef96764a', 1, 1, NULL, 'sign_in', 'auth', 'Sign In', 'active', NULL, NULL, '2025-06-21 00:42:30', '2025-06-21 00:42:30'),
(8, '9f34afb6-036c-42b2-8e9b-8546be9c75d4', 1, 1, NULL, 'sign_out', 'auth', 'Sign out', 'active', NULL, NULL, '2025-06-21 00:42:30', '2025-06-21 00:42:30'),
(9, '9f34afb6-06e2-4ca0-a45f-1721154f27ab', 1, 1, NULL, 'register', 'auth', 'Register', 'active', NULL, NULL, '2025-06-21 00:42:30', '2025-06-21 00:42:30'),
(10, '9f34afb6-08a5-46a2-9829-b986c4d1b217', 1, 1, NULL, 'login.login', 'auth', 'Login', 'active', NULL, NULL, '2025-06-21 00:42:30', '2025-06-21 00:42:30'),
(11, '9f34afb6-09c4-4a90-b678-abdfff37e83b', 1, 1, NULL, 'login.title', 'auth', 'Sign in to start your session', 'active', NULL, NULL, '2025-06-21 00:42:30', '2025-06-21 00:42:30'),
(12, '9f34afb6-0d11-4c49-a5ea-3a4375779f8b', 1, 1, NULL, 'login.forgot_password', 'auth', 'Forgot Password ', 'active', NULL, NULL, '2025-06-21 00:42:30', '2025-06-21 00:42:30'),
(13, '9f34afb6-0e36-4bd3-801a-c2547151b37a', 1, 1, NULL, 'login.register_membership', 'auth', 'Register a new membership', 'active', NULL, NULL, '2025-06-21 00:42:30', '2025-06-21 00:42:30'),
(14, '9f34afb6-11a1-407f-97f3-9febe147ae86', 1, 1, NULL, 'login.enter_email', 'auth', 'Enter Email', 'active', NULL, NULL, '2025-06-21 00:42:30', '2025-06-21 00:42:30'),
(15, '9f34afb6-14da-4bd9-81be-0ad6ee5b4409', 1, 1, NULL, 'login.enter_password', 'auth', 'Enter Password', 'active', NULL, NULL, '2025-06-21 00:42:30', '2025-06-21 00:42:30'),
(16, '9f34afb6-1843-4d5b-a5a9-707d47b02dd0', 1, 1, NULL, 'registration.hospital_registration', 'auth', 'Hospital Registration', 'active', NULL, NULL, '2025-06-21 00:42:30', '2025-06-21 00:42:30'),
(17, '9f34afb6-1a2b-4783-8ccc-7d28a5a1de35', 1, 1, NULL, 'registration.already_user', 'auth', 'Already have an account', 'active', NULL, NULL, '2025-06-21 00:42:30', '2025-06-21 00:42:30'),
(18, '9f34afb6-1e24-4cbe-9123-1d083afd135d', 1, 1, NULL, 'registration.i_agree', 'auth', 'I agree to', 'active', NULL, NULL, '2025-06-21 00:42:30', '2025-06-21 00:42:30'),
(19, '9f34afb6-212b-418a-9774-334639a62a58', 1, 1, NULL, 'registration.terms', 'auth', 'the terms', 'active', NULL, NULL, '2025-06-21 00:42:30', '2025-06-21 00:42:30'),
(20, '9f34afb6-23a6-4364-8fd0-ceebcaf5958c', 1, 1, NULL, 'registration.have_membership', 'auth', 'I already have a membership', 'active', NULL, NULL, '2025-06-21 00:42:30', '2025-06-21 00:42:30'),
(21, '9f34afb6-2688-455e-8c93-7f65d9bd8f3e', 1, 1, NULL, 'registration.enter_hospital_name', 'auth', 'Enter Hospital Name', 'active', NULL, NULL, '2025-06-21 00:42:30', '2025-06-21 00:42:30'),
(22, '9f34afb6-2b37-4625-abea-f8db1027fec0', 1, 1, NULL, 'registration.enter_username', 'auth', 'Enter User Name', 'active', NULL, NULL, '2025-06-21 00:42:30', '2025-06-21 00:42:30'),
(23, '9f34afb6-2d27-4300-8905-63fb3a7a711c', 1, 1, NULL, 'registration.enter_password', 'auth', 'Enter Password', 'active', NULL, NULL, '2025-06-21 00:42:30', '2025-06-21 00:42:30'),
(24, '9f34afb6-308a-44fa-9329-4ede3164930a', 1, 1, NULL, 'registration.enter_confirm_password', 'auth', 'Enter Confirm Password', 'active', NULL, NULL, '2025-06-21 00:42:30', '2025-06-21 00:42:30'),
(25, '9f34afb6-3434-4c51-9fd8-2693a9f91e4d', 1, 1, NULL, 'registration.registration', 'auth', 'Registration', 'active', NULL, NULL, '2025-06-21 00:42:30', '2025-06-21 00:42:30'),
(26, '9f34afb6-35cb-40b5-bb71-36b35c21e309', 1, 1, NULL, 'forgot_password.title', 'auth', 'Enter Email to reset password', 'active', NULL, NULL, '2025-06-21 00:42:30', '2025-06-21 00:42:30'),
(27, '9f34afb6-39d3-455b-aad1-abd6842145e9', 1, 1, NULL, 'forgot_password.send_pwd_reset', 'auth', 'Send Password Reset Link', 'active', NULL, NULL, '2025-06-21 00:42:30', '2025-06-21 00:42:30'),
(28, '9f34afb6-3aeb-406d-af06-9452b8ff2d8f', 1, 1, NULL, 'forgot_password.enter_email', 'auth', 'Enter Email', 'active', NULL, NULL, '2025-06-21 00:42:30', '2025-06-21 00:42:30'),
(29, '9f34afb6-3d3b-4808-9ff3-26a261bdb6d4', 1, 1, NULL, 'reset_password.title', 'auth', 'Reset your password', 'active', NULL, NULL, '2025-06-21 00:42:30', '2025-06-21 00:42:30'),
(30, '9f34afb6-3e56-454d-8655-a60ea2f359b8', 1, 1, NULL, 'reset_password.reset_pwd_btn', 'auth', 'Reset Password', 'active', NULL, NULL, '2025-06-21 00:42:30', '2025-06-21 00:42:30'),
(31, '9f34afb6-3f7f-4797-beb6-36faed8149f9', 1, 1, NULL, 'reset_password.already_reset', 'auth', 'Already have reset your password ?', 'active', NULL, NULL, '2025-06-21 00:42:30', '2025-06-21 00:42:30'),
(32, '9f34afb6-4088-4407-90bc-6c2794765491', 1, 1, NULL, 'reset_password.password_reset', 'auth', 'Password Reset', 'active', NULL, NULL, '2025-06-21 00:42:30', '2025-06-21 00:42:30'),
(33, '9f34afb6-41bf-4103-af32-13fc63abedca', 1, 1, NULL, 'new_here', 'auth', 'New Here?', 'active', NULL, NULL, '2025-06-21 00:42:30', '2025-06-21 00:42:30'),
(34, '9f34afb6-42d6-4165-b6f7-4781e09243a6', 1, 1, NULL, 'create_an_account', 'auth', 'Create an Account', 'active', NULL, NULL, '2025-06-21 00:42:30', '2025-06-21 00:42:30'),
(35, '9f34afb6-4408-42f7-bf89-2aa32d3ef78c', 1, 1, NULL, 'please_wait', 'auth', 'Please Wait...', 'active', NULL, NULL, '2025-06-21 00:42:30', '2025-06-21 00:42:30'),
(36, '9f34afb6-4547-4a7a-b4d2-b2332b98cc3b', 1, 1, NULL, 'submit', 'auth', 'Submit', 'active', NULL, NULL, '2025-06-21 00:42:30', '2025-06-21 00:42:30'),
(37, '9f34afb6-4685-4e1a-b4fc-28a56fcaafa4', 1, 1, NULL, 'already_user', 'auth', 'Already User ?', 'active', NULL, NULL, '2025-06-21 00:42:30', '2025-06-21 00:42:30'),
(38, '9f34afb6-47bc-499a-ac42-5e6ed7646717', 1, 1, NULL, 'hospital_name', 'auth', 'Hospital Name', 'active', NULL, NULL, '2025-06-21 00:42:30', '2025-06-21 00:42:30'),
(39, '9f34afb6-48d0-4616-9a40-e10ac872fecf', 1, 1, NULL, 'hospital_slug', 'auth', 'Hospital Slug', 'active', NULL, NULL, '2025-06-21 00:42:30', '2025-06-21 00:42:30'),
(40, '9f34afb6-49e4-4f39-86e8-5abd487cab6e', 1, 1, NULL, 'sent_verification_email', 'auth', 'A fresh verification link has been sent to your email address', 'active', NULL, NULL, '2025-06-21 00:42:30', '2025-06-21 00:42:30'),
(41, '9f34afb6-4afd-441f-98d2-e18deb8130cf', 1, 1, NULL, 'verify_email', 'auth', 'Verify Your Email Address', 'active', NULL, NULL, '2025-06-21 00:42:30', '2025-06-21 00:42:30'),
(42, '9f34afb6-4f77-4170-9771-0737e10b7c03', 1, 1, NULL, 'check_email_before_verify', 'auth', 'Before proceeding, please check your email for a verification link.If you did not receive the email', 'active', NULL, NULL, '2025-06-21 00:42:30', '2025-06-21 00:42:30'),
(43, '9f34afb6-50b7-41e3-8874-99d6eafd027b', 1, 1, NULL, 'request_another', 'auth', 'click here to request another', 'active', NULL, NULL, '2025-06-21 00:42:30', '2025-06-21 00:42:30'),
(44, '9f34afb6-5241-4f66-a04a-2048517adc05', 1, 2, NULL, 'select_time_slot', 'js', 'Please select appointment time slot.', 'active', NULL, NULL, '2025-06-21 00:42:30', '2025-06-21 00:42:30'),
(45, '9f34afb6-5369-4563-bec8-44790d4e7500', 1, 2, NULL, 'please_select_doctor', 'js', 'Please select Doctor', 'active', NULL, NULL, '2025-06-21 00:42:30', '2025-06-21 00:42:30'),
(46, '9f34afb6-5483-4560-8f20-52d5e31c6d09', 1, 2, NULL, 'sunday', 'js', 'Sunday', 'active', NULL, NULL, '2025-06-21 00:42:30', '2025-06-21 00:42:30'),
(47, '9f34afb6-5596-4bc3-bd32-60d05ef908cf', 1, 2, NULL, 'monday', 'js', 'Monday', 'active', NULL, NULL, '2025-06-21 00:42:30', '2025-06-21 00:42:30'),
(48, '9f34afb6-56a0-4b7e-bd53-76b436003991', 1, 2, NULL, 'tuesday', 'js', 'Tuesday', 'active', NULL, NULL, '2025-06-21 00:42:30', '2025-06-21 00:42:30'),
(49, '9f34afb6-57ad-4cd6-8f53-ae05bb9ca786', 1, 2, NULL, 'wednesday', 'js', 'Wednesday', 'active', NULL, NULL, '2025-06-21 00:42:30', '2025-06-21 00:42:30'),
(50, '9f34afb6-58ec-4457-a24a-b98b0c4887a3', 1, 2, NULL, 'thursday', 'js', 'Thursday', 'active', NULL, NULL, '2025-06-21 00:42:30', '2025-06-21 00:42:30'),
(51, '9f34afb6-59f7-4cf4-8990-6897250e5b09', 1, 2, NULL, 'friday', 'js', 'Friday', 'active', NULL, NULL, '2025-06-21 00:42:30', '2025-06-21 00:42:30'),
(52, '9f34afb6-5b3e-4141-9817-2cf628508ae1', 1, 2, NULL, 'saturday', 'js', 'Saturday', 'active', NULL, NULL, '2025-06-21 00:42:30', '2025-06-21 00:42:30'),
(53, '9f34afb6-5c4b-404b-a3cb-00260a1a12f4', 1, 2, NULL, 'doctor_schedule_not_available_on_this_date', 'js', 'Doctor Schedule not available this date.', 'active', NULL, NULL, '2025-06-21 00:42:30', '2025-06-21 00:42:30'),
(54, '9f34afb6-5d82-4825-b9ff-02ab89dc0dc9', 1, 2, NULL, 'custom', 'js', 'Custom', 'active', NULL, NULL, '2025-06-21 00:42:30', '2025-06-21 00:42:30'),
(55, '9f34afb6-5e9c-4807-94cc-9e847d82328d', 1, 2, NULL, 'apply', 'js', 'Apply', 'active', NULL, NULL, '2025-06-21 00:42:30', '2025-06-21 00:42:30'),
(56, '9f34afb6-5fa5-4406-a193-bcbdb4f834db', 1, 2, NULL, 'from', 'js', 'From', 'active', NULL, NULL, '2025-06-21 00:42:30', '2025-06-21 00:42:30'),
(57, '9f34afb6-60b5-4813-a8c2-9ba89943b10d', 1, 2, NULL, 'to', 'js', 'To', 'active', NULL, NULL, '2025-06-21 00:42:30', '2025-06-21 00:42:30'),
(58, '9f34afb6-6202-4bdc-88f6-346750c08a0d', 1, 2, NULL, 'jan', 'js', 'January', 'active', NULL, NULL, '2025-06-21 00:42:30', '2025-06-21 00:42:30'),
(59, '9f34afb6-633b-4728-88c2-e39aa333fca8', 1, 2, NULL, 'feb', 'js', 'February', 'active', NULL, NULL, '2025-06-21 00:42:30', '2025-06-21 00:42:30'),
(60, '9f34afb6-644c-4083-8e3b-b405ea085adf', 1, 2, NULL, 'mar', 'js', 'March', 'active', NULL, NULL, '2025-06-21 00:42:30', '2025-06-21 00:42:30'),
(61, '9f34afb6-6562-4677-8ecd-a7df0f1c3126', 1, 2, NULL, 'apr', 'js', 'April', 'active', NULL, NULL, '2025-06-21 00:42:30', '2025-06-21 00:42:30'),
(62, '9f34afb6-669c-4da0-bf34-3000b1feaebc', 1, 2, NULL, 'may', 'js', 'May', 'active', NULL, NULL, '2025-06-21 00:42:30', '2025-06-21 00:42:30'),
(63, '9f34afb6-67cd-4344-8661-e9399d4d66cc', 1, 2, NULL, 'jun', 'js', 'June', 'active', NULL, NULL, '2025-06-21 00:42:30', '2025-06-21 00:42:30'),
(64, '9f34afb6-68d8-407b-8592-caaedaca0c00', 1, 2, NULL, 'jul', 'js', 'July', 'active', NULL, NULL, '2025-06-21 00:42:30', '2025-06-21 00:42:30'),
(65, '9f34afb6-7455-4886-a36a-d9f90788acb2', 1, 2, NULL, 'aug', 'js', 'August', 'active', NULL, NULL, '2025-06-21 00:42:30', '2025-06-21 00:42:30'),
(66, '9f34afb6-770f-4db7-b685-286ab12e770a', 1, 2, NULL, 'sep', 'js', 'September', 'active', NULL, NULL, '2025-06-21 00:42:30', '2025-06-21 00:42:30'),
(67, '9f34afb6-7ad8-4025-bd4d-109fa82db117', 1, 2, NULL, 'oct', 'js', 'October', 'active', NULL, NULL, '2025-06-21 00:42:30', '2025-06-21 00:42:30'),
(68, '9f34afb6-7df0-4b6d-8f67-b361019fdb14', 1, 2, NULL, 'nov', 'js', 'November', 'active', NULL, NULL, '2025-06-21 00:42:30', '2025-06-21 00:42:30'),
(69, '9f34afb6-8524-49e5-ac87-cc6c2ab5fe27', 1, 2, NULL, 'dec', 'js', 'December', 'active', NULL, NULL, '2025-06-21 00:42:30', '2025-06-21 00:42:30'),
(70, '9f34afb6-8ed3-45c6-88cb-0fb95a8200d7', 1, 2, NULL, 'sun', 'js', 'SUN', 'active', NULL, NULL, '2025-06-21 00:42:30', '2025-06-21 00:42:30'),
(71, '9f34afb6-96cd-4db8-bee6-3d72598ecbf5', 1, 2, NULL, 'mon', 'js', 'MON', 'active', NULL, NULL, '2025-06-21 00:42:30', '2025-06-21 00:42:30'),
(72, '9f34afb6-a040-4eb7-81d5-6fe5ad9f9543', 1, 2, NULL, 'tue', 'js', 'TUE', 'active', NULL, NULL, '2025-06-21 00:42:30', '2025-06-21 00:42:30'),
(73, '9f34afb6-a335-4621-b7b3-ca6e153d6cb6', 1, 2, NULL, 'wed', 'js', 'WED', 'active', NULL, NULL, '2025-06-21 00:42:30', '2025-06-21 00:42:30'),
(74, '9f34afb6-a6f0-48ea-8765-2f8746097429', 1, 2, NULL, 'thu', 'js', 'THU', 'active', NULL, NULL, '2025-06-21 00:42:30', '2025-06-21 00:42:30'),
(75, '9f34afb6-aae2-4d2b-9a7c-bb4b927c5d03', 1, 2, NULL, 'fri', 'js', 'FRI', 'active', NULL, NULL, '2025-06-21 00:42:30', '2025-06-21 00:42:30'),
(76, '9f34afb6-ac94-41ba-8258-2ad3a1903fb3', 1, 2, NULL, 'sat', 'js', 'SAT', 'active', NULL, NULL, '2025-06-21 00:42:31', '2025-06-21 00:42:31'),
(77, '9f34afb6-b00d-4ca7-90e6-26a8ec1cc4fb', 1, 2, NULL, 'today', 'js', 'Today', 'active', NULL, NULL, '2025-06-21 00:42:31', '2025-06-21 00:42:31'),
(78, '9f34afb6-b11a-4a29-af68-9ed455ca6489', 1, 2, NULL, 'yesterday', 'js', 'Yesterday', 'active', NULL, NULL, '2025-06-21 00:42:31', '2025-06-21 00:42:31'),
(79, '9f34afb6-b255-4a11-97c4-df0fb206b9b9', 1, 2, NULL, 'this_week', 'js', 'This Week', 'active', NULL, NULL, '2025-06-21 00:42:31', '2025-06-21 00:42:31'),
(80, '9f34afb6-b548-43af-abcc-7dbe828b9ba7', 1, 2, NULL, 'last_7_days', 'js', 'Last 7 days', 'active', NULL, NULL, '2025-06-21 00:42:31', '2025-06-21 00:42:31'),
(81, '9f34afb6-b8c4-43a0-a67e-1f7400006bd4', 1, 2, NULL, 'last_30_days', 'js', 'Last 30 days', 'active', NULL, NULL, '2025-06-21 00:42:31', '2025-06-21 00:42:31'),
(82, '9f34afb6-bce0-48ca-80f5-992daeb05701', 1, 2, NULL, 'this_month', 'js', 'This month', 'active', NULL, NULL, '2025-06-21 00:42:31', '2025-06-21 00:42:31'),
(83, '9f34afb6-c05f-4ac8-834f-394e1395201e', 1, 2, NULL, 'last_month', 'js', 'Last month', 'active', NULL, NULL, '2025-06-21 00:42:31', '2025-06-21 00:42:31'),
(84, '9f34afb6-c48a-4003-bae0-1988a9ecc9d9', 1, 2, NULL, 'appointment', 'js', 'Appointment', 'active', NULL, NULL, '2025-06-21 00:42:31', '2025-06-21 00:42:31'),
(85, '9f34afb6-c735-4248-b6ff-8cb5f288c10c', 1, 2, NULL, 'status', 'js', 'Status', 'active', NULL, NULL, '2025-06-21 00:42:31', '2025-06-21 00:42:31'),
(86, '9f34afb6-cbed-4f96-a875-755187cc3cb3', 1, 2, NULL, 'are_you_sure_want_to_cancel', 'js', 'Are you sure want to cancel', 'active', NULL, NULL, '2025-06-21 00:42:31', '2025-06-21 00:42:31'),
(87, '9f34afb6-cffa-4190-8ab1-820a6fd7a1e3', 1, 2, NULL, 'canceled', 'js', 'Canceled', 'active', NULL, NULL, '2025-06-21 00:42:31', '2025-06-21 00:42:31'),
(88, '9f34afb6-d2d6-4d8c-8cd4-214840d9b57f', 1, 2, NULL, 'appointment_cancel', 'js', 'Appointment cancelled successfully.', 'active', NULL, NULL, '2025-06-21 00:42:31', '2025-06-21 00:42:31'),
(89, '9f34afb6-d6b7-4f81-9935-dca80595c81a', 1, 2, NULL, 'change_status', 'js', 'Change status', 'active', NULL, NULL, '2025-06-21 00:42:31', '2025-06-21 00:42:31'),
(90, '9f34afb6-d918-41a7-b820-f643e8c0341e', 1, 2, NULL, 'are_you_sure_want_to_change', 'js', 'Are you sure want to change ', 'active', NULL, NULL, '2025-06-21 00:42:31', '2025-06-21 00:42:31'),
(91, '9f34afb6-da35-4199-b29f-f5e95c41def8', 1, 2, NULL, 'changed_appointment', 'js', 'Changed Appointment', 'active', NULL, NULL, '2025-06-21 00:42:31', '2025-06-21 00:42:31'),
(92, '9f34afb6-e148-4e96-8ac7-d10769d1e921', 1, 2, NULL, 'has_been_changed', 'js', 'has been Changed.', 'active', NULL, NULL, '2025-06-21 00:42:31', '2025-06-21 00:42:31'),
(93, '9f34afb6-e270-4acb-9772-2091df18881f', 1, 2, NULL, 'department', 'js', 'Department', 'active', NULL, NULL, '2025-06-21 00:42:31', '2025-06-21 00:42:31'),
(94, '9f34afb6-e37b-4f82-b9c5-3e8e666ddcd2', 1, 2, NULL, 'select_doctor', 'js', 'Select Doctor', 'active', NULL, NULL, '2025-06-21 00:42:31', '2025-06-21 00:42:31'),
(95, '9f34afb6-e6bb-418f-9d86-dd08b6804ec3', 1, 2, NULL, 'select_appointment_date', 'js', 'Please select appointment date.', 'active', NULL, NULL, '2025-06-21 00:42:31', '2025-06-21 00:42:31'),
(96, '9f34afb6-e7dd-413c-bf22-5a2ae3e4d2ce', 1, 2, NULL, 'cancel', 'js', 'Cancel', 'active', NULL, NULL, '2025-06-21 00:42:31', '2025-06-21 00:42:31'),
(97, '9f34afb6-edf8-4856-8c55-8423bcf85f75', 1, 2, NULL, 'select_ipd_patient', 'js', 'Select IPD Patient', 'active', NULL, NULL, '2025-06-21 00:42:31', '2025-06-21 00:42:31'),
(98, '9f34afb6-f13e-4e6d-82f1-f3070cf373c9', 1, 2, NULL, 'no_ipd_patient_found', 'js', 'No IPD Patient Found', 'active', NULL, NULL, '2025-06-21 00:42:31', '2025-06-21 00:42:31'),
(99, '9f34afb6-f7ce-49b2-99a2-a8c935492f2f', 1, 2, NULL, 'select_bed_type', 'js', 'Select Bed Type', 'active', NULL, NULL, '2025-06-21 00:42:31', '2025-06-21 00:42:31'),
(100, '9f34afb6-f8f7-46fb-b8fe-2d52a02884be', 1, 2, NULL, 'are_u_sure', 'js', 'Are you sure?', 'active', NULL, NULL, '2025-06-21 00:42:31', '2025-06-21 00:42:31'),
(101, '9f34afb6-fa1f-4017-8ddc-c655d7d15a24', 1, 2, NULL, 'u_want_to_complete_this_payment', 'js', 'You want to complete this payment!', 'active', NULL, NULL, '2025-06-21 00:42:31', '2025-06-21 00:42:31'),
(102, '9f34afb6-fd54-498f-8f2a-e7512fb9472b', 1, 2, NULL, 'select_medicine', 'js', 'Select Medicine', 'active', NULL, NULL, '2025-06-21 00:42:31', '2025-06-21 00:42:31'),
(103, '9f34afb6-fe6f-4dfe-9768-9eea9450397a', 1, 2, NULL, 'select_charge_type', 'js', 'Select Category Type', 'active', NULL, NULL, '2025-06-21 00:42:31', '2025-06-21 00:42:31'),
(104, '9f34afb7-00cc-49cd-a6b2-a80779743912', 1, 2, NULL, 'select_charge_category', 'js', 'Select Charge Category', 'active', NULL, NULL, '2025-06-21 00:42:31', '2025-06-21 00:42:31'),
(105, '9f34afb7-01e7-4bbe-b869-525f224ed160', 1, 2, NULL, 'currency', 'js', 'Currency', 'active', NULL, NULL, '2025-06-21 00:42:31', '2025-06-21 00:42:31'),
(106, '9f34afb7-02f7-4ba4-bc5d-d704769ab7f7', 1, 2, NULL, 'notification_read', 'js', 'Notification read successfully.', 'active', NULL, NULL, '2025-06-21 00:42:31', '2025-06-21 00:42:31'),
(107, '9f34afb7-0651-4926-adee-fe73551bf555', 1, 2, NULL, 'all_notification_read', 'js', 'All Notification read successfully.', 'active', NULL, NULL, '2025-06-21 00:42:31', '2025-06-21 00:42:31'),
(108, '9f34afb7-08ad-4c25-8e67-91e4ca714a4d', 1, 2, NULL, 'invalid_number', 'js', 'Invalid number', 'active', NULL, NULL, '2025-06-21 00:42:31', '2025-06-21 00:42:31'),
(109, '9f34afb7-0b72-4a45-8dd3-fdc5834c9766', 1, 2, NULL, 'invalid_country_code', 'js', 'Invalid country code', 'active', NULL, NULL, '2025-06-21 00:42:31', '2025-06-21 00:42:31'),
(110, '9f34afb7-0dfd-4e62-b661-8ae72459871c', 1, 2, NULL, 'too_short', 'js', 'Too short', 'active', NULL, NULL, '2025-06-21 00:42:31', '2025-06-21 00:42:31'),
(111, '9f34afb7-112b-45e8-a5b4-5421cd55f7ac', 1, 2, NULL, 'too_long', 'js', 'Too long', 'active', NULL, NULL, '2025-06-21 00:42:31', '2025-06-21 00:42:31'),
(112, '9f34afb7-125a-43af-ac83-4fd0d91310e7', 1, 2, NULL, 'holiday', 'js', 'Holiday', 'active', NULL, NULL, '2025-06-21 00:42:31', '2025-06-21 00:42:31'),
(113, '9f34afb7-1616-4fac-a76d-954f1cd289fd', 1, 2, NULL, 'please_enter_valid_facebook_url', 'js', 'Please enter a valid facebook URL', 'active', NULL, NULL, '2025-06-21 00:42:31', '2025-06-21 00:42:31'),
(114, '9f34afb7-19cf-4bbe-9989-e595621dc453', 1, 2, NULL, 'please_enter_valid_twitter_url', 'js', 'Please enter a valid Twitter URL', 'active', NULL, NULL, '2025-06-21 00:42:31', '2025-06-21 00:42:31'),
(115, '9f34afb7-1afb-49e2-a7d0-a8dffc3415a0', 1, 2, NULL, 'please_enter_valid_Instagram_url', 'js', 'Please enter a valid Instagram URL', 'active', NULL, NULL, '2025-06-21 00:42:31', '2025-06-21 00:42:31'),
(116, '9f34afb7-1f99-4780-8fc7-0e259e6fd24f', 1, 2, NULL, 'please_enter_valid_linkedin_url', 'js', 'Please enter a valid LinkedIn URL', 'active', NULL, NULL, '2025-06-21 00:42:31', '2025-06-21 00:42:31'),
(117, '9f34afb7-217b-453a-9f99-354a0af87085', 1, 2, NULL, 'document_file_size', 'js', 'The document must be a file of type: jpeg, jpg, png, pdf, doc, docx., mp3, mp4', 'active', NULL, NULL, '2025-06-21 00:42:31', '2025-06-21 00:42:31'),
(118, '9f34afb7-27c6-4594-b329-b03da9fb03b6', 1, 2, NULL, 'paid', 'js', 'Paid', 'active', NULL, NULL, '2025-06-21 00:42:31', '2025-06-21 00:42:31'),
(119, '9f34afb7-28ec-4eca-b3cf-eb939a02f39e', 1, 2, NULL, 'unpaid', 'js', 'Unpaid', 'active', NULL, NULL, '2025-06-21 00:42:31', '2025-06-21 00:42:31'),
(120, '9f34afb7-2a29-4be1-871b-5f261574de80', 1, 2, NULL, 'deduction_not_greater_than_salary', 'js', 'Deductions cannot be greater than Basic salary + Allowance', 'active', NULL, NULL, '2025-06-21 00:42:31', '2025-06-21 00:42:31'),
(121, '9f34afb7-2d07-4d51-bdf0-f8dc6fb1803f', 1, 2, NULL, 'select_employee', 'js', 'Select Employee', 'active', NULL, NULL, '2025-06-21 00:42:31', '2025-06-21 00:42:31'),
(122, '9f34afb7-311f-46f7-95f3-b89c45ae4d57', 1, 2, NULL, 'terms_conditions', 'js', 'Terms & Conditions', 'active', NULL, NULL, '2025-06-21 00:42:31', '2025-06-21 00:42:31'),
(123, '9f34afb7-3252-482b-af86-4c287109d56c', 1, 2, NULL, 'privacy_policy', 'js', 'Privacy Policy', 'active', NULL, NULL, '2025-06-21 00:42:31', '2025-06-21 00:42:31'),
(124, '9f34afb7-3610-4408-8200-084d8ab0d983', 1, 2, NULL, 'terms_condition_required', 'js', 'The Terms & Conditions is required.', 'active', NULL, NULL, '2025-06-21 00:42:31', '2025-06-21 00:42:31'),
(125, '9f34afb7-3762-4610-879c-b17ec3ac686a', 1, 2, NULL, 'image_must_be', 'js', 'The image must be a file of type: jpg, jpeg, png.', 'active', NULL, NULL, '2025-06-21 00:42:31', '2025-06-21 00:42:31'),
(126, '9f34afb7-3bf6-4193-a632-2bfea988b35c', 1, 2, NULL, 'field_not_contain_white_space', 'js', 'field is not contain only white space', 'active', NULL, NULL, '2025-06-21 00:42:31', '2025-06-21 00:42:31'),
(127, '9f34afb7-3d39-4871-87f4-67c022e2ea43', 1, 2, NULL, 'home_page_experience', 'js', 'Home Page Experience', 'active', NULL, NULL, '2025-06-21 00:42:31', '2025-06-21 00:42:31'),
(128, '9f34afb7-3e8a-4e29-ae9f-a7da6635e72d', 1, 2, NULL, 'home_page_title', 'js', 'Home Page Title', 'active', NULL, NULL, '2025-06-21 00:42:31', '2025-06-21 00:42:31'),
(129, '9f34afb7-3fb7-472a-971e-5d94063d7395', 1, 2, NULL, 'home_page_description', 'js', 'Home Page Description', 'active', NULL, NULL, '2025-06-21 00:42:31', '2025-06-21 00:42:31'),
(130, '9f34afb7-40ec-4923-a347-f5f754ffcef4', 1, 2, NULL, 'home_page_box_title', 'js', 'Home Page Box Title', 'active', NULL, NULL, '2025-06-21 00:42:31', '2025-06-21 00:42:31'),
(131, '9f34afb7-422a-4573-b8d7-4aeaa5c0a5b0', 1, 2, NULL, 'home_page_box_description', 'js', 'Home Page Box Description', 'active', NULL, NULL, '2025-06-21 00:42:31', '2025-06-21 00:42:31'),
(132, '9f34afb7-4362-4d80-86fd-dd53f27bc2e9', 1, 2, NULL, 'home_page_certified_doctor_text', 'js', 'Home Page Certified Doctor Text', 'active', NULL, NULL, '2025-06-21 00:42:31', '2025-06-21 00:42:31'),
(133, '9f34afb7-44a9-4b84-b898-9a4b73d102d9', 1, 2, NULL, 'home_page_certified_doctor_title', 'js', 'Home Page Certified Doctor Title', 'active', NULL, NULL, '2025-06-21 00:42:31', '2025-06-21 00:42:31'),
(134, '9f34afb7-45d9-4003-9a23-2bf3ffcd9533', 1, 2, NULL, 'home_page_certified_doctor_description', 'js', 'Home Page Certified Doctor Description', 'active', NULL, NULL, '2025-06-21 00:42:31', '2025-06-21 00:42:31'),
(135, '9f34afb7-4710-4293-91e7-e149d3b02349', 1, 2, NULL, 'home_page_certified_box_title', 'js', 'Home Page Certified Box Title', 'active', NULL, NULL, '2025-06-21 00:42:31', '2025-06-21 00:42:31'),
(136, '9f34afb7-4849-4a2c-9a96-1c1e4b6e0fdf', 1, 2, NULL, 'home_page_certified_box_description', 'js', 'Home Page Certified Box Description', 'active', NULL, NULL, '2025-06-21 00:42:31', '2025-06-21 00:42:31'),
(137, '9f34afb7-498d-422f-bf94-04c32f2a4372', 1, 2, NULL, 'home_page_step_1_title', 'js', 'Home Page Step 1 Title', 'active', NULL, NULL, '2025-06-21 00:42:31', '2025-06-21 00:42:31'),
(138, '9f34afb7-4ab7-4263-a52b-ae6840a8c136', 1, 2, NULL, 'home_page_step_1_description', 'js', 'Home Page Step 1 Description', 'active', NULL, NULL, '2025-06-21 00:42:31', '2025-06-21 00:42:31'),
(139, '9f34afb7-4bdc-413e-bb23-66f13781611b', 1, 2, NULL, 'home_page_step_2_title', 'js', 'Home Page Step 2 Title', 'active', NULL, NULL, '2025-06-21 00:42:31', '2025-06-21 00:42:31'),
(140, '9f34afb7-4cf6-4b57-9c23-627e645891b1', 1, 2, NULL, 'home_page_step_2_description', 'js', 'Home Page Step 2 Description', 'active', NULL, NULL, '2025-06-21 00:42:31', '2025-06-21 00:42:31'),
(141, '9f34afb7-4e0d-4694-aa77-e04ecf68834c', 1, 2, NULL, 'home_page_step_3_title', 'js', 'Home Page Step 3 Title', 'active', NULL, NULL, '2025-06-21 00:42:31', '2025-06-21 00:42:31'),
(142, '9f34afb7-4f37-43b5-ac5e-b35f8279e8bc', 1, 2, NULL, 'home_page_step_3_description', 'js', 'Home Page Step 3 Description', 'active', NULL, NULL, '2025-06-21 00:42:31', '2025-06-21 00:42:31'),
(143, '9f34afb7-5057-4d4b-a4c1-a66b3fd5e45c', 1, 2, NULL, 'home_page_step_4_title', 'js', 'Home Page Step 4 Title', 'active', NULL, NULL, '2025-06-21 00:42:31', '2025-06-21 00:42:31'),
(144, '9f34afb7-518d-4359-89be-0f82d6c03ec0', 1, 2, NULL, 'home_page_step_4_description', 'js', 'Home Page Step 4 Description', 'active', NULL, NULL, '2025-06-21 00:42:31', '2025-06-21 00:42:31'),
(145, '9f34afb7-52a5-4a65-9964-9a72fe942e70', 1, 2, NULL, 'about_us_title', 'js', 'Title', 'active', NULL, NULL, '2025-06-21 00:42:31', '2025-06-21 00:42:31'),
(146, '9f34afb7-53be-44b1-a95d-b6888994dd6b', 1, 2, NULL, 'about_us_description', 'js', 'Description', 'active', NULL, NULL, '2025-06-21 00:42:31', '2025-06-21 00:42:31'),
(147, '9f34afb7-54e0-4cf3-bc71-2f33dc29acb4', 1, 2, NULL, 'about_us_mission', 'js', 'Mission', 'active', NULL, NULL, '2025-06-21 00:42:31', '2025-06-21 00:42:31'),
(148, '9f34afb7-577a-4868-8910-530628c9e580', 1, 2, NULL, 'warning', 'js', 'Warning !', 'active', NULL, NULL, '2025-06-21 00:42:31', '2025-06-21 00:42:31'),
(149, '9f34afb7-58aa-4fff-b859-66f3e5d958ee', 1, 2, NULL, 'document_must_be_file_type', 'js', 'The document must be a file of type: jpeg, jpg, png, pdf, doc, docx.', 'active', NULL, NULL, '2025-06-21 00:42:31', '2025-06-21 00:42:31'),
(150, '9f34afb7-59f5-46f1-b9a3-b3f115daf7c0', 1, 2, NULL, 'sending', 'js', 'Sending...', 'active', NULL, NULL, '2025-06-21 00:42:31', '2025-06-21 00:42:31'),
(151, '9f34afb7-5b33-447a-990b-efbcb764b670', 1, 2, NULL, 'send_mail', 'js', 'Send Mail', 'active', NULL, NULL, '2025-06-21 00:42:31', '2025-06-21 00:42:31'),
(152, '9f34afb7-5c5d-44f4-972d-04965f560ec2', 1, 2, NULL, 'select_account', 'js', 'Select Account', 'active', NULL, NULL, '2025-06-21 00:42:31', '2025-06-21 00:42:31'),
(153, '9f34afb7-5d7e-48bd-bd4e-730e349cf221', 1, 2, NULL, 'choose_case', 'js', 'Choose Case', 'active', NULL, NULL, '2025-06-21 00:42:31', '2025-06-21 00:42:31'),
(154, '9f34afb7-5ea2-4a15-af45-09ba779bab24', 1, 2, NULL, 'select_code', 'js', 'Select Code', 'active', NULL, NULL, '2025-06-21 00:42:31', '2025-06-21 00:42:31'),
(155, '9f34afb7-5fd4-4053-ad82-1e67743c5b93', 1, 2, NULL, 'choose_bed', 'js', 'Choose Bed', 'active', NULL, NULL, '2025-06-21 00:42:31', '2025-06-21 00:42:31'),
(156, '9f34afb7-611b-4695-996e-e98257fbf283', 1, 2, NULL, 'your_payment_failed', 'js', 'Your Payment is failed.', 'active', NULL, NULL, '2025-06-21 00:42:31', '2025-06-21 00:42:31'),
(157, '9f34afb7-624e-4169-b020-c6a60bf6db1b', 1, 2, NULL, 'has_been_deleted', 'js', 'has been deleted.', 'active', NULL, NULL, '2025-06-21 00:42:31', '2025-06-21 00:42:31'),
(158, '9f34afb7-6369-4e67-80f1-113487d0eaa8', 1, 2, NULL, 'available_quantity', 'js', 'Available Quantity', 'active', NULL, NULL, '2025-06-21 00:42:31', '2025-06-21 00:42:31'),
(159, '9f34afb7-648a-45a1-9a97-3f389dbdb4bf', 1, 2, NULL, 'medicine_required', 'js', 'Medicine field is required.', 'active', NULL, NULL, '2025-06-21 00:42:31', '2025-06-21 00:42:31'),
(160, '9f34afb7-65ae-4080-9e20-4eacd3d511df', 1, 2, NULL, 'are_you_sure_want_to_delete_this', 'js', 'Are you sure want to delete this ', 'active', NULL, NULL, '2025-06-21 00:42:31', '2025-06-21 00:42:31'),
(161, '9f34afb7-66cd-43b1-b280-eae2c8c93ffb', 1, 2, NULL, 'ipd_timeline', 'js', 'IPD Timeline', 'active', NULL, NULL, '2025-06-21 00:42:31', '2025-06-21 00:42:31'),
(162, '9f34afb7-67f4-4aff-a48e-a78e1713e6b8', 1, 2, NULL, 'deleted', 'js', 'Deleted', 'active', NULL, NULL, '2025-06-21 00:42:31', '2025-06-21 00:42:31'),
(163, '9f34afb7-6919-4a11-b7bd-f7225ad3397e', 1, 2, NULL, 'select_user', 'js', 'Select User', 'active', NULL, NULL, '2025-06-21 00:42:31', '2025-06-21 00:42:31'),
(164, '9f34afb7-6a3d-4f4d-9f39-346a2e2713a1', 1, 2, NULL, 'select_item', 'js', 'Select Item', 'active', NULL, NULL, '2025-06-21 00:42:31', '2025-06-21 00:42:31'),
(165, '9f34afb7-6b61-4d8a-baee-04c997c2dcc0', 1, 2, NULL, 'qty_cannot_be_zero', 'js', 'Quantity cannot be zero.', 'active', NULL, NULL, '2025-06-21 00:42:31', '2025-06-21 00:42:31'),
(166, '9f34afb7-6c86-450a-b6d9-28eed56e425a', 1, 2, NULL, 'qty_must_be_less_than_available_qty', 'js', 'Quantity must be less than Available quantity.', 'active', NULL, NULL, '2025-06-21 00:42:31', '2025-06-21 00:42:31'),
(167, '9f34afb7-6da9-4a23-bccc-2af05fbf19f6', 1, 2, NULL, 'are_you_sure_want_to_return_this_item', 'js', 'Are you sure want to return this item', 'active', NULL, NULL, '2025-06-21 00:42:31', '2025-06-21 00:42:31'),
(168, '9f34afb7-6ec7-471b-8bd4-292438a96bf1', 1, 2, NULL, 'item_returned', 'js', 'Item returned successfully.', 'active', NULL, NULL, '2025-06-21 00:42:31', '2025-06-21 00:42:31'),
(169, '9f34afb7-6fed-4cfb-a3ff-2acdc2bdc831', 1, 2, NULL, 'select_type_number', 'js', 'Select Type Number', 'active', NULL, NULL, '2025-06-21 00:42:31', '2025-06-21 00:42:31'),
(170, '9f34afb7-7115-4527-be67-5615afcb358b', 1, 2, NULL, 'lunch_break', 'js', 'Break', 'active', NULL, NULL, '2025-06-21 00:42:31', '2025-06-21 00:42:31'),
(171, '9f34afb7-7258-4d6b-bebb-2b349f2fe284', 1, 2, NULL, 'break_time_greater_than_zero', 'js', 'Break From time must be greater than Zero', 'active', NULL, NULL, '2025-06-21 00:42:31', '2025-06-21 00:42:31'),
(172, '9f34afb7-73a5-45a3-9901-e732ae228337', 1, 2, NULL, 'break_to_time_greater_than_zero', 'js', 'Break To time must be greater than Zero', 'active', NULL, NULL, '2025-06-21 00:42:31', '2025-06-21 00:42:31'),
(173, '9f34afb7-74d2-4453-b895-f98e51ba6732', 1, 2, NULL, 'break_to_time_greater_than_from_time', 'js', 'Break To time must be greater than Break From time.', 'active', NULL, NULL, '2025-06-21 00:42:31', '2025-06-21 00:42:31'),
(174, '9f34afb7-75fa-43f6-8d68-9f1e9eb1dcb3', 1, 2, NULL, 'date_required', 'js', 'Date field is required', 'active', NULL, NULL, '2025-06-21 00:42:31', '2025-06-21 00:42:31'),
(175, '9f34afb7-772a-44f4-ae8a-1ffaf2e1a025', 1, 2, NULL, 'discount_less_than_amount', 'js', 'The discount should be less than the total amount.', 'active', NULL, NULL, '2025-06-21 00:42:31', '2025-06-21 00:42:31'),
(176, '9f34afb7-7853-4dd4-b513-13e913ee5e3f', 1, 2, NULL, 'select_category', 'js', 'Select Category', 'active', NULL, NULL, '2025-06-21 00:42:31', '2025-06-21 00:42:31'),
(177, '9f34afb7-797a-4514-b25f-c9f114eff3e7', 1, 2, NULL, 'update_quantity', 'js', 'Update quantity should be less than previous quantity.', 'active', NULL, NULL, '2025-06-21 00:42:31', '2025-06-21 00:42:31'),
(178, '9f34afb7-7aa6-4641-9b2b-c2514b2b3bec', 1, 2, NULL, 'tax_less_100', 'js', 'Taxes should be less than 100%.', 'active', NULL, NULL, '2025-06-21 00:42:31', '2025-06-21 00:42:31'),
(179, '9f34afb7-7bd0-402b-b85f-59ea080e5c6b', 1, 2, NULL, 'net_amount_not_empty', 'js', 'Net amount can not be empty.', 'active', NULL, NULL, '2025-06-21 00:42:31', '2025-06-21 00:42:31'),
(180, '9f34afb7-7d09-4328-b5da-4a01ad6a853c', 1, 2, NULL, 'net_amount_not_zero', 'js', 'Net amount can not be zero.', 'active', NULL, NULL, '2025-06-21 00:42:31', '2025-06-21 00:42:31'),
(181, '9f34afb7-7e42-4a47-a915-1d8f521379c9', 1, 2, NULL, 'quantity_not_empty', 'js', 'Quantity cannot be zero or empty.', 'active', NULL, NULL, '2025-06-21 00:42:31', '2025-06-21 00:42:31'),
(182, '9f34afb7-7f7f-45b3-82f1-714eafdf26ac', 1, 2, NULL, 'select_patient', 'js', 'Select Patient', 'active', NULL, NULL, '2025-06-21 00:42:31', '2025-06-21 00:42:31'),
(183, '9f34afb7-80aa-43b0-af18-cd878e4b7c36', 1, 2, NULL, 'medicine_bill', 'js', 'Medicine Bill', 'active', NULL, NULL, '2025-06-21 00:42:31', '2025-06-21 00:42:31'),
(184, '9f34afb7-81e2-48d1-a9be-acaa5595a72c', 1, 2, NULL, 'medicine_bill_already_use', 'js', 'This medicine is already used in medicine bills, are you sure want to delete it?', 'active', NULL, NULL, '2025-06-21 00:42:31', '2025-06-21 00:42:31'),
(185, '9f34afb7-8315-45e5-a9f1-0d2f9a2952b4', 1, 2, NULL, 'select_service', 'js', 'Select Service', 'active', NULL, NULL, '2025-06-21 00:42:31', '2025-06-21 00:42:31'),
(186, '9f34afb7-8431-4a54-93ef-fda3cc84e1d4', 1, 2, NULL, 'select_parameter_name', 'js', 'Select Parameter Name', 'active', NULL, NULL, '2025-06-21 00:42:31', '2025-06-21 00:42:31'),
(187, '9f34afb7-8555-42bd-8a17-585df36dd745', 1, 2, NULL, 'active', 'js', 'Active', 'active', NULL, NULL, '2025-06-21 00:42:31', '2025-06-21 00:42:31'),
(188, '9f34afb7-8678-4060-99dc-ce95c82603ee', 1, 2, NULL, 'deactive', 'js', 'Deactive', 'active', NULL, NULL, '2025-06-21 00:42:31', '2025-06-21 00:42:31'),
(189, '9f34afb7-87b3-4fdc-b5db-2c502ac0f544', 1, 2, NULL, 'select_duration', 'js', 'Select Duration', 'active', NULL, NULL, '2025-06-21 00:42:31', '2025-06-21 00:42:31'),
(190, '9f34afb7-88ff-4051-8813-973f27ee4808', 1, 2, NULL, 'select_dose_interval', 'js', 'Select Dose Interval', 'active', NULL, NULL, '2025-06-21 00:42:31', '2025-06-21 00:42:31'),
(191, '9f34afb7-8a42-4cbf-b478-91576b67fd9b', 1, 2, NULL, 'enter_lot_no', 'js', 'Enter lot number .', 'active', NULL, NULL, '2025-06-21 00:42:31', '2025-06-21 00:42:31'),
(192, '9f34afb7-8b66-4a46-b2d0-afb86e03cbac', 1, 2, NULL, 'enter_sale_price', 'js', 'Enter sale price.', 'active', NULL, NULL, '2025-06-21 00:42:31', '2025-06-21 00:42:31'),
(193, '9f34afb7-8c97-43dd-9b10-bea3ab40d7b1', 1, 2, NULL, 'enter_purchase_price', 'js', 'Enter purchase price.', 'active', NULL, NULL, '2025-06-21 00:42:31', '2025-06-21 00:42:31'),
(194, '9f34afb7-8db7-4145-9a5d-97059017e213', 1, 2, NULL, 'quantity_greater_than_0', 'js', 'Quantity should be greater than 0.', 'active', NULL, NULL, '2025-06-21 00:42:31', '2025-06-21 00:42:31'),
(195, '9f34afb7-8ee3-40d7-a1e1-42aabc5ebaa8', 1, 2, NULL, 'tax_not_empty', 'js', 'The tax amount can not be zero or empty.', 'active', NULL, NULL, '2025-06-21 00:42:31', '2025-06-21 00:42:31'),
(196, '9f34afb7-9032-4e16-a629-f9487508f29b', 1, 2, NULL, 'purchase_medicine', 'js', 'Purchase Medicine', 'active', NULL, NULL, '2025-06-21 00:42:31', '2025-06-21 00:42:31'),
(197, '9f34afb7-953b-4875-89d4-4507ab3d0141', 1, 2, NULL, 'select_charge', 'js', 'Select Charge', 'active', NULL, NULL, '2025-06-21 00:42:31', '2025-06-21 00:42:31'),
(198, '9f34afb7-9698-490e-ae7a-3855f96b2342', 1, 2, NULL, 'stripe_key', 'js', 'Please enter Stripe key.', 'active', NULL, NULL, '2025-06-21 00:42:31', '2025-06-21 00:42:31'),
(199, '9f34afb7-97bc-4e6a-9941-d4dadd2c5104', 1, 2, NULL, 'stripe_secret', 'js', 'Please enter Stripe Secret', 'active', NULL, NULL, '2025-06-21 00:42:31', '2025-06-21 00:42:31'),
(200, '9f34afb7-98ec-4a0c-b125-c80647626d64', 1, 2, NULL, 'paypal_client_id', 'js', 'Please enter Paypal Client ID', 'active', NULL, NULL, '2025-06-21 00:42:31', '2025-06-21 00:42:31'),
(201, '9f34afb7-9a21-4e5c-9328-3c11d0b1e4e9', 1, 2, NULL, 'paypal_secret', 'js', 'Please enter paypal secret.', 'active', NULL, NULL, '2025-06-21 00:42:31', '2025-06-21 00:42:31'),
(202, '9f34afb7-9b5f-4f7c-abd2-89b5c2b26f3a', 1, 2, NULL, 'paypal_mode', 'js', 'Please enter paypal mode.', 'active', NULL, NULL, '2025-06-21 00:42:31', '2025-06-21 00:42:31'),
(203, '9f34afb7-9c8a-4845-b2bc-dacf648ef046', 1, 2, NULL, 'razorpay_key', 'js', 'Please enter razorpay key.', 'active', NULL, NULL, '2025-06-21 00:42:31', '2025-06-21 00:42:31'),
(204, '9f34afb7-9dbe-428e-b0cb-c5e79dab2d5d', 1, 2, NULL, 'razor_pay_secret', 'js', 'Please enter razorpay Secret.', 'active', NULL, NULL, '2025-06-21 00:42:31', '2025-06-21 00:42:31'),
(205, '9f34afb7-9ee9-41a9-82d5-9a5f6c290116', 1, 2, NULL, 'paytm_id', 'js', 'Please enter paytm merchant Id.', 'active', NULL, NULL, '2025-06-21 00:42:31', '2025-06-21 00:42:31'),
(206, '9f34afb7-a024-4641-9019-b03b77726f64', 1, 2, NULL, 'paytm_key', 'js', 'Please enter paytm merchant Key.', 'active', NULL, NULL, '2025-06-21 00:42:31', '2025-06-21 00:42:31'),
(207, '9f34afb7-a170-4870-8668-22a4a57d1b82', 1, 2, NULL, 'paystack_key', 'js', 'Please enter paystack public Key.', 'active', NULL, NULL, '2025-06-21 00:42:31', '2025-06-21 00:42:31'),
(208, '9f34afb7-a29e-48ad-954c-ea374c358885', 1, 2, NULL, 'paystack_secret', 'js', 'Please enter paystack secret Key.', 'active', NULL, NULL, '2025-06-21 00:42:31', '2025-06-21 00:42:31'),
(209, '9f34afb7-a3cd-4826-86e1-b650fb6eab19', 1, 2, NULL, 'card_template', 'js', 'Patient Smart Card Template', 'active', NULL, NULL, '2025-06-21 00:42:31', '2025-06-21 00:42:31'),
(210, '9f34afb7-a4f2-41d3-80e9-92ebf7453d2b', 1, 2, NULL, 'smart_patient_card', 'js', 'Patient Smart Card', 'active', NULL, NULL, '2025-06-21 00:42:31', '2025-06-21 00:42:31'),
(211, '9f34afb7-a619-41a0-bb91-324c95e65c20', 1, 2, NULL, 'template_required', 'js', 'Template Name field is required.', 'active', NULL, NULL, '2025-06-21 00:42:31', '2025-06-21 00:42:31'),
(212, '9f34afb7-a782-47ae-b96e-1b429e1f76e3', 1, 2, NULL, 'patient_required', 'js', 'Patient field is required.', 'active', NULL, NULL, '2025-06-21 00:42:31', '2025-06-21 00:42:31'),
(213, '9f34afb7-a9d4-4fb4-b8f5-59656b49e00b', 1, 2, NULL, 'qr_code_not_found', 'js', 'QR code not found.', 'active', NULL, NULL, '2025-06-21 00:42:31', '2025-06-21 00:42:31'),
(214, '9f34afb7-ab80-401d-ae19-2b0895edccab', 1, 2, NULL, 'charchter_160', 'js', 'The message may not be greater than 160 characters.', 'active', NULL, NULL, '2025-06-21 00:42:31', '2025-06-21 00:42:31'),
(215, '9f34afb7-ad29-49fc-a7ca-ed99d9aff49b', 1, 2, NULL, 'captcha_key', 'js', 'Please enter Google captcha Key.', 'active', NULL, NULL, '2025-06-21 00:42:31', '2025-06-21 00:42:31'),
(216, '9f34afb7-aecf-43c8-8bf2-9c8fd282cbfa', 1, 2, NULL, 'captcha_secret', 'js', 'Please enter Google captcha Secret.', 'active', NULL, NULL, '2025-06-21 00:42:31', '2025-06-21 00:42:31'),
(217, '9f34afb7-b07d-4737-8f64-a7a7990ff0b7', 1, 2, NULL, 'phone_number', 'js', 'Phone Number', 'active', NULL, NULL, '2025-06-21 00:42:31', '2025-06-21 00:42:31'),
(218, '9f34afb7-b231-46d9-ba89-67181c88def0', 1, 2, NULL, 'all_required_fields', 'js', 'Please fill all the required fields.', 'active', NULL, NULL, '2025-06-21 00:42:31', '2025-06-21 00:42:31'),
(219, '9f34afb7-b3b7-4e4c-96c2-406fede13f85', 1, 2, NULL, 'select_doctors', 'js', 'Select Doctors', 'active', NULL, NULL, '2025-06-21 00:42:31', '2025-06-21 00:42:31'),
(220, '9f34afb7-b52e-4dbf-a996-81f2d387fcbf', 1, 2, NULL, 'patient_not_exists_or_status_is_not_active', 'js', 'Patient not exists or status is not active.', 'active', NULL, NULL, '2025-06-21 00:42:31', '2025-06-21 00:42:31'),
(221, '9f34afb7-b6aa-42b5-aa0d-bffb29d4ea6b', 1, 2, NULL, 'password_not_match', 'js', 'Password and Confirm password not match.', 'active', NULL, NULL, '2025-06-21 00:42:31', '2025-06-21 00:42:31'),
(222, '9f34afb7-b823-4276-ad2e-4218a1000898', 1, 2, NULL, 'disconnect_or_reconnect', 'js', 'Please disconnect and reconnect your google calendar', 'active', NULL, NULL, '2025-06-21 00:42:31', '2025-06-21 00:42:31'),
(223, '9f34afb7-b9b1-4c6a-8167-8c6436fc1169', 1, 2, NULL, 'select_calendar', 'js', 'Please select a calendar.', 'active', NULL, NULL, '2025-06-21 00:42:31', '2025-06-21 00:42:31'),
(224, '9f34afb7-bb60-4055-822c-829d02e6bd50', 1, 2, NULL, 'value_must_be_greter_then', 'js', 'Value must be greter then 1', 'active', NULL, NULL, '2025-06-21 00:42:31', '2025-06-21 00:42:31'),
(225, '9f34afb7-bd21-401a-bb2c-ef34987be6e0', 1, 2, NULL, 'value_field_required', 'js', 'The value field is required.', 'active', NULL, NULL, '2025-06-21 00:42:31', '2025-06-21 00:42:31'),
(226, '9f34afb7-bece-4d48-9b0f-3dc7f7678c2b', 1, 2, NULL, 'select_blood_group', 'js', 'Select Blood Group', 'active', NULL, NULL, '2025-06-21 00:42:31', '2025-06-21 00:42:31'),
(227, '9f34afb7-c06e-497c-9d42-9c41f0ff517a', 1, 2, NULL, 'google_meet', 'js', 'Google Meet', 'active', NULL, NULL, '2025-06-21 00:42:31', '2025-06-21 00:42:31'),
(228, '9f34afb7-c257-475c-9d31-552c486c001d', 1, 2, NULL, 'zoom', 'js', 'Zoom', 'active', NULL, NULL, '2025-06-21 00:42:31', '2025-06-21 00:42:31'),
(229, '9f34afb7-c42a-4f08-8813-96b7799b0c49', 1, 2, NULL, 'field_required', 'js', 'field is Required.', 'active', NULL, NULL, '2025-06-21 00:42:31', '2025-06-21 00:42:31'),
(230, '9f34afb7-c5dd-4114-9cd9-4ddf765a7a47', 1, 2, NULL, 'payment_type', 'js', 'Choose Payment Type', 'active', NULL, NULL, '2025-06-21 00:42:31', '2025-06-21 00:42:31'),
(231, '9f34afb7-c91b-403a-9f31-4cb70c8eb02e', 1, 2, NULL, 'expiry_date', 'js', 'Expiry Date', 'active', NULL, NULL, '2025-06-21 00:42:31', '2025-06-21 00:42:31'),
(232, '9f34afb7-cac1-4dec-853b-f2194c19fd1a', 1, 2, NULL, 'bill_date', 'js', 'Please Select Bill Date.', 'active', NULL, NULL, '2025-06-21 00:42:31', '2025-06-21 00:42:31'),
(233, '9f34afb7-cc1e-43fd-bf5e-dc06f0882a37', 1, 2, NULL, 'select_medicine_category', 'js', 'Please Select Medication Category', 'active', NULL, NULL, '2025-06-21 00:42:31', '2025-06-21 00:42:31'),
(234, '9f34afb7-cd6b-4387-bd1f-5b8debeeb312', 1, 2, NULL, 'amount_not_zero', 'js', 'Amount can not be zero.', 'active', NULL, NULL, '2025-06-21 00:42:31', '2025-06-21 00:42:31'),
(235, '9f34afb7-cebc-4fe9-9ab6-4c7055d40f2c', 1, 2, NULL, 'phonepe_merchant_id', 'js', 'Please enter Phonepe Merchant Id.', 'active', NULL, NULL, '2025-06-21 00:42:31', '2025-06-21 00:42:31'),
(236, '9f34afb7-d002-4194-ba81-5337e89b0014', 1, 2, NULL, 'phonepe_merchant_user_id', 'js', 'Please enter Phonepe Merchant User Id.', 'active', NULL, NULL, '2025-06-21 00:42:31', '2025-06-21 00:42:31'),
(237, '9f34afb7-d141-4782-9bd8-7e287930e142', 1, 2, NULL, 'phonepe_env', 'js', 'Please enter Phonepe Env.', 'active', NULL, NULL, '2025-06-21 00:42:31', '2025-06-21 00:42:31'),
(238, '9f34afb7-d26c-4c8c-ab0a-3bdf2ae709d7', 1, 2, NULL, 'phonepe_salt_key', 'js', 'Please enter Phonepe Salt Key.', 'active', NULL, NULL, '2025-06-21 00:42:31', '2025-06-21 00:42:31'),
(239, '9f34afb7-d391-4d1a-9cc4-ac63e0715a69', 1, 2, NULL, 'phonepe_salt_index', 'js', 'Please enter Phonepe Salt Index.', 'active', NULL, NULL, '2025-06-21 00:42:31', '2025-06-21 00:42:31'),
(240, '9f34afb7-d4bd-4856-948b-5dd2a7b0e414', 1, 2, NULL, 'phonepe_merchant_transaction_id', 'js', 'Please enter Phonepe Merchant Transaction Id .', 'active', NULL, NULL, '2025-06-21 00:42:31', '2025-06-21 00:42:31'),
(241, '9f34afb7-d5ec-4042-a8e7-d9a9e0cef2f1', 1, 2, NULL, 'flutterWave_public_key', 'js', 'Please enter FlutterWave Public Key.', 'active', NULL, NULL, '2025-06-21 00:42:31', '2025-06-21 00:42:31'),
(242, '9f34afb7-d723-4ff2-95aa-334c631f6e04', 1, 2, NULL, 'flutterWave_secret_key', 'js', 'Please enter FlutterWave secret Key.', 'active', NULL, NULL, '2025-06-21 00:42:31', '2025-06-21 00:42:31'),
(243, '9f34afb7-d851-4c8b-8c9a-ffa9e11d94f8', 1, 2, NULL, 'open_ai_key', 'js', 'Please enter Openai Key.', 'active', NULL, NULL, '2025-06-21 00:42:31', '2025-06-21 00:42:31'),
(244, '9f34afb7-d97f-4798-bf97-04a5b9d6e97d', 1, 2, NULL, 'fill_physical_info', 'js', 'Fill Any Details Of Physical information.', 'active', NULL, NULL, '2025-06-21 00:42:31', '2025-06-21 00:42:31'),
(245, '9f34afb7-dacb-43da-bafa-0fccfc0146bc', 1, 2, NULL, 'hospital_type', 'js', 'Hospital Type', 'active', NULL, NULL, '2025-06-21 00:42:31', '2025-06-21 00:42:31'),
(246, '9f34afb7-dc05-48bb-9431-1b65828acd5a', 1, 2, NULL, 'hospital', 'js', 'Hospital', 'active', NULL, NULL, '2025-06-21 00:42:31', '2025-06-21 00:42:31'),
(247, '9f34afb7-dd35-4e04-96ba-9f8774cbbc15', 1, 2, NULL, 'n/a', 'js', 'Not Available', 'active', NULL, NULL, '2025-06-21 00:42:31', '2025-06-21 00:42:31'),
(248, '9f34afb7-de67-455d-a9dd-0c0b49c37e13', 1, 2, NULL, 'pending', 'js', 'Pending', 'active', NULL, NULL, '2025-06-21 00:42:31', '2025-06-21 00:42:31'),
(249, '9f34afb7-df98-498a-ac32-bc22ce6f7e15', 1, 2, NULL, 'completed', 'js', 'Completed', 'active', NULL, NULL, '2025-06-21 00:42:31', '2025-06-21 00:42:31'),
(250, '9f34afb7-e0c5-4888-96e8-1398470875ce', 1, 2, NULL, 'old_patient_email_exists', 'js', 'Email already exists, please select old patient.', 'active', NULL, NULL, '2025-06-21 00:42:31', '2025-06-21 00:42:31'),
(251, '9f34afb7-e1fe-450f-9ad9-34bdf355a662', 1, 2, NULL, 'appointment_saved', 'js', 'Appointment saved successfully.', 'active', NULL, NULL, '2025-06-21 00:42:31', '2025-06-21 00:42:31'),
(252, '9f34afb7-e367-441c-aadc-b3d85f1d4554', 1, 3, NULL, 'admin_details', 'messages', 'Admin Details', 'active', NULL, NULL, '2025-06-21 00:42:31', '2025-06-21 00:42:31'),
(253, '9f34afb7-e47b-4164-9c9a-1a38af15446d', 1, 3, NULL, 'admins', 'messages', 'Admins', 'active', NULL, NULL, '2025-06-21 00:42:31', '2025-06-21 00:42:31'),
(254, '9f34afb7-e582-4cb3-a7f7-4dd9b3806e34', 1, 3, NULL, 'admin', 'messages', 'Admin', 'active', NULL, NULL, '2025-06-21 00:42:31', '2025-06-21 00:42:31'),
(255, '9f34afb7-e690-413b-8b34-36268b72c920', 1, 3, NULL, 'roles', 'messages', 'Roles', 'active', NULL, NULL, '2025-06-21 00:42:31', '2025-06-21 00:42:31'),
(256, '9f34afb7-e7a3-4e8c-8cbc-f7248917c2fb', 1, 3, NULL, 'doctor_departments', 'messages', 'Doctor Departments', 'active', NULL, NULL, '2025-06-21 00:42:31', '2025-06-21 00:42:31'),
(257, '9f34afb7-e8bc-492b-94ca-4bdf552bb1a0', 1, 3, NULL, 'nurses', 'messages', 'Nurses', 'active', NULL, NULL, '2025-06-21 00:42:31', '2025-06-21 00:42:31'),
(258, '9f34afb7-e9c8-4e8d-9f5f-0bae35c6f819', 1, 3, NULL, 'doctors', 'messages', 'Doctors', 'active', NULL, NULL, '2025-06-21 00:42:31', '2025-06-21 00:42:31'),
(259, '9f34afb7-eb25-4947-9b00-379cd1f1624c', 1, 3, NULL, 'patients', 'messages', 'Patients', 'active', NULL, NULL, '2025-06-21 00:42:31', '2025-06-21 00:42:31'),
(260, '9f34afb7-ec4a-4681-a5ee-182ccbb546b1', 1, 3, NULL, 'lab_technicians', 'messages', 'Lab Technicians', 'active', NULL, NULL, '2025-06-21 00:42:31', '2025-06-21 00:42:31'),
(261, '9f34afb7-ed7c-488e-8d81-171268d852bc', 1, 3, NULL, 'receptionists', 'messages', 'Receptionists', 'active', NULL, NULL, '2025-06-21 00:42:31', '2025-06-21 00:42:31'),
(262, '9f34afb7-ee99-4c68-9688-3250b72c5432', 1, 3, NULL, 'pharmacists', 'messages', 'Pharmacists', 'active', NULL, NULL, '2025-06-21 00:42:31', '2025-06-21 00:42:31'),
(263, '9f34afb7-efa6-4a9a-80e4-a7d226a9935c', 1, 3, NULL, 'accountants', 'messages', 'Accountants', 'active', NULL, NULL, '2025-06-21 00:42:31', '2025-06-21 00:42:31'),
(264, '9f34afb7-f0cd-45ac-ae32-44802688dcd3', 1, 3, NULL, 'appointments', 'messages', 'Appointments', 'active', NULL, NULL, '2025-06-21 00:42:31', '2025-06-21 00:42:31'),
(265, '9f34afb7-f200-46d7-a00d-641abf2c0530', 1, 3, NULL, 'insurances', 'messages', 'Insurances', 'active', NULL, NULL, '2025-06-21 00:42:31', '2025-06-21 00:42:31'),
(266, '9f34afb7-f30e-4bb7-a285-2df12acef761', 1, 3, NULL, 'investigation_reports', 'messages', 'Investigation Reports', 'active', NULL, NULL, '2025-06-21 00:42:31', '2025-06-21 00:42:31'),
(267, '9f34afb7-f41f-4287-91a9-d9782db57688', 1, 3, NULL, 'death_reports', 'messages', 'Death Reports', 'active', NULL, NULL, '2025-06-21 00:42:31', '2025-06-21 00:42:31'),
(268, '9f34afb7-f530-495e-99ba-bd873f4a29a0', 1, 3, NULL, 'birth_reports', 'messages', 'Birth Reports', 'active', NULL, NULL, '2025-06-21 00:42:31', '2025-06-21 00:42:31'),
(269, '9f34afb7-f836-4d01-ab7b-726845c50cdb', 1, 3, NULL, 'operation_reports', 'messages', 'Operation Reports', 'active', NULL, NULL, '2025-06-21 00:42:31', '2025-06-21 00:42:31'),
(270, '9f34afb7-f959-4067-ad59-381489a60b56', 1, 3, NULL, 'medicine_categories', 'messages', 'Medicine Categories', 'active', NULL, NULL, '2025-06-21 00:42:31', '2025-06-21 00:42:31'),
(271, '9f34afb7-fa77-4dd4-a82d-a84d0243982a', 1, 3, NULL, 'medicine_brands', 'messages', 'Medicine Brands', 'active', NULL, NULL, '2025-06-21 00:42:31', '2025-06-21 00:42:31'),
(272, '9f34afb7-fb8e-415a-8724-dd80203dc3df', 1, 3, NULL, 'medicines', 'messages', 'Medicines', 'active', NULL, NULL, '2025-06-21 00:42:31', '2025-06-21 00:42:31'),
(273, '9f34afb7-fca2-4115-b0b8-78eb4fdd0a8c', 1, 3, NULL, 'cases', 'messages', 'Cases', 'active', NULL, NULL, '2025-06-21 00:42:31', '2025-06-21 00:42:31'),
(274, '9f34afb7-fdbf-4f88-9f4e-a643ebecae80', 1, 3, NULL, 'case_handlers', 'messages', 'Case Handlers', 'active', NULL, NULL, '2025-06-21 00:42:31', '2025-06-21 00:42:31'),
(275, '9f34afb7-fee5-413a-b364-bd10cdddec8b', 1, 3, NULL, 'bed_types', 'messages', 'Bed Types', 'active', NULL, NULL, '2025-06-21 00:42:31', '2025-06-21 00:42:31'),
(276, '9f34afb8-0002-4dbe-abc2-c83cad643d42', 1, 3, NULL, 'beds', 'messages', 'Beds', 'active', NULL, NULL, '2025-06-21 00:42:31', '2025-06-21 00:42:31'),
(277, '9f34afb8-0114-487a-a2bd-bf3770c9c6b2', 1, 3, NULL, 'bed_assigns', 'messages', 'Bed Assigns', 'active', NULL, NULL, '2025-06-21 00:42:31', '2025-06-21 00:42:31'),
(278, '9f34afb8-0222-4930-917f-457dc40fa54a', 1, 3, NULL, 'packages', 'messages', 'Packages', 'active', NULL, NULL, '2025-06-21 00:42:31', '2025-06-21 00:42:31'),
(279, '9f34afb8-0354-422c-a3be-508f7c56ecdf', 1, 3, NULL, 'schedules', 'messages', 'Schedules', 'active', NULL, NULL, '2025-06-21 00:42:31', '2025-06-21 00:42:31'),
(280, '9f34afb8-048d-4f03-a273-5339d6e23710', 1, 3, NULL, 'schedule_label', 'messages', 'Schedule', 'active', NULL, NULL, '2025-06-21 00:42:31', '2025-06-21 00:42:31'),
(281, '9f34afb8-05ab-4470-889d-5e445f395026', 1, 3, NULL, 'services', 'messages', 'Services', 'active', NULL, NULL, '2025-06-21 00:42:31', '2025-06-21 00:42:31'),
(282, '9f34afb8-06c0-462c-bb8b-c5fddc30a578', 1, 3, NULL, 'accounts', 'messages', 'Accounts', 'active', NULL, NULL, '2025-06-21 00:42:31', '2025-06-21 00:42:31'),
(283, '9f34afb8-07d3-40ed-96f6-bc9798541fbb', 1, 3, NULL, 'payments', 'messages', 'Payments', 'active', NULL, NULL, '2025-06-21 00:42:31', '2025-06-21 00:42:31'),
(284, '9f34afb8-08e6-4a40-bcfb-0bc8bf671ba0', 1, 3, NULL, 'bills', 'messages', 'Bills', 'active', NULL, NULL, '2025-06-21 00:42:31', '2025-06-21 00:42:31'),
(285, '9f34afb8-09f7-4626-baa4-b62d5ab6c046', 1, 3, NULL, 'employee_payrolls', 'messages', 'Employee Payrolls', 'active', NULL, NULL, '2025-06-21 00:42:31', '2025-06-21 00:42:31');
INSERT INTO `ltu_phrases` (`id`, `uuid`, `translation_id`, `translation_file_id`, `phrase_id`, `key`, `group`, `value`, `status`, `parameters`, `note`, `created_at`, `updated_at`) VALUES
(286, '9f34afb8-0b12-40ac-b4aa-5da9180e2ba2', 1, 3, NULL, 'documents', 'messages', 'Documents', 'active', NULL, NULL, '2025-06-21 00:42:31', '2025-06-21 00:42:31'),
(287, '9f34afb8-0c29-4a5f-954c-0a3f58687be5', 1, 3, NULL, 'document_types', 'messages', 'Document Types', 'active', NULL, NULL, '2025-06-21 00:42:31', '2025-06-21 00:42:31'),
(288, '9f34afb8-0d4d-4f4c-8ace-6c9a57e334df', 1, 3, NULL, 'notice_boards', 'messages', 'Notice Boards', 'active', NULL, NULL, '2025-06-21 00:42:31', '2025-06-21 00:42:31'),
(289, '9f34afb8-0e6d-48b7-a55c-a89dbb9dec4c', 1, 3, NULL, 'settings', 'messages', 'Settings', 'active', NULL, NULL, '2025-06-21 00:42:31', '2025-06-21 00:42:31'),
(290, '9f34afb8-0f8d-42d0-8ce6-3ac25385d6d7', 1, 3, NULL, 'doctors_list', 'messages', 'Doctors List', 'active', NULL, NULL, '2025-06-21 00:42:31', '2025-06-21 00:42:31'),
(291, '9f34afb8-109f-4c94-9d50-10c33b67d320', 1, 3, NULL, 'my_payrolls', 'messages', 'Payrolls', 'active', NULL, NULL, '2025-06-21 00:42:31', '2025-06-21 00:42:31'),
(292, '9f34afb8-11b9-47ea-897a-eb07dd1e6934', 1, 3, NULL, 'blood_banks', 'messages', 'Blood Banks', 'active', NULL, NULL, '2025-06-21 00:42:31', '2025-06-21 00:42:31'),
(293, '9f34afb8-12d8-4929-a0bc-dda315b0f584', 1, 3, NULL, 'blood_donors', 'messages', 'Blood Donors', 'active', NULL, NULL, '2025-06-21 00:42:31', '2025-06-21 00:42:31'),
(294, '9f34afb8-13f7-47e6-b61e-aada98b45924', 1, 3, NULL, 'invoices', 'messages', 'Invoices', 'active', NULL, NULL, '2025-06-21 00:42:31', '2025-06-21 00:42:31'),
(295, '9f34afb8-1523-44ef-93c2-6662481a872b', 1, 3, NULL, 'patients_cases', 'messages', 'Patients Cases', 'active', NULL, NULL, '2025-06-21 00:42:31', '2025-06-21 00:42:31'),
(296, '9f34afb8-163b-4a18-9310-8c1fac4c3f17', 1, 3, NULL, 'patients_case_details', 'messages', 'Patients Case Details', 'active', NULL, NULL, '2025-06-21 00:42:31', '2025-06-21 00:42:31'),
(297, '9f34afb8-174e-484e-b562-f233c9038f6d', 1, 3, NULL, 'account_manager', 'messages', 'Account Manager', 'active', NULL, NULL, '2025-06-21 00:42:31', '2025-06-21 00:42:31'),
(298, '9f34afb8-186e-49ab-bc15-f26116af7e0e', 1, 3, NULL, 'bed_management', 'messages', 'Bed Management', 'active', NULL, NULL, '2025-06-21 00:42:31', '2025-06-21 00:42:31'),
(299, '9f34afb8-1987-4e2b-9a0d-613c9a7824dc', 1, 3, NULL, 'blood_bank', 'messages', 'Blood Bank', 'active', NULL, NULL, '2025-06-21 00:42:31', '2025-06-21 00:42:31'),
(300, '9f34afb8-1a9f-4333-9a87-c8284f986238', 1, 3, NULL, 'billing', 'messages', 'Billing', 'active', NULL, NULL, '2025-06-21 00:42:31', '2025-06-21 00:42:31'),
(301, '9f34afb8-1bb1-463b-bb80-4562c1f9a143', 1, 3, NULL, 'case_manager', 'messages', 'Case Manager', 'active', NULL, NULL, '2025-06-21 00:42:31', '2025-06-21 00:42:31'),
(302, '9f34afb8-1cc8-4884-955b-295ca0aa5302', 1, 3, NULL, 'cms', 'messages', 'CMS', 'active', NULL, NULL, '2025-06-21 00:42:31', '2025-06-21 00:42:31'),
(303, '9f34afb8-1ddb-43c8-aa72-4b9df0261228', 1, 3, NULL, 'front_cms_services', 'messages', 'Front CMS Services', 'active', NULL, NULL, '2025-06-21 00:42:31', '2025-06-21 00:42:31'),
(304, '9f34afb8-1f2b-4a6e-9de0-475b94e35813', 1, 3, NULL, 'department', 'messages', 'Department', 'active', NULL, NULL, '2025-06-21 00:42:31', '2025-06-21 00:42:31'),
(305, '9f34afb8-204f-41f7-af61-497e7e71503c', 1, 3, NULL, 'departments', 'messages', 'Departments', 'active', NULL, NULL, '2025-06-21 00:42:31', '2025-06-21 00:42:31'),
(306, '9f34afb8-216a-488d-af93-e47c1f701d68', 1, 3, NULL, 'hospital_activities', 'messages', 'Hospital Activities', 'active', NULL, NULL, '2025-06-21 00:42:31', '2025-06-21 00:42:31'),
(307, '9f34afb8-2282-4ee5-a8c0-851a6e53d5eb', 1, 3, NULL, 'advanced_payments', 'messages', 'Advance Payments', 'active', NULL, NULL, '2025-06-21 00:42:31', '2025-06-21 00:42:31'),
(308, '9f34afb8-23a0-4dc9-87f8-3c5b48eeb4af', 1, 3, NULL, 'patient_admissions', 'messages', 'Patient Admissions', 'active', NULL, NULL, '2025-06-21 00:42:31', '2025-06-21 00:42:31'),
(309, '9f34afb8-24be-488e-86c0-89d0af284dc5', 1, 3, NULL, 'appointment_calendar', 'messages', 'Appoint. Calendar', 'active', NULL, NULL, '2025-06-21 00:42:31', '2025-06-21 00:42:31'),
(310, '9f34afb8-25e7-4a73-a060-f5318ed22b2e', 1, 3, NULL, 'bed_mgt', 'messages', 'Bed Management', 'active', NULL, NULL, '2025-06-21 00:42:31', '2025-06-21 00:42:31'),
(311, '9f34afb8-2709-49fe-a901-6537c906c84b', 1, 3, NULL, 'reports', 'messages', 'Reports', 'active', NULL, NULL, '2025-06-21 00:42:31', '2025-06-21 00:42:31'),
(312, '9f34afb8-2829-49cd-b5ce-86ea9701ec54', 1, 3, NULL, 'enquiries', 'messages', 'Enquiries', 'active', NULL, NULL, '2025-06-21 00:42:31', '2025-06-21 00:42:31'),
(313, '9f34afb8-294d-4201-84ae-727d4122c7c4', 1, 3, NULL, 'mail', 'messages', 'Mail', 'active', NULL, NULL, '2025-06-21 00:42:31', '2025-06-21 00:42:31'),
(314, '9f34afb8-2b9b-4943-8487-efd6d375c7de', 1, 3, NULL, 'ambulances', 'messages', 'Ambulances', 'active', NULL, NULL, '2025-06-21 00:42:31', '2025-06-21 00:42:31'),
(315, '9f34afb8-2d0f-4eca-8f12-1ac36e4668cd', 1, 3, NULL, 'ambulance_calls', 'messages', 'Ambulance Calls', 'active', NULL, NULL, '2025-06-21 00:42:31', '2025-06-21 00:42:31'),
(316, '9f34afb8-2e32-49cb-8b28-0e27762b3be1', 1, 3, NULL, 'prescriptions', 'messages', 'Prescriptions', 'active', NULL, NULL, '2025-06-21 00:42:31', '2025-06-21 00:42:31'),
(317, '9f34afb8-2f4e-40b5-9401-b8edb9a4ac59', 1, 3, NULL, 'hospital_charges', 'messages', 'Hospital Charges', 'active', NULL, NULL, '2025-06-21 00:42:31', '2025-06-21 00:42:31'),
(318, '9f34afb8-3069-4754-a146-13638d28ea08', 1, 3, NULL, 'charge_categories', 'messages', 'Charge Categories', 'active', NULL, NULL, '2025-06-21 00:42:31', '2025-06-21 00:42:31'),
(319, '9f34afb8-3184-4630-9f71-70ab51e3e30c', 1, 3, NULL, 'charges', 'messages', 'Charges', 'active', NULL, NULL, '2025-06-21 00:42:31', '2025-06-21 00:42:31'),
(320, '9f34afb8-3298-40d6-9a7f-1fcec368c8fc', 1, 3, NULL, 'radiologies', 'messages', 'Radiology', 'active', NULL, NULL, '2025-06-21 00:42:32', '2025-06-21 00:42:32'),
(321, '9f34afb8-33b2-4beb-9556-e688bc8a5050', 1, 3, NULL, 'radiology_categories', 'messages', 'Radiology Category', 'active', NULL, NULL, '2025-06-21 00:42:32', '2025-06-21 00:42:32'),
(322, '9f34afb8-34cb-4fed-ac1d-f50c29a9b836', 1, 3, NULL, 'pathologies', 'messages', 'Pathology', 'active', NULL, NULL, '2025-06-21 00:42:32', '2025-06-21 00:42:32'),
(323, '9f34afb8-35df-47c5-96af-f0eafab566c0', 1, 3, NULL, 'pathology_categories', 'messages', 'Pathology Category', 'active', NULL, NULL, '2025-06-21 00:42:32', '2025-06-21 00:42:32'),
(324, '9f34afb8-38b7-411f-a6b4-f7228a4b884e', 1, 3, NULL, 'radiology_tests', 'messages', 'Radiology Tests', 'active', NULL, NULL, '2025-06-21 00:42:32', '2025-06-21 00:42:32'),
(325, '9f34afb8-39e0-4ac6-a6aa-bbfed137f5ea', 1, 3, NULL, 'doctor_opd_charges', 'messages', 'Doctor OPD Charges', 'active', NULL, NULL, '2025-06-21 00:42:32', '2025-06-21 00:42:32'),
(326, '9f34afb8-3b08-477a-a899-5950e9013380', 1, 3, NULL, 'pathology_tests', 'messages', 'Pathology Tests', 'active', NULL, NULL, '2025-06-21 00:42:32', '2025-06-21 00:42:32'),
(327, '9f34afb8-3c1f-44a0-940e-6ea0b615b67d', 1, 3, NULL, 'expenses', 'messages', 'Expenses', 'active', NULL, NULL, '2025-06-21 00:42:32', '2025-06-21 00:42:32'),
(328, '9f34afb8-3d7a-4e62-ae4b-745e442144c9', 1, 3, NULL, 'income', 'messages', 'Income', 'active', NULL, NULL, '2025-06-21 00:42:32', '2025-06-21 00:42:32'),
(329, '9f34afb8-3ea4-46e1-93af-fda1c1ba16ba', 1, 3, NULL, 'finance', 'messages', 'Finance', 'active', NULL, NULL, '2025-06-21 00:42:32', '2025-06-21 00:42:32'),
(330, '9f34afb8-3fc5-4557-8cab-f7b4db105ac0', 1, 3, NULL, 'issued_items', 'messages', 'Issued Items', 'active', NULL, NULL, '2025-06-21 00:42:32', '2025-06-21 00:42:32'),
(331, '9f34afb8-40e1-4b20-8afc-a30c9aaaec93', 1, 3, NULL, 'ipd_patients', 'messages', 'IPD Patients', 'active', NULL, NULL, '2025-06-21 00:42:32', '2025-06-21 00:42:32'),
(332, '9f34afb8-41fe-4610-a716-63284658c767', 1, 3, NULL, 'ipd_opd', 'messages', 'IPD/OPD', 'active', NULL, NULL, '2025-06-21 00:42:32', '2025-06-21 00:42:32'),
(333, '9f34afb8-4310-4274-91ad-2b6dfc2d7917', 1, 3, NULL, 'ipd_diagnosis', 'messages', 'Diagnosis', 'active', NULL, NULL, '2025-06-21 00:42:32', '2025-06-21 00:42:32'),
(334, '9f34afb8-4439-4e1d-86bf-b844cab940d4', 1, 3, NULL, 'ipd_consultant_register', 'messages', 'Consultant Instruction', 'active', NULL, NULL, '2025-06-21 00:42:32', '2025-06-21 00:42:32'),
(335, '9f34afb8-455e-4f60-9b61-fea62bec6f50', 1, 3, NULL, 'ipd_charges', 'messages', 'Charges', 'active', NULL, NULL, '2025-06-21 00:42:32', '2025-06-21 00:42:32'),
(336, '9f34afb8-4679-48e6-8516-3ab786084d1d', 1, 3, NULL, 'ipd_prescription', 'messages', 'Prescriptions', 'active', NULL, NULL, '2025-06-21 00:42:32', '2025-06-21 00:42:32'),
(337, '9f34afb8-47a2-4685-a3c0-aa819d7586ec', 1, 3, NULL, 'ipd_timelines', 'messages', 'Timelines', 'active', NULL, NULL, '2025-06-21 00:42:32', '2025-06-21 00:42:32'),
(338, '9f34afb8-48ec-450c-b1d9-18bb6c74c596', 1, 3, NULL, 'opd_patients', 'messages', 'OPD Patients', 'active', NULL, NULL, '2025-06-21 00:42:32', '2025-06-21 00:42:32'),
(339, '9f34afb8-4a0e-4738-959d-2b6e7655902e', 1, 3, NULL, 'call_logs', 'messages', 'Call Logs', 'active', NULL, NULL, '2025-06-21 00:42:32', '2025-06-21 00:42:32'),
(340, '9f34afb8-4b2d-43e4-9e1f-5f5858f98425', 1, 3, NULL, 'visitors', 'messages', 'Visitors', 'active', NULL, NULL, '2025-06-21 00:42:32', '2025-06-21 00:42:32'),
(341, '9f34afb8-4c5f-465e-a021-beac6194c2c4', 1, 3, NULL, 'front_office', 'messages', 'Front Office', 'active', NULL, NULL, '2025-06-21 00:42:32', '2025-06-21 00:42:32'),
(342, '9f34afb8-4d7e-4987-983a-ea6b71a9bc4c', 1, 3, NULL, 'postal_receive', 'messages', 'Postal Receive', 'active', NULL, NULL, '2025-06-21 00:42:32', '2025-06-21 00:42:32'),
(343, '9f34afb8-4e97-4441-b58b-4a4238c37547', 1, 3, NULL, 'postal_dispatch', 'messages', 'Postal Dispatch', 'active', NULL, NULL, '2025-06-21 00:42:32', '2025-06-21 00:42:32'),
(344, '9f34afb8-4fc8-40be-97b9-59dfc1a0a31d', 1, 3, NULL, 'inventory', 'messages', 'Inventory', 'active', NULL, NULL, '2025-06-21 00:42:32', '2025-06-21 00:42:32'),
(345, '9f34afb8-50eb-49cb-b20e-d6b2ba65bc77', 1, 3, NULL, 'items_categories', 'messages', 'Items Categories', 'active', NULL, NULL, '2025-06-21 00:42:32', '2025-06-21 00:42:32'),
(346, '9f34afb8-5205-4889-ac34-91225d1923d2', 1, 3, NULL, 'items', 'messages', 'Items', 'active', NULL, NULL, '2025-06-21 00:42:32', '2025-06-21 00:42:32'),
(347, '9f34afb8-5323-4bc4-bc5a-7a1f57249411', 1, 3, NULL, 'items_stocks', 'messages', 'Item Stocks', 'active', NULL, NULL, '2025-06-21 00:42:32', '2025-06-21 00:42:32'),
(348, '9f34afb8-5447-4d9b-8643-1bdcd0a85272', 1, 3, NULL, 'general', 'messages', 'General', 'active', NULL, NULL, '2025-06-21 00:42:32', '2025-06-21 00:42:32'),
(349, '9f34afb8-5580-4dc2-b969-42b29c60e169', 1, 3, NULL, 'sidebar_setting', 'messages', 'Sidebar Setting', 'active', NULL, NULL, '2025-06-21 00:42:32', '2025-06-21 00:42:32'),
(350, '9f34afb8-56ad-492c-8850-7796ed7f1da8', 1, 3, NULL, 'testimonials', 'messages', 'Testimonials', 'active', NULL, NULL, '2025-06-21 00:42:32', '2025-06-21 00:42:32'),
(351, '9f34afb8-57cb-4b55-84ed-624d9dc930fc', 1, 3, NULL, 'blood_donations', 'messages', 'Blood Donations', 'active', NULL, NULL, '2025-06-21 00:42:32', '2025-06-21 00:42:32'),
(352, '9f34afb8-58ed-4ab6-badd-f7e61839d80d', 1, 3, NULL, 'blood_issues', 'messages', 'Blood Issues', 'active', NULL, NULL, '2025-06-21 00:42:32', '2025-06-21 00:42:32'),
(353, '9f34afb8-5a0f-42ec-96b8-ec1fcc4330dd', 1, 3, NULL, 'live_consultations', 'messages', 'Live Consultations', 'active', NULL, NULL, '2025-06-21 00:42:32', '2025-06-21 00:42:32'),
(354, '9f34afb8-5b36-4b21-b139-5c7839af4189', 1, 3, NULL, 'live_meetings', 'messages', 'Live Meetings', 'active', NULL, NULL, '2025-06-21 00:42:32', '2025-06-21 00:42:32'),
(355, '9f34afb8-5c51-4d6a-9d0d-5db87030a12c', 1, 3, NULL, 'vaccinations', 'messages', 'Vaccinations', 'active', NULL, NULL, '2025-06-21 00:42:32', '2025-06-21 00:42:32'),
(356, '9f34afb8-5d6a-4753-9af9-60badabeb8d8', 1, 3, NULL, 'vaccinated_patients', 'messages', 'Vaccinated Patients', 'active', NULL, NULL, '2025-06-21 00:42:32', '2025-06-21 00:42:32'),
(357, '9f34afb8-5e7d-486a-b7d7-745db5f706e6', 1, 3, NULL, 'users', 'messages', 'Users', 'active', NULL, NULL, '2025-06-21 00:42:32', '2025-06-21 00:42:32'),
(358, '9f34afb8-5f9e-4994-916e-ac1ba07a0591', 1, 3, NULL, 'posts', 'messages', 'Posts', 'active', NULL, NULL, '2025-06-21 00:42:32', '2025-06-21 00:42:32'),
(359, '9f34afb8-60c7-4abc-94ca-f17d68015cb3', 1, 3, NULL, 'front_settings', 'messages', 'Front Settings', 'active', NULL, NULL, '2025-06-21 00:42:32', '2025-06-21 00:42:32'),
(360, '9f34afb8-61df-4e53-a15c-27f0f8987b08', 1, 3, NULL, 'about_us', 'messages', 'About Us', 'active', NULL, NULL, '2025-06-21 00:42:32', '2025-06-21 00:42:32'),
(361, '9f34afb8-62fd-4bb6-a993-ec5f5a3180fe', 1, 3, NULL, 'make_an_appointment', 'messages', 'Make An Appointment', 'active', NULL, NULL, '2025-06-21 00:42:32', '2025-06-21 00:42:32'),
(362, '9f34afb8-641c-4f86-bede-3dda2c6638a9', 1, 3, NULL, 'patient_appointment', 'messages', 'Patient Appointment', 'active', NULL, NULL, '2025-06-21 00:42:32', '2025-06-21 00:42:32'),
(363, '9f34afb8-6571-4ef3-b30b-f758fd7d71ea', 1, 3, NULL, 'old_patient', 'messages', 'Old Patient', 'active', NULL, NULL, '2025-06-21 00:42:32', '2025-06-21 00:42:32'),
(364, '9f34afb8-66d7-4f12-a133-986ec39581b0', 1, 3, NULL, 'new_patient', 'messages', 'New Patient', 'active', NULL, NULL, '2025-06-21 00:42:32', '2025-06-21 00:42:32'),
(365, '9f34afb8-6802-4488-a72a-6400e18b477b', 1, 3, NULL, 'available_slot', 'messages', 'Available Slot', 'active', NULL, NULL, '2025-06-21 00:42:32', '2025-06-21 00:42:32'),
(366, '9f34afb8-692b-49fc-b45a-dfaeb44b1d87', 1, 3, NULL, 'available_slots', 'messages', 'Available Slots', 'active', NULL, NULL, '2025-06-21 00:42:32', '2025-06-21 00:42:32'),
(367, '9f34afb8-6a4c-47c3-92eb-649010a7831e', 1, 3, NULL, 'contact_us', 'messages', 'Contact Us', 'active', NULL, NULL, '2025-06-21 00:42:32', '2025-06-21 00:42:32'),
(368, '9f34afb8-6b69-4acf-8537-3e8dab007cba', 1, 3, NULL, 'short_description', 'messages', 'Short Description', 'active', NULL, NULL, '2025-06-21 00:42:32', '2025-06-21 00:42:32'),
(369, '9f34afb8-6c8d-4504-99fd-a82f9664b81a', 1, 3, NULL, 'icon', 'messages', 'Icon', 'active', NULL, NULL, '2025-06-21 00:42:32', '2025-06-21 00:42:32'),
(370, '9f34afb8-6db4-40b8-a4dc-be39ef86ccc6', 1, 3, NULL, 'front_cms', 'messages', 'Front CMS', 'active', NULL, NULL, '2025-06-21 00:42:32', '2025-06-21 00:42:32'),
(371, '9f34afb8-6ecd-4df0-b033-6b7d6451951c', 1, 3, NULL, 'facebook_url', 'messages', 'Facebook URL', 'active', NULL, NULL, '2025-06-21 00:42:32', '2025-06-21 00:42:32'),
(372, '9f34afb8-6ff8-4f2f-b472-aec30bb58ea8', 1, 3, NULL, 'twitter_url', 'messages', 'Twitter URL', 'active', NULL, NULL, '2025-06-21 00:42:32', '2025-06-21 00:42:32'),
(373, '9f34afb8-713c-40d2-a5ce-361ac0500d14', 1, 3, NULL, 'instagram_url', 'messages', 'Instagram URL', 'active', NULL, NULL, '2025-06-21 00:42:32', '2025-06-21 00:42:32'),
(374, '9f34afb8-7274-45b0-87f6-b15e57472e5e', 1, 3, NULL, 'linkedIn_url', 'messages', 'LinkedIn URL', 'active', NULL, NULL, '2025-06-21 00:42:32', '2025-06-21 00:42:32'),
(375, '9f34afb8-739b-48b4-b415-7a88275c3874', 1, 3, NULL, 'hospital_schedule', 'messages', 'Hospital Schedule', 'active', NULL, NULL, '2025-06-21 00:42:32', '2025-06-21 00:42:32'),
(376, '9f34afb8-74c2-493b-8d3b-79673756491d', 1, 3, NULL, 'impersonate', 'messages', 'Impersonate', 'active', NULL, NULL, '2025-06-21 00:42:32', '2025-06-21 00:42:32'),
(377, '9f34afb8-75e1-488a-a801-d57d1fe1b112', 1, 3, NULL, 'subscription_plan', 'messages', 'Subscription Plan', 'active', NULL, NULL, '2025-06-21 00:42:32', '2025-06-21 00:42:32'),
(378, '9f34afb8-7709-4b6b-a912-84c21501512a', 1, 3, NULL, 'subscription_days_plan_not_found', 'messages', 'We couldn\'t find any days subscription plans', 'active', NULL, NULL, '2025-06-21 00:42:32', '2025-06-21 00:42:32'),
(379, '9f34afb8-782d-4755-8916-422922d80c90', 1, 3, NULL, 'subscription_month_plan_not_found', 'messages', 'We couldn\'t find any month subscription plans', 'active', NULL, NULL, '2025-06-21 00:42:32', '2025-06-21 00:42:32'),
(380, '9f34afb8-794b-4374-86b8-3fc4d2f11647', 1, 3, NULL, 'subscription_year_plan_not_found', 'messages', 'We couldn\'t find any year subscription plans', 'active', NULL, NULL, '2025-06-21 00:42:32', '2025-06-21 00:42:32'),
(381, '9f34afb8-7a6f-4585-9a19-883aaee08de4', 1, 3, NULL, 'subscription_plan_not_found', 'messages', 'Subscription Plan Not Found', 'active', NULL, NULL, '2025-06-21 00:42:32', '2025-06-21 00:42:32'),
(382, '9f34afb8-7b94-4bd2-88a4-cfa674e3d424', 1, 3, NULL, 'month', 'messages', 'Month', 'active', NULL, NULL, '2025-06-21 00:42:32', '2025-06-21 00:42:32'),
(383, '9f34afb8-7cb2-4313-b1eb-5bacd7af6899', 1, 3, NULL, 'year', 'messages', 'Year', 'active', NULL, NULL, '2025-06-21 00:42:32', '2025-06-21 00:42:32'),
(384, '9f34afb8-7dea-42e4-a321-4b4f71470676', 1, 3, NULL, 'day', 'messages', 'Day', 'active', NULL, NULL, '2025-06-21 00:42:32', '2025-06-21 00:42:32'),
(385, '9f34afb8-7f2a-4032-b9b4-dcf77dbc988e', 1, 3, NULL, 'file_name', 'messages', 'File Name', 'active', NULL, NULL, '2025-06-21 00:42:32', '2025-06-21 00:42:32'),
(386, '9f34afb8-8062-4751-97b5-e02dadf4a1df', 1, 3, NULL, 'view_all', 'messages', 'View All', 'active', NULL, NULL, '2025-06-21 00:42:32', '2025-06-21 00:42:32'),
(387, '9f34afb8-818c-4965-a498-7996b6a96c2c', 1, 3, NULL, 'hospitals', 'messages', 'Hospitals', 'active', NULL, NULL, '2025-06-21 00:42:32', '2025-06-21 00:42:32'),
(388, '9f34afb8-82af-4d70-b007-381ad4562419', 1, 3, NULL, 'hospitals_type', 'messages', 'Hospital Type', 'active', NULL, NULL, '2025-06-21 00:42:32', '2025-06-21 00:42:32'),
(389, '9f34afb8-83d3-45fb-9626-9944e36a5975', 1, 3, NULL, 'hospital', 'messages', 'Hospital', 'active', NULL, NULL, '2025-06-21 00:42:32', '2025-06-21 00:42:32'),
(390, '9f34afb8-84ef-4f4f-a12b-244e9350d9d5', 1, 3, NULL, 'hospital_details', 'messages', 'Hospital Details', 'active', NULL, NULL, '2025-06-21 00:42:32', '2025-06-21 00:42:32'),
(391, '9f34afb8-8613-4a89-99ca-ba1aa6b4dd62', 1, 3, NULL, 'overview', 'messages', 'Overview', 'active', NULL, NULL, '2025-06-21 00:42:32', '2025-06-21 00:42:32'),
(392, '9f34afb8-873d-4b6a-8875-8437490c8e94', 1, 3, NULL, 'billings', 'messages', 'Billings', 'active', NULL, NULL, '2025-06-21 00:42:32', '2025-06-21 00:42:32'),
(393, '9f34afb8-8866-4370-afb0-5778fc01b224', 1, 3, NULL, 'billing_detail', 'messages', 'Billing Detail', 'active', NULL, NULL, '2025-06-21 00:42:32', '2025-06-21 00:42:32'),
(394, '9f34afb8-8992-49e3-8442-34faf869b155', 1, 3, NULL, 'our_hospitals', 'messages', 'Our Hospitals', 'active', NULL, NULL, '2025-06-21 00:42:32', '2025-06-21 00:42:32'),
(395, '9f34afb8-8ad2-4be6-b6f3-97d005ec2242', 1, 3, NULL, 'hospital_schedules', 'messages', 'Hospital Schedules', 'active', NULL, NULL, '2025-06-21 00:42:32', '2025-06-21 00:42:32'),
(396, '9f34afb8-8bfb-4bdc-8aaf-3cf61e59f8b3', 1, 3, NULL, 'plan_expire_notifications', 'messages', 'Plan Expire Notification (in Days)', 'active', NULL, NULL, '2025-06-21 00:42:32', '2025-06-21 00:42:32'),
(397, '9f34afb8-8e5a-43e5-bbf4-632167745023', 1, 3, NULL, 'valid', 'messages', 'Valid', 'active', NULL, NULL, '2025-06-21 00:42:32', '2025-06-21 00:42:32'),
(398, '9f34afb8-8fa4-4957-acce-7233e77d721b', 1, 3, NULL, 'paytm', 'messages', 'Paytm', 'active', NULL, NULL, '2025-06-21 00:42:32', '2025-06-21 00:42:32'),
(399, '9f34afb8-90f3-48ea-9b05-1e477e9b9765', 1, 3, NULL, 'appointment_charge', 'messages', 'Appointment Charge', 'active', NULL, NULL, '2025-06-21 00:42:32', '2025-06-21 00:42:32'),
(400, '9f34afb8-9245-46da-a938-988b127f1b71', 1, 3, NULL, 'manual_billing_payments', 'messages', 'Manual Billing Payments', 'active', NULL, NULL, '2025-06-21 00:42:32', '2025-06-21 00:42:32'),
(401, '9f34afb8-937f-4d6d-b356-17efd4d8d9db', 1, 3, NULL, 'faq', 'messages', 'FAQ', 'active', NULL, NULL, '2025-06-21 00:42:32', '2025-06-21 00:42:32'),
(402, '9f34afb8-94b1-4ce0-900e-0083e47bdad4', 1, 3, NULL, 'paid', 'messages', 'Paid', 'active', NULL, NULL, '2025-06-21 00:42:32', '2025-06-21 00:42:32'),
(403, '9f34afb8-95e6-424c-96dc-32145c2538c6', 1, 3, NULL, 'unpaid', 'messages', 'Unpaid', 'active', NULL, NULL, '2025-06-21 00:42:32', '2025-06-21 00:42:32'),
(404, '9f34afb8-9719-4eff-ba96-641336b07986', 1, 3, NULL, 'hospital_type', 'messages', 'Hospital Type', 'active', NULL, NULL, '2025-06-21 00:42:32', '2025-06-21 00:42:32'),
(405, '9f34afb8-9859-425a-9e37-26ec4e179848', 1, 3, NULL, 'minutes', 'messages', 'Minutes', 'active', NULL, NULL, '2025-06-21 00:42:32', '2025-06-21 00:42:32'),
(406, '9f34afb8-999e-44e4-9758-44e0f3cdd2b1', 1, 3, NULL, 'hours', 'messages', 'Hours', 'active', NULL, NULL, '2025-06-21 00:42:32', '2025-06-21 00:42:32'),
(407, '9f34afb8-9ad3-4235-aa7b-fafcc773be33', 1, 3, NULL, 'hospital_count', 'messages', 'Hospital Count', 'active', NULL, NULL, '2025-06-21 00:42:32', '2025-06-21 00:42:32'),
(408, '9f34afb8-9c02-4fbd-8945-b5260b8d42bd', 1, 3, NULL, 'language.Arabic', 'messages', 'Arabic', 'active', NULL, NULL, '2025-06-21 00:42:32', '2025-06-21 00:42:32'),
(409, '9f34afb8-9d2b-4f83-906b-c8312a455181', 1, 3, NULL, 'language.Chinese', 'messages', 'Chinese', 'active', NULL, NULL, '2025-06-21 00:42:32', '2025-06-21 00:42:32'),
(410, '9f34afb8-9e58-43cd-b6b3-a116b4dc4346', 1, 3, NULL, 'language.English', 'messages', 'English', 'active', NULL, NULL, '2025-06-21 00:42:32', '2025-06-21 00:42:32'),
(411, '9f34afb8-9f89-47fc-a33b-b26f1407c85f', 1, 3, NULL, 'language.French', 'messages', 'French', 'active', NULL, NULL, '2025-06-21 00:42:32', '2025-06-21 00:42:32'),
(412, '9f34afb8-a0b6-44bf-b2b1-efcec32da157', 1, 3, NULL, 'language.German', 'messages', 'German', 'active', NULL, NULL, '2025-06-21 00:42:32', '2025-06-21 00:42:32'),
(413, '9f34afb8-a1e6-4f6a-a77e-fefa7e00fad8', 1, 3, NULL, 'language.Portuguese', 'messages', 'Portuguese', 'active', NULL, NULL, '2025-06-21 00:42:32', '2025-06-21 00:42:32'),
(414, '9f34afb8-a30e-4fce-ba3c-85bd846a699a', 1, 3, NULL, 'language.Russian', 'messages', 'Russian', 'active', NULL, NULL, '2025-06-21 00:42:32', '2025-06-21 00:42:32'),
(415, '9f34afb8-a493-4598-8afe-5cc0ab97d208', 1, 3, NULL, 'language.Spanish', 'messages', 'Spanish', 'active', NULL, NULL, '2025-06-21 00:42:32', '2025-06-21 00:42:32'),
(416, '9f34afb8-a5e0-476e-907a-64754256c98c', 1, 3, NULL, 'language.Turkish', 'messages', 'Spanish', 'active', NULL, NULL, '2025-06-21 00:42:32', '2025-06-21 00:42:32'),
(417, '9f34afb8-a720-466d-b513-946cfc037165', 1, 3, NULL, 'admin_user.new_admin', 'messages', 'New Admin', 'active', NULL, NULL, '2025-06-21 00:42:32', '2025-06-21 00:42:32'),
(418, '9f34afb8-a864-438b-a835-69bf676937eb', 1, 3, NULL, 'admin_user.admin_saved_successfully', 'messages', 'Admin saved successfully', 'active', NULL, NULL, '2025-06-21 00:42:32', '2025-06-21 00:42:32'),
(419, '9f34afb8-a995-4e00-a709-64f6fed7ff89', 1, 3, NULL, 'admin_user.admin_updated_successfully', 'messages', 'Admin updated successfully', 'active', NULL, NULL, '2025-06-21 00:42:32', '2025-06-21 00:42:32'),
(420, '9f34afb8-aac7-4cf0-a4f0-6f77803d0b29', 1, 3, NULL, 'admin_user.admin_deleted_successfully', 'messages', 'Admin deleted successfully', 'active', NULL, NULL, '2025-06-21 00:42:32', '2025-06-21 00:42:32'),
(421, '9f34afb8-abf6-4ebc-b59f-5576e56c332d', 1, 3, NULL, 'role.new_role', 'messages', 'New Role', 'active', NULL, NULL, '2025-06-21 00:42:32', '2025-06-21 00:42:32'),
(422, '9f34afb8-ad1c-4263-928c-2046af965bf6', 1, 3, NULL, 'role.edit_role', 'messages', 'Edit Role', 'active', NULL, NULL, '2025-06-21 00:42:32', '2025-06-21 00:42:32'),
(423, '9f34afb8-ae5f-4cda-911b-7ea98de559ed', 1, 3, NULL, 'role.admin', 'messages', 'Admin', 'active', NULL, NULL, '2025-06-21 00:42:32', '2025-06-21 00:42:32'),
(424, '9f34afb8-afb1-4397-8b14-1b07e32f2b62', 1, 3, NULL, 'role.doctor', 'messages', 'Doctor', 'active', NULL, NULL, '2025-06-21 00:42:32', '2025-06-21 00:42:32'),
(425, '9f34afb8-b0f3-47d8-b6c2-f73ea2f6a663', 1, 3, NULL, 'role.patient', 'messages', 'Patient', 'active', NULL, NULL, '2025-06-21 00:42:32', '2025-06-21 00:42:32'),
(426, '9f34afb8-b235-4fbb-b830-7b466afb4a73', 1, 3, NULL, 'role.nurse', 'messages', 'Nurse', 'active', NULL, NULL, '2025-06-21 00:42:32', '2025-06-21 00:42:32'),
(427, '9f34afb8-b36a-49a6-87fc-89f3498c5234', 1, 3, NULL, 'role.receptionist', 'messages', 'Receptionist', 'active', NULL, NULL, '2025-06-21 00:42:32', '2025-06-21 00:42:32'),
(428, '9f34afb8-b4ad-4364-9bb5-2c05e62c844c', 1, 3, NULL, 'role.pharmacist', 'messages', 'Pharmacist', 'active', NULL, NULL, '2025-06-21 00:42:32', '2025-06-21 00:42:32'),
(429, '9f34afb8-b5e6-4004-b995-4fbc44fd6b1c', 1, 3, NULL, 'role.accountant', 'messages', 'Accountant', 'active', NULL, NULL, '2025-06-21 00:42:32', '2025-06-21 00:42:32'),
(430, '9f34afb8-b72e-4001-ae90-1d5ac513693d', 1, 3, NULL, 'role.case_manager', 'messages', 'Case Manager', 'active', NULL, NULL, '2025-06-21 00:42:32', '2025-06-21 00:42:32'),
(431, '9f34afb8-b87e-4a17-98f9-9fa4ff5de7ea', 1, 3, NULL, 'role.lab_technician', 'messages', 'Lab Technician', 'active', NULL, NULL, '2025-06-21 00:42:32', '2025-06-21 00:42:32'),
(432, '9f34afb8-b9b1-4c66-bea8-57bbfc005f11', 1, 3, NULL, 'filter.all', 'messages', 'All', 'active', NULL, NULL, '2025-06-21 00:42:32', '2025-06-21 00:42:32'),
(433, '9f34afb8-baeb-442c-97eb-071f96c98958', 1, 3, NULL, 'filter.active', 'messages', 'Active', 'active', NULL, NULL, '2025-06-21 00:42:32', '2025-06-21 00:42:32'),
(434, '9f34afb8-bc20-42a2-99ec-1df6b302f0b9', 1, 3, NULL, 'filter.deactive', 'messages', 'Deactive', 'active', NULL, NULL, '2025-06-21 00:42:32', '2025-06-21 00:42:32'),
(435, '9f34afb8-bd53-480c-8441-c70d9a5c6ccd', 1, 3, NULL, 'filter.inactive', 'messages', 'Inactive', 'active', NULL, NULL, '2025-06-21 00:42:32', '2025-06-21 00:42:32'),
(436, '9f34afb8-be85-43e4-98ca-0efd41dcaf80', 1, 3, NULL, 'user.first_name', 'messages', 'First Name', 'active', NULL, NULL, '2025-06-21 00:42:32', '2025-06-21 00:42:32'),
(437, '9f34afb8-bfbf-4121-a24c-88f981ecca7b', 1, 3, NULL, 'user.last_name', 'messages', 'Last Name', 'active', NULL, NULL, '2025-06-21 00:42:32', '2025-06-21 00:42:32'),
(438, '9f34afb8-c0f2-41a4-8064-7944bd70b86e', 1, 3, NULL, 'user.username', 'messages', 'Username', 'active', NULL, NULL, '2025-06-21 00:42:32', '2025-06-21 00:42:32'),
(439, '9f34afb8-c261-4681-ab11-fcf10646d819', 1, 3, NULL, 'user.name', 'messages', 'Name', 'active', NULL, NULL, '2025-06-21 00:42:32', '2025-06-21 00:42:32'),
(440, '9f34afb8-c399-4774-b580-652c15d11cf5', 1, 3, NULL, 'user.email', 'messages', 'Email', 'active', NULL, NULL, '2025-06-21 00:42:32', '2025-06-21 00:42:32'),
(441, '9f34afb8-c4d4-4658-8385-9c3428d83bc8', 1, 3, NULL, 'user.phone', 'messages', 'Phone', 'active', NULL, NULL, '2025-06-21 00:42:32', '2025-06-21 00:42:32'),
(442, '9f34afb8-c609-47e9-962c-e5746f88d1ed', 1, 3, NULL, 'user.designation', 'messages', 'Designation', 'active', NULL, NULL, '2025-06-21 00:42:32', '2025-06-21 00:42:32'),
(443, '9f34afb8-c73e-4e73-a0c7-884fbf375a08', 1, 3, NULL, 'user.gender', 'messages', 'Gender', 'active', NULL, NULL, '2025-06-21 00:42:32', '2025-06-21 00:42:32'),
(444, '9f34afb8-c876-4ae4-b9e5-4e30f3998baf', 1, 3, NULL, 'user.male', 'messages', 'Male', 'active', NULL, NULL, '2025-06-21 00:42:32', '2025-06-21 00:42:32'),
(445, '9f34afb8-c9ae-4b3f-a1ef-3ae066dbfcfb', 1, 3, NULL, 'user.female', 'messages', 'Female', 'active', NULL, NULL, '2025-06-21 00:42:32', '2025-06-21 00:42:32'),
(446, '9f34afb8-caea-4046-9a56-fd5187ac924a', 1, 3, NULL, 'user.qualification', 'messages', 'Qualification', 'active', NULL, NULL, '2025-06-21 00:42:32', '2025-06-21 00:42:32'),
(447, '9f34afb8-cc1f-4e75-900e-380fa7e88b89', 1, 3, NULL, 'user.dob', 'messages', 'Date Of Birth', 'active', NULL, NULL, '2025-06-21 00:42:32', '2025-06-21 00:42:32'),
(448, '9f34afb8-cd53-42f6-885e-632243216fe4', 1, 3, NULL, 'user.blood_group', 'messages', 'Blood Group', 'active', NULL, NULL, '2025-06-21 00:42:32', '2025-06-21 00:42:32'),
(449, '9f34afb8-ceb8-422f-9466-c51438f83bf0', 1, 3, NULL, 'user.select_blood_group', 'messages', 'Select Blood Group', 'active', NULL, NULL, '2025-06-21 00:42:32', '2025-06-21 00:42:32'),
(450, '9f34afb8-cffd-48fa-9575-bbbba596bd8f', 1, 3, NULL, 'user.select_donor_name', 'messages', 'Select Donor Name', 'active', NULL, NULL, '2025-06-21 00:42:32', '2025-06-21 00:42:32'),
(451, '9f34afb8-d135-4f06-8ec6-566b02690cb1', 1, 3, NULL, 'user.select_patient_name', 'messages', 'Select Patient Name', 'active', NULL, NULL, '2025-06-21 00:42:32', '2025-06-21 00:42:32'),
(452, '9f34afb8-d265-4b0f-9998-13b1c71db4ad', 1, 3, NULL, 'user.password', 'messages', 'Password', 'active', NULL, NULL, '2025-06-21 00:42:32', '2025-06-21 00:42:32'),
(453, '9f34afb8-d399-4ef1-a13f-de7ea4a702f9', 1, 3, NULL, 'user.password_confirmation', 'messages', 'Confirm Password', 'active', NULL, NULL, '2025-06-21 00:42:32', '2025-06-21 00:42:32'),
(454, '9f34afb8-d4cd-4c76-a954-2168426eb3da', 1, 3, NULL, 'user.address1', 'messages', 'Address 1', 'active', NULL, NULL, '2025-06-21 00:42:32', '2025-06-21 00:42:32'),
(455, '9f34afb8-d606-4019-a7f6-ac9823df01d5', 1, 3, NULL, 'user.address2', 'messages', 'Address 2', 'active', NULL, NULL, '2025-06-21 00:42:32', '2025-06-21 00:42:32'),
(456, '9f34afb8-d738-40b0-bf2b-5310e3c6c851', 1, 3, NULL, 'user.city', 'messages', 'City', 'active', NULL, NULL, '2025-06-21 00:42:32', '2025-06-21 00:42:32'),
(457, '9f34afb8-d867-4276-b855-04bb7a674d32', 1, 3, NULL, 'user.zip', 'messages', 'Zip', 'active', NULL, NULL, '2025-06-21 00:42:32', '2025-06-21 00:42:32'),
(458, '9f34afb8-d997-4b38-8380-63b10fb35a12', 1, 3, NULL, 'user.address_details', 'messages', 'Address Details', 'active', NULL, NULL, '2025-06-21 00:42:32', '2025-06-21 00:42:32'),
(459, '9f34afb8-dacf-4d14-860e-cef288f84e2b', 1, 3, NULL, 'user.address_not_found', 'messages', 'No Address details found', 'active', NULL, NULL, '2025-06-21 00:42:32', '2025-06-21 00:42:32'),
(460, '9f34afb8-dc04-44e0-ba28-ea77682a3124', 1, 3, NULL, 'user.education', 'messages', 'Education', 'active', NULL, NULL, '2025-06-21 00:42:32', '2025-06-21 00:42:32'),
(461, '9f34afb8-dd40-49c8-8c0e-de3cdda96abe', 1, 3, NULL, 'user.status', 'messages', 'Status', 'active', NULL, NULL, '2025-06-21 00:42:32', '2025-06-21 00:42:32'),
(462, '9f34afb8-de88-43fe-8ed4-12eac9aa8687', 1, 3, NULL, 'user.edit_profile', 'messages', 'Edit Profile', 'active', NULL, NULL, '2025-06-21 00:42:32', '2025-06-21 00:42:32'),
(463, '9f34afb8-e001-4fe0-b8cb-c25de53f547c', 1, 3, NULL, 'user.change_password', 'messages', 'Change Password', 'active', NULL, NULL, '2025-06-21 00:42:32', '2025-06-21 00:42:32'),
(464, '9f34afb8-e17b-48dc-bd32-43470b9e3b5c', 1, 3, NULL, 'user.logout', 'messages', 'Logout', 'active', NULL, NULL, '2025-06-21 00:42:32', '2025-06-21 00:42:32'),
(465, '9f34afb8-e32e-4c01-ad70-000b13a53288', 1, 3, NULL, 'user.new_user', 'messages', 'New User', 'active', NULL, NULL, '2025-06-21 00:42:32', '2025-06-21 00:42:32'),
(466, '9f34afb8-e47d-453e-a9b3-c41d5254f5e5', 1, 3, NULL, 'user.edit_user', 'messages', 'Edit User', 'active', NULL, NULL, '2025-06-21 00:42:32', '2025-06-21 00:42:32'),
(467, '9f34afb8-e5c6-4ad0-8a58-b02f2e71ad7e', 1, 3, NULL, 'user.user_details', 'messages', 'User Details', 'active', NULL, NULL, '2025-06-21 00:42:32', '2025-06-21 00:42:32'),
(468, '9f34afb8-e71d-4eef-8efb-869c0b55215e', 1, 3, NULL, 'user.email_verified', 'messages', 'Email Verified', 'active', NULL, NULL, '2025-06-21 00:42:32', '2025-06-21 00:42:32'),
(469, '9f34afb8-e898-4b1b-bc5b-fbf8b502843d', 1, 3, NULL, 'user.email_not_verified', 'messages', 'Email Not Verified', 'active', NULL, NULL, '2025-06-21 00:42:32', '2025-06-21 00:42:32'),
(470, '9f34afb8-ea28-48ea-84d5-c355ff8cb01b', 1, 3, NULL, 'user.back_to_admin', 'messages', 'Back To Super Admin', 'active', NULL, NULL, '2025-06-21 00:42:32', '2025-06-21 00:42:32'),
(471, '9f34afb8-ed2b-4ec8-9b1b-48fb0b70abb4', 1, 3, NULL, 'user.hospital_slug', 'messages', 'Hospital Slug', 'active', NULL, NULL, '2025-06-21 00:42:32', '2025-06-21 00:42:32'),
(472, '9f34afb8-ee94-4071-b6d3-6f9a1a451b97', 1, 3, NULL, 'user.enter_hospital_name', 'messages', 'Enter Hospital Name', 'active', NULL, NULL, '2025-06-21 00:42:32', '2025-06-21 00:42:32'),
(473, '9f34afb8-effb-45b0-b968-82777df614cd', 1, 3, NULL, 'user.enter_hospital_slug', 'messages', 'Enter Hospital Slug', 'active', NULL, NULL, '2025-06-21 00:42:32', '2025-06-21 00:42:32'),
(474, '9f34afb8-f13f-4f50-8d72-b0aa0b468213', 1, 3, NULL, 'user.enter_email', 'messages', 'Enter Email', 'active', NULL, NULL, '2025-06-21 00:42:32', '2025-06-21 00:42:32'),
(475, '9f34afb8-f28d-48ea-9760-96d3909ccaf4', 1, 3, NULL, 'post.name', 'messages', 'Name', 'active', NULL, NULL, '2025-06-21 00:42:32', '2025-06-21 00:42:32'),
(476, '9f34afb8-f3e3-437b-9ec1-3ddd12bc19ad', 1, 3, NULL, 'post.description', 'messages', 'Description', 'active', NULL, NULL, '2025-06-21 00:42:32', '2025-06-21 00:42:32'),
(477, '9f34afb8-f52a-4075-b567-ef90021897cd', 1, 3, NULL, 'post.new_post', 'messages', 'New Post', 'active', NULL, NULL, '2025-06-21 00:42:32', '2025-06-21 00:42:32'),
(478, '9f34afb8-f66d-48e1-abdf-e97f25b5516c', 1, 3, NULL, 'post.edit_post', 'messages', 'Edit Post', 'active', NULL, NULL, '2025-06-21 00:42:32', '2025-06-21 00:42:32'),
(479, '9f34afb8-f7d1-4119-9149-1aa8028aa589', 1, 3, NULL, 'post.post_details', 'messages', 'Post Details', 'active', NULL, NULL, '2025-06-21 00:42:32', '2025-06-21 00:42:32'),
(480, '9f34afb8-fa1c-437f-9485-0fb07cbbf45a', 1, 3, NULL, 'post.image', 'messages', 'Image', 'active', NULL, NULL, '2025-06-21 00:42:32', '2025-06-21 00:42:32'),
(481, '9f34afb8-fb7d-49ee-b780-913083112fc1', 1, 3, NULL, 'post.status', 'messages', 'Status', 'active', NULL, NULL, '2025-06-21 00:42:32', '2025-06-21 00:42:32'),
(482, '9f34afb8-fcc6-4796-8d09-617ba35b575e', 1, 3, NULL, 'common.default_country_code', 'messages', 'Default Country Code', 'active', NULL, NULL, '2025-06-21 00:42:32', '2025-06-21 00:42:32'),
(483, '9f34afb8-fe0c-4c60-9ea8-b0089a5d3656', 1, 3, NULL, 'common.profile', 'messages', 'Profile', 'active', NULL, NULL, '2025-06-21 00:42:32', '2025-06-21 00:42:32'),
(484, '9f34afb8-ff44-43ef-b90f-3dfb5a2e915b', 1, 3, NULL, 'common.post_image', 'messages', 'Post Image', 'active', NULL, NULL, '2025-06-21 00:42:32', '2025-06-21 00:42:32'),
(485, '9f34afb9-007e-4bee-ba83-8aaec7d5f6a2', 1, 3, NULL, 'common.status', 'messages', 'Status', 'active', NULL, NULL, '2025-06-21 00:42:32', '2025-06-21 00:42:32'),
(486, '9f34afb9-01ba-4f26-b24c-cc0d572eaaf5', 1, 3, NULL, 'common.action', 'messages', 'Action', 'active', NULL, NULL, '2025-06-21 00:42:32', '2025-06-21 00:42:32'),
(487, '9f34afb9-02fb-4f85-92a1-8956bc061fc9', 1, 3, NULL, 'common.save', 'messages', 'Save', 'active', NULL, NULL, '2025-06-21 00:42:32', '2025-06-21 00:42:32'),
(488, '9f34afb9-0446-4b9d-856b-08d6ccc28c92', 1, 3, NULL, 'common.cancel', 'messages', 'Cancel', 'active', NULL, NULL, '2025-06-21 00:42:32', '2025-06-21 00:42:32'),
(489, '9f34afb9-0588-40ff-a96e-45f2e611aa52', 1, 3, NULL, 'common.canceled', 'messages', 'Canceled', 'active', NULL, NULL, '2025-06-21 00:42:32', '2025-06-21 00:42:32'),
(490, '9f34afb9-06cb-49a0-91b3-530a5c498672', 1, 3, NULL, 'common.confirm', 'messages', 'Confirm', 'active', NULL, NULL, '2025-06-21 00:42:32', '2025-06-21 00:42:32'),
(491, '9f34afb9-080f-4329-b564-86e7254fcb7f', 1, 3, NULL, 'common.back', 'messages', 'Back', 'active', NULL, NULL, '2025-06-21 00:42:32', '2025-06-21 00:42:32'),
(492, '9f34afb9-0974-4ef6-b439-dc7de4fa1064', 1, 3, NULL, 'common.created_on', 'messages', 'Created On', 'active', NULL, NULL, '2025-06-21 00:42:32', '2025-06-21 00:42:32'),
(493, '9f34afb9-0ac8-4f28-8329-933870e66959', 1, 3, NULL, 'common.updated_on', 'messages', 'Updated On', 'active', NULL, NULL, '2025-06-21 00:42:32', '2025-06-21 00:42:32'),
(494, '9f34afb9-0c0c-4b4d-a6ec-acb2f639c9c1', 1, 3, NULL, 'common.last_updated', 'messages', 'Last Updated', 'active', NULL, NULL, '2025-06-21 00:42:32', '2025-06-21 00:42:32'),
(495, '9f34afb9-0d45-4a22-a7b6-23d208650808', 1, 3, NULL, 'common.n/a', 'messages', 'N/A', 'active', NULL, NULL, '2025-06-21 00:42:32', '2025-06-21 00:42:32'),
(496, '9f34afb9-0e8d-4be4-8fa6-1c08efc7805c', 1, 3, NULL, 'common.new', 'messages', 'New', 'active', NULL, NULL, '2025-06-21 00:42:32', '2025-06-21 00:42:32'),
(497, '9f34afb9-0fe0-4fab-898e-14b4ceffdde6', 1, 3, NULL, 'common.total', 'messages', 'Total', 'active', NULL, NULL, '2025-06-21 00:42:32', '2025-06-21 00:42:32'),
(498, '9f34afb9-1121-48be-bd43-4ade6234dea0', 1, 3, NULL, 'common.add', 'messages', 'Add', 'active', NULL, NULL, '2025-06-21 00:42:32', '2025-06-21 00:42:32'),
(499, '9f34afb9-126e-469c-aeef-b2fda08bdce8', 1, 3, NULL, 'common.active', 'messages', 'Active', 'active', NULL, NULL, '2025-06-21 00:42:32', '2025-06-21 00:42:32'),
(500, '9f34afb9-13ed-4a5b-9eea-0ce75b38c4ef', 1, 3, NULL, 'common.deactive', 'messages', 'Deactive', 'active', NULL, NULL, '2025-06-21 00:42:32', '2025-06-21 00:42:32'),
(501, '9f34afb9-1539-44a4-95a3-56e90b0d443a', 1, 3, NULL, 'common.name', 'messages', 'Name', 'active', NULL, NULL, '2025-06-21 00:42:32', '2025-06-21 00:42:32'),
(502, '9f34afb9-167f-40fc-96ec-82ae54fcfc3a', 1, 3, NULL, 'common.edit', 'messages', 'Edit', 'active', NULL, NULL, '2025-06-21 00:42:32', '2025-06-21 00:42:32'),
(503, '9f34afb9-17c1-4692-ab7b-9f35f23091df', 1, 3, NULL, 'common.delete', 'messages', 'Delete', 'active', NULL, NULL, '2025-06-21 00:42:32', '2025-06-21 00:42:32'),
(504, '9f34afb9-1907-40bd-b477-e4edefdee4aa', 1, 3, NULL, 'common.view', 'messages', 'View', 'active', NULL, NULL, '2025-06-21 00:42:32', '2025-06-21 00:42:32'),
(505, '9f34afb9-1a4b-416a-9055-33c281520526', 1, 3, NULL, 'common.view_attachment', 'messages', 'View Attachment', 'active', NULL, NULL, '2025-06-21 00:42:32', '2025-06-21 00:42:32'),
(506, '9f34afb9-1ba2-4824-abac-21ae88d05c84', 1, 3, NULL, 'common.de_active', 'messages', 'Deactive', 'active', NULL, NULL, '2025-06-21 00:42:32', '2025-06-21 00:42:32'),
(507, '9f34afb9-1ceb-44a6-8047-52bb0267ca09', 1, 3, NULL, 'common.description', 'messages', 'Description', 'active', NULL, NULL, '2025-06-21 00:42:32', '2025-06-21 00:42:32'),
(508, '9f34afb9-1e26-4055-95d2-897ca50e2e7e', 1, 3, NULL, 'common.created_at', 'messages', 'Created On', 'active', NULL, NULL, '2025-06-21 00:42:32', '2025-06-21 00:42:32'),
(509, '9f34afb9-1f84-40c6-98a1-3b395214f2ab', 1, 3, NULL, 'common.updated_at', 'messages', 'Last Updated', 'active', NULL, NULL, '2025-06-21 00:42:32', '2025-06-21 00:42:32'),
(510, '9f34afb9-20f8-4e38-9a49-db4ac66176f6', 1, 3, NULL, 'common.is_available', 'messages', 'Is Available', 'active', NULL, NULL, '2025-06-21 00:42:32', '2025-06-21 00:42:32'),
(511, '9f34afb9-2244-4de1-bb55-8265ab4c8fe6', 1, 3, NULL, 'common.choose', 'messages', 'Choose', 'active', NULL, NULL, '2025-06-21 00:42:32', '2025-06-21 00:42:32'),
(512, '9f34afb9-238e-427f-9207-0e12ea485227', 1, 3, NULL, 'common.yes', 'messages', 'Yes', 'active', NULL, NULL, '2025-06-21 00:42:32', '2025-06-21 00:42:32'),
(513, '9f34afb9-24de-4b24-8ae9-e2859a6f0d56', 1, 3, NULL, 'common.no', 'messages', 'No', 'active', NULL, NULL, '2025-06-21 00:42:32', '2025-06-21 00:42:32'),
(514, '9f34afb9-2613-403a-a0a7-58a5e75065dd', 1, 3, NULL, 'common.address', 'messages', 'Address', 'active', NULL, NULL, '2025-06-21 00:42:32', '2025-06-21 00:42:32'),
(515, '9f34afb9-2757-4f0b-b059-d21cad3780db', 1, 3, NULL, 'common.export_to_excel', 'messages', 'Export to Excel', 'active', NULL, NULL, '2025-06-21 00:42:32', '2025-06-21 00:42:32'),
(516, '9f34afb9-2895-45f0-8b44-019ae580be5c', 1, 3, NULL, 'common.reset', 'messages', 'Reset', 'active', NULL, NULL, '2025-06-21 00:42:32', '2025-06-21 00:42:32'),
(517, '9f34afb9-29e2-472b-bbdd-7e11f18b911f', 1, 3, NULL, 'common.actions', 'messages', 'Actions', 'active', NULL, NULL, '2025-06-21 00:42:32', '2025-06-21 00:42:32'),
(518, '9f34afb9-2b46-4aac-9b77-bef0def417a1', 1, 3, NULL, 'common.filter_options', 'messages', 'Filter Options', 'active', NULL, NULL, '2025-06-21 00:42:32', '2025-06-21 00:42:32'),
(519, '9f34afb9-2c9c-49fe-ab66-123bc9036105', 1, 3, NULL, 'common.select_status', 'messages', 'Select Status', 'active', NULL, NULL, '2025-06-21 00:42:32', '2025-06-21 00:42:32'),
(520, '9f34afb9-2de0-4925-b875-60b7bda99328', 1, 3, NULL, 'common.showing', 'messages', 'Showing', 'active', NULL, NULL, '2025-06-21 00:42:32', '2025-06-21 00:42:32'),
(521, '9f34afb9-2f1d-44f7-a07a-b836d8b495da', 1, 3, NULL, 'common.of', 'messages', 'of', 'active', NULL, NULL, '2025-06-21 00:42:32', '2025-06-21 00:42:32'),
(522, '9f34afb9-306a-44a8-8118-9259d64b654b', 1, 3, NULL, 'common.results', 'messages', 'Results', 'active', NULL, NULL, '2025-06-21 00:42:32', '2025-06-21 00:42:32'),
(523, '9f34afb9-31b5-4a02-bd20-4101251db8b8', 1, 3, NULL, 'common.show', 'messages', 'Show', 'active', NULL, NULL, '2025-06-21 00:42:32', '2025-06-21 00:42:32'),
(524, '9f34afb9-3313-45f3-adb3-6c1b012a0ee0', 1, 3, NULL, 'common.previous', 'messages', 'Previous', 'active', NULL, NULL, '2025-06-21 00:42:32', '2025-06-21 00:42:32'),
(525, '9f34afb9-3459-4570-9cd5-5288b9a12273', 1, 3, NULL, 'common.next', 'messages', 'Next', 'active', NULL, NULL, '2025-06-21 00:42:32', '2025-06-21 00:42:32'),
(526, '9f34afb9-35a1-40e3-b2a8-773c6e8be6c8', 1, 3, NULL, 'common.default_plan', 'messages', 'Default Plan', 'active', NULL, NULL, '2025-06-21 00:42:32', '2025-06-21 00:42:32'),
(527, '9f34afb9-36e9-46ae-90f5-e4660a1261ed', 1, 3, NULL, 'common.select_type', 'messages', 'Select Type', 'active', NULL, NULL, '2025-06-21 00:42:32', '2025-06-21 00:42:32'),
(528, '9f34afb9-3831-4c0e-9254-12ce37ded487', 1, 3, NULL, 'common.select_type_number', 'messages', 'Select Type Number', 'active', NULL, NULL, '2025-06-21 00:42:32', '2025-06-21 00:42:32'),
(529, '9f34afb9-397a-478f-b49d-48ce150ee9d2', 1, 3, NULL, 'common.filter', 'messages', 'Filter', 'active', NULL, NULL, '2025-06-21 00:42:32', '2025-06-21 00:42:32'),
(530, '9f34afb9-3ad1-4b87-a532-f852f59df27f', 1, 3, NULL, 'common.user_details', 'messages', 'User', 'active', NULL, NULL, '2025-06-21 00:42:32', '2025-06-21 00:42:32'),
(531, '9f34afb9-3c2f-4dfc-bb72-86cce864197d', 1, 3, NULL, 'common.no_data_available', 'messages', 'No data available in table', 'active', NULL, NULL, '2025-06-21 00:42:32', '2025-06-21 00:42:32'),
(532, '9f34afb9-3d76-4622-a00f-739f51392b55', 1, 3, NULL, 'common.allow_img_text', 'messages', 'Allowed file types: png, jpg, jpeg, svg.', 'active', NULL, NULL, '2025-06-21 00:42:32', '2025-06-21 00:42:32'),
(533, '9f34afb9-3ebb-4bc1-8f4c-74e197d826ff', 1, 3, NULL, 'common.search', 'messages', 'Search', 'active', NULL, NULL, '2025-06-21 00:42:32', '2025-06-21 00:42:32'),
(534, '9f34afb9-3ff9-42b0-9b65-aa3f74b1b871', 1, 3, NULL, 'common.no_matching_records_found', 'messages', 'No matching records found', 'active', NULL, NULL, '2025-06-21 00:42:32', '2025-06-21 00:42:32'),
(535, '9f34afb9-4143-41d9-af28-8aa56656774c', 1, 3, NULL, 'common.custom', 'messages', 'Custom', 'active', NULL, NULL, '2025-06-21 00:42:32', '2025-06-21 00:42:32'),
(536, '9f34afb9-42ab-494f-974f-44d0aa20ed05', 1, 3, NULL, 'common.apply', 'messages', 'Apply', 'active', NULL, NULL, '2025-06-21 00:42:32', '2025-06-21 00:42:32'),
(537, '9f34afb9-4411-4483-a00c-6f74737e6560', 1, 3, NULL, 'common.from', 'messages', 'From', 'active', NULL, NULL, '2025-06-21 00:42:32', '2025-06-21 00:42:32'),
(538, '9f34afb9-4568-4b33-8892-0cc22bb7b55b', 1, 3, NULL, 'common.to', 'messages', 'To', 'active', NULL, NULL, '2025-06-21 00:42:32', '2025-06-21 00:42:32'),
(539, '9f34afb9-46d1-42b9-b3a3-81a097e68eb6', 1, 3, NULL, 'common.invalid_number', 'messages', 'Invalid number', 'active', NULL, NULL, '2025-06-21 00:42:32', '2025-06-21 00:42:32'),
(540, '9f34afb9-4818-42f2-acef-6cb4d6546e40', 1, 3, NULL, 'common.invalid_country_code', 'messages', 'Invalid country code', 'active', NULL, NULL, '2025-06-21 00:42:32', '2025-06-21 00:42:32'),
(541, '9f34afb9-49b1-4e43-b572-a07eb1f7cd2c', 1, 3, NULL, 'common.too_short', 'messages', 'Too short', 'active', NULL, NULL, '2025-06-21 00:42:32', '2025-06-21 00:42:32'),
(542, '9f34afb9-4b29-4f2f-ac80-85e1e52b990f', 1, 3, NULL, 'common.too_long', 'messages', 'Too long', 'active', NULL, NULL, '2025-06-21 00:42:32', '2025-06-21 00:42:32'),
(543, '9f34afb9-4c72-4b42-8617-efef09517b92', 1, 3, NULL, 'common.undefined', 'messages', 'undefined', 'active', NULL, NULL, '2025-06-21 00:42:32', '2025-06-21 00:42:32'),
(544, '9f34afb9-4dbe-40e9-b0ce-878d91969a59', 1, 3, NULL, 'common.not_found', 'messages', 'not found', 'active', NULL, NULL, '2025-06-21 00:42:32', '2025-06-21 00:42:32'),
(545, '9f34afb9-4f06-400f-88af-9ab401e012fd', 1, 3, NULL, 'common.no data available in table', 'messages', 'No data available in table', 'active', NULL, NULL, '2025-06-21 00:42:32', '2025-06-21 00:42:32'),
(546, '9f34afb9-5055-4a4d-8998-72e60fbc0d03', 1, 3, NULL, 'common.status_updated_successfully', 'messages', 'Status updated successfully.', 'active', NULL, NULL, '2025-06-21 00:42:32', '2025-06-21 00:42:32'),
(547, '9f34afb9-519f-4f54-b145-bc0237000e57', 1, 3, NULL, 'common.saved_successfully', 'messages', 'saved successfully', 'active', NULL, NULL, '2025-06-21 00:42:32', '2025-06-21 00:42:32'),
(548, '9f34afb9-52e3-4162-8bdd-5f38475a8d78', 1, 3, NULL, 'common.updated_successfully', 'messages', 'updated successfully', 'active', NULL, NULL, '2025-06-21 00:42:32', '2025-06-21 00:42:32'),
(549, '9f34afb9-5421-466a-9db8-df109cbfab44', 1, 3, NULL, 'common.deleted_successfully', 'messages', 'deleted successfully', 'active', NULL, NULL, '2025-06-21 00:42:32', '2025-06-21 00:42:32'),
(550, '9f34afb9-5564-4d83-8749-411d71414e17', 1, 3, NULL, 'common.are_you_sure_want_to_delete_this', 'messages', 'Are you sure want to delete this ', 'active', NULL, NULL, '2025-06-21 00:42:32', '2025-06-21 00:42:32'),
(551, '9f34afb9-56c7-417f-9af8-b1e43978671f', 1, 3, NULL, 'common.deleted', 'messages', 'Deleted', 'active', NULL, NULL, '2025-06-21 00:42:32', '2025-06-21 00:42:32'),
(552, '9f34afb9-5820-4564-8987-b746af6066f9', 1, 3, NULL, 'common.has_been_deleted', 'messages', 'has been deleted.', 'active', NULL, NULL, '2025-06-21 00:42:32', '2025-06-21 00:42:32'),
(553, '9f34afb9-596f-41fd-b5df-58abd4722d21', 1, 3, NULL, 'common.cant_be_deleted', 'messages', 'can\'t be deleted', 'active', NULL, NULL, '2025-06-21 00:42:32', '2025-06-21 00:42:32'),
(554, '9f34afb9-5ade-47cc-b3b8-e6b4573fc6d1', 1, 3, NULL, 'common.ok', 'messages', 'Ok', 'active', NULL, NULL, '2025-06-21 00:42:32', '2025-06-21 00:42:32'),
(555, '9f34afb9-5c2c-4c7d-afb8-75655e5b09de', 1, 3, NULL, 'common.this_action_is_not_allowed_for_default_record', 'messages', 'This action is not allowed for default record.', 'active', NULL, NULL, '2025-06-21 00:42:32', '2025-06-21 00:42:32'),
(556, '9f34afb9-5d80-4023-afce-d823c27c658e', 1, 3, NULL, 'common.please_enter_valid_facebook_url', 'messages', 'Please enter a valid facebook URL', 'active', NULL, NULL, '2025-06-21 00:42:32', '2025-06-21 00:42:32'),
(557, '9f34afb9-5ecc-4e45-a036-266c674415c8', 1, 3, NULL, 'common.please_enter_valid_twitter_url', 'messages', 'Please enter a valid Twitter URL', 'active', NULL, NULL, '2025-06-21 00:42:32', '2025-06-21 00:42:32'),
(558, '9f34afb9-6014-4b3d-bf76-23757eee715c', 1, 3, NULL, 'common.please_enter_valid_linkedin_url', 'messages', 'Please enter a valid LinkedIn URL', 'active', NULL, NULL, '2025-06-21 00:42:32', '2025-06-21 00:42:32'),
(559, '9f34afb9-6160-40e5-ae95-07afdd11bcca', 1, 3, NULL, 'common.please_enter_valid_Instagram_url', 'messages', 'Please enter a valid Instagram URL', 'active', NULL, NULL, '2025-06-21 00:42:32', '2025-06-21 00:42:32'),
(560, '9f34afb9-62b3-4c58-bae9-4b3c0b60e58b', 1, 3, NULL, 'common.select_payment', 'messages', 'Select Payment Status', 'active', NULL, NULL, '2025-06-21 00:42:32', '2025-06-21 00:42:32'),
(561, '9f34afb9-6418-4ab9-a8a5-2ff403966541', 1, 3, NULL, 'common.logged_in_successfully', 'messages', 'Logged in successfully.', 'active', NULL, NULL, '2025-06-21 00:42:32', '2025-06-21 00:42:32'),
(562, '9f34afb9-6574-43e6-883f-d4328917bbf8', 1, 3, NULL, 'common.logout_successfully', 'messages', 'Logout successfully.', 'active', NULL, NULL, '2025-06-21 00:42:32', '2025-06-21 00:42:32'),
(563, '9f34afb9-66c3-41e8-8209-7abaef373025', 1, 3, NULL, 'common.we_have_your_password_resetk_link', 'messages', 'We have e-mailed your password reset link!', 'active', NULL, NULL, '2025-06-21 00:42:32', '2025-06-21 00:42:32'),
(564, '9f34afb9-6934-4c3c-9f83-71a4af81e2c3', 1, 3, NULL, 'common.we_cant_find_user', 'messages', 'We can\'t find user with this email address', 'active', NULL, NULL, '2025-06-21 00:42:32', '2025-06-21 00:42:32'),
(565, '9f34afb9-6a7f-4a93-884d-1ce0e15651c2', 1, 3, NULL, 'common.this_password_reset_token_is_invalid', 'messages', 'This password reset token is invalid', 'active', NULL, NULL, '2025-06-21 00:42:32', '2025-06-21 00:42:32'),
(566, '9f34afb9-6bd1-4784-af38-419a6b84163c', 1, 3, NULL, 'common.password_reset_successfully', 'messages', 'Password reset successfully', 'active', NULL, NULL, '2025-06-21 00:42:32', '2025-06-21 00:42:32'),
(567, '9f34afb9-6d14-444a-8017-6d8c02ac1996', 1, 3, NULL, 'common.please_enter_correct_old_password', 'messages', 'please enter correct old password', 'active', NULL, NULL, '2025-06-21 00:42:32', '2025-06-21 00:42:32'),
(568, '9f34afb9-6e5f-46d7-b427-1bbe301ba2ff', 1, 3, NULL, 'common.password_updated', 'messages', 'Your password has been successfully updated.', 'active', NULL, NULL, '2025-06-21 00:42:32', '2025-06-21 00:42:32'),
(569, '9f34afb9-6fa5-45b4-9f3a-7be3e0eac612', 1, 3, NULL, 'common.doctor_scheduled', 'messages', 'Doctor Scheduled', 'active', NULL, NULL, '2025-06-21 00:42:32', '2025-06-21 00:42:32'),
(570, '9f34afb9-70f5-49b5-9d1b-a8380f90b992', 1, 3, NULL, 'common.patient_registered_successfully', 'messages', 'Patient registered successfully', 'active', NULL, NULL, '2025-06-21 00:42:32', '2025-06-21 00:42:32'),
(571, '9f34afb9-725e-4d36-90ee-997f200d1494', 1, 3, NULL, 'common.appointment_confirmed_successfully', 'messages', 'Appointment confirmed successfully', 'active', NULL, NULL, '2025-06-21 00:42:32', '2025-06-21 00:42:32'),
(572, '9f34afb9-73bd-4944-8810-cd5b1374bc3c', 1, 3, NULL, 'common.bed_assigned_successfully', 'messages', 'Bed Assigned Successfully', 'active', NULL, NULL, '2025-06-21 00:42:32', '2025-06-21 00:42:32');
INSERT INTO `ltu_phrases` (`id`, `uuid`, `translation_id`, `translation_file_id`, `phrase_id`, `key`, `group`, `value`, `status`, `parameters`, `note`, `created_at`, `updated_at`) VALUES
(573, '9f34afb9-752e-48d1-9922-ddfdde980d01', 1, 3, NULL, 'common.username_and_password_required', 'messages', 'Username and password required', 'active', NULL, NULL, '2025-06-21 00:42:32', '2025-06-21 00:42:32'),
(574, '9f34afb9-7685-4b10-ab17-0b6afda96360', 1, 3, NULL, 'common.meeting_finished_or_cancelled', 'messages', 'This meeting is finished or cancelled', 'active', NULL, NULL, '2025-06-21 00:42:32', '2025-06-21 00:42:32'),
(575, '9f34afb9-77ed-4287-997c-15e266573717', 1, 3, NULL, 'common.something_want_wrong', 'messages', 'Something went wrong', 'active', NULL, NULL, '2025-06-21 00:42:32', '2025-06-21 00:42:32'),
(576, '9f34afb9-7944-415b-b171-61ed695e1f87', 1, 3, NULL, 'common.cancelled_successfully', 'messages', 'cancelled successfully', 'active', NULL, NULL, '2025-06-21 00:42:32', '2025-06-21 00:42:32'),
(577, '9f34afb9-7aa1-44b8-aa03-f8bd47d4e0ea', 1, 3, NULL, 'common.not_updated', 'messages', 'Not updated', 'active', NULL, NULL, '2025-06-21 00:42:32', '2025-06-21 00:42:32'),
(578, '9f34afb9-7bf1-4f4b-b400-ff6ef685473c', 1, 3, NULL, 'common.invalid_username_password', 'messages', 'Invalid username or password', 'active', NULL, NULL, '2025-06-21 00:42:32', '2025-06-21 00:42:32'),
(579, '9f34afb9-7d3e-4467-9a25-9a170d3ba62c', 1, 3, NULL, 'common.appointment_transaction', 'messages', 'Appointment Transaction', 'active', NULL, NULL, '2025-06-21 00:42:32', '2025-06-21 00:42:32'),
(580, '9f34afb9-7e88-4bbc-b089-1ebb018fb7cc', 1, 3, NULL, 'common.no_data_found', 'messages', 'No Data Found', 'active', NULL, NULL, '2025-06-21 00:42:32', '2025-06-21 00:42:32'),
(581, '9f34afb9-7fe8-43a3-b56f-c2d247559745', 1, 3, NULL, 'common.is_already_exists', 'messages', 'is already exists.', 'active', NULL, NULL, '2025-06-21 00:42:32', '2025-06-21 00:42:32'),
(582, '9f34afb9-814c-4398-8757-7526def97a46', 1, 3, NULL, 'common.close', 'messages', 'Close', 'active', NULL, NULL, '2025-06-21 00:42:32', '2025-06-21 00:42:32'),
(583, '9f34afb9-82aa-4bc4-8186-99da8c0c7d1b', 1, 3, NULL, 'months.jan', 'messages', 'January', 'active', NULL, NULL, '2025-06-21 00:42:32', '2025-06-21 00:42:32'),
(584, '9f34afb9-840e-405a-8284-1bc901943925', 1, 3, NULL, 'months.feb', 'messages', 'February', 'active', NULL, NULL, '2025-06-21 00:42:32', '2025-06-21 00:42:32'),
(585, '9f34afb9-856e-40e6-a04e-87606d197f23', 1, 3, NULL, 'months.mar', 'messages', 'March', 'active', NULL, NULL, '2025-06-21 00:42:32', '2025-06-21 00:42:32'),
(586, '9f34afb9-86c3-4efa-a72a-574786723414', 1, 3, NULL, 'months.apr', 'messages', 'April', 'active', NULL, NULL, '2025-06-21 00:42:32', '2025-06-21 00:42:32'),
(587, '9f34afb9-8809-4b47-a7b1-01f357697367', 1, 3, NULL, 'months.may', 'messages', 'May', 'active', NULL, NULL, '2025-06-21 00:42:32', '2025-06-21 00:42:32'),
(588, '9f34afb9-895c-4330-acc2-ffa5ee35884a', 1, 3, NULL, 'months.jun', 'messages', 'June', 'active', NULL, NULL, '2025-06-21 00:42:32', '2025-06-21 00:42:32'),
(589, '9f34afb9-8ac4-4635-8dcf-059dbfacbd93', 1, 3, NULL, 'months.jul', 'messages', 'July', 'active', NULL, NULL, '2025-06-21 00:42:32', '2025-06-21 00:42:32'),
(590, '9f34afb9-8c6d-4ea3-9f27-b81c9c846f66', 1, 3, NULL, 'months.aug', 'messages', 'August', 'active', NULL, NULL, '2025-06-21 00:42:32', '2025-06-21 00:42:32'),
(591, '9f34afb9-8ddb-44b1-9835-6193edab1ed7', 1, 3, NULL, 'months.sep', 'messages', 'September', 'active', NULL, NULL, '2025-06-21 00:42:32', '2025-06-21 00:42:32'),
(592, '9f34afb9-8f37-4d83-9aac-12fb9a5c5a59', 1, 3, NULL, 'months.oct', 'messages', 'October', 'active', NULL, NULL, '2025-06-21 00:42:32', '2025-06-21 00:42:32'),
(593, '9f34afb9-908b-43b0-8105-fccfea47e226', 1, 3, NULL, 'months.nov', 'messages', 'November', 'active', NULL, NULL, '2025-06-21 00:42:32', '2025-06-21 00:42:32'),
(594, '9f34afb9-91e3-4453-a64d-506ece69474a', 1, 3, NULL, 'months.dec', 'messages', 'December', 'active', NULL, NULL, '2025-06-21 00:42:32', '2025-06-21 00:42:32'),
(595, '9f34afb9-9347-4f4d-8558-1c4722f3c70b', 1, 3, NULL, 'weekdays.sun', 'messages', 'SUN', 'active', NULL, NULL, '2025-06-21 00:42:32', '2025-06-21 00:42:32'),
(596, '9f34afb9-94a2-4e69-9a19-3f46def45a80', 1, 3, NULL, 'weekdays.mon', 'messages', 'MON', 'active', NULL, NULL, '2025-06-21 00:42:32', '2025-06-21 00:42:32'),
(597, '9f34afb9-95fd-4bed-bfbf-bae372b2292d', 1, 3, NULL, 'weekdays.tue', 'messages', 'TUE', 'active', NULL, NULL, '2025-06-21 00:42:32', '2025-06-21 00:42:32'),
(598, '9f34afb9-9757-4ead-8506-33a628d99904', 1, 3, NULL, 'weekdays.wed', 'messages', 'WED', 'active', NULL, NULL, '2025-06-21 00:42:32', '2025-06-21 00:42:32'),
(599, '9f34afb9-98ba-4e87-9276-762995fa88c4', 1, 3, NULL, 'weekdays.thu', 'messages', 'THU', 'active', NULL, NULL, '2025-06-21 00:42:32', '2025-06-21 00:42:32'),
(600, '9f34afb9-9a03-40ae-941c-ab3b15a0c7df', 1, 3, NULL, 'weekdays.fri', 'messages', 'FRI', 'active', NULL, NULL, '2025-06-21 00:42:32', '2025-06-21 00:42:32'),
(601, '9f34afb9-9b6d-43aa-8d43-8097d2911987', 1, 3, NULL, 'weekdays.sat', 'messages', 'SAT', 'active', NULL, NULL, '2025-06-21 00:42:32', '2025-06-21 00:42:32'),
(602, '9f34afb9-9cc9-4c18-95cb-89ea501c2e2c', 1, 3, NULL, 'receptionist.receptionist', 'messages', 'Receptionist', 'active', NULL, NULL, '2025-06-21 00:42:32', '2025-06-21 00:42:32'),
(603, '9f34afb9-9e22-4d1a-86af-7fd34604f108', 1, 3, NULL, 'receptionist.receptionists', 'messages', 'Receptionists', 'active', NULL, NULL, '2025-06-21 00:42:32', '2025-06-21 00:42:32'),
(604, '9f34afb9-9f77-43a9-89c0-cd07f90305de', 1, 3, NULL, 'receptionist.receptionist_details', 'messages', 'Receptionist Details', 'active', NULL, NULL, '2025-06-21 00:42:32', '2025-06-21 00:42:32'),
(605, '9f34afb9-a0cd-461a-a18f-50295e635302', 1, 3, NULL, 'receptionist.new_receptionist', 'messages', 'New Receptionist', 'active', NULL, NULL, '2025-06-21 00:42:32', '2025-06-21 00:42:32'),
(606, '9f34afb9-a228-49fe-bad7-88422a8bc71b', 1, 3, NULL, 'receptionist.edit_receptionist', 'messages', 'Edit Receptionist', 'active', NULL, NULL, '2025-06-21 00:42:32', '2025-06-21 00:42:32'),
(607, '9f34afb9-a386-452e-8d66-fe767907d548', 1, 3, NULL, 'insurance.insurance', 'messages', 'Insurance', 'active', NULL, NULL, '2025-06-21 00:42:32', '2025-06-21 00:42:32'),
(608, '9f34afb9-a4df-48df-840d-d5334cf95f1a', 1, 3, NULL, 'insurance.insurances', 'messages', 'Insurances', 'active', NULL, NULL, '2025-06-21 00:42:32', '2025-06-21 00:42:32'),
(609, '9f34afb9-a64b-485a-aa5c-e957cdee5d7b', 1, 3, NULL, 'insurance.insurance_details', 'messages', 'Insurance Details', 'active', NULL, NULL, '2025-06-21 00:42:32', '2025-06-21 00:42:32'),
(610, '9f34afb9-a7bb-4463-ab70-901a487a692d', 1, 3, NULL, 'insurance.new_insurance', 'messages', 'New Insurance', 'active', NULL, NULL, '2025-06-21 00:42:32', '2025-06-21 00:42:32'),
(611, '9f34afb9-a929-477b-93cc-a18ed11d73f5', 1, 3, NULL, 'insurance.edit_insurance', 'messages', 'Edit Insurance', 'active', NULL, NULL, '2025-06-21 00:42:32', '2025-06-21 00:42:32'),
(612, '9f34afb9-aa85-47ed-8f58-c8fd252b1766', 1, 3, NULL, 'insurance.service_tax', 'messages', 'Service Tax', 'active', NULL, NULL, '2025-06-21 00:42:32', '2025-06-21 00:42:32'),
(613, '9f34afb9-abf5-408b-886a-441a13c141ee', 1, 3, NULL, 'insurance.insurance_no', 'messages', 'Insurance No', 'active', NULL, NULL, '2025-06-21 00:42:32', '2025-06-21 00:42:32'),
(614, '9f34afb9-ad5f-4a18-9c43-690c34fe2115', 1, 3, NULL, 'insurance.insurance_code', 'messages', 'Insurance Code', 'active', NULL, NULL, '2025-06-21 00:42:32', '2025-06-21 00:42:32'),
(615, '9f34afb9-aeb0-4de8-995c-192b0bb813b8', 1, 3, NULL, 'insurance.hospital_rate', 'messages', 'Hospital Rate', 'active', NULL, NULL, '2025-06-21 00:42:32', '2025-06-21 00:42:32'),
(616, '9f34afb9-b01a-4b44-a570-815e8019c035', 1, 3, NULL, 'insurance.discount', 'messages', 'Discount', 'active', NULL, NULL, '2025-06-21 00:42:32', '2025-06-21 00:42:32'),
(617, '9f34afb9-b16c-4326-a745-3e0c1e0d8ab4', 1, 3, NULL, 'insurance.remark', 'messages', 'Remark', 'active', NULL, NULL, '2025-06-21 00:42:32', '2025-06-21 00:42:32'),
(618, '9f34afb9-b2c3-4d9c-9821-aa4ee6882329', 1, 3, NULL, 'insurance.disease_details', 'messages', 'Disease Details', 'active', NULL, NULL, '2025-06-21 00:42:32', '2025-06-21 00:42:32'),
(619, '9f34afb9-b426-45a5-8dbd-ae6bb91e6495', 1, 3, NULL, 'insurance.diseases_name', 'messages', 'Diseases Name', 'active', NULL, NULL, '2025-06-21 00:42:32', '2025-06-21 00:42:32'),
(620, '9f34afb9-b596-41b9-9559-c2de782eba18', 1, 3, NULL, 'insurance.diseases_charge', 'messages', 'Diseases charge', 'active', NULL, NULL, '2025-06-21 00:42:32', '2025-06-21 00:42:32'),
(621, '9f34afb9-b6e8-4cbe-a397-0982ea635ce1', 1, 3, NULL, 'insurance.total_amount', 'messages', 'Total Amount', 'active', NULL, NULL, '2025-06-21 00:42:32', '2025-06-21 00:42:32'),
(622, '9f34afb9-b845-4729-a194-9f08fe9afc5c', 1, 3, NULL, 'doctor_department.doctor_departments', 'messages', 'Doctor Departments', 'active', NULL, NULL, '2025-06-21 00:42:32', '2025-06-21 00:42:32'),
(623, '9f34afb9-b9a4-4cf6-9f3f-7128cae56517', 1, 3, NULL, 'doctor_department.doctor_department', 'messages', 'Doctor Department', 'active', NULL, NULL, '2025-06-21 00:42:33', '2025-06-21 00:42:33'),
(624, '9f34afb9-baf5-40e8-a2de-b407bc146b1c', 1, 3, NULL, 'doctor_department.doctor_department_details', 'messages', 'Doctor Department Details', 'active', NULL, NULL, '2025-06-21 00:42:33', '2025-06-21 00:42:33'),
(625, '9f34afb9-bc46-45d1-8fc2-240716348de3', 1, 3, NULL, 'doctor_department.new_doctor_department', 'messages', 'New Doctor Department', 'active', NULL, NULL, '2025-06-21 00:42:33', '2025-06-21 00:42:33'),
(626, '9f34afb9-bd90-475e-8d6f-255cf64e9bfc', 1, 3, NULL, 'doctor_department.edit_doctor_department', 'messages', 'Edit Doctor Department', 'active', NULL, NULL, '2025-06-21 00:42:33', '2025-06-21 00:42:33'),
(627, '9f34afb9-bee8-4827-be33-528f71fba58e', 1, 3, NULL, 'doctor_department.title', 'messages', 'Title', 'active', NULL, NULL, '2025-06-21 00:42:33', '2025-06-21 00:42:33'),
(628, '9f34afb9-c044-4451-aef1-3f633fdcb889', 1, 3, NULL, 'doctor_department.description', 'messages', 'Description', 'active', NULL, NULL, '2025-06-21 00:42:33', '2025-06-21 00:42:33'),
(629, '9f34afb9-c19b-4ece-b990-6e105b541b49', 1, 3, NULL, 'investigation_report.investigation_reports', 'messages', 'Investigation Reports', 'active', NULL, NULL, '2025-06-21 00:42:33', '2025-06-21 00:42:33'),
(630, '9f34afb9-c301-453b-bf8f-2f8a447ac2cc', 1, 3, NULL, 'investigation_report.investigation_report', 'messages', 'Investigation Report', 'active', NULL, NULL, '2025-06-21 00:42:33', '2025-06-21 00:42:33'),
(631, '9f34afb9-c47c-45ac-89d0-73180fdeb208', 1, 3, NULL, 'investigation_report.investigation_report_details', 'messages', 'Investigation Report Details', 'active', NULL, NULL, '2025-06-21 00:42:33', '2025-06-21 00:42:33'),
(632, '9f34afb9-c5d4-48f7-bf31-13e63362330e', 1, 3, NULL, 'investigation_report.new_investigation_report', 'messages', 'New Investigation Report', 'active', NULL, NULL, '2025-06-21 00:42:33', '2025-06-21 00:42:33'),
(633, '9f34afb9-c733-4246-a8dc-f2b96d911c66', 1, 3, NULL, 'investigation_report.edit_investigation_report', 'messages', 'Edit Investigation Report', 'active', NULL, NULL, '2025-06-21 00:42:33', '2025-06-21 00:42:33'),
(634, '9f34afb9-c889-4f3d-865e-32d71dbbba01', 1, 3, NULL, 'investigation_report.patient', 'messages', 'Patient', 'active', NULL, NULL, '2025-06-21 00:42:33', '2025-06-21 00:42:33'),
(635, '9f34afb9-c9e3-4b60-add9-89548080ddc8', 1, 3, NULL, 'investigation_report.date', 'messages', 'Date', 'active', NULL, NULL, '2025-06-21 00:42:33', '2025-06-21 00:42:33'),
(636, '9f34afb9-cb48-4a50-a7aa-4be32b18b500', 1, 3, NULL, 'investigation_report.title', 'messages', 'Title', 'active', NULL, NULL, '2025-06-21 00:42:33', '2025-06-21 00:42:33'),
(637, '9f34afb9-cc98-439a-b48a-224504480160', 1, 3, NULL, 'investigation_report.doctor', 'messages', 'Doctor', 'active', NULL, NULL, '2025-06-21 00:42:33', '2025-06-21 00:42:33'),
(638, '9f34afb9-cdf4-4306-bb96-b5678f96e8a7', 1, 3, NULL, 'investigation_report.description', 'messages', 'Description', 'active', NULL, NULL, '2025-06-21 00:42:33', '2025-06-21 00:42:33'),
(639, '9f34afb9-cf4f-4422-9b56-5f88e3967d4a', 1, 3, NULL, 'investigation_report.attachment', 'messages', 'Attachment', 'active', NULL, NULL, '2025-06-21 00:42:33', '2025-06-21 00:42:33'),
(640, '9f34afb9-d0b0-49e2-98c4-7321b554383a', 1, 3, NULL, 'investigation_report.solved', 'messages', 'Solved', 'active', NULL, NULL, '2025-06-21 00:42:33', '2025-06-21 00:42:33'),
(641, '9f34afb9-d227-4c47-b958-daa6e9725cb7', 1, 3, NULL, 'investigation_report.not_solved', 'messages', 'Not Solved', 'active', NULL, NULL, '2025-06-21 00:42:33', '2025-06-21 00:42:33'),
(642, '9f34afb9-d39b-4096-9eb9-cf2568de5017', 1, 3, NULL, 'pharmacist.new_pharmacist', 'messages', 'New Pharmacist', 'active', NULL, NULL, '2025-06-21 00:42:33', '2025-06-21 00:42:33'),
(643, '9f34afb9-d523-4cf9-b6fd-124a568f598c', 1, 3, NULL, 'pharmacist.edit_pharmacist', 'messages', 'Edit Pharmacist', 'active', NULL, NULL, '2025-06-21 00:42:33', '2025-06-21 00:42:33'),
(644, '9f34afb9-d68e-4fec-857f-973f5a969553', 1, 3, NULL, 'pharmacist.pharmacists', 'messages', 'Pharmacists', 'active', NULL, NULL, '2025-06-21 00:42:33', '2025-06-21 00:42:33'),
(645, '9f34afb9-d7fa-4e73-9225-81d18fec9157', 1, 3, NULL, 'pharmacist.pharmacist_details', 'messages', 'Pharmacist Details', 'active', NULL, NULL, '2025-06-21 00:42:33', '2025-06-21 00:42:33'),
(646, '9f34afb9-d960-43e4-b092-c26b9b9acd68', 1, 3, NULL, 'death_report.death_report', 'messages', 'Death Report', 'active', NULL, NULL, '2025-06-21 00:42:33', '2025-06-21 00:42:33'),
(647, '9f34afb9-dbee-4de0-80d3-61bc654c742e', 1, 3, NULL, 'death_report.death_reports', 'messages', 'Death Reports', 'active', NULL, NULL, '2025-06-21 00:42:33', '2025-06-21 00:42:33'),
(648, '9f34afb9-dd6c-46cd-9fce-8792b86bef07', 1, 3, NULL, 'death_report.new_death_report', 'messages', 'New Death Report', 'active', NULL, NULL, '2025-06-21 00:42:33', '2025-06-21 00:42:33'),
(649, '9f34afb9-deec-4ca4-be84-59c8f4bb00c3', 1, 3, NULL, 'death_report.edit_death_report', 'messages', 'Edit Death Report', 'active', NULL, NULL, '2025-06-21 00:42:33', '2025-06-21 00:42:33'),
(650, '9f34afb9-e055-4a04-b0f4-ca6fd7ddd7ed', 1, 3, NULL, 'death_report.death_report_details', 'messages', 'Death Report Details', 'active', NULL, NULL, '2025-06-21 00:42:33', '2025-06-21 00:42:33'),
(651, '9f34afb9-e1ba-469d-8fd2-1fcc04918b0f', 1, 3, NULL, 'death_report.patient_name', 'messages', 'Patient Name', 'active', NULL, NULL, '2025-06-21 00:42:33', '2025-06-21 00:42:33'),
(652, '9f34afb9-e31e-4dac-ab84-8db4952991f7', 1, 3, NULL, 'death_report.case_id', 'messages', 'Case ID', 'active', NULL, NULL, '2025-06-21 00:42:33', '2025-06-21 00:42:33'),
(653, '9f34afb9-e47a-47b1-9a6d-044cf5a4952b', 1, 3, NULL, 'death_report.doctor_name', 'messages', 'Doctor Name', 'active', NULL, NULL, '2025-06-21 00:42:33', '2025-06-21 00:42:33'),
(654, '9f34afb9-e5d5-42ba-8cef-b15350133700', 1, 3, NULL, 'death_report.date', 'messages', 'Date', 'active', NULL, NULL, '2025-06-21 00:42:33', '2025-06-21 00:42:33'),
(655, '9f34afb9-e732-4a61-bdc9-91c31607de3c', 1, 3, NULL, 'death_report.description', 'messages', 'Description', 'active', NULL, NULL, '2025-06-21 00:42:33', '2025-06-21 00:42:33'),
(656, '9f34afb9-e897-44ae-8a7d-995a8c2c69b1', 1, 3, NULL, 'birth_report.birth_report', 'messages', 'Birth Report', 'active', NULL, NULL, '2025-06-21 00:42:33', '2025-06-21 00:42:33'),
(657, '9f34afb9-e9f7-426b-8400-608fd216736d', 1, 3, NULL, 'birth_report.birth_reports', 'messages', 'Birth Reports', 'active', NULL, NULL, '2025-06-21 00:42:33', '2025-06-21 00:42:33'),
(658, '9f34afb9-eb51-4d89-ad3a-cb9c39596ce6', 1, 3, NULL, 'birth_report.birth_report_details', 'messages', 'Birth Report Details', 'active', NULL, NULL, '2025-06-21 00:42:33', '2025-06-21 00:42:33'),
(659, '9f34afb9-ecd3-4fcb-9331-162691763f18', 1, 3, NULL, 'birth_report.new_birth_report', 'messages', 'New Birth Report', 'active', NULL, NULL, '2025-06-21 00:42:33', '2025-06-21 00:42:33'),
(660, '9f34afb9-ee5b-4557-a9c4-b5309c1dc09a', 1, 3, NULL, 'birth_report.edit_birth_report', 'messages', 'Edit Birth Report', 'active', NULL, NULL, '2025-06-21 00:42:33', '2025-06-21 00:42:33'),
(661, '9f34afb9-efda-4942-803c-6ff6e0d00a98', 1, 3, NULL, 'birth_report.patient_name', 'messages', 'Patient Name', 'active', NULL, NULL, '2025-06-21 00:42:33', '2025-06-21 00:42:33'),
(662, '9f34afb9-f14b-4653-99af-8da458a150a8', 1, 3, NULL, 'birth_report.case_id', 'messages', 'Case ID', 'active', NULL, NULL, '2025-06-21 00:42:33', '2025-06-21 00:42:33'),
(663, '9f34afb9-f2b6-400b-ace7-09d1cc499b41', 1, 3, NULL, 'birth_report.doctor_name', 'messages', 'Doctor Name', 'active', NULL, NULL, '2025-06-21 00:42:33', '2025-06-21 00:42:33'),
(664, '9f34afb9-f422-4d91-a4b3-d15d3839369e', 1, 3, NULL, 'birth_report.date', 'messages', 'Date', 'active', NULL, NULL, '2025-06-21 00:42:33', '2025-06-21 00:42:33'),
(665, '9f34afb9-f5a6-4c15-b0ea-d14ec2999707', 1, 3, NULL, 'birth_report.description', 'messages', 'Description', 'active', NULL, NULL, '2025-06-21 00:42:33', '2025-06-21 00:42:33'),
(666, '9f34afb9-f734-4e59-8958-bcf12f493d7e', 1, 3, NULL, 'odontogram.odontogram', 'messages', 'Odontogram', 'active', NULL, NULL, '2025-06-21 00:42:33', '2025-06-21 00:42:33'),
(667, '9f34afb9-f8bf-45a4-ba26-7d07eee81d73', 1, 3, NULL, 'odontogram.odontograms', 'messages', 'Odontograms', 'active', NULL, NULL, '2025-06-21 00:42:33', '2025-06-21 00:42:33'),
(668, '9f34afb9-fa40-401a-b493-73f335386d68', 1, 3, NULL, 'accountant.new_accountant', 'messages', 'New Accountant', 'active', NULL, NULL, '2025-06-21 00:42:33', '2025-06-21 00:42:33'),
(669, '9f34afb9-fbc3-42ec-a06b-d9106406374a', 1, 3, NULL, 'accountant.edit_accountant', 'messages', 'Edit Accountant', 'active', NULL, NULL, '2025-06-21 00:42:33', '2025-06-21 00:42:33'),
(670, '9f34afb9-fd62-4e72-9c55-a12a9e8d3978', 1, 3, NULL, 'accountant.accountants', 'messages', 'Accountants', 'active', NULL, NULL, '2025-06-21 00:42:33', '2025-06-21 00:42:33'),
(671, '9f34afb9-fef4-428c-8d5f-21e2aac137a6', 1, 3, NULL, 'accountant.accountant_details', 'messages', 'Accountant Details', 'active', NULL, NULL, '2025-06-21 00:42:33', '2025-06-21 00:42:33'),
(672, '9f34afba-007d-436d-a3e7-66d3ad9acd62', 1, 3, NULL, 'accountant.credit', 'messages', 'Credit', 'active', NULL, NULL, '2025-06-21 00:42:33', '2025-06-21 00:42:33'),
(673, '9f34afba-0210-410a-8211-06fccf89af7f', 1, 3, NULL, 'accountant.debit', 'messages', 'Debit', 'active', NULL, NULL, '2025-06-21 00:42:33', '2025-06-21 00:42:33'),
(674, '9f34afba-039f-42cc-ad01-756ba15863fd', 1, 3, NULL, 'employee_payroll.employee_payroll', 'messages', 'Employee Payroll', 'active', NULL, NULL, '2025-06-21 00:42:33', '2025-06-21 00:42:33'),
(675, '9f34afba-052d-49c8-9d6d-9ce3b4e57949', 1, 3, NULL, 'employee_payroll.employee_payrolls', 'messages', 'Employee Payrolls', 'active', NULL, NULL, '2025-06-21 00:42:33', '2025-06-21 00:42:33'),
(676, '9f34afba-071c-469a-b6e2-65c0d689ba38', 1, 3, NULL, 'employee_payroll.employee_payroll_details', 'messages', 'Employee Payroll Details', 'active', NULL, NULL, '2025-06-21 00:42:33', '2025-06-21 00:42:33'),
(677, '9f34afba-089f-48ef-820a-09dc5e4214be', 1, 3, NULL, 'employee_payroll.new_employee_payroll', 'messages', 'New Employee Payroll', 'active', NULL, NULL, '2025-06-21 00:42:33', '2025-06-21 00:42:33'),
(678, '9f34afba-0a55-4330-9dad-389c44e5b8af', 1, 3, NULL, 'employee_payroll.edit_employee_payroll', 'messages', 'Edit Employee Payroll', 'active', NULL, NULL, '2025-06-21 00:42:33', '2025-06-21 00:42:33'),
(679, '9f34afba-0c32-4a14-b87a-3d41e8ff2df0', 1, 3, NULL, 'employee_payroll.sr_no', 'messages', 'Sr No', 'active', NULL, NULL, '2025-06-21 00:42:33', '2025-06-21 00:42:33'),
(680, '9f34afba-0dca-4b54-8ee4-4edff983afcb', 1, 3, NULL, 'employee_payroll.payroll_id', 'messages', 'Payroll ID', 'active', NULL, NULL, '2025-06-21 00:42:33', '2025-06-21 00:42:33'),
(681, '9f34afba-0f66-4809-9398-b0cda8444fd7', 1, 3, NULL, 'employee_payroll.month', 'messages', 'Month', 'active', NULL, NULL, '2025-06-21 00:42:33', '2025-06-21 00:42:33'),
(682, '9f34afba-10f3-43c8-a1db-678f33288876', 1, 3, NULL, 'employee_payroll.year', 'messages', 'Year', 'active', NULL, NULL, '2025-06-21 00:42:33', '2025-06-21 00:42:33'),
(683, '9f34afba-126d-471c-bf89-1d83cc3cc444', 1, 3, NULL, 'employee_payroll.role', 'messages', 'Role', 'active', NULL, NULL, '2025-06-21 00:42:33', '2025-06-21 00:42:33'),
(684, '9f34afba-13ed-44aa-b2fd-16179c12cb67', 1, 3, NULL, 'employee_payroll.employee', 'messages', 'Employee', 'active', NULL, NULL, '2025-06-21 00:42:33', '2025-06-21 00:42:33'),
(685, '9f34afba-15bb-44b4-bc43-f129b6780960', 1, 3, NULL, 'employee_payroll.basic_salary', 'messages', 'Basic Salary', 'active', NULL, NULL, '2025-06-21 00:42:33', '2025-06-21 00:42:33'),
(686, '9f34afba-1752-4656-aab8-83db3ac66ebc', 1, 3, NULL, 'employee_payroll.allowance', 'messages', 'Allowance', 'active', NULL, NULL, '2025-06-21 00:42:33', '2025-06-21 00:42:33'),
(687, '9f34afba-18d4-482b-8425-3c9c61f5dbb4', 1, 3, NULL, 'employee_payroll.deductions', 'messages', 'Deductions', 'active', NULL, NULL, '2025-06-21 00:42:33', '2025-06-21 00:42:33'),
(688, '9f34afba-1a5d-4c4a-9319-dcb58f46b51d', 1, 3, NULL, 'employee_payroll.net_salary', 'messages', 'Net Salary', 'active', NULL, NULL, '2025-06-21 00:42:33', '2025-06-21 00:42:33'),
(689, '9f34afba-1bff-468e-8bcd-48a1bff53ae7', 1, 3, NULL, 'employee_payroll.paid', 'messages', 'Paid', 'active', NULL, NULL, '2025-06-21 00:42:33', '2025-06-21 00:42:33'),
(690, '9f34afba-1d9d-4d3f-a209-71b312c6746e', 1, 3, NULL, 'employee_payroll.not_paid', 'messages', 'Not Paid', 'active', NULL, NULL, '2025-06-21 00:42:33', '2025-06-21 00:42:33'),
(691, '9f34afba-1fa3-4c98-86fa-da8ce3197acc', 1, 3, NULL, 'employee_payroll.unpaid', 'messages', 'Unpaid', 'active', NULL, NULL, '2025-06-21 00:42:33', '2025-06-21 00:42:33'),
(692, '9f34afba-2159-463b-8ccc-49de5b07ccd4', 1, 3, NULL, 'employee_payroll.employee_name', 'messages', 'Employee Name', 'active', NULL, NULL, '2025-06-21 00:42:33', '2025-06-21 00:42:33'),
(693, '9f34afba-22eb-4d03-9e02-adfd5511c013', 1, 3, NULL, 'employee_payroll.select_employee', 'messages', 'Select Employee', 'active', NULL, NULL, '2025-06-21 00:42:33', '2025-06-21 00:42:33'),
(694, '9f34afba-2720-42a6-b8b9-3809931899a0', 1, 3, NULL, 'operation_report.operation_report', 'messages', 'Operation Report', 'active', NULL, NULL, '2025-06-21 00:42:33', '2025-06-21 00:42:33'),
(695, '9f34afba-28c8-4c6e-ac04-6f598725db2e', 1, 3, NULL, 'operation_report.operation_reports', 'messages', 'Operation Reports', 'active', NULL, NULL, '2025-06-21 00:42:33', '2025-06-21 00:42:33'),
(696, '9f34afba-2a3c-418e-8768-ce86f5ffdc8d', 1, 3, NULL, 'operation_report.operation_report_details', 'messages', 'Operation Report Details', 'active', NULL, NULL, '2025-06-21 00:42:33', '2025-06-21 00:42:33'),
(697, '9f34afba-2bef-40bb-b5d7-6e901547c0f9', 1, 3, NULL, 'operation_report.new_operation_report', 'messages', 'New Operation Report', 'active', NULL, NULL, '2025-06-21 00:42:33', '2025-06-21 00:42:33'),
(698, '9f34afba-2d58-412b-b49a-ff69a768f169', 1, 3, NULL, 'operation_report.edit_operation_report', 'messages', 'Edit Operation Report', 'active', NULL, NULL, '2025-06-21 00:42:33', '2025-06-21 00:42:33'),
(699, '9f34afba-2ed8-4453-9312-639312818cbf', 1, 3, NULL, 'operation_report.patient_name', 'messages', 'Patient Name', 'active', NULL, NULL, '2025-06-21 00:42:33', '2025-06-21 00:42:33'),
(700, '9f34afba-305d-4d5e-a60a-3933517adaa6', 1, 3, NULL, 'operation_report.case_id', 'messages', 'Case ID', 'active', NULL, NULL, '2025-06-21 00:42:33', '2025-06-21 00:42:33'),
(701, '9f34afba-31cf-481d-a343-d53371151c08', 1, 3, NULL, 'operation_report.doctor_name', 'messages', 'Doctor Name', 'active', NULL, NULL, '2025-06-21 00:42:33', '2025-06-21 00:42:33'),
(702, '9f34afba-333d-4416-8797-0ef3971e575c', 1, 3, NULL, 'operation_report.date', 'messages', 'Date', 'active', NULL, NULL, '2025-06-21 00:42:33', '2025-06-21 00:42:33'),
(703, '9f34afba-34aa-46b2-b6d7-4b50695c35a6', 1, 3, NULL, 'operation_report.description', 'messages', 'Description', 'active', NULL, NULL, '2025-06-21 00:42:33', '2025-06-21 00:42:33'),
(704, '9f34afba-3615-4976-bd9d-5b0f89a9e8d1', 1, 3, NULL, 'account.account', 'messages', 'Account', 'active', NULL, NULL, '2025-06-21 00:42:33', '2025-06-21 00:42:33'),
(705, '9f34afba-3794-41b6-acba-6636e43121c5', 1, 3, NULL, 'account.accounts', 'messages', 'Accounts', 'active', NULL, NULL, '2025-06-21 00:42:33', '2025-06-21 00:42:33'),
(706, '9f34afba-3912-4a50-82b7-faab1f2ce808', 1, 3, NULL, 'account.account_details', 'messages', 'Account Details', 'active', NULL, NULL, '2025-06-21 00:42:33', '2025-06-21 00:42:33'),
(707, '9f34afba-3a7c-49e4-b7b0-3b8d723a175f', 1, 3, NULL, 'account.new_account', 'messages', 'New Account', 'active', NULL, NULL, '2025-06-21 00:42:33', '2025-06-21 00:42:33'),
(708, '9f34afba-3bfc-418f-a83e-14fda489cb98', 1, 3, NULL, 'account.edit_account', 'messages', 'Edit Account', 'active', NULL, NULL, '2025-06-21 00:42:33', '2025-06-21 00:42:33'),
(709, '9f34afba-3d8a-424c-afa0-e367d02dc4c5', 1, 3, NULL, 'account.name', 'messages', 'Name', 'active', NULL, NULL, '2025-06-21 00:42:33', '2025-06-21 00:42:33'),
(710, '9f34afba-3f11-432d-8099-fa69d1a90ba9', 1, 3, NULL, 'account.description', 'messages', 'Description', 'active', NULL, NULL, '2025-06-21 00:42:33', '2025-06-21 00:42:33'),
(711, '9f34afba-4084-4756-8fb3-b6032acef61a', 1, 3, NULL, 'account.type', 'messages', 'Type', 'active', NULL, NULL, '2025-06-21 00:42:33', '2025-06-21 00:42:33'),
(712, '9f34afba-41fb-4889-8a83-78a6f63f59de', 1, 3, NULL, 'account.status', 'messages', 'Status', 'active', NULL, NULL, '2025-06-21 00:42:33', '2025-06-21 00:42:33'),
(713, '9f34afba-4372-4992-be5d-1f363ee7a56b', 1, 3, NULL, 'account.payments', 'messages', 'Payments', 'active', NULL, NULL, '2025-06-21 00:42:33', '2025-06-21 00:42:33'),
(714, '9f34afba-44de-476b-a038-537160737fca', 1, 3, NULL, 'invoice.send_mail', 'messages', 'Send Mail', 'active', NULL, NULL, '2025-06-21 00:42:33', '2025-06-21 00:42:33'),
(715, '9f34afba-4650-4d25-a8b9-d8a424639f6f', 1, 3, NULL, 'invoice.invoice_id', 'messages', 'Invoice ID', 'active', NULL, NULL, '2025-06-21 00:42:33', '2025-06-21 00:42:33'),
(716, '9f34afba-47c5-43a7-a110-ac50d2b6fc2f', 1, 3, NULL, 'invoice.invoice', 'messages', 'Invoice', 'active', NULL, NULL, '2025-06-21 00:42:33', '2025-06-21 00:42:33'),
(717, '9f34afba-4945-420b-b124-a1657b017b51', 1, 3, NULL, 'invoice.invoices', 'messages', 'Invoices', 'active', NULL, NULL, '2025-06-21 00:42:33', '2025-06-21 00:42:33'),
(718, '9f34afba-4acb-4872-86ca-0baf35925214', 1, 3, NULL, 'invoice.invoice_details', 'messages', 'Invoice Details', 'active', NULL, NULL, '2025-06-21 00:42:33', '2025-06-21 00:42:33'),
(719, '9f34afba-4c39-4b97-8b9e-be6ac5a4f2d0', 1, 3, NULL, 'invoice.new_invoice', 'messages', 'New Invoice', 'active', NULL, NULL, '2025-06-21 00:42:33', '2025-06-21 00:42:33'),
(720, '9f34afba-4db7-4d45-9cf7-6796155b9235', 1, 3, NULL, 'invoice.edit_invoice', 'messages', 'Edit Invoice', 'active', NULL, NULL, '2025-06-21 00:42:33', '2025-06-21 00:42:33'),
(721, '9f34afba-4f3e-4342-a209-06ce7f46dc00', 1, 3, NULL, 'invoice.patient', 'messages', 'Patient', 'active', NULL, NULL, '2025-06-21 00:42:33', '2025-06-21 00:42:33'),
(722, '9f34afba-50b3-4445-9bf7-e0370f56b750', 1, 3, NULL, 'invoice.invoice_date', 'messages', 'Invoice Date', 'active', NULL, NULL, '2025-06-21 00:42:33', '2025-06-21 00:42:33'),
(723, '9f34afba-521f-4f11-aa12-727662054814', 1, 3, NULL, 'invoice.amount', 'messages', 'Amount', 'active', NULL, NULL, '2025-06-21 00:42:33', '2025-06-21 00:42:33'),
(724, '9f34afba-5389-4775-bb15-fad3eb2fff9d', 1, 3, NULL, 'invoice.patient_id', 'messages', 'Patient ID', 'active', NULL, NULL, '2025-06-21 00:42:33', '2025-06-21 00:42:33'),
(725, '9f34afba-54ef-401b-936c-3da1f2a841e4', 1, 3, NULL, 'invoice.discount', 'messages', 'Discount', 'active', NULL, NULL, '2025-06-21 00:42:33', '2025-06-21 00:42:33'),
(726, '9f34afba-5663-4947-a39e-9fd3ac546b3f', 1, 3, NULL, 'invoice.account_name', 'messages', 'Account Name', 'active', NULL, NULL, '2025-06-21 00:42:33', '2025-06-21 00:42:33'),
(727, '9f34afba-57d9-4eaf-8aea-1d9fcc5fb2b3', 1, 3, NULL, 'invoice.description', 'messages', 'Description', 'active', NULL, NULL, '2025-06-21 00:42:33', '2025-06-21 00:42:33'),
(728, '9f34afba-5974-47fc-a6d6-19fada54d209', 1, 3, NULL, 'invoice.qty', 'messages', 'Qty', 'active', NULL, NULL, '2025-06-21 00:42:33', '2025-06-21 00:42:33'),
(729, '9f34afba-5ae8-40f6-9eb3-a8bddcd130ef', 1, 3, NULL, 'invoice.price', 'messages', 'Price', 'active', NULL, NULL, '2025-06-21 00:42:33', '2025-06-21 00:42:33'),
(730, '9f34afba-5d77-45f4-a758-2fa9ebfe3e55', 1, 3, NULL, 'invoice.add', 'messages', 'Add', 'active', NULL, NULL, '2025-06-21 00:42:33', '2025-06-21 00:42:33'),
(731, '9f34afba-5eed-42c3-9438-d6e64b6dc835', 1, 3, NULL, 'invoice.sub_total', 'messages', 'Sub Total', 'active', NULL, NULL, '2025-06-21 00:42:33', '2025-06-21 00:42:33'),
(732, '9f34afba-6064-4d59-9d1c-7d656385e718', 1, 3, NULL, 'invoice.total', 'messages', 'Total Amount', 'active', NULL, NULL, '2025-06-21 00:42:33', '2025-06-21 00:42:33'),
(733, '9f34afba-61c6-475d-9f36-6d9ac0983799', 1, 3, NULL, 'invoice.edit', 'messages', 'Edit', 'active', NULL, NULL, '2025-06-21 00:42:33', '2025-06-21 00:42:33'),
(734, '9f34afba-6333-4f80-9542-fd270eafb8c0', 1, 3, NULL, 'invoice.hospital_address', 'messages', 'Hospital Address', 'active', NULL, NULL, '2025-06-21 00:42:33', '2025-06-21 00:42:33'),
(735, '9f34afba-64a4-4b38-a3a5-1ac92cd9d79b', 1, 3, NULL, 'invoice.paid', 'messages', 'Paid', 'active', NULL, NULL, '2025-06-21 00:42:33', '2025-06-21 00:42:33'),
(736, '9f34afba-662a-4376-af89-42199340b5fb', 1, 3, NULL, 'invoice.not_paid', 'messages', 'Not Paid', 'active', NULL, NULL, '2025-06-21 00:42:33', '2025-06-21 00:42:33'),
(737, '9f34afba-67c5-4305-8eb8-ab23308d0381', 1, 3, NULL, 'invoice.print_invoice', 'messages', 'Print Invoice', 'active', NULL, NULL, '2025-06-21 00:42:33', '2025-06-21 00:42:33'),
(738, '9f34afba-6940-40a9-bf00-d43638ac0c52', 1, 3, NULL, 'nurse.new_nurse', 'messages', 'New Nurse', 'active', NULL, NULL, '2025-06-21 00:42:33', '2025-06-21 00:42:33'),
(739, '9f34afba-6abd-45de-ba07-447eb99e7d7b', 1, 3, NULL, 'nurse.edit_nurse', 'messages', 'Edit Nurse', 'active', NULL, NULL, '2025-06-21 00:42:33', '2025-06-21 00:42:33'),
(740, '9f34afba-6c2b-4c24-87ba-19b37e7bf876', 1, 3, NULL, 'nurse.nurse_details', 'messages', 'Nurse Details', 'active', NULL, NULL, '2025-06-21 00:42:33', '2025-06-21 00:42:33'),
(741, '9f34afba-6dd3-45cb-a69b-7aac442c7e1d', 1, 3, NULL, 'nurse.phone_no', 'messages', 'Phone No', 'active', NULL, NULL, '2025-06-21 00:42:33', '2025-06-21 00:42:33'),
(742, '9f34afba-6f4c-42b1-9fca-4131ba7901ca', 1, 3, NULL, 'nurse.birth_date', 'messages', 'Birth Date', 'active', NULL, NULL, '2025-06-21 00:42:33', '2025-06-21 00:42:33'),
(743, '9f34afba-70cb-4190-9e92-e863c2eb928b', 1, 3, NULL, 'nurse.choose', 'messages', 'Choose', 'active', NULL, NULL, '2025-06-21 00:42:33', '2025-06-21 00:42:33'),
(744, '9f34afba-723e-4db7-a186-edd416dd1237', 1, 3, NULL, 'patient.new_patient', 'messages', 'New Patient', 'active', NULL, NULL, '2025-06-21 00:42:33', '2025-06-21 00:42:33'),
(745, '9f34afba-73b2-4668-941f-da88db823614', 1, 3, NULL, 'patient.edit_patient', 'messages', 'Edit Patient', 'active', NULL, NULL, '2025-06-21 00:42:33', '2025-06-21 00:42:33'),
(746, '9f34afba-7525-4dcd-b851-e33a0e803391', 1, 3, NULL, 'patient.patient_details', 'messages', 'Patient Details', 'active', NULL, NULL, '2025-06-21 00:42:33', '2025-06-21 00:42:33'),
(747, '9f34afba-769e-4f3c-9316-71e61379f3a1', 1, 3, NULL, 'patient.total_cases', 'messages', 'Total Cases', 'active', NULL, NULL, '2025-06-21 00:42:33', '2025-06-21 00:42:33'),
(748, '9f34afba-782f-4802-b8e3-d97b8e771bc7', 1, 3, NULL, 'patient.total_admissions', 'messages', 'Total Admissions', 'active', NULL, NULL, '2025-06-21 00:42:33', '2025-06-21 00:42:33'),
(749, '9f34afba-79a8-4794-8e3f-10dc495c7bd1', 1, 3, NULL, 'patient.total_appointments', 'messages', 'Total Appointments', 'active', NULL, NULL, '2025-06-21 00:42:33', '2025-06-21 00:42:33'),
(750, '9f34afba-7b1d-404d-a67a-255c103b0fba', 1, 3, NULL, 'payment.payment', 'messages', 'Payment', 'active', NULL, NULL, '2025-06-21 00:42:33', '2025-06-21 00:42:33'),
(751, '9f34afba-7c8a-41f7-8220-f01a4f6acf45', 1, 3, NULL, 'payment.payments', 'messages', 'Payments', 'active', NULL, NULL, '2025-06-21 00:42:33', '2025-06-21 00:42:33'),
(752, '9f34afba-7e09-44e8-9544-189c336e8cd6', 1, 3, NULL, 'payment.payment_details', 'messages', 'Payment Details', 'active', NULL, NULL, '2025-06-21 00:42:33', '2025-06-21 00:42:33'),
(753, '9f34afba-7f75-4e66-8702-756bf7b55b56', 1, 3, NULL, 'payment.new_payment', 'messages', 'New Payment', 'active', NULL, NULL, '2025-06-21 00:42:33', '2025-06-21 00:42:33'),
(754, '9f34afba-810f-4fc1-b11a-f849a4be2c85', 1, 3, NULL, 'payment.edit_payment', 'messages', 'Edit Payment', 'active', NULL, NULL, '2025-06-21 00:42:33', '2025-06-21 00:42:33'),
(755, '9f34afba-828c-4ff2-a200-443ce3a0b138', 1, 3, NULL, 'payment.account_name', 'messages', 'Account Name', 'active', NULL, NULL, '2025-06-21 00:42:33', '2025-06-21 00:42:33'),
(756, '9f34afba-8403-4bcd-9fc5-30cace0debad', 1, 3, NULL, 'payment.payment_date', 'messages', 'Payment Date', 'active', NULL, NULL, '2025-06-21 00:42:33', '2025-06-21 00:42:33'),
(757, '9f34afba-85d6-40be-ad93-a3701bce8d01', 1, 3, NULL, 'payment.pay_to', 'messages', 'Pay To', 'active', NULL, NULL, '2025-06-21 00:42:33', '2025-06-21 00:42:33'),
(758, '9f34afba-8749-4b12-9b83-883a54f074e6', 1, 3, NULL, 'payment.amount', 'messages', 'Amount', 'active', NULL, NULL, '2025-06-21 00:42:33', '2025-06-21 00:42:33'),
(759, '9f34afba-88b9-478f-a0ae-1673c7ddccba', 1, 3, NULL, 'payment.account', 'messages', 'Account', 'active', NULL, NULL, '2025-06-21 00:42:33', '2025-06-21 00:42:33'),
(760, '9f34afba-8a2a-4a6b-9706-70fe54e168e8', 1, 3, NULL, 'payment.description', 'messages', 'Description', 'active', NULL, NULL, '2025-06-21 00:42:33', '2025-06-21 00:42:33'),
(761, '9f34afba-8b9f-46a5-8f50-733c2fbd4576', 1, 3, NULL, 'payment.payment_reports', 'messages', 'Payment Reports', 'active', NULL, NULL, '2025-06-21 00:42:33', '2025-06-21 00:42:33'),
(762, '9f34afba-8d20-49e1-a373-9ebda5cb349a', 1, 3, NULL, 'payment.your_payment_is_successfully_completed', 'messages', 'Your Payment is successfully completed', 'active', NULL, NULL, '2025-06-21 00:42:33', '2025-06-21 00:42:33'),
(763, '9f34afba-8eac-441d-92ca-33a59d67a6b9', 1, 3, NULL, 'payment.payment_failed', 'messages', 'Sorry! Payment is failed, Try again after some time', 'active', NULL, NULL, '2025-06-21 00:42:33', '2025-06-21 00:42:33'),
(764, '9f34afba-904b-44cf-909c-5627560cc838', 1, 3, NULL, 'transaction_filter.manual', 'messages', 'Manual', 'active', NULL, NULL, '2025-06-21 00:42:33', '2025-06-21 00:42:33'),
(765, '9f34afba-91cd-4611-a781-433989c0b7eb', 1, 3, NULL, 'transaction_filter.razorpay', 'messages', 'Razorpay', 'active', NULL, NULL, '2025-06-21 00:42:33', '2025-06-21 00:42:33'),
(766, '9f34afba-934e-4d19-b20e-a071a3869453', 1, 3, NULL, 'transaction_filter.paypal', 'messages', 'Paypal', 'active', NULL, NULL, '2025-06-21 00:42:33', '2025-06-21 00:42:33'),
(767, '9f34afba-94c7-4506-a8b6-1abf68c03f60', 1, 3, NULL, 'transaction_filter.stripe', 'messages', 'Stripe', 'active', NULL, NULL, '2025-06-21 00:42:33', '2025-06-21 00:42:33'),
(768, '9f34afba-9661-41cd-a13d-4975fb7d9e43', 1, 3, NULL, 'transaction_filter.paystack', 'messages', 'Paystack', 'active', NULL, NULL, '2025-06-21 00:42:33', '2025-06-21 00:42:33'),
(769, '9f34afba-97cd-4498-8288-ae9aaaf54b42', 1, 3, NULL, 'transaction_filter.paytm', 'messages', 'Paytm', 'active', NULL, NULL, '2025-06-21 00:42:33', '2025-06-21 00:42:33'),
(770, '9f34afba-995a-478e-bbdd-160daeb7973d', 1, 3, NULL, 'transaction_filter.cash', 'messages', 'Cash', 'active', NULL, NULL, '2025-06-21 00:42:33', '2025-06-21 00:42:33'),
(771, '9f34afba-9acb-4eac-b151-5c3b2e59d1a1', 1, 3, NULL, 'transaction_filter.cheque', 'messages', 'Cheque', 'active', NULL, NULL, '2025-06-21 00:42:33', '2025-06-21 00:42:33'),
(772, '9f34afba-9c4a-4334-ba7b-9084278ed562', 1, 3, NULL, 'advanced_payment.advanced_payment', 'messages', 'Advance Payment', 'active', NULL, NULL, '2025-06-21 00:42:33', '2025-06-21 00:42:33'),
(773, '9f34afba-9dca-4b5c-bc6e-9d48fd807fa8', 1, 3, NULL, 'advanced_payment.advanced_payments', 'messages', 'Advance Payments', 'active', NULL, NULL, '2025-06-21 00:42:33', '2025-06-21 00:42:33'),
(774, '9f34afba-9f5a-48bf-be67-18882b05a47c', 1, 3, NULL, 'advanced_payment.advanced_payment_details', 'messages', 'Advance Payment Details', 'active', NULL, NULL, '2025-06-21 00:42:33', '2025-06-21 00:42:33'),
(775, '9f34afba-a0ed-4487-ab90-e379b85d746e', 1, 3, NULL, 'advanced_payment.new_advanced_payment', 'messages', 'New Advance Payment', 'active', NULL, NULL, '2025-06-21 00:42:33', '2025-06-21 00:42:33'),
(776, '9f34afba-a262-4e14-90cc-d6e11a6d090c', 1, 3, NULL, 'advanced_payment.edit_advanced_payment', 'messages', 'Edit Advance Payment', 'active', NULL, NULL, '2025-06-21 00:42:33', '2025-06-21 00:42:33'),
(777, '9f34afba-a3e6-4eca-b520-628d2e1bc995', 1, 3, NULL, 'advanced_payment.patient', 'messages', 'Patient', 'active', NULL, NULL, '2025-06-21 00:42:33', '2025-06-21 00:42:33'),
(778, '9f34afba-a55b-4566-9652-3f12ec7a09e3', 1, 3, NULL, 'advanced_payment.receipt_no', 'messages', 'Receipt No', 'active', NULL, NULL, '2025-06-21 00:42:33', '2025-06-21 00:42:33'),
(779, '9f34afba-a6d4-4b32-a85f-4cf358f5847f', 1, 3, NULL, 'advanced_payment.amount', 'messages', 'Amount', 'active', NULL, NULL, '2025-06-21 00:42:33', '2025-06-21 00:42:33'),
(780, '9f34afba-a867-4773-a978-3aa35c62aa66', 1, 3, NULL, 'advanced_payment.date', 'messages', 'Date', 'active', NULL, NULL, '2025-06-21 00:42:33', '2025-06-21 00:42:33'),
(781, '9f34afba-aa01-4e22-90db-004c51885321', 1, 3, NULL, 'advanced_payment.patient_name', 'messages', 'Patient Name', 'active', NULL, NULL, '2025-06-21 00:42:33', '2025-06-21 00:42:33'),
(782, '9f34afba-ab8b-4f0f-af0e-0cd4a811386e', 1, 3, NULL, 'bed.bed', 'messages', 'New Bed', 'active', NULL, NULL, '2025-06-21 00:42:33', '2025-06-21 00:42:33'),
(783, '9f34afba-ad03-48d5-ba74-d0321c7d1aa0', 1, 3, NULL, 'bed.beds', 'messages', 'Beds', 'active', NULL, NULL, '2025-06-21 00:42:33', '2025-06-21 00:42:33'),
(784, '9f34afba-ae72-4286-941d-f28cdb110548', 1, 3, NULL, 'bed.bed_details', 'messages', 'Bed Details', 'active', NULL, NULL, '2025-06-21 00:42:33', '2025-06-21 00:42:33'),
(785, '9f34afba-afdf-4f3d-af23-d3fbc7d0ce71', 1, 3, NULL, 'bed.new_bed', 'messages', 'New Bed', 'active', NULL, NULL, '2025-06-21 00:42:33', '2025-06-21 00:42:33'),
(786, '9f34afba-b159-4d5a-a9e5-db3709697a98', 1, 3, NULL, 'bed.edit_bed', 'messages', 'Edit Bed', 'active', NULL, NULL, '2025-06-21 00:42:33', '2025-06-21 00:42:33'),
(787, '9f34afba-b2c8-4e57-a38d-7d591c660678', 1, 3, NULL, 'bed.new_bulk_bed', 'messages', 'New Bulk Bed', 'active', NULL, NULL, '2025-06-21 00:42:33', '2025-06-21 00:42:33'),
(788, '9f34afba-b462-4f4d-a61b-0d6b0cffab58', 1, 3, NULL, 'bed.name', 'messages', 'Name', 'active', NULL, NULL, '2025-06-21 00:42:33', '2025-06-21 00:42:33'),
(789, '9f34afba-b5f5-40de-b9fd-c2c8fa067d9f', 1, 3, NULL, 'bed.bed_type', 'messages', 'Bed Type', 'active', NULL, NULL, '2025-06-21 00:42:33', '2025-06-21 00:42:33'),
(790, '9f34afba-b786-4df9-94d4-c33a0b160da5', 1, 3, NULL, 'bed.charge', 'messages', 'Charge', 'active', NULL, NULL, '2025-06-21 00:42:33', '2025-06-21 00:42:33'),
(791, '9f34afba-b906-401e-a1a1-89574ddf9faf', 1, 3, NULL, 'bed.available', 'messages', 'Available', 'active', NULL, NULL, '2025-06-21 00:42:33', '2025-06-21 00:42:33'),
(792, '9f34afba-ba88-444a-93b0-afab51e9e40a', 1, 3, NULL, 'bed.not_available', 'messages', 'Not Available', 'active', NULL, NULL, '2025-06-21 00:42:33', '2025-06-21 00:42:33'),
(793, '9f34afba-bc04-464f-8cf9-3dd93d21d332', 1, 3, NULL, 'bed.description', 'messages', 'Description', 'active', NULL, NULL, '2025-06-21 00:42:33', '2025-06-21 00:42:33'),
(794, '9f34afba-bd8a-48d7-a0fc-6d633ff26685', 1, 3, NULL, 'bed.add', 'messages', 'Add', 'active', NULL, NULL, '2025-06-21 00:42:33', '2025-06-21 00:42:33'),
(795, '9f34afba-bf0c-4898-a1c9-2f5ee19878d7', 1, 3, NULL, 'bed.bed_id', 'messages', 'Bed ID', 'active', NULL, NULL, '2025-06-21 00:42:33', '2025-06-21 00:42:33'),
(796, '9f34afba-c0b7-4e4a-bacc-42d661935278', 1, 3, NULL, 'bed.select_bed_type', 'messages', 'Select Bed Type', 'active', NULL, NULL, '2025-06-21 00:42:33', '2025-06-21 00:42:33'),
(797, '9f34afba-c244-4040-aa05-c91e35201926', 1, 3, NULL, 'bed.select_bed', 'messages', 'Select Bed', 'active', NULL, NULL, '2025-06-21 00:42:33', '2025-06-21 00:42:33'),
(798, '9f34afba-c3be-4dd1-852b-94e3f87b0dc7', 1, 3, NULL, 'bed.choose_bed', 'messages', 'Choose Bed', 'active', NULL, NULL, '2025-06-21 00:42:33', '2025-06-21 00:42:33'),
(799, '9f34afba-c541-4307-bb4e-f9f91204e51f', 1, 3, NULL, 'bed_type.bed_type', 'messages', 'Bed Type', 'active', NULL, NULL, '2025-06-21 00:42:33', '2025-06-21 00:42:33'),
(800, '9f34afba-c6bb-4d98-8ea0-8fe632ce0f5f', 1, 3, NULL, 'bed_type.bed_types', 'messages', 'Bed Types', 'active', NULL, NULL, '2025-06-21 00:42:33', '2025-06-21 00:42:33'),
(801, '9f34afba-c864-4ec7-9185-3f27e212b9d8', 1, 3, NULL, 'bed_type.bed_type_details', 'messages', 'Bed Type Details', 'active', NULL, NULL, '2025-06-21 00:42:33', '2025-06-21 00:42:33'),
(802, '9f34afba-c9e7-4f9f-9cbe-0de90e1774a1', 1, 3, NULL, 'bed_type.new_bed_type', 'messages', 'New Bed Type', 'active', NULL, NULL, '2025-06-21 00:42:33', '2025-06-21 00:42:33'),
(803, '9f34afba-cb62-437d-ad31-0d1ecad62adb', 1, 3, NULL, 'bed_type.edit_bed_type', 'messages', 'Edit Bed Type', 'active', NULL, NULL, '2025-06-21 00:42:33', '2025-06-21 00:42:33'),
(804, '9f34afba-cce4-4ea0-9c66-ebc514f2a5cb', 1, 3, NULL, 'bed_type.title', 'messages', 'Title', 'active', NULL, NULL, '2025-06-21 00:42:33', '2025-06-21 00:42:33'),
(805, '9f34afba-ce5c-47f5-88bf-6880adb871b7', 1, 3, NULL, 'bed_type.description', 'messages', 'Description', 'active', NULL, NULL, '2025-06-21 00:42:33', '2025-06-21 00:42:33'),
(806, '9f34afba-cfd5-4169-8887-deee3a0be8c6', 1, 3, NULL, 'doctor.new_doctor', 'messages', 'New Doctor', 'active', NULL, NULL, '2025-06-21 00:42:33', '2025-06-21 00:42:33'),
(807, '9f34afba-d161-4519-b312-7080edf9b659', 1, 3, NULL, 'doctor.edit_doctor', 'messages', 'Edit Doctor', 'active', NULL, NULL, '2025-06-21 00:42:33', '2025-06-21 00:42:33'),
(808, '9f34afba-d2f3-4fc6-85f1-ef10556fc384', 1, 3, NULL, 'doctor.doctor_details', 'messages', 'Doctor Details', 'active', NULL, NULL, '2025-06-21 00:42:33', '2025-06-21 00:42:33'),
(809, '9f34afba-d472-4d40-b5af-2adcbba2b923', 1, 3, NULL, 'doctor.specialist', 'messages', 'Specialist', 'active', NULL, NULL, '2025-06-21 00:42:33', '2025-06-21 00:42:33'),
(810, '9f34afba-d5ef-49d6-ba01-dcddcbf8bc64', 1, 3, NULL, 'doctor.name', 'messages', 'Name', 'active', NULL, NULL, '2025-06-21 00:42:33', '2025-06-21 00:42:33'),
(811, '9f34afba-d771-4aca-b5e7-719847455d2d', 1, 3, NULL, 'bed_assign.bed_assign', 'messages', 'Bed Assign', 'active', NULL, NULL, '2025-06-21 00:42:33', '2025-06-21 00:42:33'),
(812, '9f34afba-d8f4-4dd7-9cdc-304697741ea2', 1, 3, NULL, 'bed_assign.bed_assigns', 'messages', 'Bed Assigns', 'active', NULL, NULL, '2025-06-21 00:42:33', '2025-06-21 00:42:33'),
(813, '9f34afba-db7f-4021-b995-52ea8c320caf', 1, 3, NULL, 'bed_assign.bed_assign_details', 'messages', 'Bed Assign Details', 'active', NULL, NULL, '2025-06-21 00:42:33', '2025-06-21 00:42:33'),
(814, '9f34afba-dd11-4fcc-b08f-16ab68df92e7', 1, 3, NULL, 'bed_assign.new_bed_assign', 'messages', 'New Bed Assign', 'active', NULL, NULL, '2025-06-21 00:42:33', '2025-06-21 00:42:33'),
(815, '9f34afba-deae-4eea-a097-1258395c49df', 1, 3, NULL, 'bed_assign.edit_bed_assign', 'messages', 'Edit Bed Assign', 'active', NULL, NULL, '2025-06-21 00:42:33', '2025-06-21 00:42:33'),
(816, '9f34afba-e04b-4f22-b7a1-b7828960cc9c', 1, 3, NULL, 'bed_assign.patient_name', 'messages', 'Patient Name', 'active', NULL, NULL, '2025-06-21 00:42:33', '2025-06-21 00:42:33'),
(817, '9f34afba-e1fb-44ee-9a8d-90219076c2c6', 1, 3, NULL, 'bed_assign.bed_name', 'messages', 'Bed Name', 'active', NULL, NULL, '2025-06-21 00:42:33', '2025-06-21 00:42:33'),
(818, '9f34afba-e382-48fd-ac7e-1861e0740571', 1, 3, NULL, 'bed_assign.case_id', 'messages', 'Case ID', 'active', NULL, NULL, '2025-06-21 00:42:33', '2025-06-21 00:42:33'),
(819, '9f34afba-e50a-4074-926e-abccffafabbe', 1, 3, NULL, 'bed_assign.assign_date', 'messages', 'Assign Date', 'active', NULL, NULL, '2025-06-21 00:42:33', '2025-06-21 00:42:33'),
(820, '9f34afba-e68b-474a-8eb3-0cddfe0fbf31', 1, 3, NULL, 'bed_assign.discharge_date', 'messages', 'Discharge Date', 'active', NULL, NULL, '2025-06-21 00:42:33', '2025-06-21 00:42:33'),
(821, '9f34afba-e808-4509-bf35-94ee895815dd', 1, 3, NULL, 'bed_assign.bed', 'messages', 'Bed', 'active', NULL, NULL, '2025-06-21 00:42:33', '2025-06-21 00:42:33'),
(822, '9f34afba-e992-4208-9808-816f4ecd494c', 1, 3, NULL, 'bed_assign.description', 'messages', 'Description', 'active', NULL, NULL, '2025-06-21 00:42:33', '2025-06-21 00:42:33'),
(823, '9f34afba-eb0f-47bf-b032-39a80d55a33b', 1, 3, NULL, 'bed_assign.assigned', 'messages', 'Assigned', 'active', NULL, NULL, '2025-06-21 00:42:33', '2025-06-21 00:42:33'),
(824, '9f34afba-ec8a-4db9-82c7-f43a4a87e014', 1, 3, NULL, 'bed_assign.not_assigned', 'messages', 'Not Assigned', 'active', NULL, NULL, '2025-06-21 00:42:33', '2025-06-21 00:42:33'),
(825, '9f34afba-ee06-4ff9-860c-6994312c5fb8', 1, 3, NULL, 'bed_assign.ipd_patient_id', 'messages', 'IPD Patient ID', 'active', NULL, NULL, '2025-06-21 00:42:33', '2025-06-21 00:42:33'),
(826, '9f34afba-ef7f-49c4-acaa-8ea0dbba6e94', 1, 3, NULL, 'bed_assign.assign_date_should_not_be_smaller_than_patient_birth_date', 'messages', 'Bed Assign date should not be smaller than patient birth date.', 'active', NULL, NULL, '2025-06-21 00:42:33', '2025-06-21 00:42:33'),
(827, '9f34afba-f12b-442d-9d53-7d4828880012', 1, 3, NULL, 'package.package', 'messages', 'Package', 'active', NULL, NULL, '2025-06-21 00:42:33', '2025-06-21 00:42:33'),
(828, '9f34afba-f2bb-4e98-99cb-b328b03cefd6', 1, 3, NULL, 'package.packages', 'messages', 'Packages', 'active', NULL, NULL, '2025-06-21 00:42:33', '2025-06-21 00:42:33'),
(829, '9f34afba-f444-4cf4-8bc4-08f71f43f5ef', 1, 3, NULL, 'package.package_details', 'messages', 'Package Details', 'active', NULL, NULL, '2025-06-21 00:42:33', '2025-06-21 00:42:33'),
(830, '9f34afba-f5d7-4bab-b0cf-5e29f38ca630', 1, 3, NULL, 'package.new_package', 'messages', 'New Package', 'active', NULL, NULL, '2025-06-21 00:42:33', '2025-06-21 00:42:33'),
(831, '9f34afba-f763-4f3d-a1bb-22ae758de065', 1, 3, NULL, 'package.edit_package', 'messages', 'Edit Package', 'active', NULL, NULL, '2025-06-21 00:42:33', '2025-06-21 00:42:33'),
(832, '9f34afba-f8ce-489a-b8fb-59b2e5194f2c', 1, 3, NULL, 'package.name', 'messages', 'Name', 'active', NULL, NULL, '2025-06-21 00:42:33', '2025-06-21 00:42:33'),
(833, '9f34afba-faa6-4e2c-9f8a-849943fe0820', 1, 3, NULL, 'package.description', 'messages', 'Description', 'active', NULL, NULL, '2025-06-21 00:42:33', '2025-06-21 00:42:33'),
(834, '9f34afba-fc38-4632-bb70-39c34b5e87ed', 1, 3, NULL, 'package.discount', 'messages', 'Discount', 'active', NULL, NULL, '2025-06-21 00:42:33', '2025-06-21 00:42:33'),
(835, '9f34afba-fdb4-4b1c-94e9-deb525f8903c', 1, 3, NULL, 'package.total_amount', 'messages', 'Total Amount', 'active', NULL, NULL, '2025-06-21 00:42:33', '2025-06-21 00:42:33'),
(836, '9f34afba-ff4a-439b-8cbc-65224969289e', 1, 3, NULL, 'package.service', 'messages', 'Service', 'active', NULL, NULL, '2025-06-21 00:42:33', '2025-06-21 00:42:33'),
(837, '9f34afbb-00d6-488d-bbc8-f33a5cfdc0f1', 1, 3, NULL, 'package.qty', 'messages', 'Qty', 'active', NULL, NULL, '2025-06-21 00:42:33', '2025-06-21 00:42:33'),
(838, '9f34afbb-0258-482a-86d0-1c935953605f', 1, 3, NULL, 'package.rate', 'messages', 'Rate', 'active', NULL, NULL, '2025-06-21 00:42:33', '2025-06-21 00:42:33'),
(839, '9f34afbb-03d2-4723-b29e-bb5de00d39b6', 1, 3, NULL, 'package.amount', 'messages', 'Amount', 'active', NULL, NULL, '2025-06-21 00:42:33', '2025-06-21 00:42:33'),
(840, '9f34afbb-055b-48c0-ba1a-77df5975cdfa', 1, 3, NULL, 'package.select_service', 'messages', 'Select Service', 'active', NULL, NULL, '2025-06-21 00:42:33', '2025-06-21 00:42:33'),
(841, '9f34afbb-06e4-4559-a1cf-ba4af162c168', 1, 3, NULL, 'bill.print_bill', 'messages', 'Print Bill', 'active', NULL, NULL, '2025-06-21 00:42:33', '2025-06-21 00:42:33'),
(842, '9f34afbb-0886-4424-af61-da64a605b3b0', 1, 3, NULL, 'bill.bill_id', 'messages', 'Bill ID', 'active', NULL, NULL, '2025-06-21 00:42:33', '2025-06-21 00:42:33'),
(843, '9f34afbb-0a0a-49f0-a9a5-d95b0f2610c7', 1, 3, NULL, 'bill.bill', 'messages', 'Bill', 'active', NULL, NULL, '2025-06-21 00:42:33', '2025-06-21 00:42:33'),
(844, '9f34afbb-0bc6-48d3-8348-ebf89823cdd0', 1, 3, NULL, 'bill.bills', 'messages', 'Bills', 'active', NULL, NULL, '2025-06-21 00:42:33', '2025-06-21 00:42:33'),
(845, '9f34afbb-0da4-42f6-a6b0-b434649ef4ed', 1, 3, NULL, 'bill.bill_details', 'messages', 'Bill Details', 'active', NULL, NULL, '2025-06-21 00:42:33', '2025-06-21 00:42:33'),
(846, '9f34afbb-0f62-4b33-931c-2261ce76d8db', 1, 3, NULL, 'bill.new_bill', 'messages', 'New Bill', 'active', NULL, NULL, '2025-06-21 00:42:33', '2025-06-21 00:42:33'),
(847, '9f34afbb-10f2-42cd-b527-4886cac0d086', 1, 3, NULL, 'bill.edit_bill', 'messages', 'Edit Bill', 'active', NULL, NULL, '2025-06-21 00:42:33', '2025-06-21 00:42:33'),
(848, '9f34afbb-1297-4dee-ba38-ee10d75b015c', 1, 3, NULL, 'bill.patient', 'messages', 'Patient', 'active', NULL, NULL, '2025-06-21 00:42:33', '2025-06-21 00:42:33'),
(849, '9f34afbb-142f-4cba-8e9d-7196a074604b', 1, 3, NULL, 'bill.bill_date', 'messages', 'Bill Date', 'active', NULL, NULL, '2025-06-21 00:42:33', '2025-06-21 00:42:33'),
(850, '9f34afbb-15b8-445e-b1f5-2a3e17300c8f', 1, 3, NULL, 'bill.amount', 'messages', 'Amount', 'active', NULL, NULL, '2025-06-21 00:42:33', '2025-06-21 00:42:33'),
(851, '9f34afbb-1742-46b5-82aa-053dd2f1ab6e', 1, 3, NULL, 'bill.admission_id', 'messages', 'Admission ID', 'active', NULL, NULL, '2025-06-21 00:42:33', '2025-06-21 00:42:33');
INSERT INTO `ltu_phrases` (`id`, `uuid`, `translation_id`, `translation_file_id`, `phrase_id`, `key`, `group`, `value`, `status`, `parameters`, `note`, `created_at`, `updated_at`) VALUES
(852, '9f34afbb-18d3-4467-bc60-173c8825fef1', 1, 3, NULL, 'bill.patient_name', 'messages', 'Patient Name', 'active', NULL, NULL, '2025-06-21 00:42:33', '2025-06-21 00:42:33'),
(853, '9f34afbb-1a8c-41af-9b49-151762b65da8', 1, 3, NULL, 'bill.patient_email', 'messages', 'Patient Email', 'active', NULL, NULL, '2025-06-21 00:42:33', '2025-06-21 00:42:33'),
(854, '9f34afbb-1c30-415f-8ed6-4f825485d18f', 1, 3, NULL, 'bill.patient_cell_no', 'messages', 'Patient Cell No', 'active', NULL, NULL, '2025-06-21 00:42:33', '2025-06-21 00:42:33'),
(855, '9f34afbb-1db6-460d-b88f-b91a41937bd4', 1, 3, NULL, 'bill.patient_gender', 'messages', 'Patient Gender', 'active', NULL, NULL, '2025-06-21 00:42:33', '2025-06-21 00:42:33'),
(856, '9f34afbb-1f59-4e0e-9299-ab7d0355eff0', 1, 3, NULL, 'bill.patient_dob', 'messages', 'Patient DOB', 'active', NULL, NULL, '2025-06-21 00:42:33', '2025-06-21 00:42:33'),
(857, '9f34afbb-20ea-4ef0-b1ae-b047b0256d44', 1, 3, NULL, 'bill.doctor_name', 'messages', 'Doctor Name', 'active', NULL, NULL, '2025-06-21 00:42:33', '2025-06-21 00:42:33'),
(858, '9f34afbb-2287-4f31-aa04-cb565acbdbc4', 1, 3, NULL, 'bill.admission_date', 'messages', 'Admission Date', 'active', NULL, NULL, '2025-06-21 00:42:33', '2025-06-21 00:42:33'),
(859, '9f34afbb-2432-47a8-8940-764839e3eaaf', 1, 3, NULL, 'bill.discharge_date', 'messages', 'Discharge Date', 'active', NULL, NULL, '2025-06-21 00:42:33', '2025-06-21 00:42:33'),
(860, '9f34afbb-25c4-4846-93a5-880cf024d284', 1, 3, NULL, 'bill.package_name', 'messages', 'Package Name', 'active', NULL, NULL, '2025-06-21 00:42:33', '2025-06-21 00:42:33'),
(861, '9f34afbb-2755-43d9-a536-0df49cfeda85', 1, 3, NULL, 'bill.insurance_name', 'messages', 'Insurance Name', 'active', NULL, NULL, '2025-06-21 00:42:33', '2025-06-21 00:42:33'),
(862, '9f34afbb-28db-410d-b8c3-e34b7b8970b1', 1, 3, NULL, 'bill.total_days', 'messages', 'Total Days', 'active', NULL, NULL, '2025-06-21 00:42:33', '2025-06-21 00:42:33'),
(863, '9f34afbb-2a5c-443a-a61d-dcb36f3be3ed', 1, 3, NULL, 'bill.policy_no', 'messages', 'Policy No', 'active', NULL, NULL, '2025-06-21 00:42:33', '2025-06-21 00:42:33'),
(864, '9f34afbb-2beb-42f8-83cc-368f6c1bbbd9', 1, 3, NULL, 'bill.item_name', 'messages', 'Item Name', 'active', NULL, NULL, '2025-06-21 00:42:33', '2025-06-21 00:42:33'),
(865, '9f34afbb-2d89-46ec-8d5f-678c6f63c6f4', 1, 3, NULL, 'bill.qty', 'messages', 'Qty', 'active', NULL, NULL, '2025-06-21 00:42:33', '2025-06-21 00:42:33'),
(866, '9f34afbb-2f20-4288-8c3a-d64af2015d86', 1, 3, NULL, 'bill.price', 'messages', 'Price', 'active', NULL, NULL, '2025-06-21 00:42:33', '2025-06-21 00:42:33'),
(867, '9f34afbb-30c0-47af-b561-87ccd4b1bf9b', 1, 3, NULL, 'bill.add', 'messages', 'Add', 'active', NULL, NULL, '2025-06-21 00:42:33', '2025-06-21 00:42:33'),
(868, '9f34afbb-3271-47e7-a993-c6ab86f1a1fb', 1, 3, NULL, 'bill.total_amount', 'messages', 'Total Amount', 'active', NULL, NULL, '2025-06-21 00:42:33', '2025-06-21 00:42:33'),
(869, '9f34afbb-3423-4317-af58-b3fe5eb6e7a9', 1, 3, NULL, 'bill.edit', 'messages', 'Edit', 'active', NULL, NULL, '2025-06-21 00:42:33', '2025-06-21 00:42:33'),
(870, '9f34afbb-35a3-4932-ac06-7e80ff4f0799', 1, 3, NULL, 'bill.cell_no', 'messages', 'Cell No', 'active', NULL, NULL, '2025-06-21 00:42:33', '2025-06-21 00:42:33'),
(871, '9f34afbb-3733-4794-a9d5-7e34e4257bcc', 1, 3, NULL, 'bill.bill_summary', 'messages', 'Bill Summary', 'active', NULL, NULL, '2025-06-21 00:42:33', '2025-06-21 00:42:33'),
(872, '9f34afbb-38c5-4480-aa34-fac7b9f00c75', 1, 3, NULL, 'bill.generate_bill', 'messages', 'Generate Bill', 'active', NULL, NULL, '2025-06-21 00:42:33', '2025-06-21 00:42:33'),
(873, '9f34afbb-3a51-4464-bf86-a7e2c0fe60e7', 1, 3, NULL, 'bill.update_bill', 'messages', 'Update Bill', 'active', NULL, NULL, '2025-06-21 00:42:33', '2025-06-21 00:42:33'),
(874, '9f34afbb-3be4-4ef8-b359-edb684293b5e', 1, 3, NULL, 'bill.calculate', 'messages', 'Calculate', 'active', NULL, NULL, '2025-06-21 00:42:33', '2025-06-21 00:42:33'),
(875, '9f34afbb-3d64-4ca8-8e20-7bedba7e493f', 1, 3, NULL, 'blood_donor.blood_donor', 'messages', 'Blood Donor', 'active', NULL, NULL, '2025-06-21 00:42:33', '2025-06-21 00:42:33'),
(876, '9f34afbb-3ef4-4992-9025-f33d159aa772', 1, 3, NULL, 'blood_donor.blood_donors', 'messages', 'Blood Donors', 'active', NULL, NULL, '2025-06-21 00:42:33', '2025-06-21 00:42:33'),
(877, '9f34afbb-4080-4651-a56e-91b4b43d0ec7', 1, 3, NULL, 'blood_donor.blood_donor_details', 'messages', 'Blood Donor Details', 'active', NULL, NULL, '2025-06-21 00:42:34', '2025-06-21 00:42:34'),
(878, '9f34afbb-421d-472d-ad9c-8e4238a036ee', 1, 3, NULL, 'blood_donor.new_blood_donor', 'messages', 'New Blood Donor', 'active', NULL, NULL, '2025-06-21 00:42:34', '2025-06-21 00:42:34'),
(879, '9f34afbb-43c6-4c2e-8380-ea029e4e70bb', 1, 3, NULL, 'blood_donor.edit_blood_donor', 'messages', 'Edit Blood Donor', 'active', NULL, NULL, '2025-06-21 00:42:34', '2025-06-21 00:42:34'),
(880, '9f34afbb-4559-4f74-ba7b-b574f4ae1c57', 1, 3, NULL, 'blood_donor.name', 'messages', 'Name', 'active', NULL, NULL, '2025-06-21 00:42:34', '2025-06-21 00:42:34'),
(881, '9f34afbb-4714-4e26-be2d-08c1c030e9c3', 1, 3, NULL, 'blood_donor.age', 'messages', 'Age', 'active', NULL, NULL, '2025-06-21 00:42:34', '2025-06-21 00:42:34'),
(882, '9f34afbb-48a6-48bc-90b2-1a84fce99b9e', 1, 3, NULL, 'blood_donor.gender', 'messages', 'Gender', 'active', NULL, NULL, '2025-06-21 00:42:34', '2025-06-21 00:42:34'),
(883, '9f34afbb-4a36-4bac-8916-e04e86c8f828', 1, 3, NULL, 'blood_donor.blood_group', 'messages', 'Blood Group', 'active', NULL, NULL, '2025-06-21 00:42:34', '2025-06-21 00:42:34'),
(884, '9f34afbb-4bd0-471d-a6ce-8e51660968b6', 1, 3, NULL, 'blood_donor.donation_date', 'messages', 'Donation Date', 'active', NULL, NULL, '2025-06-21 00:42:34', '2025-06-21 00:42:34'),
(885, '9f34afbb-4d7a-47c4-9150-f2d282b3533a', 1, 3, NULL, 'blood_donor.last_donation_date', 'messages', 'Last Donation Date', 'active', NULL, NULL, '2025-06-21 00:42:34', '2025-06-21 00:42:34'),
(886, '9f34afbb-4f01-4554-ada9-3062b4240717', 1, 3, NULL, 'hospital_blood_bank.blood_bank', 'messages', 'Blood Bank', 'active', NULL, NULL, '2025-06-21 00:42:34', '2025-06-21 00:42:34'),
(887, '9f34afbb-509b-44bb-a1a5-c57a862d916d', 1, 3, NULL, 'hospital_blood_bank.blood_banks', 'messages', 'Blood Banks', 'active', NULL, NULL, '2025-06-21 00:42:34', '2025-06-21 00:42:34'),
(888, '9f34afbb-5216-4efb-8c3f-0af1d76cc8cc', 1, 3, NULL, 'hospital_blood_bank.blood_bank_details', 'messages', 'Blood Bank Details', 'active', NULL, NULL, '2025-06-21 00:42:34', '2025-06-21 00:42:34'),
(889, '9f34afbb-53a8-497d-bbcc-24e823c57e9e', 1, 3, NULL, 'hospital_blood_bank.new_blood_group', 'messages', 'New Blood Group', 'active', NULL, NULL, '2025-06-21 00:42:34', '2025-06-21 00:42:34'),
(890, '9f34afbb-5537-41f1-8a2c-6fc216fea310', 1, 3, NULL, 'hospital_blood_bank.edit_blood_group', 'messages', 'Edit Blood Group', 'active', NULL, NULL, '2025-06-21 00:42:34', '2025-06-21 00:42:34'),
(891, '9f34afbb-56be-4f13-b0b0-5aa6afeea50a', 1, 3, NULL, 'hospital_blood_bank.blood_group', 'messages', 'Blood Group', 'active', NULL, NULL, '2025-06-21 00:42:34', '2025-06-21 00:42:34'),
(892, '9f34afbb-5abe-4146-b8d6-52b4f06233cc', 1, 3, NULL, 'hospital_blood_bank.remained_bags', 'messages', 'Remained Bags', 'active', NULL, NULL, '2025-06-21 00:42:34', '2025-06-21 00:42:34'),
(893, '9f34afbb-5c68-4343-938c-8f8d46501698', 1, 3, NULL, 'case.case', 'messages', 'Case', 'active', NULL, NULL, '2025-06-21 00:42:34', '2025-06-21 00:42:34'),
(894, '9f34afbb-5dfe-4a03-9d7e-c7e07c49da99', 1, 3, NULL, 'case.select_case', 'messages', 'Select Case', 'active', NULL, NULL, '2025-06-21 00:42:34', '2025-06-21 00:42:34'),
(895, '9f34afbb-5f8f-48b1-bac1-9b8eee183b25', 1, 3, NULL, 'case.case_date', 'messages', 'Case Date', 'active', NULL, NULL, '2025-06-21 00:42:34', '2025-06-21 00:42:34'),
(896, '9f34afbb-626a-4843-afdc-ebcd0d96e387', 1, 3, NULL, 'case.new_case', 'messages', 'New Case', 'active', NULL, NULL, '2025-06-21 00:42:34', '2025-06-21 00:42:34'),
(897, '9f34afbb-6452-4578-9099-cd68205c18d9', 1, 3, NULL, 'case.edit_case', 'messages', 'Edit Case', 'active', NULL, NULL, '2025-06-21 00:42:34', '2025-06-21 00:42:34'),
(898, '9f34afbb-65f6-4033-a272-1439aae4d788', 1, 3, NULL, 'case.case_details', 'messages', 'Case Details', 'active', NULL, NULL, '2025-06-21 00:42:34', '2025-06-21 00:42:34'),
(899, '9f34afbb-6780-44da-bd9a-68f464137df1', 1, 3, NULL, 'case.phone', 'messages', 'Phone', 'active', NULL, NULL, '2025-06-21 00:42:34', '2025-06-21 00:42:34'),
(900, '9f34afbb-6929-4170-b2d8-cbd3df1a442b', 1, 3, NULL, 'case.fee', 'messages', 'Fee', 'active', NULL, NULL, '2025-06-21 00:42:34', '2025-06-21 00:42:34'),
(901, '9f34afbb-6ab8-4a86-b7bd-c2bae4661f89', 1, 3, NULL, 'case.patient', 'messages', 'Patient', 'active', NULL, NULL, '2025-06-21 00:42:34', '2025-06-21 00:42:34'),
(902, '9f34afbb-6c6b-4b92-a179-d033c3fc4970', 1, 3, NULL, 'case.doctor', 'messages', 'Doctor', 'active', NULL, NULL, '2025-06-21 00:42:34', '2025-06-21 00:42:34'),
(903, '9f34afbb-6e19-497c-a575-045aeb975c56', 1, 3, NULL, 'case.case_id', 'messages', 'Case ID', 'active', NULL, NULL, '2025-06-21 00:42:34', '2025-06-21 00:42:34'),
(904, '9f34afbb-6fa6-49f3-af2a-6f8b88dad8c4', 1, 3, NULL, 'case.date', 'messages', 'Date', 'active', NULL, NULL, '2025-06-21 00:42:34', '2025-06-21 00:42:34'),
(905, '9f34afbb-7143-4945-9092-5f3fdd552363', 1, 3, NULL, 'case.description', 'messages', 'Description', 'active', NULL, NULL, '2025-06-21 00:42:34', '2025-06-21 00:42:34'),
(906, '9f34afbb-72e9-4ba4-ba51-24ce2b651d4a', 1, 3, NULL, 'service.new_service', 'messages', 'New Service', 'active', NULL, NULL, '2025-06-21 00:42:34', '2025-06-21 00:42:34'),
(907, '9f34afbb-7496-4bef-928d-b424958666e8', 1, 3, NULL, 'service.edit_service', 'messages', 'Edit Service', 'active', NULL, NULL, '2025-06-21 00:42:34', '2025-06-21 00:42:34'),
(908, '9f34afbb-7649-4ac8-856e-ef417408befe', 1, 3, NULL, 'service.service_details', 'messages', 'Service Details', 'active', NULL, NULL, '2025-06-21 00:42:34', '2025-06-21 00:42:34'),
(909, '9f34afbb-77db-4986-be13-8c7478d6b7bc', 1, 3, NULL, 'service.quantity', 'messages', 'Quantity', 'active', NULL, NULL, '2025-06-21 00:42:34', '2025-06-21 00:42:34'),
(910, '9f34afbb-7992-4faa-bbb3-a21c74eeff8f', 1, 3, NULL, 'service.rate', 'messages', 'Rate', 'active', NULL, NULL, '2025-06-21 00:42:34', '2025-06-21 00:42:34'),
(911, '9f34afbb-7b2a-41bf-ae8c-5f48c26e477c', 1, 3, NULL, 'service.given', 'messages', 'Given', 'active', NULL, NULL, '2025-06-21 00:42:34', '2025-06-21 00:42:34'),
(912, '9f34afbb-7cc4-46c0-b88c-0fb8e82b38a8', 1, 3, NULL, 'service.not_given', 'messages', 'Not Given', 'active', NULL, NULL, '2025-06-21 00:42:34', '2025-06-21 00:42:34'),
(913, '9f34afbb-7e4e-4c36-92fb-078a7e82833d', 1, 3, NULL, 'appointment.new_appointment', 'messages', 'New Appointment', 'active', NULL, NULL, '2025-06-21 00:42:34', '2025-06-21 00:42:34'),
(914, '9f34afbb-7fe0-4002-a779-02193df7fc97', 1, 3, NULL, 'appointment.edit_appointment', 'messages', 'Edit Appointment', 'active', NULL, NULL, '2025-06-21 00:42:34', '2025-06-21 00:42:34'),
(915, '9f34afbb-81b4-420c-8276-5d3995d8f7b0', 1, 3, NULL, 'appointment.appointment_details', 'messages', 'Appointment Details', 'active', NULL, NULL, '2025-06-21 00:42:34', '2025-06-21 00:42:34'),
(916, '9f34afbb-8351-4d28-8315-d2ad926695ce', 1, 3, NULL, 'appointment.calendar_view', 'messages', 'Calendar View', 'active', NULL, NULL, '2025-06-21 00:42:34', '2025-06-21 00:42:34'),
(917, '9f34afbb-84e0-4da4-9102-61a51582ebf8', 1, 3, NULL, 'appointment.patient_name', 'messages', 'Patient Name', 'active', NULL, NULL, '2025-06-21 00:42:34', '2025-06-21 00:42:34'),
(918, '9f34afbb-8678-40eb-9e45-05e76f86d63a', 1, 3, NULL, 'appointment.doctor_name', 'messages', 'Doctor Name', 'active', NULL, NULL, '2025-06-21 00:42:34', '2025-06-21 00:42:34'),
(919, '9f34afbb-8816-492a-ae2e-55c8f6690456', 1, 3, NULL, 'appointment.department_name', 'messages', 'Department Name', 'active', NULL, NULL, '2025-06-21 00:42:34', '2025-06-21 00:42:34'),
(920, '9f34afbb-89a9-4243-b808-5fc04db0d95d', 1, 3, NULL, 'appointment.date', 'messages', 'Date', 'active', NULL, NULL, '2025-06-21 00:42:34', '2025-06-21 00:42:34'),
(921, '9f34afbb-8b3a-4a28-91d2-ed5e09edbf80', 1, 3, NULL, 'appointment.doctor_department', 'messages', 'Doctor Department', 'active', NULL, NULL, '2025-06-21 00:42:34', '2025-06-21 00:42:34'),
(922, '9f34afbb-8cc8-43ce-8e04-aa6befbe7276', 1, 3, NULL, 'appointment.doctor_department_name', 'messages', 'Doctor Department Name', 'active', NULL, NULL, '2025-06-21 00:42:34', '2025-06-21 00:42:34'),
(923, '9f34afbb-8e60-4673-a552-99518c8c2fc1', 1, 3, NULL, 'appointment.doctor', 'messages', 'Doctor', 'active', NULL, NULL, '2025-06-21 00:42:34', '2025-06-21 00:42:34'),
(924, '9f34afbb-8ff3-4535-9137-5c4253e93eb1', 1, 3, NULL, 'appointment.description', 'messages', 'Description', 'active', NULL, NULL, '2025-06-21 00:42:34', '2025-06-21 00:42:34'),
(925, '9f34afbb-9193-4b9a-8a3c-8a9b4d42471c', 1, 3, NULL, 'appointment.patient', 'messages', 'Patient', 'active', NULL, NULL, '2025-06-21 00:42:34', '2025-06-21 00:42:34'),
(926, '9f34afbb-9332-423a-8102-178b8a8e3b82', 1, 3, NULL, 'appointment.appointment_calendar', 'messages', 'Appointment Calendar', 'active', NULL, NULL, '2025-06-21 00:42:34', '2025-06-21 00:42:34'),
(927, '9f34afbb-94ec-4b76-bda4-f001490b1aca', 1, 3, NULL, 'appointment.appointment_list', 'messages', 'Appointment List', 'active', NULL, NULL, '2025-06-21 00:42:34', '2025-06-21 00:42:34'),
(928, '9f34afbb-9693-4c8f-a127-a717c6cf9a24', 1, 3, NULL, 'appointment.completed', 'messages', 'Completed', 'active', NULL, NULL, '2025-06-21 00:42:34', '2025-06-21 00:42:34'),
(929, '9f34afbb-981f-4119-90e8-dc13643f1814', 1, 3, NULL, 'appointment.pending', 'messages', 'Pending', 'active', NULL, NULL, '2025-06-21 00:42:34', '2025-06-21 00:42:34'),
(930, '9f34afbb-99b3-46f8-a220-e05cb275828f', 1, 3, NULL, 'appointment.available_slot', 'messages', 'Available Slot', 'active', NULL, NULL, '2025-06-21 00:42:34', '2025-06-21 00:42:34'),
(931, '9f34afbb-9b45-4817-b6c2-ba495c55f0cb', 1, 3, NULL, 'appointment.no_available', 'messages', 'Not Available', 'active', NULL, NULL, '2025-06-21 00:42:34', '2025-06-21 00:42:34'),
(932, '9f34afbb-9cf5-403d-a126-11d27d16601b', 1, 3, NULL, 'appointment.today', 'messages', 'Today', 'active', NULL, NULL, '2025-06-21 00:42:34', '2025-06-21 00:42:34'),
(933, '9f34afbb-9eb1-49e1-94d3-1c1303c797f9', 1, 3, NULL, 'appointment.month', 'messages', 'Month', 'active', NULL, NULL, '2025-06-21 00:42:34', '2025-06-21 00:42:34'),
(934, '9f34afbb-a03f-428f-8ce6-82c1eaf2f777', 1, 3, NULL, 'appointment.week', 'messages', 'Week', 'active', NULL, NULL, '2025-06-21 00:42:34', '2025-06-21 00:42:34'),
(935, '9f34afbb-a1e0-462e-b2a0-4b921e8d5a12', 1, 3, NULL, 'appointment.day', 'messages', 'Day', 'active', NULL, NULL, '2025-06-21 00:42:34', '2025-06-21 00:42:34'),
(936, '9f34afbb-a383-4456-9206-16198e15e9a4', 1, 3, NULL, 'appointment.opd_date', 'messages', 'Opd Date', 'active', NULL, NULL, '2025-06-21 00:42:34', '2025-06-21 00:42:34'),
(937, '9f34afbb-a524-41f9-b463-858351a886ea', 1, 3, NULL, 'appointment.yesterday', 'messages', 'Yesterday', 'active', NULL, NULL, '2025-06-21 00:42:34', '2025-06-21 00:42:34'),
(938, '9f34afbb-a6d7-4b02-915b-b845b1708e38', 1, 3, NULL, 'appointment.this_week', 'messages', 'This Week', 'active', NULL, NULL, '2025-06-21 00:42:34', '2025-06-21 00:42:34'),
(939, '9f34afbb-a87b-438f-bd2e-8bc052de9f46', 1, 3, NULL, 'appointment.last_7_days', 'messages', 'Last 7 days', 'active', NULL, NULL, '2025-06-21 00:42:34', '2025-06-21 00:42:34'),
(940, '9f34afbb-aa33-4f7e-b8aa-49dffa778b2a', 1, 3, NULL, 'appointment.last_30_days', 'messages', 'Last 30 days', 'active', NULL, NULL, '2025-06-21 00:42:34', '2025-06-21 00:42:34'),
(941, '9f34afbb-abed-4bcd-83a4-8c2cbb56607a', 1, 3, NULL, 'appointment.this_month', 'messages', 'This month', 'active', NULL, NULL, '2025-06-21 00:42:34', '2025-06-21 00:42:34'),
(942, '9f34afbb-ada0-401c-bf11-177923ebec88', 1, 3, NULL, 'appointment.last_month', 'messages', 'Last month', 'active', NULL, NULL, '2025-06-21 00:42:34', '2025-06-21 00:42:34'),
(943, '9f34afbb-af3f-4602-892d-8a221fa8683a', 1, 3, NULL, 'appointment.custom', 'messages', 'Custom', 'active', NULL, NULL, '2025-06-21 00:42:34', '2025-06-21 00:42:34'),
(944, '9f34afbb-b0d5-45f4-ba5a-4952600df6f9', 1, 3, NULL, 'appointment.start_date', 'messages', 'Start Date', 'active', NULL, NULL, '2025-06-21 00:42:34', '2025-06-21 00:42:34'),
(945, '9f34afbb-b27d-42db-8f70-1b634ced7245', 1, 3, NULL, 'appointment.end_date', 'messages', 'End Date', 'active', NULL, NULL, '2025-06-21 00:42:34', '2025-06-21 00:42:34'),
(946, '9f34afbb-b41e-4090-9ebb-dbf87273de59', 1, 3, NULL, 'appointment.change_status', 'messages', 'Change status', 'active', NULL, NULL, '2025-06-21 00:42:34', '2025-06-21 00:42:34'),
(947, '9f34afbb-b5bb-4350-913b-06dd1408775d', 1, 3, NULL, 'appointment.are_you_sure_want_to_change', 'messages', 'Are you sure want to change ', 'active', NULL, NULL, '2025-06-21 00:42:34', '2025-06-21 00:42:34'),
(948, '9f34afbb-b759-4b85-b25e-425c71249359', 1, 3, NULL, 'appointment.changed_appointment', 'messages', 'Changed Appointment', 'active', NULL, NULL, '2025-06-21 00:42:34', '2025-06-21 00:42:34'),
(949, '9f34afbb-b8e8-45b1-b667-8a6cb6b3ef57', 1, 3, NULL, 'appointment.has_been_changed', 'messages', 'has been Changed.', 'active', NULL, NULL, '2025-06-21 00:42:34', '2025-06-21 00:42:34'),
(950, '9f34afbb-ba7a-49be-893f-8a8dae80117c', 1, 3, NULL, 'appointment.are_you_sure_want_to_cancel', 'messages', 'Are you sure want to cancel', 'active', NULL, NULL, '2025-06-21 00:42:34', '2025-06-21 00:42:34'),
(951, '9f34afbb-bc17-4046-a6a5-b24d95a8eb56', 1, 3, NULL, 'appointment.has_been_cancelled', 'messages', 'has been Cancelled.', 'active', NULL, NULL, '2025-06-21 00:42:34', '2025-06-21 00:42:34'),
(952, '9f34afbb-be18-47e0-b5a7-398bfca9c68a', 1, 3, NULL, 'appointment.please_select_doctor', 'messages', 'Please select Doctor', 'active', NULL, NULL, '2025-06-21 00:42:34', '2025-06-21 00:42:34'),
(953, '9f34afbb-bfc3-4793-a375-be7bbade66f3', 1, 3, NULL, 'appointment.doctor_schedule_not_available_on_this_date', 'messages', 'Doctor Schedule not available this date.', 'active', NULL, NULL, '2025-06-21 00:42:34', '2025-06-21 00:42:34'),
(954, '9f34afbb-c158-4af8-bdc4-c76d7ed06ec4', 1, 3, NULL, 'appointment.patient_not_exists_or_status_is_not_active', 'messages', 'Patient not exists or status is not active.', 'active', NULL, NULL, '2025-06-21 00:42:34', '2025-06-21 00:42:34'),
(955, '9f34afbb-c306-4217-b65c-be353b6089c1', 1, 3, NULL, 'appointment.please_select_appointment_time_slot', 'messages', 'Please select appointment time slot', 'active', NULL, NULL, '2025-06-21 00:42:34', '2025-06-21 00:42:34'),
(956, '9f34afbb-c4a0-4b1a-befd-6f8b19d33c30', 1, 3, NULL, 'appointment.time', 'messages', 'Time', 'active', NULL, NULL, '2025-06-21 00:42:34', '2025-06-21 00:42:34'),
(957, '9f34afbb-c655-422b-bbdd-acef258b165f', 1, 3, NULL, 'case_handler.new_case_handler', 'messages', 'New Case Handler', 'active', NULL, NULL, '2025-06-21 00:42:34', '2025-06-21 00:42:34'),
(958, '9f34afbb-c80d-4086-8848-9ec2910a3286', 1, 3, NULL, 'case_handler.edit_case_handler', 'messages', 'Edit Case Handler', 'active', NULL, NULL, '2025-06-21 00:42:34', '2025-06-21 00:42:34'),
(959, '9f34afbb-c9ac-4895-89ac-81710e1d4014', 1, 3, NULL, 'case_handler.case_handler_detail', 'messages', 'Case Handler Details', 'active', NULL, NULL, '2025-06-21 00:42:34', '2025-06-21 00:42:34'),
(960, '9f34afbb-cb4c-4729-a626-5daeb16d2195', 1, 3, NULL, 'lab_tech.new_lab_tech', 'messages', 'New Lab Technician', 'active', NULL, NULL, '2025-06-21 00:42:34', '2025-06-21 00:42:34'),
(961, '9f34afbb-ccee-4a9e-932c-a51c49457a07', 1, 3, NULL, 'lab_tech.edit_lab_tech', 'messages', 'Edit Lab Technician', 'active', NULL, NULL, '2025-06-21 00:42:34', '2025-06-21 00:42:34'),
(962, '9f34afbb-ce98-420b-8339-83ac021cce9d', 1, 3, NULL, 'lab_tech.lab_tech_detail', 'messages', 'Lab Technician Details', 'active', NULL, NULL, '2025-06-21 00:42:34', '2025-06-21 00:42:34'),
(963, '9f34afbb-d040-4770-b2f8-d4ede0580569', 1, 3, NULL, 'doc_type.new_doc_type', 'messages', 'New Document Type', 'active', NULL, NULL, '2025-06-21 00:42:34', '2025-06-21 00:42:34'),
(964, '9f34afbb-d1da-4f2d-b14d-24b68019c0f7', 1, 3, NULL, 'doc_type.edit_doc_type', 'messages', 'Edit Document Type', 'active', NULL, NULL, '2025-06-21 00:42:34', '2025-06-21 00:42:34'),
(965, '9f34afbb-d3a2-438d-adf0-87e3b42d43eb', 1, 3, NULL, 'doc_type.name', 'messages', 'Name', 'active', NULL, NULL, '2025-06-21 00:42:34', '2025-06-21 00:42:34'),
(966, '9f34afbb-d54d-45ac-9aa2-9099253c319b', 1, 3, NULL, 'document.document', 'messages', 'Document', 'active', NULL, NULL, '2025-06-21 00:42:34', '2025-06-21 00:42:34'),
(967, '9f34afbb-d6f0-4e6e-87ab-79b260e74609', 1, 3, NULL, 'document.documents', 'messages', 'Documents', 'active', NULL, NULL, '2025-06-21 00:42:34', '2025-06-21 00:42:34'),
(968, '9f34afbb-d899-4bd5-952d-69d45354d003', 1, 3, NULL, 'document.new_document', 'messages', 'New Document', 'active', NULL, NULL, '2025-06-21 00:42:34', '2025-06-21 00:42:34'),
(969, '9f34afbb-da2f-443a-a6c2-2d82857c6ada', 1, 3, NULL, 'document.edit_document', 'messages', 'Edit Document', 'active', NULL, NULL, '2025-06-21 00:42:34', '2025-06-21 00:42:34'),
(970, '9f34afbb-dbda-4e63-b276-ba218e674255', 1, 3, NULL, 'document.title', 'messages', 'Title', 'active', NULL, NULL, '2025-06-21 00:42:34', '2025-06-21 00:42:34'),
(971, '9f34afbb-dd82-4356-b080-a24c76e402ac', 1, 3, NULL, 'document.document_type', 'messages', 'Document Type', 'active', NULL, NULL, '2025-06-21 00:42:34', '2025-06-21 00:42:34'),
(972, '9f34afbb-df31-4853-8752-4f287bbcb600', 1, 3, NULL, 'document.document_type_details', 'messages', 'Document Type Details', 'active', NULL, NULL, '2025-06-21 00:42:34', '2025-06-21 00:42:34'),
(973, '9f34afbb-e0dd-40d9-a091-aca84d658b33', 1, 3, NULL, 'document.patient', 'messages', 'Patient', 'active', NULL, NULL, '2025-06-21 00:42:34', '2025-06-21 00:42:34'),
(974, '9f34afbb-e278-405d-91f6-1b7f7a74e499', 1, 3, NULL, 'document.download', 'messages', 'Download', 'active', NULL, NULL, '2025-06-21 00:42:34', '2025-06-21 00:42:34'),
(975, '9f34afbb-e427-4086-b787-6405b2396aa3', 1, 3, NULL, 'document.select_patient', 'messages', 'Select Patient', 'active', NULL, NULL, '2025-06-21 00:42:34', '2025-06-21 00:42:34'),
(976, '9f34afbb-e5d9-45b9-8a75-1c12db038a79', 1, 3, NULL, 'document.select_account', 'messages', 'Select Account', 'active', NULL, NULL, '2025-06-21 00:42:34', '2025-06-21 00:42:34'),
(977, '9f34afbb-e78b-47fb-b528-cb72b97f7f16', 1, 3, NULL, 'document.select_admission_id', 'messages', 'Select Admission ID', 'active', NULL, NULL, '2025-06-21 00:42:34', '2025-06-21 00:42:34'),
(978, '9f34afbb-e935-4db6-8e8c-2e32e843bad1', 1, 3, NULL, 'document.in_percentage', 'messages', 'In percentage', 'active', NULL, NULL, '2025-06-21 00:42:34', '2025-06-21 00:42:34'),
(979, '9f34afbb-ebe5-4390-a21b-3b4bc91d9eec', 1, 3, NULL, 'document.select_document_type', 'messages', 'Select Document Type', 'active', NULL, NULL, '2025-06-21 00:42:34', '2025-06-21 00:42:34'),
(980, '9f34afbb-edb7-485c-9a45-16ec96749c58', 1, 3, NULL, 'document.uploaded_by', 'messages', 'Uploaded By', 'active', NULL, NULL, '2025-06-21 00:42:34', '2025-06-21 00:42:34'),
(981, '9f34afbb-ef9f-4df9-89ed-e08c0c1b9a43', 1, 3, NULL, 'document.document_detail', 'messages', 'Document Details', 'active', NULL, NULL, '2025-06-21 00:42:34', '2025-06-21 00:42:34'),
(982, '9f34afbb-f165-4c7e-bd7f-71b96f01c554', 1, 3, NULL, 'document.notes', 'messages', 'Notes', 'active', NULL, NULL, '2025-06-21 00:42:34', '2025-06-21 00:42:34'),
(983, '9f34afbb-f308-44ef-9b89-1f09b148c5df', 1, 3, NULL, 'document.view', 'messages', 'View', 'active', NULL, NULL, '2025-06-21 00:42:34', '2025-06-21 00:42:34'),
(984, '9f34afbb-f4a9-4148-ba09-cdee4a48a150', 1, 3, NULL, 'document.attachment', 'messages', 'Attachment', 'active', NULL, NULL, '2025-06-21 00:42:34', '2025-06-21 00:42:34'),
(985, '9f34afbb-f66a-46b4-b4d8-ad4181b529ab', 1, 3, NULL, 'document.change_attachment', 'messages', 'Change Attachment', 'active', NULL, NULL, '2025-06-21 00:42:34', '2025-06-21 00:42:34'),
(986, '9f34afbb-f841-4e79-8176-56efc2d2251a', 1, 3, NULL, 'document.document_file_size', 'messages', 'The document must be a file of type: jpeg, jpg, png, pdf, doc, docx., mp3, mp4', 'active', NULL, NULL, '2025-06-21 00:42:34', '2025-06-21 00:42:34'),
(987, '9f34afbb-f9ef-448f-b19e-d7f061c86d1a', 1, 3, NULL, 'patient_admission.patient_admission', 'messages', 'Patient Admission', 'active', NULL, NULL, '2025-06-21 00:42:34', '2025-06-21 00:42:34'),
(988, '9f34afbb-fbba-4c65-a421-3ccc021ee016', 1, 3, NULL, 'patient_admission.new_patient_admission', 'messages', 'New Patient Admission', 'active', NULL, NULL, '2025-06-21 00:42:34', '2025-06-21 00:42:34'),
(989, '9f34afbb-fd79-4284-af3d-9d138e58c961', 1, 3, NULL, 'patient_admission.edit_patient_admission', 'messages', 'Edit Patient Admission', 'active', NULL, NULL, '2025-06-21 00:42:34', '2025-06-21 00:42:34'),
(990, '9f34afbb-ff2e-4add-9e9d-1e8ce083f585', 1, 3, NULL, 'patient_admission.details', 'messages', 'Patient Admission Details', 'active', NULL, NULL, '2025-06-21 00:42:34', '2025-06-21 00:42:34'),
(991, '9f34afbc-00d9-476a-86c5-5ba1951d9938', 1, 3, NULL, 'patient_admission.patient', 'messages', 'Patient', 'active', NULL, NULL, '2025-06-21 00:42:34', '2025-06-21 00:42:34'),
(992, '9f34afbc-028e-4724-b956-796f2a35df80', 1, 3, NULL, 'patient_admission.patient_name', 'messages', 'Patient Name', 'active', NULL, NULL, '2025-06-21 00:42:34', '2025-06-21 00:42:34'),
(993, '9f34afbc-046d-4228-82c8-dea808956c6b', 1, 3, NULL, 'patient_admission.doctor', 'messages', 'Doctor', 'active', NULL, NULL, '2025-06-21 00:42:34', '2025-06-21 00:42:34'),
(994, '9f34afbc-05fe-42d6-8414-87164d822e7f', 1, 3, NULL, 'patient_admission.doctor_name', 'messages', 'Doctor Name', 'active', NULL, NULL, '2025-06-21 00:42:34', '2025-06-21 00:42:34'),
(995, '9f34afbc-07a6-412a-acce-052707a7a98c', 1, 3, NULL, 'patient_admission.admission_date', 'messages', 'Admission Date', 'active', NULL, NULL, '2025-06-21 00:42:34', '2025-06-21 00:42:34'),
(996, '9f34afbc-093d-4069-9da3-4f4d85db9f58', 1, 3, NULL, 'patient_admission.discharge_date', 'messages', 'Discharge Date', 'active', NULL, NULL, '2025-06-21 00:42:34', '2025-06-21 00:42:34'),
(997, '9f34afbc-0aed-476c-80be-c4670ba383de', 1, 3, NULL, 'patient_admission.package', 'messages', 'Package', 'active', NULL, NULL, '2025-06-21 00:42:34', '2025-06-21 00:42:34'),
(998, '9f34afbc-0c90-4797-8b15-f45fa9dac4c1', 1, 3, NULL, 'patient_admission.package_name', 'messages', 'Package Name', 'active', NULL, NULL, '2025-06-21 00:42:34', '2025-06-21 00:42:34'),
(999, '9f34afbc-0e40-46a4-8bc6-a563304fadd2', 1, 3, NULL, 'patient_admission.insurance', 'messages', 'Insurance', 'active', NULL, NULL, '2025-06-21 00:42:34', '2025-06-21 00:42:34'),
(1000, '9f34afbc-0ffa-4a0e-ac85-991538a58c18', 1, 3, NULL, 'patient_admission.insurance_name', 'messages', 'Insurance Name', 'active', NULL, NULL, '2025-06-21 00:42:34', '2025-06-21 00:42:34'),
(1001, '9f34afbc-11a3-434e-890b-7f384f75ad0f', 1, 3, NULL, 'patient_admission.policy_no', 'messages', 'Policy No', 'active', NULL, NULL, '2025-06-21 00:42:34', '2025-06-21 00:42:34'),
(1002, '9f34afbc-1358-4eb2-b613-d2baa54d287f', 1, 3, NULL, 'patient_admission.bed', 'messages', 'Bed', 'active', NULL, NULL, '2025-06-21 00:42:34', '2025-06-21 00:42:34'),
(1003, '9f34afbc-14fd-4fcf-a61e-32b886add071', 1, 3, NULL, 'patient_admission.agent_name', 'messages', 'Agent Name', 'active', NULL, NULL, '2025-06-21 00:42:34', '2025-06-21 00:42:34'),
(1004, '9f34afbc-16aa-4a96-ba0e-b94f4f5824e4', 1, 3, NULL, 'patient_admission.guardian_name', 'messages', 'Guardian Name', 'active', NULL, NULL, '2025-06-21 00:42:34', '2025-06-21 00:42:34'),
(1005, '9f34afbc-187e-4e0b-acfd-e5ccd71d35ff', 1, 3, NULL, 'patient_admission.guardian_relation', 'messages', 'Guardian Relation', 'active', NULL, NULL, '2025-06-21 00:42:34', '2025-06-21 00:42:34'),
(1006, '9f34afbc-1a2c-4d11-9beb-065c9cd381ec', 1, 3, NULL, 'patient_admission.guardian_contact', 'messages', 'Guardian Contact', 'active', NULL, NULL, '2025-06-21 00:42:34', '2025-06-21 00:42:34'),
(1007, '9f34afbc-1bd7-4344-9153-2aa49c879baa', 1, 3, NULL, 'patient_admission.guardian_address', 'messages', 'Guardian Address', 'active', NULL, NULL, '2025-06-21 00:42:34', '2025-06-21 00:42:34'),
(1008, '9f34afbc-1d99-4739-bf5c-58169d2f98d7', 1, 3, NULL, 'patient_admission.patient_admission_id', 'messages', 'Patient Admission ID', 'active', NULL, NULL, '2025-06-21 00:42:34', '2025-06-21 00:42:34'),
(1009, '9f34afbc-1f35-4d4e-a101-f7c6cff02554', 1, 3, NULL, 'patient_admission.select_package', 'messages', 'Select Package', 'active', NULL, NULL, '2025-06-21 00:42:34', '2025-06-21 00:42:34'),
(1010, '9f34afbc-20e1-4c77-859d-8cbc34828ee7', 1, 3, NULL, 'patient_admission.select_insurance', 'messages', 'Select Insurance', 'active', NULL, NULL, '2025-06-21 00:42:34', '2025-06-21 00:42:34'),
(1011, '9f34afbc-2287-4b9c-a412-fec8ba569dc0', 1, 3, NULL, 'setting.paystack', 'messages', 'PayStack', 'active', NULL, NULL, '2025-06-21 00:42:34', '2025-06-21 00:42:34'),
(1012, '9f34afbc-2440-46dd-8add-dd4ac7105a50', 1, 3, NULL, 'setting.paystack_public_key', 'messages', 'Paystack Public Key', 'active', NULL, NULL, '2025-06-21 00:42:34', '2025-06-21 00:42:34'),
(1013, '9f34afbc-260c-442f-af60-7f7b937c795e', 1, 3, NULL, 'setting.paystack_secret_key', 'messages', 'Paystack Secret Key', 'active', NULL, NULL, '2025-06-21 00:42:34', '2025-06-21 00:42:34'),
(1014, '9f34afbc-27b6-42c9-a870-19efe5f4a497', 1, 3, NULL, 'setting.paytm', 'messages', 'Paytm', 'active', NULL, NULL, '2025-06-21 00:42:34', '2025-06-21 00:42:34'),
(1015, '9f34afbc-2975-4427-a291-983201ca2cf7', 1, 3, NULL, 'setting.paytm_merchant_id', 'messages', 'Paytm Merchant ID', 'active', NULL, NULL, '2025-06-21 00:42:34', '2025-06-21 00:42:34'),
(1016, '9f34afbc-2b29-4359-8a71-d5eccdf22ff6', 1, 3, NULL, 'setting.paytm_merchant_key', 'messages', 'Paytm Merchant Key', 'active', NULL, NULL, '2025-06-21 00:42:34', '2025-06-21 00:42:34'),
(1017, '9f34afbc-2cdf-4550-a4f0-479f09af6cfa', 1, 3, NULL, 'setting.app_name', 'messages', 'App Name', 'active', NULL, NULL, '2025-06-21 00:42:34', '2025-06-21 00:42:34'),
(1018, '9f34afbc-2e90-4e06-95fc-0c34ce1fefd5', 1, 3, NULL, 'setting.company_name', 'messages', 'Company Name', 'active', NULL, NULL, '2025-06-21 00:42:34', '2025-06-21 00:42:34'),
(1019, '9f34afbc-3029-48c7-9582-c3646bb7671d', 1, 3, NULL, 'setting.app_logo', 'messages', 'App Logo', 'active', NULL, NULL, '2025-06-21 00:42:34', '2025-06-21 00:42:34'),
(1020, '9f34afbc-31d4-4595-a910-135f76dc3ef9', 1, 3, NULL, 'setting.change_logo', 'messages', 'Change Logo', 'active', NULL, NULL, '2025-06-21 00:42:34', '2025-06-21 00:42:34'),
(1021, '9f34afbc-3387-4d85-abbb-e5dfc8237b3a', 1, 3, NULL, 'setting.currency', 'messages', 'Current Currency', 'active', NULL, NULL, '2025-06-21 00:42:34', '2025-06-21 00:42:34'),
(1022, '9f34afbc-3536-4672-bd35-63fa8d503764', 1, 3, NULL, 'setting.address', 'messages', 'Hospital Address', 'active', NULL, NULL, '2025-06-21 00:42:34', '2025-06-21 00:42:34'),
(1023, '9f34afbc-36d9-4680-b687-594511732891', 1, 3, NULL, 'setting.hospital_email', 'messages', 'Hospital Email', 'active', NULL, NULL, '2025-06-21 00:42:34', '2025-06-21 00:42:34'),
(1024, '9f34afbc-38ab-4e49-92fc-6c17d859b1b3', 1, 3, NULL, 'setting.hospital_phone', 'messages', 'Hospital Phone', 'active', NULL, NULL, '2025-06-21 00:42:34', '2025-06-21 00:42:34'),
(1025, '9f34afbc-3a5a-42e7-8718-473ca81caac8', 1, 3, NULL, 'setting.hospital_from_day', 'messages', 'Hospital From Day', 'active', NULL, NULL, '2025-06-21 00:42:34', '2025-06-21 00:42:34'),
(1026, '9f34afbc-3c15-4111-a06d-e706628de8c2', 1, 3, NULL, 'setting.hospital_from_time', 'messages', 'Hospital From Time', 'active', NULL, NULL, '2025-06-21 00:42:34', '2025-06-21 00:42:34'),
(1027, '9f34afbc-3dea-45b8-b4a7-04718fd76f79', 1, 3, NULL, 'setting.about_us', 'messages', 'About Us', 'active', NULL, NULL, '2025-06-21 00:42:34', '2025-06-21 00:42:34'),
(1028, '9f34afbc-3fb6-44a7-9f7b-d07761d420c1', 1, 3, NULL, 'setting.image_validation', 'messages', 'The image must be of pixel 90 x 60.', 'active', NULL, NULL, '2025-06-21 00:42:34', '2025-06-21 00:42:34'),
(1029, '9f34afbc-4170-4f24-9f06-bee79f90dc65', 1, 3, NULL, 'setting.favicon', 'messages', 'Favicon', 'active', NULL, NULL, '2025-06-21 00:42:34', '2025-06-21 00:42:34'),
(1030, '9f34afbc-431b-47db-a3b1-c55458af6049', 1, 3, NULL, 'setting.change_favicon', 'messages', 'Change Favicon', 'active', NULL, NULL, '2025-06-21 00:42:34', '2025-06-21 00:42:34'),
(1031, '9f34afbc-44d0-44b1-9e3d-7001c02ca981', 1, 3, NULL, 'setting.favicon_validation', 'messages', 'The image must be of pixel 34 x 34.', 'active', NULL, NULL, '2025-06-21 00:42:34', '2025-06-21 00:42:34'),
(1032, '9f34afbc-4683-4128-a04d-f44f06943eaf', 1, 3, NULL, 'setting.social_details', 'messages', 'Social Details', 'active', NULL, NULL, '2025-06-21 00:42:34', '2025-06-21 00:42:34'),
(1033, '9f34afbc-482f-4a52-b272-e717f20ccdf7', 1, 3, NULL, 'setting.enable_google_reCAPTCHA', 'messages', 'Enable Google reCAPTCHA', 'active', NULL, NULL, '2025-06-21 00:42:34', '2025-06-21 00:42:34'),
(1034, '9f34afbc-49cc-4ebd-9067-6d0d48cc7f98', 1, 3, NULL, 'setting.credential', 'messages', 'Credential', 'active', NULL, NULL, '2025-06-21 00:42:34', '2025-06-21 00:42:34'),
(1035, '9f34afbc-4b8a-4331-ab62-e1e51947da77', 1, 3, NULL, 'setting.clinic_name', 'messages', 'Clinic Name', 'active', NULL, NULL, '2025-06-21 00:42:34', '2025-06-21 00:42:34'),
(1036, '9f34afbc-4d53-4b1a-8672-b8680c70ef4c', 1, 3, NULL, 'setting.credentials', 'messages', 'Credentials', 'active', NULL, NULL, '2025-06-21 00:42:34', '2025-06-21 00:42:34'),
(1037, '9f34afbc-4f18-46e8-8447-907630448f54', 1, 3, NULL, 'setting.stripe', 'messages', 'Stripe', 'active', NULL, NULL, '2025-06-21 00:42:34', '2025-06-21 00:42:34'),
(1038, '9f34afbc-50c9-40e4-8aef-fa587b96fb25', 1, 3, NULL, 'setting.stripe_key', 'messages', 'Stripe key', 'active', NULL, NULL, '2025-06-21 00:42:34', '2025-06-21 00:42:34'),
(1039, '9f34afbc-5273-4101-9b4d-343b0a04f262', 1, 3, NULL, 'setting.stripe_secret', 'messages', 'Stripe Secret', 'active', NULL, NULL, '2025-06-21 00:42:34', '2025-06-21 00:42:34'),
(1040, '9f34afbc-5414-4de0-a3c3-ca9318b411a0', 1, 3, NULL, 'setting.paypal_secret', 'messages', 'Paypal Secret', 'active', NULL, NULL, '2025-06-21 00:42:34', '2025-06-21 00:42:34'),
(1041, '9f34afbc-55ca-4a22-bcf5-a40091eb7cb9', 1, 3, NULL, 'setting.paypal_client_id', 'messages', 'Paypal Client ID', 'active', NULL, NULL, '2025-06-21 00:42:34', '2025-06-21 00:42:34'),
(1042, '9f34afbc-5776-46b6-850e-fde168eb5834', 1, 3, NULL, 'setting.paypal_mode', 'messages', 'Paypal Mode', 'active', NULL, NULL, '2025-06-21 00:42:34', '2025-06-21 00:42:34'),
(1043, '9f34afbc-5933-4e03-bf98-cff81d077f10', 1, 3, NULL, 'setting.paypal', 'messages', 'Paypal', 'active', NULL, NULL, '2025-06-21 00:42:34', '2025-06-21 00:42:34'),
(1044, '9f34afbc-5ae1-4452-a5da-fcbe94ba5165', 1, 3, NULL, 'setting.paypal_key', 'messages', 'Paypal key', 'active', NULL, NULL, '2025-06-21 00:42:34', '2025-06-21 00:42:34'),
(1045, '9f34afbc-5cb3-4119-87cf-6b9f1da32024', 1, 3, NULL, 'setting.razorpay_key', 'messages', 'Razorpay Key', 'active', NULL, NULL, '2025-06-21 00:42:34', '2025-06-21 00:42:34'),
(1046, '9f34afbc-5e6b-4a24-8aa7-95baeeca7f61', 1, 3, NULL, 'setting.razorpay_secret', 'messages', 'Razorpay Secret', 'active', NULL, NULL, '2025-06-21 00:42:34', '2025-06-21 00:42:34'),
(1047, '9f34afbc-603e-4816-a956-e613fa287d35', 1, 3, NULL, 'setting.razorpay', 'messages', 'Razorpay', 'active', NULL, NULL, '2025-06-21 00:42:34', '2025-06-21 00:42:34'),
(1048, '9f34afbc-620b-492c-b486-c3bc424eac93', 1, 3, NULL, 'setting.payment_gateway', 'messages', 'Payment Gateway', 'active', NULL, NULL, '2025-06-21 00:42:34', '2025-06-21 00:42:34'),
(1049, '9f34afbc-63ba-43d9-beea-3ebb278b1cfa', 1, 3, NULL, 'currency.currencies', 'messages', 'Currencies', 'active', NULL, NULL, '2025-06-21 00:42:34', '2025-06-21 00:42:34'),
(1050, '9f34afbc-656c-4aa0-89b3-8b01123a280c', 1, 3, NULL, 'currency.new_currency', 'messages', 'New Currency', 'active', NULL, NULL, '2025-06-21 00:42:34', '2025-06-21 00:42:34'),
(1051, '9f34afbc-671c-4127-a23b-ed9060501a82', 1, 3, NULL, 'currency.edit_currency', 'messages', 'Edit Currency', 'active', NULL, NULL, '2025-06-21 00:42:34', '2025-06-21 00:42:34'),
(1052, '9f34afbc-68d8-46d3-aa89-8852ffadcefa', 1, 3, NULL, 'currency.currency_name', 'messages', 'Currency Name', 'active', NULL, NULL, '2025-06-21 00:42:34', '2025-06-21 00:42:34'),
(1053, '9f34afbc-6ab3-47ab-943e-10f9c478d868', 1, 3, NULL, 'currency.currency_code', 'messages', 'Currency Code', 'active', NULL, NULL, '2025-06-21 00:42:34', '2025-06-21 00:42:34'),
(1054, '9f34afbc-6c86-4d9d-af98-6c4b9bde38c5', 1, 3, NULL, 'currency.currency_icon', 'messages', 'Currency Icon', 'active', NULL, NULL, '2025-06-21 00:42:34', '2025-06-21 00:42:34'),
(1055, '9f34afbc-6e2d-4819-bd0b-636d93a73cd2', 1, 3, NULL, 'currency.add_currency_code_as_per_three_letter_iso_code', 'messages', 'Add currency code as per three-letter ISO code', 'active', NULL, NULL, '2025-06-21 00:42:34', '2025-06-21 00:42:34'),
(1056, '9f34afbc-6fdd-46c7-bc3f-d2fe5ca2bcf9', 1, 3, NULL, 'currency.you_can_find_out_here', 'messages', 'you can find out here', 'active', NULL, NULL, '2025-06-21 00:42:34', '2025-06-21 00:42:34'),
(1057, '9f34afbc-718b-4848-be51-732d87ff90d8', 1, 3, NULL, 'schedule.new', 'messages', 'New Schedule', 'active', NULL, NULL, '2025-06-21 00:42:34', '2025-06-21 00:42:34'),
(1058, '9f34afbc-7346-41d9-b66f-1492566b3ac5', 1, 3, NULL, 'schedule.edit', 'messages', 'Edit Schedule', 'active', NULL, NULL, '2025-06-21 00:42:34', '2025-06-21 00:42:34'),
(1059, '9f34afbc-74ea-42ef-8011-382a673012c2', 1, 3, NULL, 'schedule.details', 'messages', 'Schedule Details', 'active', NULL, NULL, '2025-06-21 00:42:34', '2025-06-21 00:42:34'),
(1060, '9f34afbc-76ba-4fdd-90b3-363a1032d9f7', 1, 3, NULL, 'schedule.doctor_name', 'messages', 'Doctor Name', 'active', NULL, NULL, '2025-06-21 00:42:34', '2025-06-21 00:42:34'),
(1061, '9f34afbc-7879-49f0-9438-f6a2f44b8869', 1, 3, NULL, 'schedule.select_doctor_name', 'messages', 'Select Doctor Name', 'active', NULL, NULL, '2025-06-21 00:42:34', '2025-06-21 00:42:34'),
(1062, '9f34afbc-7a3a-461a-b083-0822ac5e6df0', 1, 3, NULL, 'schedule.per_patient_time', 'messages', 'Per Patient Time', 'active', NULL, NULL, '2025-06-21 00:42:34', '2025-06-21 00:42:34'),
(1063, '9f34afbc-7d0b-4ea2-af36-b16e1fbefe64', 1, 3, NULL, 'schedule.serial_visibility', 'messages', 'Serial Visibility', 'active', NULL, NULL, '2025-06-21 00:42:34', '2025-06-21 00:42:34'),
(1064, '9f34afbc-7ebd-4a1d-a6a4-76b568fc85f7', 1, 3, NULL, 'schedule.select_serial_visibility', 'messages', 'Select Serial Visibility', 'active', NULL, NULL, '2025-06-21 00:42:34', '2025-06-21 00:42:34'),
(1065, '9f34afbc-8087-4519-aba2-0d22a8d9e872', 1, 3, NULL, 'schedule.available_on', 'messages', 'Available On', 'active', NULL, NULL, '2025-06-21 00:42:34', '2025-06-21 00:42:34'),
(1066, '9f34afbc-8249-4864-a519-354d1b7073d9', 1, 3, NULL, 'schedule.available_from', 'messages', 'Available From', 'active', NULL, NULL, '2025-06-21 00:42:34', '2025-06-21 00:42:34'),
(1067, '9f34afbc-8408-4ef8-9269-d02aff6eb928', 1, 3, NULL, 'schedule.available_to', 'messages', 'Available To', 'active', NULL, NULL, '2025-06-21 00:42:34', '2025-06-21 00:42:34'),
(1068, '9f34afbc-85c8-4ab2-a064-085ad0c5af3c', 1, 3, NULL, 'schedule.sequential', 'messages', 'Sequential', 'active', NULL, NULL, '2025-06-21 00:42:34', '2025-06-21 00:42:34'),
(1069, '9f34afbc-8789-4e61-9568-d93c7068ee76', 1, 3, NULL, 'schedule.timestamp', 'messages', 'Timestamp', 'active', NULL, NULL, '2025-06-21 00:42:34', '2025-06-21 00:42:34'),
(1070, '9f34afbc-895c-4d0e-8bf4-a08cb5477e93', 1, 3, NULL, 'notice_board.new', 'messages', 'New Notice Board', 'active', NULL, NULL, '2025-06-21 00:42:34', '2025-06-21 00:42:34'),
(1071, '9f34afbc-8b26-4944-9834-88e75c4488be', 1, 3, NULL, 'notice_board.edit', 'messages', 'Edit Notice Board', 'active', NULL, NULL, '2025-06-21 00:42:34', '2025-06-21 00:42:34'),
(1072, '9f34afbc-8ce3-4c32-9e20-076024712b47', 1, 3, NULL, 'notice_board.details', 'messages', 'Notice Board Details', 'active', NULL, NULL, '2025-06-21 00:42:34', '2025-06-21 00:42:34'),
(1073, '9f34afbc-8e93-4083-a206-16c532c3718c', 1, 3, NULL, 'notice_board.title', 'messages', 'Title', 'active', NULL, NULL, '2025-06-21 00:42:34', '2025-06-21 00:42:34'),
(1074, '9f34afbc-903f-48e0-8baf-6b6ec5971b31', 1, 3, NULL, 'notice_board.description', 'messages', 'Description', 'active', NULL, NULL, '2025-06-21 00:42:34', '2025-06-21 00:42:34'),
(1075, '9f34afbc-9210-427d-9b14-281967a91cd8', 1, 3, NULL, 'notice_board.created_at', 'messages', 'Created At', 'active', NULL, NULL, '2025-06-21 00:42:34', '2025-06-21 00:42:34'),
(1076, '9f34afbc-93db-460c-b618-e8872f2230a1', 1, 3, NULL, 'my_payroll.my_payrolls', 'messages', 'My Payrolls', 'active', NULL, NULL, '2025-06-21 00:42:34', '2025-06-21 00:42:34'),
(1077, '9f34afbc-9587-4fc5-928f-e57b4a4ab99b', 1, 3, NULL, 'my_payroll.basic_salary', 'messages', 'Basic Salary', 'active', NULL, NULL, '2025-06-21 00:42:34', '2025-06-21 00:42:34'),
(1078, '9f34afbc-9744-4ee0-a647-80a706cae50a', 1, 3, NULL, 'my_payroll.allowance', 'messages', 'Allowance', 'active', NULL, NULL, '2025-06-21 00:42:34', '2025-06-21 00:42:34'),
(1079, '9f34afbc-98f3-4ecd-bceb-8934f7146895', 1, 3, NULL, 'my_payroll.deductions', 'messages', 'Deductions', 'active', NULL, NULL, '2025-06-21 00:42:34', '2025-06-21 00:42:34'),
(1080, '9f34afbc-9aa8-4dbe-a80c-f7d4c1c4dd42', 1, 3, NULL, 'my_payroll.net_salary', 'messages', 'Net Salary', 'active', NULL, NULL, '2025-06-21 00:42:34', '2025-06-21 00:42:34'),
(1081, '9f34afbc-9c5a-4442-baad-95f97ffa2de3', 1, 3, NULL, 'medicine.medicine', 'messages', 'Medicine', 'active', NULL, NULL, '2025-06-21 00:42:34', '2025-06-21 00:42:34'),
(1082, '9f34afbc-9e10-471f-8fc2-8b2c1b4751e7', 1, 3, NULL, 'medicine.medicine_category', 'messages', 'Medicine Category', 'active', NULL, NULL, '2025-06-21 00:42:34', '2025-06-21 00:42:34'),
(1083, '9f34afbc-9fe9-4d49-a20f-5bd1372043a3', 1, 3, NULL, 'medicine.medicine_category_details', 'messages', 'Medicine Category Details', 'active', NULL, NULL, '2025-06-21 00:42:34', '2025-06-21 00:42:34'),
(1084, '9f34afbc-a191-487f-91d4-a25cb8f03e17', 1, 3, NULL, 'medicine.medicines', 'messages', 'Medicines', 'active', NULL, NULL, '2025-06-21 00:42:34', '2025-06-21 00:42:34'),
(1085, '9f34afbc-a34a-419d-b56a-a97a6c7d4956', 1, 3, NULL, 'medicine.medicine_details', 'messages', 'Medicine Details', 'active', NULL, NULL, '2025-06-21 00:42:34', '2025-06-21 00:42:34'),
(1086, '9f34afbc-a4f9-45de-b354-caeb8bfc4a0c', 1, 3, NULL, 'medicine.new_medicine', 'messages', 'New Medicine', 'active', NULL, NULL, '2025-06-21 00:42:34', '2025-06-21 00:42:34'),
(1087, '9f34afbc-a6b0-4a51-97ba-4d0192adf062', 1, 3, NULL, 'medicine.new_medicine_category', 'messages', 'New Medicine Category', 'active', NULL, NULL, '2025-06-21 00:42:34', '2025-06-21 00:42:34'),
(1088, '9f34afbc-a864-4f82-b356-25e261c5b354', 1, 3, NULL, 'medicine.edit_medicine_category', 'messages', 'Edit Medicine Category', 'active', NULL, NULL, '2025-06-21 00:42:34', '2025-06-21 00:42:34'),
(1089, '9f34afbc-aa24-4870-8cd4-288091eee6fc', 1, 3, NULL, 'medicine.edit_medicine', 'messages', 'Edit Medicine', 'active', NULL, NULL, '2025-06-21 00:42:34', '2025-06-21 00:42:34'),
(1090, '9f34afbc-abcf-4626-9a2c-77c0a1030eb0', 1, 3, NULL, 'medicine.name', 'messages', 'Name', 'active', NULL, NULL, '2025-06-21 00:42:34', '2025-06-21 00:42:34'),
(1091, '9f34afbc-ad94-48b4-a26c-03fe25b3ee6f', 1, 3, NULL, 'medicine.brand', 'messages', 'Brand', 'active', NULL, NULL, '2025-06-21 00:42:34', '2025-06-21 00:42:34'),
(1092, '9f34afbc-af52-4c5d-b445-ad45724f147f', 1, 3, NULL, 'medicine.selling_price', 'messages', 'Selling Price', 'active', NULL, NULL, '2025-06-21 00:42:34', '2025-06-21 00:42:34'),
(1093, '9f34afbc-b108-4a9f-b28b-dfbe21652f82', 1, 3, NULL, 'medicine.buying_price', 'messages', 'Buying Price', 'active', NULL, NULL, '2025-06-21 00:42:34', '2025-06-21 00:42:34'),
(1094, '9f34afbc-b2e3-451a-a09b-bb71126b64c8', 1, 3, NULL, 'medicine.category', 'messages', 'Category', 'active', NULL, NULL, '2025-06-21 00:42:34', '2025-06-21 00:42:34'),
(1095, '9f34afbc-b4a7-4330-bfe2-1b765f961c3e', 1, 3, NULL, 'medicine.salt_composition', 'messages', 'Salt Composition', 'active', NULL, NULL, '2025-06-21 00:42:34', '2025-06-21 00:42:34'),
(1096, '9f34afbc-b668-4553-9394-59b983752204', 1, 3, NULL, 'medicine.side_effects', 'messages', 'Side Effects', 'active', NULL, NULL, '2025-06-21 00:42:34', '2025-06-21 00:42:34'),
(1097, '9f34afbc-b81f-401b-9f9b-9a7c156a1d54', 1, 3, NULL, 'medicine.description', 'messages', 'Description', 'active', NULL, NULL, '2025-06-21 00:42:34', '2025-06-21 00:42:34'),
(1098, '9f34afbc-b9f4-4904-8177-f6391e4d89de', 1, 3, NULL, 'medicine.category_id', 'messages', 'Category ID', 'active', NULL, NULL, '2025-06-21 00:42:34', '2025-06-21 00:42:34'),
(1099, '9f34afbc-bbbf-4dc0-836e-03986d4a822d', 1, 3, NULL, 'medicine.brand_name', 'messages', 'Brand Name', 'active', NULL, NULL, '2025-06-21 00:42:34', '2025-06-21 00:42:34'),
(1100, '9f34afbc-bd7b-4d8d-8b81-884173e55d82', 1, 3, NULL, 'medicine.medicine_brands', 'messages', 'Medicine Brands', 'active', NULL, NULL, '2025-06-21 00:42:34', '2025-06-21 00:42:34'),
(1101, '9f34afbc-bf2d-4d47-81da-9a0b8813fa08', 1, 3, NULL, 'medicine.medicine_brands_details', 'messages', 'Medicine Brand Details', 'active', NULL, NULL, '2025-06-21 00:42:34', '2025-06-21 00:42:34'),
(1102, '9f34afbc-c0ea-4337-a604-0f2c504b46ae', 1, 3, NULL, 'medicine.new_brand', 'messages', 'New Brand', 'active', NULL, NULL, '2025-06-21 00:42:34', '2025-06-21 00:42:34'),
(1103, '9f34afbc-c2a8-44d2-9837-91d32513d3a5', 1, 3, NULL, 'medicine.new_medicine_brand', 'messages', 'New Medicine Brand', 'active', NULL, NULL, '2025-06-21 00:42:34', '2025-06-21 00:42:34'),
(1104, '9f34afbc-c449-441f-9a59-550084e9e98a', 1, 3, NULL, 'medicine.edit_medicine_brand', 'messages', 'Edit Medicine Brand', 'active', NULL, NULL, '2025-06-21 00:42:34', '2025-06-21 00:42:34'),
(1105, '9f34afbc-c605-4bea-84f0-3d88e1f0b727', 1, 3, NULL, 'medicine.select_category', 'messages', 'Select Category', 'active', NULL, NULL, '2025-06-21 00:42:35', '2025-06-21 00:42:35'),
(1106, '9f34afbc-c7ec-4849-b66b-d4713ae06057', 1, 3, NULL, 'medicine.select_brand', 'messages', 'Select Brand', 'active', NULL, NULL, '2025-06-21 00:42:35', '2025-06-21 00:42:35'),
(1107, '9f34afbc-c9dd-40b8-8c7f-4d251c8b9d3b', 1, 3, NULL, 'medicine.is_active', 'messages', 'Is active', 'active', NULL, NULL, '2025-06-21 00:42:35', '2025-06-21 00:42:35'),
(1108, '9f34afbc-cba8-49ae-9da5-323949de9391', 1, 3, NULL, 'profile.change_language', 'messages', 'Change Language', 'active', NULL, NULL, '2025-06-21 00:42:35', '2025-06-21 00:42:35'),
(1109, '9f34afbc-cd5e-4899-9e45-813f3412ce23', 1, 3, NULL, 'profile.change_Profile', 'messages', 'Change Profile', 'active', NULL, NULL, '2025-06-21 00:42:35', '2025-06-21 00:42:35'),
(1110, '9f34afbc-cf14-4e6b-98cf-ab0eac390cb6', 1, 3, NULL, 'profile.change_post_image', 'messages', 'Change Post Image', 'active', NULL, NULL, '2025-06-21 00:42:35', '2025-06-21 00:42:35'),
(1111, '9f34afbc-d0d5-488f-ae9e-ca7689b422a7', 1, 3, NULL, 'profile.language', 'messages', 'Language', 'active', NULL, NULL, '2025-06-21 00:42:35', '2025-06-21 00:42:35'),
(1112, '9f34afbc-d418-4f77-8b7b-28ed7f74e921', 1, 3, NULL, 'profile.edit_profile', 'messages', 'Edit Profile', 'active', NULL, NULL, '2025-06-21 00:42:35', '2025-06-21 00:42:35'),
(1113, '9f34afbc-d60d-44c3-bc0d-a250fe595351', 1, 3, NULL, 'profile.full_name', 'messages', 'Full Name', 'active', NULL, NULL, '2025-06-21 00:42:35', '2025-06-21 00:42:35'),
(1114, '9f34afbc-d7c5-4740-821b-9e2e39fbd108', 1, 3, NULL, 'profile.first_name', 'messages', 'First Name', 'active', NULL, NULL, '2025-06-21 00:42:35', '2025-06-21 00:42:35'),
(1115, '9f34afbc-d985-4552-9272-91a41c1cf5bf', 1, 3, NULL, 'profile.last_name', 'messages', 'Last Name', 'active', NULL, NULL, '2025-06-21 00:42:35', '2025-06-21 00:42:35'),
(1116, '9f34afbc-db75-4df0-8846-8ed1f4ee5e3b', 1, 3, NULL, 'profile.email', 'messages', 'Email', 'active', NULL, NULL, '2025-06-21 00:42:35', '2025-06-21 00:42:35'),
(1117, '9f34afbc-dd30-45a5-aa3a-8d9eb17bf667', 1, 3, NULL, 'profile.phone', 'messages', 'Phone', 'active', NULL, NULL, '2025-06-21 00:42:35', '2025-06-21 00:42:35'),
(1118, '9f34afbc-def8-421d-aa14-0174e3846dde', 1, 3, NULL, 'profile.profile', 'messages', 'Profile', 'active', NULL, NULL, '2025-06-21 00:42:35', '2025-06-21 00:42:35'),
(1119, '9f34afbc-e0cc-4360-8990-7f2e493f38ff', 1, 3, NULL, 'profile.type', 'messages', 'Type', 'active', NULL, NULL, '2025-06-21 00:42:35', '2025-06-21 00:42:35'),
(1120, '9f34afbc-e2a2-4c53-b837-897270b37959', 1, 3, NULL, 'dashboard.dashboard', 'messages', 'Dashboard', 'active', NULL, NULL, '2025-06-21 00:42:35', '2025-06-21 00:42:35'),
(1121, '9f34afbc-e489-4fc3-8bf5-48d24bdc6a7c', 1, 3, NULL, 'dashboard.total_invoices', 'messages', 'Invoice Amount', 'active', NULL, NULL, '2025-06-21 00:42:35', '2025-06-21 00:42:35'),
(1122, '9f34afbc-e687-4c4c-8426-86a0f7c06d96', 1, 3, NULL, 'dashboard.total_bills', 'messages', 'Billed Amount', 'active', NULL, NULL, '2025-06-21 00:42:35', '2025-06-21 00:42:35'),
(1123, '9f34afbc-e858-4aba-9f71-cf9dcc114fbf', 1, 3, NULL, 'dashboard.total_payments', 'messages', 'Payment Amount', 'active', NULL, NULL, '2025-06-21 00:42:35', '2025-06-21 00:42:35'),
(1124, '9f34afbc-ea15-4900-950c-d361cd06bf98', 1, 3, NULL, 'dashboard.total_advance_payments', 'messages', 'Advance Payment Amount', 'active', NULL, NULL, '2025-06-21 00:42:35', '2025-06-21 00:42:35'),
(1125, '9f34afbc-ebdb-4829-ae17-edf1651137d7', 1, 3, NULL, 'dashboard.notice_boards', 'messages', 'Notice Boards', 'active', NULL, NULL, '2025-06-21 00:42:35', '2025-06-21 00:42:35'),
(1126, '9f34afbc-ed9d-4b73-bf90-e5414883bc0d', 1, 3, NULL, 'dashboard.title', 'messages', 'Title', 'active', NULL, NULL, '2025-06-21 00:42:35', '2025-06-21 00:42:35');
INSERT INTO `ltu_phrases` (`id`, `uuid`, `translation_id`, `translation_file_id`, `phrase_id`, `key`, `group`, `value`, `status`, `parameters`, `note`, `created_at`, `updated_at`) VALUES
(1127, '9f34afbc-ef65-4d3b-b41e-3e0b782cedad', 1, 3, NULL, 'dashboard.doctors', 'messages', 'Doctors', 'active', NULL, NULL, '2025-06-21 00:42:35', '2025-06-21 00:42:35'),
(1128, '9f34afbc-f157-4786-86ec-0106b1c46a04', 1, 3, NULL, 'dashboard.available_beds', 'messages', 'Available Beds', 'active', NULL, NULL, '2025-06-21 00:42:35', '2025-06-21 00:42:35'),
(1129, '9f34afbc-f313-4328-a3e0-ee07bf917406', 1, 3, NULL, 'dashboard.patients', 'messages', 'Patients', 'active', NULL, NULL, '2025-06-21 00:42:35', '2025-06-21 00:42:35'),
(1130, '9f34afbc-f4d4-43f3-8c28-b43d42528d1e', 1, 3, NULL, 'dashboard.income_and_expense_report', 'messages', 'Income and Expense Report', 'active', NULL, NULL, '2025-06-21 00:42:35', '2025-06-21 00:42:35'),
(1131, '9f34afbc-f697-427f-80af-f88cfdee2eb8', 1, 3, NULL, 'dashboard.income_and_expense_reports', 'messages', 'Income and Expense Reports', 'active', NULL, NULL, '2025-06-21 00:42:35', '2025-06-21 00:42:35'),
(1132, '9f34afbc-f84e-4711-a038-09c432e685eb', 1, 3, NULL, 'dashboard.no_enquiries_yet', 'messages', 'No Enquiries yet...', 'active', NULL, NULL, '2025-06-21 00:42:35', '2025-06-21 00:42:35'),
(1133, '9f34afbc-fa0d-468d-bf7a-a4067996b3b6', 1, 3, NULL, 'dashboard.no_notice_yet', 'messages', 'No Notice Boards yet..', 'active', NULL, NULL, '2025-06-21 00:42:35', '2025-06-21 00:42:35'),
(1134, '9f34afbc-fc02-4560-9018-fb727a503914', 1, 3, NULL, 'dashboard.total_hospitals', 'messages', 'Total Hospitals', 'active', NULL, NULL, '2025-06-21 00:42:35', '2025-06-21 00:42:35'),
(1135, '9f34afbc-fdc9-456d-888f-55e4083a4061', 1, 3, NULL, 'dashboard.total_subscription_plans', 'messages', 'Total Subscription Plans', 'active', NULL, NULL, '2025-06-21 00:42:35', '2025-06-21 00:42:35'),
(1136, '9f34afbc-ff8e-4325-b737-0e39a8b4e9cd', 1, 3, NULL, 'dashboard.total_subscribers', 'messages', 'Total Subscribers', 'active', NULL, NULL, '2025-06-21 00:42:35', '2025-06-21 00:42:35'),
(1137, '9f34afbd-0152-447f-a09a-c28abf2bfeb1', 1, 3, NULL, 'dashboard.total_enquiries', 'messages', 'Total Enquiries', 'active', NULL, NULL, '2025-06-21 00:42:35', '2025-06-21 00:42:35'),
(1138, '9f34afbd-0354-4f5b-a419-60ba81d69f9d', 1, 3, NULL, 'dashboard.total_revenue', 'messages', 'Total Revenue', 'active', NULL, NULL, '2025-06-21 00:42:35', '2025-06-21 00:42:35'),
(1139, '9f34afbd-052b-4f7e-bbe2-f284cc2985c0', 1, 3, NULL, 'dashboard.total_active_hospital_plan', 'messages', 'Total Active Hospital Plans', 'active', NULL, NULL, '2025-06-21 00:42:35', '2025-06-21 00:42:35'),
(1140, '9f34afbd-06eb-4ea7-8b1a-746a631eed8e', 1, 3, NULL, 'dashboard.total_expired_hospital_plan', 'messages', 'Total Expired Hospital Plans', 'active', NULL, NULL, '2025-06-21 00:42:35', '2025-06-21 00:42:35'),
(1141, '9f34afbd-08b5-4364-b8d5-5e5e4379616b', 1, 3, NULL, 'dashboard.income_report', 'messages', 'Income Overview', 'active', NULL, NULL, '2025-06-21 00:42:35', '2025-06-21 00:42:35'),
(1142, '9f34afbd-0a98-4720-856e-27fce5e6cf58', 1, 3, NULL, 'dashboard.please_select_rang_picker', 'messages', 'Please Select Rang Picker', 'active', NULL, NULL, '2025-06-21 00:42:35', '2025-06-21 00:42:35'),
(1143, '9f34afbd-0c7e-4f33-bfa9-9775103943da', 1, 3, NULL, 'enquiry.name', 'messages', 'Name', 'active', NULL, NULL, '2025-06-21 00:42:35', '2025-06-21 00:42:35'),
(1144, '9f34afbd-0e37-4be1-bf48-9a16dd49d65f', 1, 3, NULL, 'enquiry.email', 'messages', 'Email', 'active', NULL, NULL, '2025-06-21 00:42:35', '2025-06-21 00:42:35'),
(1145, '9f34afbd-100a-418a-b9d3-13bda94280fa', 1, 3, NULL, 'enquiry.contact', 'messages', 'Contact', 'active', NULL, NULL, '2025-06-21 00:42:35', '2025-06-21 00:42:35'),
(1146, '9f34afbd-1301-4d0e-a32a-113eb4726aae', 1, 3, NULL, 'enquiry.type', 'messages', 'Type', 'active', NULL, NULL, '2025-06-21 00:42:35', '2025-06-21 00:42:35'),
(1147, '9f34afbd-14da-4e88-b814-883e34fa00a0', 1, 3, NULL, 'enquiry.message', 'messages', 'Message', 'active', NULL, NULL, '2025-06-21 00:42:35', '2025-06-21 00:42:35'),
(1148, '9f34afbd-16cf-4663-aeca-83304b1259b1', 1, 3, NULL, 'enquiry.viewed_by', 'messages', 'Viewed By', 'active', NULL, NULL, '2025-06-21 00:42:35', '2025-06-21 00:42:35'),
(1149, '9f34afbd-188e-4b1d-96b0-2bda3b070078', 1, 3, NULL, 'enquiry.enquiry_details', 'messages', 'Enquiry Details', 'active', NULL, NULL, '2025-06-21 00:42:35', '2025-06-21 00:42:35'),
(1150, '9f34afbd-1a91-4719-bb60-f49fc3895568', 1, 3, NULL, 'enquiry.read', 'messages', 'Read', 'active', NULL, NULL, '2025-06-21 00:42:35', '2025-06-21 00:42:35'),
(1151, '9f34afbd-1c72-4670-bd3e-dde468b01a6a', 1, 3, NULL, 'enquiry.unread', 'messages', 'Unread', 'active', NULL, NULL, '2025-06-21 00:42:35', '2025-06-21 00:42:35'),
(1152, '9f34afbd-1e6b-4769-b83d-6019305b4721', 1, 3, NULL, 'enquiry.not_viewed', 'messages', 'Not Viewed', 'active', NULL, NULL, '2025-06-21 00:42:35', '2025-06-21 00:42:35'),
(1153, '9f34afbd-202c-40fd-af8c-ac656e1a036d', 1, 3, NULL, 'enquiry.received_on', 'messages', 'Received On', 'active', NULL, NULL, '2025-06-21 00:42:35', '2025-06-21 00:42:35'),
(1154, '9f34afbd-21e4-40e0-9585-2f74282240de', 1, 3, NULL, 'enquiry.send_enquiry', 'messages', 'Send Enquiry', 'active', NULL, NULL, '2025-06-21 00:42:35', '2025-06-21 00:42:35'),
(1155, '9f34afbd-23d3-47e9-852f-c8cfe1a0c4ae', 1, 3, NULL, 'enquiry.general_enquiry', 'messages', 'General Enquiry', 'active', NULL, NULL, '2025-06-21 00:42:35', '2025-06-21 00:42:35'),
(1156, '9f34afbd-2593-4855-b0cb-5ad94064274f', 1, 3, NULL, 'enquiry.residential_care', 'messages', 'Residential Care', 'active', NULL, NULL, '2025-06-21 00:42:35', '2025-06-21 00:42:35'),
(1157, '9f34afbd-2772-404a-847b-4eee84ba9825', 1, 3, NULL, 'enquiry.feedback/suggestions', 'messages', 'Feedback / Suggestions', 'active', NULL, NULL, '2025-06-21 00:42:35', '2025-06-21 00:42:35'),
(1158, '9f34afbd-293d-436a-b8ff-c3e703f8f324', 1, 3, NULL, 'email.to', 'messages', 'To', 'active', NULL, NULL, '2025-06-21 00:42:35', '2025-06-21 00:42:35'),
(1159, '9f34afbd-2b06-4036-ac68-1f2a6200987e', 1, 3, NULL, 'email.subject', 'messages', 'Subject', 'active', NULL, NULL, '2025-06-21 00:42:35', '2025-06-21 00:42:35'),
(1160, '9f34afbd-2ced-4efd-91c7-72f84ba38be1', 1, 3, NULL, 'email.message', 'messages', 'Message', 'active', NULL, NULL, '2025-06-21 00:42:35', '2025-06-21 00:42:35'),
(1161, '9f34afbd-2ed5-49f6-bbb5-18b23469f5d0', 1, 3, NULL, 'email.attachment', 'messages', 'Attachment', 'active', NULL, NULL, '2025-06-21 00:42:35', '2025-06-21 00:42:35'),
(1162, '9f34afbd-30c9-4dfd-8d58-ad75fe29d45a', 1, 3, NULL, 'ambulance.ambulance', 'messages', 'Ambulance', 'active', NULL, NULL, '2025-06-21 00:42:35', '2025-06-21 00:42:35'),
(1163, '9f34afbd-32a9-40de-b830-182555fb14c5', 1, 3, NULL, 'ambulance.ambulances', 'messages', 'Ambulances', 'active', NULL, NULL, '2025-06-21 00:42:35', '2025-06-21 00:42:35'),
(1164, '9f34afbd-34b4-434e-87f7-e1ab0e26eda7', 1, 3, NULL, 'ambulance.ambulance_details', 'messages', 'Ambulance Details', 'active', NULL, NULL, '2025-06-21 00:42:35', '2025-06-21 00:42:35'),
(1165, '9f34afbd-36a3-4c87-b164-0cfcd52d44e8', 1, 3, NULL, 'ambulance.vehicle_number', 'messages', 'Vehicle Number', 'active', NULL, NULL, '2025-06-21 00:42:35', '2025-06-21 00:42:35'),
(1166, '9f34afbd-3896-400d-ac42-3b631fa01826', 1, 3, NULL, 'ambulance.vehicle_model', 'messages', 'Vehicle Model', 'active', NULL, NULL, '2025-06-21 00:42:35', '2025-06-21 00:42:35'),
(1167, '9f34afbd-3ab2-4074-94e5-84d5afa4901d', 1, 3, NULL, 'ambulance.year_made', 'messages', 'Year Made', 'active', NULL, NULL, '2025-06-21 00:42:35', '2025-06-21 00:42:35'),
(1168, '9f34afbd-3ca6-4731-91d7-2cfacb217d87', 1, 3, NULL, 'ambulance.driver_name', 'messages', 'Driver Name', 'active', NULL, NULL, '2025-06-21 00:42:35', '2025-06-21 00:42:35'),
(1169, '9f34afbd-3e9f-496f-9531-653f09af9315', 1, 3, NULL, 'ambulance.driver_license', 'messages', 'Driver License', 'active', NULL, NULL, '2025-06-21 00:42:35', '2025-06-21 00:42:35'),
(1170, '9f34afbd-407e-44a4-9153-a58b74d24373', 1, 3, NULL, 'ambulance.driver_contact', 'messages', 'Driver Contact', 'active', NULL, NULL, '2025-06-21 00:42:35', '2025-06-21 00:42:35'),
(1171, '9f34afbd-42ab-435d-906f-50429b590620', 1, 3, NULL, 'ambulance.note', 'messages', 'Note', 'active', NULL, NULL, '2025-06-21 00:42:35', '2025-06-21 00:42:35'),
(1172, '9f34afbd-44a3-4d5c-b981-b3f1cff30747', 1, 3, NULL, 'ambulance.vehicle_type', 'messages', 'Vehicle Type', 'active', NULL, NULL, '2025-06-21 00:42:35', '2025-06-21 00:42:35'),
(1173, '9f34afbd-4693-4851-8526-89b00aea9158', 1, 3, NULL, 'ambulance.is_available', 'messages', 'Is Available', 'active', NULL, NULL, '2025-06-21 00:42:35', '2025-06-21 00:42:35'),
(1174, '9f34afbd-4858-48a1-91de-261388a499f9', 1, 3, NULL, 'ambulance.new_ambulance', 'messages', 'New Ambulance', 'active', NULL, NULL, '2025-06-21 00:42:35', '2025-06-21 00:42:35'),
(1175, '9f34afbd-4a41-49dd-8d39-47fbab42bb8b', 1, 3, NULL, 'ambulance.edit_ambulance', 'messages', 'Edit Ambulance', 'active', NULL, NULL, '2025-06-21 00:42:35', '2025-06-21 00:42:35'),
(1176, '9f34afbd-4c15-4754-a438-2ad656f5abef', 1, 3, NULL, 'ambulance.select_ambulance', 'messages', 'Select Ambulance', 'active', NULL, NULL, '2025-06-21 00:42:35', '2025-06-21 00:42:35'),
(1177, '9f34afbd-4de6-4ffa-a67a-697c528651a4', 1, 3, NULL, 'ambulance.owned', 'messages', 'Owned', 'active', NULL, NULL, '2025-06-21 00:42:35', '2025-06-21 00:42:35'),
(1178, '9f34afbd-4fbd-492e-9a51-6e4fe1ec7e7b', 1, 3, NULL, 'ambulance.contractual', 'messages', 'Contractual', 'active', NULL, NULL, '2025-06-21 00:42:35', '2025-06-21 00:42:35'),
(1179, '9f34afbd-5188-4847-933a-4b531acb4e5f', 1, 3, NULL, 'ambulance_call.ambulance_call', 'messages', 'Ambulance Call', 'active', NULL, NULL, '2025-06-21 00:42:35', '2025-06-21 00:42:35'),
(1180, '9f34afbd-535a-42b8-b929-91809f18c8b1', 1, 3, NULL, 'ambulance_call.ambulance_calls', 'messages', 'Ambulance Calls', 'active', NULL, NULL, '2025-06-21 00:42:35', '2025-06-21 00:42:35'),
(1181, '9f34afbd-5543-49c9-93fb-67d97c26bf68', 1, 3, NULL, 'ambulance_call.ambulance_call_details', 'messages', 'Ambulance Call Details', 'active', NULL, NULL, '2025-06-21 00:42:35', '2025-06-21 00:42:35'),
(1182, '9f34afbd-572b-4143-8ee7-6dc1326a0d2b', 1, 3, NULL, 'ambulance_call.vehicle_model', 'messages', 'Vehicle Model', 'active', NULL, NULL, '2025-06-21 00:42:35', '2025-06-21 00:42:35'),
(1183, '9f34afbd-58fb-4e0e-80e8-ab02cd428220', 1, 3, NULL, 'ambulance_call.patient', 'messages', 'Patient', 'active', NULL, NULL, '2025-06-21 00:42:35', '2025-06-21 00:42:35'),
(1184, '9f34afbd-5ad8-44b6-aa73-c229b32fd857', 1, 3, NULL, 'ambulance_call.driver_name', 'messages', 'Driver Name', 'active', NULL, NULL, '2025-06-21 00:42:35', '2025-06-21 00:42:35'),
(1185, '9f34afbd-5cb3-4dae-9385-cd5e55975ca7', 1, 3, NULL, 'ambulance_call.date', 'messages', 'Date', 'active', NULL, NULL, '2025-06-21 00:42:35', '2025-06-21 00:42:35'),
(1186, '9f34afbd-5e9f-48eb-a54a-0a9fc6f256ff', 1, 3, NULL, 'ambulance_call.amount', 'messages', 'Amount', 'active', NULL, NULL, '2025-06-21 00:42:35', '2025-06-21 00:42:35'),
(1187, '9f34afbd-6069-4702-9412-75410c760e10', 1, 3, NULL, 'ambulance_call.new_ambulance_call', 'messages', 'New Ambulance Call', 'active', NULL, NULL, '2025-06-21 00:42:35', '2025-06-21 00:42:35'),
(1188, '9f34afbd-623a-46cd-ad21-510a1f6355c2', 1, 3, NULL, 'ambulance_call.edit_ambulance_call', 'messages', 'Edit Ambulance Call', 'active', NULL, NULL, '2025-06-21 00:42:35', '2025-06-21 00:42:35'),
(1189, '9f34afbd-6404-4251-86fb-83eeb609122d', 1, 3, NULL, 'ambulance_call.select_ambulance', 'messages', 'Select Ambulance', 'active', NULL, NULL, '2025-06-21 00:42:35', '2025-06-21 00:42:35'),
(1190, '9f34afbd-65d2-4ec0-90fa-82bd53463c48', 1, 3, NULL, 'prescription.prescription', 'messages', 'Prescription', 'active', NULL, NULL, '2025-06-21 00:42:35', '2025-06-21 00:42:35'),
(1191, '9f34afbd-67a9-4a41-9be6-6ff21c446eef', 1, 3, NULL, 'prescription.prescriptions', 'messages', 'Prescriptions', 'active', NULL, NULL, '2025-06-21 00:42:35', '2025-06-21 00:42:35'),
(1192, '9f34afbd-6981-417a-9efa-3e63048c68aa', 1, 3, NULL, 'prescription.prescription_details', 'messages', 'Prescription Details', 'active', NULL, NULL, '2025-06-21 00:42:35', '2025-06-21 00:42:35'),
(1193, '9f34afbd-6b69-4df7-aeb1-8788707948a5', 1, 3, NULL, 'prescription.new_prescription', 'messages', 'New Prescription', 'active', NULL, NULL, '2025-06-21 00:42:35', '2025-06-21 00:42:35'),
(1194, '9f34afbd-6d32-4d6d-b317-6dab1d607a66', 1, 3, NULL, 'prescription.edit_prescription', 'messages', 'Edit Prescription', 'active', NULL, NULL, '2025-06-21 00:42:35', '2025-06-21 00:42:35'),
(1195, '9f34afbd-6f05-4f73-a631-3bb12fdc744d', 1, 3, NULL, 'prescription.patient', 'messages', 'Patient', 'active', NULL, NULL, '2025-06-21 00:42:35', '2025-06-21 00:42:35'),
(1196, '9f34afbd-70dd-4183-9889-573c4e44eadc', 1, 3, NULL, 'prescription.doctor', 'messages', 'Doctor', 'active', NULL, NULL, '2025-06-21 00:42:35', '2025-06-21 00:42:35'),
(1197, '9f34afbd-72af-49de-8a9a-37f79f62232e', 1, 3, NULL, 'prescription.food_allergies', 'messages', 'Food Allergies', 'active', NULL, NULL, '2025-06-21 00:42:35', '2025-06-21 00:42:35'),
(1198, '9f34afbd-7473-4205-b5d0-796520e34376', 1, 3, NULL, 'prescription.tendency_bleed', 'messages', 'Tendency Bleed', 'active', NULL, NULL, '2025-06-21 00:42:35', '2025-06-21 00:42:35'),
(1199, '9f34afbd-7642-4110-9f3b-95d46709b36a', 1, 3, NULL, 'prescription.heart_disease', 'messages', 'Heart Disease', 'active', NULL, NULL, '2025-06-21 00:42:35', '2025-06-21 00:42:35'),
(1200, '9f34afbd-7822-4f27-a9aa-0cfd9f126d41', 1, 3, NULL, 'prescription.high_blood_pressure', 'messages', 'High Blood Pressure', 'active', NULL, NULL, '2025-06-21 00:42:35', '2025-06-21 00:42:35'),
(1201, '9f34afbd-7a19-4b77-b336-50d931c8f41d', 1, 3, NULL, 'prescription.diabetic', 'messages', 'Diabetic', 'active', NULL, NULL, '2025-06-21 00:42:35', '2025-06-21 00:42:35'),
(1202, '9f34afbd-7bec-4672-a95c-f57a870c1236', 1, 3, NULL, 'prescription.surgery', 'messages', 'Surgery', 'active', NULL, NULL, '2025-06-21 00:42:35', '2025-06-21 00:42:35'),
(1203, '9f34afbd-7dce-45af-a927-a73fd91d7383', 1, 3, NULL, 'prescription.accident', 'messages', 'Accident', 'active', NULL, NULL, '2025-06-21 00:42:35', '2025-06-21 00:42:35'),
(1204, '9f34afbd-7fd8-443d-bb9c-21f8245e0edd', 1, 3, NULL, 'prescription.others', 'messages', 'Others', 'active', NULL, NULL, '2025-06-21 00:42:35', '2025-06-21 00:42:35'),
(1205, '9f34afbd-81ce-44c6-97af-fb7bc3b0cba0', 1, 3, NULL, 'prescription.medical_history', 'messages', 'Medical History', 'active', NULL, NULL, '2025-06-21 00:42:35', '2025-06-21 00:42:35'),
(1206, '9f34afbd-83b8-4076-b702-975f646bcdd6', 1, 3, NULL, 'prescription.current_medication', 'messages', 'Current Medication', 'active', NULL, NULL, '2025-06-21 00:42:35', '2025-06-21 00:42:35'),
(1207, '9f34afbd-85a7-4eb2-826e-7435d7550e0b', 1, 3, NULL, 'prescription.female_pregnancy', 'messages', 'Female Pregnancy', 'active', NULL, NULL, '2025-06-21 00:42:35', '2025-06-21 00:42:35'),
(1208, '9f34afbd-8781-4c2c-883d-62461e2568a9', 1, 3, NULL, 'prescription.breast_feeding', 'messages', 'Breast Feeding', 'active', NULL, NULL, '2025-06-21 00:42:35', '2025-06-21 00:42:35'),
(1209, '9f34afbd-894e-4aa8-bd4b-be03f9d4ff53', 1, 3, NULL, 'prescription.health_insurance', 'messages', 'Health Insurance', 'active', NULL, NULL, '2025-06-21 00:42:35', '2025-06-21 00:42:35'),
(1210, '9f34afbd-8b20-4458-8d2b-0d41984b7a0f', 1, 3, NULL, 'prescription.low_income', 'messages', 'Low Income', 'active', NULL, NULL, '2025-06-21 00:42:35', '2025-06-21 00:42:35'),
(1211, '9f34afbd-8cfb-4f89-b769-da980bcb9ae9', 1, 3, NULL, 'prescription.reference', 'messages', 'Reference', 'active', NULL, NULL, '2025-06-21 00:42:35', '2025-06-21 00:42:35'),
(1212, '9f34afbd-8ec6-4660-95e2-372c1f572311', 1, 3, NULL, 'prescription.physical_information', 'messages', 'Physical Information', 'active', NULL, NULL, '2025-06-21 00:42:35', '2025-06-21 00:42:35'),
(1213, '9f34afbd-90a4-49b8-9b06-22c7aed550c0', 1, 3, NULL, 'prescription.new_medicine', 'messages', 'New Medicine', 'active', NULL, NULL, '2025-06-21 00:42:35', '2025-06-21 00:42:35'),
(1214, '9f34afbd-9278-4581-b813-f29e6b979616', 1, 3, NULL, 'prescription.plus_rate', 'messages', 'Pulse Rate', 'active', NULL, NULL, '2025-06-21 00:42:35', '2025-06-21 00:42:35'),
(1215, '9f34afbd-946e-4b2c-b446-e4ce5792bb16', 1, 3, NULL, 'prescription.temperature', 'messages', 'Temperature', 'active', NULL, NULL, '2025-06-21 00:42:35', '2025-06-21 00:42:35'),
(1216, '9f34afbd-964c-4d66-b782-6c72728adedb', 1, 3, NULL, 'prescription.problem_description', 'messages', 'Problem Description', 'active', NULL, NULL, '2025-06-21 00:42:35', '2025-06-21 00:42:35'),
(1217, '9f34afbd-9826-4cde-9b2e-efe507933383', 1, 3, NULL, 'prescription.test', 'messages', 'Test', 'active', NULL, NULL, '2025-06-21 00:42:35', '2025-06-21 00:42:35'),
(1218, '9f34afbd-99f4-47dd-8ed0-c90fb4828203', 1, 3, NULL, 'prescription.advice', 'messages', 'Advice', 'active', NULL, NULL, '2025-06-21 00:42:35', '2025-06-21 00:42:35'),
(1219, '9f34afbd-9bb3-4f76-af45-5ed90fa04740', 1, 3, NULL, 'prescription.next_visit', 'messages', 'Next Visit', 'active', NULL, NULL, '2025-06-21 00:42:35', '2025-06-21 00:42:35'),
(1220, '9f34afbd-9d85-49d4-973e-3cc28c01ff90', 1, 3, NULL, 'prescription.time', 'messages', 'Time', 'active', NULL, NULL, '2025-06-21 00:42:35', '2025-06-21 00:42:35'),
(1221, '9f34afbd-9f56-4398-b975-c7903967d524', 1, 3, NULL, 'prescription.comment', 'messages', 'Comment', 'active', NULL, NULL, '2025-06-21 00:42:35', '2025-06-21 00:42:35'),
(1222, '9f34afbd-a12b-4230-879c-ee55afb7eb88', 1, 3, NULL, 'prescription.problem', 'messages', 'Problem', 'active', NULL, NULL, '2025-06-21 00:42:35', '2025-06-21 00:42:35'),
(1223, '9f34afbd-a309-4e6c-9a55-f19d84e141d4', 1, 3, NULL, 'prescription.rx', 'messages', 'Rx', 'active', NULL, NULL, '2025-06-21 00:42:35', '2025-06-21 00:42:35'),
(1224, '9f34afbd-a4f9-4f08-ba50-17ae87de2447', 1, 3, NULL, 'prescription.medicine_name', 'messages', 'Medicine Name', 'active', NULL, NULL, '2025-06-21 00:42:35', '2025-06-21 00:42:35'),
(1225, '9f34afbd-a6ed-4c84-a8b0-f0e88c525f6a', 1, 3, NULL, 'prescription.duration', 'messages', 'Duration', 'active', NULL, NULL, '2025-06-21 00:42:35', '2025-06-21 00:42:35'),
(1226, '9f34afbd-a8da-4a18-a012-69fec6ca89db', 1, 3, NULL, 'prescription.days', 'messages', 'Days', 'active', NULL, NULL, '2025-06-21 00:42:35', '2025-06-21 00:42:35'),
(1227, '9f34afbd-aad0-4ad9-9460-3b00744823b0', 1, 3, NULL, 'prescription.after_meal', 'messages', 'After Meal', 'active', NULL, NULL, '2025-06-21 00:42:35', '2025-06-21 00:42:35'),
(1228, '9f34afbd-aca3-4354-a319-57de1e269a80', 1, 3, NULL, 'prescription.before_meal', 'messages', 'Before Meal', 'active', NULL, NULL, '2025-06-21 00:42:35', '2025-06-21 00:42:35'),
(1229, '9f34afbd-afc4-43d8-b9ab-1fddd95df2a9', 1, 3, NULL, 'prescription.fill_physical_information', 'messages', 'Fill any details of physical information', 'active', NULL, NULL, '2025-06-21 00:42:35', '2025-06-21 00:42:35'),
(1230, '9f34afbd-b1b7-46fd-ac5e-a2f0176a2f3d', 1, 3, NULL, 'prescription.data_retrive_from_openai', 'messages', 'Data Retrive Successfully from OpenAI', 'active', NULL, NULL, '2025-06-21 00:42:35', '2025-06-21 00:42:35'),
(1231, '9f34afbd-b3a2-433e-89f2-6670ea1ea0f3', 1, 3, NULL, 'charge_category.charge_categories', 'messages', 'Charge Categories', 'active', NULL, NULL, '2025-06-21 00:42:35', '2025-06-21 00:42:35'),
(1232, '9f34afbd-b57d-4e10-97be-46b407c3176b', 1, 3, NULL, 'charge_category.new_charge_category', 'messages', 'New Charge Category', 'active', NULL, NULL, '2025-06-21 00:42:35', '2025-06-21 00:42:35'),
(1233, '9f34afbd-b760-4224-87a6-d99c86819ea3', 1, 3, NULL, 'charge_category.edit_charge_category', 'messages', 'Edit Charge Category', 'active', NULL, NULL, '2025-06-21 00:42:35', '2025-06-21 00:42:35'),
(1234, '9f34afbd-b93b-4cbe-a828-aff0ac29d5bd', 1, 3, NULL, 'charge_category.charge_type', 'messages', 'Charge Type', 'active', NULL, NULL, '2025-06-21 00:42:35', '2025-06-21 00:42:35'),
(1235, '9f34afbd-bb15-4f3f-bfd7-8115b4226887', 1, 3, NULL, 'charge_category.charge_category_details', 'messages', 'Charge Category Details', 'active', NULL, NULL, '2025-06-21 00:42:35', '2025-06-21 00:42:35'),
(1236, '9f34afbd-bd22-4436-bd7d-7692694741ff', 1, 3, NULL, 'charge_category.select_charge_type', 'messages', 'Select Category Type', 'active', NULL, NULL, '2025-06-21 00:42:35', '2025-06-21 00:42:35'),
(1237, '9f34afbd-bf07-4650-998f-285a772da7f5', 1, 3, NULL, 'charge_filter.investigation', 'messages', 'Investigation', 'active', NULL, NULL, '2025-06-21 00:42:35', '2025-06-21 00:42:35'),
(1238, '9f34afbd-c0f0-4970-92a9-f153da4ad6e9', 1, 3, NULL, 'charge_filter.procedure', 'messages', 'Procedure', 'active', NULL, NULL, '2025-06-21 00:42:35', '2025-06-21 00:42:35'),
(1239, '9f34afbd-c2c7-490f-be99-45054ee86684', 1, 3, NULL, 'charge_filter.supplier', 'messages', 'Supplier', 'active', NULL, NULL, '2025-06-21 00:42:35', '2025-06-21 00:42:35'),
(1240, '9f34afbd-c4a3-4a0d-a81d-66e07a9c9428', 1, 3, NULL, 'charge_filter.operation_theater', 'messages', 'Operation Theater', 'active', NULL, NULL, '2025-06-21 00:42:35', '2025-06-21 00:42:35'),
(1241, '9f34afbd-c69b-4a59-b294-6db7a65f5bc5', 1, 3, NULL, 'charge_filter.others', 'messages', 'Others', 'active', NULL, NULL, '2025-06-21 00:42:35', '2025-06-21 00:42:35'),
(1242, '9f34afbd-c88a-4ad8-8e9a-cb1a5ad69ab0', 1, 3, NULL, 'charge.new_charge', 'messages', 'New Charge', 'active', NULL, NULL, '2025-06-21 00:42:35', '2025-06-21 00:42:35'),
(1243, '9f34afbd-ca7b-483e-9100-8445ad80e0f0', 1, 3, NULL, 'charge.edit_charge', 'messages', 'Edit Charge', 'active', NULL, NULL, '2025-06-21 00:42:35', '2025-06-21 00:42:35'),
(1244, '9f34afbd-cc5d-4910-804d-d8e4dec0720f', 1, 3, NULL, 'charge.charge_details', 'messages', 'Charge Details', 'active', NULL, NULL, '2025-06-21 00:42:35', '2025-06-21 00:42:35'),
(1245, '9f34afbd-ce58-48bc-9f28-ad9317e8d953', 1, 3, NULL, 'charge.charge_category', 'messages', 'Charge Category', 'active', NULL, NULL, '2025-06-21 00:42:35', '2025-06-21 00:42:35'),
(1246, '9f34afbd-d03f-4c80-9eb4-eddd133c7909', 1, 3, NULL, 'charge.standard_charge', 'messages', 'Standard Charge', 'active', NULL, NULL, '2025-06-21 00:42:35', '2025-06-21 00:42:35'),
(1247, '9f34afbd-d233-4df9-9b8a-ed55b02da532', 1, 3, NULL, 'charge.code', 'messages', 'Code', 'active', NULL, NULL, '2025-06-21 00:42:35', '2025-06-21 00:42:35'),
(1248, '9f34afbd-d41c-4406-bea8-d155d1669e52', 1, 3, NULL, 'radiology_category.name', 'messages', 'Name', 'active', NULL, NULL, '2025-06-21 00:42:35', '2025-06-21 00:42:35'),
(1249, '9f34afbd-d5fc-47db-aab2-2b30ceaf2659', 1, 3, NULL, 'radiology_category.radiology_categories', 'messages', 'Radiology Categories', 'active', NULL, NULL, '2025-06-21 00:42:35', '2025-06-21 00:42:35'),
(1250, '9f34afbd-d7f8-49fd-8059-fdb495e41b3a', 1, 3, NULL, 'radiology_category.new_radiology_category', 'messages', 'New Radiology Category', 'active', NULL, NULL, '2025-06-21 00:42:35', '2025-06-21 00:42:35'),
(1251, '9f34afbd-d9e0-4189-a4aa-03385c4af2cb', 1, 3, NULL, 'radiology_category.edit_radiology_category', 'messages', 'Edit Radiology Category', 'active', NULL, NULL, '2025-06-21 00:42:35', '2025-06-21 00:42:35'),
(1252, '9f34afbd-dbc6-4c00-9183-bcd5169d616e', 1, 3, NULL, 'pathology_category.pathology_categories', 'messages', 'Pathology Categories', 'active', NULL, NULL, '2025-06-21 00:42:35', '2025-06-21 00:42:35'),
(1253, '9f34afbd-ddb1-48a6-9043-2a263669612d', 1, 3, NULL, 'pathology_category.select_charge_category', 'messages', 'Select Charge Category', 'active', NULL, NULL, '2025-06-21 00:42:35', '2025-06-21 00:42:35'),
(1254, '9f34afbd-df8d-477f-9c28-1d8df266eb34', 1, 3, NULL, 'pathology_category.new_pathology_category', 'messages', 'New Pathology Category', 'active', NULL, NULL, '2025-06-21 00:42:35', '2025-06-21 00:42:35'),
(1255, '9f34afbd-e167-4e58-9479-cad1b9b2dfe0', 1, 3, NULL, 'pathology_category.edit_pathology_category', 'messages', 'Edit Pathology Category', 'active', NULL, NULL, '2025-06-21 00:42:35', '2025-06-21 00:42:35'),
(1256, '9f34afbd-e34f-435e-beb1-10799f604b33', 1, 3, NULL, 'pathology_category.name', 'messages', 'Name', 'active', NULL, NULL, '2025-06-21 00:42:35', '2025-06-21 00:42:35'),
(1257, '9f34afbd-e571-4e2e-a3f3-a29089c3affd', 1, 3, NULL, 'radiology_test.radiology_tests', 'messages', 'Radiology Tests', 'active', NULL, NULL, '2025-06-21 00:42:35', '2025-06-21 00:42:35'),
(1258, '9f34afbd-e762-4ca4-a8a6-6b2a6c5a95f8', 1, 3, NULL, 'radiology_test.new_radiology_test', 'messages', 'New Radiology Test', 'active', NULL, NULL, '2025-06-21 00:42:35', '2025-06-21 00:42:35'),
(1259, '9f34afbd-e94c-4b1d-9bab-68b9ac74281c', 1, 3, NULL, 'radiology_test.edit_radiology_test', 'messages', 'Edit Radiology Test', 'active', NULL, NULL, '2025-06-21 00:42:35', '2025-06-21 00:42:35'),
(1260, '9f34afbd-eb26-4ba0-963a-829b29e32ef4', 1, 3, NULL, 'radiology_test.radiology_test_details', 'messages', 'Radiology Test Details', 'active', NULL, NULL, '2025-06-21 00:42:35', '2025-06-21 00:42:35'),
(1261, '9f34afbd-ed04-4972-a6c5-1ba2a69fbfe4', 1, 3, NULL, 'radiology_test.test_name', 'messages', 'Test Name', 'active', NULL, NULL, '2025-06-21 00:42:35', '2025-06-21 00:42:35'),
(1262, '9f34afbd-eefa-4bad-9455-a35e755a5af6', 1, 3, NULL, 'radiology_test.short_name', 'messages', 'Short Name', 'active', NULL, NULL, '2025-06-21 00:42:35', '2025-06-21 00:42:35'),
(1263, '9f34afbd-f0d9-4cf2-aabc-1f90e857d337', 1, 3, NULL, 'radiology_test.test_type', 'messages', 'Test Type', 'active', NULL, NULL, '2025-06-21 00:42:35', '2025-06-21 00:42:35'),
(1264, '9f34afbd-f2a1-486b-adf1-5a008734abbb', 1, 3, NULL, 'radiology_test.category_name', 'messages', 'Category Name', 'active', NULL, NULL, '2025-06-21 00:42:35', '2025-06-21 00:42:35'),
(1265, '9f34afbd-f495-404d-92da-5a927d12f36f', 1, 3, NULL, 'radiology_test.subcategory', 'messages', 'Sub Category', 'active', NULL, NULL, '2025-06-21 00:42:35', '2025-06-21 00:42:35'),
(1266, '9f34afbd-f6a9-4b16-a1c1-0253f2cf965f', 1, 3, NULL, 'radiology_test.report_days', 'messages', 'Report Days', 'active', NULL, NULL, '2025-06-21 00:42:35', '2025-06-21 00:42:35'),
(1267, '9f34afbd-f8c3-4841-af3c-5847f3495317', 1, 3, NULL, 'radiology_test.charge_category', 'messages', 'Charge Category', 'active', NULL, NULL, '2025-06-21 00:42:35', '2025-06-21 00:42:35'),
(1268, '9f34afbd-facd-4ffd-aafb-4642309f3f60', 1, 3, NULL, 'radiology_test.standard_charge', 'messages', 'Standard Charge', 'active', NULL, NULL, '2025-06-21 00:42:35', '2025-06-21 00:42:35'),
(1269, '9f34afbd-fcc5-4170-9f71-75491c102960', 1, 3, NULL, 'doctor_opd_charge.new_doctor_opd_charge', 'messages', 'New Doctor OPD Charge', 'active', NULL, NULL, '2025-06-21 00:42:35', '2025-06-21 00:42:35'),
(1270, '9f34afbd-feb3-442b-a759-4fa09fc3036e', 1, 3, NULL, 'doctor_opd_charge.edit_doctor_opd_charge', 'messages', 'Edit Doctor OPD Charge', 'active', NULL, NULL, '2025-06-21 00:42:35', '2025-06-21 00:42:35'),
(1271, '9f34afbe-00b9-43a5-8857-43fcda808323', 1, 3, NULL, 'doctor_opd_charge.doctor_name', 'messages', 'Doctor Name', 'active', NULL, NULL, '2025-06-21 00:42:35', '2025-06-21 00:42:35'),
(1272, '9f34afbe-02a6-49ca-8a23-3f1e6df54801', 1, 3, NULL, 'doctor_opd_charge.standard_charge', 'messages', 'Doctor OPD Charge', 'active', NULL, NULL, '2025-06-21 00:42:35', '2025-06-21 00:42:35'),
(1273, '9f34afbe-0474-4c6a-9f67-76338c256488', 1, 3, NULL, 'doctor_opd_charge.doctor', 'messages', 'Doctor', 'active', NULL, NULL, '2025-06-21 00:42:35', '2025-06-21 00:42:35'),
(1274, '9f34afbe-0669-4c93-be61-8e93be687f1d', 1, 3, NULL, 'pathology_test.pathology_tests', 'messages', 'Pathology Tests', 'active', NULL, NULL, '2025-06-21 00:42:35', '2025-06-21 00:42:35'),
(1275, '9f34afbe-0867-495a-9384-c9fb2d3b6111', 1, 3, NULL, 'pathology_test.new_pathology_test', 'messages', 'New Pathology Test', 'active', NULL, NULL, '2025-06-21 00:42:35', '2025-06-21 00:42:35'),
(1276, '9f34afbe-0a59-4d52-9be6-4ca67c72856d', 1, 3, NULL, 'pathology_test.edit_pathology_test', 'messages', 'Edit Pathology Test', 'active', NULL, NULL, '2025-06-21 00:42:35', '2025-06-21 00:42:35'),
(1277, '9f34afbe-0c54-4528-a684-0cd5b32f379e', 1, 3, NULL, 'pathology_test.pathology_test_details', 'messages', 'Pathology Test Details', 'active', NULL, NULL, '2025-06-21 00:42:35', '2025-06-21 00:42:35'),
(1278, '9f34afbe-0e70-48cc-b532-73adb0e5d65f', 1, 3, NULL, 'pathology_test.test_name', 'messages', 'Test Name', 'active', NULL, NULL, '2025-06-21 00:42:35', '2025-06-21 00:42:35'),
(1279, '9f34afbe-1046-4629-b515-28ac6a3ac115', 1, 3, NULL, 'pathology_test.short_name', 'messages', 'Short Name', 'active', NULL, NULL, '2025-06-21 00:42:35', '2025-06-21 00:42:35'),
(1280, '9f34afbe-122a-4158-ae15-27ca38cbc177', 1, 3, NULL, 'pathology_test.test_type', 'messages', 'Test Type', 'active', NULL, NULL, '2025-06-21 00:42:35', '2025-06-21 00:42:35'),
(1281, '9f34afbe-142e-43a8-a003-93f3c459f0da', 1, 3, NULL, 'pathology_test.category_name', 'messages', 'Category Name', 'active', NULL, NULL, '2025-06-21 00:42:35', '2025-06-21 00:42:35'),
(1282, '9f34afbe-1605-40f6-bcc0-ba635b1a422e', 1, 3, NULL, 'pathology_test.unit', 'messages', 'Unit', 'active', NULL, NULL, '2025-06-21 00:42:35', '2025-06-21 00:42:35'),
(1283, '9f34afbe-17f2-4b35-bc4c-69648546f729', 1, 3, NULL, 'pathology_test.subcategory', 'messages', 'Sub Category', 'active', NULL, NULL, '2025-06-21 00:42:35', '2025-06-21 00:42:35'),
(1284, '9f34afbe-19d4-48bf-890e-bb153b098ed8', 1, 3, NULL, 'pathology_test.method', 'messages', 'Method', 'active', NULL, NULL, '2025-06-21 00:42:35', '2025-06-21 00:42:35'),
(1285, '9f34afbe-1bc3-4b6f-b70e-84793a38f137', 1, 3, NULL, 'pathology_test.report_days', 'messages', 'Report Days', 'active', NULL, NULL, '2025-06-21 00:42:35', '2025-06-21 00:42:35'),
(1286, '9f34afbe-1d99-4615-bdf3-0bfc8d06d095', 1, 3, NULL, 'pathology_test.charge_category', 'messages', 'Charge Category', 'active', NULL, NULL, '2025-06-21 00:42:35', '2025-06-21 00:42:35'),
(1287, '9f34afbe-1fd8-4ebb-920e-ca2d53ab6ec0', 1, 3, NULL, 'pathology_test.standard_charge', 'messages', 'Standard Charge', 'active', NULL, NULL, '2025-06-21 00:42:35', '2025-06-21 00:42:35'),
(1288, '9f34afbe-2200-465f-878e-8af8f250bd2d', 1, 3, NULL, 'expense_filter.building_rent', 'messages', 'Building Rent', 'active', NULL, NULL, '2025-06-21 00:42:35', '2025-06-21 00:42:35'),
(1289, '9f34afbe-2424-4bae-bba3-fdf9fe0c06a6', 1, 3, NULL, 'expense_filter.equipments', 'messages', 'Equipments', 'active', NULL, NULL, '2025-06-21 00:42:35', '2025-06-21 00:42:35'),
(1290, '9f34afbe-2625-4fcb-8408-1e980792fc21', 1, 3, NULL, 'expense_filter.electricity_bill', 'messages', 'Electricity Bill', 'active', NULL, NULL, '2025-06-21 00:42:35', '2025-06-21 00:42:35'),
(1291, '9f34afbe-2838-4ec6-a84c-4cce24448db1', 1, 3, NULL, 'expense_filter.telephone_bill', 'messages', 'Telephone Bill', 'active', NULL, NULL, '2025-06-21 00:42:35', '2025-06-21 00:42:35'),
(1292, '9f34afbe-2a2e-4bd0-a203-c6ede1cde14a', 1, 3, NULL, 'expense_filter.power_generator_fuel_charge', 'messages', 'Power Generator Fuel Charge', 'active', NULL, NULL, '2025-06-21 00:42:35', '2025-06-21 00:42:35'),
(1293, '9f34afbe-2c27-4311-9254-930410d24f18', 1, 3, NULL, 'expense_filter.tea_expense', 'messages', 'Tea Expense', 'active', NULL, NULL, '2025-06-21 00:42:35', '2025-06-21 00:42:35'),
(1294, '9f34afbe-2e3b-4ae6-815d-a8d98b708b18', 1, 3, NULL, 'expense.new_expense', 'messages', 'New Expense', 'active', NULL, NULL, '2025-06-21 00:42:35', '2025-06-21 00:42:35'),
(1295, '9f34afbe-3049-4d23-bfca-6682f124737c', 1, 3, NULL, 'expense.edit_expense', 'messages', 'Edit Expense', 'active', NULL, NULL, '2025-06-21 00:42:35', '2025-06-21 00:42:35'),
(1296, '9f34afbe-3243-4306-b6ae-351e8a7ab7b3', 1, 3, NULL, 'expense.expense_head', 'messages', 'Expense Head', 'active', NULL, NULL, '2025-06-21 00:42:35', '2025-06-21 00:42:35'),
(1297, '9f34afbe-3425-49b4-bcab-841b72e7ddd7', 1, 3, NULL, 'expense.name', 'messages', 'Name', 'active', NULL, NULL, '2025-06-21 00:42:35', '2025-06-21 00:42:35'),
(1298, '9f34afbe-3614-4367-9e00-8abad0a9210e', 1, 3, NULL, 'expense.date', 'messages', 'Date', 'active', NULL, NULL, '2025-06-21 00:42:35', '2025-06-21 00:42:35'),
(1299, '9f34afbe-3807-44ac-b572-2d539f23f5db', 1, 3, NULL, 'expense.invoice_number', 'messages', 'Invoice Number', 'active', NULL, NULL, '2025-06-21 00:42:35', '2025-06-21 00:42:35'),
(1300, '9f34afbe-39f1-4ccb-816d-74af7187c6b1', 1, 3, NULL, 'expense.amount', 'messages', 'Amount', 'active', NULL, NULL, '2025-06-21 00:42:35', '2025-06-21 00:42:35'),
(1301, '9f34afbe-3be2-497f-8f96-edb8845b7778', 1, 3, NULL, 'expense.attachment', 'messages', 'Attachment', 'active', NULL, NULL, '2025-06-21 00:42:35', '2025-06-21 00:42:35'),
(1302, '9f34afbe-3dc7-4e27-a534-0fc538030b99', 1, 3, NULL, 'expense.description', 'messages', 'Description', 'active', NULL, NULL, '2025-06-21 00:42:35', '2025-06-21 00:42:35'),
(1303, '9f34afbe-3fba-43d5-abdf-f42a51d52335', 1, 3, NULL, 'expense.choose', 'messages', 'Choose', 'active', NULL, NULL, '2025-06-21 00:42:35', '2025-06-21 00:42:35'),
(1304, '9f34afbe-4194-4cd8-b29f-a5eb1b00a895', 1, 3, NULL, 'expense.download', 'messages', 'Download', 'active', NULL, NULL, '2025-06-21 00:42:35', '2025-06-21 00:42:35'),
(1305, '9f34afbe-4376-4c63-a17d-41f6c63c9446', 1, 3, NULL, 'expense.select_expense_head', 'messages', 'Select Expense Head', 'active', NULL, NULL, '2025-06-21 00:42:35', '2025-06-21 00:42:35'),
(1306, '9f34afbe-4576-43a0-bfba-c42be813fb67', 1, 3, NULL, 'expense.expense_details', 'messages', 'Expense Details', 'active', NULL, NULL, '2025-06-21 00:42:35', '2025-06-21 00:42:35'),
(1307, '9f34afbe-4791-4493-8d86-02f3fb21c6fe', 1, 3, NULL, 'expense.document_error', 'messages', 'The document must be a file of type: jpeg, jpg, png, pdf, doc, docx.', 'active', NULL, NULL, '2025-06-21 00:42:35', '2025-06-21 00:42:35'),
(1308, '9f34afbe-49b0-433d-aaeb-ac372f6bfd13', 1, 3, NULL, 'income_filter.canteen_rate', 'messages', 'Canteen Rent', 'active', NULL, NULL, '2025-06-21 00:42:35', '2025-06-21 00:42:35'),
(1309, '9f34afbe-4d13-4aa5-a9b3-216e85a03555', 1, 3, NULL, 'income_filter.hospital_charges', 'messages', 'Hospital Charges', 'active', NULL, NULL, '2025-06-21 00:42:36', '2025-06-21 00:42:36'),
(1310, '9f34afbe-4f47-433c-b313-ef40a5653bdf', 1, 3, NULL, 'income_filter.special_campaign', 'messages', 'Special Campaign', 'active', NULL, NULL, '2025-06-21 00:42:36', '2025-06-21 00:42:36'),
(1311, '9f34afbe-515d-4ad0-9d29-4ad014142810', 1, 3, NULL, 'income_filter.vehicle_stand_charge', 'messages', 'Vehicle Stand Charge', 'active', NULL, NULL, '2025-06-21 00:42:36', '2025-06-21 00:42:36'),
(1312, '9f34afbe-5476-487c-b4cc-7be3a5b4e4c1', 1, 3, NULL, 'incomes.incomes', 'messages', 'Incomes', 'active', NULL, NULL, '2025-06-21 00:42:36', '2025-06-21 00:42:36'),
(1313, '9f34afbe-5687-4406-9a27-d51290a0e1e9', 1, 3, NULL, 'incomes.new_income', 'messages', 'New Income', 'active', NULL, NULL, '2025-06-21 00:42:36', '2025-06-21 00:42:36'),
(1314, '9f34afbe-5874-4472-bcf5-cc55ee0bef60', 1, 3, NULL, 'incomes.edit_income', 'messages', 'Edit Income', 'active', NULL, NULL, '2025-06-21 00:42:36', '2025-06-21 00:42:36'),
(1315, '9f34afbe-5a61-4557-bd5f-70f9ce38aec4', 1, 3, NULL, 'incomes.income_head', 'messages', 'Income Head', 'active', NULL, NULL, '2025-06-21 00:42:36', '2025-06-21 00:42:36'),
(1316, '9f34afbe-5c54-45a3-9b13-b0668cb48f6a', 1, 3, NULL, 'incomes.name', 'messages', 'Name', 'active', NULL, NULL, '2025-06-21 00:42:36', '2025-06-21 00:42:36'),
(1317, '9f34afbe-5e50-48ab-af20-1b6ad223f590', 1, 3, NULL, 'incomes.date', 'messages', 'Date', 'active', NULL, NULL, '2025-06-21 00:42:36', '2025-06-21 00:42:36'),
(1318, '9f34afbe-6048-4b3f-8cdf-b32adca2b02d', 1, 3, NULL, 'incomes.invoice_number', 'messages', 'Invoice Number', 'active', NULL, NULL, '2025-06-21 00:42:36', '2025-06-21 00:42:36'),
(1319, '9f34afbe-6227-4a66-a119-aef10cde0af3', 1, 3, NULL, 'incomes.amount', 'messages', 'Amount', 'active', NULL, NULL, '2025-06-21 00:42:36', '2025-06-21 00:42:36'),
(1320, '9f34afbe-6412-4237-9264-d40d63228baa', 1, 3, NULL, 'incomes.attachment', 'messages', 'Attachment', 'active', NULL, NULL, '2025-06-21 00:42:36', '2025-06-21 00:42:36'),
(1321, '9f34afbe-6607-4854-a8ec-47f7b7cf1b13', 1, 3, NULL, 'incomes.description', 'messages', 'Description', 'active', NULL, NULL, '2025-06-21 00:42:36', '2025-06-21 00:42:36'),
(1322, '9f34afbe-680b-4b25-a8c0-b6cac7723bae', 1, 3, NULL, 'incomes.choose', 'messages', 'Choose', 'active', NULL, NULL, '2025-06-21 00:42:36', '2025-06-21 00:42:36'),
(1323, '9f34afbe-6a0e-4dd5-bde9-47e261aee4aa', 1, 3, NULL, 'incomes.download', 'messages', 'Download', 'active', NULL, NULL, '2025-06-21 00:42:36', '2025-06-21 00:42:36'),
(1324, '9f34afbe-6bf6-4a2b-b70d-60da13f6f5e2', 1, 3, NULL, 'incomes.select_income_head', 'messages', 'Select Income Head', 'active', NULL, NULL, '2025-06-21 00:42:36', '2025-06-21 00:42:36'),
(1325, '9f34afbe-6de0-4e58-a12f-fe2bf48d3cc7', 1, 3, NULL, 'incomes.income_details', 'messages', 'Income Details', 'active', NULL, NULL, '2025-06-21 00:42:36', '2025-06-21 00:42:36'),
(1326, '9f34afbe-6fc5-4e90-9a65-0f399defa29a', 1, 3, NULL, 'incomes.document_error', 'messages', 'The document must be a file of type: jpeg, jpg, png, pdf, doc, docx.', 'active', NULL, NULL, '2025-06-21 00:42:36', '2025-06-21 00:42:36'),
(1327, '9f34afbe-71c1-452d-b1f3-ed1b62b8c646', 1, 3, NULL, 'bed_status.bed_status', 'messages', 'Bed Status', 'active', NULL, NULL, '2025-06-21 00:42:36', '2025-06-21 00:42:36'),
(1328, '9f34afbe-73d3-426e-b64e-ffa3089769a3', 1, 3, NULL, 'bed_status.assigned_beds', 'messages', 'Assigned Beds', 'active', NULL, NULL, '2025-06-21 00:42:36', '2025-06-21 00:42:36'),
(1329, '9f34afbe-75d0-47ef-b984-38af2f0079d0', 1, 3, NULL, 'bed_status.available_beds', 'messages', 'Available Beds', 'active', NULL, NULL, '2025-06-21 00:42:36', '2025-06-21 00:42:36'),
(1330, '9f34afbe-77bd-4d39-9220-c86af8287c7d', 1, 3, NULL, 'bed_status.bed_name', 'messages', 'Bed Name', 'active', NULL, NULL, '2025-06-21 00:42:36', '2025-06-21 00:42:36'),
(1331, '9f34afbe-79db-4f58-b551-f7e6eb1de7eb', 1, 3, NULL, 'bed_status.patient_name', 'messages', 'Patient Name', 'active', NULL, NULL, '2025-06-21 00:42:36', '2025-06-21 00:42:36'),
(1332, '9f34afbe-7bd8-479e-a681-c81f9c179f2a', 1, 3, NULL, 'bed_status.phone', 'messages', 'Phone', 'active', NULL, NULL, '2025-06-21 00:42:36', '2025-06-21 00:42:36'),
(1333, '9f34afbe-7dc6-46d5-a9c1-89f344e9294f', 1, 3, NULL, 'bed_status.admission_date', 'messages', 'Admission Date', 'active', NULL, NULL, '2025-06-21 00:42:36', '2025-06-21 00:42:36'),
(1334, '9f34afbe-7fa6-4088-8044-ce8887f9744e', 1, 3, NULL, 'bed_status.gender', 'messages', 'Gender', 'active', NULL, NULL, '2025-06-21 00:42:36', '2025-06-21 00:42:36'),
(1335, '9f34afbe-818e-4658-b9c2-788b8f420e2f', 1, 3, NULL, 'message.message', 'messages', 'Message', 'active', NULL, NULL, '2025-06-21 00:42:36', '2025-06-21 00:42:36'),
(1336, '9f34afbe-838e-4f6a-93b7-69fb3151a6ec', 1, 3, NULL, 'message.messages', 'messages', 'Messages', 'active', NULL, NULL, '2025-06-21 00:42:36', '2025-06-21 00:42:36'),
(1337, '9f34afbe-857a-4635-9c23-0af700615b0e', 1, 3, NULL, 'message.send_to', 'messages', 'Send To', 'active', NULL, NULL, '2025-06-21 00:42:36', '2025-06-21 00:42:36'),
(1338, '9f34afbe-877b-44aa-bb80-36b607148b89', 1, 3, NULL, 'message.subject', 'messages', 'Subject', 'active', NULL, NULL, '2025-06-21 00:42:36', '2025-06-21 00:42:36'),
(1339, '9f34afbe-896e-45ea-9460-4dc6aa28f423', 1, 3, NULL, 'message.new_message', 'messages', 'New Message', 'active', NULL, NULL, '2025-06-21 00:42:36', '2025-06-21 00:42:36'),
(1340, '9f34afbe-8b87-4403-b313-de5c1669f35e', 1, 3, NULL, 'message.messages_details', 'messages', 'Message Details', 'active', NULL, NULL, '2025-06-21 00:42:36', '2025-06-21 00:42:36'),
(1341, '9f34afbe-8d78-4940-b553-49a52af2216a', 1, 3, NULL, 'message.sender_name', 'messages', 'Sender Name', 'active', NULL, NULL, '2025-06-21 00:42:36', '2025-06-21 00:42:36'),
(1342, '9f34afbe-8f60-4d87-9fb2-a6df74ac11f3', 1, 3, NULL, 'message.date', 'messages', 'Date', 'active', NULL, NULL, '2025-06-21 00:42:36', '2025-06-21 00:42:36'),
(1343, '9f34afbe-9148-4b70-853b-08d3a78aac21', 1, 3, NULL, 'message.select_user', 'messages', 'Select User', 'active', NULL, NULL, '2025-06-21 00:42:36', '2025-06-21 00:42:36'),
(1344, '9f34afbe-9333-4240-a524-0d765bdf83c8', 1, 3, NULL, 'sms.sms', 'messages', 'SMS', 'active', NULL, NULL, '2025-06-21 00:42:36', '2025-06-21 00:42:36'),
(1345, '9f34afbe-950a-44a0-8f3a-94f6085e0bd8', 1, 3, NULL, 'sms.new_sms', 'messages', 'New SMS', 'active', NULL, NULL, '2025-06-21 00:42:36', '2025-06-21 00:42:36'),
(1346, '9f34afbe-9702-4c5f-934f-f2ce4ac99c75', 1, 3, NULL, 'sms.send_to', 'messages', 'Send To', 'active', NULL, NULL, '2025-06-21 00:42:36', '2025-06-21 00:42:36'),
(1347, '9f34afbe-98eb-45b8-91a9-ea8a4bcaa237', 1, 3, NULL, 'sms.phone_number', 'messages', 'Phone Number', 'active', NULL, NULL, '2025-06-21 00:42:36', '2025-06-21 00:42:36'),
(1348, '9f34afbe-9b50-4ed7-8345-6b9b865497af', 1, 3, NULL, 'sms.send_by', 'messages', 'Send By', 'active', NULL, NULL, '2025-06-21 00:42:36', '2025-06-21 00:42:36'),
(1349, '9f34afbe-9d3e-4f9b-aead-19554a91ad56', 1, 3, NULL, 'sms.message', 'messages', 'Message', 'active', NULL, NULL, '2025-06-21 00:42:36', '2025-06-21 00:42:36'),
(1350, '9f34afbe-9f4a-4e4c-af98-9192a7334fb8', 1, 3, NULL, 'sms.sms_details', 'messages', 'SMS Details', 'active', NULL, NULL, '2025-06-21 00:42:36', '2025-06-21 00:42:36'),
(1351, '9f34afbe-a14f-4522-997c-fe685dc7bc79', 1, 3, NULL, 'sms.date', 'messages', 'Date', 'active', NULL, NULL, '2025-06-21 00:42:36', '2025-06-21 00:42:36'),
(1352, '9f34afbe-a355-40da-b501-b57b6cb27225', 1, 3, NULL, 'sms.send', 'messages', 'Send', 'active', NULL, NULL, '2025-06-21 00:42:36', '2025-06-21 00:42:36'),
(1353, '9f34afbe-a54f-40f3-9cab-987a9c2a8358', 1, 3, NULL, 'sms.role', 'messages', 'Role', 'active', NULL, NULL, '2025-06-21 00:42:36', '2025-06-21 00:42:36'),
(1354, '9f34afbe-a732-489f-80ea-080227d555ed', 1, 3, NULL, 'sms.select_role', 'messages', 'Select Role', 'active', NULL, NULL, '2025-06-21 00:42:36', '2025-06-21 00:42:36'),
(1355, '9f34afbe-a929-4add-8364-18dfae6b6b96', 1, 3, NULL, 'sms.send_sms_by_number_directly', 'messages', 'Send SMS by number directly', 'active', NULL, NULL, '2025-06-21 00:42:36', '2025-06-21 00:42:36'),
(1356, '9f34afbe-ab0d-4d4f-a1f8-9707314ea7e4', 1, 3, NULL, 'sms.only_user_with_registered_phone_will_display', 'messages', '(Only Users with a registered phone will display.)', 'active', NULL, NULL, '2025-06-21 00:42:36', '2025-06-21 00:42:36'),
(1357, '9f34afbe-acfc-4e1f-93cd-570420f3bcc6', 1, 3, NULL, 'sms.sms_mail', 'messages', 'SMS/Mail', 'active', NULL, NULL, '2025-06-21 00:42:36', '2025-06-21 00:42:36'),
(1358, '9f34afbe-af03-46ae-bb0c-a47585f2418c', 1, 3, NULL, 'patient_diagnosis_test.diagnosis', 'messages', 'Diagnosis', 'active', NULL, NULL, '2025-06-21 00:42:36', '2025-06-21 00:42:36'),
(1359, '9f34afbe-b113-4689-ad87-a236c0580ab7', 1, 3, NULL, 'patient_diagnosis_test.diagnosis_test', 'messages', 'Diagnosis Tests', 'active', NULL, NULL, '2025-06-21 00:42:36', '2025-06-21 00:42:36'),
(1360, '9f34afbe-b309-414a-9f7a-20cda2180ec6', 1, 3, NULL, 'patient_diagnosis_test.patient_diagnosis_test', 'messages', 'Patient Diagnosis Tests', 'active', NULL, NULL, '2025-06-21 00:42:36', '2025-06-21 00:42:36'),
(1361, '9f34afbe-b4f1-40eb-8c39-12b69ae244d0', 1, 3, NULL, 'patient_diagnosis_test.report_number', 'messages', 'Report number', 'active', NULL, NULL, '2025-06-21 00:42:36', '2025-06-21 00:42:36'),
(1362, '9f34afbe-b6f3-4c4b-bcea-4c50adf16345', 1, 3, NULL, 'patient_diagnosis_test.patient', 'messages', 'Patient', 'active', NULL, NULL, '2025-06-21 00:42:36', '2025-06-21 00:42:36'),
(1363, '9f34afbe-b90d-4bc2-8ab3-b481c6f1801e', 1, 3, NULL, 'patient_diagnosis_test.doctor', 'messages', 'Doctor', 'active', NULL, NULL, '2025-06-21 00:42:36', '2025-06-21 00:42:36'),
(1364, '9f34afbe-bb12-4bcf-af26-2d7c716ac7c9', 1, 3, NULL, 'patient_diagnosis_test.created_at', 'messages', 'Created at', 'active', NULL, NULL, '2025-06-21 00:42:36', '2025-06-21 00:42:36'),
(1365, '9f34afbe-bd0c-42fc-b9e1-a34147f72900', 1, 3, NULL, 'patient_diagnosis_test.action', 'messages', 'Action', 'active', NULL, NULL, '2025-06-21 00:42:36', '2025-06-21 00:42:36'),
(1366, '9f34afbe-bf0a-4870-9e79-c5f6e0ec4d6e', 1, 3, NULL, 'patient_diagnosis_test.new_patient_diagnosis_test', 'messages', 'New Patient Diagnosis Test', 'active', NULL, NULL, '2025-06-21 00:42:36', '2025-06-21 00:42:36'),
(1367, '9f34afbe-c10d-4877-ac44-238c0afabbc8', 1, 3, NULL, 'patient_diagnosis_test.edit_patient_diagnosis_test', 'messages', 'Edit Patient Diagnosis Test', 'active', NULL, NULL, '2025-06-21 00:42:36', '2025-06-21 00:42:36'),
(1368, '9f34afbe-c321-45c6-a3d2-96d4e5577335', 1, 3, NULL, 'patient_diagnosis_test.create_patient_diagnosis_test', 'messages', 'Create Patient Diagnosis Test', 'active', NULL, NULL, '2025-06-21 00:42:36', '2025-06-21 00:42:36'),
(1369, '9f34afbe-c526-40b2-8dc9-7efc81cfa15d', 1, 3, NULL, 'patient_diagnosis_test.patient_diagnosis_test_details', 'messages', 'Patient Diagnosis Test Details', 'active', NULL, NULL, '2025-06-21 00:42:36', '2025-06-21 00:42:36'),
(1370, '9f34afbe-c719-4340-a799-b38ce4de7934', 1, 3, NULL, 'patient_diagnosis_test.diagnosis_category', 'messages', 'Diagnosis Category', 'active', NULL, NULL, '2025-06-21 00:42:36', '2025-06-21 00:42:36'),
(1371, '9f34afbe-c91f-4e62-9dd1-fe8c0695c9fc', 1, 3, NULL, 'patient_diagnosis_test.add_other_diagnosis_property', 'messages', 'Add other diagnosis property', 'active', NULL, NULL, '2025-06-21 00:42:36', '2025-06-21 00:42:36'),
(1372, '9f34afbe-cb7a-4c9d-9463-7f2b4e4b4699', 1, 3, NULL, 'patient_diagnosis_test.other_diagnosis_property', 'messages', 'Other diagnosis property', 'active', NULL, NULL, '2025-06-21 00:42:36', '2025-06-21 00:42:36'),
(1373, '9f34afbe-cd7f-4f92-8b4d-2029a1f30dc0', 1, 3, NULL, 'patient_diagnosis_test.diagnosis_property_name', 'messages', 'Diagnosis Property Name', 'active', NULL, NULL, '2025-06-21 00:42:36', '2025-06-21 00:42:36'),
(1374, '9f34afbe-cf6a-4863-a557-b8040dbf231d', 1, 3, NULL, 'patient_diagnosis_test.diagnosis_property_value', 'messages', 'Diagnosis Property Value', 'active', NULL, NULL, '2025-06-21 00:42:36', '2025-06-21 00:42:36'),
(1375, '9f34afbe-d169-4008-b0a6-1af02dc7cf03', 1, 3, NULL, 'patient_diagnosis_test.patient_name', 'messages', 'Patient name', 'active', NULL, NULL, '2025-06-21 00:42:36', '2025-06-21 00:42:36'),
(1376, '9f34afbe-d361-42d3-8779-3817467bee04', 1, 3, NULL, 'patient_diagnosis_test.doctor_name', 'messages', 'Doctor name', 'active', NULL, NULL, '2025-06-21 00:42:36', '2025-06-21 00:42:36'),
(1377, '9f34afbe-d570-4006-84fe-5a45a7881095', 1, 3, NULL, 'patient_diagnosis_test.age', 'messages', 'Age', 'active', NULL, NULL, '2025-06-21 00:42:36', '2025-06-21 00:42:36'),
(1378, '9f34afbe-d77f-41b2-9895-2505ccfb299c', 1, 3, NULL, 'patient_diagnosis_test.height', 'messages', 'Height', 'active', NULL, NULL, '2025-06-21 00:42:36', '2025-06-21 00:42:36'),
(1379, '9f34afbe-d98b-4b26-a3da-f38e16021c6d', 1, 3, NULL, 'patient_diagnosis_test.weight', 'messages', 'Weight', 'active', NULL, NULL, '2025-06-21 00:42:36', '2025-06-21 00:42:36'),
(1380, '9f34afbe-db95-4ebe-bb8b-23266619e3cd', 1, 3, NULL, 'patient_diagnosis_test.average_glucose', 'messages', 'Average glucose', 'active', NULL, NULL, '2025-06-21 00:42:36', '2025-06-21 00:42:36'),
(1381, '9f34afbe-dd8d-4694-b29c-886e52cc7af8', 1, 3, NULL, 'patient_diagnosis_test.fasting_blood_sugar', 'messages', 'Fasting Blood Sugar', 'active', NULL, NULL, '2025-06-21 00:42:36', '2025-06-21 00:42:36'),
(1382, '9f34afbe-df88-4995-bbbe-22df607b6054', 1, 3, NULL, 'patient_diagnosis_test.urine_sugar', 'messages', 'Urine Sugar', 'active', NULL, NULL, '2025-06-21 00:42:36', '2025-06-21 00:42:36'),
(1383, '9f34afbe-e198-45a0-9f61-9b66fa152b28', 1, 3, NULL, 'patient_diagnosis_test.blood_pressure', 'messages', 'Blood Pressure', 'active', NULL, NULL, '2025-06-21 00:42:36', '2025-06-21 00:42:36'),
(1384, '9f34afbe-e398-4243-823b-6c0ba091a697', 1, 3, NULL, 'patient_diagnosis_test.diabetes', 'messages', 'Diabetes', 'active', NULL, NULL, '2025-06-21 00:42:36', '2025-06-21 00:42:36'),
(1385, '9f34afbe-e591-467a-96cc-7f89202e079d', 1, 3, NULL, 'patient_diagnosis_test.cholesterol', 'messages', 'Cholesterol', 'active', NULL, NULL, '2025-06-21 00:42:36', '2025-06-21 00:42:36'),
(1386, '9f34afbe-e79a-4a53-870c-ccafc608cff7', 1, 3, NULL, 'patient_diagnosis_test.print_diagnosis_test', 'messages', 'Print Diagnosis Test', 'active', NULL, NULL, '2025-06-21 00:42:36', '2025-06-21 00:42:36'),
(1387, '9f34afbe-e99d-4e9c-8ac0-e77af6c6b6f3', 1, 3, NULL, 'patient_diagnosis_test.select_diagnosis_cat', 'messages', 'Select Diagnosis Category', 'active', NULL, NULL, '2025-06-21 00:42:36', '2025-06-21 00:42:36'),
(1388, '9f34afbe-ebbb-4c51-953c-f1042c39342b', 1, 3, NULL, 'patient_diagnosis_test.patient_unique', 'messages', 'The patient\'s name has already been taken.', 'active', NULL, NULL, '2025-06-21 00:42:36', '2025-06-21 00:42:36'),
(1389, '9f34afbe-edbd-4e7f-82ae-d9cdc0299674', 1, 3, NULL, 'patient_diagnosis_test.report_generated', 'messages', 'Report Generated', 'active', NULL, NULL, '2025-06-21 00:42:36', '2025-06-21 00:42:36'),
(1390, '9f34afbe-efc5-47ec-9f86-13ab19c6e8e6', 1, 3, NULL, 'diagnosis_category.diagnosis_category', 'messages', 'Diagnosis Category', 'active', NULL, NULL, '2025-06-21 00:42:36', '2025-06-21 00:42:36'),
(1391, '9f34afbe-f1d1-47d8-b1ae-430cb7123a71', 1, 3, NULL, 'diagnosis_category.diagnosis_category_details', 'messages', 'Diagnosis Category Details', 'active', NULL, NULL, '2025-06-21 00:42:36', '2025-06-21 00:42:36'),
(1392, '9f34afbe-f3df-4f24-b8f3-1e8b9454f63a', 1, 3, NULL, 'diagnosis_category.diagnosis_categories', 'messages', 'Diagnosis Categories', 'active', NULL, NULL, '2025-06-21 00:42:36', '2025-06-21 00:42:36'),
(1393, '9f34afbe-f5f8-4367-a8d5-3a8266263507', 1, 3, NULL, 'diagnosis_category.new_diagnosis_category', 'messages', 'New Diagnosis Category', 'active', NULL, NULL, '2025-06-21 00:42:36', '2025-06-21 00:42:36'),
(1394, '9f34afbe-f7f2-4f97-aa2f-065c6df4d0bd', 1, 3, NULL, 'diagnosis_category.description', 'messages', 'Description', 'active', NULL, NULL, '2025-06-21 00:42:36', '2025-06-21 00:42:36');
INSERT INTO `ltu_phrases` (`id`, `uuid`, `translation_id`, `translation_file_id`, `phrase_id`, `key`, `group`, `value`, `status`, `parameters`, `note`, `created_at`, `updated_at`) VALUES
(1395, '9f34afbe-fb12-46a5-bf62-0a323795ca72', 1, 3, NULL, 'diagnosis_category.category_name', 'messages', 'Category name', 'active', NULL, NULL, '2025-06-21 00:42:36', '2025-06-21 00:42:36'),
(1396, '9f34afbe-fd39-4fc1-80f1-18a99fa8a348', 1, 3, NULL, 'diagnosis_category.edit_diagnosis_category', 'messages', 'Edit Diagnosis Category', 'active', NULL, NULL, '2025-06-21 00:42:36', '2025-06-21 00:42:36'),
(1397, '9f34afbe-ff51-4fe7-a831-2be892a8982e', 1, 3, NULL, 'item_category.item_category', 'messages', 'Item Category', 'active', NULL, NULL, '2025-06-21 00:42:36', '2025-06-21 00:42:36'),
(1398, '9f34afbf-018e-42a6-9665-1e3a87c3e349', 1, 3, NULL, 'item_category.item_categories', 'messages', 'Item Categories', 'active', NULL, NULL, '2025-06-21 00:42:36', '2025-06-21 00:42:36'),
(1399, '9f34afbf-039a-4ba6-898b-86f16f63819e', 1, 3, NULL, 'item_category.new_item_category', 'messages', 'New Item Category', 'active', NULL, NULL, '2025-06-21 00:42:36', '2025-06-21 00:42:36'),
(1400, '9f34afbf-05b0-42e4-ba8b-5a1669fb595b', 1, 3, NULL, 'item_category.edit_item_category', 'messages', 'Edit Item Category', 'active', NULL, NULL, '2025-06-21 00:42:36', '2025-06-21 00:42:36'),
(1401, '9f34afbf-07cb-42da-ab8e-02063d198629', 1, 3, NULL, 'item_category.name', 'messages', 'Name', 'active', NULL, NULL, '2025-06-21 00:42:36', '2025-06-21 00:42:36'),
(1402, '9f34afbf-09f4-491f-aedd-aee55dc92018', 1, 3, NULL, 'item.item', 'messages', 'Item', 'active', NULL, NULL, '2025-06-21 00:42:36', '2025-06-21 00:42:36'),
(1403, '9f34afbf-0c00-4002-b51e-72479c478e37', 1, 3, NULL, 'item.items', 'messages', 'Items', 'active', NULL, NULL, '2025-06-21 00:42:36', '2025-06-21 00:42:36'),
(1404, '9f34afbf-0df5-47c7-8546-747ee2b74755', 1, 3, NULL, 'item.new_item', 'messages', 'New Item', 'active', NULL, NULL, '2025-06-21 00:42:36', '2025-06-21 00:42:36'),
(1405, '9f34afbf-0fdd-454a-abd6-e5a912442e86', 1, 3, NULL, 'item.edit_item', 'messages', 'Edit Item', 'active', NULL, NULL, '2025-06-21 00:42:36', '2025-06-21 00:42:36'),
(1406, '9f34afbf-11dd-4674-a793-0ac39ec99d56', 1, 3, NULL, 'item.item_details', 'messages', 'Item Details', 'active', NULL, NULL, '2025-06-21 00:42:36', '2025-06-21 00:42:36'),
(1407, '9f34afbf-13f1-4be1-9f41-a3ecf28d5583', 1, 3, NULL, 'item.name', 'messages', 'Name', 'active', NULL, NULL, '2025-06-21 00:42:36', '2025-06-21 00:42:36'),
(1408, '9f34afbf-161a-404f-a70c-647e3b8ae653', 1, 3, NULL, 'item.item_category', 'messages', 'Item Category', 'active', NULL, NULL, '2025-06-21 00:42:36', '2025-06-21 00:42:36'),
(1409, '9f34afbf-1825-4deb-b909-8476dea8d123', 1, 3, NULL, 'item.unit', 'messages', 'Unit', 'active', NULL, NULL, '2025-06-21 00:42:36', '2025-06-21 00:42:36'),
(1410, '9f34afbf-1a26-4b39-b395-f2e21a903775', 1, 3, NULL, 'item.description', 'messages', 'Description', 'active', NULL, NULL, '2025-06-21 00:42:36', '2025-06-21 00:42:36'),
(1411, '9f34afbf-1c52-412d-b30e-affa02066acb', 1, 3, NULL, 'item.available_quantity', 'messages', 'Available Quantity', 'active', NULL, NULL, '2025-06-21 00:42:36', '2025-06-21 00:42:36'),
(1412, '9f34afbf-1e75-484e-855a-3f3b82ca6706', 1, 3, NULL, 'item.select_item_category', 'messages', 'Select Item Category', 'active', NULL, NULL, '2025-06-21 00:42:36', '2025-06-21 00:42:36'),
(1413, '9f34afbf-2087-4907-87b2-ae442fe593aa', 1, 3, NULL, 'item_stock.item_stock', 'messages', 'Item Stock', 'active', NULL, NULL, '2025-06-21 00:42:36', '2025-06-21 00:42:36'),
(1414, '9f34afbf-2280-45d2-b381-e336c75b26ac', 1, 3, NULL, 'item_stock.item_stocks', 'messages', 'Item Stocks', 'active', NULL, NULL, '2025-06-21 00:42:36', '2025-06-21 00:42:36'),
(1415, '9f34afbf-248c-4c15-a9c4-e40879c0829c', 1, 3, NULL, 'item_stock.new_item_stock', 'messages', 'New Item Stock', 'active', NULL, NULL, '2025-06-21 00:42:36', '2025-06-21 00:42:36'),
(1416, '9f34afbf-268c-4247-af43-150910b7c152', 1, 3, NULL, 'item_stock.edit_item_stock', 'messages', 'Edit Item Stock', 'active', NULL, NULL, '2025-06-21 00:42:36', '2025-06-21 00:42:36'),
(1417, '9f34afbf-2884-48d9-8490-10b5a6daa849', 1, 3, NULL, 'item_stock.item_stock_details', 'messages', 'Item Stock Details', 'active', NULL, NULL, '2025-06-21 00:42:36', '2025-06-21 00:42:36'),
(1418, '9f34afbf-2aaf-40a6-9185-6f8921b59b0a', 1, 3, NULL, 'item_stock.item_category', 'messages', 'Item Category', 'active', NULL, NULL, '2025-06-21 00:42:36', '2025-06-21 00:42:36'),
(1419, '9f34afbf-2cc9-45ce-91f8-5e9f6d499f8e', 1, 3, NULL, 'item_stock.item', 'messages', 'Item Name', 'active', NULL, NULL, '2025-06-21 00:42:36', '2025-06-21 00:42:36'),
(1420, '9f34afbf-2edd-4e94-896d-6b4cabf3a934', 1, 3, NULL, 'item_stock.supplier_name', 'messages', 'Supplier Name', 'active', NULL, NULL, '2025-06-21 00:42:36', '2025-06-21 00:42:36'),
(1421, '9f34afbf-3103-4fe2-aa8d-46dedb7fb2bd', 1, 3, NULL, 'item_stock.store_name', 'messages', 'Store Name', 'active', NULL, NULL, '2025-06-21 00:42:36', '2025-06-21 00:42:36'),
(1422, '9f34afbf-3317-4be1-971c-f2d04f0322c6', 1, 3, NULL, 'item_stock.quantity', 'messages', 'Quantity', 'active', NULL, NULL, '2025-06-21 00:42:36', '2025-06-21 00:42:36'),
(1423, '9f34afbf-352b-4fab-bc9f-35929ccb4c9c', 1, 3, NULL, 'item_stock.purchase_price', 'messages', 'Purchase Price', 'active', NULL, NULL, '2025-06-21 00:42:36', '2025-06-21 00:42:36'),
(1424, '9f34afbf-3721-4cb3-8712-ac3279cd6e6b', 1, 3, NULL, 'item_stock.description', 'messages', 'Description', 'active', NULL, NULL, '2025-06-21 00:42:36', '2025-06-21 00:42:36'),
(1425, '9f34afbf-3933-40e0-b422-1cf9c3488f69', 1, 3, NULL, 'item_stock.attachment', 'messages', 'Attachment', 'active', NULL, NULL, '2025-06-21 00:42:36', '2025-06-21 00:42:36'),
(1426, '9f34afbf-3b29-43bf-af3f-185a18d10b2f', 1, 3, NULL, 'issued_item.issued_item', 'messages', 'Issued Item', 'active', NULL, NULL, '2025-06-21 00:42:36', '2025-06-21 00:42:36'),
(1427, '9f34afbf-3d26-4636-a1ee-3ff5b7286151', 1, 3, NULL, 'issued_item.issued_items', 'messages', 'Issued Items', 'active', NULL, NULL, '2025-06-21 00:42:36', '2025-06-21 00:42:36'),
(1428, '9f34afbf-3f5d-4260-bbab-ef3d5290251a', 1, 3, NULL, 'issued_item.new_issued_item', 'messages', 'New Issued Item', 'active', NULL, NULL, '2025-06-21 00:42:36', '2025-06-21 00:42:36'),
(1429, '9f34afbf-414b-44f1-aa46-9a4103876cf1', 1, 3, NULL, 'issued_item.edit_issued_item', 'messages', 'Edit Issued Item', 'active', NULL, NULL, '2025-06-21 00:42:36', '2025-06-21 00:42:36'),
(1430, '9f34afbf-436d-4566-a02b-3b1296157ead', 1, 3, NULL, 'issued_item.issued_item_details', 'messages', 'Issued Items Details', 'active', NULL, NULL, '2025-06-21 00:42:36', '2025-06-21 00:42:36'),
(1431, '9f34afbf-45a7-450c-b144-3e268019b4d1', 1, 3, NULL, 'issued_item.department_id', 'messages', 'User Type', 'active', NULL, NULL, '2025-06-21 00:42:36', '2025-06-21 00:42:36'),
(1432, '9f34afbf-479f-425e-9285-5590c90d43d8', 1, 3, NULL, 'issued_item.user_id', 'messages', 'Issue To', 'active', NULL, NULL, '2025-06-21 00:42:36', '2025-06-21 00:42:36'),
(1433, '9f34afbf-49aa-4487-9e4a-914862dc0fb4', 1, 3, NULL, 'issued_item.issued_by', 'messages', 'Issue By', 'active', NULL, NULL, '2025-06-21 00:42:36', '2025-06-21 00:42:36'),
(1434, '9f34afbf-4bb6-422c-9aed-c785bc694b8e', 1, 3, NULL, 'issued_item.issued_for', 'messages', 'Issue For', 'active', NULL, NULL, '2025-06-21 00:42:36', '2025-06-21 00:42:36'),
(1435, '9f34afbf-4dd5-43d8-b969-fddfcc08ee8a', 1, 3, NULL, 'issued_item.issued_date', 'messages', 'Issue Date', 'active', NULL, NULL, '2025-06-21 00:42:36', '2025-06-21 00:42:36'),
(1436, '9f34afbf-5038-4a9b-ab6b-a935975eb44e', 1, 3, NULL, 'issued_item.return_date', 'messages', 'Return Date', 'active', NULL, NULL, '2025-06-21 00:42:36', '2025-06-21 00:42:36'),
(1437, '9f34afbf-5289-4894-9ee5-f692559cf117', 1, 3, NULL, 'issued_item.item_category', 'messages', 'Item Category', 'active', NULL, NULL, '2025-06-21 00:42:36', '2025-06-21 00:42:36'),
(1438, '9f34afbf-54b6-4d8d-8533-7f9d39f18f16', 1, 3, NULL, 'issued_item.item', 'messages', 'Item', 'active', NULL, NULL, '2025-06-21 00:42:36', '2025-06-21 00:42:36'),
(1439, '9f34afbf-56cc-41e2-9ec5-2ac40dd291b3', 1, 3, NULL, 'issued_item.quantity', 'messages', 'Quantity', 'active', NULL, NULL, '2025-06-21 00:42:36', '2025-06-21 00:42:36'),
(1440, '9f34afbf-58db-436a-b7a3-4605f75ee8ad', 1, 3, NULL, 'issued_item.description', 'messages', 'Description', 'active', NULL, NULL, '2025-06-21 00:42:36', '2025-06-21 00:42:36'),
(1441, '9f34afbf-5af7-4fdd-92d0-b1dfbc785326', 1, 3, NULL, 'issued_item.available_quantity', 'messages', 'Available Quantity', 'active', NULL, NULL, '2025-06-21 00:42:36', '2025-06-21 00:42:36'),
(1442, '9f34afbf-5d13-4ade-b49c-ab04a17a3ac8', 1, 3, NULL, 'issued_item.item_return', 'messages', 'Return Item', 'active', NULL, NULL, '2025-06-21 00:42:36', '2025-06-21 00:42:36'),
(1443, '9f34afbf-5f52-492b-9150-b3f50d931e73', 1, 3, NULL, 'issued_item.item_returned', 'messages', 'Returned', 'active', NULL, NULL, '2025-06-21 00:42:36', '2025-06-21 00:42:36'),
(1444, '9f34afbf-617a-46e2-b0d2-9262c4d13628', 1, 3, NULL, 'issued_item.select_user_type', 'messages', 'Select User Type', 'active', NULL, NULL, '2025-06-21 00:42:36', '2025-06-21 00:42:36'),
(1445, '9f34afbf-63a7-49dd-93bf-2b5f30c8165f', 1, 3, NULL, 'issued_item.qty_cannot_be_zero', 'messages', 'Quantity cannot be zero.', 'active', NULL, NULL, '2025-06-21 00:42:36', '2025-06-21 00:42:36'),
(1446, '9f34afbf-65dd-4578-b493-3efa6aa059d4', 1, 3, NULL, 'issued_item.qty_must_be_less_than_available_qty', 'messages', 'Quantity must be less than Available quantity.', 'active', NULL, NULL, '2025-06-21 00:42:36', '2025-06-21 00:42:36'),
(1447, '9f34afbf-6847-46e2-b7e3-a1c2717a847b', 1, 3, NULL, 'issued_item.are_you_sure_want_to_return_this_item', 'messages', 'Are you sure want to return this item', 'active', NULL, NULL, '2025-06-21 00:42:36', '2025-06-21 00:42:36'),
(1448, '9f34afbf-6a8b-44cd-a861-c03990d0f0ac', 1, 3, NULL, 'ipd_patient.ipd_patient', 'messages', 'IPD Patient', 'active', NULL, NULL, '2025-06-21 00:42:36', '2025-06-21 00:42:36'),
(1449, '9f34afbf-6ce0-4d51-8f5d-13c1aef917ec', 1, 3, NULL, 'ipd_patient.ipd_patients', 'messages', 'IPD Patients', 'active', NULL, NULL, '2025-06-21 00:42:36', '2025-06-21 00:42:36'),
(1450, '9f34afbf-6f17-4056-9a89-f97222f85b5e', 1, 3, NULL, 'ipd_patient.new_ipd_patient', 'messages', 'New IPD Patient', 'active', NULL, NULL, '2025-06-21 00:42:36', '2025-06-21 00:42:36'),
(1451, '9f34afbf-713f-4802-93ff-2f2c05eface4', 1, 3, NULL, 'ipd_patient.edit_ipd_patient', 'messages', 'Edit IPD Patient', 'active', NULL, NULL, '2025-06-21 00:42:36', '2025-06-21 00:42:36'),
(1452, '9f34afbf-7376-48a0-90e6-247e426af73d', 1, 3, NULL, 'ipd_patient.ipd_patient_details', 'messages', 'IPD Patient Details', 'active', NULL, NULL, '2025-06-21 00:42:36', '2025-06-21 00:42:36'),
(1453, '9f34afbf-7599-4701-b68f-47712a3d4f9c', 1, 3, NULL, 'ipd_patient.patient_id', 'messages', 'Patient', 'active', NULL, NULL, '2025-06-21 00:42:36', '2025-06-21 00:42:36'),
(1454, '9f34afbf-77c1-43e4-9d83-107f5288ab5f', 1, 3, NULL, 'ipd_patient.ipd_number', 'messages', 'IPD No', 'active', NULL, NULL, '2025-06-21 00:42:36', '2025-06-21 00:42:36'),
(1455, '9f34afbf-79f5-4149-b4f1-7ce9beb8ba58', 1, 3, NULL, 'ipd_patient.height', 'messages', 'Height', 'active', NULL, NULL, '2025-06-21 00:42:36', '2025-06-21 00:42:36'),
(1456, '9f34afbf-7c4a-413f-939e-7e56f0b28b25', 1, 3, NULL, 'ipd_patient.weight', 'messages', 'Weight', 'active', NULL, NULL, '2025-06-21 00:42:36', '2025-06-21 00:42:36'),
(1457, '9f34afbf-7e9a-484a-a0c9-ac452aed82af', 1, 3, NULL, 'ipd_patient.bp', 'messages', 'Blood Pressure', 'active', NULL, NULL, '2025-06-21 00:42:36', '2025-06-21 00:42:36'),
(1458, '9f34afbf-812b-4509-81c4-817ed8b0dd78', 1, 3, NULL, 'ipd_patient.symptoms', 'messages', 'Symptoms', 'active', NULL, NULL, '2025-06-21 00:42:36', '2025-06-21 00:42:36'),
(1459, '9f34afbf-845f-45c8-a9cf-382faeff13b7', 1, 3, NULL, 'ipd_patient.notes', 'messages', 'Notes', 'active', NULL, NULL, '2025-06-21 00:42:36', '2025-06-21 00:42:36'),
(1460, '9f34afbf-89d0-4f25-923e-41ff145ba963', 1, 3, NULL, 'ipd_patient.admission_date', 'messages', 'Admission Date', 'active', NULL, NULL, '2025-06-21 00:42:36', '2025-06-21 00:42:36'),
(1461, '9f34afbf-8c26-411a-9550-ba8879453d3a', 1, 3, NULL, 'ipd_patient.case_id', 'messages', 'Case', 'active', NULL, NULL, '2025-06-21 00:42:36', '2025-06-21 00:42:36'),
(1462, '9f34afbf-8e9c-4260-94b1-e7dc03f3fc0d', 1, 3, NULL, 'ipd_patient.is_old_patient', 'messages', 'Is Old Patient', 'active', NULL, NULL, '2025-06-21 00:42:36', '2025-06-21 00:42:36'),
(1463, '9f34afbf-90d6-493d-9a87-a230d943aa85', 1, 3, NULL, 'ipd_patient.doctor_id', 'messages', 'Doctor', 'active', NULL, NULL, '2025-06-21 00:42:36', '2025-06-21 00:42:36'),
(1464, '9f34afbf-9322-4ae1-b7a3-63e238879307', 1, 3, NULL, 'ipd_patient.bed_type_id', 'messages', 'Bed Type', 'active', NULL, NULL, '2025-06-21 00:42:36', '2025-06-21 00:42:36'),
(1465, '9f34afbf-95b8-4788-a31b-64860d701163', 1, 3, NULL, 'ipd_patient.bed_id', 'messages', 'Bed', 'active', NULL, NULL, '2025-06-21 00:42:36', '2025-06-21 00:42:36'),
(1466, '9f34afbf-97f4-4912-a75e-b45b071fd87b', 1, 3, NULL, 'ipd_patient.bill_status', 'messages', 'Bill Status', 'active', NULL, NULL, '2025-06-21 00:42:36', '2025-06-21 00:42:36'),
(1467, '9f34afbf-9a51-4897-bc8e-bbfcb9836525', 1, 3, NULL, 'ipd_patient.choose_case', 'messages', 'Choose Case', 'active', NULL, NULL, '2025-06-21 00:42:36', '2025-06-21 00:42:36'),
(1468, '9f34afbf-9cac-47b5-8c71-fbdc2f200251', 1, 3, NULL, 'ipd_patient.discharged', 'messages', 'Discharged', 'active', NULL, NULL, '2025-06-21 00:42:36', '2025-06-21 00:42:36'),
(1469, '9f34afbf-9eca-4c55-b0da-07b5930e4013', 1, 3, NULL, 'ipd_patient.discharge_patient', 'messages', 'Discharge patient', 'active', NULL, NULL, '2025-06-21 00:42:36', '2025-06-21 00:42:36'),
(1470, '9f34afbf-a1ae-4b9e-a196-57fc5235bc6d', 1, 3, NULL, 'ipd_patient.please_select_applied_date', 'messages', 'Please select Applied date', 'active', NULL, NULL, '2025-06-21 00:42:36', '2025-06-21 00:42:36'),
(1471, '9f34afbf-a534-4445-af1e-d9577f417dc2', 1, 3, NULL, 'ipd_patient.please_select_instruction_date', 'messages', 'Please select Instruction date', 'active', NULL, NULL, '2025-06-21 00:42:36', '2025-06-21 00:42:36'),
(1472, '9f34afbf-a86b-464b-b360-411c3135e490', 1, 3, NULL, 'ipd_patient.please_enter_instruction', 'messages', 'Please enter Instruction', 'active', NULL, NULL, '2025-06-21 00:42:36', '2025-06-21 00:42:36'),
(1473, '9f34afbf-ab38-43b3-b6fb-0707ef390d28', 1, 3, NULL, 'ipd_patient_diagnosis.new_ipd_diagnosis', 'messages', 'Add Diagnosis', 'active', NULL, NULL, '2025-06-21 00:42:36', '2025-06-21 00:42:36'),
(1474, '9f34afbf-adc9-448b-bc56-cd273f6eaaa6', 1, 3, NULL, 'ipd_patient_diagnosis.edit_ipd_diagnosis', 'messages', 'Edit Diagnosis', 'active', NULL, NULL, '2025-06-21 00:42:36', '2025-06-21 00:42:36'),
(1475, '9f34afbf-b02a-402a-a797-9fabaa790bd8', 1, 3, NULL, 'ipd_patient_diagnosis.report_type', 'messages', 'Report Type', 'active', NULL, NULL, '2025-06-21 00:42:36', '2025-06-21 00:42:36'),
(1476, '9f34afbf-b396-4c16-a2bb-90c5bb5af6d3', 1, 3, NULL, 'ipd_patient_diagnosis.report_date', 'messages', 'Report Date', 'active', NULL, NULL, '2025-06-21 00:42:36', '2025-06-21 00:42:36'),
(1477, '9f34afbf-b60f-4471-8f89-b3785f9b61cd', 1, 3, NULL, 'ipd_patient_diagnosis.document', 'messages', 'Document', 'active', NULL, NULL, '2025-06-21 00:42:36', '2025-06-21 00:42:36'),
(1478, '9f34afbf-b94f-408e-8277-8d480b00017d', 1, 3, NULL, 'ipd_patient_diagnosis.description', 'messages', 'Description', 'active', NULL, NULL, '2025-06-21 00:42:36', '2025-06-21 00:42:36'),
(1479, '9f34afbf-bba3-4f05-aca5-60ee35996d6d', 1, 3, NULL, 'ipd_patient_consultant_register.new_consultant_register', 'messages', 'Add Consultant Instruction', 'active', NULL, NULL, '2025-06-21 00:42:36', '2025-06-21 00:42:36'),
(1480, '9f34afbf-bdd3-4abf-8968-27b4e48db562', 1, 3, NULL, 'ipd_patient_consultant_register.edit_consultant_register', 'messages', 'Edit Consultant Instruction', 'active', NULL, NULL, '2025-06-21 00:42:36', '2025-06-21 00:42:36'),
(1481, '9f34afbf-c020-4907-ba03-84f660b09efc', 1, 3, NULL, 'ipd_patient_consultant_register.applied_date', 'messages', 'Applied Date', 'active', NULL, NULL, '2025-06-21 00:42:36', '2025-06-21 00:42:36'),
(1482, '9f34afbf-c23f-42ec-af89-b2128311ab8b', 1, 3, NULL, 'ipd_patient_consultant_register.doctor_id', 'messages', 'Doctor', 'active', NULL, NULL, '2025-06-21 00:42:36', '2025-06-21 00:42:36'),
(1483, '9f34afbf-c469-4ddf-a9a0-621710c6e29b', 1, 3, NULL, 'ipd_patient_consultant_register.instruction', 'messages', 'Instruction', 'active', NULL, NULL, '2025-06-21 00:42:36', '2025-06-21 00:42:36'),
(1484, '9f34afbf-c687-465d-ad50-ddd8540d566c', 1, 3, NULL, 'ipd_patient_consultant_register.instruction_date', 'messages', 'Instruction Date', 'active', NULL, NULL, '2025-06-21 00:42:36', '2025-06-21 00:42:36'),
(1485, '9f34afbf-c8a9-4a10-984a-4c06dff49c37', 1, 3, NULL, 'ipd_patient_charges.new_charge', 'messages', 'Add Charges', 'active', NULL, NULL, '2025-06-21 00:42:36', '2025-06-21 00:42:36'),
(1486, '9f34afbf-cad3-45b9-be37-77d9afbbd25f', 1, 3, NULL, 'ipd_patient_charges.edit_charge', 'messages', 'Edit Charges', 'active', NULL, NULL, '2025-06-21 00:42:36', '2025-06-21 00:42:36'),
(1487, '9f34afbf-cd0b-4edf-836a-8b7f833e3b47', 1, 3, NULL, 'ipd_patient_charges.date', 'messages', 'Date', 'active', NULL, NULL, '2025-06-21 00:42:36', '2025-06-21 00:42:36'),
(1488, '9f34afbf-cf51-4364-9947-21ede35a1a00', 1, 3, NULL, 'ipd_patient_charges.charge_type_id', 'messages', 'Charge Type', 'active', NULL, NULL, '2025-06-21 00:42:36', '2025-06-21 00:42:36'),
(1489, '9f34afbf-d168-4b12-ad09-6d640a89a1f7', 1, 3, NULL, 'ipd_patient_charges.charge_category_id', 'messages', 'Charge Category', 'active', NULL, NULL, '2025-06-21 00:42:36', '2025-06-21 00:42:36'),
(1490, '9f34afbf-d386-4509-8987-15118e35889f', 1, 3, NULL, 'ipd_patient_charges.charge_id', 'messages', 'Code', 'active', NULL, NULL, '2025-06-21 00:42:37', '2025-06-21 00:42:37'),
(1491, '9f34afbf-d59e-48e4-aa28-0d7a62d74222', 1, 3, NULL, 'ipd_patient_charges.standard_charge', 'messages', 'Standard Charge', 'active', NULL, NULL, '2025-06-21 00:42:37', '2025-06-21 00:42:37'),
(1492, '9f34afbf-d7ae-4832-a2e9-5f2e34db34a1', 1, 3, NULL, 'ipd_patient_charges.applied_charge', 'messages', 'Applied Charge', 'active', NULL, NULL, '2025-06-21 00:42:37', '2025-06-21 00:42:37'),
(1493, '9f34afbf-d9c9-4699-a251-05dafd60cdbb', 1, 3, NULL, 'ipd_patient_prescription.ipd_no', 'messages', 'IPD No', 'active', NULL, NULL, '2025-06-21 00:42:37', '2025-06-21 00:42:37'),
(1494, '9f34afbf-dbea-4ccc-b605-544fe04595f9', 1, 3, NULL, 'ipd_patient_prescription.header_note', 'messages', 'Header Note', 'active', NULL, NULL, '2025-06-21 00:42:37', '2025-06-21 00:42:37'),
(1495, '9f34afbf-de08-4693-84d5-217fad0c16c9', 1, 3, NULL, 'ipd_patient_prescription.footer_note', 'messages', 'Footer Note', 'active', NULL, NULL, '2025-06-21 00:42:37', '2025-06-21 00:42:37'),
(1496, '9f34afbf-e030-47cf-b7a2-b1e56028c80b', 1, 3, NULL, 'ipd_patient_prescription.new_prescription', 'messages', 'Add Prescription', 'active', NULL, NULL, '2025-06-21 00:42:37', '2025-06-21 00:42:37'),
(1497, '9f34afbf-e24b-4882-9a66-2c13c1658bb3', 1, 3, NULL, 'ipd_patient_prescription.edit_prescription', 'messages', 'Edit Prescription', 'active', NULL, NULL, '2025-06-21 00:42:37', '2025-06-21 00:42:37'),
(1498, '9f34afbf-e463-4b99-b505-c41ce9a87f9d', 1, 3, NULL, 'ipd_patient_prescription.prescription_details', 'messages', 'Prescription Details', 'active', NULL, NULL, '2025-06-21 00:42:37', '2025-06-21 00:42:37'),
(1499, '9f34afbf-e68e-45ff-a24c-718d3a5deb38', 1, 3, NULL, 'ipd_patient_prescription.category_id', 'messages', 'Medicine Category', 'active', NULL, NULL, '2025-06-21 00:42:37', '2025-06-21 00:42:37'),
(1500, '9f34afbf-e8cd-4559-90f2-6f55d3bd8ea1', 1, 3, NULL, 'ipd_patient_prescription.medicine_id', 'messages', 'Medicine', 'active', NULL, NULL, '2025-06-21 00:42:37', '2025-06-21 00:42:37'),
(1501, '9f34afbf-eafd-4ebf-8477-d7037f03ed7f', 1, 3, NULL, 'ipd_patient_prescription.dosage', 'messages', 'Dosage', 'active', NULL, NULL, '2025-06-21 00:42:37', '2025-06-21 00:42:37'),
(1502, '9f34afbf-ed48-4393-a329-6e766ed2589f', 1, 3, NULL, 'ipd_patient_prescription.instruction', 'messages', 'Instruction', 'active', NULL, NULL, '2025-06-21 00:42:37', '2025-06-21 00:42:37'),
(1503, '9f34afbf-ef7b-4a16-8e75-0356f1c015a6', 1, 3, NULL, 'ipd_patient_prescription.print_prescription', 'messages', 'Print Prescription', 'active', NULL, NULL, '2025-06-21 00:42:37', '2025-06-21 00:42:37'),
(1504, '9f34afbf-f19d-4ecf-bed2-9635e0d31836', 1, 3, NULL, 'ipd_patient_timeline.new_ipd_timeline', 'messages', 'Add Timeline', 'active', NULL, NULL, '2025-06-21 00:42:37', '2025-06-21 00:42:37'),
(1505, '9f34afbf-f3b4-412f-93b2-170004ba3c79', 1, 3, NULL, 'ipd_patient_timeline.edit_ipd_timeline', 'messages', 'Edit Timeline', 'active', NULL, NULL, '2025-06-21 00:42:37', '2025-06-21 00:42:37'),
(1506, '9f34afbf-f5fb-467a-96a9-c4e8fc43bd8a', 1, 3, NULL, 'ipd_patient_timeline.title', 'messages', 'Title', 'active', NULL, NULL, '2025-06-21 00:42:37', '2025-06-21 00:42:37'),
(1507, '9f34afbf-f83a-498f-bee0-4321ef294473', 1, 3, NULL, 'ipd_patient_timeline.date', 'messages', 'Date', 'active', NULL, NULL, '2025-06-21 00:42:37', '2025-06-21 00:42:37'),
(1508, '9f34afbf-fa76-429e-8e69-3aa03b90c684', 1, 3, NULL, 'ipd_patient_timeline.description', 'messages', 'Description', 'active', NULL, NULL, '2025-06-21 00:42:37', '2025-06-21 00:42:37'),
(1509, '9f34afbf-fc7d-406d-b520-c94f17102692', 1, 3, NULL, 'ipd_patient_timeline.document', 'messages', 'Document', 'active', NULL, NULL, '2025-06-21 00:42:37', '2025-06-21 00:42:37'),
(1510, '9f34afbf-fea1-4481-833a-8faccf810c86', 1, 3, NULL, 'ipd_patient_timeline.visible_to_person', 'messages', 'Visible To Person', 'active', NULL, NULL, '2025-06-21 00:42:37', '2025-06-21 00:42:37'),
(1511, '9f34afc0-00be-4b99-9e06-b719ce96149b', 1, 3, NULL, 'ipd_patient_timeline.no_timeline_found', 'messages', 'No TimeLine Found', 'active', NULL, NULL, '2025-06-21 00:42:37', '2025-06-21 00:42:37'),
(1512, '9f34afc0-02fc-4aeb-a431-2e4fa8172c98', 1, 3, NULL, 'ipd_payments.add_ipd_payment', 'messages', 'Add IPD Payment', 'active', NULL, NULL, '2025-06-21 00:42:37', '2025-06-21 00:42:37'),
(1513, '9f34afc0-0516-4c4c-951b-cee5b2188087', 1, 3, NULL, 'ipd_payments.edit_ipd_payment', 'messages', 'Edit IPD Payment', 'active', NULL, NULL, '2025-06-21 00:42:37', '2025-06-21 00:42:37'),
(1514, '9f34afc0-073a-4fa1-bcbc-a7f8bed60c64', 1, 3, NULL, 'ipd_payments.select_payment_mode', 'messages', 'Select Payment Mode', 'active', NULL, NULL, '2025-06-21 00:42:37', '2025-06-21 00:42:37'),
(1515, '9f34afc0-097f-4ab8-b797-92cd29e12ced', 1, 3, NULL, 'ipd_payments.payment_mode', 'messages', 'Payment Mode', 'active', NULL, NULL, '2025-06-21 00:42:37', '2025-06-21 00:42:37'),
(1516, '9f34afc0-0ba0-4176-b2be-3dfa9fef209e', 1, 3, NULL, 'ipd_payments.make_payment', 'messages', 'Make Payment', 'active', NULL, NULL, '2025-06-21 00:42:37', '2025-06-21 00:42:37'),
(1517, '9f34afc0-0dbd-4e89-bf9a-f71143a95425', 1, 3, NULL, 'ipd_bill.paid_amount', 'messages', 'Paid Amount', 'active', NULL, NULL, '2025-06-21 00:42:37', '2025-06-21 00:42:37'),
(1518, '9f34afc0-0fe8-4d97-90d8-3926b77deabb', 1, 3, NULL, 'ipd_bill.total_charges', 'messages', 'Total Charges', 'active', NULL, NULL, '2025-06-21 00:42:37', '2025-06-21 00:42:37'),
(1519, '9f34afc0-1225-417c-8aca-5f98802775d5', 1, 3, NULL, 'ipd_bill.gross_total', 'messages', 'Gross Total', 'active', NULL, NULL, '2025-06-21 00:42:37', '2025-06-21 00:42:37'),
(1520, '9f34afc0-1483-43d2-ac58-a69f748bc50c', 1, 3, NULL, 'ipd_bill.discount_in_percentage', 'messages', 'Discount In Percentage', 'active', NULL, NULL, '2025-06-21 00:42:37', '2025-06-21 00:42:37'),
(1521, '9f34afc0-16c2-4b48-a3cf-24ddc9c2d3d5', 1, 3, NULL, 'ipd_bill.discount_in_number', 'messages', 'Discount In Number', 'active', NULL, NULL, '2025-06-21 00:42:37', '2025-06-21 00:42:37'),
(1522, '9f34afc0-18ed-4892-bf29-e2a07abf255e', 1, 3, NULL, 'ipd_bill.tax_in_percentage', 'messages', 'Tax In Percentage', 'active', NULL, NULL, '2025-06-21 00:42:37', '2025-06-21 00:42:37'),
(1523, '9f34afc0-1b07-4f97-8aac-548174329d33', 1, 3, NULL, 'ipd_bill.tax_in_number', 'messages', 'Tax In Number', 'active', NULL, NULL, '2025-06-21 00:42:37', '2025-06-21 00:42:37'),
(1524, '9f34afc0-1d2d-48ec-808e-e2a4859593a0', 1, 3, NULL, 'ipd_bill.other_charges', 'messages', 'Other Charges', 'active', NULL, NULL, '2025-06-21 00:42:37', '2025-06-21 00:42:37'),
(1525, '9f34afc0-1f4a-422e-821e-cf5b98349be9', 1, 3, NULL, 'ipd_bill.net_payable_amount', 'messages', 'Net Payable Amount', 'active', NULL, NULL, '2025-06-21 00:42:37', '2025-06-21 00:42:37'),
(1526, '9f34afc0-2177-4742-a1ef-6efd69c79def', 1, 3, NULL, 'ipd_bill.discharge_patient', 'messages', 'Discharge Patient', 'active', NULL, NULL, '2025-06-21 00:42:37', '2025-06-21 00:42:37'),
(1527, '9f34afc0-23af-442f-bd41-1545a18ba6e8', 1, 3, NULL, 'opd_patient.opd_patient', 'messages', 'OPD Patient', 'active', NULL, NULL, '2025-06-21 00:42:37', '2025-06-21 00:42:37'),
(1528, '9f34afc0-25d5-4e48-a2f5-5c643f357cb6', 1, 3, NULL, 'opd_patient.opd_patients', 'messages', 'OPD Patients', 'active', NULL, NULL, '2025-06-21 00:42:37', '2025-06-21 00:42:37'),
(1529, '9f34afc0-29a0-4f14-97c6-d26ed668f53b', 1, 3, NULL, 'opd_patient.new_opd_patient', 'messages', 'New OPD Patient', 'active', NULL, NULL, '2025-06-21 00:42:37', '2025-06-21 00:42:37'),
(1530, '9f34afc0-2bfb-4336-9e36-13bf486b6cc0', 1, 3, NULL, 'opd_patient.edit_opd_patient', 'messages', 'Edit OPD Patient', 'active', NULL, NULL, '2025-06-21 00:42:37', '2025-06-21 00:42:37'),
(1531, '9f34afc0-2e1b-49d8-ae33-5206cadc02b6', 1, 3, NULL, 'opd_patient.opd_patient_details', 'messages', 'OPD Patient Details', 'active', NULL, NULL, '2025-06-21 00:42:37', '2025-06-21 00:42:37'),
(1532, '9f34afc0-304d-4443-9967-19c6e448fced', 1, 3, NULL, 'opd_patient.opd_number', 'messages', 'OPD No', 'active', NULL, NULL, '2025-06-21 00:42:37', '2025-06-21 00:42:37'),
(1533, '9f34afc0-3281-4780-9c07-a90e475e604a', 1, 3, NULL, 'opd_patient.appointment_date', 'messages', 'Appointment Date', 'active', NULL, NULL, '2025-06-21 00:42:37', '2025-06-21 00:42:37'),
(1534, '9f34afc0-3492-472a-8b52-f40aaffe01b9', 1, 3, NULL, 'opd_patient.visits', 'messages', 'Visits', 'active', NULL, NULL, '2025-06-21 00:42:37', '2025-06-21 00:42:37'),
(1535, '9f34afc0-36b9-4d25-aaeb-9895a7aba2bf', 1, 3, NULL, 'opd_patient.revisits', 'messages', 'Revisit', 'active', NULL, NULL, '2025-06-21 00:42:37', '2025-06-21 00:42:37'),
(1536, '9f34afc0-3905-48a0-9c45-644b4b086d37', 1, 3, NULL, 'opd_patient.total_visits', 'messages', 'Total Visits', 'active', NULL, NULL, '2025-06-21 00:42:37', '2025-06-21 00:42:37'),
(1537, '9f34afc0-3b47-43b5-9af9-382f3b5538d0', 1, 3, NULL, 'opd_payments.add_opd_payment', 'messages', 'Add Opd Payment', 'active', NULL, NULL, '2025-06-21 00:42:37', '2025-06-21 00:42:37'),
(1538, '9f34afc0-3d80-44a2-90c6-ffb0eef6a6bf', 1, 3, NULL, 'opd_payments.edit_opd_payment', 'messages', 'Edit Opd Payment', 'active', NULL, NULL, '2025-06-21 00:42:37', '2025-06-21 00:42:37'),
(1539, '9f34afc0-3fa0-4724-ad69-7c4efd4edf32', 1, 3, NULL, 'opd_payments.payment_mode', 'messages', 'Payment Mode', 'active', NULL, NULL, '2025-06-21 00:42:37', '2025-06-21 00:42:37'),
(1540, '9f34afc0-41d8-4e96-bd9a-fa5fbfa3e8d6', 1, 3, NULL, 'opd_payments.make_payment', 'messages', 'Make Payment', 'active', NULL, NULL, '2025-06-21 00:42:37', '2025-06-21 00:42:37'),
(1541, '9f34afc0-4434-420b-b870-2982f1298013', 1, 3, NULL, 'opd_payments.choose_payment', 'messages', 'Choose Payment', 'active', NULL, NULL, '2025-06-21 00:42:37', '2025-06-21 00:42:37'),
(1542, '9f34afc0-4693-4089-8c1a-7a4772e6db22', 1, 3, NULL, 'call_log.new', 'messages', 'New Call Log', 'active', NULL, NULL, '2025-06-21 00:42:37', '2025-06-21 00:42:37'),
(1543, '9f34afc0-490f-4a69-8ad2-e81bb509d3b2', 1, 3, NULL, 'call_log.edit', 'messages', 'Edit Call Log', 'active', NULL, NULL, '2025-06-21 00:42:37', '2025-06-21 00:42:37'),
(1544, '9f34afc0-4b38-44ab-825b-fa27ca4ef06a', 1, 3, NULL, 'call_log.name', 'messages', 'Name', 'active', NULL, NULL, '2025-06-21 00:42:37', '2025-06-21 00:42:37'),
(1545, '9f34afc0-4d51-4258-a409-5acd2661791e', 1, 3, NULL, 'call_log.phone', 'messages', 'Phone', 'active', NULL, NULL, '2025-06-21 00:42:37', '2025-06-21 00:42:37'),
(1546, '9f34afc0-4f7d-491c-9d7e-52c129797ddd', 1, 3, NULL, 'call_log.received_on', 'messages', 'Received On', 'active', NULL, NULL, '2025-06-21 00:42:37', '2025-06-21 00:42:37'),
(1547, '9f34afc0-51b2-4240-af55-11eaaed1d457', 1, 3, NULL, 'call_log.follow_up_date', 'messages', 'Follow-Up Date', 'active', NULL, NULL, '2025-06-21 00:42:37', '2025-06-21 00:42:37'),
(1548, '9f34afc0-53f0-461e-b893-afee1ebea072', 1, 3, NULL, 'call_log.note', 'messages', 'Note', 'active', NULL, NULL, '2025-06-21 00:42:37', '2025-06-21 00:42:37'),
(1549, '9f34afc0-561b-433e-aaa7-0a5cd9aca6a9', 1, 3, NULL, 'call_log.call_type', 'messages', 'Call Type', 'active', NULL, NULL, '2025-06-21 00:42:37', '2025-06-21 00:42:37'),
(1550, '9f34afc0-583f-49a5-9e5c-58d9c9421990', 1, 3, NULL, 'call_log.incoming', 'messages', 'Incoming', 'active', NULL, NULL, '2025-06-21 00:42:37', '2025-06-21 00:42:37'),
(1551, '9f34afc0-5a8b-4247-a711-6b4504c2100d', 1, 3, NULL, 'call_log.outgoing', 'messages', 'Outgoing', 'active', NULL, NULL, '2025-06-21 00:42:37', '2025-06-21 00:42:37'),
(1552, '9f34afc0-5cad-4453-a63d-c12f33572528', 1, 3, NULL, 'visitor_filter.visit', 'messages', 'Visit', 'active', NULL, NULL, '2025-06-21 00:42:37', '2025-06-21 00:42:37'),
(1553, '9f34afc0-5ece-4061-af5c-f6ec558903cd', 1, 3, NULL, 'visitor_filter.enquiry', 'messages', 'Enquiry', 'active', NULL, NULL, '2025-06-21 00:42:37', '2025-06-21 00:42:37'),
(1554, '9f34afc0-60fc-43e3-a745-63c8de112ef4', 1, 3, NULL, 'visitor_filter.seminar', 'messages', 'Seminar', 'active', NULL, NULL, '2025-06-21 00:42:37', '2025-06-21 00:42:37'),
(1555, '9f34afc0-6343-4818-b96e-4f5a01504040', 1, 3, NULL, 'visitor.new', 'messages', 'New Visitor', 'active', NULL, NULL, '2025-06-21 00:42:37', '2025-06-21 00:42:37'),
(1556, '9f34afc0-6575-424e-bbb3-3e7c93585522', 1, 3, NULL, 'visitor.edit', 'messages', 'Edit Visitor', 'active', NULL, NULL, '2025-06-21 00:42:37', '2025-06-21 00:42:37'),
(1557, '9f34afc0-679e-412f-9e7a-7fa6c9fc8e80', 1, 3, NULL, 'visitor.name', 'messages', 'Name', 'active', NULL, NULL, '2025-06-21 00:42:37', '2025-06-21 00:42:37'),
(1558, '9f34afc0-69c0-4e5d-93f0-79c46ff1eb3f', 1, 3, NULL, 'visitor.purpose', 'messages', 'Purpose', 'active', NULL, NULL, '2025-06-21 00:42:37', '2025-06-21 00:42:37'),
(1559, '9f34afc0-6be6-4bf7-afd5-2f62da9e7f34', 1, 3, NULL, 'visitor.phone', 'messages', 'Phone', 'active', NULL, NULL, '2025-06-21 00:42:37', '2025-06-21 00:42:37'),
(1560, '9f34afc0-6e22-439e-9625-a0d2a1524e3a', 1, 3, NULL, 'visitor.id_card', 'messages', 'ID Card', 'active', NULL, NULL, '2025-06-21 00:42:37', '2025-06-21 00:42:37'),
(1561, '9f34afc0-705e-469c-9a5c-69a33e2b54de', 1, 3, NULL, 'visitor.number_of_person', 'messages', 'Number Of Person', 'active', NULL, NULL, '2025-06-21 00:42:37', '2025-06-21 00:42:37'),
(1562, '9f34afc0-73bf-4698-8ff6-78aef012b35b', 1, 3, NULL, 'visitor.date', 'messages', 'Date', 'active', NULL, NULL, '2025-06-21 00:42:37', '2025-06-21 00:42:37'),
(1563, '9f34afc0-761a-497c-a8b6-3392b7c46f32', 1, 3, NULL, 'visitor.in_time', 'messages', 'In Time', 'active', NULL, NULL, '2025-06-21 00:42:37', '2025-06-21 00:42:37'),
(1564, '9f34afc0-785f-4a44-8dc2-58d916534425', 1, 3, NULL, 'visitor.out_time', 'messages', 'Out Time', 'active', NULL, NULL, '2025-06-21 00:42:37', '2025-06-21 00:42:37'),
(1565, '9f34afc0-7aa3-4303-99ea-9dc7c8347f8f', 1, 3, NULL, 'visitor.note', 'messages', 'Note', 'active', NULL, NULL, '2025-06-21 00:42:37', '2025-06-21 00:42:37'),
(1566, '9f34afc0-7cf7-43ec-b7d5-3911e16fe36f', 1, 3, NULL, 'visitor.select_purpose', 'messages', 'Select purpose', 'active', NULL, NULL, '2025-06-21 00:42:37', '2025-06-21 00:42:37'),
(1567, '9f34afc0-7f3c-4854-9364-ea5ca3355b87', 1, 3, NULL, 'postal.new_receive', 'messages', 'New Receive', 'active', NULL, NULL, '2025-06-21 00:42:37', '2025-06-21 00:42:37'),
(1568, '9f34afc0-81a2-4891-99ce-54cfb5117557', 1, 3, NULL, 'postal.new_dispatch', 'messages', 'New Dispatch', 'active', NULL, NULL, '2025-06-21 00:42:37', '2025-06-21 00:42:37'),
(1569, '9f34afc0-842b-4b30-845a-f2376338bf75', 1, 3, NULL, 'postal.dispatch', 'messages', 'Dispatch', 'active', NULL, NULL, '2025-06-21 00:42:37', '2025-06-21 00:42:37'),
(1570, '9f34afc0-8669-4159-9ab9-7176206a7dc9', 1, 3, NULL, 'postal.receive', 'messages', 'Receive', 'active', NULL, NULL, '2025-06-21 00:42:37', '2025-06-21 00:42:37'),
(1571, '9f34afc0-88aa-4034-a5ce-50933a46fbf6', 1, 3, NULL, 'postal.edit_receive', 'messages', 'Edit Receive', 'active', NULL, NULL, '2025-06-21 00:42:37', '2025-06-21 00:42:37'),
(1572, '9f34afc0-8b23-4a1c-a563-2f8d09b682c5', 1, 3, NULL, 'postal.edit_dispatch', 'messages', 'Edit Dispatch', 'active', NULL, NULL, '2025-06-21 00:42:37', '2025-06-21 00:42:37'),
(1573, '9f34afc0-8d68-43fb-8152-f138d6f2e010', 1, 3, NULL, 'postal.to_title', 'messages', 'To Title', 'active', NULL, NULL, '2025-06-21 00:42:37', '2025-06-21 00:42:37'),
(1574, '9f34afc0-8fb8-4198-a7b1-b026137bed8f', 1, 3, NULL, 'postal.from_title', 'messages', 'From Title', 'active', NULL, NULL, '2025-06-21 00:42:37', '2025-06-21 00:42:37'),
(1575, '9f34afc0-921b-4bab-8e16-0b6f4b901381', 1, 3, NULL, 'postal.reference_no', 'messages', 'Reference Number', 'active', NULL, NULL, '2025-06-21 00:42:37', '2025-06-21 00:42:37'),
(1576, '9f34afc0-945c-4d7c-ac9b-e344fc04eb0f', 1, 3, NULL, 'postal.date', 'messages', 'Date', 'active', NULL, NULL, '2025-06-21 00:42:37', '2025-06-21 00:42:37'),
(1577, '9f34afc0-9689-4911-b72e-10b40263d48f', 1, 3, NULL, 'postal.address', 'messages', 'Address', 'active', NULL, NULL, '2025-06-21 00:42:37', '2025-06-21 00:42:37'),
(1578, '9f34afc0-9c0e-47ae-bd81-300ded3cf734', 1, 3, NULL, 'testimonial.new_testimonial', 'messages', 'New Testimonial', 'active', NULL, NULL, '2025-06-21 00:42:37', '2025-06-21 00:42:37'),
(1579, '9f34afc0-9e7e-4703-aac6-737268a1ad54', 1, 3, NULL, 'testimonial.edit_testimonial', 'messages', 'Edit Testimonial', 'active', NULL, NULL, '2025-06-21 00:42:37', '2025-06-21 00:42:37'),
(1580, '9f34afc0-a0b9-4f66-af36-159bb61d39fc', 1, 3, NULL, 'testimonial.name', 'messages', 'Name', 'active', NULL, NULL, '2025-06-21 00:42:37', '2025-06-21 00:42:37'),
(1581, '9f34afc0-a2f4-4811-a670-dcbaa1d92cab', 1, 3, NULL, 'testimonial.description', 'messages', 'Description', 'active', NULL, NULL, '2025-06-21 00:42:37', '2025-06-21 00:42:37'),
(1582, '9f34afc0-a53a-4bce-81fd-eb97c770da9a', 1, 3, NULL, 'testimonial.profile_error', 'messages', 'The document must be a file of type: jpeg, jpg, png.', 'active', NULL, NULL, '2025-06-21 00:42:37', '2025-06-21 00:42:37'),
(1583, '9f34afc0-a75b-4e98-a1b9-31e51f20c928', 1, 3, NULL, 'testimonial.position', 'messages', 'Position', 'active', NULL, NULL, '2025-06-21 00:42:37', '2025-06-21 00:42:37'),
(1584, '9f34afc0-a99c-40dc-bdf9-1acc4b635423', 1, 3, NULL, 'testimonial.show_testimonial', 'messages', 'Show Testimonial', 'active', NULL, NULL, '2025-06-21 00:42:37', '2025-06-21 00:42:37'),
(1585, '9f34afc0-abf6-442e-a08a-402e1c9606b7', 1, 3, NULL, 'blood_donation.new_blood_donation', 'messages', 'New Blood Donation', 'active', NULL, NULL, '2025-06-21 00:42:37', '2025-06-21 00:42:37'),
(1586, '9f34afc0-ae2a-48c2-8b2f-175dea4bd14a', 1, 3, NULL, 'blood_donation.edit_blood_donation', 'messages', 'Edit Blood Donation', 'active', NULL, NULL, '2025-06-21 00:42:37', '2025-06-21 00:42:37'),
(1587, '9f34afc0-b06a-4323-89d6-58ae04b22f14', 1, 3, NULL, 'blood_donation.donor_name', 'messages', 'Donor Name', 'active', NULL, NULL, '2025-06-21 00:42:37', '2025-06-21 00:42:37'),
(1588, '9f34afc0-b298-4dc4-8da4-c38968abf0ff', 1, 3, NULL, 'blood_donation.bags', 'messages', 'Bags', 'active', NULL, NULL, '2025-06-21 00:42:37', '2025-06-21 00:42:37'),
(1589, '9f34afc0-b4e4-47ca-baf8-4426ede1a19c', 1, 3, NULL, 'blood_issue.new_blood_issue', 'messages', 'New Blood Issue', 'active', NULL, NULL, '2025-06-21 00:42:37', '2025-06-21 00:42:37'),
(1590, '9f34afc0-b737-4a9e-a1f1-2a33b71f538b', 1, 3, NULL, 'blood_issue.edit_blood_issue', 'messages', 'Edit Blood Issue', 'active', NULL, NULL, '2025-06-21 00:42:37', '2025-06-21 00:42:37'),
(1591, '9f34afc0-b970-401a-87f6-de66153b650a', 1, 3, NULL, 'blood_issue.issue_date', 'messages', 'Issue Date', 'active', NULL, NULL, '2025-06-21 00:42:37', '2025-06-21 00:42:37'),
(1592, '9f34afc0-bb9c-4977-b1ee-d6204dadb670', 1, 3, NULL, 'blood_issue.patient_name', 'messages', 'Patient Name', 'active', NULL, NULL, '2025-06-21 00:42:37', '2025-06-21 00:42:37'),
(1593, '9f34afc0-bdd2-4d0d-bdeb-72dfe0f1297f', 1, 3, NULL, 'blood_issue.doctor_name', 'messages', 'Doctor Name', 'active', NULL, NULL, '2025-06-21 00:42:37', '2025-06-21 00:42:37'),
(1594, '9f34afc0-c00e-4ffe-9b96-051e0a44ea71', 1, 3, NULL, 'blood_issue.donor_name', 'messages', 'Donor Name', 'active', NULL, NULL, '2025-06-21 00:42:37', '2025-06-21 00:42:37'),
(1595, '9f34afc0-c248-4a55-9d57-59930c0f13d6', 1, 3, NULL, 'blood_issue.amount', 'messages', 'Amount', 'active', NULL, NULL, '2025-06-21 00:42:37', '2025-06-21 00:42:37'),
(1596, '9f34afc0-c48c-46f6-b309-6cfe460b9d34', 1, 3, NULL, 'blood_issue.remarks', 'messages', 'Remarks', 'active', NULL, NULL, '2025-06-21 00:42:37', '2025-06-21 00:42:37'),
(1597, '9f34afc0-c6b7-4789-9d09-d35a3596b156', 1, 3, NULL, 'notification.notifications', 'messages', 'Notifications', 'active', NULL, NULL, '2025-06-21 00:42:37', '2025-06-21 00:42:37'),
(1598, '9f34afc0-c8e9-497f-aeb7-772712a9cc8a', 1, 3, NULL, 'notification.mark_all_as_read', 'messages', 'Mark All As Read', 'active', NULL, NULL, '2025-06-21 00:42:37', '2025-06-21 00:42:37'),
(1599, '9f34afc0-cb01-40cf-abfe-6111293a7781', 1, 3, NULL, 'notification.you_don`t_have_any_new_notification', 'messages', 'You don\'t have any new notification', 'active', NULL, NULL, '2025-06-21 00:42:37', '2025-06-21 00:42:37'),
(1600, '9f34afc0-cd24-4a26-90d1-941b48a827f1', 1, 3, NULL, 'live_consultation_filter.awaited', 'messages', 'Awaited', 'active', NULL, NULL, '2025-06-21 00:42:37', '2025-06-21 00:42:37'),
(1601, '9f34afc0-cf4b-4bc9-8919-0d46c521f73c', 1, 3, NULL, 'live_consultation_filter.cancelled', 'messages', 'Cancelled', 'active', NULL, NULL, '2025-06-21 00:42:37', '2025-06-21 00:42:37'),
(1602, '9f34afc0-d187-4262-84a2-72ea78683588', 1, 3, NULL, 'live_consultation_filter.finished', 'messages', 'Finished', 'active', NULL, NULL, '2025-06-21 00:42:37', '2025-06-21 00:42:37'),
(1603, '9f34afc0-d411-4f64-86ab-3d4bd34cedad', 1, 3, NULL, 'live_consultation.new_live_consultation', 'messages', 'New Live Consultation', 'active', NULL, NULL, '2025-06-21 00:42:37', '2025-06-21 00:42:37'),
(1604, '9f34afc0-d65f-4727-80e6-8baf9d70b953', 1, 3, NULL, 'live_consultation.consultation_title', 'messages', 'Consultation Title', 'active', NULL, NULL, '2025-06-21 00:42:37', '2025-06-21 00:42:37'),
(1605, '9f34afc0-d8bd-4907-b5c8-84df863a110e', 1, 3, NULL, 'live_consultation.consultation_date', 'messages', 'Consultation Date', 'active', NULL, NULL, '2025-06-21 00:42:37', '2025-06-21 00:42:37'),
(1606, '9f34afc0-db00-4a2c-938f-665d42e45ff0', 1, 3, NULL, 'live_consultation.consultation_duration_minutes', 'messages', 'Consultation Duration Minutes', 'active', NULL, NULL, '2025-06-21 00:42:37', '2025-06-21 00:42:37'),
(1607, '9f34afc0-dd62-46c0-88a5-096b845823b7', 1, 3, NULL, 'live_consultation.client_video', 'messages', 'Client Video', 'active', NULL, NULL, '2025-06-21 00:42:37', '2025-06-21 00:42:37'),
(1608, '9f34afc0-df97-49fe-9671-aff28e0836e9', 1, 3, NULL, 'live_consultation.host_video', 'messages', 'Host Video', 'active', NULL, NULL, '2025-06-21 00:42:37', '2025-06-21 00:42:37'),
(1609, '9f34afc0-e1b3-48f7-ba97-ef31fa2eda60', 1, 3, NULL, 'live_consultation.enable', 'messages', 'Enable', 'active', NULL, NULL, '2025-06-21 00:42:37', '2025-06-21 00:42:37'),
(1610, '9f34afc0-e3d7-4e2c-a00b-26a881ff8989', 1, 3, NULL, 'live_consultation.disabled', 'messages', 'Disabled', 'active', NULL, NULL, '2025-06-21 00:42:37', '2025-06-21 00:42:37'),
(1611, '9f34afc0-e600-4ce0-b6a7-440c00a86da8', 1, 3, NULL, 'live_consultation.type', 'messages', 'Type', 'active', NULL, NULL, '2025-06-21 00:42:37', '2025-06-21 00:42:37'),
(1612, '9f34afc0-e844-441b-bbe9-c2b16ee3fa71', 1, 3, NULL, 'live_consultation.type_number', 'messages', 'Type Number', 'active', NULL, NULL, '2025-06-21 00:42:37', '2025-06-21 00:42:37'),
(1613, '9f34afc0-ea81-4a09-8f8b-451142a7163d', 1, 3, NULL, 'live_consultation.created_by', 'messages', 'Created By', 'active', NULL, NULL, '2025-06-21 00:42:37', '2025-06-21 00:42:37'),
(1614, '9f34afc0-eccb-4b57-8b9a-d5e6329bb395', 1, 3, NULL, 'live_consultation.created_for', 'messages', 'Created For', 'active', NULL, NULL, '2025-06-21 00:42:37', '2025-06-21 00:42:37'),
(1615, '9f34afc0-eeff-4338-822d-6d8838c459f5', 1, 3, NULL, 'live_consultation.new_live_meeting', 'messages', 'New Live Meeting', 'active', NULL, NULL, '2025-06-21 00:42:37', '2025-06-21 00:42:37'),
(1616, '9f34afc0-f120-455e-be8e-37013c903444', 1, 3, NULL, 'live_consultation.staff_list', 'messages', 'Staff List', 'active', NULL, NULL, '2025-06-21 00:42:37', '2025-06-21 00:42:37'),
(1617, '9f34afc0-f350-4301-b232-ef48ae67317d', 1, 3, NULL, 'live_consultation.edit_live_consultation', 'messages', 'Edit Live Consultation', 'active', NULL, NULL, '2025-06-21 00:42:37', '2025-06-21 00:42:37'),
(1618, '9f34afc0-f588-4c64-a273-447c88e94181', 1, 3, NULL, 'live_consultation.duration', 'messages', 'Duration (in minutes)', 'active', NULL, NULL, '2025-06-21 00:42:37', '2025-06-21 00:42:37'),
(1619, '9f34afc0-f7bf-4569-bc80-f501185a3929', 1, 3, NULL, 'live_consultation.start_now', 'messages', 'Start Now', 'active', NULL, NULL, '2025-06-21 00:42:37', '2025-06-21 00:42:37'),
(1620, '9f34afc0-fa07-4e95-b0df-af11922695d0', 1, 3, NULL, 'live_consultation.join_now', 'messages', 'Join Now', 'active', NULL, NULL, '2025-06-21 00:42:37', '2025-06-21 00:42:37'),
(1621, '9f34afc0-fc45-454e-af4f-02f59789df91', 1, 3, NULL, 'live_consultation.edit_live_meeting', 'messages', 'Edit Live Meeting', 'active', NULL, NULL, '2025-06-21 00:42:37', '2025-06-21 00:42:37'),
(1622, '9f34afc0-fe73-4e60-b907-44240ea99ff6', 1, 3, NULL, 'live_consultation.add_credential', 'messages', 'Add Credential', 'active', NULL, NULL, '2025-06-21 00:42:37', '2025-06-21 00:42:37'),
(1623, '9f34afc1-00a7-45dc-bc8e-f2a0b54fd574', 1, 3, NULL, 'live_consultation.zoom_api_key', 'messages', 'Zoom Api Key', 'active', NULL, NULL, '2025-06-21 00:42:37', '2025-06-21 00:42:37'),
(1624, '9f34afc1-02c1-4556-8c34-c4173981479f', 1, 3, NULL, 'live_consultation.zoom_api_secret', 'messages', 'Zoom API Secret', 'active', NULL, NULL, '2025-06-21 00:42:37', '2025-06-21 00:42:37'),
(1625, '9f34afc1-050b-40ec-97e1-c3c4b2e8dc68', 1, 3, NULL, 'live_consultation.how_to_generate_Oauth_credentials', 'messages', 'How to generate OAuth credentials', 'active', NULL, NULL, '2025-06-21 00:42:37', '2025-06-21 00:42:37'),
(1626, '9f34afc1-0744-4130-bf24-6834d2d490d1', 1, 3, NULL, 'live_consultation.select_platform', 'messages', 'Select platform', 'active', NULL, NULL, '2025-06-21 00:42:37', '2025-06-21 00:42:37'),
(1627, '9f34afc1-09a4-4763-8061-5f45317fde10', 1, 3, NULL, 'vaccination.vaccinations', 'messages', 'Vaccinations', 'active', NULL, NULL, '2025-06-21 00:42:37', '2025-06-21 00:42:37'),
(1628, '9f34afc1-0be2-42e1-8f2b-31a58ba79930', 1, 3, NULL, 'vaccination.new_vaccination', 'messages', 'New Vaccination', 'active', NULL, NULL, '2025-06-21 00:42:37', '2025-06-21 00:42:37'),
(1629, '9f34afc1-0e13-4263-9f75-f77b24e0b4b6', 1, 3, NULL, 'vaccination.edit_vaccination', 'messages', 'Edit Vaccination', 'active', NULL, NULL, '2025-06-21 00:42:37', '2025-06-21 00:42:37'),
(1630, '9f34afc1-1039-45ac-8bda-39beb6f550ad', 1, 3, NULL, 'vaccination.select_vaccination', 'messages', 'Select Vaccination', 'active', NULL, NULL, '2025-06-21 00:42:37', '2025-06-21 00:42:37'),
(1631, '9f34afc1-1277-4891-a512-53ef78afe0e8', 1, 3, NULL, 'vaccination.name', 'messages', 'Name', 'active', NULL, NULL, '2025-06-21 00:42:37', '2025-06-21 00:42:37'),
(1632, '9f34afc1-14eb-4f91-8ed4-2c1c0f0c4c4c', 1, 3, NULL, 'vaccination.manufactured_by', 'messages', 'Manufactured By', 'active', NULL, NULL, '2025-06-21 00:42:37', '2025-06-21 00:42:37'),
(1633, '9f34afc1-173d-4c65-a1d7-418bc8359bf9', 1, 3, NULL, 'vaccination.brand', 'messages', 'Brand', 'active', NULL, NULL, '2025-06-21 00:42:37', '2025-06-21 00:42:37'),
(1634, '9f34afc1-1968-41ee-949e-8b5fdec77a99', 1, 3, NULL, 'vaccination.vaccinated', 'messages', 'Vaccinated', 'active', NULL, NULL, '2025-06-21 00:42:37', '2025-06-21 00:42:37'),
(1635, '9f34afc1-1b98-46b7-9084-e5e09a40b7e4', 1, 3, NULL, 'vaccinated_patient.patient', 'messages', 'Patient', 'active', NULL, NULL, '2025-06-21 00:42:37', '2025-06-21 00:42:37'),
(1636, '9f34afc1-1dbe-4b5d-94c0-d7ae1c59f7b5', 1, 3, NULL, 'vaccinated_patient.vaccination', 'messages', 'Vaccination', 'active', NULL, NULL, '2025-06-21 00:42:37', '2025-06-21 00:42:37'),
(1637, '9f34afc1-1fea-4da1-a30a-e334a3b258c8', 1, 3, NULL, 'vaccinated_patient.vaccination_name', 'messages', 'Vaccination Name', 'active', NULL, NULL, '2025-06-21 00:42:37', '2025-06-21 00:42:37'),
(1638, '9f34afc1-2213-487f-8b08-9a34466c19f5', 1, 3, NULL, 'vaccinated_patient.serial_no', 'messages', 'Serial No', 'active', NULL, NULL, '2025-06-21 00:42:37', '2025-06-21 00:42:37'),
(1639, '9f34afc1-2444-4518-b129-fd22f0312829', 1, 3, NULL, 'vaccinated_patient.does_no', 'messages', 'Dose No', 'active', NULL, NULL, '2025-06-21 00:42:37', '2025-06-21 00:42:37'),
(1640, '9f34afc1-26ba-44d0-91a8-63cd862d1589', 1, 3, NULL, 'vaccinated_patient.dose_given_date', 'messages', 'Dose Given Date', 'active', NULL, NULL, '2025-06-21 00:42:37', '2025-06-21 00:42:37'),
(1641, '9f34afc1-28fb-4a37-ae8c-7bfaf6abf236', 1, 3, NULL, 'vaccinated_patient.description', 'messages', 'Description', 'active', NULL, NULL, '2025-06-21 00:42:37', '2025-06-21 00:42:37'),
(1642, '9f34afc1-2b35-4e02-947e-3f5530fb4c97', 1, 3, NULL, 'vaccinated_patient.add_vaccinate_patient', 'messages', 'Add Vaccinated Patient', 'active', NULL, NULL, '2025-06-21 00:42:37', '2025-06-21 00:42:37'),
(1643, '9f34afc1-2d9e-4b37-95a2-51817197c490', 1, 3, NULL, 'vaccinated_patient.new_vaccinate_patient', 'messages', 'New Vaccinated Patient', 'active', NULL, NULL, '2025-06-21 00:42:37', '2025-06-21 00:42:37'),
(1644, '9f34afc1-2fe3-4863-a062-f55f9a2d6db2', 1, 3, NULL, 'vaccinated_patient.edit_vaccinate_patient', 'messages', 'Edit Vaccinated Patient', 'active', NULL, NULL, '2025-06-21 00:42:37', '2025-06-21 00:42:37'),
(1645, '9f34afc1-3339-42ba-b636-9e519797e243', 1, 3, NULL, 'vaccinated_patient.vaccine', 'messages', 'Vaccine', 'active', NULL, NULL, '2025-06-21 00:42:37', '2025-06-21 00:42:37'),
(1646, '9f34afc1-3592-4eb2-87be-2788028774e1', 1, 3, NULL, 'vaccinated_patient.vaccinate_patient', 'messages', 'Vaccinate Patient', 'active', NULL, NULL, '2025-06-21 00:42:37', '2025-06-21 00:42:37'),
(1647, '9f34afc1-37d3-4086-919a-70e5a573713d', 1, 3, NULL, 'front_setting.front_setting_details', 'messages', 'Front Setting Details', 'active', NULL, NULL, '2025-06-21 00:42:37', '2025-06-21 00:42:37'),
(1648, '9f34afc1-39ff-4f52-88ac-66f5ea74d5d0', 1, 3, NULL, 'front_setting.about_us_details', 'messages', 'About Us Details', 'active', NULL, NULL, '2025-06-21 00:42:37', '2025-06-21 00:42:37'),
(1649, '9f34afc1-3c51-4b39-8543-4be8f77c3ee7', 1, 3, NULL, 'front_setting.appointment_details', 'messages', 'Appointment Details', 'active', NULL, NULL, '2025-06-21 00:42:37', '2025-06-21 00:42:37'),
(1650, '9f34afc1-3e93-4331-a7b9-9ed9a3986a99', 1, 3, NULL, 'front_setting.terms_condition_details', 'messages', 'T&C Details', 'active', NULL, NULL, '2025-06-21 00:42:37', '2025-06-21 00:42:37'),
(1651, '9f34afc1-40d3-4864-a55b-41bd9670b6a3', 1, 3, NULL, 'front_setting.about_us_title', 'messages', 'Title', 'active', NULL, NULL, '2025-06-21 00:42:37', '2025-06-21 00:42:37'),
(1652, '9f34afc1-4313-43ae-960f-713308423af3', 1, 3, NULL, 'front_setting.about_us_mission', 'messages', 'Mission', 'active', NULL, NULL, '2025-06-21 00:42:37', '2025-06-21 00:42:37'),
(1653, '9f34afc1-456d-4d1c-8989-18266367bfa0', 1, 3, NULL, 'front_setting.about_us_image', 'messages', 'Image', 'active', NULL, NULL, '2025-06-21 00:42:37', '2025-06-21 00:42:37'),
(1654, '9f34afc1-47ca-43e6-9321-e8f4ecaf72af', 1, 3, NULL, 'front_setting.about_us_description', 'messages', 'Description', 'active', NULL, NULL, '2025-06-21 00:42:37', '2025-06-21 00:42:37'),
(1655, '9f34afc1-4a2e-4cf7-beaf-507659cc680e', 1, 3, NULL, 'front_setting.home_page_image', 'messages', 'Home Page Image', 'active', NULL, NULL, '2025-06-21 00:42:37', '2025-06-21 00:42:37'),
(1656, '9f34afc1-4c78-4a00-bfb8-a15ee81786b9', 1, 3, NULL, 'front_setting.home_page_title', 'messages', 'Home Page Title', 'active', NULL, NULL, '2025-06-21 00:42:37', '2025-06-21 00:42:37'),
(1657, '9f34afc1-4ed7-4ce1-ba47-c58942ed59e6', 1, 3, NULL, 'front_setting.home_page_description', 'messages', 'Home Page Description', 'active', NULL, NULL, '2025-06-21 00:42:37', '2025-06-21 00:42:37'),
(1658, '9f34afc1-5103-435b-be29-e2c6f06b82e4', 1, 3, NULL, 'front_setting.home_page_box_title', 'messages', 'Home Page Box Title', 'active', NULL, NULL, '2025-06-21 00:42:37', '2025-06-21 00:42:37'),
(1659, '9f34afc1-5337-4900-a027-fcf45253d0cf', 1, 3, NULL, 'front_setting.home_page_box_description', 'messages', 'Home Page Box Description', 'active', NULL, NULL, '2025-06-21 00:42:37', '2025-06-21 00:42:37'),
(1660, '9f34afc1-55a9-4b1b-8bd4-89fa9382fb02', 1, 3, NULL, 'front_setting.home_page_experience', 'messages', 'Home Page Experience', 'active', NULL, NULL, '2025-06-21 00:42:37', '2025-06-21 00:42:37'),
(1661, '9f34afc1-5805-44e4-8628-a203f003e414', 1, 3, NULL, 'front_setting.home_page_step_1_title', 'messages', 'Home Page Step 1 Title', 'active', NULL, NULL, '2025-06-21 00:42:37', '2025-06-21 00:42:37'),
(1662, '9f34afc1-5a56-49c4-86a3-b88d1a37f2d7', 1, 3, NULL, 'front_setting.home_page_step_1_description', 'messages', 'Home Page Step 1 Description', 'active', NULL, NULL, '2025-06-21 00:42:38', '2025-06-21 00:42:38');
INSERT INTO `ltu_phrases` (`id`, `uuid`, `translation_id`, `translation_file_id`, `phrase_id`, `key`, `group`, `value`, `status`, `parameters`, `note`, `created_at`, `updated_at`) VALUES
(1663, '9f34afc1-5cb2-413c-8dc2-e5ad650164a3', 1, 3, NULL, 'front_setting.home_page_step_2_title', 'messages', 'Home Page Step 2 Title', 'active', NULL, NULL, '2025-06-21 00:42:38', '2025-06-21 00:42:38'),
(1664, '9f34afc1-5eee-4e49-ba9b-65f0715babee', 1, 3, NULL, 'front_setting.home_page_step_2_description', 'messages', 'Home Page Step 2 Description', 'active', NULL, NULL, '2025-06-21 00:42:38', '2025-06-21 00:42:38'),
(1665, '9f34afc1-614a-48a9-86e6-4b579396f977', 1, 3, NULL, 'front_setting.home_page_step_3_title', 'messages', 'Home Page Step 3 Title', 'active', NULL, NULL, '2025-06-21 00:42:38', '2025-06-21 00:42:38'),
(1666, '9f34afc1-6397-4e6b-8c77-b8c8a81e3389', 1, 3, NULL, 'front_setting.home_page_step_3_description', 'messages', 'Home Page Step 3 Description', 'active', NULL, NULL, '2025-06-21 00:42:38', '2025-06-21 00:42:38'),
(1667, '9f34afc1-65e2-4abd-bfa0-9f0917288e68', 1, 3, NULL, 'front_setting.home_page_step_4_title', 'messages', 'Home Page Step 4 Title', 'active', NULL, NULL, '2025-06-21 00:42:38', '2025-06-21 00:42:38'),
(1668, '9f34afc1-682e-46a5-ae8d-8b6f4580d801', 1, 3, NULL, 'front_setting.home_page_step_4_description', 'messages', 'Home Page Step 4 Description', 'active', NULL, NULL, '2025-06-21 00:42:38', '2025-06-21 00:42:38'),
(1669, '9f34afc1-6a68-4e23-be91-c5de6f768b03', 1, 3, NULL, 'front_setting.terms_conditions', 'messages', 'Terms & Conditions', 'active', NULL, NULL, '2025-06-21 00:42:38', '2025-06-21 00:42:38'),
(1670, '9f34afc1-6cc0-499a-9668-ed9439951b9d', 1, 3, NULL, 'front_setting.privacy_policy', 'messages', 'Privacy Policy', 'active', NULL, NULL, '2025-06-21 00:42:38', '2025-06-21 00:42:38'),
(1671, '9f34afc1-6efb-4530-b787-2d5286212c1a', 1, 3, NULL, 'front_setting.home_page_certified_doctor_image', 'messages', 'Home Page Certified Doctor Image', 'active', NULL, NULL, '2025-06-21 00:42:38', '2025-06-21 00:42:38'),
(1672, '9f34afc1-7140-4a6c-8822-194af51b4832', 1, 3, NULL, 'front_setting.home_page_certified_doctor_text', 'messages', 'Home Page Certified Doctor Text', 'active', NULL, NULL, '2025-06-21 00:42:38', '2025-06-21 00:42:38'),
(1673, '9f34afc1-738f-4977-809b-a9b7fc990f03', 1, 3, NULL, 'front_setting.home_page_certified_doctor_title', 'messages', 'Home Page Certified Doctor Title', 'active', NULL, NULL, '2025-06-21 00:42:38', '2025-06-21 00:42:38'),
(1674, '9f34afc1-75f1-4b47-a6e9-87ea40727140', 1, 3, NULL, 'front_setting.home_page_certified_doctor_description', 'messages', 'Home Page Certified Doctor Description', 'active', NULL, NULL, '2025-06-21 00:42:38', '2025-06-21 00:42:38'),
(1675, '9f34afc1-784d-4936-8796-8e622e879cee', 1, 3, NULL, 'front_setting.home_page_certified_box_title', 'messages', 'Home Page Certified Box Title', 'active', NULL, NULL, '2025-06-21 00:42:38', '2025-06-21 00:42:38'),
(1676, '9f34afc1-7a8f-4571-80fc-34496010943f', 1, 3, NULL, 'front_setting.home_page_certified_box_description', 'messages', 'Home Page Certified Box Description', 'active', NULL, NULL, '2025-06-21 00:42:38', '2025-06-21 00:42:38'),
(1677, '9f34afc1-7ccf-41a5-8e40-eb99c8a22f85', 1, 3, NULL, 'change_password.change_password', 'messages', 'Change Password', 'active', NULL, NULL, '2025-06-21 00:42:38', '2025-06-21 00:42:38'),
(1678, '9f34afc1-7f3b-4dad-879a-011a75d41d87', 1, 3, NULL, 'change_password.current_password', 'messages', 'Current Password', 'active', NULL, NULL, '2025-06-21 00:42:38', '2025-06-21 00:42:38'),
(1679, '9f34afc1-818b-42dd-b7ca-65dfd5050558', 1, 3, NULL, 'change_password.new_password', 'messages', 'New Password', 'active', NULL, NULL, '2025-06-21 00:42:38', '2025-06-21 00:42:38'),
(1680, '9f34afc1-83c9-4a40-bdb7-be3c464b93f6', 1, 3, NULL, 'change_password.confirm_password', 'messages', 'Confirm Password', 'active', NULL, NULL, '2025-06-21 00:42:38', '2025-06-21 00:42:38'),
(1681, '9f34afc1-8607-421a-a79f-109acf6ebc9e', 1, 3, NULL, 'change_password.enter_your_current_password', 'messages', 'Enter your current password', 'active', NULL, NULL, '2025-06-21 00:42:38', '2025-06-21 00:42:38'),
(1682, '9f34afc1-8870-4111-a732-792a4d5df4bc', 1, 3, NULL, 'change_password.enter_a_new_password', 'messages', 'Enter a new password', 'active', NULL, NULL, '2025-06-21 00:42:38', '2025-06-21 00:42:38'),
(1683, '9f34afc1-8abb-4dee-b9b1-3bad13435e70', 1, 3, NULL, 'change_password.confirm_your_new_password', 'messages', 'Confirm your new password', 'active', NULL, NULL, '2025-06-21 00:42:38', '2025-06-21 00:42:38'),
(1684, '9f34afc1-8d0c-4500-a536-297ce267d140', 1, 3, NULL, 'front_services.new_service', 'messages', 'New Service', 'active', NULL, NULL, '2025-06-21 00:42:38', '2025-06-21 00:42:38'),
(1685, '9f34afc1-8f5b-4536-ba50-40ab37128208', 1, 3, NULL, 'front_services.edit_service', 'messages', 'Edit Service', 'active', NULL, NULL, '2025-06-21 00:42:38', '2025-06-21 00:42:38'),
(1686, '9f34afc1-91a2-45fe-a565-a451ca4075c8', 1, 3, NULL, 'web_home.home', 'messages', 'Home', 'active', NULL, NULL, '2025-06-21 00:42:38', '2025-06-21 00:42:38'),
(1687, '9f34afc1-93c9-4d01-8e69-7ab178462afe', 1, 3, NULL, 'web_home.services', 'messages', 'Services', 'active', NULL, NULL, '2025-06-21 00:42:38', '2025-06-21 00:42:38'),
(1688, '9f34afc1-962e-4d39-9b68-28fdaf7c7510', 1, 3, NULL, 'web_home.doctors', 'messages', 'Doctors', 'active', NULL, NULL, '2025-06-21 00:42:38', '2025-06-21 00:42:38'),
(1689, '9f34afc1-987c-4241-9141-8f7a7a801ea8', 1, 3, NULL, 'web_home.about_us', 'messages', 'About Us', 'active', NULL, NULL, '2025-06-21 00:42:38', '2025-06-21 00:42:38'),
(1690, '9f34afc1-9ac7-4a44-8473-2d6a99454d7a', 1, 3, NULL, 'web_home.contact', 'messages', 'Contact', 'active', NULL, NULL, '2025-06-21 00:42:38', '2025-06-21 00:42:38'),
(1691, '9f34afc1-9cfe-4774-a550-db3201fbba7b', 1, 3, NULL, 'web_home.make_appointment', 'messages', 'Make Appointment', 'active', NULL, NULL, '2025-06-21 00:42:38', '2025-06-21 00:42:38'),
(1692, '9f34afc1-9f9a-411e-ba9a-376e78d91f80', 1, 3, NULL, 'web_home.working_hours', 'messages', 'Working Hours', 'active', NULL, NULL, '2025-06-21 00:42:38', '2025-06-21 00:42:38'),
(1693, '9f34afc1-a1f7-49d6-9396-58807545f1bf', 1, 3, NULL, 'web_home.testimonials', 'messages', 'Testimonials', 'active', NULL, NULL, '2025-06-21 00:42:38', '2025-06-21 00:42:38'),
(1694, '9f34afc1-a42d-4818-b6b1-8403f161378d', 1, 3, NULL, 'web_home.terms_of_service', 'messages', 'Terms of Service', 'active', NULL, NULL, '2025-06-21 00:42:38', '2025-06-21 00:42:38'),
(1695, '9f34afc1-a67a-497c-81f4-976b500a15e8', 1, 3, NULL, 'web_home.privacy_policy', 'messages', 'Privacy Policy', 'active', NULL, NULL, '2025-06-21 00:42:38', '2025-06-21 00:42:38'),
(1696, '9f34afc1-a8df-40ae-bc98-32ff856d403c', 1, 3, NULL, 'web_home.patients', 'messages', 'Patients', 'active', NULL, NULL, '2025-06-21 00:42:38', '2025-06-21 00:42:38'),
(1697, '9f34afc1-ab29-43e9-8f90-54787563de10', 1, 3, NULL, 'web_home.years_experience', 'messages', 'Years Experience', 'active', NULL, NULL, '2025-06-21 00:42:38', '2025-06-21 00:42:38'),
(1698, '9f34afc1-ad7b-41e3-8ef7-c35a2e6946e5', 1, 3, NULL, 'web_home.sign_up', 'messages', 'Sign Up', 'active', NULL, NULL, '2025-06-21 00:42:38', '2025-06-21 00:42:38'),
(1699, '9f34afc1-afcd-4472-b774-be6e04e5046e', 1, 3, NULL, 'web_home.available_doctors', 'messages', 'Available Doctors', 'active', NULL, NULL, '2025-06-21 00:42:38', '2025-06-21 00:42:38'),
(1700, '9f34afc1-b215-4007-95b0-d5b37e8f3496', 1, 3, NULL, 'web_home.select_doctors', 'messages', 'Select Doctors', 'active', NULL, NULL, '2025-06-21 00:42:38', '2025-06-21 00:42:38'),
(1701, '9f34afc1-b454-4721-95a4-05d411cbe164', 1, 3, NULL, 'web_home.contact_doctors', 'messages', 'Contact Doctor', 'active', NULL, NULL, '2025-06-21 00:42:38', '2025-06-21 00:42:38'),
(1702, '9f34afc1-b6b7-4140-885f-053590933b82', 1, 3, NULL, 'web_home.contact_hospital', 'messages', 'Contact Hospital', 'active', NULL, NULL, '2025-06-21 00:42:38', '2025-06-21 00:42:38'),
(1703, '9f34afc1-b915-4b64-9da2-ac6d26e79edf', 1, 3, NULL, 'web_home.easy_solutions', 'messages', 'Easy Solutions', 'active', NULL, NULL, '2025-06-21 00:42:38', '2025-06-21 00:42:38'),
(1704, '9f34afc1-bb58-4019-9d9d-4484eb1a5093', 1, 3, NULL, 'web_home.4_easy_step_and_get_the_world_best_treatment', 'messages', '4 Easy Step and Get the World Best Treatment', 'active', NULL, NULL, '2025-06-21 00:42:38', '2025-06-21 00:42:38'),
(1705, '9f34afc1-bd98-4739-bd13-a833fc371b8d', 1, 3, NULL, 'web_home.book_an_appointment', 'messages', 'Book an Appointment', 'active', NULL, NULL, '2025-06-21 00:42:38', '2025-06-21 00:42:38'),
(1706, '9f34afc1-bfdd-4c54-b65e-9953c390ffef', 1, 3, NULL, 'web_home.select_doctor', 'messages', 'Select Doctor', 'active', NULL, NULL, '2025-06-21 00:42:38', '2025-06-21 00:42:38'),
(1707, '9f34afc1-c226-40f3-bc84-31f9329837fe', 1, 3, NULL, 'web_home.book_now', 'messages', 'Book Now', 'active', NULL, NULL, '2025-06-21 00:42:38', '2025-06-21 00:42:38'),
(1708, '9f34afc1-c471-496b-955e-217fb1b0b719', 1, 3, NULL, 'web_home.patients_beds', 'messages', 'Patients Beds', 'active', NULL, NULL, '2025-06-21 00:42:38', '2025-06-21 00:42:38'),
(1709, '9f34afc1-c6ab-4dcd-b2e3-53a43ca803da', 1, 3, NULL, 'web_home.doctors_nurses', 'messages', 'Doctors & Nurses', 'active', NULL, NULL, '2025-06-21 00:42:38', '2025-06-21 00:42:38'),
(1710, '9f34afc1-c930-4377-816f-648adbcd4c29', 1, 3, NULL, 'web_home.happy_patients', 'messages', 'Happy Patients', 'active', NULL, NULL, '2025-06-21 00:42:38', '2025-06-21 00:42:38'),
(1711, '9f34afc1-cb99-46a5-add2-baee32c39919', 1, 3, NULL, 'web_home.book_appointment', 'messages', 'Book Appointment', 'active', NULL, NULL, '2025-06-21 00:42:38', '2025-06-21 00:42:38'),
(1712, '9f34afc1-cded-4a18-b2df-0b0d1b3739de', 1, 3, NULL, 'web_home.our_services', 'messages', 'Our Services', 'active', NULL, NULL, '2025-06-21 00:42:38', '2025-06-21 00:42:38'),
(1713, '9f34afc1-d091-47ad-90bf-43dd6d7719a8', 1, 3, NULL, 'web_home.we_offer_different_services_to_improve_your_health', 'messages', 'We Offer Different Services To Improve Your Health', 'active', NULL, NULL, '2025-06-21 00:42:38', '2025-06-21 00:42:38'),
(1714, '9f34afc1-d2d4-46a4-9009-1456f0e74ace', 1, 3, NULL, 'web_home.professional_doctors', 'messages', 'Professional Doctors', 'active', NULL, NULL, '2025-06-21 00:42:38', '2025-06-21 00:42:38'),
(1715, '9f34afc1-d53f-4ac7-abb5-38fbd0560a63', 1, 3, NULL, 'web_home.we_are_experienced_healthcare_professionals', 'messages', 'We are Experienced Healthcare Professionals', 'active', NULL, NULL, '2025-06-21 00:42:38', '2025-06-21 00:42:38'),
(1716, '9f34afc1-d792-430e-928d-1639566325a9', 1, 3, NULL, 'web_home.our_testimonials', 'messages', 'Our Testimonials', 'active', NULL, NULL, '2025-06-21 00:42:38', '2025-06-21 00:42:38'),
(1717, '9f34afc1-da0c-4f5f-b357-53e4a40c532a', 1, 3, NULL, 'web_home.what_our_patient_say_about_medical_treatments', 'messages', 'What Our Patients Say About Our Medical Treatments', 'active', NULL, NULL, '2025-06-21 00:42:38', '2025-06-21 00:42:38'),
(1718, '9f34afc1-dc85-49ee-9b36-44714a50ba49', 1, 3, NULL, 'web_contact.call_today', 'messages', 'Call Today', 'active', NULL, NULL, '2025-06-21 00:42:38', '2025-06-21 00:42:38'),
(1719, '9f34afc1-defb-4121-8855-1c24cf289340', 1, 3, NULL, 'web_contact.open_hours', 'messages', 'Open Hours', 'active', NULL, NULL, '2025-06-21 00:42:38', '2025-06-21 00:42:38'),
(1720, '9f34afc1-e150-4b8d-92a8-57115c895285', 1, 3, NULL, 'web_contact.our_location', 'messages', 'Our Location', 'active', NULL, NULL, '2025-06-21 00:42:38', '2025-06-21 00:42:38'),
(1721, '9f34afc1-e3af-4926-9f89-0060f2892cd0', 1, 3, NULL, 'web_contact.send_us_a_message', 'messages', 'Send Us a Message', 'active', NULL, NULL, '2025-06-21 00:42:38', '2025-06-21 00:42:38'),
(1722, '9f34afc1-e5f8-41ca-9b63-823232bc9f41', 1, 3, NULL, 'web_contact.your_name', 'messages', 'Your Name', 'active', NULL, NULL, '2025-06-21 00:42:38', '2025-06-21 00:42:38'),
(1723, '9f34afc1-e832-45d3-a711-71b5b06fb841', 1, 3, NULL, 'web_contact.your_email', 'messages', 'Your Email', 'active', NULL, NULL, '2025-06-21 00:42:38', '2025-06-21 00:42:38'),
(1724, '9f34afc1-ea88-4cf2-a7f2-5ea6c2cdef04', 1, 3, NULL, 'web_contact.phone_number', 'messages', 'Phone Number', 'active', NULL, NULL, '2025-06-21 00:42:38', '2025-06-21 00:42:38'),
(1725, '9f34afc1-ee17-4243-aa32-442c15dadd0a', 1, 3, NULL, 'web_contact.select_enquiry', 'messages', 'Select Enquiry', 'active', NULL, NULL, '2025-06-21 00:42:38', '2025-06-21 00:42:38'),
(1726, '9f34afc1-f0a2-4fd4-8f75-a0abe1e13e6a', 1, 3, NULL, 'web_contact.your_message', 'messages', 'Your Message', 'active', NULL, NULL, '2025-06-21 00:42:38', '2025-06-21 00:42:38'),
(1727, '9f34afc1-f312-47c0-93af-3e4fe7a5e320', 1, 3, NULL, 'web_contact.send_message', 'messages', 'Send Message', 'active', NULL, NULL, '2025-06-21 00:42:38', '2025-06-21 00:42:38'),
(1728, '9f34afc1-f694-48a9-aeed-c97a7bd9a137', 1, 3, NULL, 'web_contact.enter_your_name', 'messages', 'Enter your name', 'active', NULL, NULL, '2025-06-21 00:42:38', '2025-06-21 00:42:38'),
(1729, '9f34afc1-f917-4de9-a454-f118c1e1ef91', 1, 3, NULL, 'web_contact.enter_your_email', 'messages', 'Enter your email', 'active', NULL, NULL, '2025-06-21 00:42:38', '2025-06-21 00:42:38'),
(1730, '9f34afc1-fb5b-42ef-a92d-fbb367930ac3', 1, 3, NULL, 'web_contact.contact_no', 'messages', 'Contact No', 'active', NULL, NULL, '2025-06-21 00:42:38', '2025-06-21 00:42:38'),
(1731, '9f34afc1-fdce-4b1b-b19c-1841b7fbdd68', 1, 3, NULL, 'web_contact.please_enter_your_phone_number', 'messages', 'Please enter your phone number', 'active', NULL, NULL, '2025-06-21 00:42:38', '2025-06-21 00:42:38'),
(1732, '9f34afc2-001f-4158-8d8e-608b020c4398', 1, 3, NULL, 'web_contact.enter_your_phone_number', 'messages', 'Enter your phone number', 'active', NULL, NULL, '2025-06-21 00:42:38', '2025-06-21 00:42:38'),
(1733, '9f34afc2-028a-4d7a-aee6-ee427380abef', 1, 3, NULL, 'web_contact.write_your_message', 'messages', 'Write your message', 'active', NULL, NULL, '2025-06-21 00:42:38', '2025-06-21 00:42:38'),
(1734, '9f34afc2-04e4-4a50-b861-f63f9b43947a', 1, 3, NULL, 'web_contact.type_your_message', 'messages', 'Type your message', 'active', NULL, NULL, '2025-06-21 00:42:38', '2025-06-21 00:42:38'),
(1735, '9f34afc2-0732-43e0-bf85-5343204ab5d9', 1, 3, NULL, 'web_contact.get_in_touch', 'messages', 'Get in touch and let us know how we can help. Fill out the form and we’ll be in touch as soon as possible.', 'active', NULL, NULL, '2025-06-21 00:42:38', '2025-06-21 00:42:38'),
(1736, '9f34afc2-09a7-415a-a45c-ec30f3d505c1', 1, 3, NULL, 'web_menu.about', 'messages', 'About', 'active', NULL, NULL, '2025-06-21 00:42:38', '2025-06-21 00:42:38'),
(1737, '9f34afc2-0c02-4da1-bcf1-34e757cc4dfe', 1, 3, NULL, 'web_menu.our_features', 'messages', 'Our Features', 'active', NULL, NULL, '2025-06-21 00:42:38', '2025-06-21 00:42:38'),
(1738, '9f34afc2-0e51-4164-b32f-283e74f7b17a', 1, 3, NULL, 'web_menu.appointment', 'messages', 'Appointment', 'active', NULL, NULL, '2025-06-21 00:42:38', '2025-06-21 00:42:38'),
(1739, '9f34afc2-109f-45de-89d0-815652f92e8b', 1, 3, NULL, 'web_menu.working_hours', 'messages', 'Working Hours', 'active', NULL, NULL, '2025-06-21 00:42:38', '2025-06-21 00:42:38'),
(1740, '9f34afc2-131f-4a7d-b9f0-f3223946122f', 1, 3, NULL, 'web_menu.login', 'messages', 'Login', 'active', NULL, NULL, '2025-06-21 00:42:38', '2025-06-21 00:42:38'),
(1741, '9f34afc2-155f-4c6f-9957-dd9462c62ad7', 1, 3, NULL, 'web_menu.useful_link', 'messages', 'Useful Link', 'active', NULL, NULL, '2025-06-21 00:42:38', '2025-06-21 00:42:38'),
(1742, '9f34afc2-17aa-46d4-907e-0295a1f90013', 1, 3, NULL, 'web_menu.contact_information', 'messages', 'Contact Information', 'active', NULL, NULL, '2025-06-21 00:42:38', '2025-06-21 00:42:38'),
(1743, '9f34afc2-1a32-46d9-841c-9c71d0f8d2f8', 1, 3, NULL, 'web_menu.copyright', 'messages', 'Copyright', 'active', NULL, NULL, '2025-06-21 00:42:38', '2025-06-21 00:42:38'),
(1744, '9f34afc2-1c86-4b8f-919e-fe7dce555583', 1, 3, NULL, 'web_menu.all_rights_reserved_by', 'messages', 'All Rights Reserved by', 'active', NULL, NULL, '2025-06-21 00:42:38', '2025-06-21 00:42:38'),
(1745, '9f34afc2-1f03-4d2b-897a-16c88f7e1c8b', 1, 3, NULL, 'web_menu.all_rights_reserved', 'messages', 'All Rights Reserved', 'active', NULL, NULL, '2025-06-21 00:42:38', '2025-06-21 00:42:38'),
(1746, '9f34afc2-2161-4019-a509-886548770951', 1, 3, NULL, 'web_appointment.make_an_appointment', 'messages', 'Make an Appointment', 'active', NULL, NULL, '2025-06-21 00:42:38', '2025-06-21 00:42:38'),
(1747, '9f34afc2-23b7-405e-8f71-63489749b625', 1, 3, NULL, 'web_appointment.call_now_and_get_a_free_consulting', 'messages', 'Call Now and Get a Free Consulting', 'active', NULL, NULL, '2025-06-21 00:42:38', '2025-06-21 00:42:38'),
(1748, '9f34afc2-2610-4d78-a2c5-91da49f687bc', 1, 3, NULL, 'web_appointment.enter_your_first_name', 'messages', 'Enter your First Name', 'active', NULL, NULL, '2025-06-21 00:42:38', '2025-06-21 00:42:38'),
(1749, '9f34afc2-2869-4ee0-a889-2ef2252afad0', 1, 3, NULL, 'web_appointment.enter_your_last_name', 'messages', 'Enter your Last Name', 'active', NULL, NULL, '2025-06-21 00:42:38', '2025-06-21 00:42:38'),
(1750, '9f34afc2-2aaf-4c2d-9cc3-e2d3efdd52a9', 1, 3, NULL, 'web_appointment.enter_your_password', 'messages', 'Enter your Password', 'active', NULL, NULL, '2025-06-21 00:42:38', '2025-06-21 00:42:38'),
(1751, '9f34afc2-2d1b-424b-9c78-925beab6f2de', 1, 3, NULL, 'web_appointment.enter_confirm_password', 'messages', 'Enter Confirm Password', 'active', NULL, NULL, '2025-06-21 00:42:38', '2025-06-21 00:42:38'),
(1752, '9f34afc2-2f77-4afe-b429-685de0d8d83d', 1, 3, NULL, 'web_appointment.select_department', 'messages', 'Select Department', 'active', NULL, NULL, '2025-06-21 00:42:38', '2025-06-21 00:42:38'),
(1753, '9f34afc2-31f4-4fdb-97e2-53b2ce0f8b4b', 1, 3, NULL, 'web_appointment.select_doctor', 'messages', 'Select Doctor', 'active', NULL, NULL, '2025-06-21 00:42:38', '2025-06-21 00:42:38'),
(1754, '9f34afc2-345d-4bcd-a080-bafacabf9db7', 1, 3, NULL, 'web_appointment.enter_description', 'messages', 'Enter Description', 'active', NULL, NULL, '2025-06-21 00:42:38', '2025-06-21 00:42:38'),
(1755, '9f34afc2-36cf-4247-919f-7dbea6864207', 1, 3, NULL, 'web_appointment.select_time', 'messages', 'Select Time', 'active', NULL, NULL, '2025-06-21 00:42:38', '2025-06-21 00:42:38'),
(1756, '9f34afc2-3938-4b7b-994a-662f596ec261', 1, 3, NULL, 'web_appointment.select_date', 'messages', 'Select Date', 'active', NULL, NULL, '2025-06-21 00:42:38', '2025-06-21 00:42:38'),
(1757, '9f34afc2-3b93-4913-be44-604648c2dc49', 1, 3, NULL, 'web_working_hours.opening_hours', 'messages', 'Opening Hours', 'active', NULL, NULL, '2025-06-21 00:42:38', '2025-06-21 00:42:38'),
(1758, '9f34afc2-3de6-447c-90b1-075d953a61aa', 1, 3, NULL, 'web_working_hours.no_yet_opening_hours', 'messages', 'No yet Opening Hours', 'active', NULL, NULL, '2025-06-21 00:42:38', '2025-06-21 00:42:38'),
(1759, '9f34afc2-4034-4c2e-9e27-83fbafc3f577', 1, 3, NULL, 'subscription_plans.select_plan_type', 'messages', 'Select Plan Type', 'active', NULL, NULL, '2025-06-21 00:42:38', '2025-06-21 00:42:38'),
(1760, '9f34afc2-42a1-45c8-8d08-4d63fd05c8bf', 1, 3, NULL, 'subscription_plans.add_subscription_plan', 'messages', 'Add Subscription Plan', 'active', NULL, NULL, '2025-06-21 00:42:38', '2025-06-21 00:42:38'),
(1761, '9f34afc2-4505-48dc-bfe9-49de411d4f21', 1, 3, NULL, 'subscription_plans.name', 'messages', 'Name', 'active', NULL, NULL, '2025-06-21 00:42:38', '2025-06-21 00:42:38'),
(1762, '9f34afc2-4768-4726-93e8-b92f6e8df06e', 1, 3, NULL, 'subscription_plans.currency', 'messages', 'Currency', 'active', NULL, NULL, '2025-06-21 00:42:38', '2025-06-21 00:42:38'),
(1763, '9f34afc2-49cf-4c34-b852-3add75f5c1b9', 1, 3, NULL, 'subscription_plans.price', 'messages', 'Price', 'active', NULL, NULL, '2025-06-21 00:42:38', '2025-06-21 00:42:38'),
(1764, '9f34afc2-4c28-4ffd-b0d7-af322929c06d', 1, 3, NULL, 'subscription_plans.valid_until', 'messages', 'Trial Days', 'active', NULL, NULL, '2025-06-21 00:42:38', '2025-06-21 00:42:38'),
(1765, '9f34afc2-4e89-4f2b-af7b-e34e46175b3a', 1, 3, NULL, 'subscription_plans.edit_subscription_plan', 'messages', 'Edit Subscription Plan', 'active', NULL, NULL, '2025-06-21 00:42:38', '2025-06-21 00:42:38'),
(1766, '9f34afc2-50da-4ad1-ac91-f14ad57136cd', 1, 3, NULL, 'subscription_plans.plan_type', 'messages', 'Frequency', 'active', NULL, NULL, '2025-06-21 00:42:38', '2025-06-21 00:42:38'),
(1767, '9f34afc2-5331-40b9-8443-ce79bcc9b49e', 1, 3, NULL, 'subscription_plans.active_plan', 'messages', 'Active Plans', 'active', NULL, NULL, '2025-06-21 00:42:38', '2025-06-21 00:42:38'),
(1768, '9f34afc2-5594-47aa-87d0-c024f1c7b583', 1, 3, NULL, 'subscription_plans.valid_until_tooltip', 'messages', 'If you are entering 1 & plan type is year it will be considered as 1 year same for month.', 'active', NULL, NULL, '2025-06-21 00:42:38', '2025-06-21 00:42:38'),
(1769, '9f34afc2-580f-4fa2-b9cc-2b2d4a7d1966', 1, 3, NULL, 'subscription_plans.trail_plan', 'messages', 'Trial Days', 'active', NULL, NULL, '2025-06-21 00:42:38', '2025-06-21 00:42:38'),
(1770, '9f34afc2-5a88-401c-bdec-867f292a6b08', 1, 3, NULL, 'subscription_plans.trail_plan_text', 'messages', ' trial days will be available for this plan.', 'active', NULL, NULL, '2025-06-21 00:42:38', '2025-06-21 00:42:38'),
(1771, '9f34afc2-5ce3-4d59-9003-d5701443a640', 1, 3, NULL, 'subscription_plans.payment_type', 'messages', 'Choose Payment Type', 'active', NULL, NULL, '2025-06-21 00:42:38', '2025-06-21 00:42:38'),
(1772, '9f34afc2-5f46-4be0-a1b8-0eb79a459f39', 1, 3, NULL, 'subscription_plans.transactions', 'messages', 'Transactions', 'active', NULL, NULL, '2025-06-21 00:42:38', '2025-06-21 00:42:38'),
(1773, '9f34afc2-61b0-49c1-815c-095b176e1086', 1, 3, NULL, 'subscription_plans.transaction_details', 'messages', 'Transaction Detail', 'active', NULL, NULL, '2025-06-21 00:42:38', '2025-06-21 00:42:38'),
(1774, '9f34afc2-6413-40b4-b714-8f27132b1cf6', 1, 3, NULL, 'subscription_plans.plan_name', 'messages', 'Plan Name', 'active', NULL, NULL, '2025-06-21 00:42:38', '2025-06-21 00:42:38'),
(1775, '9f34afc2-6688-44fd-856c-3d9f0bc7f9fb', 1, 3, NULL, 'subscription_plans.transaction_date', 'messages', 'Transaction Date', 'active', NULL, NULL, '2025-06-21 00:42:38', '2025-06-21 00:42:38'),
(1776, '9f34afc2-68f8-43c9-b594-23afe84a00ca', 1, 3, NULL, 'subscription_plans.payment_method', 'messages', 'Payment Method', 'active', NULL, NULL, '2025-06-21 00:42:38', '2025-06-21 00:42:38'),
(1777, '9f34afc2-6b78-4461-8d2b-a891a26d08a7', 1, 3, NULL, 'subscription_plans.amount', 'messages', 'Amount', 'active', NULL, NULL, '2025-06-21 00:42:38', '2025-06-21 00:42:38'),
(1778, '9f34afc2-6dfc-4446-ae7a-c21f6cc23182', 1, 3, NULL, 'subscription_plans.free_plan', 'messages', 'Free Plan', 'active', NULL, NULL, '2025-06-21 00:42:38', '2025-06-21 00:42:38'),
(1779, '9f34afc2-7057-4fa9-bb42-7bce99adf636', 1, 3, NULL, 'subscription_plans.plan_features', 'messages', 'Plan Features', 'active', NULL, NULL, '2025-06-21 00:42:38', '2025-06-21 00:42:38'),
(1780, '9f34afc2-72bf-4897-9d87-6807b296290a', 1, 3, NULL, 'subscription_plans.select_all', 'messages', 'Select All', 'active', NULL, NULL, '2025-06-21 00:42:38', '2025-06-21 00:42:38'),
(1781, '9f34afc2-7515-48f0-9fb1-ba87b8f14aed', 1, 3, NULL, 'subscription_plans.default_plan_text_one', 'messages', 'This menu contains', 'active', NULL, NULL, '2025-06-21 00:42:38', '2025-06-21 00:42:38'),
(1782, '9f34afc2-7774-4815-bb9e-9d27ba856986', 1, 3, NULL, 'subscription_plans.default_plan_text_two', 'messages', 'sub menus.', 'active', NULL, NULL, '2025-06-21 00:42:38', '2025-06-21 00:42:38'),
(1783, '9f34afc2-79f7-4755-9591-511b97517552', 1, 3, NULL, 'subscription_plans.view_subscription_plan', 'messages', 'Subscription Plan Details', 'active', NULL, NULL, '2025-06-21 00:42:38', '2025-06-21 00:42:38'),
(1784, '9f34afc2-7c46-4f3b-aeec-3b446c232b11', 1, 3, NULL, 'subscription_plans.start_date', 'messages', 'Start Date', 'active', NULL, NULL, '2025-06-21 00:42:38', '2025-06-21 00:42:38'),
(1785, '9f34afc2-7eb2-496d-9636-d1f842d6f1db', 1, 3, NULL, 'subscription_plans.end_date', 'messages', 'Expires On', 'active', NULL, NULL, '2025-06-21 00:42:38', '2025-06-21 00:42:38'),
(1786, '9f34afc2-812c-4e21-b4ec-17ace45ae58e', 1, 3, NULL, 'subscription_plans.make_default', 'messages', 'Make Default', 'active', NULL, NULL, '2025-06-21 00:42:38', '2025-06-21 00:42:38'),
(1787, '9f34afc2-8391-4ae4-9335-8322b642e913', 1, 3, NULL, 'subscription_plans.default_plan', 'messages', 'Default Plan', 'active', NULL, NULL, '2025-06-21 00:42:38', '2025-06-21 00:42:38'),
(1788, '9f34afc2-85e2-413b-ab76-bcfe16d4a068', 1, 3, NULL, 'subscription_plans.subscription_plans', 'messages', 'Subscription Plans', 'active', NULL, NULL, '2025-06-21 00:42:38', '2025-06-21 00:42:38'),
(1789, '9f34afc2-8832-4e2c-a461-31af85201fc7', 1, 3, NULL, 'subscription_plans.remaining_balance', 'messages', 'Remaining Balance', 'active', NULL, NULL, '2025-06-21 00:42:38', '2025-06-21 00:42:38'),
(1790, '9f34afc2-8a9e-439b-bd43-f847edd8de89', 1, 3, NULL, 'subscription_plans.amount_to_pay', 'messages', 'Amount to Pay', 'active', NULL, NULL, '2025-06-21 00:42:38', '2025-06-21 00:42:38'),
(1791, '9f34afc2-8cf8-49c6-905e-b966c391278f', 1, 3, NULL, 'subscription_plans.used_days', 'messages', 'Used Days', 'active', NULL, NULL, '2025-06-21 00:42:38', '2025-06-21 00:42:38'),
(1792, '9f34afc2-8f4e-49b8-8431-69dae212ee61', 1, 3, NULL, 'subscription_plans.total_extra_days', 'messages', 'Total Extra Days', 'active', NULL, NULL, '2025-06-21 00:42:38', '2025-06-21 00:42:38'),
(1793, '9f34afc2-91e1-4616-8e60-f3d146bfc5d5', 1, 3, NULL, 'subscription_plans.pay_or_switch_plan', 'messages', 'Pay / Switch Plan', 'active', NULL, NULL, '2025-06-21 00:42:38', '2025-06-21 00:42:38'),
(1794, '9f34afc2-945f-412e-bf1b-5cb2998bc845', 1, 3, NULL, 'subscription_plans.transaction', 'messages', 'Transaction', 'active', NULL, NULL, '2025-06-21 00:42:38', '2025-06-21 00:42:38'),
(1795, '9f34afc2-96c3-44a7-b060-0124fd429867', 1, 3, NULL, 'subscription_plans.frequency', 'messages', 'Frequency', 'active', NULL, NULL, '2025-06-21 00:42:38', '2025-06-21 00:42:38'),
(1796, '9f34afc2-995b-4608-b570-4aed580d3bd4', 1, 3, NULL, 'subscription_plans.trail_end_date', 'messages', 'Trial End Date', 'active', NULL, NULL, '2025-06-21 00:42:38', '2025-06-21 00:42:38'),
(1797, '9f34afc2-9be0-4004-ac21-f3f5673a6201', 1, 3, NULL, 'subscription_plans.payment', 'messages', 'Payment', 'active', NULL, NULL, '2025-06-21 00:42:38', '2025-06-21 00:42:38'),
(1798, '9f34afc2-9e41-437c-8843-10a86ff071ff', 1, 3, NULL, 'subscription_plans.enter_plan_name', 'messages', 'Enter Plan Name', 'active', NULL, NULL, '2025-06-21 00:42:38', '2025-06-21 00:42:38'),
(1799, '9f34afc2-a0c9-442a-b4a7-5896005bc749', 1, 3, NULL, 'subscription_plans.select_currency', 'messages', 'Select Currency', 'active', NULL, NULL, '2025-06-21 00:42:38', '2025-06-21 00:42:38'),
(1800, '9f34afc2-a341-4938-a096-0c68d8795303', 1, 3, NULL, 'subscription_plans.enter_price', 'messages', 'Enter Price', 'active', NULL, NULL, '2025-06-21 00:42:38', '2025-06-21 00:42:38'),
(1801, '9f34afc2-a5ac-45e9-93d2-022f0c79351a', 1, 3, NULL, 'subscription_plans.enter_trial_day', 'messages', 'Enter Trial Days', 'active', NULL, NULL, '2025-06-21 00:42:38', '2025-06-21 00:42:38'),
(1802, '9f34afc2-a7ff-4c6a-a35a-12b0087f80f0', 1, 3, NULL, 'subscription_pricing_plans.subscription_pricing_plan', 'messages', 'Subscription Pricing Plan', 'active', NULL, NULL, '2025-06-21 00:42:38', '2025-06-21 00:42:38'),
(1803, '9f34afc2-aa87-4f10-b7f5-b9589ca604d9', 1, 3, NULL, 'subscription_pricing_plans.choose_plan', 'messages', 'Choose Plan', 'active', NULL, NULL, '2025-06-21 00:42:38', '2025-06-21 00:42:38'),
(1804, '9f34afc2-acf1-4d56-a132-52953b16d1fb', 1, 3, NULL, 'subscription_pricing_plans.week', 'messages', 'Week', 'active', NULL, NULL, '2025-06-21 00:42:38', '2025-06-21 00:42:38'),
(1805, '9f34afc2-af41-43ec-b6f3-894f421f8313', 1, 3, NULL, 'subscription_pricing_plans.month', 'messages', 'Month', 'active', NULL, NULL, '2025-06-21 00:42:38', '2025-06-21 00:42:38'),
(1806, '9f34afc2-b195-4cad-9a05-6a7887a3864e', 1, 3, NULL, 'subscription_pricing_plans.year', 'messages', 'Year', 'active', NULL, NULL, '2025-06-21 00:42:38', '2025-06-21 00:42:38'),
(1807, '9f34afc2-b3fc-47a2-8179-8d73a1f7e654', 1, 3, NULL, 'subscription_pricing_plans.has_been_subscribed', 'messages', 'has been subscribed', 'active', NULL, NULL, '2025-06-21 00:42:38', '2025-06-21 00:42:38'),
(1808, '9f34afc2-b64e-4ed3-989c-d8bd36e31f07', 1, 3, NULL, 'subscription_pricing_plans.has_already_been_subscribed', 'messages', 'is already subscribed', 'active', NULL, NULL, '2025-06-21 00:42:38', '2025-06-21 00:42:38'),
(1809, '9f34afc2-b8bc-4355-997f-1c794c211ac1', 1, 3, NULL, 'subscription_pricing_plans.currently_active', 'messages', 'Currently Active', 'active', NULL, NULL, '2025-06-21 00:42:38', '2025-06-21 00:42:38'),
(1810, '9f34afc2-bb37-49e3-bcb1-aa312a482b48', 1, 3, NULL, 'subscription_pricing_plans.renew_plan', 'messages', 'Renew Plan', 'active', NULL, NULL, '2025-06-21 00:42:38', '2025-06-21 00:42:38'),
(1811, '9f34afc2-becb-4792-bf55-3fc3babcad50', 1, 3, NULL, 'subscription_pricing_plans.no_pricing_plan_found', 'messages', 'We couldn\'t find any Subscription Plan\'s', 'active', NULL, NULL, '2025-06-21 00:42:38', '2025-06-21 00:42:38'),
(1812, '9f34afc2-c16d-4148-baa6-3c07725da708', 1, 3, NULL, 'subscription_pricing_plans.renew_free_plan', 'messages', 'Free Plan cannot be renewed/chosen again', 'active', NULL, NULL, '2025-06-21 00:42:38', '2025-06-21 00:42:38'),
(1813, '9f34afc2-c3f8-4bb6-9198-2379f8b80502', 1, 3, NULL, 'subscription_pricing_plans.proceed_to_payment', 'messages', 'Proceed to Payment', 'active', NULL, NULL, '2025-06-21 00:42:38', '2025-06-21 00:42:38'),
(1814, '9f34afc2-c65d-4d31-be3f-473915c7f881', 1, 3, NULL, 'subscription_pricing_plans.switch_plan', 'messages', 'Switch Plan', 'active', NULL, NULL, '2025-06-21 00:42:38', '2025-06-21 00:42:38'),
(1815, '9f34afc2-c8c9-4623-8305-0c8bd9ad987c', 1, 3, NULL, 'landing_cms.landing_cms', 'messages', 'Landing CMS', 'active', NULL, NULL, '2025-06-21 00:42:38', '2025-06-21 00:42:38'),
(1816, '9f34afc2-cb50-427f-854c-542add16ce3f', 1, 3, NULL, 'landing_cms.section_one', 'messages', 'Section One', 'active', NULL, NULL, '2025-06-21 00:42:38', '2025-06-21 00:42:38'),
(1817, '9f34afc2-cdb9-4863-9e6a-554d609e147d', 1, 3, NULL, 'landing_cms.text_main', 'messages', 'Text Main', 'active', NULL, NULL, '2025-06-21 00:42:38', '2025-06-21 00:42:38'),
(1818, '9f34afc2-d028-45d6-b47a-53da2439b3b8', 1, 3, NULL, 'landing_cms.text_secondary', 'messages', 'Text Secondary', 'active', NULL, NULL, '2025-06-21 00:42:38', '2025-06-21 00:42:38'),
(1819, '9f34afc2-d28e-45e9-8fd7-526f89e48e81', 1, 3, NULL, 'landing_cms.image', 'messages', 'Image', 'active', NULL, NULL, '2025-06-21 00:42:38', '2025-06-21 00:42:38'),
(1820, '9f34afc2-d4f7-4f3c-875b-738c03a35e63', 1, 3, NULL, 'landing_cms.section_two', 'messages', 'Section Two', 'active', NULL, NULL, '2025-06-21 00:42:38', '2025-06-21 00:42:38'),
(1821, '9f34afc2-d76f-44c8-9372-d05edb233fa2', 1, 3, NULL, 'landing_cms.card_one_image', 'messages', 'Card One Image', 'active', NULL, NULL, '2025-06-21 00:42:38', '2025-06-21 00:42:38'),
(1822, '9f34afc2-d9d4-4604-8337-16eb9df38758', 1, 3, NULL, 'landing_cms.card_one_text', 'messages', 'Card One Text', 'active', NULL, NULL, '2025-06-21 00:42:38', '2025-06-21 00:42:38'),
(1823, '9f34afc2-dc47-48db-aec0-edcc31ec4576', 1, 3, NULL, 'landing_cms.card_one_text_secondary', 'messages', 'Card One Text Secondary', 'active', NULL, NULL, '2025-06-21 00:42:38', '2025-06-21 00:42:38'),
(1824, '9f34afc2-ded4-4b29-9a42-13981ef5272f', 1, 3, NULL, 'landing_cms.card_two_image', 'messages', 'Card Two Image', 'active', NULL, NULL, '2025-06-21 00:42:38', '2025-06-21 00:42:38'),
(1825, '9f34afc2-e164-492e-b535-6c6314984814', 1, 3, NULL, 'landing_cms.card_two_text', 'messages', 'Card Two Text', 'active', NULL, NULL, '2025-06-21 00:42:39', '2025-06-21 00:42:39'),
(1826, '9f34afc2-e3ce-4059-b824-4ff64a5a424f', 1, 3, NULL, 'landing_cms.card_two_text_secondary', 'messages', 'Card Two Text Secondary', 'active', NULL, NULL, '2025-06-21 00:42:39', '2025-06-21 00:42:39'),
(1827, '9f34afc2-e615-49b6-acdd-404c6600131a', 1, 3, NULL, 'landing_cms.card_third_image', 'messages', 'Card Third Image', 'active', NULL, NULL, '2025-06-21 00:42:39', '2025-06-21 00:42:39'),
(1828, '9f34afc2-e891-4d7f-9eed-1f27d23fe12c', 1, 3, NULL, 'landing_cms.card_third_text', 'messages', 'Card Third Text', 'active', NULL, NULL, '2025-06-21 00:42:39', '2025-06-21 00:42:39'),
(1829, '9f34afc2-eb29-4ffc-bacf-dbd03040e714', 1, 3, NULL, 'landing_cms.card_third_text_secondary', 'messages', 'Card Third Text Secondary', 'active', NULL, NULL, '2025-06-21 00:42:39', '2025-06-21 00:42:39'),
(1830, '9f34afc2-eda4-4a57-845e-feca510f4df8', 1, 3, NULL, 'landing_cms.section_three', 'messages', 'Section Three', 'active', NULL, NULL, '2025-06-21 00:42:39', '2025-06-21 00:42:39'),
(1831, '9f34afc2-f01b-4eae-b993-e1def5d909b5', 1, 3, NULL, 'landing_cms.text_one', 'messages', 'Text One', 'active', NULL, NULL, '2025-06-21 00:42:39', '2025-06-21 00:42:39'),
(1832, '9f34afc2-f290-416a-8996-a8d8061c4af5', 1, 3, NULL, 'landing_cms.text_two', 'messages', 'Text Two', 'active', NULL, NULL, '2025-06-21 00:42:39', '2025-06-21 00:42:39'),
(1833, '9f34afc2-f4fa-4ca9-91ef-c6bc74cf45a2', 1, 3, NULL, 'landing_cms.text_three', 'messages', 'Text Three', 'active', NULL, NULL, '2025-06-21 00:42:39', '2025-06-21 00:42:39'),
(1834, '9f34afc2-f74c-49f0-8922-374d87658fc9', 1, 3, NULL, 'landing_cms.text_four', 'messages', 'Text Four', 'active', NULL, NULL, '2025-06-21 00:42:39', '2025-06-21 00:42:39'),
(1835, '9f34afc2-f9b5-48a9-b738-d7970ef57225', 1, 3, NULL, 'landing_cms.text_five', 'messages', 'Text Five', 'active', NULL, NULL, '2025-06-21 00:42:39', '2025-06-21 00:42:39'),
(1836, '9f34afc2-fc39-44a4-a2d2-a9dcb836ceba', 1, 3, NULL, 'landing_cms.section_four', 'messages', 'Section Four', 'active', NULL, NULL, '2025-06-21 00:42:39', '2025-06-21 00:42:39'),
(1837, '9f34afc2-feb1-425f-9949-bbe82143d817', 1, 3, NULL, 'landing_cms.card_three_image', 'messages', 'Card Three Image', 'active', NULL, NULL, '2025-06-21 00:42:39', '2025-06-21 00:42:39'),
(1838, '9f34afc3-0109-4666-aca8-0d9b5a931435', 1, 3, NULL, 'landing_cms.card_three_text', 'messages', 'Card Three Text', 'active', NULL, NULL, '2025-06-21 00:42:39', '2025-06-21 00:42:39'),
(1839, '9f34afc3-037c-48c0-8c36-a50848ba31be', 1, 3, NULL, 'landing_cms.card_three_text_secondary', 'messages', 'Card Three Text Secondary', 'active', NULL, NULL, '2025-06-21 00:42:39', '2025-06-21 00:42:39'),
(1840, '9f34afc3-05da-4aa8-a252-9d470a441cf3', 1, 3, NULL, 'landing_cms.card_four_image', 'messages', 'Card Four Image', 'active', NULL, NULL, '2025-06-21 00:42:39', '2025-06-21 00:42:39'),
(1841, '9f34afc3-0831-4173-87bc-4358dff1b6f8', 1, 3, NULL, 'landing_cms.card_four_text', 'messages', 'Card Four Text', 'active', NULL, NULL, '2025-06-21 00:42:39', '2025-06-21 00:42:39'),
(1842, '9f34afc3-0ab0-4b60-ba0e-a59eb7326a8f', 1, 3, NULL, 'landing_cms.card_four_text_secondary', 'messages', 'Card Four Text Secondary', 'active', NULL, NULL, '2025-06-21 00:42:39', '2025-06-21 00:42:39'),
(1843, '9f34afc3-0d1a-4b28-89c8-4acdb5ca343b', 1, 3, NULL, 'landing_cms.card_five_image', 'messages', 'Card Five Image', 'active', NULL, NULL, '2025-06-21 00:42:39', '2025-06-21 00:42:39'),
(1844, '9f34afc3-0f6b-492d-8be9-0301b58f7d01', 1, 3, NULL, 'landing_cms.card_five_text', 'messages', 'Card Five Text', 'active', NULL, NULL, '2025-06-21 00:42:39', '2025-06-21 00:42:39'),
(1845, '9f34afc3-11e2-4087-8ed7-27f895e2c438', 1, 3, NULL, 'landing_cms.card_five_text_secondary', 'messages', 'Card Five Text Secondary', 'active', NULL, NULL, '2025-06-21 00:42:39', '2025-06-21 00:42:39'),
(1846, '9f34afc3-1499-4e8d-853f-93f8e90fa2f6', 1, 3, NULL, 'landing_cms.card_six_image', 'messages', 'Card Six Image', 'active', NULL, NULL, '2025-06-21 00:42:39', '2025-06-21 00:42:39'),
(1847, '9f34afc3-1709-41ac-ad01-c7f9e423f026', 1, 3, NULL, 'landing_cms.card_six_text', 'messages', 'Card Six Text', 'active', NULL, NULL, '2025-06-21 00:42:39', '2025-06-21 00:42:39'),
(1848, '9f34afc3-1973-40e6-92f9-35cb42f5ff7e', 1, 3, NULL, 'landing_cms.card_six_text_secondary', 'messages', 'Card Six Text Secondary', 'active', NULL, NULL, '2025-06-21 00:42:39', '2025-06-21 00:42:39'),
(1849, '9f34afc3-1bce-4206-b446-f528c2d1c74f', 1, 3, NULL, 'landing_cms.section_five', 'messages', 'Section Five', 'active', NULL, NULL, '2025-06-21 00:42:39', '2025-06-21 00:42:39'),
(1850, '9f34afc3-1e3c-4b78-b066-98fbefee9c96', 1, 3, NULL, 'landing_cms.main_image', 'messages', 'Main Image', 'active', NULL, NULL, '2025-06-21 00:42:39', '2025-06-21 00:42:39'),
(1851, '9f34afc3-2093-41da-8f5c-68aacf2127fc', 1, 3, NULL, 'landing_cms.card_one_number', 'messages', 'Card One Number', 'active', NULL, NULL, '2025-06-21 00:42:39', '2025-06-21 00:42:39'),
(1852, '9f34afc3-2300-4cee-881c-00d201a5edab', 1, 3, NULL, 'landing_cms.card_two_number', 'messages', 'Card Two Number', 'active', NULL, NULL, '2025-06-21 00:42:39', '2025-06-21 00:42:39'),
(1853, '9f34afc3-25a8-44b8-a7aa-4f3562814223', 1, 3, NULL, 'landing_cms.card_three_number', 'messages', 'Card Three Number', 'active', NULL, NULL, '2025-06-21 00:42:39', '2025-06-21 00:42:39'),
(1854, '9f34afc3-282f-4d9d-a0de-2179042e4af3', 1, 3, NULL, 'landing_cms.card_four_number', 'messages', 'Card Four Number', 'active', NULL, NULL, '2025-06-21 00:42:39', '2025-06-21 00:42:39'),
(1855, '9f34afc3-2aaf-4988-b929-8479aa8f807f', 1, 3, NULL, 'landing_cms.about_us', 'messages', 'About Us', 'active', NULL, NULL, '2025-06-21 00:42:39', '2025-06-21 00:42:39'),
(1856, '9f34afc3-2d2f-4eb9-9f91-c799f0a803e6', 1, 3, NULL, 'landing_cms.main_img_one', 'messages', 'Main Image One', 'active', NULL, NULL, '2025-06-21 00:42:39', '2025-06-21 00:42:39'),
(1857, '9f34afc3-2fc3-48ae-8962-ec7bbd61b03b', 1, 3, NULL, 'landing_cms.main_img_two', 'messages', 'Main Image Two', 'active', NULL, NULL, '2025-06-21 00:42:39', '2025-06-21 00:42:39'),
(1858, '9f34afc3-322d-4755-89d2-e904bb2b96e9', 1, 3, NULL, 'subscribe.subscribers', 'messages', 'Subscribers', 'active', NULL, NULL, '2025-06-21 00:42:39', '2025-06-21 00:42:39'),
(1859, '9f34afc3-34e8-4453-a4e8-a31d00bd3050', 1, 3, NULL, 'footer_setting.footer_settings', 'messages', 'Footer Settings', 'active', NULL, NULL, '2025-06-21 00:42:39', '2025-06-21 00:42:39'),
(1860, '9f34afc3-377d-46d2-96e6-158989d3fee9', 1, 3, NULL, 'footer_setting.footer_text', 'messages', 'Footer Text', 'active', NULL, NULL, '2025-06-21 00:42:39', '2025-06-21 00:42:39'),
(1861, '9f34afc3-3a1b-43a2-8429-523f749300da', 1, 3, NULL, 'footer_setting.address', 'messages', 'Address', 'active', NULL, NULL, '2025-06-21 00:42:39', '2025-06-21 00:42:39'),
(1862, '9f34afc3-3ca3-404e-92d0-70eea3480526', 1, 3, NULL, 'landing.subscribe_our_newsletter', 'messages', 'Subscribe Our Newsletter', 'active', NULL, NULL, '2025-06-21 00:42:39', '2025-06-21 00:42:39'),
(1863, '9f34afc3-3f14-4324-b48d-11cb5f626b85', 1, 3, NULL, 'landing.subscribe', 'messages', 'Subscribe', 'active', NULL, NULL, '2025-06-21 00:42:39', '2025-06-21 00:42:39'),
(1864, '9f34afc3-416c-49d4-874a-5e89fe872ba9', 1, 3, NULL, 'landing.usefull_link', 'messages', 'Useful links', 'active', NULL, NULL, '2025-06-21 00:42:39', '2025-06-21 00:42:39'),
(1865, '9f34afc3-43e5-402b-836e-3f61425d37b8', 1, 3, NULL, 'landing.faqs', 'messages', 'FAQs', 'active', NULL, NULL, '2025-06-21 00:42:39', '2025-06-21 00:42:39'),
(1866, '9f34afc3-4676-44ca-91d5-1c3c51a258b7', 1, 3, NULL, 'landing.about', 'messages', 'About', 'active', NULL, NULL, '2025-06-21 00:42:39', '2025-06-21 00:42:39'),
(1867, '9f34afc3-48f5-4bb5-a0af-a59e2c0aca16', 1, 3, NULL, 'landing.home', 'messages', 'Home', 'active', NULL, NULL, '2025-06-21 00:42:39', '2025-06-21 00:42:39'),
(1868, '9f34afc3-4b71-4d01-b8c7-5e12080cf17b', 1, 3, NULL, 'landing.pricing', 'messages', 'Pricing', 'active', NULL, NULL, '2025-06-21 00:42:39', '2025-06-21 00:42:39'),
(1869, '9f34afc3-4e4b-49a5-9dac-867ff9909c6b', 1, 3, NULL, 'landing.get_in_touch', 'messages', 'Get In Touch', 'active', NULL, NULL, '2025-06-21 00:42:39', '2025-06-21 00:42:39'),
(1870, '9f34afc3-50f4-4509-81de-6c9149fada76', 1, 3, NULL, 'landing.all_rights_reserved', 'messages', 'All Right Reserved', 'active', NULL, NULL, '2025-06-21 00:42:39', '2025-06-21 00:42:39'),
(1871, '9f34afc3-5366-4c48-bd52-14e77dbb9f08', 1, 3, NULL, 'landing.call', 'messages', 'Call', 'active', NULL, NULL, '2025-06-21 00:42:39', '2025-06-21 00:42:39'),
(1872, '9f34afc3-5634-4e0d-a2e9-4e0556ded743', 1, 3, NULL, 'landing.choose_your_pricing_plan', 'messages', 'Choose Your Pricing Plan', 'active', NULL, NULL, '2025-06-21 00:42:39', '2025-06-21 00:42:39'),
(1873, '9f34afc3-58b9-44ae-ab3c-ff33b10f91a6', 1, 3, NULL, 'landing.enquiry', 'messages', 'Enquiry', 'active', NULL, NULL, '2025-06-21 00:42:39', '2025-06-21 00:42:39'),
(1874, '9f34afc3-5b2e-472b-a41a-cd2c973c1f0b', 1, 3, NULL, 'faqs.faqs', 'messages', 'FAQs', 'active', NULL, NULL, '2025-06-21 00:42:39', '2025-06-21 00:42:39'),
(1875, '9f34afc3-5da2-4f5c-b9ca-522114282abf', 1, 3, NULL, 'faqs.add_faqs', 'messages', 'Add FAQs', 'active', NULL, NULL, '2025-06-21 00:42:39', '2025-06-21 00:42:39'),
(1876, '9f34afc3-6039-4f28-a8f3-cf11bb70fa8e', 1, 3, NULL, 'faqs.edit_faqs', 'messages', 'Edit FAQs', 'active', NULL, NULL, '2025-06-21 00:42:39', '2025-06-21 00:42:39'),
(1877, '9f34afc3-62e4-466b-8ca5-43edf1596e35', 1, 3, NULL, 'faqs.question', 'messages', 'Question', 'active', NULL, NULL, '2025-06-21 00:42:39', '2025-06-21 00:42:39'),
(1878, '9f34afc3-6570-4ad1-b6ae-6aefbc1a11ec', 1, 3, NULL, 'faqs.answer', 'messages', 'Answer', 'active', NULL, NULL, '2025-06-21 00:42:39', '2025-06-21 00:42:39'),
(1879, '9f34afc3-67e5-4ad5-903e-01782d25275e', 1, 3, NULL, 'faqs.show', 'messages', 'Show FAQs', 'active', NULL, NULL, '2025-06-21 00:42:39', '2025-06-21 00:42:39'),
(1880, '9f34afc3-6a57-4938-af6a-5bba117a3242', 1, 3, NULL, 'service_slider.service_slider_image', 'messages', 'Service Slider Image', 'active', NULL, NULL, '2025-06-21 00:42:39', '2025-06-21 00:42:39'),
(1881, '9f34afc3-6cdd-45c0-9b88-03da7058c3b9', 1, 3, NULL, 'service_slider.add_service_slider', 'messages', 'Add Service Slider Image', 'active', NULL, NULL, '2025-06-21 00:42:39', '2025-06-21 00:42:39'),
(1882, '9f34afc3-6f56-4c76-b91a-efb5b270ce57', 1, 3, NULL, 'service_slider.edit_service_slider', 'messages', 'Edit Service Slider Image', 'active', NULL, NULL, '2025-06-21 00:42:39', '2025-06-21 00:42:39'),
(1883, '9f34afc3-71b9-4671-89cc-cdf71d17ef48', 1, 3, NULL, 'service_slider.img_tooltip_text', 'messages', 'Best resolution for this image will be 140x50', 'active', NULL, NULL, '2025-06-21 00:42:39', '2025-06-21 00:42:39'),
(1884, '9f34afc3-7432-4570-b648-eb2bcda42e09', 1, 3, NULL, 'hospitals_list.hospital_name', 'messages', 'Hospital Name', 'active', NULL, NULL, '2025-06-21 00:42:39', '2025-06-21 00:42:39'),
(1885, '9f34afc3-76b5-470b-ad2d-1a1c6f15789b', 1, 3, NULL, 'hospitals_list.hospital_username', 'messages', 'Hospital Username', 'active', NULL, NULL, '2025-06-21 00:42:39', '2025-06-21 00:42:39'),
(1886, '9f34afc3-792e-4269-8536-8b4df2fef584', 1, 3, NULL, 'hospitals_list.add_new_hospital', 'messages', 'Add New Hospital', 'active', NULL, NULL, '2025-06-21 00:42:39', '2025-06-21 00:42:39'),
(1887, '9f34afc3-7bad-45f7-a2bf-7272706374a4', 1, 3, NULL, 'hospitals_list.edit_hospital', 'messages', 'Edit Hospital', 'active', NULL, NULL, '2025-06-21 00:42:39', '2025-06-21 00:42:39'),
(1888, '9f34afc3-7e28-4590-aebf-9f02e0afcdb9', 1, 3, NULL, 'hospitals_list.new_hospital', 'messages', 'New Hospital', 'active', NULL, NULL, '2025-06-21 00:42:39', '2025-06-21 00:42:39'),
(1889, '9f34afc3-80d3-45ab-ae35-8e56bebcb909', 1, 3, NULL, 'subscription.month', 'messages', 'Month', 'active', NULL, NULL, '2025-06-21 00:42:39', '2025-06-21 00:42:39'),
(1890, '9f34afc3-835c-4a9b-9041-83d1812c8422', 1, 3, NULL, 'subscription.year', 'messages', 'Year', 'active', NULL, NULL, '2025-06-21 00:42:39', '2025-06-21 00:42:39'),
(1891, '9f34afc3-85db-451f-beec-23c6f4bffef8', 1, 3, NULL, 'subscription.subscription', 'messages', 'Subscription', 'active', NULL, NULL, '2025-06-21 00:42:39', '2025-06-21 00:42:39'),
(1892, '9f34afc3-885b-4ebf-a5fe-ad5c87ea67ad', 1, 3, NULL, 'subscription.subscriptions', 'messages', 'Subscriptions', 'active', NULL, NULL, '2025-06-21 00:42:39', '2025-06-21 00:42:39'),
(1893, '9f34afc3-8aec-407e-a4fd-1bf03947eb08', 1, 3, NULL, 'subscription.subscription_details', 'messages', 'Subscription Details', 'active', NULL, NULL, '2025-06-21 00:42:39', '2025-06-21 00:42:39'),
(1894, '9f34afc3-8e9c-46f2-b784-7b828ad2dc49', 1, 3, NULL, 'subscription.edit_subscription', 'messages', 'Edit Subscription', 'active', NULL, NULL, '2025-06-21 00:42:39', '2025-06-21 00:42:39'),
(1895, '9f34afc3-9136-4513-a72b-488fa0db34a4', 1, 3, NULL, 'subscription.payment_approved', 'messages', 'Payment Approved', 'active', NULL, NULL, '2025-06-21 00:42:39', '2025-06-21 00:42:39'),
(1896, '9f34afc3-93b5-4fdf-a918-05237d17b78f', 1, 3, NULL, 'subscription.approved', 'messages', 'Approved', 'active', NULL, NULL, '2025-06-21 00:42:39', '2025-06-21 00:42:39'),
(1897, '9f34afc3-9623-4aad-b0e2-c5a8e2d100b4', 1, 3, NULL, 'subscription.denied', 'messages', 'Denied', 'active', NULL, NULL, '2025-06-21 00:42:39', '2025-06-21 00:42:39'),
(1898, '9f34afc3-98a4-453a-993c-e6eff13d4d55', 1, 3, NULL, 'subscription.select_manual_payment', 'messages', 'Select Manual Payment', 'active', NULL, NULL, '2025-06-21 00:42:39', '2025-06-21 00:42:39'),
(1899, '9f34afc3-9b14-433d-af47-7dac0e8ab5b1', 1, 3, NULL, 'subscription.waiting_for_approval', 'messages', 'Waiting for Approval', 'active', NULL, NULL, '2025-06-21 00:42:39', '2025-06-21 00:42:39'),
(1900, '9f34afc3-9d9d-4356-a151-56c720fd0ad6', 1, 3, NULL, 'subscription.cash_payment_done', 'messages', 'Your payment is done and your subscription will be activated once the admin approve your transaction.', 'active', NULL, NULL, '2025-06-21 00:42:39', '2025-06-21 00:42:39'),
(1901, '9f34afc3-a042-47f7-8690-4881bd4a4911', 1, 3, NULL, 'delete.accountant', 'messages', 'Accountant', 'active', NULL, NULL, '2025-06-21 00:42:39', '2025-06-21 00:42:39'),
(1902, '9f34afc3-a2e3-4043-9d97-fe8ba6973916', 1, 3, NULL, 'delete.account', 'messages', 'Account', 'active', NULL, NULL, '2025-06-21 00:42:39', '2025-06-21 00:42:39'),
(1903, '9f34afc3-a55f-4e8d-b9c2-6ea475259216', 1, 3, NULL, 'delete.advanced_payment', 'messages', 'Advanced Payment', 'active', NULL, NULL, '2025-06-21 00:42:39', '2025-06-21 00:42:39'),
(1904, '9f34afc3-a7dd-4c58-920e-1237bbb4247b', 1, 3, NULL, 'delete.ambulance_call', 'messages', 'Ambulance Call', 'active', NULL, NULL, '2025-06-21 00:42:39', '2025-06-21 00:42:39'),
(1905, '9f34afc3-aa62-4391-be8c-b1e1fb080981', 1, 3, NULL, 'delete.ambulance', 'messages', 'Ambulance', 'active', NULL, NULL, '2025-06-21 00:42:39', '2025-06-21 00:42:39'),
(1906, '9f34afc3-acef-4be1-be58-7a129a84603c', 1, 3, NULL, 'delete.appointment', 'messages', 'Appointment', 'active', NULL, NULL, '2025-06-21 00:42:39', '2025-06-21 00:42:39'),
(1907, '9f34afc3-af80-4b6e-94c7-7c13f7cd70ba', 1, 3, NULL, 'delete.bed_assign', 'messages', 'Bed Assign', 'active', NULL, NULL, '2025-06-21 00:42:39', '2025-06-21 00:42:39'),
(1908, '9f34afc3-b216-4fac-b7ac-30af58181d22', 1, 3, NULL, 'delete.bed_type', 'messages', 'Bed Type', 'active', NULL, NULL, '2025-06-21 00:42:39', '2025-06-21 00:42:39'),
(1909, '9f34afc3-b4a8-475d-82bd-0ee368d907fd', 1, 3, NULL, 'delete.bed', 'messages', 'Bed', 'active', NULL, NULL, '2025-06-21 00:42:39', '2025-06-21 00:42:39'),
(1910, '9f34afc3-b720-401a-8d0c-11f4e617b5e2', 1, 3, NULL, 'delete.bill', 'messages', 'Bill', 'active', NULL, NULL, '2025-06-21 00:42:39', '2025-06-21 00:42:39'),
(1911, '9f34afc3-b9a5-4577-b635-8758ed96bc65', 1, 3, NULL, 'delete.birth_report', 'messages', 'Birth Report', 'active', NULL, NULL, '2025-06-21 00:42:39', '2025-06-21 00:42:39'),
(1912, '9f34afc3-bc1e-4269-9bd3-56eeedcc343e', 1, 3, NULL, 'delete.blood_group', 'messages', 'Blood Group', 'active', NULL, NULL, '2025-06-21 00:42:39', '2025-06-21 00:42:39'),
(1913, '9f34afc3-be9e-431b-b8bc-03db5527f055', 1, 3, NULL, 'delete.blood_donation', 'messages', 'Blood Donation', 'active', NULL, NULL, '2025-06-21 00:42:39', '2025-06-21 00:42:39'),
(1914, '9f34afc3-c0fc-4d84-9b7d-f6724ad86276', 1, 3, NULL, 'delete.blood_donor', 'messages', 'Blood Donor', 'active', NULL, NULL, '2025-06-21 00:42:39', '2025-06-21 00:42:39'),
(1915, '9f34afc3-c388-498f-b810-21f239cb23eb', 1, 3, NULL, 'delete.blood_issue', 'messages', 'Blood Issue', 'active', NULL, NULL, '2025-06-21 00:42:39', '2025-06-21 00:42:39'),
(1916, '9f34afc3-c62c-4ba3-a159-b7e17db579cb', 1, 3, NULL, 'delete.medicine_brand', 'messages', 'Medicine Brand', 'active', NULL, NULL, '2025-06-21 00:42:39', '2025-06-21 00:42:39'),
(1917, '9f34afc3-c8ce-4a9c-ba9b-871a30a84aa5', 1, 3, NULL, 'delete.call_log', 'messages', 'Call Log', 'active', NULL, NULL, '2025-06-21 00:42:39', '2025-06-21 00:42:39'),
(1918, '9f34afc3-cb49-45cf-a2fa-23924b4af411', 1, 3, NULL, 'delete.case_handler', 'messages', 'Case Handler', 'active', NULL, NULL, '2025-06-21 00:42:39', '2025-06-21 00:42:39'),
(1919, '9f34afc3-cdb1-4a33-abb7-167ec0a89b33', 1, 3, NULL, 'delete.medicine_category', 'messages', 'Medicine Category', 'active', NULL, NULL, '2025-06-21 00:42:39', '2025-06-21 00:42:39'),
(1920, '9f34afc3-d035-4dad-a620-f8723a4e2ca4', 1, 3, NULL, 'delete.charge_category', 'messages', 'Charge Category', 'active', NULL, NULL, '2025-06-21 00:42:39', '2025-06-21 00:42:39'),
(1921, '9f34afc3-d2b8-42db-a62d-614c7b253205', 1, 3, NULL, 'delete.charge', 'messages', 'Charge', 'active', NULL, NULL, '2025-06-21 00:42:39', '2025-06-21 00:42:39'),
(1922, '9f34afc3-d566-49d2-ba1c-abfa42eb4c76', 1, 3, NULL, 'delete.department', 'messages', 'Department', 'active', NULL, NULL, '2025-06-21 00:42:39', '2025-06-21 00:42:39'),
(1923, '9f34afc3-d7f8-47b1-b321-40ad19937856', 1, 3, NULL, 'delete.diagnosis_category', 'messages', 'Diagnosis Category', 'active', NULL, NULL, '2025-06-21 00:42:39', '2025-06-21 00:42:39'),
(1924, '9f34afc3-da6e-4a41-8482-2213a464b351', 1, 3, NULL, 'delete.doctor_opd_charge', 'messages', 'Doctor Opd Charge', 'active', NULL, NULL, '2025-06-21 00:42:39', '2025-06-21 00:42:39');
INSERT INTO `ltu_phrases` (`id`, `uuid`, `translation_id`, `translation_file_id`, `phrase_id`, `key`, `group`, `value`, `status`, `parameters`, `note`, `created_at`, `updated_at`) VALUES
(1925, '9f34afc3-dd11-40dc-9367-51748c59f35a', 1, 3, NULL, 'delete.doctor_department', 'messages', 'Doctor Department', 'active', NULL, NULL, '2025-06-21 00:42:39', '2025-06-21 00:42:39'),
(1926, '9f34afc3-df8c-427a-b455-845a5373dc83', 1, 3, NULL, 'delete.document', 'messages', 'Document', 'active', NULL, NULL, '2025-06-21 00:42:39', '2025-06-21 00:42:39'),
(1927, '9f34afc3-e206-4336-ae3e-3dfb922f2735', 1, 3, NULL, 'delete.document_type', 'messages', 'Document Type', 'active', NULL, NULL, '2025-06-21 00:42:39', '2025-06-21 00:42:39'),
(1928, '9f34afc3-e479-44a7-9618-addf8b3f0335', 1, 3, NULL, 'delete.employee_payroll', 'messages', 'Employee Payroll', 'active', NULL, NULL, '2025-06-21 00:42:39', '2025-06-21 00:42:39'),
(1929, '9f34afc3-e6ee-4e0a-9070-037456e886d9', 1, 3, NULL, 'delete.expense', 'messages', 'Expense', 'active', NULL, NULL, '2025-06-21 00:42:39', '2025-06-21 00:42:39'),
(1930, '9f34afc3-e96b-40fc-bed0-bc76e294c258', 1, 3, NULL, 'delete.faq', 'messages', 'FAQ', 'active', NULL, NULL, '2025-06-21 00:42:39', '2025-06-21 00:42:39'),
(1931, '9f34afc3-ec13-4fe2-9a5f-174fff256590', 1, 3, NULL, 'delete.income', 'messages', 'Income', 'active', NULL, NULL, '2025-06-21 00:42:39', '2025-06-21 00:42:39'),
(1932, '9f34afc3-eea7-44d0-93f9-8e4695daed2f', 1, 3, NULL, 'delete.insurance', 'messages', 'Insurance', 'active', NULL, NULL, '2025-06-21 00:42:39', '2025-06-21 00:42:39'),
(1933, '9f34afc3-f142-4fb6-b6d8-841250cb6883', 1, 3, NULL, 'delete.investigation_report', 'messages', 'Investigation Report', 'active', NULL, NULL, '2025-06-21 00:42:39', '2025-06-21 00:42:39'),
(1934, '9f34afc3-f3c8-460c-bab9-3efbd795fe4a', 1, 3, NULL, 'delete.invoice', 'messages', 'Invoice', 'active', NULL, NULL, '2025-06-21 00:42:39', '2025-06-21 00:42:39'),
(1935, '9f34afc3-f64f-4be9-bfa9-f9a32cbabd2d', 1, 3, NULL, 'delete.ipd_charge', 'messages', 'IPD Charge', 'active', NULL, NULL, '2025-06-21 00:42:39', '2025-06-21 00:42:39'),
(1936, '9f34afc3-f8d6-4cf1-9501-446783c2901e', 1, 3, NULL, 'delete.ipd_consultant_instruction', 'messages', 'IPD Consultant Instruction', 'active', NULL, NULL, '2025-06-21 00:42:39', '2025-06-21 00:42:39'),
(1937, '9f34afc3-fb41-4a41-ae7f-f45e7ee49f9f', 1, 3, NULL, 'delete.ipd_diagnosis', 'messages', 'IPD Diagnosis', 'active', NULL, NULL, '2025-06-21 00:42:39', '2025-06-21 00:42:39'),
(1938, '9f34afc3-fde1-4011-a95c-604867f25174', 1, 3, NULL, 'delete.ipd_patient', 'messages', 'IPD Patient', 'active', NULL, NULL, '2025-06-21 00:42:39', '2025-06-21 00:42:39'),
(1939, '9f34afc4-0071-4b13-8132-b3dc5d6c64e0', 1, 3, NULL, 'delete.ipd_payment', 'messages', 'IPD Payment', 'active', NULL, NULL, '2025-06-21 00:42:39', '2025-06-21 00:42:39'),
(1940, '9f34afc4-0309-4dc7-8fef-7bb60e1572c9', 1, 3, NULL, 'delete.ipd_prescription', 'messages', 'IPD Prescription', 'active', NULL, NULL, '2025-06-21 00:42:39', '2025-06-21 00:42:39'),
(1941, '9f34afc4-05a8-4354-8c87-ed68b5299b3d', 1, 3, NULL, 'delete.issued_item', 'messages', 'Issued Item', 'active', NULL, NULL, '2025-06-21 00:42:39', '2025-06-21 00:42:39'),
(1942, '9f34afc4-0855-4e56-bb58-58eb2ecd64a5', 1, 3, NULL, 'delete.item_category', 'messages', 'Item Category', 'active', NULL, NULL, '2025-06-21 00:42:39', '2025-06-21 00:42:39'),
(1943, '9f34afc4-0adf-4de9-9bc1-6474d1e1712c', 1, 3, NULL, 'delete.item_stock', 'messages', 'Item Stock', 'active', NULL, NULL, '2025-06-21 00:42:39', '2025-06-21 00:42:39'),
(1944, '9f34afc4-0d6b-4f73-a05c-cccd0a068e37', 1, 3, NULL, 'delete.item', 'messages', 'Item', 'active', NULL, NULL, '2025-06-21 00:42:39', '2025-06-21 00:42:39'),
(1945, '9f34afc4-11a5-4c69-b0e5-ec1f013d5e7e', 1, 3, NULL, 'delete.lab_technician', 'messages', 'Lab Technician', 'active', NULL, NULL, '2025-06-21 00:42:39', '2025-06-21 00:42:39'),
(1946, '9f34afc4-143f-41f6-8de0-1bb08f2eb630', 1, 3, NULL, 'delete.live_consultation', 'messages', 'Live Consultation', 'active', NULL, NULL, '2025-06-21 00:42:39', '2025-06-21 00:42:39'),
(1947, '9f34afc4-16e7-4b80-a31d-e708697e93c3', 1, 3, NULL, 'delete.live_meeting', 'messages', 'Live Meeting', 'active', NULL, NULL, '2025-06-21 00:42:39', '2025-06-21 00:42:39'),
(1948, '9f34afc4-1973-4a14-99ec-237596a133c5', 1, 3, NULL, 'delete.medicine', 'messages', 'Medicine', 'active', NULL, NULL, '2025-06-21 00:42:39', '2025-06-21 00:42:39'),
(1949, '9f34afc4-1bff-4d36-92e9-fe3af27da5a1', 1, 3, NULL, 'delete.notice_board', 'messages', 'Notice Board', 'active', NULL, NULL, '2025-06-21 00:42:39', '2025-06-21 00:42:39'),
(1950, '9f34afc4-1e96-4906-9465-64672bc91178', 1, 3, NULL, 'delete.nurse', 'messages', 'Nurse', 'active', NULL, NULL, '2025-06-21 00:42:39', '2025-06-21 00:42:39'),
(1951, '9f34afc4-212f-49d9-8cd0-055b782810ea', 1, 3, NULL, 'delete.opd_diagnosis', 'messages', 'OPD Diagnosis', 'active', NULL, NULL, '2025-06-21 00:42:39', '2025-06-21 00:42:39'),
(1952, '9f34afc4-23e1-4bef-905e-df26f9203b5c', 1, 3, NULL, 'delete.opd_patient', 'messages', 'OPD Patient', 'active', NULL, NULL, '2025-06-21 00:42:39', '2025-06-21 00:42:39'),
(1953, '9f34afc4-26b2-481b-b69d-4684f7013137', 1, 3, NULL, 'delete.opd_patient_visit', 'messages', 'OPD Patient Visit', 'active', NULL, NULL, '2025-06-21 00:42:39', '2025-06-21 00:42:39'),
(1954, '9f34afc4-2947-4f36-b7d0-a2a51f7bcd4c', 1, 3, NULL, 'delete.operation_report', 'messages', 'Operation Report', 'active', NULL, NULL, '2025-06-21 00:42:39', '2025-06-21 00:42:39'),
(1955, '9f34afc4-2bcb-482d-85e6-33ea9c79d4c3', 1, 3, NULL, 'delete.package', 'messages', 'Package', 'active', NULL, NULL, '2025-06-21 00:42:39', '2025-06-21 00:42:39'),
(1956, '9f34afc4-2e89-4589-874c-b0062f858b39', 1, 3, NULL, 'delete.pathology_category', 'messages', 'Pathology Category', 'active', NULL, NULL, '2025-06-21 00:42:39', '2025-06-21 00:42:39'),
(1957, '9f34afc4-311e-4aa1-ba36-bf0f92621e27', 1, 3, NULL, 'delete.pathology_test', 'messages', 'Pathology Test', 'active', NULL, NULL, '2025-06-21 00:42:39', '2025-06-21 00:42:39'),
(1958, '9f34afc4-33a9-4fa6-9458-567777cc08c4', 1, 3, NULL, 'delete.patient_admission', 'messages', 'Patient Admission', 'active', NULL, NULL, '2025-06-21 00:42:39', '2025-06-21 00:42:39'),
(1959, '9f34afc4-3622-43c6-a997-8190164621fa', 1, 3, NULL, 'delete.case', 'messages', 'Case', 'active', NULL, NULL, '2025-06-21 00:42:39', '2025-06-21 00:42:39'),
(1960, '9f34afc4-389f-4431-addc-0fe3af1f8a03', 1, 3, NULL, 'delete.patient_diagnosis_test', 'messages', 'Patient diagnosis test', 'active', NULL, NULL, '2025-06-21 00:42:39', '2025-06-21 00:42:39'),
(1961, '9f34afc4-3b3a-44b9-8bb7-0a6e86268275', 1, 3, NULL, 'delete.patient', 'messages', 'Patient', 'active', NULL, NULL, '2025-06-21 00:42:39', '2025-06-21 00:42:39'),
(1962, '9f34afc4-3dc3-4faf-aab8-214651b2340a', 1, 3, NULL, 'delete.payment', 'messages', 'Payment', 'active', NULL, NULL, '2025-06-21 00:42:39', '2025-06-21 00:42:39'),
(1963, '9f34afc4-406e-4f1c-a5b2-c5609dde1671', 1, 3, NULL, 'delete.pharmacist', 'messages', 'Pharmacist', 'active', NULL, NULL, '2025-06-21 00:42:39', '2025-06-21 00:42:39'),
(1964, '9f34afc4-42f6-4ffc-8b21-9636bdace7ac', 1, 3, NULL, 'delete.prescription', 'messages', 'Prescription', 'active', NULL, NULL, '2025-06-21 00:42:39', '2025-06-21 00:42:39'),
(1965, '9f34afc4-456e-4128-b0ea-4d98800b593c', 1, 3, NULL, 'delete.radiology_category', 'messages', 'Radiology Category', 'active', NULL, NULL, '2025-06-21 00:42:39', '2025-06-21 00:42:39'),
(1966, '9f34afc4-47ea-45c4-ab8f-3f407cd430f7', 1, 3, NULL, 'delete.radiology_test', 'messages', 'Radiology Test', 'active', NULL, NULL, '2025-06-21 00:42:39', '2025-06-21 00:42:39'),
(1967, '9f34afc4-4a60-47bf-a646-5fb068073403', 1, 3, NULL, 'delete.receptionist', 'messages', 'Receptionist', 'active', NULL, NULL, '2025-06-21 00:42:39', '2025-06-21 00:42:39'),
(1968, '9f34afc4-4cd1-4cd0-8354-0929c5d2cfb8', 1, 3, NULL, 'delete.schedule', 'messages', 'Schedule', 'active', NULL, NULL, '2025-06-21 00:42:39', '2025-06-21 00:42:39'),
(1969, '9f34afc4-4f62-4cb7-b7ae-8f5f6095410d', 1, 3, NULL, 'delete.service_slider', 'messages', 'Service Slider', 'active', NULL, NULL, '2025-06-21 00:42:39', '2025-06-21 00:42:39'),
(1970, '9f34afc4-51f0-4bfb-9f03-51d97d7fbf17', 1, 3, NULL, 'delete.service', 'messages', 'Service', 'active', NULL, NULL, '2025-06-21 00:42:39', '2025-06-21 00:42:39'),
(1971, '9f34afc4-5488-40c8-86f6-837518c5ec10', 1, 3, NULL, 'delete.sms', 'messages', 'SMS', 'active', NULL, NULL, '2025-06-21 00:42:39', '2025-06-21 00:42:39'),
(1972, '9f34afc4-572e-4db3-99dc-c6fa484b5828', 1, 3, NULL, 'delete.subscriber', 'messages', 'Subscriber', 'active', NULL, NULL, '2025-06-21 00:42:39', '2025-06-21 00:42:39'),
(1973, '9f34afc4-59c9-4ac5-9d54-b7c0a6ffb254', 1, 3, NULL, 'delete.subscription_plan', 'messages', 'Subscription Plan', 'active', NULL, NULL, '2025-06-21 00:42:39', '2025-06-21 00:42:39'),
(1974, '9f34afc4-5c4b-423d-8dc8-f729a00262b9', 1, 3, NULL, 'delete.hospital', 'messages', 'Hospital', 'active', NULL, NULL, '2025-06-21 00:42:39', '2025-06-21 00:42:39'),
(1975, '9f34afc4-5ed6-499d-9a44-ec0e9137c429', 1, 3, NULL, 'delete.enquiry', 'messages', 'Enquiry', 'active', NULL, NULL, '2025-06-21 00:42:39', '2025-06-21 00:42:39'),
(1976, '9f34afc4-6178-49cc-942a-bb1de5f2d54f', 1, 3, NULL, 'delete.user', 'messages', 'User', 'active', NULL, NULL, '2025-06-21 00:42:39', '2025-06-21 00:42:39'),
(1977, '9f34afc4-6528-4439-8b4f-3c9981111744', 1, 3, NULL, 'delete.vaccinated_patient', 'messages', 'Vaccinated Patient', 'active', NULL, NULL, '2025-06-21 00:42:39', '2025-06-21 00:42:39'),
(1978, '9f34afc4-6816-498b-94c9-08621c951598', 1, 3, NULL, 'delete.vaccination', 'messages', 'Vaccination', 'active', NULL, NULL, '2025-06-21 00:42:40', '2025-06-21 00:42:40'),
(1979, '9f34afc4-6a9e-4cfa-b6ff-38956053c6d3', 1, 3, NULL, 'delete.visitor', 'messages', 'Visitor', 'active', NULL, NULL, '2025-06-21 00:42:40', '2025-06-21 00:42:40'),
(1980, '9f34afc4-6d2d-4fe0-a994-b4a8070f2f3f', 1, 3, NULL, 'delete.testimonial', 'messages', 'Testimonial', 'active', NULL, NULL, '2025-06-21 00:42:40', '2025-06-21 00:42:40'),
(1981, '9f34afc4-6fce-4c48-a486-cd38048626f1', 1, 3, NULL, 'delete.opd_timelines', 'messages', 'OPD Timeline', 'active', NULL, NULL, '2025-06-21 00:42:40', '2025-06-21 00:42:40'),
(1982, '9f34afc4-7263-4584-99f2-ff6b499e8c93', 1, 3, NULL, 'flash.not_allow_access_record', 'messages', 'Seems, you are not allowed to access this record.', 'active', NULL, NULL, '2025-06-21 00:42:40', '2025-06-21 00:42:40'),
(1983, '9f34afc4-74ff-461b-9e70-bd0e58b53452', 1, 3, NULL, 'flash.accountant_not_found', 'messages', 'Accountant not found', 'active', NULL, NULL, '2025-06-21 00:42:40', '2025-06-21 00:42:40'),
(1984, '9f34afc4-7779-481b-86d2-bd41cc4dbd40', 1, 3, NULL, 'flash.admin_not_found', 'messages', 'Admin not found', 'active', NULL, NULL, '2025-06-21 00:42:40', '2025-06-21 00:42:40'),
(1985, '9f34afc4-7a14-4110-8c09-f47282d303a1', 1, 3, NULL, 'flash.advance_payment_not_found', 'messages', 'Advance Payment not found', 'active', NULL, NULL, '2025-06-21 00:42:40', '2025-06-21 00:42:40'),
(1986, '9f34afc4-7cb5-4e2d-8f70-ee86cf5ae028', 1, 3, NULL, 'flash.ambulance_call_not_found', 'messages', 'Ambulance Call not found', 'active', NULL, NULL, '2025-06-21 00:42:40', '2025-06-21 00:42:40'),
(1987, '9f34afc4-7f63-4dd3-824b-f9a3d44c7eff', 1, 3, NULL, 'flash.ambulance_not_found', 'messages', 'Ambulance not found', 'active', NULL, NULL, '2025-06-21 00:42:40', '2025-06-21 00:42:40'),
(1988, '9f34afc4-8211-4b46-b6f9-eeca06be71c0', 1, 3, NULL, 'flash.bed_assign_not_found', 'messages', 'Bed Assign not found', 'active', NULL, NULL, '2025-06-21 00:42:40', '2025-06-21 00:42:40'),
(1989, '9f34afc4-84b5-4512-848c-7b1f3bafecaf', 1, 3, NULL, 'flash.bed_not_found', 'messages', 'Bed not found', 'active', NULL, NULL, '2025-06-21 00:42:40', '2025-06-21 00:42:40'),
(1990, '9f34afc4-873d-4628-8097-6ace45729cc5', 1, 3, NULL, 'flash.birth_report_not_found', 'messages', 'Birth Report not found', 'active', NULL, NULL, '2025-06-21 00:42:40', '2025-06-21 00:42:40'),
(1991, '9f34afc4-89d8-46fc-a51c-11e66ca6ef17', 1, 3, NULL, 'flash.blood_bank_not_found', 'messages', 'Blood bank not found', 'active', NULL, NULL, '2025-06-21 00:42:40', '2025-06-21 00:42:40'),
(1992, '9f34afc4-8c8c-455b-961f-ea1696af464b', 1, 3, NULL, 'flash.blood_donation_not_found', 'messages', 'Blood donation not found', 'active', NULL, NULL, '2025-06-21 00:42:40', '2025-06-21 00:42:40'),
(1993, '9f34afc4-8f1c-4423-8fe2-f8e940aff24f', 1, 3, NULL, 'flash.blood_donor_not_found', 'messages', 'Blood Donor not found', 'active', NULL, NULL, '2025-06-21 00:42:40', '2025-06-21 00:42:40'),
(1994, '9f34afc4-91ab-4792-95ef-5188f266e0e2', 1, 3, NULL, 'flash.blood_issue_not_found', 'messages', 'Blood issue not found', 'active', NULL, NULL, '2025-06-21 00:42:40', '2025-06-21 00:42:40'),
(1995, '9f34afc4-9456-4a70-8d5f-6fc435d0ea5e', 1, 3, NULL, 'flash.brand_not_found', 'messages', 'Brand not found', 'active', NULL, NULL, '2025-06-21 00:42:40', '2025-06-21 00:42:40'),
(1996, '9f34afc4-96fd-4f76-995a-e7d06dba95b0', 1, 3, NULL, 'flash.call_log_not_found', 'messages', 'Call log not found', 'active', NULL, NULL, '2025-06-21 00:42:40', '2025-06-21 00:42:40'),
(1997, '9f34afc4-9992-4efb-8314-85892dbc3d69', 1, 3, NULL, 'flash.case_handler_not_found', 'messages', 'Case Handler not found', 'active', NULL, NULL, '2025-06-21 00:42:40', '2025-06-21 00:42:40'),
(1998, '9f34afc4-9c45-4d2b-b883-3f5aafd160ae', 1, 3, NULL, 'flash.charge_not_found', 'messages', 'Charge not found', 'active', NULL, NULL, '2025-06-21 00:42:40', '2025-06-21 00:42:40'),
(1999, '9f34afc4-9ed1-48ad-a20f-534cd809c75e', 1, 3, NULL, 'flash.currency_not_found', 'messages', 'Currency not found', 'active', NULL, NULL, '2025-06-21 00:42:40', '2025-06-21 00:42:40'),
(2000, '9f34afc4-a189-4e44-a157-2bd6073a39e5', 1, 3, NULL, 'flash.death_report_not_found', 'messages', 'Death Report not found', 'active', NULL, NULL, '2025-06-21 00:42:40', '2025-06-21 00:42:40'),
(2001, '9f34afc4-a429-45a3-88d3-00cba33f4a2c', 1, 3, NULL, 'flash.department_not_found', 'messages', 'Department not found', 'active', NULL, NULL, '2025-06-21 00:42:40', '2025-06-21 00:42:40'),
(2002, '9f34afc4-a6be-473e-a346-88903587a584', 1, 3, NULL, 'flash.doctor_opd_charge_not_found', 'messages', 'Doctor Opd Charge not found', 'active', NULL, NULL, '2025-06-21 00:42:40', '2025-06-21 00:42:40'),
(2003, '9f34afc4-a967-493f-ba6e-cf207e647b68', 1, 3, NULL, 'flash.document_not_found', 'messages', 'Document not found', 'active', NULL, NULL, '2025-06-21 00:42:40', '2025-06-21 00:42:40'),
(2004, '9f34afc4-abff-4869-8b37-4d2588f4f8cc', 1, 3, NULL, 'flash.employee_payroll_not_found', 'messages', 'Employee Payroll not found', 'active', NULL, NULL, '2025-06-21 00:42:40', '2025-06-21 00:42:40'),
(2005, '9f34afc4-ae9f-4c5d-a41c-d2ad2ce054b3', 1, 3, NULL, 'flash.expense_not_found', 'messages', 'Expense not found', 'active', NULL, NULL, '2025-06-21 00:42:40', '2025-06-21 00:42:40'),
(2006, '9f34afc4-b14e-43b1-8b1c-772acbdaa518', 1, 3, NULL, 'flash.front_service_not_found', 'messages', 'Front Service not found', 'active', NULL, NULL, '2025-06-21 00:42:40', '2025-06-21 00:42:40'),
(2007, '9f34afc4-b3e3-41ed-8f17-55bb95b8295d', 1, 3, NULL, 'flash.hospital_not_found', 'messages', 'Hospital not found', 'active', NULL, NULL, '2025-06-21 00:42:40', '2025-06-21 00:42:40'),
(2008, '9f34afc4-b684-40f1-a1e0-06f0d8131bcc', 1, 3, NULL, 'flash.income_not_found', 'messages', 'Income not found', 'active', NULL, NULL, '2025-06-21 00:42:40', '2025-06-21 00:42:40'),
(2009, '9f34afc4-b91e-4111-8297-24809416c6fe', 1, 3, NULL, 'flash.insurance_not_found', 'messages', 'Insurance not found', 'active', NULL, NULL, '2025-06-21 00:42:40', '2025-06-21 00:42:40'),
(2010, '9f34afc4-bbd6-4d16-bbd9-e5186668cbdc', 1, 3, NULL, 'flash.invoice_not_found', 'messages', 'Invoice not found', 'active', NULL, NULL, '2025-06-21 00:42:40', '2025-06-21 00:42:40'),
(2011, '9f34afc4-be62-4f3a-8c8f-c289743dc993', 1, 3, NULL, 'flash.ipd_charge_not_found', 'messages', 'IPD Charge not found', 'active', NULL, NULL, '2025-06-21 00:42:40', '2025-06-21 00:42:40'),
(2012, '9f34afc4-c0f6-4b9f-9cc6-3b63ceb8155b', 1, 3, NULL, 'flash.ipd_consultant_register_not_found', 'messages', 'IPD Consultant Register not found', 'active', NULL, NULL, '2025-06-21 00:42:40', '2025-06-21 00:42:40'),
(2013, '9f34afc4-c3ac-48f6-b570-ecfc2070623b', 1, 3, NULL, 'flash.ipd_diagnosis_not_found', 'messages', 'IPD Diagnosis not found', 'active', NULL, NULL, '2025-06-21 00:42:40', '2025-06-21 00:42:40'),
(2014, '9f34afc4-c63b-467a-a29d-fb7dcc839982', 1, 3, NULL, 'flash.ipd_patient_not_found', 'messages', 'IPD Patient not found', 'active', NULL, NULL, '2025-06-21 00:42:40', '2025-06-21 00:42:40'),
(2015, '9f34afc4-c8fe-41e4-ad78-321e97e838ae', 1, 3, NULL, 'flash.ipd_payment_not_found', 'messages', 'IPD Payment not found', 'active', NULL, NULL, '2025-06-21 00:42:40', '2025-06-21 00:42:40'),
(2016, '9f34afc4-cb9e-41c6-9e8a-8991315084b4', 1, 3, NULL, 'flash.ipd_prescription_not_found', 'messages', 'IPD Prescription not found', 'active', NULL, NULL, '2025-06-21 00:42:40', '2025-06-21 00:42:40'),
(2017, '9f34afc4-ce21-41e8-b3e3-b6858b2dff1d', 1, 3, NULL, 'flash.ipd_timeline_not_found', 'messages', 'IPD Timeline not found', 'active', NULL, NULL, '2025-06-21 00:42:40', '2025-06-21 00:42:40'),
(2018, '9f34afc4-d0bd-4133-9cf5-cd7fb79e878e', 1, 3, NULL, 'flash.issued_item_not_found', 'messages', 'Issued Item not found', 'active', NULL, NULL, '2025-06-21 00:42:40', '2025-06-21 00:42:40'),
(2019, '9f34afc4-d350-4c74-b22d-8c612838a6a6', 1, 3, NULL, 'flash.item_category_not_found', 'messages', 'Item Category not found', 'active', NULL, NULL, '2025-06-21 00:42:40', '2025-06-21 00:42:40'),
(2020, '9f34afc4-d5ea-414b-85cf-32c91d2d3f76', 1, 3, NULL, 'flash.item_stock_not_found', 'messages', 'Item Stock not found', 'active', NULL, NULL, '2025-06-21 00:42:40', '2025-06-21 00:42:40'),
(2021, '9f34afc4-d88e-4339-9381-64f3d3a93d28', 1, 3, NULL, 'flash.lab_technician_not_found', 'messages', 'Lab Technician not found', 'active', NULL, NULL, '2025-06-21 00:42:40', '2025-06-21 00:42:40'),
(2022, '9f34afc4-db3b-477a-8b89-9425774b1191', 1, 3, NULL, 'flash.live_consultation_not_found', 'messages', 'Live Consultation not found', 'active', NULL, NULL, '2025-06-21 00:42:40', '2025-06-21 00:42:40'),
(2023, '9f34afc4-ddb8-4149-a160-9645c9869eea', 1, 3, NULL, 'flash.live_meeting_not_found', 'messages', 'Live Meeting not found', 'active', NULL, NULL, '2025-06-21 00:42:40', '2025-06-21 00:42:40'),
(2024, '9f34afc4-e057-48bc-917f-bf000dfe25b7', 1, 3, NULL, 'flash.medicine_not_found', 'messages', 'Medicine not found', 'active', NULL, NULL, '2025-06-21 00:42:40', '2025-06-21 00:42:40'),
(2025, '9f34afc4-e319-4beb-ad56-fad51db6b035', 1, 3, NULL, 'flash.notice_board_not_found', 'messages', 'Notice Board not found', 'active', NULL, NULL, '2025-06-21 00:42:40', '2025-06-21 00:42:40'),
(2026, '9f34afc4-e5c8-4b03-8d84-4d29aa038595', 1, 3, NULL, 'flash.nurse_not_found', 'messages', 'Nurse not found', 'active', NULL, NULL, '2025-06-21 00:42:40', '2025-06-21 00:42:40'),
(2027, '9f34afc4-e862-4bbd-8462-2cd0f7079160', 1, 3, NULL, 'flash.opd_diagnosis_not_found', 'messages', 'Opd Diagnosis not found', 'active', NULL, NULL, '2025-06-21 00:42:40', '2025-06-21 00:42:40'),
(2028, '9f34afc4-eb24-45e5-a4eb-103b562fac64', 1, 3, NULL, 'flash.opd_patient_not_found', 'messages', 'Opd Patient not found', 'active', NULL, NULL, '2025-06-21 00:42:40', '2025-06-21 00:42:40'),
(2029, '9f34afc4-eda9-435a-80d2-9cf257b1c484', 1, 3, NULL, 'flash.opd_timeline_not_found', 'messages', 'Opd Timeline not found', 'active', NULL, NULL, '2025-06-21 00:42:40', '2025-06-21 00:42:40'),
(2030, '9f34afc4-f037-40a6-a5ed-e58311e55860', 1, 3, NULL, 'flash.operation_report_not_found', 'messages', 'Operation Report not found', 'active', NULL, NULL, '2025-06-21 00:42:40', '2025-06-21 00:42:40'),
(2031, '9f34afc4-f2e1-4ac4-8115-8f0e05110d50', 1, 3, NULL, 'flash.package_not_found', 'messages', 'Package not found', 'active', NULL, NULL, '2025-06-21 00:42:40', '2025-06-21 00:42:40'),
(2032, '9f34afc4-f57a-4172-b18b-d5aaf62f8b1c', 1, 3, NULL, 'flash.pathology_category_not_found', 'messages', 'Pathology Category not found', 'active', NULL, NULL, '2025-06-21 00:42:40', '2025-06-21 00:42:40'),
(2033, '9f34afc4-f828-4ad2-b959-5c5723bcdbc2', 1, 3, NULL, 'flash.pathology_test_not_found', 'messages', 'Pathology Test not found', 'active', NULL, NULL, '2025-06-21 00:42:40', '2025-06-21 00:42:40'),
(2034, '9f34afc4-fad8-427b-8d36-fde9f5a7f8f4', 1, 3, NULL, 'flash.patient_admission_not_found', 'messages', 'Patient Admission not found', 'active', NULL, NULL, '2025-06-21 00:42:40', '2025-06-21 00:42:40'),
(2035, '9f34afc4-fd93-4780-bfa8-9744f8d4935d', 1, 3, NULL, 'flash.patient_case_not_found', 'messages', 'Patient Case not found', 'active', NULL, NULL, '2025-06-21 00:42:40', '2025-06-21 00:42:40'),
(2036, '9f34afc5-002a-4623-b919-4dd5d5ba5589', 1, 3, NULL, 'flash.patient_not_found', 'messages', 'Patient not found', 'active', NULL, NULL, '2025-06-21 00:42:40', '2025-06-21 00:42:40'),
(2037, '9f34afc5-02c5-4dde-91e3-255f07b3ac15', 1, 3, NULL, 'flash.diagnosis_test_not_found', 'messages', 'Diagnosis Test not found', 'active', NULL, NULL, '2025-06-21 00:42:40', '2025-06-21 00:42:40'),
(2038, '9f34afc5-0568-4d54-854f-40c7e6c0d153', 1, 3, NULL, 'flash.pharmacist_not_found', 'messages', 'Pharmacist not found', 'active', NULL, NULL, '2025-06-21 00:42:40', '2025-06-21 00:42:40'),
(2039, '9f34afc5-07ff-4df3-9410-e1fda951a4b9', 1, 3, NULL, 'flash.postal_not_found', 'messages', 'Postal not found', 'active', NULL, NULL, '2025-06-21 00:42:40', '2025-06-21 00:42:40'),
(2040, '9f34afc5-0ab5-40a9-8987-259e8a1efe80', 1, 3, NULL, 'flash.radiology_category_not_found', 'messages', 'Radiology Category not found', 'active', NULL, NULL, '2025-06-21 00:42:40', '2025-06-21 00:42:40'),
(2041, '9f34afc5-0d69-427c-a395-ac12cf2ce77c', 1, 3, NULL, 'flash.radiology_test_not_found', 'messages', 'Radiology Test not found', 'active', NULL, NULL, '2025-06-21 00:42:40', '2025-06-21 00:42:40'),
(2042, '9f34afc5-100e-4965-b59b-43596d16ab84', 1, 3, NULL, 'flash.receptionist__not_found', 'messages', 'Receptionist__not_found not found', 'active', NULL, NULL, '2025-06-21 00:42:40', '2025-06-21 00:42:40'),
(2043, '9f34afc5-12bc-498c-bc02-6efda4df8816', 1, 3, NULL, 'flash.schedule_not_found', 'messages', 'Schedule not found', 'active', NULL, NULL, '2025-06-21 00:42:40', '2025-06-21 00:42:40'),
(2044, '9f34afc5-1551-44d5-a21f-b5d9ad1b14c3', 1, 3, NULL, 'flash.sms_not_found', 'messages', 'Sms not found', 'active', NULL, NULL, '2025-06-21 00:42:40', '2025-06-21 00:42:40'),
(2045, '9f34afc5-17ea-473d-937d-d41ea0e83696', 1, 3, NULL, 'flash.user_not_found', 'messages', 'User not found', 'active', NULL, NULL, '2025-06-21 00:42:40', '2025-06-21 00:42:40'),
(2046, '9f34afc5-1aa0-4f41-ac5b-aeb72df9258d', 1, 3, NULL, 'flash.vaccinated_patient_not_found', 'messages', 'Vaccinated Patient not found', 'active', NULL, NULL, '2025-06-21 00:42:40', '2025-06-21 00:42:40'),
(2047, '9f34afc5-1d2f-4c86-a9d4-13bde166fa9e', 1, 3, NULL, 'flash.vaccination_not_found', 'messages', 'Vaccination not found', 'active', NULL, NULL, '2025-06-21 00:42:40', '2025-06-21 00:42:40'),
(2048, '9f34afc5-1fe5-4562-91fe-a4d63f928e8d', 1, 3, NULL, 'flash.visitor_not_found', 'messages', 'Visitor not found', 'active', NULL, NULL, '2025-06-21 00:42:40', '2025-06-21 00:42:40'),
(2049, '9f34afc5-226e-407e-8fce-2df77dce84b0', 1, 3, NULL, 'flash.testimonial_not_found', 'messages', 'Testimonial not found', 'active', NULL, NULL, '2025-06-21 00:42:40', '2025-06-21 00:42:40'),
(2050, '9f34afc5-2521-4276-8e88-f9a56363ca7f', 1, 3, NULL, 'flash.accountant_save', 'messages', 'Accountant saved successfully.', 'active', NULL, NULL, '2025-06-21 00:42:40', '2025-06-21 00:42:40'),
(2051, '9f34afc5-27bd-4f0f-9b95-bdc008aa044d', 1, 3, NULL, 'flash.accountant_update', 'messages', 'Accountant updated successfully.', 'active', NULL, NULL, '2025-06-21 00:42:40', '2025-06-21 00:42:40'),
(2052, '9f34afc5-2a7c-4742-bd65-5aee774b5842', 1, 3, NULL, 'flash.accountant_cant_delete', 'messages', 'Accountant can\'t be deleted.', 'active', NULL, NULL, '2025-06-21 00:42:40', '2025-06-21 00:42:40'),
(2053, '9f34afc5-2d1d-4401-bf3b-bf34f728d539', 1, 3, NULL, 'flash.accountant_delete', 'messages', 'Accountant deleted successfully.', 'active', NULL, NULL, '2025-06-21 00:42:40', '2025-06-21 00:42:40'),
(2054, '9f34afc5-2faf-4c2c-bbaf-80d971ccb98b', 1, 3, NULL, 'flash.account_save', 'messages', 'Account saved successfully.', 'active', NULL, NULL, '2025-06-21 00:42:40', '2025-06-21 00:42:40'),
(2055, '9f34afc5-325b-4de5-9d89-1421f23f8e49', 1, 3, NULL, 'flash.account_retrieved', 'messages', 'Account retrieved successfully.', 'active', NULL, NULL, '2025-06-21 00:42:40', '2025-06-21 00:42:40'),
(2056, '9f34afc5-350d-45b3-b9ac-7efb1ebd6fae', 1, 3, NULL, 'flash.account_cant_delete', 'messages', 'Account can\'t be deleted.', 'active', NULL, NULL, '2025-06-21 00:42:40', '2025-06-21 00:42:40'),
(2057, '9f34afc5-37cd-48ee-9705-2d82edfd0eec', 1, 3, NULL, 'flash.account_delete', 'messages', 'Account deleted successfully.', 'active', NULL, NULL, '2025-06-21 00:42:40', '2025-06-21 00:42:40'),
(2058, '9f34afc5-3a7a-478f-9938-ad475aa84b3c', 1, 3, NULL, 'flash.account_update', 'messages', 'Account updated successfully.', 'active', NULL, NULL, '2025-06-21 00:42:40', '2025-06-21 00:42:40'),
(2059, '9f34afc5-3d0f-4225-ba86-85f72251b7f2', 1, 3, NULL, 'flash.advanced_payment_save', 'messages', 'Advanced Payment saved successfully.', 'active', NULL, NULL, '2025-06-21 00:42:40', '2025-06-21 00:42:40'),
(2060, '9f34afc5-3fbe-42f2-9c39-ab9d556ee650', 1, 3, NULL, 'flash.advanced_payment_not', 'messages', 'Advanced Payment not found', 'active', NULL, NULL, '2025-06-21 00:42:40', '2025-06-21 00:42:40'),
(2061, '9f34afc5-43a5-4d09-b05d-692b570c315b', 1, 3, NULL, 'flash.advanced_payment_retrieve', 'messages', 'Advanced Payment retrieved successfully.', 'active', NULL, NULL, '2025-06-21 00:42:40', '2025-06-21 00:42:40'),
(2062, '9f34afc5-4678-476c-a6a2-dbdb258490af', 1, 3, NULL, 'flash.advanced_payment_updated', 'messages', 'Advanced Payment updated successfully.', 'active', NULL, NULL, '2025-06-21 00:42:40', '2025-06-21 00:42:40'),
(2063, '9f34afc5-490d-4fb5-90ad-ab830d5eb805', 1, 3, NULL, 'flash.advanced_payment_deleted', 'messages', 'AdvancedPayment deleted successfully.', 'active', NULL, NULL, '2025-06-21 00:42:40', '2025-06-21 00:42:40'),
(2064, '9f34afc5-4bb9-46f8-8448-d1b109211c42', 1, 3, NULL, 'flash.ambulance_call_saved', 'messages', 'Ambulance Call saved successfully.', 'active', NULL, NULL, '2025-06-21 00:42:40', '2025-06-21 00:42:40'),
(2065, '9f34afc5-4e5f-4e75-8b72-78e2526e9818', 1, 3, NULL, 'flash.ambulance_call_updated', 'messages', 'Ambulance Call updated successfully.', 'active', NULL, NULL, '2025-06-21 00:42:40', '2025-06-21 00:42:40'),
(2066, '9f34afc5-511a-478a-8fe4-f04f27eed81c', 1, 3, NULL, 'flash.ambulance_call_deleted', 'messages', 'Ambulance Call deleted successfully.', 'active', NULL, NULL, '2025-06-21 00:42:40', '2025-06-21 00:42:40'),
(2067, '9f34afc5-53d9-4f14-8f2c-588258567878', 1, 3, NULL, 'flash.driver_not_found', 'messages', 'Driver name not found', 'active', NULL, NULL, '2025-06-21 00:42:40', '2025-06-21 00:42:40'),
(2068, '9f34afc5-5666-40b9-befc-4f91b9241e77', 1, 3, NULL, 'flash.driver_retrieved', 'messages', 'Driver name retrieved successful', 'active', NULL, NULL, '2025-06-21 00:42:40', '2025-06-21 00:42:40'),
(2069, '9f34afc5-5900-48dc-b280-650f090ebed2', 1, 3, NULL, 'flash.ambulance_saved', 'messages', 'Ambulance saved successfully.', 'active', NULL, NULL, '2025-06-21 00:42:40', '2025-06-21 00:42:40'),
(2070, '9f34afc5-5b9d-4384-85d5-221c83ee9c61', 1, 3, NULL, 'flash.ambulance_update', 'messages', 'Ambulance updated successfully.', 'active', NULL, NULL, '2025-06-21 00:42:40', '2025-06-21 00:42:40'),
(2071, '9f34afc5-5e62-479f-8646-b03963a1970e', 1, 3, NULL, 'flash.ambulance_cant_delete', 'messages', 'Ambulance can\'t be deleted.', 'active', NULL, NULL, '2025-06-21 00:42:40', '2025-06-21 00:42:40'),
(2072, '9f34afc5-60f9-4848-99f8-e2eff25b33f0', 1, 3, NULL, 'flash.ambulance_delete', 'messages', 'Ambulance deleted successfully.', 'active', NULL, NULL, '2025-06-21 00:42:40', '2025-06-21 00:42:40'),
(2073, '9f34afc5-63b7-4c8d-9341-b9943e66bc78', 1, 3, NULL, 'flash.appointment_list_retrieved', 'messages', 'Appointment list retrieved successfully.', 'active', NULL, NULL, '2025-06-21 00:42:40', '2025-06-21 00:42:40'),
(2074, '9f34afc5-6657-4234-9ae4-d5ec43114baf', 1, 3, NULL, 'flash.appointment_retrieved', 'messages', 'Appointment Retrieved Successfully.', 'active', NULL, NULL, '2025-06-21 00:42:40', '2025-06-21 00:42:40'),
(2075, '9f34afc5-690b-4caa-bba9-faafc7f9f063', 1, 3, NULL, 'flash.appointment_not_found', 'messages', 'Appointment not found', 'active', NULL, NULL, '2025-06-21 00:42:40', '2025-06-21 00:42:40'),
(2076, '9f34afc5-6bc3-4d4f-9d2c-67b64da7267e', 1, 3, NULL, 'flash.date_smaller', 'messages', 'Date should not be smaller than patient birth date.', 'active', NULL, NULL, '2025-06-21 00:42:40', '2025-06-21 00:42:40'),
(2077, '9f34afc5-6e92-4ac2-8aeb-ecda0126c79a', 1, 3, NULL, 'flash.assign_date_smaller', 'messages', 'Assign date should not be smaller than patient birth date.', 'active', NULL, NULL, '2025-06-21 00:42:40', '2025-06-21 00:42:40'),
(2078, '9f34afc5-7122-4e7e-8e84-4be0cac7e78d', 1, 3, NULL, 'flash.admission_date_smaller', 'messages', 'Admission date should not be smaller than patient birth date.', 'active', NULL, NULL, '2025-06-21 00:42:40', '2025-06-21 00:42:40'),
(2079, '9f34afc5-73de-46d2-82ec-7349bac84aaa', 1, 3, NULL, 'flash.case_date_smaller', 'messages', 'Case date should not be smaller than patient birth date.', 'active', NULL, NULL, '2025-06-21 00:42:40', '2025-06-21 00:42:40'),
(2080, '9f34afc5-76a4-439d-8c99-4f9a07cab0e0', 1, 3, NULL, 'flash.investigation_date_smaller', 'messages', 'Investigation report date should not be smaller than patient birth date.', 'active', NULL, NULL, '2025-06-21 00:42:40', '2025-06-21 00:42:40'),
(2081, '9f34afc5-793a-49c3-a807-631500c4bb4b', 1, 3, NULL, 'flash.bill_date_smaller', 'messages', 'Bill date should not be smaller than patient birth date.', 'active', NULL, NULL, '2025-06-21 00:42:40', '2025-06-21 00:42:40'),
(2082, '9f34afc5-7be3-43e5-9ab4-78726083768d', 1, 3, NULL, 'flash.cant_create', 'messages', 'Can\'t create report because the patient has been dead.', 'active', NULL, NULL, '2025-06-21 00:42:40', '2025-06-21 00:42:40'),
(2083, '9f34afc5-7e71-4e62-9012-928087194063', 1, 3, NULL, 'flash.appointment_created', 'messages', 'Appointment created successfully.', 'active', NULL, NULL, '2025-06-21 00:42:40', '2025-06-21 00:42:40'),
(2084, '9f34afc5-8116-42f6-9f6c-a5347d5f0b78', 1, 3, NULL, 'flash.appointment_delete', 'messages', 'Appointment deleted successfully.', 'active', NULL, NULL, '2025-06-21 00:42:40', '2025-06-21 00:42:40'),
(2085, '9f34afc5-83d3-4e0d-889c-47c3d0b4b0f4', 1, 3, NULL, 'flash.appointment_cancel', 'messages', 'Appointment cancelled successfully.', 'active', NULL, NULL, '2025-06-21 00:42:40', '2025-06-21 00:42:40'),
(2086, '9f34afc5-8693-4142-b186-1ef5a4f9b9a3', 1, 3, NULL, 'flash.appointment_booked', 'messages', 'Appointment Booked successfully', 'active', NULL, NULL, '2025-06-21 00:42:40', '2025-06-21 00:42:40'),
(2087, '9f34afc5-892a-4c67-a9e2-828460b65a0a', 1, 3, NULL, 'flash.appointment_saved', 'messages', 'Appointment saved successfully.', 'active', NULL, NULL, '2025-06-21 00:42:40', '2025-06-21 00:42:40'),
(2088, '9f34afc5-8bcd-4524-8d96-7db4db8f2cb6', 1, 3, NULL, 'flash.appointment_updated', 'messages', 'Appointment updated successfully.', 'active', NULL, NULL, '2025-06-21 00:42:40', '2025-06-21 00:42:40'),
(2089, '9f34afc5-8e60-423b-a936-0075f91a2c7f', 1, 3, NULL, 'flash.appointment_charge_must_be_greater_than_570', 'messages', 'Appointment Charge must be greater than 570', 'active', NULL, NULL, '2025-06-21 00:42:40', '2025-06-21 00:42:40'),
(2090, '9f34afc5-9102-4ed3-b24e-ce68d02addf5', 1, 3, NULL, 'flash.appointment_approved_successfully', 'messages', 'Appointment Approved Successfully', 'active', NULL, NULL, '2025-06-21 00:42:40', '2025-06-21 00:42:40'),
(2091, '9f34afc5-93a9-4c9f-b68f-12d33e009bf0', 1, 3, NULL, 'flash.appointment_cancelled_successfully', 'messages', 'Appointment Cancelled Successfully', 'active', NULL, NULL, '2025-06-21 00:42:40', '2025-06-21 00:42:40'),
(2092, '9f34afc5-964d-4607-a338-813e042a8f4d', 1, 3, NULL, 'flash.retrieve', 'messages', 'Retrieved successfully', 'active', NULL, NULL, '2025-06-21 00:42:40', '2025-06-21 00:42:40'),
(2093, '9f34afc5-98e5-4494-a2e2-f66a04413d87', 1, 3, NULL, 'flash.bed_assign_save', 'messages', 'Bed Assign saved successfully.', 'active', NULL, NULL, '2025-06-21 00:42:40', '2025-06-21 00:42:40'),
(2094, '9f34afc5-9b92-4f6f-953e-6a5f26b779e8', 1, 3, NULL, 'flash.bed_assign_update', 'messages', 'Bed Assign updated successfully.', 'active', NULL, NULL, '2025-06-21 00:42:40', '2025-06-21 00:42:40'),
(2095, '9f34afc5-9e5e-4e63-86c4-29d5a5b004a9', 1, 3, NULL, 'flash.bed_assign_delete', 'messages', 'Bed Assign deleted successfully.', 'active', NULL, NULL, '2025-06-21 00:42:40', '2025-06-21 00:42:40'),
(2096, '9f34afc5-a119-4551-ae07-266c6914f7b4', 1, 3, NULL, 'flash.bed_saved', 'messages', 'Bed saved successfully.', 'active', NULL, NULL, '2025-06-21 00:42:40', '2025-06-21 00:42:40'),
(2097, '9f34afc5-a3d0-4e7c-91d3-a035ef276ead', 1, 3, NULL, 'flash.beds_saved', 'messages', 'Beds saved successfully.', 'active', NULL, NULL, '2025-06-21 00:42:40', '2025-06-21 00:42:40'),
(2098, '9f34afc5-a690-4301-ad27-1ebcd73fe471', 1, 3, NULL, 'flash.bed_retrieved', 'messages', 'Bed retrieved successfully.', 'active', NULL, NULL, '2025-06-21 00:42:40', '2025-06-21 00:42:40'),
(2099, '9f34afc5-a934-437a-81cd-21d16ff94056', 1, 3, NULL, 'flash.bed_updated', 'messages', 'Bed updated successfully.', 'active', NULL, NULL, '2025-06-21 00:42:40', '2025-06-21 00:42:40'),
(2100, '9f34afc5-abda-4115-8395-f87e650c30e7', 1, 3, NULL, 'flash.bed_cant_deleted', 'messages', 'Bed can\'t be deleted.', 'active', NULL, NULL, '2025-06-21 00:42:40', '2025-06-21 00:42:40'),
(2101, '9f34afc5-aeb4-4441-829d-463995d62489', 1, 3, NULL, 'flash.bed_deleted', 'messages', 'Bed deleted successfully.', 'active', NULL, NULL, '2025-06-21 00:42:40', '2025-06-21 00:42:40'),
(2102, '9f34afc5-b15f-430b-a13f-d02e74a18fca', 1, 3, NULL, 'flash.bed_type_retrieved', 'messages', 'Bed Type retrieved successfully.', 'active', NULL, NULL, '2025-06-21 00:42:40', '2025-06-21 00:42:40'),
(2103, '9f34afc5-b426-4f1a-902a-7fc0ccf2f635', 1, 3, NULL, 'flash.bed_type_saved', 'messages', 'Bed Type saved successfully.', 'active', NULL, NULL, '2025-06-21 00:42:40', '2025-06-21 00:42:40'),
(2104, '9f34afc5-b6b3-4d79-b802-01c6f7391123', 1, 3, NULL, 'flash.bed_type_updated', 'messages', 'Bed Type updated successfully.', 'active', NULL, NULL, '2025-06-21 00:42:40', '2025-06-21 00:42:40'),
(2105, '9f34afc5-b95c-4979-9241-4838dd1d098b', 1, 3, NULL, 'flash.bed_type_not_found', 'messages', 'Bed Type not found', 'active', NULL, NULL, '2025-06-21 00:42:40', '2025-06-21 00:42:40'),
(2106, '9f34afc5-bbf6-4912-a857-332471b635c4', 1, 3, NULL, 'flash.bed_type_cant_deleted', 'messages', 'Bed Type can\'t be deleted.', 'active', NULL, NULL, '2025-06-21 00:42:40', '2025-06-21 00:42:40'),
(2107, '9f34afc5-beb3-4e82-8779-b027cd8c50a4', 1, 3, NULL, 'flash.bed_type_deleted', 'messages', 'Bed Type deleted successfully.', 'active', NULL, NULL, '2025-06-21 00:42:40', '2025-06-21 00:42:40'),
(2108, '9f34afc5-c16e-405e-8449-ec24acab28fa', 1, 3, NULL, 'flash.bill_saved', 'messages', 'Bill saved successfully.', 'active', NULL, NULL, '2025-06-21 00:42:40', '2025-06-21 00:42:40'),
(2109, '9f34afc5-c42f-4b09-a9e6-e2473b18cb72', 1, 3, NULL, 'flash.bill_updated', 'messages', 'Bill updated successfully.', 'active', NULL, NULL, '2025-06-21 00:42:40', '2025-06-21 00:42:40'),
(2110, '9f34afc5-c6da-4fb9-8d9f-2f94c12c6f86', 1, 3, NULL, 'flash.bill_deleted', 'messages', 'Bill deleted successfully.', 'active', NULL, NULL, '2025-06-21 00:42:40', '2025-06-21 00:42:40'),
(2111, '9f34afc5-c980-4e23-b40a-be2fdead9d74', 1, 3, NULL, 'flash.bill_retrieved', 'messages', 'Details retrieved successfully.', 'active', NULL, NULL, '2025-06-21 00:42:40', '2025-06-21 00:42:40'),
(2112, '9f34afc5-cc14-4b31-b56f-5a0897cce437', 1, 3, NULL, 'flash.birth_report_saved', 'messages', 'Birth Report saved successfully.', 'active', NULL, NULL, '2025-06-21 00:42:40', '2025-06-21 00:42:40'),
(2113, '9f34afc5-ceca-4dc0-bd71-40aa6f55aeca', 1, 3, NULL, 'flash.birth_report_updated', 'messages', 'Birth Report updated successfully.', 'active', NULL, NULL, '2025-06-21 00:42:40', '2025-06-21 00:42:40'),
(2114, '9f34afc5-d164-4397-8b24-5136f9050789', 1, 3, NULL, 'flash.birth_report_retrieved', 'messages', 'Birth Report retrieved successfully.', 'active', NULL, NULL, '2025-06-21 00:42:40', '2025-06-21 00:42:40'),
(2115, '9f34afc5-d40c-4523-87f4-c163157d6844', 1, 3, NULL, 'flash.birth_report_deleted', 'messages', 'Birth Report deleted successfully.', 'active', NULL, NULL, '2025-06-21 00:42:40', '2025-06-21 00:42:40'),
(2116, '9f34afc5-d6c9-4e7a-894f-716b42ae7c98', 1, 3, NULL, 'flash.blood_group_saved', 'messages', 'Blood group saved successfully.', 'active', NULL, NULL, '2025-06-21 00:42:40', '2025-06-21 00:42:40'),
(2117, '9f34afc5-d96f-4fb7-9a2d-d9ae4a93491a', 1, 3, NULL, 'flash.blood_group_updated', 'messages', 'Blood group updated successfully.', 'active', NULL, NULL, '2025-06-21 00:42:40', '2025-06-21 00:42:40'),
(2118, '9f34afc5-dc24-4746-b51b-00615ce19fad', 1, 3, NULL, 'flash.blood_bank_retrieved', 'messages', 'Blood Bank retrieved successfully.', 'active', NULL, NULL, '2025-06-21 00:42:40', '2025-06-21 00:42:40'),
(2119, '9f34afc5-deb9-4320-8803-5467f2e618cb', 1, 3, NULL, 'flash.blood_bank_cant_deleted', 'messages', 'Blood Bank can\'t be deleted.', 'active', NULL, NULL, '2025-06-21 00:42:40', '2025-06-21 00:42:40'),
(2120, '9f34afc5-e173-4693-b66f-bdc1e03dcac5', 1, 3, NULL, 'flash.blood_bank_updated', 'messages', 'Blood bank updated successfully.', 'active', NULL, NULL, '2025-06-21 00:42:40', '2025-06-21 00:42:40'),
(2121, '9f34afc5-e415-4d18-b6b4-b0215dafe19f', 1, 3, NULL, 'flash.blood_bank_deleted', 'messages', 'Blood Bank deleted successfully.', 'active', NULL, NULL, '2025-06-21 00:42:40', '2025-06-21 00:42:40'),
(2122, '9f34afc5-e6e7-4de7-9dce-f4bc4638b716', 1, 3, NULL, 'flash.blood_donation_saved', 'messages', 'Blood Donation saved successfully.', 'active', NULL, NULL, '2025-06-21 00:42:40', '2025-06-21 00:42:40'),
(2123, '9f34afc5-e9a3-4d9a-b681-f0cbfcf5cd20', 1, 3, NULL, 'flash.blood_donation_retrieved', 'messages', 'Blood Donation retrieved successfully.', 'active', NULL, NULL, '2025-06-21 00:42:40', '2025-06-21 00:42:40'),
(2124, '9f34afc5-ec74-4321-9087-250035a0299c', 1, 3, NULL, 'flash.blood_donation_updated', 'messages', 'Blood Donation updated successfully.', 'active', NULL, NULL, '2025-06-21 00:42:40', '2025-06-21 00:42:40'),
(2125, '9f34afc5-ef90-457d-b7fc-8ccf1e178a89', 1, 3, NULL, 'flash.blood_donation_deleted', 'messages', 'Blood Donation deleted successfully.', 'active', NULL, NULL, '2025-06-21 00:42:41', '2025-06-21 00:42:41'),
(2126, '9f34afc5-f269-4b39-a64c-1956b8c7dcd6', 1, 3, NULL, 'flash.blood_donor_saved', 'messages', 'Blood Donor saved successfully.', 'active', NULL, NULL, '2025-06-21 00:42:41', '2025-06-21 00:42:41'),
(2127, '9f34afc5-f557-4374-8e52-c28bf36eaf35', 1, 3, NULL, 'flash.blood_donor_retrieved', 'messages', 'Blood Donor retrieved successfully.', 'active', NULL, NULL, '2025-06-21 00:42:41', '2025-06-21 00:42:41'),
(2128, '9f34afc5-f823-4543-9689-053d14531895', 1, 3, NULL, 'flash.blood_donor_updated', 'messages', 'Blood Donor updated successfully.', 'active', NULL, NULL, '2025-06-21 00:42:41', '2025-06-21 00:42:41'),
(2129, '9f34afc5-fb09-4692-9e02-f012bab79fe2', 1, 3, NULL, 'flash.blood_donor_cant_delete', 'messages', 'Blood Donor can\'t be deleted.', 'active', NULL, NULL, '2025-06-21 00:42:41', '2025-06-21 00:42:41'),
(2130, '9f34afc5-fdf9-456b-9ed1-1f6d26fa5f92', 1, 3, NULL, 'flash.blood_donor_delete', 'messages', 'Blood Donor deleted successfully.', 'active', NULL, NULL, '2025-06-21 00:42:41', '2025-06-21 00:42:41'),
(2131, '9f34afc6-00e1-4339-8ca5-81bb256a36f7', 1, 3, NULL, 'flash.blood_issue_saved', 'messages', 'Blood Issue saved successfully.', 'active', NULL, NULL, '2025-06-21 00:42:41', '2025-06-21 00:42:41'),
(2132, '9f34afc6-03d3-41da-9ef1-e8a32b99fe79', 1, 3, NULL, 'flash.blood_issue_updated', 'messages', 'Blood Issue updated successfully.', 'active', NULL, NULL, '2025-06-21 00:42:41', '2025-06-21 00:42:41'),
(2133, '9f34afc6-06bf-4ef5-9e88-636c2ed25b6d', 1, 3, NULL, 'flash.blood_issue_retrieved', 'messages', 'Blood Issue retrieved successfully.', 'active', NULL, NULL, '2025-06-21 00:42:41', '2025-06-21 00:42:41'),
(2134, '9f34afc6-09aa-4896-ba32-b85eaa86728b', 1, 3, NULL, 'flash.blood_issue_deleted', 'messages', 'Blood Issue deleted successfully.', 'active', NULL, NULL, '2025-06-21 00:42:41', '2025-06-21 00:42:41'),
(2135, '9f34afc6-0c82-4df4-bff9-16eeb41991b7', 1, 3, NULL, 'flash.blood_group_retrieved', 'messages', 'Blood Group retrieved successfully.', 'active', NULL, NULL, '2025-06-21 00:42:41', '2025-06-21 00:42:41'),
(2136, '9f34afc6-0fa3-4fd4-9d83-ff52efefdb64', 1, 3, NULL, 'flash.medicine_brand_saved', 'messages', 'Medicine brand saved successfully.', 'active', NULL, NULL, '2025-06-21 00:42:41', '2025-06-21 00:42:41'),
(2137, '9f34afc6-1268-48fb-8313-4476800a93fe', 1, 3, NULL, 'flash.medicine_brand_updated', 'messages', 'Medicine brand updated successfully.', 'active', NULL, NULL, '2025-06-21 00:42:41', '2025-06-21 00:42:41'),
(2138, '9f34afc6-155c-4781-95ea-429c1858a1dd', 1, 3, NULL, 'flash.medicine_brand_cant_deleted', 'messages', 'Medicine brand can\'t be deleted.', 'active', NULL, NULL, '2025-06-21 00:42:41', '2025-06-21 00:42:41'),
(2139, '9f34afc6-1849-4deb-8de7-45ba7975f285', 1, 3, NULL, 'flash.medicine_brand_deleted', 'messages', 'Medicine brand deleted successfully.', 'active', NULL, NULL, '2025-06-21 00:42:41', '2025-06-21 00:42:41'),
(2140, '9f34afc6-1b2b-4265-a6f9-778952863880', 1, 3, NULL, 'flash.call_log_saved', 'messages', 'Call Log saved successfully.', 'active', NULL, NULL, '2025-06-21 00:42:41', '2025-06-21 00:42:41'),
(2141, '9f34afc6-1fab-4e05-ada5-f8989e282a52', 1, 3, NULL, 'flash.call_log_updated', 'messages', 'Call Log updated successfully.', 'active', NULL, NULL, '2025-06-21 00:42:41', '2025-06-21 00:42:41'),
(2142, '9f34afc6-229b-4e45-9b90-90836b821c10', 1, 3, NULL, 'flash.call_log_deleted', 'messages', 'Call Log deleted successfully.', 'active', NULL, NULL, '2025-06-21 00:42:41', '2025-06-21 00:42:41'),
(2143, '9f34afc6-2580-49f6-ac9b-90cad49dd10c', 1, 3, NULL, 'flash.case_handler_saved', 'messages', 'Case Handler saved successfully.', 'active', NULL, NULL, '2025-06-21 00:42:41', '2025-06-21 00:42:41'),
(2144, '9f34afc6-299a-4c46-bb7b-cf64f4c96474', 1, 3, NULL, 'flash.case_handler_updated', 'messages', 'Case Handler updated successfully.', 'active', NULL, NULL, '2025-06-21 00:42:41', '2025-06-21 00:42:41'),
(2145, '9f34afc6-2c6c-45af-aebf-09a0bd141a1f', 1, 3, NULL, 'flash.case_handler_cant_deleted', 'messages', 'Case Handler can\'t be deleted.', 'active', NULL, NULL, '2025-06-21 00:42:41', '2025-06-21 00:42:41'),
(2146, '9f34afc6-2f3e-4e8c-a680-ad9048c282cb', 1, 3, NULL, 'flash.case_handler_deleted', 'messages', 'Case Handler deleted successfully.', 'active', NULL, NULL, '2025-06-21 00:42:41', '2025-06-21 00:42:41'),
(2147, '9f34afc6-321e-443e-bfeb-a40f5b3e01e1', 1, 3, NULL, 'flash.notification_read', 'messages', 'Notification read successfully.', 'active', NULL, NULL, '2025-06-21 00:42:41', '2025-06-21 00:42:41'),
(2148, '9f34afc6-34f8-4341-8c14-79ad27dbeddf', 1, 3, NULL, 'flash.all_notification_read', 'messages', 'All Notification read successfully.', 'active', NULL, NULL, '2025-06-21 00:42:41', '2025-06-21 00:42:41'),
(2149, '9f34afc6-37ec-43ed-9721-ada4122041f8', 1, 3, NULL, 'flash.request_pending', 'messages', 'Your Manual Transaction Requests pending.', 'active', NULL, NULL, '2025-06-21 00:42:41', '2025-06-21 00:42:41'),
(2150, '9f34afc6-3ae8-430c-b108-1821a0f80ef7', 1, 3, NULL, 'flash.manual_payment_approved', 'messages', 'Manual Payment Approved successfully.', 'active', NULL, NULL, '2025-06-21 00:42:41', '2025-06-21 00:42:41'),
(2151, '9f34afc6-3dbd-46a8-8737-c2d4fb672849', 1, 3, NULL, 'flash.manual_payment_denied', 'messages', 'Manual Payment Denied successfully.', 'active', NULL, NULL, '2025-06-21 00:42:41', '2025-06-21 00:42:41'),
(2152, '9f34afc6-4b24-49f7-9565-ea63ceb02d2a', 1, 3, NULL, 'flash.payment_gateway_updated', 'messages', 'Payment gateway updated successfully.', 'active', NULL, NULL, '2025-06-21 00:42:41', '2025-06-21 00:42:41'),
(2153, '9f34afc6-4e37-40ba-a3d9-329a630bbc98', 1, 3, NULL, 'flash.payment_saved', 'messages', 'Payment saved successfully.', 'active', NULL, NULL, '2025-06-21 00:42:41', '2025-06-21 00:42:41'),
(2154, '9f34afc6-5125-4f1f-acc7-b478e7b80a27', 1, 3, NULL, 'flash.payment_updated', 'messages', 'Payment updated successfully.', 'active', NULL, NULL, '2025-06-21 00:42:41', '2025-06-21 00:42:41'),
(2155, '9f34afc6-53e0-4df6-bfe0-0eed198e4962', 1, 3, NULL, 'flash.payment_deleted', 'messages', 'Payment deleted successfully.', 'active', NULL, NULL, '2025-06-21 00:42:41', '2025-06-21 00:42:41'),
(2156, '9f34afc6-56ae-4fcb-80e7-52378732d4d5', 1, 3, NULL, 'flash.payment_retrieved', 'messages', 'Payment retrieved successfully.', 'active', NULL, NULL, '2025-06-21 00:42:41', '2025-06-21 00:42:41'),
(2157, '9f34afc6-597a-4b1a-b479-33b38a88149e', 1, 3, NULL, 'flash.medicine_saved', 'messages', 'Medicine saved successfully.', 'active', NULL, NULL, '2025-06-21 00:42:41', '2025-06-21 00:42:41'),
(2158, '9f34afc6-5c4f-4f56-a9fa-127633ccc75d', 1, 3, NULL, 'flash.medicine_updated', 'messages', 'Medicine updated successfully.', 'active', NULL, NULL, '2025-06-21 00:42:41', '2025-06-21 00:42:41'),
(2159, '9f34afc6-5f5d-4624-a111-d3ffffcdcc91', 1, 3, NULL, 'flash.medicine_deleted', 'messages', 'Medicine deleted successfully.', 'active', NULL, NULL, '2025-06-21 00:42:41', '2025-06-21 00:42:41'),
(2160, '9f34afc6-6242-4501-b008-f6e8cecf8d61', 1, 3, NULL, 'flash.medicine_retrieved', 'messages', 'Medicine retrieved successfully.', 'active', NULL, NULL, '2025-06-21 00:42:41', '2025-06-21 00:42:41'),
(2161, '9f34afc6-652f-4adb-8d6f-284c666468a3', 1, 3, NULL, 'flash.pathology_test_saved', 'messages', 'Pathology Test saved successfully.', 'active', NULL, NULL, '2025-06-21 00:42:41', '2025-06-21 00:42:41'),
(2162, '9f34afc6-683c-41cb-adf1-882b2aeb4f77', 1, 3, NULL, 'flash.pathology_test_updated', 'messages', 'Pathology Test updated successfully.', 'active', NULL, NULL, '2025-06-21 00:42:41', '2025-06-21 00:42:41'),
(2163, '9f34afc6-6b5b-4070-8372-c6abe30b5fc7', 1, 3, NULL, 'flash.pathology_test_deleted', 'messages', 'Pathology Test deleted successfully.', 'active', NULL, NULL, '2025-06-21 00:42:41', '2025-06-21 00:42:41'),
(2164, '9f34afc6-6e23-4927-bd28-5993dae4fa36', 1, 3, NULL, 'flash.pathology_test_retrieved', 'messages', 'Pathology Test retrieved successfully.', 'active', NULL, NULL, '2025-06-21 00:42:41', '2025-06-21 00:42:41'),
(2165, '9f34afc6-711f-499d-a10c-c5498fb7e55b', 1, 3, NULL, 'flash.patient_admission_saved', 'messages', 'Patient Admission saved successfully.', 'active', NULL, NULL, '2025-06-21 00:42:41', '2025-06-21 00:42:41'),
(2166, '9f34afc6-73f9-4aeb-a159-b91c55a2fdbc', 1, 3, NULL, 'flash.patient_admission_updated', 'messages', 'Patient Admission updated successfully.', 'active', NULL, NULL, '2025-06-21 00:42:41', '2025-06-21 00:42:41'),
(2167, '9f34afc6-76e3-46f5-a976-b71cb96354cd', 1, 3, NULL, 'flash.patient_admission_cant_deleted', 'messages', 'Patient Admission can\'t be deleted.', 'active', NULL, NULL, '2025-06-21 00:42:41', '2025-06-21 00:42:41'),
(2168, '9f34afc6-79c1-45fe-954b-023bb13f05ec', 1, 3, NULL, 'flash.patient_admission_deleted', 'messages', 'Patient Admission deleted successfully.', 'active', NULL, NULL, '2025-06-21 00:42:41', '2025-06-21 00:42:41'),
(2169, '9f34afc6-7c80-472f-a5b4-28ca1196acc0', 1, 3, NULL, 'flash.patient_admission_retrieved', 'messages', 'Patient Admission retrieved successfully.', 'active', NULL, NULL, '2025-06-21 00:42:41', '2025-06-21 00:42:41'),
(2170, '9f34afc6-7f7d-486c-a7e5-ccb9f18e25f0', 1, 3, NULL, 'flash.Patient_saved', 'messages', 'Patient saved successfully.', 'active', NULL, NULL, '2025-06-21 00:42:41', '2025-06-21 00:42:41'),
(2171, '9f34afc6-8266-414c-971b-fb41db374fa0', 1, 3, NULL, 'flash.Patient_updated', 'messages', 'Patient updated successfully.', 'active', NULL, NULL, '2025-06-21 00:42:41', '2025-06-21 00:42:41'),
(2172, '9f34afc6-8537-4f23-9ab9-d7a65e7c7383', 1, 3, NULL, 'flash.Patient_cant_deleted', 'messages', 'Patient can\'t be deleted.', 'active', NULL, NULL, '2025-06-21 00:42:41', '2025-06-21 00:42:41'),
(2173, '9f34afc6-8808-4632-aeab-92d819649a8e', 1, 3, NULL, 'flash.Patient_deleted', 'messages', 'Patient deleted successfully.', 'active', NULL, NULL, '2025-06-21 00:42:41', '2025-06-21 00:42:41'),
(2174, '9f34afc6-8adc-4379-977b-005f07958a4c', 1, 3, NULL, 'flash.case_saved', 'messages', 'Case saved successfully.', 'active', NULL, NULL, '2025-06-21 00:42:41', '2025-06-21 00:42:41'),
(2175, '9f34afc6-8da7-4f19-b26d-55d5e60d4014', 1, 3, NULL, 'flash.case_updated', 'messages', 'Case updated successfully.', 'active', NULL, NULL, '2025-06-21 00:42:41', '2025-06-21 00:42:41'),
(2176, '9f34afc6-90bb-4a6b-b28b-2cbae1d08a04', 1, 3, NULL, 'flash.case_cant_deleted', 'messages', 'Case can\'t be deleted.', 'active', NULL, NULL, '2025-06-21 00:42:41', '2025-06-21 00:42:41'),
(2177, '9f34afc6-9386-44d2-af48-a4ec2de24e56', 1, 3, NULL, 'flash.case_deleted', 'messages', 'Case deleted successfully.', 'active', NULL, NULL, '2025-06-21 00:42:41', '2025-06-21 00:42:41'),
(2178, '9f34afc6-9654-457b-8171-4501d5ba5dc6', 1, 3, NULL, 'flash.case_retrieved', 'messages', 'Case retrieved successfully.', 'active', NULL, NULL, '2025-06-21 00:42:41', '2025-06-21 00:42:41'),
(2179, '9f34afc6-9914-44f4-85c4-05e39aa82282', 1, 3, NULL, 'flash.notice_board_saved', 'messages', 'Notice Board saved successfully.', 'active', NULL, NULL, '2025-06-21 00:42:41', '2025-06-21 00:42:41');
INSERT INTO `ltu_phrases` (`id`, `uuid`, `translation_id`, `translation_file_id`, `phrase_id`, `key`, `group`, `value`, `status`, `parameters`, `note`, `created_at`, `updated_at`) VALUES
(2180, '9f34afc6-9be1-48a0-8b52-bcd39da299b0', 1, 3, NULL, 'flash.notice_board_retrieved', 'messages', 'Notice Board retrieved successfully.', 'active', NULL, NULL, '2025-06-21 00:42:41', '2025-06-21 00:42:41'),
(2181, '9f34afc6-9ec5-4993-9dad-52c7d6aa47f9', 1, 3, NULL, 'flash.notice_board_updated', 'messages', 'Notice Board updated successfully.', 'active', NULL, NULL, '2025-06-21 00:42:41', '2025-06-21 00:42:41'),
(2182, '9f34afc6-a1a1-4e67-b94e-7efa045afff8', 1, 3, NULL, 'flash.notice_board_deleted', 'messages', 'Notice Board deleted successfully.', 'active', NULL, NULL, '2025-06-21 00:42:41', '2025-06-21 00:42:41'),
(2183, '9f34afc6-a47d-4a39-9a54-23fe48be6167', 1, 3, NULL, 'flash.medicine_category_saved', 'messages', 'Medicine category saved successfully.', 'active', NULL, NULL, '2025-06-21 00:42:41', '2025-06-21 00:42:41'),
(2184, '9f34afc6-a748-4aa9-a8fd-2d0a2f4c8106', 1, 3, NULL, 'flash.medicine_category_not_found', 'messages', 'Medicine Category not found', 'active', NULL, NULL, '2025-06-21 00:42:41', '2025-06-21 00:42:41'),
(2185, '9f34afc6-aa22-4771-8914-990f22a8a80e', 1, 3, NULL, 'flash.medicine_category_retrieved', 'messages', 'Medicine category retrieved successfully.', 'active', NULL, NULL, '2025-06-21 00:42:41', '2025-06-21 00:42:41'),
(2186, '9f34afc6-acf3-47b2-8363-444f7e9738d7', 1, 3, NULL, 'flash.medicine_category_cant_deleted', 'messages', 'Medicine Category can\'t be deleted.', 'active', NULL, NULL, '2025-06-21 00:42:41', '2025-06-21 00:42:41'),
(2187, '9f34afc6-afde-42f8-9fa8-58b15c654970', 1, 3, NULL, 'flash.medicine_category_deleted', 'messages', 'Medicine category deleted successfully.', 'active', NULL, NULL, '2025-06-21 00:42:41', '2025-06-21 00:42:41'),
(2188, '9f34afc6-b2d5-4326-8860-3ef089255291', 1, 3, NULL, 'flash.medicine_category_updated', 'messages', 'Medicine category updated successfully.', 'active', NULL, NULL, '2025-06-21 00:42:41', '2025-06-21 00:42:41'),
(2189, '9f34afc6-b59f-4dcd-bd51-de90ab6c7f1b', 1, 3, NULL, 'flash.Standard_charge_retrieved', 'messages', 'StandardCharge retrieved successfully.', 'active', NULL, NULL, '2025-06-21 00:42:41', '2025-06-21 00:42:41'),
(2190, '9f34afc6-b8c3-412e-a6a9-741a1d40ea86', 1, 3, NULL, 'flash.charge_saved', 'messages', 'Charge saved successfully.', 'active', NULL, NULL, '2025-06-21 00:42:41', '2025-06-21 00:42:41'),
(2191, '9f34afc6-bb8f-446c-ac72-04de073cf9ce', 1, 3, NULL, 'flash.charge_retrieved', 'messages', 'Charge Retrieved Successfully.', 'active', NULL, NULL, '2025-06-21 00:42:41', '2025-06-21 00:42:41'),
(2192, '9f34afc6-be56-43de-bad3-26cf4c47d461', 1, 3, NULL, 'flash.charge_updated', 'messages', 'Charge updated successfully.', 'active', NULL, NULL, '2025-06-21 00:42:41', '2025-06-21 00:42:41'),
(2193, '9f34afc6-c114-4d82-9cf9-44dddc0f1ca2', 1, 3, NULL, 'flash.charge_deleted', 'messages', 'Charge deleted successfully.', 'active', NULL, NULL, '2025-06-21 00:42:41', '2025-06-21 00:42:41'),
(2194, '9f34afc6-c3cc-4db0-b585-193388af755c', 1, 3, NULL, 'flash.radiology_test_saved', 'messages', 'Radiology Test saved successfully.', 'active', NULL, NULL, '2025-06-21 00:42:41', '2025-06-21 00:42:41'),
(2195, '9f34afc6-c69e-43be-9bea-a926871e68e0', 1, 3, NULL, 'flash.radiology_test_updated', 'messages', 'Radiology Test updated successfully.', 'active', NULL, NULL, '2025-06-21 00:42:41', '2025-06-21 00:42:41'),
(2196, '9f34afc6-c971-4cfc-a983-66c54d688789', 1, 3, NULL, 'flash.radiology_test_deleted', 'messages', 'Radiology Test deleted successfully.', 'active', NULL, NULL, '2025-06-21 00:42:41', '2025-06-21 00:42:41'),
(2197, '9f34afc6-ccee-47b3-87fa-a2e355f1cd58', 1, 3, NULL, 'flash.radiology_test_retrieved', 'messages', 'Radiology Test Retrieved Successfully.', 'active', NULL, NULL, '2025-06-21 00:42:41', '2025-06-21 00:42:41'),
(2198, '9f34afc6-cfb9-468f-87d5-eacab803771e', 1, 3, NULL, 'flash.item_returned', 'messages', 'Item returned successfully.', 'active', NULL, NULL, '2025-06-21 00:42:41', '2025-06-21 00:42:41'),
(2199, '9f34afc6-d284-4f4d-8306-f9d479fd25a1', 1, 3, NULL, 'flash.issued_item_saved', 'messages', 'Issued Item saved successfully.', 'active', NULL, NULL, '2025-06-21 00:42:41', '2025-06-21 00:42:41'),
(2200, '9f34afc6-d546-4c4e-a596-01acd39cf2d0', 1, 3, NULL, 'flash.issued_item_deleted', 'messages', 'Issued Item deleted successfully.', 'active', NULL, NULL, '2025-06-21 00:42:41', '2025-06-21 00:42:41'),
(2201, '9f34afc6-dd0c-4468-9967-7f7881561fc4', 1, 3, NULL, 'flash.charge_category_saved', 'messages', 'Charge Category saved successfully.', 'active', NULL, NULL, '2025-06-21 00:42:41', '2025-06-21 00:42:41'),
(2202, '9f34afc6-e5b3-4f18-8870-cbf455576324', 1, 3, NULL, 'flash.charge_category_not_found', 'messages', 'Charge Category not found', 'active', NULL, NULL, '2025-06-21 00:42:41', '2025-06-21 00:42:41'),
(2203, '9f34afc6-e8b8-4c24-a34d-0296fbeeeadd', 1, 3, NULL, 'flash.charge_category_retrieved', 'messages', 'Charge Category Retrieved successfully.', 'active', NULL, NULL, '2025-06-21 00:42:41', '2025-06-21 00:42:41'),
(2204, '9f34afc6-eb85-4dbe-87d5-8d27f9b61411', 1, 3, NULL, 'flash.charge_category_updated', 'messages', 'Charge Category updated successfully.', 'active', NULL, NULL, '2025-06-21 00:42:41', '2025-06-21 00:42:41'),
(2205, '9f34afc6-ee63-46d8-b59f-bfcfdac8529d', 1, 3, NULL, 'flash.charge_category_cant_deleted', 'messages', 'Charge Category can\'t be deleted.', 'active', NULL, NULL, '2025-06-21 00:42:41', '2025-06-21 00:42:41'),
(2206, '9f34afc6-f125-4fb1-8ffc-4e60e2f64b2a', 1, 3, NULL, 'flash.charge_category_deleted', 'messages', 'Charge Category deleted successfully.', 'active', NULL, NULL, '2025-06-21 00:42:41', '2025-06-21 00:42:41'),
(2207, '9f34afc6-f3f1-4558-b24f-a1ae562205b2', 1, 3, NULL, 'flash.radiology_category_saved', 'messages', 'Radiology Category saved successfully.', 'active', NULL, NULL, '2025-06-21 00:42:41', '2025-06-21 00:42:41'),
(2208, '9f34afc6-f6e2-4633-8450-3d3fa5af877b', 1, 3, NULL, 'flash.radiology_category_retrieved', 'messages', 'Radiology Category Retrieved successfully.', 'active', NULL, NULL, '2025-06-21 00:42:41', '2025-06-21 00:42:41'),
(2209, '9f34afc6-f992-49a1-9b04-42b90fb2f8f0', 1, 3, NULL, 'flash.radiology_category_updated', 'messages', 'Radiology Category updated successfully.', 'active', NULL, NULL, '2025-06-21 00:42:41', '2025-06-21 00:42:41'),
(2210, '9f34afc6-fc65-43aa-9367-ef44d8fa94ab', 1, 3, NULL, 'flash.radiology_category_cant_deleted', 'messages', 'Radiology Category can\'t be deleted.', 'active', NULL, NULL, '2025-06-21 00:42:41', '2025-06-21 00:42:41'),
(2211, '9f34afc6-ff67-49f7-b174-172e7c146dc0', 1, 3, NULL, 'flash.radiology_category_deleted', 'messages', 'Radiology Category deleted successfully.', 'active', NULL, NULL, '2025-06-21 00:42:41', '2025-06-21 00:42:41'),
(2212, '9f34afc7-027c-4ac5-9406-b60e7476d573', 1, 3, NULL, 'flash.item_category_saved', 'messages', 'Item Category saved successfully.', 'active', NULL, NULL, '2025-06-21 00:42:41', '2025-06-21 00:42:41'),
(2213, '9f34afc7-0558-40c4-a6a5-91614b15b359', 1, 3, NULL, 'flash.item_category_retrieved', 'messages', 'Item Category Retrieved successfully.', 'active', NULL, NULL, '2025-06-21 00:42:41', '2025-06-21 00:42:41'),
(2214, '9f34afc7-0831-4753-aca5-5e1245f6cbbb', 1, 3, NULL, 'flash.item_category_updated', 'messages', 'Item Category updated successfully.', 'active', NULL, NULL, '2025-06-21 00:42:41', '2025-06-21 00:42:41'),
(2215, '9f34afc7-0b41-420d-94e9-576f7f98c153', 1, 3, NULL, 'flash.item_category_cant_deleted', 'messages', 'Item Category can\'t be deleted.', 'active', NULL, NULL, '2025-06-21 00:42:41', '2025-06-21 00:42:41'),
(2216, '9f34afc7-0e45-48e7-a9c7-9643ceacda22', 1, 3, NULL, 'flash.item_category_deleted', 'messages', 'Item Category deleted successfully.', 'active', NULL, NULL, '2025-06-21 00:42:41', '2025-06-21 00:42:41'),
(2217, '9f34afc7-1116-4122-839e-6bd3a701c5dd', 1, 3, NULL, 'flash.pathology_category_saved', 'messages', 'Pathology Category saved successfully.', 'active', NULL, NULL, '2025-06-21 00:42:41', '2025-06-21 00:42:41'),
(2218, '9f34afc7-13e2-4b5c-b9f8-0ff51acbbdb8', 1, 3, NULL, 'flash.pathology_category_retrieved', 'messages', 'Pathology Category Retrieved successfully.', 'active', NULL, NULL, '2025-06-21 00:42:41', '2025-06-21 00:42:41'),
(2219, '9f34afc7-16c5-43e0-b0ae-f66da18af088', 1, 3, NULL, 'flash.pathology_category_updated', 'messages', 'Pathology Category updated successfully.', 'active', NULL, NULL, '2025-06-21 00:42:41', '2025-06-21 00:42:41'),
(2220, '9f34afc7-19ba-486e-a016-8f731690fc0b', 1, 3, NULL, 'flash.pathology_category_cant_deleted', 'messages', 'Pathology Category can\'t be deleted.', 'active', NULL, NULL, '2025-06-21 00:42:41', '2025-06-21 00:42:41'),
(2221, '9f34afc7-1cb4-4846-b0de-0203d115e553', 1, 3, NULL, 'flash.pathology_category_deleted', 'messages', 'Pathology Category deleted successfully.', 'active', NULL, NULL, '2025-06-21 00:42:41', '2025-06-21 00:42:41'),
(2222, '9f34afc7-1f9a-4f12-9f11-3e1f9ba0a932', 1, 3, NULL, 'flash.live_status_retrieved', 'messages', 'Live Status retrieved successfully.', 'active', NULL, NULL, '2025-06-21 00:42:41', '2025-06-21 00:42:41'),
(2223, '9f34afc7-227e-4f49-861d-36c3c9af2471', 1, 3, NULL, 'flash.live_consultation_saved', 'messages', 'Live Consultation saved successfully.', 'active', NULL, NULL, '2025-06-21 00:42:41', '2025-06-21 00:42:41'),
(2224, '9f34afc7-254f-41f3-9016-4368e770e711', 1, 3, NULL, 'flash.live_consultation_retrieved', 'messages', 'Live Consultation Retrieved successfully.', 'active', NULL, NULL, '2025-06-21 00:42:41', '2025-06-21 00:42:41'),
(2225, '9f34afc7-282e-466e-a924-798b778d22be', 1, 3, NULL, 'flash.live_consultation_updated', 'messages', 'Live Consultation updated successfully.', 'active', NULL, NULL, '2025-06-21 00:42:41', '2025-06-21 00:42:41'),
(2226, '9f34afc7-2b37-4b29-bf20-00ba050be953', 1, 3, NULL, 'flash.live_consultation_deleted', 'messages', 'Live Consultation deleted successfully.', 'active', NULL, NULL, '2025-06-21 00:42:41', '2025-06-21 00:42:41'),
(2227, '9f34afc7-2fd1-44b5-a34b-9c67b7a1873c', 1, 3, NULL, 'flash.live_meeting_saved', 'messages', 'Live Meeting saved successfully.', 'active', NULL, NULL, '2025-06-21 00:42:41', '2025-06-21 00:42:41'),
(2228, '9f34afc7-32d5-4a1b-a60d-74cba6c6c06b', 1, 3, NULL, 'flash.live_meeting_retrieved', 'messages', 'Live Meeting Retrieved successfully.', 'active', NULL, NULL, '2025-06-21 00:42:41', '2025-06-21 00:42:41'),
(2229, '9f34afc7-35d3-4bcd-bf41-ab9e3db0e334', 1, 3, NULL, 'flash.live_meeting_updated', 'messages', 'Live Meeting updated successfully.', 'active', NULL, NULL, '2025-06-21 00:42:41', '2025-06-21 00:42:41'),
(2230, '9f34afc7-38a8-49a2-bbe7-f6af8c48fd7f', 1, 3, NULL, 'flash.live_meeting_deleted', 'messages', 'Live Meeting deleted successfully.', 'active', NULL, NULL, '2025-06-21 00:42:41', '2025-06-21 00:42:41'),
(2231, '9f34afc7-3b92-4347-9980-f1af06673a04', 1, 3, NULL, 'flash.user_zoom_credential_retrieved', 'messages', 'User Zoom Credential retrieved successfully.', 'active', NULL, NULL, '2025-06-21 00:42:41', '2025-06-21 00:42:41'),
(2232, '9f34afc7-3e77-4444-8060-0eccfa3a7c13', 1, 3, NULL, 'flash.user_zoom_credential_saved', 'messages', 'User Zoom Credential saved successfully.', 'active', NULL, NULL, '2025-06-21 00:42:41', '2025-06-21 00:42:41'),
(2233, '9f34afc7-4167-4545-86c5-116e0a0a416e', 1, 3, NULL, 'flash.item_not_found', 'messages', 'Items not found', 'active', NULL, NULL, '2025-06-21 00:42:41', '2025-06-21 00:42:41'),
(2234, '9f34afc7-4441-4138-bc3b-6d7064101294', 1, 3, NULL, 'flash.mail_sent', 'messages', 'Mail sent successfully.', 'active', NULL, NULL, '2025-06-21 00:42:41', '2025-06-21 00:42:41'),
(2235, '9f34afc7-4731-4ffd-9138-f0e40b32c0a6', 1, 3, NULL, 'flash.item_saved', 'messages', 'Item saved successfully.', 'active', NULL, NULL, '2025-06-21 00:42:41', '2025-06-21 00:42:41'),
(2236, '9f34afc7-4a18-4d30-9b27-e9e91f817489', 1, 3, NULL, 'flash.item_updated', 'messages', 'Item updated successfully.', 'active', NULL, NULL, '2025-06-21 00:42:41', '2025-06-21 00:42:41'),
(2237, '9f34afc7-4d0a-4c51-a1a7-9c7a1d40ea9e', 1, 3, NULL, 'flash.item_cant_deleted', 'messages', 'Item can\'t be deleted.', 'active', NULL, NULL, '2025-06-21 00:42:41', '2025-06-21 00:42:41'),
(2238, '9f34afc7-5039-4632-8bbd-471d00002647', 1, 3, NULL, 'flash.item_deleted', 'messages', 'Item deleted successfully.', 'active', NULL, NULL, '2025-06-21 00:42:41', '2025-06-21 00:42:41'),
(2239, '9f34afc7-5326-45be-a949-65a0c58dfda0', 1, 3, NULL, 'flash.lab_technician_saved', 'messages', 'Lab Technician saved successfully.', 'active', NULL, NULL, '2025-06-21 00:42:41', '2025-06-21 00:42:41'),
(2240, '9f34afc7-561e-4755-bc41-b066e699fe93', 1, 3, NULL, 'flash.lab_technician_updated', 'messages', 'Lab Technician updated successfully.', 'active', NULL, NULL, '2025-06-21 00:42:41', '2025-06-21 00:42:41'),
(2241, '9f34afc7-58fc-4216-83a1-4ea7dcb5cf68', 1, 3, NULL, 'flash.lab_technician_cant_deleted', 'messages', 'Lab Technician can\'t be deleted.', 'active', NULL, NULL, '2025-06-21 00:42:41', '2025-06-21 00:42:41'),
(2242, '9f34afc7-5c04-4a51-9eae-1dbe900a3b82', 1, 3, NULL, 'flash.lab_technician_deleted', 'messages', 'Lab Technician deleted successfully.', 'active', NULL, NULL, '2025-06-21 00:42:41', '2025-06-21 00:42:41'),
(2243, '9f34afc7-5ed9-4699-8a91-84da56a07aa0', 1, 3, NULL, 'flash.nurse_saved', 'messages', 'Nurse saved successfully.', 'active', NULL, NULL, '2025-06-21 00:42:41', '2025-06-21 00:42:41'),
(2244, '9f34afc7-61ba-4dff-b257-c6f83886dab8', 1, 3, NULL, 'flash.nurse_updated', 'messages', 'Nurse updated successfully.', 'active', NULL, NULL, '2025-06-21 00:42:41', '2025-06-21 00:42:41'),
(2245, '9f34afc7-648a-465d-8be4-66080f557966', 1, 3, NULL, 'flash.nurse_cant_deleted', 'messages', 'Nurse can\'t be deleted.', 'active', NULL, NULL, '2025-06-21 00:42:41', '2025-06-21 00:42:41'),
(2246, '9f34afc7-6777-4a13-8cc3-6332960fa292', 1, 3, NULL, 'flash.nurse_deleted', 'messages', 'Nurse deleted successfully.', 'active', NULL, NULL, '2025-06-21 00:42:41', '2025-06-21 00:42:41'),
(2247, '9f34afc7-6a5f-4199-b1ef-ccb950dc86de', 1, 3, NULL, 'flash.Pharmacist_saved', 'messages', 'Pharmacist saved successfully.', 'active', NULL, NULL, '2025-06-21 00:42:41', '2025-06-21 00:42:41'),
(2248, '9f34afc7-6d90-4b14-af19-8f2e07cc34c3', 1, 3, NULL, 'flash.Pharmacist_updated', 'messages', 'Pharmacist updated successfully.', 'active', NULL, NULL, '2025-06-21 00:42:41', '2025-06-21 00:42:41'),
(2249, '9f34afc7-7061-43b3-b0b5-099418aec067', 1, 3, NULL, 'flash.Pharmacist_cant_deleted', 'messages', 'Pharmacist can\'t be deleted.', 'active', NULL, NULL, '2025-06-21 00:42:41', '2025-06-21 00:42:41'),
(2250, '9f34afc7-7343-4855-ba7f-95cf4ae6ad13', 1, 3, NULL, 'flash.Pharmacist_deleted', 'messages', 'Pharmacist deleted successfully.', 'active', NULL, NULL, '2025-06-21 00:42:41', '2025-06-21 00:42:41'),
(2251, '9f34afc7-7637-4478-a55d-c4281f9559aa', 1, 3, NULL, 'flash.package_saved', 'messages', 'Package saved successfully.', 'active', NULL, NULL, '2025-06-21 00:42:42', '2025-06-21 00:42:42'),
(2252, '9f34afc7-7932-4a13-bf5e-d4ca36bb1b23', 1, 3, NULL, 'flash.package_updated', 'messages', 'Package updated successfully.', 'active', NULL, NULL, '2025-06-21 00:42:42', '2025-06-21 00:42:42'),
(2253, '9f34afc7-7c26-4086-9b42-54338e0e992e', 1, 3, NULL, 'flash.package_cant_deleted', 'messages', 'Package can\'t be deleted.', 'active', NULL, NULL, '2025-06-21 00:42:42', '2025-06-21 00:42:42'),
(2254, '9f34afc7-7ef9-40d1-8dc1-572babc90999', 1, 3, NULL, 'flash.package_deleted', 'messages', 'Package deleted successfully.', 'active', NULL, NULL, '2025-06-21 00:42:42', '2025-06-21 00:42:42'),
(2255, '9f34afc7-81ee-4cdd-a1e0-e4b30aee7c75', 1, 3, NULL, 'flash.item_stock_saved', 'messages', 'Item Stock saved successfully.', 'active', NULL, NULL, '2025-06-21 00:42:42', '2025-06-21 00:42:42'),
(2256, '9f34afc7-84ce-4684-a734-260b70a68d5b', 1, 3, NULL, 'flash.item_stock_updated', 'messages', 'Item Stock updated successfully.', 'active', NULL, NULL, '2025-06-21 00:42:42', '2025-06-21 00:42:42'),
(2257, '9f34afc7-87b2-4f60-a015-f608a4cb61f1', 1, 3, NULL, 'flash.item_stock_deleted', 'messages', 'Item Stock deleted successfully.', 'active', NULL, NULL, '2025-06-21 00:42:42', '2025-06-21 00:42:42'),
(2258, '9f34afc7-965d-459f-87ae-6a021a26ccfb', 1, 3, NULL, 'flash.diagnosis_category_saved', 'messages', 'Diagnosis Category saved successfully.', 'active', NULL, NULL, '2025-06-21 00:42:42', '2025-06-21 00:42:42'),
(2259, '9f34afc7-999c-4f88-a3ae-8e31df00f296', 1, 3, NULL, 'flash.diagnosis_category_not_found', 'messages', 'Diagnosis Category not found', 'active', NULL, NULL, '2025-06-21 00:42:42', '2025-06-21 00:42:42'),
(2260, '9f34afc7-9cb8-410d-93fb-a8d8ee4f7224', 1, 3, NULL, 'flash.diagnosis_category_retrieved', 'messages', 'Diagnosis Category retrieved successfully.', 'active', NULL, NULL, '2025-06-21 00:42:42', '2025-06-21 00:42:42'),
(2261, '9f34afc7-9fa2-4524-8836-57c6bc035d81', 1, 3, NULL, 'flash.diagnosis_category_updated', 'messages', 'Diagnosis Category updated successfully.', 'active', NULL, NULL, '2025-06-21 00:42:42', '2025-06-21 00:42:42'),
(2262, '9f34afc7-a294-49d5-a174-0b5330921220', 1, 3, NULL, 'flash.diagnosis_category_cant_deleted', 'messages', 'Diagnosis Category can\'t be deleted.', 'active', NULL, NULL, '2025-06-21 00:42:42', '2025-06-21 00:42:42'),
(2263, '9f34afc7-a592-4fc7-909d-b8b35a6aee6b', 1, 3, NULL, 'flash.diagnosis_category_deleted', 'messages', 'Diagnosis Category deleted successfully.', 'active', NULL, NULL, '2025-06-21 00:42:42', '2025-06-21 00:42:42'),
(2264, '9f34afc7-a881-4911-bfd9-3e3d66b1bd5f', 1, 3, NULL, 'flash.death_report_saved', 'messages', 'Death Report saved successfully.', 'active', NULL, NULL, '2025-06-21 00:42:42', '2025-06-21 00:42:42'),
(2265, '9f34afc7-aba0-4641-86ab-8e4dc8a3abeb', 1, 3, NULL, 'flash.death_report_retrieved', 'messages', 'Death Report retrieved successfully.', 'active', NULL, NULL, '2025-06-21 00:42:42', '2025-06-21 00:42:42'),
(2266, '9f34afc7-aeb7-4981-83ca-e4e6e0ca22a1', 1, 3, NULL, 'flash.death_report_updated', 'messages', 'Death Report updated successfully.', 'active', NULL, NULL, '2025-06-21 00:42:42', '2025-06-21 00:42:42'),
(2267, '9f34afc7-b1b4-49e7-8818-db8b5e08400a', 1, 3, NULL, 'flash.death_report_deleted', 'messages', 'Death Report deleted successfully.', 'active', NULL, NULL, '2025-06-21 00:42:42', '2025-06-21 00:42:42'),
(2268, '9f34afc7-b491-42ed-86f4-74f964e5aa84', 1, 3, NULL, 'flash.department_saved', 'messages', 'Department saved successfully.', 'active', NULL, NULL, '2025-06-21 00:42:42', '2025-06-21 00:42:42'),
(2269, '9f34afc7-b780-4f38-9736-282d0da7450a', 1, 3, NULL, 'flash.department_retrieved', 'messages', 'Department retrieved successfully.', 'active', NULL, NULL, '2025-06-21 00:42:42', '2025-06-21 00:42:42'),
(2270, '9f34afc7-ba50-4fac-9bf7-0eac8553fc6e', 1, 3, NULL, 'flash.department_updated', 'messages', 'Department updated successfully.', 'active', NULL, NULL, '2025-06-21 00:42:42', '2025-06-21 00:42:42'),
(2271, '9f34afc7-bd57-4805-b54b-4f5e597bc7bf', 1, 3, NULL, 'flash.department_deleted', 'messages', 'Department deleted successfully.', 'active', NULL, NULL, '2025-06-21 00:42:42', '2025-06-21 00:42:42'),
(2272, '9f34afc7-c049-43b4-adb3-0a5247b52fd3', 1, 3, NULL, 'flash.doctor_department_saved', 'messages', 'Doctor Department saved successfully.', 'active', NULL, NULL, '2025-06-21 00:42:42', '2025-06-21 00:42:42'),
(2273, '9f34afc7-c36e-4b00-b72f-8b6f62e74d57', 1, 3, NULL, 'flash.doctor_department_not_found', 'messages', 'Doctor Department not found', 'active', NULL, NULL, '2025-06-21 00:42:42', '2025-06-21 00:42:42'),
(2274, '9f34afc7-c657-4119-865b-1ad1b58c1e5e', 1, 3, NULL, 'flash.doctor_department_retrieved', 'messages', 'Doctor Department retrieved successfully.', 'active', NULL, NULL, '2025-06-21 00:42:42', '2025-06-21 00:42:42'),
(2275, '9f34afc7-c931-4156-bc0b-0229a0c6a60e', 1, 3, NULL, 'flash.doctor_department_updated', 'messages', 'Doctor Department updated successfully.', 'active', NULL, NULL, '2025-06-21 00:42:42', '2025-06-21 00:42:42'),
(2276, '9f34afc7-cc1c-47ae-aa6f-5c5895c7e370', 1, 3, NULL, 'flash.doctor_department_cant_deleted', 'messages', 'Doctor Department can\'t be deleted.', 'active', NULL, NULL, '2025-06-21 00:42:42', '2025-06-21 00:42:42'),
(2277, '9f34afc7-cf97-47d3-8993-42cd7aeba9b2', 1, 3, NULL, 'flash.doctor_department_deleted', 'messages', 'Doctor Department deleted successfully.', 'active', NULL, NULL, '2025-06-21 00:42:42', '2025-06-21 00:42:42'),
(2278, '9f34afc7-d28a-4afb-a67b-ebe9a0878600', 1, 3, NULL, 'flash.patient_diagnosis_saved', 'messages', 'Patient diagnosis saved successfully.', 'active', NULL, NULL, '2025-06-21 00:42:42', '2025-06-21 00:42:42'),
(2279, '9f34afc7-d57e-4e7a-a068-325be49d72e1', 1, 3, NULL, 'flash.patient_diagnosis_updated', 'messages', 'Patient diagnosis updated successfully.', 'active', NULL, NULL, '2025-06-21 00:42:42', '2025-06-21 00:42:42'),
(2280, '9f34afc7-d88d-4ec2-a451-18c46adc6011', 1, 3, NULL, 'flash.patient_diagnosis_deleted', 'messages', 'Patient diagnosis deleted successfully.', 'active', NULL, NULL, '2025-06-21 00:42:42', '2025-06-21 00:42:42'),
(2281, '9f34afc7-db51-4262-9905-1865cc56a06f', 1, 3, NULL, 'flash.users_not_found', 'messages', 'Users not found', 'active', NULL, NULL, '2025-06-21 00:42:42', '2025-06-21 00:42:42'),
(2282, '9f34afc7-de55-444a-be6a-3a2343baffe1', 1, 3, NULL, 'flash.user_saved', 'messages', 'User saved successfully.', 'active', NULL, NULL, '2025-06-21 00:42:42', '2025-06-21 00:42:42'),
(2283, '9f34afc7-e13b-4d5a-858b-02c04a430776', 1, 3, NULL, 'flash.user_deleted', 'messages', 'User deleted Successfully.', 'active', NULL, NULL, '2025-06-21 00:42:42', '2025-06-21 00:42:42'),
(2284, '9f34afc7-e433-448d-8d40-430aca598360', 1, 3, NULL, 'flash.user_updated', 'messages', 'User updated Successfully.', 'active', NULL, NULL, '2025-06-21 00:42:42', '2025-06-21 00:42:42'),
(2285, '9f34afc7-e748-42f8-996e-76a212a8a283', 1, 3, NULL, 'flash.post_not_found', 'messages', 'Post not found', 'active', NULL, NULL, '2025-06-21 00:42:42', '2025-06-21 00:42:42'),
(2286, '9f34afc7-ea3c-40f2-b08d-159b9073ba08', 1, 3, NULL, 'flash.post_saved', 'messages', 'Post saved successfully.', 'active', NULL, NULL, '2025-06-21 00:42:42', '2025-06-21 00:42:42'),
(2287, '9f34afc7-ed92-42b5-8eb3-6875a6f2abbd', 1, 3, NULL, 'flash.post_deleted', 'messages', 'Post deleted successfully.', 'active', NULL, NULL, '2025-06-21 00:42:42', '2025-06-21 00:42:42'),
(2288, '9f34afc7-f07d-4f24-b9df-64559857b4b7', 1, 3, NULL, 'flash.post_state_updated', 'messages', 'Status updated successfully.', 'active', NULL, NULL, '2025-06-21 00:42:42', '2025-06-21 00:42:42'),
(2289, '9f34afc7-f3bc-4c61-a6c2-7fa1a373ac21', 1, 3, NULL, 'flash.doctor_save', 'messages', 'Doctor saved successfully.', 'active', NULL, NULL, '2025-06-21 00:42:42', '2025-06-21 00:42:42'),
(2290, '9f34afc7-f6e9-4fcf-b542-8e078beba77c', 1, 3, NULL, 'flash.doctor_not_found', 'messages', 'Doctor not found', 'active', NULL, NULL, '2025-06-21 00:42:42', '2025-06-21 00:42:42'),
(2291, '9f34afc7-f9e4-49ff-8e29-829bfa478937', 1, 3, NULL, 'flash.doctor_update', 'messages', 'Doctor updated successfully.', 'active', NULL, NULL, '2025-06-21 00:42:42', '2025-06-21 00:42:42'),
(2292, '9f34afc7-fce2-4823-8018-01cc179a5454', 1, 3, NULL, 'flash.doctor_cant_deleted', 'messages', 'Doctor can\'t be deleted.', 'active', NULL, NULL, '2025-06-21 00:42:42', '2025-06-21 00:42:42'),
(2293, '9f34afc8-0016-4648-a2dc-569057340a49', 1, 3, NULL, 'flash.doctor_delete', 'messages', 'Doctor deleted successfully.', 'active', NULL, NULL, '2025-06-21 00:42:42', '2025-06-21 00:42:42'),
(2294, '9f34afc8-02fc-4b06-b036-f69a0bbb843d', 1, 3, NULL, 'flash.OPD_charge_saved', 'messages', 'Doctor OPD Charge saved successfully.', 'active', NULL, NULL, '2025-06-21 00:42:42', '2025-06-21 00:42:42'),
(2295, '9f34afc8-05f5-4109-80c1-7c319876ae0f', 1, 3, NULL, 'flash.OPD_charge_retrieved', 'messages', 'Doctor OPD Charge Retrieved successfully.', 'active', NULL, NULL, '2025-06-21 00:42:42', '2025-06-21 00:42:42'),
(2296, '9f34afc8-08ee-4450-956c-eacb1b262211', 1, 3, NULL, 'flash.OPD_charge_updated', 'messages', 'Doctor OPD Charge updated successfully.', 'active', NULL, NULL, '2025-06-21 00:42:42', '2025-06-21 00:42:42'),
(2297, '9f34afc8-0bd2-406c-a924-d1ba1a2ff445', 1, 3, NULL, 'flash.OPD_charge_deleted', 'messages', 'Doctor OPD Charge deleted successfully.', 'active', NULL, NULL, '2025-06-21 00:42:42', '2025-06-21 00:42:42'),
(2298, '9f34afc8-0ed1-4769-b8b1-71f0b270041e', 1, 3, NULL, 'flash.operation_report_saved', 'messages', 'Operation Report saved successfully.', 'active', NULL, NULL, '2025-06-21 00:42:42', '2025-06-21 00:42:42'),
(2299, '9f34afc8-11c3-47ea-8dd1-90115d35e07f', 1, 3, NULL, 'flash.operation_report_retrieved', 'messages', 'Operation Report Retrieved successfully.', 'active', NULL, NULL, '2025-06-21 00:42:42', '2025-06-21 00:42:42'),
(2300, '9f34afc8-14cb-4ecb-9e46-ab6d7672aa5d', 1, 3, NULL, 'flash.operation_report_updated', 'messages', 'Operation Report updated successfully.', 'active', NULL, NULL, '2025-06-21 00:42:42', '2025-06-21 00:42:42'),
(2301, '9f34afc8-17bd-4685-a5f8-e71a88191bc9', 1, 3, NULL, 'flash.operation_report_deleted', 'messages', 'Operation Report deleted successfully.', 'active', NULL, NULL, '2025-06-21 00:42:42', '2025-06-21 00:42:42'),
(2302, '9f34afc8-1aa6-42dd-aa44-de9287dfb0ae', 1, 3, NULL, 'flash.OPD_diagnosis_saved', 'messages', 'OPD Diagnosis saved successfully.', 'active', NULL, NULL, '2025-06-21 00:42:42', '2025-06-21 00:42:42'),
(2303, '9f34afc8-1dbb-428c-9311-166d6bf2904d', 1, 3, NULL, 'flash.OPD_diagnosis_retrieved', 'messages', 'OPD Diagnosis Retrieved successfully.', 'active', NULL, NULL, '2025-06-21 00:42:42', '2025-06-21 00:42:42'),
(2304, '9f34afc8-20a8-4bcc-aef9-82dc27ab7ab6', 1, 3, NULL, 'flash.OPD_diagnosis_updated', 'messages', 'OPD Diagnosis updated successfully.', 'active', NULL, NULL, '2025-06-21 00:42:42', '2025-06-21 00:42:42'),
(2305, '9f34afc8-2381-4357-b787-8654caab800f', 1, 3, NULL, 'flash.OPD_diagnosis_deleted', 'messages', 'OPD Diagnosis deleted successfully.', 'active', NULL, NULL, '2025-06-21 00:42:42', '2025-06-21 00:42:42'),
(2306, '9f34afc8-2683-482e-a420-ce58984a70c9', 1, 3, NULL, 'flash.OPD_timeline_saved', 'messages', 'OPD Timeline saved successfully.', 'active', NULL, NULL, '2025-06-21 00:42:42', '2025-06-21 00:42:42'),
(2307, '9f34afc8-29e9-4e01-a0e8-f8784dee9f5a', 1, 3, NULL, 'flash.OPD_timeline_retrieved', 'messages', 'OPD Timeline Retrieved successfully.', 'active', NULL, NULL, '2025-06-21 00:42:42', '2025-06-21 00:42:42'),
(2308, '9f34afc8-2cfd-40b6-b4e8-8acbb2c04182', 1, 3, NULL, 'flash.OPD_timeline_updated', 'messages', 'OPD Timeline updated successfully.', 'active', NULL, NULL, '2025-06-21 00:42:42', '2025-06-21 00:42:42'),
(2309, '9f34afc8-2ffd-46f4-9f0e-39b7417668db', 1, 3, NULL, 'flash.OPD_timeline_deleted', 'messages', 'OPD Timeline deleted successfully.', 'active', NULL, NULL, '2025-06-21 00:42:42', '2025-06-21 00:42:42'),
(2310, '9f34afc8-345a-4707-a150-d33f48555cc1', 1, 3, NULL, 'flash.OPD_Patient_saved', 'messages', 'OPD Patient saved successfully.', 'active', NULL, NULL, '2025-06-21 00:42:42', '2025-06-21 00:42:42'),
(2311, '9f34afc8-375e-4900-a925-d5af44539c70', 1, 3, NULL, 'flash.OPD_Patient_updated', 'messages', 'OPD Patient updated successfully.', 'active', NULL, NULL, '2025-06-21 00:42:42', '2025-06-21 00:42:42'),
(2312, '9f34afc8-3a7c-4e12-b8ae-4038ddae0baf', 1, 3, NULL, 'flash.OPD_Patient_deleted', 'messages', 'OPD Patient deleted successfully.', 'active', NULL, NULL, '2025-06-21 00:42:42', '2025-06-21 00:42:42'),
(2313, '9f34afc8-3d8a-4aef-ab06-697348c35918', 1, 3, NULL, 'flash.IPD_charge_saved', 'messages', 'IPD Charge saved successfully.', 'active', NULL, NULL, '2025-06-21 00:42:42', '2025-06-21 00:42:42'),
(2314, '9f34afc8-40a9-4964-80ec-42d68449fdd5', 1, 3, NULL, 'flash.IPD_charge_retrieved', 'messages', 'IPD Charge Retrieved successfully.', 'active', NULL, NULL, '2025-06-21 00:42:42', '2025-06-21 00:42:42'),
(2315, '9f34afc8-4e66-46d0-81dd-925a31c84422', 1, 3, NULL, 'flash.IPD_charge_updated', 'messages', 'IPD Charge updated successfully.', 'active', NULL, NULL, '2025-06-21 00:42:42', '2025-06-21 00:42:42'),
(2316, '9f34afc8-51e4-4b65-ad41-c2d4bd40ed7f', 1, 3, NULL, 'flash.IPD_charge_deleted', 'messages', 'IPD Charge deleted successfully.', 'active', NULL, NULL, '2025-06-21 00:42:42', '2025-06-21 00:42:42'),
(2317, '9f34afc8-54e2-4f6e-bf91-ac2f55315cc1', 1, 3, NULL, 'flash.IPD_diagnosis_saved', 'messages', 'IPD Diagnosis saved successfully.', 'active', NULL, NULL, '2025-06-21 00:42:42', '2025-06-21 00:42:42'),
(2318, '9f34afc8-57ed-4c7e-a46f-f9541f7fd62d', 1, 3, NULL, 'flash.IPD_diagnosis_retrieved', 'messages', 'IPD Diagnosis Retrieved successfully.', 'active', NULL, NULL, '2025-06-21 00:42:42', '2025-06-21 00:42:42'),
(2319, '9f34afc8-5ae5-43ce-bc18-0de62afa8ee9', 1, 3, NULL, 'flash.IPD_diagnosis_updated', 'messages', 'IPD Diagnosis updated successfully.', 'active', NULL, NULL, '2025-06-21 00:42:42', '2025-06-21 00:42:42'),
(2320, '9f34afc8-5dfd-4b20-b7ab-8947a6af7b72', 1, 3, NULL, 'flash.IPD_diagnosis_deleted', 'messages', 'IPD Diagnosis deleted successfully.', 'active', NULL, NULL, '2025-06-21 00:42:42', '2025-06-21 00:42:42'),
(2321, '9f34afc8-6166-4217-937b-81c7e45a8f29', 1, 3, NULL, 'flash.IPD_Patient_saved', 'messages', 'IPD Patient saved successfully.', 'active', NULL, NULL, '2025-06-21 00:42:42', '2025-06-21 00:42:42'),
(2322, '9f34afc8-6477-48dd-8cf2-a849d84cadbe', 1, 3, NULL, 'flash.IPD_Patient_updated', 'messages', 'IPD Patient updated successfully.', 'active', NULL, NULL, '2025-06-21 00:42:42', '2025-06-21 00:42:42'),
(2323, '9f34afc8-677a-45d4-a007-ec8155759965', 1, 3, NULL, 'flash.IPD_Patient_deleted', 'messages', 'IPD Patient deleted successfully.', 'active', NULL, NULL, '2025-06-21 00:42:42', '2025-06-21 00:42:42'),
(2324, '9f34afc8-6a61-4853-92d1-4b2a65a43323', 1, 3, NULL, 'flash.IPD_consultant_saved', 'messages', 'IPD Consultant Instruction saved successfully.', 'active', NULL, NULL, '2025-06-21 00:42:42', '2025-06-21 00:42:42'),
(2325, '9f34afc8-6d55-4ad6-895e-188adac5d51e', 1, 3, NULL, 'flash.IPD_consultant_retrieved', 'messages', 'IPD Consultant Instruction Retrieved successfully.', 'active', NULL, NULL, '2025-06-21 00:42:42', '2025-06-21 00:42:42'),
(2326, '9f34afc8-7034-4b5e-94df-313b3939df14', 1, 3, NULL, 'flash.IPD_consultant_updated', 'messages', 'IPD Consultant Instruction updated successfully.', 'active', NULL, NULL, '2025-06-21 00:42:42', '2025-06-21 00:42:42'),
(2327, '9f34afc8-7338-40f7-b8f8-4cf2c65765ac', 1, 3, NULL, 'flash.IPD_consultant_deleted', 'messages', 'IPD Consultant Instruction deleted successfully.', 'active', NULL, NULL, '2025-06-21 00:42:42', '2025-06-21 00:42:42'),
(2328, '9f34afc8-7640-4dcc-bd55-2a69a97b6693', 1, 3, NULL, 'flash.IPD_Prescription_saved', 'messages', 'IPD Prescription saved successfully.', 'active', NULL, NULL, '2025-06-21 00:42:42', '2025-06-21 00:42:42'),
(2329, '9f34afc8-794b-4db3-a699-23ae13c0c579', 1, 3, NULL, 'flash.IPD_Prescription_retrieved', 'messages', 'IPD Prescription Retrieved successfully.', 'active', NULL, NULL, '2025-06-21 00:42:42', '2025-06-21 00:42:42'),
(2330, '9f34afc8-7c25-4707-a3e9-91523c0ddcac', 1, 3, NULL, 'flash.IPD_Prescription_updated', 'messages', 'IPD Prescription updated successfully.', 'active', NULL, NULL, '2025-06-21 00:42:42', '2025-06-21 00:42:42'),
(2331, '9f34afc8-7f0d-40eb-9f1a-782db17cfc04', 1, 3, NULL, 'flash.IPD_Prescription_deleted', 'messages', 'IPD Prescription deleted successfully.', 'active', NULL, NULL, '2025-06-21 00:42:42', '2025-06-21 00:42:42'),
(2332, '9f34afc8-8228-440b-b211-e3af28e402d4', 1, 3, NULL, 'flash.prescription_saved', 'messages', 'Prescription saved successfully.', 'active', NULL, NULL, '2025-06-21 00:42:42', '2025-06-21 00:42:42'),
(2333, '9f34afc8-8501-48e4-b2d9-cfdd8a78a84a', 1, 3, NULL, 'flash.prescription_not_found', 'messages', 'Prescription not found', 'active', NULL, NULL, '2025-06-21 00:42:42', '2025-06-21 00:42:42'),
(2334, '9f34afc8-8815-4404-abc3-e601dc06b14a', 1, 3, NULL, 'flash.prescription_retrieved', 'messages', 'Prescription Retrieved successfully.', 'active', NULL, NULL, '2025-06-21 00:42:42', '2025-06-21 00:42:42'),
(2335, '9f34afc8-8b10-4710-8c74-4fe1108d88bf', 1, 3, NULL, 'flash.prescription_updated', 'messages', 'Prescription updated successfully.', 'active', NULL, NULL, '2025-06-21 00:42:42', '2025-06-21 00:42:42'),
(2336, '9f34afc8-8e1f-483b-a18e-19aba127d126', 1, 3, NULL, 'flash.prescription_deleted', 'messages', 'Prescription deleted successfully.', 'active', NULL, NULL, '2025-06-21 00:42:42', '2025-06-21 00:42:42'),
(2337, '9f34afc8-9129-4670-b78d-e94e335d90d0', 1, 3, NULL, 'flash.setting_updated', 'messages', 'Setting updated successfully.', 'active', NULL, NULL, '2025-06-21 00:42:42', '2025-06-21 00:42:42'),
(2338, '9f34afc8-942f-49aa-99ed-27f20fe84a5e', 1, 3, NULL, 'flash.service_saved', 'messages', 'Service saved successfully.', 'active', NULL, NULL, '2025-06-21 00:42:42', '2025-06-21 00:42:42'),
(2339, '9f34afc8-9710-46ea-9c1d-0c21d76ac5ba', 1, 3, NULL, 'flash.service_not_found', 'messages', 'Service not found', 'active', NULL, NULL, '2025-06-21 00:42:42', '2025-06-21 00:42:42'),
(2340, '9f34afc8-9a1a-4e8e-9a58-f6c2845ff7dd', 1, 3, NULL, 'flash.service_updated', 'messages', 'Service updated successfully.', 'active', NULL, NULL, '2025-06-21 00:42:42', '2025-06-21 00:42:42'),
(2341, '9f34afc8-9d22-4aa5-9d8e-6f6a78022f51', 1, 3, NULL, 'flash.service_cant_deleted', 'messages', 'Service Type can\'t be deleted.', 'active', NULL, NULL, '2025-06-21 00:42:42', '2025-06-21 00:42:42'),
(2342, '9f34afc8-a01a-4bb9-92fc-092caff59e91', 1, 3, NULL, 'flash.service_deleted', 'messages', 'Service deleted successfully.', 'active', NULL, NULL, '2025-06-21 00:42:42', '2025-06-21 00:42:42'),
(2343, '9f34afc8-a331-4889-af35-4b988105b0b5', 1, 3, NULL, 'flash.IPD_payment_saved', 'messages', 'IPD Payment saved successfully.', 'active', NULL, NULL, '2025-06-21 00:42:42', '2025-06-21 00:42:42'),
(2344, '9f34afc8-a619-4f25-b970-9a815607e32c', 1, 3, NULL, 'flash.IPD_payment_retrieved', 'messages', 'IPD Payment Retrieved successfully.', 'active', NULL, NULL, '2025-06-21 00:42:42', '2025-06-21 00:42:42'),
(2345, '9f34afc8-a938-4d55-bdab-66908091e3be', 1, 3, NULL, 'flash.IPD_payment_updated', 'messages', 'IPD Payment updated successfully.', 'active', NULL, NULL, '2025-06-21 00:42:42', '2025-06-21 00:42:42'),
(2346, '9f34afc8-ac2c-49ec-b6c1-b29b20eb7213', 1, 3, NULL, 'flash.IPD_payment_deleted', 'messages', 'IPD Payment deleted successfully.', 'active', NULL, NULL, '2025-06-21 00:42:42', '2025-06-21 00:42:42'),
(2347, '9f34afc8-af3f-4f14-ba73-17e5a5cc2bd6', 1, 3, NULL, 'flash.IPD_timeline_saved', 'messages', 'IPD Timeline saved successfully.', 'active', NULL, NULL, '2025-06-21 00:42:42', '2025-06-21 00:42:42'),
(2348, '9f34afc8-b284-4584-af2f-020f56ea6bf0', 1, 3, NULL, 'flash.IPD_timeline_retrieved', 'messages', 'IPD Timeline Retrieved Successfully.', 'active', NULL, NULL, '2025-06-21 00:42:42', '2025-06-21 00:42:42'),
(2349, '9f34afc8-b5a5-44a1-9dc1-bfc2263413e9', 1, 3, NULL, 'flash.IPD_timeline_updated', 'messages', 'IPD Timeline updated successfully.', 'active', NULL, NULL, '2025-06-21 00:42:42', '2025-06-21 00:42:42'),
(2350, '9f34afc8-b8db-44d0-9054-917afb1e7e36', 1, 3, NULL, 'flash.IPD_timeline_deleted', 'messages', 'IPD Timeline deleted successfully.', 'active', NULL, NULL, '2025-06-21 00:42:42', '2025-06-21 00:42:42'),
(2351, '9f34afc8-bbdc-47ac-94d9-fb5daf19428f', 1, 3, NULL, 'flash.document_saved', 'messages', 'Document saved successfully.', 'active', NULL, NULL, '2025-06-21 00:42:42', '2025-06-21 00:42:42'),
(2352, '9f34afc8-bed8-4a5b-84c9-d57089e2c464', 1, 3, NULL, 'flash.document_retrieved', 'messages', 'Document Retrieved successfully.', 'active', NULL, NULL, '2025-06-21 00:42:42', '2025-06-21 00:42:42'),
(2353, '9f34afc8-c1f8-4987-acd1-df58506f7490', 1, 3, NULL, 'flash.document_updated', 'messages', 'Document updated successfully.', 'active', NULL, NULL, '2025-06-21 00:42:42', '2025-06-21 00:42:42'),
(2354, '9f34afc8-c4e2-4615-91ab-bfd73060ac50', 1, 3, NULL, 'flash.document_deleted', 'messages', 'Document deleted successfully.', 'active', NULL, NULL, '2025-06-21 00:42:42', '2025-06-21 00:42:42'),
(2355, '9f34afc8-c7d8-47e2-94bd-d7558db75194', 1, 3, NULL, 'flash.expense_saved', 'messages', 'Expense saved successfully.', 'active', NULL, NULL, '2025-06-21 00:42:42', '2025-06-21 00:42:42'),
(2356, '9f34afc8-cae4-466e-ab24-1ffa4f24adf8', 1, 3, NULL, 'flash.expense_retrieved', 'messages', 'Expense retrieved successfully.', 'active', NULL, NULL, '2025-06-21 00:42:42', '2025-06-21 00:42:42'),
(2357, '9f34afc8-cdf9-415f-b47b-f7e463869faf', 1, 3, NULL, 'flash.expense_updated', 'messages', 'Expense updated successfully.', 'active', NULL, NULL, '2025-06-21 00:42:42', '2025-06-21 00:42:42'),
(2358, '9f34afc8-d0e6-49d9-bfa0-56f34370f449', 1, 3, NULL, 'flash.expense_deleted', 'messages', 'Expense deleted successfully.', 'active', NULL, NULL, '2025-06-21 00:42:42', '2025-06-21 00:42:42'),
(2359, '9f34afc8-d3c6-43ca-a582-a53ef76c6977', 1, 3, NULL, 'flash.income_saved', 'messages', 'Income saved successfully', 'active', NULL, NULL, '2025-06-21 00:42:42', '2025-06-21 00:42:42'),
(2360, '9f34afc8-d69d-4193-a4bf-f274ee32f332', 1, 3, NULL, 'flash.income_retrieved', 'messages', 'Income retrieved successfully.', 'active', NULL, NULL, '2025-06-21 00:42:42', '2025-06-21 00:42:42'),
(2361, '9f34afc8-dbf9-4d30-bc8a-f20beccb186e', 1, 3, NULL, 'flash.income_updated', 'messages', 'Income updated successfully.', 'active', NULL, NULL, '2025-06-21 00:42:42', '2025-06-21 00:42:42'),
(2362, '9f34afc8-dee6-4e3a-8029-641fc257cd22', 1, 3, NULL, 'flash.income_deleted', 'messages', 'Income deleted successfully.', 'active', NULL, NULL, '2025-06-21 00:42:42', '2025-06-21 00:42:42'),
(2363, '9f34afc8-e1dd-4ad5-a57e-e97397ec6f4c', 1, 3, NULL, 'flash.visitor_saved', 'messages', 'Visitor saved successfully.', 'active', NULL, NULL, '2025-06-21 00:42:42', '2025-06-21 00:42:42'),
(2364, '9f34afc8-e4d1-4abc-84aa-bf03ae789250', 1, 3, NULL, 'flash.visitor_updated', 'messages', 'Visitor updated successfully.', 'active', NULL, NULL, '2025-06-21 00:42:42', '2025-06-21 00:42:42'),
(2365, '9f34afc8-e7d4-4fee-bb07-9dd984650a0e', 1, 3, NULL, 'flash.visitor_deleted', 'messages', 'Visitor deleted successfully.', 'active', NULL, NULL, '2025-06-21 00:42:42', '2025-06-21 00:42:42'),
(2366, '9f34afc8-eae3-41b0-90bf-ee6f3c9695d9', 1, 3, NULL, 'flash.vaccinated_patients_saved', 'messages', 'Vaccinated Patients saved successfully.', 'active', NULL, NULL, '2025-06-21 00:42:42', '2025-06-21 00:42:42'),
(2367, '9f34afc8-edce-4311-ade2-38417cbcf52d', 1, 3, NULL, 'flash.vaccinated_patients_retrieved', 'messages', 'Vaccinated Patients retrieved successfully.', 'active', NULL, NULL, '2025-06-21 00:42:42', '2025-06-21 00:42:42'),
(2368, '9f34afc8-fa05-4281-9064-21f9625da363', 1, 3, NULL, 'flash.vaccinated_patients_updated', 'messages', 'Vaccinated Patients updated successfully.', 'active', NULL, NULL, '2025-06-21 00:42:42', '2025-06-21 00:42:42'),
(2369, '9f34afc8-fe1b-4819-81d2-3b60e628c332', 1, 3, NULL, 'flash.vaccinated_patients_deleted', 'messages', 'Vaccinated Patients deleted successfully.', 'active', NULL, NULL, '2025-06-21 00:42:43', '2025-06-21 00:42:43'),
(2370, '9f34afc9-01a9-40e8-8083-cbe84c45da61', 1, 3, NULL, 'flash.vaccination_saved', 'messages', 'Vaccination saved successfully.', 'active', NULL, NULL, '2025-06-21 00:42:43', '2025-06-21 00:42:43'),
(2371, '9f34afc9-0495-41fc-bb04-ae0606b474f9', 1, 3, NULL, 'flash.vaccination_retrieved', 'messages', 'Vaccination retrieved successfully.', 'active', NULL, NULL, '2025-06-21 00:42:43', '2025-06-21 00:42:43'),
(2372, '9f34afc9-078a-412a-b953-8470a018dc68', 1, 3, NULL, 'flash.vaccination_updated', 'messages', 'Vaccination updated successfully.', 'active', NULL, NULL, '2025-06-21 00:42:43', '2025-06-21 00:42:43'),
(2373, '9f34afc9-0a81-4a84-ab19-09b0c6194358', 1, 3, NULL, 'flash.vaccination_cant_deleted', 'messages', 'Vaccination can\'t be deleted', 'active', NULL, NULL, '2025-06-21 00:42:43', '2025-06-21 00:42:43'),
(2374, '9f34afc9-0d71-412c-8f43-e44ef4dd2360', 1, 3, NULL, 'flash.vaccination_deleted', 'messages', 'Vaccination deleted successfully.', 'active', NULL, NULL, '2025-06-21 00:42:43', '2025-06-21 00:42:43'),
(2375, '9f34afc9-1074-4083-b8a1-409733f8b255', 1, 3, NULL, 'flash.invoice_saved', 'messages', 'Invoice saved successfully.', 'active', NULL, NULL, '2025-06-21 00:42:43', '2025-06-21 00:42:43'),
(2376, '9f34afc9-1398-48df-9464-836e749da8a6', 1, 3, NULL, 'flash.invoice_updated', 'messages', 'Invoice updated successfully.', 'active', NULL, NULL, '2025-06-21 00:42:43', '2025-06-21 00:42:43'),
(2377, '9f34afc9-1701-4fc2-aad1-87bd33cc1281', 1, 3, NULL, 'flash.invoice_deleted', 'messages', 'Invoice deleted successfully.', 'active', NULL, NULL, '2025-06-21 00:42:43', '2025-06-21 00:42:43'),
(2378, '9f34afc9-1a0b-4225-8038-b2bde34c05c0', 1, 3, NULL, 'flash.insurance_saved', 'messages', 'Insurance saved successfully.', 'active', NULL, NULL, '2025-06-21 00:42:43', '2025-06-21 00:42:43'),
(2379, '9f34afc9-1d07-47f7-9ea4-32d9678fa7f2', 1, 3, NULL, 'flash.invoice_id_already_exist', 'messages', 'Invoice id already exist', 'active', NULL, NULL, '2025-06-21 00:42:43', '2025-06-21 00:42:43'),
(2380, '9f34afc9-2039-4998-b179-6ea4c89c16e5', 1, 3, NULL, 'flash.insurance_updated', 'messages', 'Insurance updated successfully.', 'active', NULL, NULL, '2025-06-21 00:42:43', '2025-06-21 00:42:43'),
(2381, '9f34afc9-2327-45e6-a538-0f0199570e62', 1, 3, NULL, 'flash.insurance_cant_deleted', 'messages', 'Insurance Type can\'t be deleted.', 'active', NULL, NULL, '2025-06-21 00:42:43', '2025-06-21 00:42:43'),
(2382, '9f34afc9-2618-499a-a84f-171bc1fc1396', 1, 3, NULL, 'flash.insurance_deleted', 'messages', 'Insurance deleted successfully.', 'active', NULL, NULL, '2025-06-21 00:42:43', '2025-06-21 00:42:43'),
(2383, '9f34afc9-292c-4a0c-9357-2656c4895a66', 1, 3, NULL, 'flash.receptionist_saved', 'messages', 'Receptionist saved successfully.', 'active', NULL, NULL, '2025-06-21 00:42:43', '2025-06-21 00:42:43'),
(2384, '9f34afc9-2c0c-4fbe-b6b2-e44687548853', 1, 3, NULL, 'flash.receptionist_updated', 'messages', 'Receptionist updated successfully.', 'active', NULL, NULL, '2025-06-21 00:42:43', '2025-06-21 00:42:43'),
(2385, '9f34afc9-2ef6-4bea-bf2a-a934bab374ab', 1, 3, NULL, 'flash.receptionist_cant_deleted', 'messages', 'Receptionist Type can\'t be deleted.', 'active', NULL, NULL, '2025-06-21 00:42:43', '2025-06-21 00:42:43'),
(2386, '9f34afc9-3207-4c20-865a-8ac2004792d2', 1, 3, NULL, 'flash.receptionist_deleted', 'messages', 'Receptionist deleted successfully.', 'active', NULL, NULL, '2025-06-21 00:42:43', '2025-06-21 00:42:43'),
(2387, '9f34afc9-34eb-402f-975b-7a0ecb966856', 1, 3, NULL, 'flash.schedule_saved', 'messages', 'Schedule saved successfully.', 'active', NULL, NULL, '2025-06-21 00:42:43', '2025-06-21 00:42:43'),
(2388, '9f34afc9-37e8-4d92-870a-4e85c742cfde', 1, 3, NULL, 'flash.schedule_updated', 'messages', 'Schedule updated successfully.', 'active', NULL, NULL, '2025-06-21 00:42:43', '2025-06-21 00:42:43'),
(2389, '9f34afc9-3ad9-4dd2-b277-b4eff3653284', 1, 3, NULL, 'flash.schedule_cant_deleted', 'messages', 'Schedule Type can\'t be deleted.', 'active', NULL, NULL, '2025-06-21 00:42:43', '2025-06-21 00:42:43'),
(2390, '9f34afc9-3e20-4860-a08d-ee68ce79bae9', 1, 3, NULL, 'flash.schedule_deleted', 'messages', 'Schedule deleted successfully.', 'active', NULL, NULL, '2025-06-21 00:42:43', '2025-06-21 00:42:43'),
(2391, '9f34afc9-411e-4dea-ab54-ea9889d52a17', 1, 3, NULL, 'flash.frontService_saved', 'messages', 'FrontService saved successfully.', 'active', NULL, NULL, '2025-06-21 00:42:43', '2025-06-21 00:42:43'),
(2392, '9f34afc9-4422-488a-b209-6c2889be76e7', 1, 3, NULL, 'flash.frontService_retrieved', 'messages', 'FrontService retrieved successfully.', 'active', NULL, NULL, '2025-06-21 00:42:43', '2025-06-21 00:42:43'),
(2393, '9f34afc9-488d-4885-8ada-3871e12e122d', 1, 3, NULL, 'flash.frontService_updated', 'messages', 'FrontService updated successfully.', 'active', NULL, NULL, '2025-06-21 00:42:43', '2025-06-21 00:42:43'),
(2394, '9f34afc9-4bc2-4813-8d88-6481d6d2b547', 1, 3, NULL, 'flash.frontService_deleted', 'messages', 'FrontService deleted successfully.', 'active', NULL, NULL, '2025-06-21 00:42:43', '2025-06-21 00:42:43'),
(2395, '9f34afc9-4ee1-46f7-98fe-60b8fa36410f', 1, 3, NULL, 'flash.front_setting_updated', 'messages', 'Front Setting updated successfully.', 'active', NULL, NULL, '2025-06-21 00:42:43', '2025-06-21 00:42:43'),
(2396, '9f34afc9-51f6-4931-a6ad-a75c56e80de0', 1, 3, NULL, 'flash.order_created', 'messages', 'Order Created Successfully.', 'active', NULL, NULL, '2025-06-21 00:42:43', '2025-06-21 00:42:43'),
(2397, '9f34afc9-54ed-4b9d-895d-96ca1c2e63ff', 1, 3, NULL, 'flash.FAQs_created', 'messages', 'FAQs created successfully.', 'active', NULL, NULL, '2025-06-21 00:42:43', '2025-06-21 00:42:43'),
(2398, '9f34afc9-57e3-472a-a757-58b23d1be406', 1, 3, NULL, 'flash.FAQs_retrieved', 'messages', 'FAQs retrieved successfully.', 'active', NULL, NULL, '2025-06-21 00:42:43', '2025-06-21 00:42:43'),
(2399, '9f34afc9-5ae2-4120-a528-d93b1486305c', 1, 3, NULL, 'flash.FAQs_updated', 'messages', 'FAQs updated successfully.', 'active', NULL, NULL, '2025-06-21 00:42:43', '2025-06-21 00:42:43'),
(2400, '9f34afc9-5de6-4c08-94f2-d74567bf213c', 1, 3, NULL, 'flash.FAQs_deleted', 'messages', 'FAQs deleted successfully.', 'active', NULL, NULL, '2025-06-21 00:42:43', '2025-06-21 00:42:43'),
(2401, '9f34afc9-60e5-4ae6-b672-937ebd957885', 1, 3, NULL, 'flash.income_and_expense_retrieved', 'messages', 'Income and Expense report retrieved successfully.', 'active', NULL, NULL, '2025-06-21 00:42:43', '2025-06-21 00:42:43'),
(2402, '9f34afc9-6407-48de-af31-5e25cd5a894c', 1, 3, NULL, 'flash.income_report_generate', 'messages', 'Income Report Generate successfully.', 'active', NULL, NULL, '2025-06-21 00:42:43', '2025-06-21 00:42:43'),
(2403, '9f34afc9-670d-4c4a-8476-ca1b9e8718d8', 1, 3, NULL, 'flash.hospital_saved', 'messages', 'Hospital saved successfully.', 'active', NULL, NULL, '2025-06-21 00:42:43', '2025-06-21 00:42:43'),
(2404, '9f34afc9-6a0e-45a5-85d4-b15505126a48', 1, 3, NULL, 'flash.hospital_schedule_saved', 'messages', 'Hospital Schedule saved successfully.', 'active', NULL, NULL, '2025-06-21 00:42:43', '2025-06-21 00:42:43'),
(2405, '9f34afc9-6d20-4697-89fb-2008225bc5bd', 1, 3, NULL, 'flash.hospital_update', 'messages', 'Hospital updated successfully.', 'active', NULL, NULL, '2025-06-21 00:42:43', '2025-06-21 00:42:43'),
(2406, '9f34afc9-7080-4784-911b-612b5e3ba7d1', 1, 3, NULL, 'flash.IPD_bill_saved', 'messages', 'IPD Bill saved successfully.', 'active', NULL, NULL, '2025-06-21 00:42:43', '2025-06-21 00:42:43'),
(2407, '9f34afc9-7383-4d9b-8bef-3f5da9bdb23f', 1, 3, NULL, 'flash.document_type_saved', 'messages', 'Document Type saved successfully.', 'active', NULL, NULL, '2025-06-21 00:42:43', '2025-06-21 00:42:43'),
(2408, '9f34afc9-7668-4b2f-8db6-b8a6209a80c1', 1, 3, NULL, 'flash.document_type_not_found', 'messages', 'Document Type not found', 'active', NULL, NULL, '2025-06-21 00:42:43', '2025-06-21 00:42:43'),
(2409, '9f34afc9-79b1-45df-9bb3-c1344c2b17e8', 1, 3, NULL, 'flash.document_type_retrieved', 'messages', 'Document Type retrieved successfully.', 'active', NULL, NULL, '2025-06-21 00:42:43', '2025-06-21 00:42:43'),
(2410, '9f34afc9-7d11-4c33-90fc-a1c356fc36eb', 1, 3, NULL, 'flash.document_type_updated', 'messages', 'Document Type updated successfully.', 'active', NULL, NULL, '2025-06-21 00:42:43', '2025-06-21 00:42:43'),
(2411, '9f34afc9-8072-48af-84e2-b331f8ff5bbc', 1, 3, NULL, 'flash.document_type_cant_deleted', 'messages', 'Document Type can\'t be deleted.', 'active', NULL, NULL, '2025-06-21 00:42:43', '2025-06-21 00:42:43'),
(2412, '9f34afc9-8371-4a4b-8df9-babdbb4e7e28', 1, 3, NULL, 'flash.document_type_deleted', 'messages', 'Document Type deleted successfully.', 'active', NULL, NULL, '2025-06-21 00:42:43', '2025-06-21 00:42:43'),
(2413, '9f34afc9-8685-4702-b50e-aa208ee6d159', 1, 3, NULL, 'flash.subscription_plan_saved', 'messages', 'Subscription Plan created successfully.', 'active', NULL, NULL, '2025-06-21 00:42:43', '2025-06-21 00:42:43'),
(2414, '9f34afc9-895c-45b5-8ff8-b9f78eb5f66a', 1, 3, NULL, 'flash.subscription_plan_retrieved', 'messages', 'Subscription Plan retrieved successfully.', 'active', NULL, NULL, '2025-06-21 00:42:43', '2025-06-21 00:42:43'),
(2415, '9f34afc9-8cab-4538-815f-30439f9012e0', 1, 3, NULL, 'flash.subscription_plan_updated', 'messages', 'Subscription Plan updated successfully.', 'active', NULL, NULL, '2025-06-21 00:42:43', '2025-06-21 00:42:43'),
(2416, '9f34afc9-8fa2-4e17-94e5-bc2c71568f0a', 1, 3, NULL, 'flash.subscription_plan_cant_deleted', 'messages', 'Subscription Plan can\'t be deleted.', 'active', NULL, NULL, '2025-06-21 00:42:43', '2025-06-21 00:42:43'),
(2417, '9f34afc9-92a3-42fd-bb25-cf1b22a1a64e', 1, 3, NULL, 'flash.subscription_plan_deleted', 'messages', 'Subscription Plan deleted successfully.', 'active', NULL, NULL, '2025-06-21 00:42:43', '2025-06-21 00:42:43'),
(2418, '9f34afc9-9592-48a5-9b09-c7cc2f2b2794', 1, 3, NULL, 'flash.employee_payroll_saved', 'messages', 'Employee Payroll saved successfully.', 'active', NULL, NULL, '2025-06-21 00:42:43', '2025-06-21 00:42:43'),
(2419, '9f34afc9-98af-4697-ad86-2ec4558f5aa2', 1, 3, NULL, 'flash.employee_payroll_updated', 'messages', 'Employee Payroll updated successfully.', 'active', NULL, NULL, '2025-06-21 00:42:43', '2025-06-21 00:42:43'),
(2420, '9f34afc9-9bc4-498f-b787-87467cee6ae7', 1, 3, NULL, 'flash.employee_payroll_deleted', 'messages', 'Employee Payroll Deleted successfully.', 'active', NULL, NULL, '2025-06-21 00:42:43', '2025-06-21 00:42:43'),
(2421, '9f34afc9-9ec2-4ee7-be26-282725cde1ef', 1, 3, NULL, 'flash.employee_list_not_found', 'messages', 'Employees List not found', 'active', NULL, NULL, '2025-06-21 00:42:43', '2025-06-21 00:42:43');
INSERT INTO `ltu_phrases` (`id`, `uuid`, `translation_id`, `translation_file_id`, `phrase_id`, `key`, `group`, `value`, `status`, `parameters`, `note`, `created_at`, `updated_at`) VALUES
(2422, '9f34afc9-a1cc-4dcc-aa5e-ea24475f245b', 1, 3, NULL, 'flash.employee_payroll_retrieved', 'messages', 'Employee Payroll retrieved successfully.', 'active', NULL, NULL, '2025-06-21 00:42:43', '2025-06-21 00:42:43'),
(2423, '9f34afc9-a508-4472-b401-aef838654a89', 1, 3, NULL, 'flash.enquiry_send', 'messages', 'Enquiry send successfully.', 'active', NULL, NULL, '2025-06-21 00:42:43', '2025-06-21 00:42:43'),
(2424, '9f34afc9-a808-43da-b0b6-3424fce94dc5', 1, 3, NULL, 'flash.enquiry_delete', 'messages', 'Enquiry deleted successfully.', 'active', NULL, NULL, '2025-06-21 00:42:43', '2025-06-21 00:42:43'),
(2425, '9f34afc9-aaf5-4759-bcfa-6f8d44a88d4a', 1, 3, NULL, 'flash.testimonial_save', 'messages', 'Testimonial saved successfully.', 'active', NULL, NULL, '2025-06-21 00:42:43', '2025-06-21 00:42:43'),
(2426, '9f34afc9-ae06-457b-b2eb-af9ceadbacfa', 1, 3, NULL, 'flash.testimonial_retrieve', 'messages', 'Testimonials Retrieved Successfully.', 'active', NULL, NULL, '2025-06-21 00:42:43', '2025-06-21 00:42:43'),
(2427, '9f34afc9-b108-49d7-9795-8fd8735b0d28', 1, 3, NULL, 'flash.testimonial_update', 'messages', 'Testimonial updated successfully.', 'active', NULL, NULL, '2025-06-21 00:42:43', '2025-06-21 00:42:43'),
(2428, '9f34afc9-b429-494a-bc92-09934ea78fb1', 1, 3, NULL, 'flash.testimonial_delete', 'messages', 'Testimonial deleted successfully.', 'active', NULL, NULL, '2025-06-21 00:42:43', '2025-06-21 00:42:43'),
(2429, '9f34afc9-b723-4e4a-9e8b-4b0873dc7438', 1, 3, NULL, 'flash.new_tenant_assigned', 'messages', 'New tenant assigned successfully', 'active', NULL, NULL, '2025-06-21 00:42:43', '2025-06-21 00:42:43'),
(2430, '9f34afc9-ba43-4961-b456-9cbd9a509840', 1, 3, NULL, 'flash.password_update', 'messages', 'Password updated successfully.', 'active', NULL, NULL, '2025-06-21 00:42:43', '2025-06-21 00:42:43'),
(2431, '9f34afc9-bd3b-4ae7-96f7-1f7523a6865d', 1, 3, NULL, 'flash.profile_update', 'messages', 'Profile updated successfully.', 'active', NULL, NULL, '2025-06-21 00:42:43', '2025-06-21 00:42:43'),
(2432, '9f34afc9-c064-402b-9c0b-c28e52e0530d', 1, 3, NULL, 'flash.data_retrieved', 'messages', 'Data Retrieved Successfully.', 'active', NULL, NULL, '2025-06-21 00:42:43', '2025-06-21 00:42:43'),
(2433, '9f34afc9-c39e-4c00-93e9-17496774ae6a', 1, 3, NULL, 'flash.subscription_created', 'messages', 'Subscription created successfully.', 'active', NULL, NULL, '2025-06-21 00:42:43', '2025-06-21 00:42:43'),
(2434, '9f34afc9-cc38-4c10-b0d6-c9977473ece0', 1, 3, NULL, 'flash.subscription_updated', 'messages', 'Subscription updated successfully.', 'active', NULL, NULL, '2025-06-21 00:42:43', '2025-06-21 00:42:43'),
(2435, '9f34afc9-cf84-4373-ac49-9076ac52e6f5', 1, 3, NULL, 'flash.subscription_retrieved', 'messages', 'Subscription retrieved successfully.', 'active', NULL, NULL, '2025-06-21 00:42:43', '2025-06-21 00:42:43'),
(2436, '9f34afc9-d289-4d6a-8e41-25995c683685', 1, 3, NULL, 'flash.postal_receive_saved', 'messages', 'Postal Receive saved successfully.', 'active', NULL, NULL, '2025-06-21 00:42:43', '2025-06-21 00:42:43'),
(2437, '9f34afc9-d575-4060-8167-2616322248a8', 1, 3, NULL, 'flash.postal_dispatch_saved', 'messages', 'Postal Dispatch saved successfully.', 'active', NULL, NULL, '2025-06-21 00:42:43', '2025-06-21 00:42:43'),
(2438, '9f34afc9-d859-49c3-9846-1079350f39c2', 1, 3, NULL, 'flash.postal_dispatch_deleted', 'messages', 'Postal Dispatch deleted successfully.', 'active', NULL, NULL, '2025-06-21 00:42:43', '2025-06-21 00:42:43'),
(2439, '9f34afc9-db3b-4846-aeee-a85accd52bd4', 1, 3, NULL, 'flash.postal_receive_retrieved', 'messages', 'Postal Receive retrieved successfully.', 'active', NULL, NULL, '2025-06-21 00:42:43', '2025-06-21 00:42:43'),
(2440, '9f34afc9-de49-47a5-babf-61f0cdf5f319', 1, 3, NULL, 'flash.postal_dispatch_retrieved', 'messages', 'Postal Dispatch retrieved successfully.', 'active', NULL, NULL, '2025-06-21 00:42:43', '2025-06-21 00:42:43'),
(2441, '9f34afc9-e174-4e9b-bb6a-b7769f428938', 1, 3, NULL, 'flash.postal_receive_update', 'messages', 'Postal Receive update successfully.', 'active', NULL, NULL, '2025-06-21 00:42:43', '2025-06-21 00:42:43'),
(2442, '9f34afc9-e47f-4207-ab1a-0d74162605f2', 1, 3, NULL, 'flash.postal_receive_deleted', 'messages', 'Postal Receive deleted successfully.', 'active', NULL, NULL, '2025-06-21 00:42:43', '2025-06-21 00:42:43'),
(2443, '9f34afc9-e768-46c7-82f4-fd895122805a', 1, 3, NULL, 'flash.postal_dispatch_update', 'messages', 'Postal Dispatch update successfully', 'active', NULL, NULL, '2025-06-21 00:42:43', '2025-06-21 00:42:43'),
(2444, '9f34afc9-ea73-4396-9c06-683a599c5077', 1, 3, NULL, 'flash.postal_deleted', 'messages', 'Postal deleted successfully.', 'active', NULL, NULL, '2025-06-21 00:42:43', '2025-06-21 00:42:43'),
(2445, '9f34afc9-ed85-4142-83ac-ac35212780a0', 1, 3, NULL, 'flash.investigation_report_saved', 'messages', 'Investigation Report saved successfully.', 'active', NULL, NULL, '2025-06-21 00:42:43', '2025-06-21 00:42:43'),
(2446, '9f34afc9-f089-43ae-a5c2-b5794e4d3e16', 1, 3, NULL, 'flash.investigation_report_not_found', 'messages', 'Investigation Report not found', 'active', NULL, NULL, '2025-06-21 00:42:43', '2025-06-21 00:42:43'),
(2447, '9f34afc9-f3ab-49d4-a3da-54fe2e36b58c', 1, 3, NULL, 'flash.investigation_report_updated', 'messages', 'Investigation Report updated successfully.', 'active', NULL, NULL, '2025-06-21 00:42:43', '2025-06-21 00:42:43'),
(2448, '9f34afc9-f6a7-45e8-af51-86c1b03659f9', 1, 3, NULL, 'flash.investigation_report_deleted', 'messages', 'Investigation Report deleted successfully.', 'active', NULL, NULL, '2025-06-21 00:42:43', '2025-06-21 00:42:43'),
(2449, '9f34afc9-f999-4064-abb8-9b4f192e36c6', 1, 3, NULL, 'flash.sms_limit_over', 'messages', 'Your current plan sms limit is over.', 'active', NULL, NULL, '2025-06-21 00:42:43', '2025-06-21 00:42:43'),
(2450, '9f34afc9-fc96-4351-ab72-4cfb3ae70412', 1, 3, NULL, 'flash.sms_send', 'messages', 'SMS send successfully.', 'active', NULL, NULL, '2025-06-21 00:42:43', '2025-06-21 00:42:43'),
(2451, '9f34afc9-ff93-4924-a251-e01deb7524ba', 1, 3, NULL, 'flash.sms_delete', 'messages', 'SMS delete successfully', 'active', NULL, NULL, '2025-06-21 00:42:43', '2025-06-21 00:42:43'),
(2452, '9f34afca-0257-4ee3-b236-66c6d013883a', 1, 3, NULL, 'flash.user_list_not', 'messages', 'User List not found', 'active', NULL, NULL, '2025-06-21 00:42:43', '2025-06-21 00:42:43'),
(2453, '9f34afca-0545-4c83-9c48-c2241ec816e3', 1, 3, NULL, 'flash.user_retrieved', 'messages', 'User retrieved successfully.', 'active', NULL, NULL, '2025-06-21 00:42:43', '2025-06-21 00:42:43'),
(2454, '9f34afca-085a-496d-b021-38dad0f8f608', 1, 3, NULL, 'flash.language_update', 'messages', 'Language Updated Successfully.', 'active', NULL, NULL, '2025-06-21 00:42:43', '2025-06-21 00:42:43'),
(2455, '9f34afca-0b53-49eb-a398-390f1d810dff', 1, 3, NULL, 'flash.sms_retrieved', 'messages', 'SMS Retrieved', 'active', NULL, NULL, '2025-06-21 00:42:43', '2025-06-21 00:42:43'),
(2456, '9f34afca-0e53-4783-b7a9-a68628e2a170', 1, 3, NULL, 'flash.email_verified', 'messages', 'Email Verified successfully.', 'active', NULL, NULL, '2025-06-21 00:42:43', '2025-06-21 00:42:43'),
(2457, '9f34afca-115a-4e5b-9488-cefca8a0f480', 1, 3, NULL, 'flash.default_plan_changed', 'messages', 'Default plan changed successfully.', 'active', NULL, NULL, '2025-06-21 00:42:43', '2025-06-21 00:42:43'),
(2458, '9f34afca-146b-4696-a600-04a66dbba5ec', 1, 3, NULL, 'flash.session_created', 'messages', 'Session created successfully.', 'active', NULL, NULL, '2025-06-21 00:42:43', '2025-06-21 00:42:43'),
(2459, '9f34afca-174a-4631-b80e-9888b7bd003f', 1, 3, NULL, 'flash.your_payment_success', 'messages', 'Your Payment is successfully completed.', 'active', NULL, NULL, '2025-06-21 00:42:43', '2025-06-21 00:42:43'),
(2460, '9f34afca-1a56-4033-bd8b-075f8a12d4e9', 1, 3, NULL, 'flash.your_payment_failed', 'messages', 'Your Payment is failed.', 'active', NULL, NULL, '2025-06-21 00:42:43', '2025-06-21 00:42:43'),
(2461, '9f34afca-1d65-4a5d-8df4-5f8ab2487111', 1, 3, NULL, 'flash.cannot_switch', 'messages', 'Cannot switch to zero plan if trial is available / having a paid plan which is currently active', 'active', NULL, NULL, '2025-06-21 00:42:43', '2025-06-21 00:42:43'),
(2462, '9f34afca-2071-4fd9-bc9d-16fdab83c172', 1, 3, NULL, 'flash.some_doctors', 'messages', 'Some doctors have scheduled their days in given unchecked days, so are you sure you want to perform this operation?', 'active', NULL, NULL, '2025-06-21 00:42:43', '2025-06-21 00:42:43'),
(2463, '9f34afca-236b-444a-853f-82a480917e27', 1, 3, NULL, 'flash.currency_not_supported_paypal', 'messages', 'This currency is not supported by PayPal for making payments.', 'active', NULL, NULL, '2025-06-21 00:42:43', '2025-06-21 00:42:43'),
(2464, '9f34afca-2651-491b-98cd-9e711770652d', 1, 3, NULL, 'flash.currency_not_supported_razorpay', 'messages', 'This currency is not supported by Razorpay for making payments.', 'active', NULL, NULL, '2025-06-21 00:42:43', '2025-06-21 00:42:43'),
(2465, '9f34afca-295a-4c17-b7d3-39472bd00c2b', 1, 3, NULL, 'flash.unable_to_process', 'messages', 'Unable to process the payment at the moment. Try again later.', 'active', NULL, NULL, '2025-06-21 00:42:43', '2025-06-21 00:42:43'),
(2466, '9f34afca-2c51-42de-aa21-1ac53e900f33', 1, 3, NULL, 'flash.the_patient', 'messages', 'The patient is already registered with same vaccine and dose no.', 'active', NULL, NULL, '2025-06-21 00:42:43', '2025-06-21 00:42:43'),
(2467, '9f34afca-2f6b-414c-8299-491567f87ce3', 1, 3, NULL, 'flash.opd_diagnosis_report_generated', 'messages', 'Diagnosis Report generated Successfully.', 'active', NULL, NULL, '2025-06-21 00:42:43', '2025-06-21 00:42:43'),
(2468, '9f34afca-3272-4c1b-a2e2-0186d68faf56', 1, 3, NULL, 'flash.failed_to_redirect', 'messages', 'Failed to Redirect', 'active', NULL, NULL, '2025-06-21 00:42:43', '2025-06-21 00:42:43'),
(2469, '9f34afca-3581-44ed-a9f8-f6a13c056087', 1, 3, NULL, 'flash.access_denied', 'messages', 'Access Denied', 'active', NULL, NULL, '2025-06-21 00:42:43', '2025-06-21 00:42:43'),
(2470, '9f34afca-387f-4333-be68-a9fe8d5bacd1', 1, 3, NULL, 'flash.patient_smart_card_deleted', 'messages', 'Patient Smart Card Deleted Successfully.', 'active', NULL, NULL, '2025-06-21 00:42:43', '2025-06-21 00:42:43'),
(2471, '9f34afca-3ba2-48c6-ad4d-01ef7adcf65f', 1, 3, NULL, 'flash.smart_patient_card_template_already_in_use', 'messages', 'Smart Patient Card Template already in use.', 'active', NULL, NULL, '2025-06-21 00:42:43', '2025-06-21 00:42:43'),
(2472, '9f34afca-3eb0-482a-a617-4c964b2c9e90', 1, 3, NULL, 'flash.please_select_header_color', 'messages', 'Please select header color', 'active', NULL, NULL, '2025-06-21 00:42:43', '2025-06-21 00:42:43'),
(2473, '9f34afca-41b1-4497-b5e5-03a359f34e44', 1, 3, NULL, 'flash.odontogram_created', 'messages', 'Odontogram Created Successfully.', 'active', NULL, NULL, '2025-06-21 00:42:43', '2025-06-21 00:42:43'),
(2474, '9f34afca-44d9-4fdd-9532-f9a2e9013e90', 1, 3, NULL, 'flash.odontogram_updated', 'messages', 'Odontogram Updated Successfully.', 'active', NULL, NULL, '2025-06-21 00:42:43', '2025-06-21 00:42:43'),
(2475, '9f34afca-47f3-4190-98ca-a7aaabeaafe4', 1, 3, NULL, 'flash.odontogram_deleted', 'messages', 'Odontogram Deleted Successfully.', 'active', NULL, NULL, '2025-06-21 00:42:43', '2025-06-21 00:42:43'),
(2476, '9f34afca-4bff-485f-ab32-cc752fbe8da8', 1, 3, NULL, 'purchase_medicine.purchase_number', 'messages', 'Purchase Number', 'active', NULL, NULL, '2025-06-21 00:42:43', '2025-06-21 00:42:43'),
(2477, '9f34afca-4ef8-4c3a-b739-0eebc4e76716', 1, 3, NULL, 'purchase_medicine.total', 'messages', 'Total', 'active', NULL, NULL, '2025-06-21 00:42:43', '2025-06-21 00:42:43'),
(2478, '9f34afca-5200-419b-9280-d98b9e7ae0e2', 1, 3, NULL, 'purchase_medicine.discount', 'messages', 'Discount', 'active', NULL, NULL, '2025-06-21 00:42:43', '2025-06-21 00:42:43'),
(2479, '9f34afca-54ed-49e3-b7f2-05aa197f4189', 1, 3, NULL, 'purchase_medicine.tax_amount', 'messages', 'Tax Amount', 'active', NULL, NULL, '2025-06-21 00:42:43', '2025-06-21 00:42:43'),
(2480, '9f34afca-5808-4d36-b1bb-e8a1c6b4d5ff', 1, 3, NULL, 'purchase_medicine.net_amount', 'messages', 'Net Amount', 'active', NULL, NULL, '2025-06-21 00:42:43', '2025-06-21 00:42:43'),
(2481, '9f34afca-5b11-4fe2-9160-f08861a09f62', 1, 3, NULL, 'purchase_medicine.payment_mode', 'messages', 'Payment Mode', 'active', NULL, NULL, '2025-06-21 00:42:43', '2025-06-21 00:42:43'),
(2482, '9f34afca-5e12-4ce3-ab0a-80641df157a6', 1, 3, NULL, 'purchase_medicine.payment_note', 'messages', 'Payment Note', 'active', NULL, NULL, '2025-06-21 00:42:43', '2025-06-21 00:42:43'),
(2483, '9f34afca-6110-4601-b982-9784c82055b3', 1, 3, NULL, 'purchase_medicine.note', 'messages', 'Note', 'active', NULL, NULL, '2025-06-21 00:42:43', '2025-06-21 00:42:43'),
(2484, '9f34afca-63ef-4f43-b99e-75128607fb45', 1, 3, NULL, 'purchase_medicine.purchase_medicine', 'messages', 'Purchase Medicine', 'active', NULL, NULL, '2025-06-21 00:42:43', '2025-06-21 00:42:43'),
(2485, '9f34afca-66f3-4816-911d-af77f4e5b5ac', 1, 3, NULL, 'purchase_medicine.purchase_medicine_details', 'messages', 'Purchase Medicine Details', 'active', NULL, NULL, '2025-06-21 00:42:43', '2025-06-21 00:42:43'),
(2486, '9f34afca-69f2-4c06-bfd4-8225f69e6126', 1, 3, NULL, 'purchase_medicine.purchase_medicine_overview', 'messages', 'Purchase Medicine Overview', 'active', NULL, NULL, '2025-06-21 00:42:43', '2025-06-21 00:42:43'),
(2487, '9f34afca-6d0a-4dd9-a9ad-2b06d97ea1b5', 1, 3, NULL, 'purchase_medicine.lot_no', 'messages', 'Lot no.', 'active', NULL, NULL, '2025-06-21 00:42:43', '2025-06-21 00:42:43'),
(2488, '9f34afca-700e-4e02-9bfe-6e15ac36c58c', 1, 3, NULL, 'purchase_medicine.tax', 'messages', 'Tax', 'active', NULL, NULL, '2025-06-21 00:42:43', '2025-06-21 00:42:43'),
(2489, '9f34afca-7306-4230-ad9e-1db0d5a004ca', 1, 3, NULL, 'purchase_medicine.quantity', 'messages', 'Quantity', 'active', NULL, NULL, '2025-06-21 00:42:43', '2025-06-21 00:42:43'),
(2490, '9f34afca-760b-4a5a-b19e-6fdb0c6d89b1', 1, 3, NULL, 'purchase_medicine.amount', 'messages', 'Amount', 'active', NULL, NULL, '2025-06-21 00:42:43', '2025-06-21 00:42:43'),
(2491, '9f34afca-7909-403f-a94d-49e8e9ed3fd0', 1, 3, NULL, 'purchase_medicine.expiry_date', 'messages', 'Expiry Date', 'active', NULL, NULL, '2025-06-21 00:42:43', '2025-06-21 00:42:43'),
(2492, '9f34afca-7bff-4336-b607-359d81862f0d', 1, 3, NULL, 'purchase_medicine.other_details', 'messages', 'Other Details', 'active', NULL, NULL, '2025-06-21 00:42:43', '2025-06-21 00:42:43'),
(2493, '9f34afca-7f0d-4fe9-a42a-feb9697f8133', 1, 3, NULL, 'purchase_medicine.dose_duration', 'messages', 'Dose Duration', 'active', NULL, NULL, '2025-06-21 00:42:43', '2025-06-21 00:42:43'),
(2494, '9f34afca-820f-4455-9472-529efb3f0ea2', 1, 3, NULL, 'used_medicine.used_medicine', 'messages', 'Used Medicine', 'active', NULL, NULL, '2025-06-21 00:42:44', '2025-06-21 00:42:44'),
(2495, '9f34afca-8512-4541-8bdd-b4408a8136db', 1, 3, NULL, 'used_medicine.used_quantity', 'messages', 'Used Quantity', 'active', NULL, NULL, '2025-06-21 00:42:44', '2025-06-21 00:42:44'),
(2496, '9f34afca-8829-46b6-a9c1-57d2de412811', 1, 3, NULL, 'used_medicine.used_at', 'messages', 'Used At', 'active', NULL, NULL, '2025-06-21 00:42:44', '2025-06-21 00:42:44'),
(2497, '9f34afca-8b6b-4bd8-a3e1-4351849d7b90', 1, 3, NULL, 'medicine_bills.medicine_bills', 'messages', 'Medicine Bills', 'active', NULL, NULL, '2025-06-21 00:42:44', '2025-06-21 00:42:44'),
(2498, '9f34afca-8e7e-420f-9c2a-e91a2f5d5739', 1, 3, NULL, 'medicine_bills.medicine_bill', 'messages', 'Medicine Bill', 'active', NULL, NULL, '2025-06-21 00:42:44', '2025-06-21 00:42:44'),
(2499, '9f34afca-9191-4b21-a31a-e6ef09444714', 1, 3, NULL, 'medicine_bills.add_medicine_bill', 'messages', 'Add Medicine Bill', 'active', NULL, NULL, '2025-06-21 00:42:44', '2025-06-21 00:42:44'),
(2500, '9f34afca-949b-43de-8767-dae6bbda11ad', 1, 3, NULL, 'medicine_bills.edit_medicine_bill', 'messages', 'Edit Medicine Bill', 'active', NULL, NULL, '2025-06-21 00:42:44', '2025-06-21 00:42:44'),
(2501, '9f34afca-97ba-4f66-b0ee-55c00775e137', 1, 3, NULL, 'medicine_bills.medicine_bill_details', 'messages', 'Medicine Bill details', 'active', NULL, NULL, '2025-06-21 00:42:44', '2025-06-21 00:42:44'),
(2502, '9f34afca-9ac9-4b71-8420-cc68d9971bbc', 1, 3, NULL, 'medicine_bills.dose_interval', 'messages', 'Dose Interval', 'active', NULL, NULL, '2025-06-21 00:42:44', '2025-06-21 00:42:44'),
(2503, '9f34afca-9de4-401c-8e4f-ebbb2886a353', 1, 3, NULL, 'medicine_bills.available_quantity', 'messages', 'The available quantity of', 'active', NULL, NULL, '2025-06-21 00:42:44', '2025-06-21 00:42:44'),
(2504, '9f34afca-a0c6-4a87-8190-d5614345fada', 1, 3, NULL, 'medicine_bills.is', 'messages', 'is', 'active', NULL, NULL, '2025-06-21 00:42:44', '2025-06-21 00:42:44'),
(2505, '9f34afca-a3d9-459a-a153-eef568f61530', 1, 3, NULL, 'medicine_bills.prescription_not_found', 'messages', 'Prescription not found.', 'active', NULL, NULL, '2025-06-21 00:42:44', '2025-06-21 00:42:44'),
(2506, '9f34afca-a6e7-4c3f-ade1-ddd48759235c', 1, 3, NULL, 'medicine_bills.medicine_not_selected', 'messages', 'Please select at least one medicine.', 'active', NULL, NULL, '2025-06-21 00:42:44', '2025-06-21 00:42:44'),
(2507, '9f34afca-aa11-4523-943f-15ac58ac6f3d', 1, 3, NULL, 'medicine_bills.duplicate_medicine', 'messages', 'Cannot add duplicate medicines.', 'active', NULL, NULL, '2025-06-21 00:42:44', '2025-06-21 00:42:44'),
(2508, '9f34afca-ad0e-4137-b565-f18a78f17460', 1, 3, NULL, 'medicine_bills.payment_status', 'messages', 'Payment Status', 'active', NULL, NULL, '2025-06-21 00:42:44', '2025-06-21 00:42:44'),
(2509, '9f34afca-b00c-4aaf-a5d4-649b7633e944', 1, 3, NULL, 'medicine_bills.sale_price', 'messages', 'Sale Price', 'active', NULL, NULL, '2025-06-21 00:42:44', '2025-06-21 00:42:44'),
(2510, '9f34afca-b331-4a1a-8d60-d33afd65a324', 1, 3, NULL, 'medicine_bills.select_medicine', 'messages', 'Select Medicine', 'active', NULL, NULL, '2025-06-21 00:42:44', '2025-06-21 00:42:44'),
(2511, '9f34afca-b649-4330-8d92-440e4f398c2a', 1, 3, NULL, 'medicine_bills.update_quantity', 'messages', 'Update quantity should be less than previous quantity.', 'active', NULL, NULL, '2025-06-21 00:42:44', '2025-06-21 00:42:44'),
(2512, '9f34afca-b95b-4b30-81ba-6e85f5e2c189', 1, 3, NULL, 'medicine_bills.net_amount_not_empty', 'messages', 'Net amount can not be empty.', 'active', NULL, NULL, '2025-06-21 00:42:44', '2025-06-21 00:42:44'),
(2513, '9f34afca-bc4c-435c-9e61-f0096574570d', 1, 3, NULL, 'medicine_bills.net_amount_not_zero', 'messages', 'Net amount can not be zero.', 'active', NULL, NULL, '2025-06-21 00:42:44', '2025-06-21 00:42:44'),
(2514, '9f34afca-bf78-440d-8aca-c1eb4f2b6522', 1, 3, NULL, 'medicine_bills.medicine_required', 'messages', 'Medicine field is required.', 'active', NULL, NULL, '2025-06-21 00:42:44', '2025-06-21 00:42:44'),
(2515, '9f34afca-c266-4f4e-81a6-908234f9d337', 1, 3, NULL, 'medicine_bills.bill_number', 'messages', 'Bill Number', 'active', NULL, NULL, '2025-06-21 00:42:44', '2025-06-21 00:42:44'),
(2516, '9f34afca-c567-444a-bcab-10aa391a4492', 1, 3, NULL, 'medicine_bills.connect_with_zoom', 'messages', 'Connect With Zoom', 'active', NULL, NULL, '2025-06-21 00:42:44', '2025-06-21 00:42:44'),
(2517, '9f34afca-c864-435e-9bcd-d3c572407fc7', 1, 3, NULL, 'medicine_bills.connected', 'messages', 'Connected', 'active', NULL, NULL, '2025-06-21 00:42:44', '2025-06-21 00:42:44'),
(2518, '9f34afca-cb6a-42b3-8a0d-bdaf006825ef', 1, 3, NULL, 'new_change.current_password_invalid', 'messages', 'Current password is invalid.', 'active', NULL, NULL, '2025-06-21 00:42:44', '2025-06-21 00:42:44'),
(2519, '9f34afca-ce64-4e3a-8281-54021621996f', 1, 3, NULL, 'new_change.captcha_verification_failed', 'messages', 'Captcha verification failed.', 'active', NULL, NULL, '2025-06-21 00:42:44', '2025-06-21 00:42:44'),
(2520, '9f34afca-d180-46e8-b5ca-d09ed69d5bf8', 1, 3, NULL, 'new_change.paystack_created', 'messages', 'Paystack created successfully.', 'active', NULL, NULL, '2025-06-21 00:42:44', '2025-06-21 00:42:44'),
(2521, '9f34afca-d494-40dc-a76f-5d043ac4f290', 1, 3, NULL, 'new_change.unique_vehicle_number', 'messages', 'The vehicle number has already been taken.', 'active', NULL, NULL, '2025-06-21 00:42:44', '2025-06-21 00:42:44'),
(2522, '9f34afca-d79c-4428-a4b9-213b84224525', 1, 3, NULL, 'new_change.unique_patient', 'messages', 'The patient\'s name has already been taken.', 'active', NULL, NULL, '2025-06-21 00:42:44', '2025-06-21 00:42:44'),
(2523, '9f34afca-dab7-4d2d-8a9c-fca768ab4b12', 1, 3, NULL, 'new_change.select_appointment_date', 'messages', 'Please select appointment date.', 'active', NULL, NULL, '2025-06-21 00:42:44', '2025-06-21 00:42:44'),
(2524, '9f34afca-ddbc-4b7e-9a43-bbf8884f6dcb', 1, 3, NULL, 'new_change.select_time_slot', 'messages', 'Please select appointment time slot.', 'active', NULL, NULL, '2025-06-21 00:42:44', '2025-06-21 00:42:44'),
(2525, '9f34afca-e0dc-456d-b7e2-e8b7b5cb37b5', 1, 3, NULL, 'new_change.pending_payment', 'messages', 'Pending Payment', 'active', NULL, NULL, '2025-06-21 00:42:44', '2025-06-21 00:42:44'),
(2526, '9f34afca-e3dd-4a42-a818-5a476b026b06', 1, 3, NULL, 'new_change.have_to_connect_zoom', 'messages', 'You have to connect with zoom.', 'active', NULL, NULL, '2025-06-21 00:42:44', '2025-06-21 00:42:44'),
(2527, '9f34afca-e6f3-4116-a8f3-8146f86e0a0a', 1, 3, NULL, 'new_change.invalid_token', 'messages', 'Invalid access token.', 'active', NULL, NULL, '2025-06-21 00:42:44', '2025-06-21 00:42:44'),
(2528, '9f34afca-ea04-4481-8843-700c448d19c5', 1, 3, NULL, 'new_change.in_progress', 'messages', 'Sorry, you cannot delete this meeting since it\'s in progress.', 'active', NULL, NULL, '2025-06-21 00:42:44', '2025-06-21 00:42:44'),
(2529, '9f34afca-ecee-46ff-80b3-3e6095be19b1', 1, 3, NULL, 'new_change.add_credential', 'messages', 'Please, add credentials for zoom meeting.', 'active', NULL, NULL, '2025-06-21 00:42:44', '2025-06-21 00:42:44'),
(2530, '9f34afca-efef-4a41-9413-bce84c2fcd7c', 1, 3, NULL, 'new_change.already_in_use', 'messages', 'Your zoom credentials are already in use.', 'active', NULL, NULL, '2025-06-21 00:42:44', '2025-06-21 00:42:44'),
(2531, '9f34afca-f2e5-49a9-aad3-8932780cae50', 1, 3, NULL, 'new_change.all_required_fields', 'messages', 'Please fill all the required fields.', 'active', NULL, NULL, '2025-06-21 00:42:44', '2025-06-21 00:42:44'),
(2532, '9f34afca-f60c-4ab5-a766-56974c5638e7', 1, 3, NULL, 'new_change.password_not_match', 'messages', 'Password and Confirm password not match.', 'active', NULL, NULL, '2025-06-21 00:42:44', '2025-06-21 00:42:44'),
(2533, '9f34afca-f900-4e5b-a13f-650cfdc1d75f', 1, 3, NULL, 'new_change.subscribed_success', 'messages', 'Subscribed Successfully.', 'active', NULL, NULL, '2025-06-21 00:42:44', '2025-06-21 00:42:44'),
(2534, '9f34afca-fc6d-43ef-89f8-0d91f9dc753b', 1, 3, NULL, 'new_change.not_have_account', 'messages', 'Don’t have an account', 'active', NULL, NULL, '2025-06-21 00:42:44', '2025-06-21 00:42:44'),
(2535, '9f34afca-ff93-4761-b38d-a8fee4bd37d9', 1, 3, NULL, 'new_change.google_captcha_required', 'messages', 'The Google reCaptcha field is required.', 'active', NULL, NULL, '2025-06-21 00:42:44', '2025-06-21 00:42:44'),
(2536, '9f34afcb-02a0-4483-906f-86526ec22736', 1, 3, NULL, 'new_change.captcha_failed', 'messages', 'Captcha verification failed', 'active', NULL, NULL, '2025-06-21 00:42:44', '2025-06-21 00:42:44'),
(2537, '9f34afcb-05e1-4818-a166-d2a3c20645b1', 1, 3, NULL, 'new_change.case_required', 'messages', 'The case field is required.', 'active', NULL, NULL, '2025-06-21 00:42:44', '2025-06-21 00:42:44'),
(2538, '9f34afcb-0901-4f22-a74c-13a248b24a9f', 1, 3, NULL, 'new_change.bed_required', 'messages', 'The bed field is required.', 'active', NULL, NULL, '2025-06-21 00:42:44', '2025-06-21 00:42:44'),
(2539, '9f34afcb-0c12-45e8-b37c-23cd75175415', 1, 3, NULL, 'new_change.best_resolution_profile', 'messages', 'Best resolution for this profile will be', 'active', NULL, NULL, '2025-06-21 00:42:44', '2025-06-21 00:42:44'),
(2540, '9f34afcb-0f29-4d5b-b0da-5831a48f0022', 1, 3, NULL, 'new_change.best_resolution_icon', 'messages', 'Best resolution for this icon will be', 'active', NULL, NULL, '2025-06-21 00:42:44', '2025-06-21 00:42:44'),
(2541, '9f34afcb-1255-4a29-a9a4-bca3410c9eef', 1, 3, NULL, 'new_change.best_resolution_image', 'messages', 'Best resolution for this image will be', 'active', NULL, NULL, '2025-06-21 00:42:44', '2025-06-21 00:42:44'),
(2542, '9f34afcb-154a-4ae7-beb7-9516c1496467', 1, 3, NULL, 'new_change.select_ipd_patient', 'messages', 'Select IPD Patient', 'active', NULL, NULL, '2025-06-21 00:42:44', '2025-06-21 00:42:44'),
(2543, '9f34afcb-184d-4007-93d8-06f6cafa5500', 1, 3, NULL, 'new_change.currency_update', 'messages', 'Currency updated successfully', 'active', NULL, NULL, '2025-06-21 00:42:44', '2025-06-21 00:42:44'),
(2544, '9f34afcb-1b5e-4597-9ab5-18afb1c3188c', 1, 3, NULL, 'new_change.currency_store', 'messages', 'Currency saved successfully', 'active', NULL, NULL, '2025-06-21 00:42:44', '2025-06-21 00:42:44'),
(2545, '9f34afcb-1e76-4ead-beaf-471833085f8b', 1, 3, NULL, 'new_change.plan_price', 'messages', 'Plan Price', 'active', NULL, NULL, '2025-06-21 00:42:44', '2025-06-21 00:42:44'),
(2546, '9f34afcb-219f-4a6e-8e6e-d6d17a182230', 1, 3, NULL, 'new_change.new_plan', 'messages', 'New Plan', 'active', NULL, NULL, '2025-06-21 00:42:44', '2025-06-21 00:42:44'),
(2547, '9f34afcb-24b0-4e6c-8364-9c7655ecd516', 1, 3, NULL, 'new_change.pre_plan', 'messages', 'Remaining Balance of Prev. Plan', 'active', NULL, NULL, '2025-06-21 00:42:44', '2025-06-21 00:42:44'),
(2548, '9f34afcb-27ac-412c-ad6a-456acf4d63d0', 1, 3, NULL, 'new_change.payable_amount', 'messages', 'Payable Amount', 'active', NULL, NULL, '2025-06-21 00:42:44', '2025-06-21 00:42:44'),
(2549, '9f34afcb-2a9b-4856-a744-d47d94515ff8', 1, 3, NULL, 'new_change.remaining_days', 'messages', 'Remaining days', 'active', NULL, NULL, '2025-06-21 00:42:44', '2025-06-21 00:42:44'),
(2550, '9f34afcb-2db0-4cd6-8bfb-ac9d9c727789', 1, 3, NULL, 'new_change.used_balance', 'messages', 'Used Balance', 'active', NULL, NULL, '2025-06-21 00:42:44', '2025-06-21 00:42:44'),
(2551, '9f34afcb-30c4-4ce7-b438-3c2c56bfa00f', 1, 3, NULL, 'new_change.current_plan', 'messages', 'Current Plan', 'active', NULL, NULL, '2025-06-21 00:42:44', '2025-06-21 00:42:44'),
(2552, '9f34afcb-33d3-4659-9f70-7b3ce70f37da', 1, 3, NULL, 'new_change.current_expired_plan', 'messages', 'Current Expired Plan', 'active', NULL, NULL, '2025-06-21 00:42:44', '2025-06-21 00:42:44'),
(2553, '9f34afcb-36f9-4227-b898-b26515b86a03', 1, 3, NULL, 'new_change.sunday', 'messages', 'Sunday', 'active', NULL, NULL, '2025-06-21 00:42:44', '2025-06-21 00:42:44'),
(2554, '9f34afcb-3a04-4f00-83ff-3a7ed0755930', 1, 3, NULL, 'new_change.monday', 'messages', 'Monday', 'active', NULL, NULL, '2025-06-21 00:42:44', '2025-06-21 00:42:44'),
(2555, '9f34afcb-3d1e-4e6d-91b2-fb6b5abfff29', 1, 3, NULL, 'new_change.tuesday', 'messages', 'Tuesday', 'active', NULL, NULL, '2025-06-21 00:42:44', '2025-06-21 00:42:44'),
(2556, '9f34afcb-4025-43c1-b6f4-8b17416880af', 1, 3, NULL, 'new_change.wednesday', 'messages', 'Wednesday', 'active', NULL, NULL, '2025-06-21 00:42:44', '2025-06-21 00:42:44'),
(2557, '9f34afcb-44a1-4927-9b00-03a954943bec', 1, 3, NULL, 'new_change.thursday', 'messages', 'Thursday', 'active', NULL, NULL, '2025-06-21 00:42:44', '2025-06-21 00:42:44'),
(2558, '9f34afcb-47d3-43ff-9b77-8da5f776bdb3', 1, 3, NULL, 'new_change.friday', 'messages', 'Friday', 'active', NULL, NULL, '2025-06-21 00:42:44', '2025-06-21 00:42:44'),
(2559, '9f34afcb-4ae8-42bc-a98d-1dfaa6abceac', 1, 3, NULL, 'new_change.saturday', 'messages', 'Saturday', 'active', NULL, NULL, '2025-06-21 00:42:44', '2025-06-21 00:42:44'),
(2560, '9f34afcb-4f30-4400-9e12-a467caff8f38', 1, 3, NULL, 'new_change.service_slider_store', 'messages', 'Service slider image created successfully.', 'active', NULL, NULL, '2025-06-21 00:42:44', '2025-06-21 00:42:44'),
(2561, '9f34afcb-5238-44ae-ac9a-22858454c950', 1, 3, NULL, 'new_change.service_slider_update', 'messages', 'Service slider image updated successfully.', 'active', NULL, NULL, '2025-06-21 00:42:44', '2025-06-21 00:42:44'),
(2562, '9f34afcb-5566-4491-826c-e92142a4fef6', 1, 3, NULL, 'new_change.captcha_key', 'messages', 'Google Captcha key', 'active', NULL, NULL, '2025-06-21 00:42:44', '2025-06-21 00:42:44'),
(2563, '9f34afcb-5872-4d9f-b9ae-0ca077bc924e', 1, 3, NULL, 'new_change.captcha_secret', 'messages', 'Google Captcha Secret', 'active', NULL, NULL, '2025-06-21 00:42:44', '2025-06-21 00:42:44'),
(2564, '9f34afcb-5b80-47c7-8647-648d52732e07', 1, 3, NULL, 'new_change.change_image', 'messages', 'Change  Image', 'active', NULL, NULL, '2025-06-21 00:42:44', '2025-06-21 00:42:44'),
(2565, '9f34afcb-5ec2-49fa-ae7c-ec9a9af44530', 1, 3, NULL, 'new_change.allow_img_text_extra', 'messages', 'Allowed file types: png, jpg, gif, jpeg, svg, webp.', 'active', NULL, NULL, '2025-06-21 00:42:44', '2025-06-21 00:42:44'),
(2566, '9f34afcb-61eb-4469-a713-d9909aa6e31f', 1, 3, NULL, 'new_change.sms_limit', 'messages', 'Sms Limit', 'active', NULL, NULL, '2025-06-21 00:42:44', '2025-06-21 00:42:44'),
(2567, '9f34afcb-6507-4338-aab8-ac65496f747f', 1, 3, NULL, 'new_change.enter_sms-limit', 'messages', 'Enter Sms Limit', 'active', NULL, NULL, '2025-06-21 00:42:44', '2025-06-21 00:42:44'),
(2568, '9f34afcb-67f8-4084-92af-756836981ec5', 1, 3, NULL, 'new_change.no_records_found', 'messages', 'No records founds.', 'active', NULL, NULL, '2025-06-21 00:42:44', '2025-06-21 00:42:44'),
(2569, '9f34afcb-6af3-4c1a-94e2-ceb23cd847d6', 1, 3, NULL, 'new_change.bed_distinct', 'messages', 'The Bed field has a duplicate value.', 'active', NULL, NULL, '2025-06-21 00:42:44', '2025-06-21 00:42:44'),
(2570, '9f34afcb-6e0b-4b21-ac9f-8ecd44f10af1', 1, 3, NULL, 'new_change.bed_unique', 'messages', 'The Bed input has already been taken.', 'active', NULL, NULL, '2025-06-21 00:42:44', '2025-06-21 00:42:44'),
(2571, '9f34afcb-7107-418d-a32f-c29e311fe9ae', 1, 3, NULL, 'new_change.name_unique', 'messages', 'The name has already been taken.', 'active', NULL, NULL, '2025-06-21 00:42:44', '2025-06-21 00:42:44'),
(2572, '9f34afcb-742b-4733-8f09-5a992092921c', 1, 3, NULL, 'new_change.charge_number', 'messages', 'The charge must be number.', 'active', NULL, NULL, '2025-06-21 00:42:44', '2025-06-21 00:42:44'),
(2573, '9f34afcb-7744-4de2-a2f0-a917cb78367a', 1, 3, NULL, 'new_change.charge_regex', 'messages', 'The charge must be in a valid format.', 'active', NULL, NULL, '2025-06-21 00:42:44', '2025-06-21 00:42:44'),
(2574, '9f34afcb-7a51-48c6-9ea2-5e7390651c5d', 1, 3, NULL, 'new_change.password_min', 'messages', 'Password must contain at least 6 characters.', 'active', NULL, NULL, '2025-06-21 00:42:44', '2025-06-21 00:42:44'),
(2575, '9f34afcb-7d73-45fb-86dc-e22c0b6d8390', 1, 3, NULL, 'new_change.password_same', 'messages', 'The password and confirm password must be matched.', 'active', NULL, NULL, '2025-06-21 00:42:44', '2025-06-21 00:42:44'),
(2576, '9f34afcb-8099-4e1b-a887-d95806d7f3a4', 1, 3, NULL, 'new_change.slug_unique', 'messages', 'The hospital slug has already been taken.', 'active', NULL, NULL, '2025-06-21 00:42:44', '2025-06-21 00:42:44'),
(2577, '9f34afcb-83c1-4fc3-98a8-2f2b244b3114', 1, 3, NULL, 'new_change.service_image_required', 'messages', 'Service image slider field is required.', 'active', NULL, NULL, '2025-06-21 00:42:44', '2025-06-21 00:42:44'),
(2578, '9f34afcb-86b9-4292-9a8e-2a69d5fa2073', 1, 3, NULL, 'new_change.email_subscribe', 'messages', 'The email has already subscribed.', 'active', NULL, NULL, '2025-06-21 00:42:44', '2025-06-21 00:42:44'),
(2579, '9f34afcb-89df-44a5-9ce5-3dd187cdd916', 1, 3, NULL, 'new_change.admission_required', 'messages', 'The Admission id field is required.', 'active', NULL, NULL, '2025-06-21 00:42:44', '2025-06-21 00:42:44'),
(2580, '9f34afcb-8cf2-400f-b9f6-1f8610d167bd', 1, 3, NULL, 'new_change.one_patient', 'messages', 'Please select at least one patient.', 'active', NULL, NULL, '2025-06-21 00:42:44', '2025-06-21 00:42:44'),
(2581, '9f34afcb-900a-4551-aa68-e0eac1817764', 1, 3, NULL, 'new_change.category_required', 'messages', 'The Category field is required.', 'active', NULL, NULL, '2025-06-21 00:42:44', '2025-06-21 00:42:44'),
(2582, '9f34afcb-930e-4b88-9ee0-55eb60f64247', 1, 3, NULL, 'new_change.brand_required', 'messages', 'The Brand field is required.', 'active', NULL, NULL, '2025-06-21 00:42:44', '2025-06-21 00:42:44'),
(2583, '9f34afcb-9621-4610-9aaa-173d2a811d10', 1, 3, NULL, 'new_change.card_one_char', 'messages', 'The card one text secondary must not be greater than 90 characters', 'active', NULL, NULL, '2025-06-21 00:42:44', '2025-06-21 00:42:44'),
(2584, '9f34afcb-98fe-43ab-b297-89231cdcb8a0', 1, 3, NULL, 'new_change.back_to_main_site', 'messages', 'Back To Main Site', 'active', NULL, NULL, '2025-06-21 00:42:44', '2025-06-21 00:42:44'),
(2585, '9f34afcb-9c45-4e0d-83f0-799776ec36c2', 1, 3, NULL, 'new_change.added_at', 'messages', 'Added At', 'active', NULL, NULL, '2025-06-21 00:42:44', '2025-06-21 00:42:44'),
(2586, '9f34afcb-9f73-4bae-ba55-2efc358c45c2', 1, 3, NULL, 'new_change.pathology_units', 'messages', 'Pathology Units', 'active', NULL, NULL, '2025-06-21 00:42:44', '2025-06-21 00:42:44'),
(2587, '9f34afcb-a28a-4987-af56-49c112e58134', 1, 3, NULL, 'new_change.pathology_unit', 'messages', 'Pathology Unit', 'active', NULL, NULL, '2025-06-21 00:42:44', '2025-06-21 00:42:44'),
(2588, '9f34afcb-a59d-4657-973e-084764d09a4b', 1, 3, NULL, 'new_change.add_unit', 'messages', 'New Pathology Unit', 'active', NULL, NULL, '2025-06-21 00:42:44', '2025-06-21 00:42:44'),
(2589, '9f34afcb-a8bd-4b45-887a-1cefb1629ecf', 1, 3, NULL, 'new_change.edit_unit', 'messages', 'Edit Pathology Unit', 'active', NULL, NULL, '2025-06-21 00:42:44', '2025-06-21 00:42:44'),
(2590, '9f34afcb-abd8-4fb4-9d52-d0aa33566bee', 1, 3, NULL, 'new_change.pathology_unit_not_found', 'messages', 'Pathology Unit not found', 'active', NULL, NULL, '2025-06-21 00:42:44', '2025-06-21 00:42:44'),
(2591, '9f34afcb-aeed-479c-89c0-717b22d979d5', 1, 3, NULL, 'new_change.pathology_unit_cant_deleted', 'messages', 'Pathology Unit can\'t be deleted.', 'active', NULL, NULL, '2025-06-21 00:42:44', '2025-06-21 00:42:44'),
(2592, '9f34afcb-b215-4d1c-9e21-bf0ba747b2c5', 1, 3, NULL, 'new_change.pathology_parameter_not_found', 'messages', 'Pathology Parameter not found', 'active', NULL, NULL, '2025-06-21 00:42:44', '2025-06-21 00:42:44'),
(2593, '9f34afcb-b52c-4e77-8555-26cbdfe58a98', 1, 3, NULL, 'new_change.pathology_parameter_cant_deleted', 'messages', 'Pathology Parameter can\'t be deleted.', 'active', NULL, NULL, '2025-06-21 00:42:44', '2025-06-21 00:42:44'),
(2594, '9f34afcb-b82e-4723-bad3-03affafc1579', 1, 3, NULL, 'new_change.pathology_parameter', 'messages', 'Pathology Parameter', 'active', NULL, NULL, '2025-06-21 00:42:44', '2025-06-21 00:42:44'),
(2595, '9f34afcb-bb42-49ac-8657-49c83be923cf', 1, 3, NULL, 'new_change.pathology_parameters', 'messages', 'Pathology Parameters', 'active', NULL, NULL, '2025-06-21 00:42:44', '2025-06-21 00:42:44'),
(2596, '9f34afcb-be54-41d3-9990-da078d600c27', 1, 3, NULL, 'new_change.add_parameter', 'messages', 'New Pathology Parameter', 'active', NULL, NULL, '2025-06-21 00:42:44', '2025-06-21 00:42:44'),
(2597, '9f34afcb-c16a-4369-9a3e-8bc726a41b68', 1, 3, NULL, 'new_change.edit_parameter', 'messages', 'Edit Pathology Parameter', 'active', NULL, NULL, '2025-06-21 00:42:44', '2025-06-21 00:42:44'),
(2598, '9f34afcb-c4a2-445f-8403-386f23753d79', 1, 3, NULL, 'new_change.parameter_name_required', 'messages', 'Parameter Name field is required.', 'active', NULL, NULL, '2025-06-21 00:42:44', '2025-06-21 00:42:44'),
(2599, '9f34afcb-c7be-4d5f-a0a7-b0b3fc19ca14', 1, 3, NULL, 'new_change.patient_result_required', 'messages', 'Patient Result field is required.', 'active', NULL, NULL, '2025-06-21 00:42:44', '2025-06-21 00:42:44'),
(2600, '9f34afcb-cad5-487b-89f2-34cd717b9f7a', 1, 3, NULL, 'new_change.parameter_name', 'messages', 'Parameter Name', 'active', NULL, NULL, '2025-06-21 00:42:44', '2025-06-21 00:42:44'),
(2601, '9f34afcb-ce00-4e65-ac88-ecdf85679b68', 1, 3, NULL, 'new_change.patient_result', 'messages', 'Patient Result', 'active', NULL, NULL, '2025-06-21 00:42:44', '2025-06-21 00:42:44'),
(2602, '9f34afcb-d135-4603-99c0-27cca0353513', 1, 3, NULL, 'new_change.select_parameter_name', 'messages', 'Select Parameter Name', 'active', NULL, NULL, '2025-06-21 00:42:44', '2025-06-21 00:42:44'),
(2603, '9f34afcb-d43b-46d3-9c9c-280f9171b6a8', 1, 3, NULL, 'new_change.reference_range', 'messages', 'Reference Range', 'active', NULL, NULL, '2025-06-21 00:42:44', '2025-06-21 00:42:44'),
(2604, '9f34afcb-d74b-44bf-8a9c-f46462907dc5', 1, 3, NULL, 'new_change.select_unit', 'messages', 'Select Unit', 'active', NULL, NULL, '2025-06-21 00:42:44', '2025-06-21 00:42:44'),
(2605, '9f34afcb-da6e-4901-b209-b4955d198654', 1, 3, NULL, 'new_change.print_pathology_test', 'messages', 'Print Pathology Test', 'active', NULL, NULL, '2025-06-21 00:42:44', '2025-06-21 00:42:44'),
(2606, '9f34afcb-dd82-4305-add8-71ccf0db6fb8', 1, 3, NULL, 'new_change.pathology_test_report', 'messages', 'Pathology Test Report', 'active', NULL, NULL, '2025-06-21 00:42:44', '2025-06-21 00:42:44'),
(2607, '9f34afcb-e096-4a07-b5e3-be9b2796e621', 1, 3, NULL, 'new_change.default_admin_not_delete', 'messages', 'Default SuperAdmin can\'t be deleted.', 'active', NULL, NULL, '2025-06-21 00:42:44', '2025-06-21 00:42:44'),
(2608, '9f34afcb-e3b6-4125-81e3-c754c26f1e78', 1, 3, NULL, 'new_change.notify_mail_for_patient_book', 'messages', 'Notify Mail For Patient booked appointment', 'active', NULL, NULL, '2025-06-21 00:42:44', '2025-06-21 00:42:44'),
(2609, '9f34afcb-e6e3-45a3-9bf6-da43c0cd95c1', 1, 3, NULL, 'new_change.currency_setting_not_found', 'messages', 'Currency Setting not found', 'active', NULL, NULL, '2025-06-21 00:42:44', '2025-06-21 00:42:44'),
(2610, '9f34afcb-e9fe-4fc6-b9e6-cf3bbd879fee', 1, 3, NULL, 'new_change.default_currency_not_delete', 'messages', 'Can not be delete default currency', 'active', NULL, NULL, '2025-06-21 00:42:44', '2025-06-21 00:42:44'),
(2611, '9f34afcb-ed30-4da2-bd29-b8b6e0355335', 1, 3, NULL, 'new_change.time_invalid', 'messages', 'day start time is invalid', 'active', NULL, NULL, '2025-06-21 00:42:44', '2025-06-21 00:42:44'),
(2612, '9f34afcb-f05e-4fa4-bfc0-e5959e4ff913', 1, 3, NULL, 'new_change.hospital_not_delete', 'messages', 'Hospital Type can\'t be deleted.', 'active', NULL, NULL, '2025-06-21 00:42:44', '2025-06-21 00:42:44'),
(2613, '9f34afcb-f361-45bf-9acc-f806a67fe064', 1, 3, NULL, 'new_change.patient_invoice_bill', 'messages', 'Patient Invoice Bill', 'active', NULL, NULL, '2025-06-21 00:42:44', '2025-06-21 00:42:44'),
(2614, '9f34afcb-f66d-4045-aca9-bc6d6a59ac91', 1, 3, NULL, 'new_change.patient_mail_send', 'messages', 'Patient invoice mail send successfully.', 'active', NULL, NULL, '2025-06-21 00:42:44', '2025-06-21 00:42:44'),
(2615, '9f34afcb-f9b2-4e74-8b3b-2ba8a0793c7d', 1, 3, NULL, 'new_change.is', 'messages', 'is', 'active', NULL, NULL, '2025-06-21 00:42:44', '2025-06-21 00:42:44'),
(2616, '9f34afcb-fcee-4471-9b7f-b0124b4e23f7', 1, 3, NULL, 'new_change.staff_limit', 'messages', 'Maximum staff add limit is 10.', 'active', NULL, NULL, '2025-06-21 00:42:44', '2025-06-21 00:42:44'),
(2617, '9f34afcb-fffb-4ec3-94e5-0768b44f75a1', 1, 3, NULL, 'new_change.medicine_bill_already_use', 'messages', 'This medicine is already used in medicine bills, are you sure want to delete it?', 'active', NULL, NULL, '2025-06-21 00:42:44', '2025-06-21 00:42:44'),
(2618, '9f34afcc-0336-40e2-b820-be6a89951ada', 1, 3, NULL, 'new_change.not_in_use', 'messages', 'Not in use', 'active', NULL, NULL, '2025-06-21 00:42:44', '2025-06-21 00:42:44'),
(2619, '9f34afcc-0649-4651-98f0-b94077a31f63', 1, 3, NULL, 'new_change.paystack_support_zar', 'messages', 'Only \'ZAR\',\'USD\',\'GHS\',\'NGN\',\'KES\' Currency is Allowed.', 'active', NULL, NULL, '2025-06-21 00:42:44', '2025-06-21 00:42:44'),
(2620, '9f34afcc-0942-4d93-b6f6-535511ff3ec6', 1, 3, NULL, 'new_change.payment_fail', 'messages', 'Payment failed for some reason', 'active', NULL, NULL, '2025-06-21 00:42:45', '2025-06-21 00:42:45'),
(2621, '9f34afcc-0c5c-4982-a75b-03b8c3788d39', 1, 3, NULL, 'new_change.paystack_token_expired', 'messages', 'The paystack token has expired. Please refresh the page and try again.', 'active', NULL, NULL, '2025-06-21 00:42:45', '2025-06-21 00:42:45'),
(2622, '9f34afcc-0f7b-47c6-97b7-dd64b6747975', 1, 3, NULL, 'new_change.paytm_support_indian', 'messages', 'Paytm only supported indian currency.', 'active', NULL, NULL, '2025-06-21 00:42:45', '2025-06-21 00:42:45'),
(2623, '9f34afcc-129b-4be5-aa8e-6a9de65fc576', 1, 3, NULL, 'new_change.medicine_purchase_success', 'messages', 'Medicine purchased successfully', 'active', NULL, NULL, '2025-06-21 00:42:45', '2025-06-21 00:42:45'),
(2624, '9f34afcc-15ba-49ec-a5ab-dad00d937807', 1, 3, NULL, 'new_change.provide_stripe_key', 'messages', 'Please Provide a Stripe key.', 'active', NULL, NULL, '2025-06-21 00:42:45', '2025-06-21 00:42:45'),
(2625, '9f34afcc-18ec-4834-9ba5-7b56ea63dace', 1, 3, NULL, 'new_change.currency_not_delete', 'messages', 'Currency can\'t be deleted.', 'active', NULL, NULL, '2025-06-21 00:42:45', '2025-06-21 00:42:45'),
(2626, '9f34afcc-1c06-48b6-b2db-2f75d0d96cb1', 1, 3, NULL, 'new_change.admin_not_delete', 'messages', 'Default Admin can\'t be deleted.', 'active', NULL, NULL, '2025-06-21 00:42:45', '2025-06-21 00:42:45'),
(2627, '9f34afcc-1f1f-4356-b5e3-dac3efbb2bff', 1, 3, NULL, 'new_change.subscription_mail', 'messages', 'Subscription Mail.', 'active', NULL, NULL, '2025-06-21 00:42:45', '2025-06-21 00:42:45'),
(2628, '9f34afcc-2237-4d8a-a9c9-ae3243688242', 1, 3, NULL, 'new_change.hospital_register', 'messages', 'Notify Mail For New Hospital Registered', 'active', NULL, NULL, '2025-06-21 00:42:45', '2025-06-21 00:42:45'),
(2629, '9f34afcc-2586-4790-bef8-eeb784bb725e', 1, 3, NULL, 'new_change.appointment_with_doctor', 'messages', 'You have an appointment with Dr.', 'active', NULL, NULL, '2025-06-21 00:42:45', '2025-06-21 00:42:45'),
(2630, '9f34afcc-28a8-4c2d-bf80-f1936aa62842', 1, 3, NULL, 'new_change.doctor_appointments', 'messages', 'Doctor Appointments', 'active', NULL, NULL, '2025-06-21 00:42:45', '2025-06-21 00:42:45'),
(2631, '9f34afcc-2be1-4357-8bff-96bfcca05af7', 1, 3, NULL, 'new_change.enquiry_mail', 'messages', 'Enquiry Mail', 'active', NULL, NULL, '2025-06-21 00:42:45', '2025-06-21 00:42:45'),
(2632, '9f34afcc-2f09-4ff3-a1b0-532e59f41768', 1, 3, NULL, 'new_change.consultancy_create', 'messages', 'New Live Consultation Created', 'active', NULL, NULL, '2025-06-21 00:42:45', '2025-06-21 00:42:45'),
(2633, '9f34afcc-320e-4e32-b2f3-56fb8a1ac5b0', 1, 3, NULL, 'new_change.meeting_create', 'messages', 'New Live Meeting Created', 'active', NULL, NULL, '2025-06-21 00:42:45', '2025-06-21 00:42:45'),
(2634, '9f34afcc-351c-4408-966d-452c2341506a', 1, 3, NULL, 'new_change.hello', 'messages', 'Hello', 'active', NULL, NULL, '2025-06-21 00:42:45', '2025-06-21 00:42:45'),
(2635, '9f34afcc-383f-405f-bfc0-2709cd3187c2', 1, 3, NULL, 'new_change.dr.', 'messages', 'Dr.', 'active', NULL, NULL, '2025-06-21 00:42:45', '2025-06-21 00:42:45'),
(2636, '9f34afcc-3b5e-4365-bc85-5000a084fddf', 1, 3, NULL, 'new_change.reminder', 'messages', 'This is just to remind you that your appointment with', 'active', NULL, NULL, '2025-06-21 00:42:45', '2025-06-21 00:42:45'),
(2637, '9f34afcc-3e8c-4067-9b2a-5cf2fbf2206a', 1, 3, NULL, 'new_change.within_one_hour', 'messages', 'is within next one hour', 'active', NULL, NULL, '2025-06-21 00:42:45', '2025-06-21 00:42:45'),
(2638, '9f34afcc-41b5-46b5-b136-d13e7511d76c', 1, 3, NULL, 'new_change.patient_problem', 'messages', 'Patient Problem', 'active', NULL, NULL, '2025-06-21 00:42:45', '2025-06-21 00:42:45'),
(2639, '9f34afcc-44c2-45de-a508-3c8f543719d7', 1, 3, NULL, 'new_change.appointment_time', 'messages', 'Appointment Time', 'active', NULL, NULL, '2025-06-21 00:42:45', '2025-06-21 00:42:45'),
(2640, '9f34afcc-47ef-4264-8e48-3827dd68b058', 1, 3, NULL, 'new_change.thanks_regards', 'messages', 'Thanks & Regards', 'active', NULL, NULL, '2025-06-21 00:42:45', '2025-06-21 00:42:45'),
(2641, '9f34afcc-4b0c-4dd0-bdba-8099a127a1aa', 1, 3, NULL, 'new_change.new_hospital_registerd', 'messages', 'A new hospital has been registered in your list of hospitals.', 'active', NULL, NULL, '2025-06-21 00:42:45', '2025-06-21 00:42:45'),
(2642, '9f34afcc-4e2d-4c12-9b27-a63647cddf64', 1, 3, NULL, 'new_change.hospital_contact', 'messages', 'Hospital Contact', 'active', NULL, NULL, '2025-06-21 00:42:45', '2025-06-21 00:42:45'),
(2643, '9f34afcc-527c-4649-8ded-662ecc9e8ec4', 1, 3, NULL, 'new_change.prescription_report', 'messages', 'Prescription Report', 'active', NULL, NULL, '2025-06-21 00:42:45', '2025-06-21 00:42:45'),
(2644, '9f34afcc-55c5-4128-8bdb-7a43a303577c', 1, 3, NULL, 'new_change.years', 'messages', 'Years', 'active', NULL, NULL, '2025-06-21 00:42:45', '2025-06-21 00:42:45'),
(2645, '9f34afcc-58e4-4355-8f10-5017ebca6af9', 1, 3, NULL, 'new_change.patient_diagnosis_test_report', 'messages', 'Patient Diagnosis Test Report', 'active', NULL, NULL, '2025-06-21 00:42:45', '2025-06-21 00:42:45'),
(2646, '9f34afcc-5c02-4bba-aab0-1b0e6f890c01', 1, 3, NULL, 'new_change.diagnosis_report_id', 'messages', 'Patient Diagnosis Report ID', 'active', NULL, NULL, '2025-06-21 00:42:45', '2025-06-21 00:42:45'),
(2647, '9f34afcc-5f32-4326-a3f2-6427167199cb', 1, 3, NULL, 'new_change.no_ipd_patient_found', 'messages', 'No IPD Patient Found', 'active', NULL, NULL, '2025-06-21 00:42:45', '2025-06-21 00:42:45'),
(2648, '9f34afcc-6258-4ab0-b7ee-e2486279a8d7', 1, 3, NULL, 'new_change.deduction_not_greater_than_salary', 'messages', 'Deductions cannot be greater than Basic salary + Allowance', 'active', NULL, NULL, '2025-06-21 00:42:45', '2025-06-21 00:42:45'),
(2649, '9f34afcc-6581-4bb7-a244-e72d6bc70b3f', 1, 3, NULL, 'new_change.terms_condition_required', 'messages', 'The Terms & Conditions is required.', 'active', NULL, NULL, '2025-06-21 00:42:45', '2025-06-21 00:42:45'),
(2650, '9f34afcc-68af-45d3-9040-9a1354bf7aa0', 1, 3, NULL, 'new_change.privacy_policy', 'messages', 'The Privacy Policy is required.', 'active', NULL, NULL, '2025-06-21 00:42:45', '2025-06-21 00:42:45'),
(2651, '9f34afcc-6bfa-4dc6-bcde-3ac9eeb09747', 1, 3, NULL, 'new_change.image_must_be', 'messages', 'The image must be a file of type: jpg, jpeg, png.', 'active', NULL, NULL, '2025-06-21 00:42:45', '2025-06-21 00:42:45'),
(2652, '9f34afcc-6f16-4639-9e10-8939406e9d5f', 1, 3, NULL, 'new_change.field_not_contain_white_space', 'messages', 'field is not contain only white space', 'active', NULL, NULL, '2025-06-21 00:42:45', '2025-06-21 00:42:45'),
(2653, '9f34afcc-7243-42f0-8d27-5429d5fbd71c', 1, 3, NULL, 'new_change.document_must_be_file_type', 'messages', 'The document must be a file of type: jpeg, jpg, png, pdf, doc, docx.', 'active', NULL, NULL, '2025-06-21 00:42:45', '2025-06-21 00:42:45'),
(2654, '9f34afcc-756c-40f9-a528-34f266ee687e', 1, 3, NULL, 'new_change.select_code', 'messages', 'Select Code', 'active', NULL, NULL, '2025-06-21 00:42:45', '2025-06-21 00:42:45'),
(2655, '9f34afcc-7876-4494-a2ae-c9c58f886a60', 1, 3, NULL, 'new_change.select_item', 'messages', 'Select Item', 'active', NULL, NULL, '2025-06-21 00:42:45', '2025-06-21 00:42:45'),
(2656, '9f34afcc-7ba4-4aee-9d3d-da4ff47f6d0c', 1, 3, NULL, 'new_change.discount_less_than_amount', 'messages', 'The discount should be less than the total amount.', 'active', NULL, NULL, '2025-06-21 00:42:45', '2025-06-21 00:42:45'),
(2657, '9f34afcc-7ec3-4205-b0b4-2cb42d92dbcd', 1, 3, NULL, 'new_change.tax_less_100', 'messages', 'Taxes should be less than 100%.', 'active', NULL, NULL, '2025-06-21 00:42:45', '2025-06-21 00:42:45'),
(2658, '9f34afcc-81f4-4dec-92ef-b821e9a87345', 1, 3, NULL, 'new_change.quantity_not_empty', 'messages', 'Quantity cannot be zero or empty.', 'active', NULL, NULL, '2025-06-21 00:42:45', '2025-06-21 00:42:45'),
(2659, '9f34afcc-84f1-4754-952e-0f09fefb6e4a', 1, 3, NULL, 'new_change.select_duration', 'messages', 'Select Duration', 'active', NULL, NULL, '2025-06-21 00:42:45', '2025-06-21 00:42:45'),
(2660, '9f34afcc-882d-45b9-8d4b-c640c0451715', 1, 3, NULL, 'new_change.select_dose_interval', 'messages', 'Select Dose Interval', 'active', NULL, NULL, '2025-06-21 00:42:45', '2025-06-21 00:42:45'),
(2661, '9f34afcc-8b73-4c61-8e09-e62e1ee6a57e', 1, 3, NULL, 'new_change.enter_lot_no', 'messages', 'Enter lot number .', 'active', NULL, NULL, '2025-06-21 00:42:45', '2025-06-21 00:42:45'),
(2662, '9f34afcc-8e8a-4185-8e7d-557292ea433c', 1, 3, NULL, 'new_change.tax_not_empty', 'messages', 'The tax amount can not be zero or empty.', 'active', NULL, NULL, '2025-06-21 00:42:45', '2025-06-21 00:42:45'),
(2663, '9f34afcc-91c3-4a7f-80d8-c6842954ec06', 1, 3, NULL, 'new_change.quantity_greater_than_0', 'messages', 'Quantity should be greater than 0.', 'active', NULL, NULL, '2025-06-21 00:42:45', '2025-06-21 00:42:45'),
(2664, '9f34afcc-94e8-41e9-991c-081c60efa9ad', 1, 3, NULL, 'new_change.enter_sale_price', 'messages', 'Enter sale price.', 'active', NULL, NULL, '2025-06-21 00:42:45', '2025-06-21 00:42:45'),
(2665, '9f34afcc-9812-4d56-8c8a-92dcaf32d53c', 1, 3, NULL, 'new_change.enter_purchase_price', 'messages', 'Enter purchase price.', 'active', NULL, NULL, '2025-06-21 00:42:45', '2025-06-21 00:42:45'),
(2666, '9f34afcc-9b3b-493d-9ecb-48a7d6a6fdd0', 1, 3, NULL, 'new_change.enter_quantity', 'messages', 'Please enter quantity.', 'active', NULL, NULL, '2025-06-21 00:42:45', '2025-06-21 00:42:45'),
(2667, '9f34afcc-9e79-47a0-b01c-e27eacefe952', 1, 3, NULL, 'new_change.select_charge', 'messages', 'Select Charge', 'active', NULL, NULL, '2025-06-21 00:42:45', '2025-06-21 00:42:45'),
(2668, '9f34afcc-a19d-473f-8c3b-4a2a78e01e12', 1, 3, NULL, 'new_change.charchter_160', 'messages', 'The message may not be greater than 160 characters.', 'active', NULL, NULL, '2025-06-21 00:42:45', '2025-06-21 00:42:45'),
(2669, '9f34afcc-a4cf-47ec-80dd-b6b4205f8bc9', 1, 3, NULL, 'new_change.enter_captcha_key', 'messages', 'Please enter Google captcha Key.', 'active', NULL, NULL, '2025-06-21 00:42:45', '2025-06-21 00:42:45');
INSERT INTO `ltu_phrases` (`id`, `uuid`, `translation_id`, `translation_file_id`, `phrase_id`, `key`, `group`, `value`, `status`, `parameters`, `note`, `created_at`, `updated_at`) VALUES
(2670, '9f34afcc-a82f-49f2-a17d-c40c6d1ee9e1', 1, 3, NULL, 'new_change.enter_captcha_secret', 'messages', 'Please enter Google captcha Secret.', 'active', NULL, NULL, '2025-06-21 00:42:45', '2025-06-21 00:42:45'),
(2671, '9f34afcc-abe3-4999-bb9c-b2dacb142d76', 1, 3, NULL, 'new_change.paypal_client_id', 'messages', 'Please enter paypal client id.', 'active', NULL, NULL, '2025-06-21 00:42:45', '2025-06-21 00:42:45'),
(2672, '9f34afcc-afb3-4d05-9346-6135c64f631c', 1, 3, NULL, 'new_change.paypal_secret', 'messages', 'Please enter paypal secret.', 'active', NULL, NULL, '2025-06-21 00:42:45', '2025-06-21 00:42:45'),
(2673, '9f34afcc-b3b7-4c82-9fe1-7130f7921bd9', 1, 3, NULL, 'new_change.paypal_mode', 'messages', 'Please enter paypal mode.', 'active', NULL, NULL, '2025-06-21 00:42:45', '2025-06-21 00:42:45'),
(2674, '9f34afcc-b7d2-48c9-b289-ca8111cc306b', 1, 3, NULL, 'new_change.razor_pay_secret', 'messages', 'Please enter razorpay Secret.', 'active', NULL, NULL, '2025-06-21 00:42:45', '2025-06-21 00:42:45'),
(2675, '9f34afcc-bcf6-4d03-9bcb-371a467408a8', 1, 3, NULL, 'new_change.razorpay_key', 'messages', 'Please enter razorpay key.', 'active', NULL, NULL, '2025-06-21 00:42:45', '2025-06-21 00:42:45'),
(2676, '9f34afcc-c135-42ba-9bfc-4a863743f7fa', 1, 3, NULL, 'new_change.stripe_secret', 'messages', 'Please enter stripe Secret.', 'active', NULL, NULL, '2025-06-21 00:42:45', '2025-06-21 00:42:45'),
(2677, '9f34afcc-c50a-4e6e-96e9-b9c537dbcf4c', 1, 3, NULL, 'new_change.stripe_key', 'messages', 'Please enter Stripe Secret.', 'active', NULL, NULL, '2025-06-21 00:42:45', '2025-06-21 00:42:45'),
(2678, '9f34afcc-c912-402c-baf4-bcba75befb9f', 1, 3, NULL, 'new_change.paystack_key', 'messages', 'Please enter paystack public Key.', 'active', NULL, NULL, '2025-06-21 00:42:45', '2025-06-21 00:42:45'),
(2679, '9f34afcc-cccf-4772-8b93-aa7230337354', 1, 3, NULL, 'new_change.paystack_secret', 'messages', 'Please enter paystack secret Key.', 'active', NULL, NULL, '2025-06-21 00:42:45', '2025-06-21 00:42:45'),
(2680, '9f34afcc-d04f-4337-a399-0e827a69b0b0', 1, 3, NULL, 'new_change.paytm_id', 'messages', 'Please enter paytm merchant Id.', 'active', NULL, NULL, '2025-06-21 00:42:45', '2025-06-21 00:42:45'),
(2681, '9f34afcc-d3af-4a04-bb15-7e58600c9cad', 1, 3, NULL, 'new_change.paytm_key', 'messages', 'Please enter paytm merchant Key.', 'active', NULL, NULL, '2025-06-21 00:42:45', '2025-06-21 00:42:45'),
(2682, '9f34afcc-d6fa-400a-9396-ff50f070b3bd', 1, 3, NULL, 'new_change.sending', 'messages', 'Sending...', 'active', NULL, NULL, '2025-06-21 00:42:45', '2025-06-21 00:42:45'),
(2683, '9f34afcc-da78-41e1-95e8-0ea1fac5280f', 1, 3, NULL, 'new_change.warning', 'messages', 'Warning !', 'active', NULL, NULL, '2025-06-21 00:42:45', '2025-06-21 00:42:45'),
(2684, '9f34afcc-ddc3-41be-8b1a-e766cdaef0dc', 1, 3, NULL, 'new_change.select_payment_gateway', 'messages', 'Select Payment Gateway', 'active', NULL, NULL, '2025-06-21 00:42:45', '2025-06-21 00:42:45'),
(2685, '9f34afcc-e108-4789-a96b-131102cddf41', 1, 3, NULL, 'new_change.upcoming_appointments', 'messages', 'Upcoming Appointments', 'active', NULL, NULL, '2025-06-21 00:42:45', '2025-06-21 00:42:45'),
(2686, '9f34afcc-e490-4e31-a215-e5b151fe4101', 1, 3, NULL, 'new_change.expired', 'messages', 'Expired', 'active', NULL, NULL, '2025-06-21 00:42:45', '2025-06-21 00:42:45'),
(2687, '9f34afcc-e7ff-45d8-be0e-07f26ca20d1f', 1, 3, NULL, 'new_change.not_expired', 'messages', 'Not Expired', 'active', NULL, NULL, '2025-06-21 00:42:45', '2025-06-21 00:42:45'),
(2688, '9f34afcc-ed74-41c0-af56-016101b29e27', 1, 3, NULL, 'new_change.plan_expire_status', 'messages', 'Expire', 'active', NULL, NULL, '2025-06-21 00:42:45', '2025-06-21 00:42:45'),
(2689, '9f34afcc-f0be-45dc-b893-cbdb5dff5ba9', 1, 3, NULL, 'new_change.select_plan_expire_status', 'messages', 'Select Expire', 'active', NULL, NULL, '2025-06-21 00:42:45', '2025-06-21 00:42:45'),
(2690, '9f34afcc-f3fd-4121-9f20-832e954e962d', 1, 3, NULL, 'new_change.if_you_did_not_create_an_account', 'messages', 'If you did not create an account, no further action is required.', 'active', NULL, NULL, '2025-06-21 00:42:45', '2025-06-21 00:42:45'),
(2691, '9f34afcc-f744-4a3e-b77a-fd6d1a2fade0', 1, 3, NULL, 'new_change.verify_email_address', 'messages', 'Verify Email Address', 'active', NULL, NULL, '2025-06-21 00:42:45', '2025-06-21 00:42:45'),
(2692, '9f34afcc-fa7a-4308-b439-e13717744e19', 1, 3, NULL, 'new_change.click_the_button_below_to_verify_your_email_address', 'messages', 'Please click the button below to verify your email address.', 'active', NULL, NULL, '2025-06-21 00:42:45', '2025-06-21 00:42:45'),
(2693, '9f34afcc-fda0-4f19-8473-d6e0c4d0bd26', 1, 3, NULL, 'new_change.trouble', 'messages', 'If you’re having trouble clicking the \"Verify Email Address\" button, copy and paste the URL below into your web browser', 'active', NULL, NULL, '2025-06-21 00:42:45', '2025-06-21 00:42:45'),
(2694, '9f34afcd-00c1-4064-80e2-6becc701e35d', 1, 3, NULL, 'holiday.holiday', 'messages', 'Holiday', 'active', NULL, NULL, '2025-06-21 00:42:45', '2025-06-21 00:42:45'),
(2695, '9f34afcd-03e0-410e-8535-1e4207ce1188', 1, 3, NULL, 'holiday.add_holiday', 'messages', 'Add Holiday', 'active', NULL, NULL, '2025-06-21 00:42:45', '2025-06-21 00:42:45'),
(2696, '9f34afcd-0738-488c-b22d-16b76f698392', 1, 3, NULL, 'holiday.doctor_holiday', 'messages', 'Doctor Holidays', 'active', NULL, NULL, '2025-06-21 00:42:45', '2025-06-21 00:42:45'),
(2697, '9f34afcd-0afb-482a-9534-dc2e70c30ab2', 1, 3, NULL, 'holiday.service_category', 'messages', 'Service Category', 'active', NULL, NULL, '2025-06-21 00:42:45', '2025-06-21 00:42:45'),
(2698, '9f34afcd-0ecb-4446-b529-4b80b385d382', 1, 3, NULL, 'holiday.holiday_date', 'messages', 'Holiday Date', 'active', NULL, NULL, '2025-06-21 00:42:45', '2025-06-21 00:42:45'),
(2699, '9f34afcd-1241-4794-a3ee-eb5907e7ae1a', 1, 3, NULL, 'holiday.reason', 'messages', 'Reason', 'active', NULL, NULL, '2025-06-21 00:42:45', '2025-06-21 00:42:45'),
(2700, '9f34afcd-15c4-4699-bcc8-ca8c5be07494', 1, 3, NULL, 'holiday.holiday_already_is_exist', 'messages', 'Holiday is already exist.', 'active', NULL, NULL, '2025-06-21 00:42:45', '2025-06-21 00:42:45'),
(2701, '9f34afcd-191b-4e62-8f30-02410c1aece2', 1, 3, NULL, 'holiday.doctor_holiday_create', 'messages', 'Doctor Holiday saved successfully.', 'active', NULL, NULL, '2025-06-21 00:42:45', '2025-06-21 00:42:45'),
(2702, '9f34afcd-1cab-44b4-b9aa-7ad3c6467003', 1, 3, NULL, 'holiday.you_are_not_allow_to_record', 'messages', 'Seems, you are not allowed to access this record.', 'active', NULL, NULL, '2025-06-21 00:42:45', '2025-06-21 00:42:45'),
(2703, '9f34afcd-1ffc-4603-8630-8a716323525d', 1, 3, NULL, 'lunch_break.lunch_breaks', 'messages', 'Breaks', 'active', NULL, NULL, '2025-06-21 00:42:45', '2025-06-21 00:42:45'),
(2704, '9f34afcd-234a-4153-8882-8d4b12dbb81c', 1, 3, NULL, 'lunch_break.lunch_break', 'messages', 'Break', 'active', NULL, NULL, '2025-06-21 00:42:45', '2025-06-21 00:42:45'),
(2705, '9f34afcd-26d9-448e-bff4-da76071840d0', 1, 3, NULL, 'lunch_break.break_create', 'messages', 'Break saved successfully.', 'active', NULL, NULL, '2025-06-21 00:42:45', '2025-06-21 00:42:45'),
(2706, '9f34afcd-2a17-429e-98a1-f22346e3431a', 1, 3, NULL, 'lunch_break.break_update', 'messages', 'break updated successfully.', 'active', NULL, NULL, '2025-06-21 00:42:45', '2025-06-21 00:42:45'),
(2707, '9f34afcd-2d4e-4b03-a454-3aaa2b038efb', 1, 3, NULL, 'lunch_break.add_break', 'messages', 'Add Break', 'active', NULL, NULL, '2025-06-21 00:42:45', '2025-06-21 00:42:45'),
(2708, '9f34afcd-307c-490d-9b0c-0b260fe505ef', 1, 3, NULL, 'lunch_break.edit_break', 'messages', 'Edit Break', 'active', NULL, NULL, '2025-06-21 00:42:45', '2025-06-21 00:42:45'),
(2709, '9f34afcd-3395-48d2-bb68-731788b069d0', 1, 3, NULL, 'lunch_break.break_already_is_exist', 'messages', 'Break is already exist.', 'active', NULL, NULL, '2025-06-21 00:42:45', '2025-06-21 00:42:45'),
(2710, '9f34afcd-36dd-47bd-91f5-0f27cf47a5a4', 1, 3, NULL, 'lunch_break.break_time_greater_than_zero', 'messages', 'Break From time must be greater than Zero', 'active', NULL, NULL, '2025-06-21 00:42:45', '2025-06-21 00:42:45'),
(2711, '9f34afcd-39f7-457f-b3f3-88039c929307', 1, 3, NULL, 'lunch_break.break_to_time_greater_than_zero', 'messages', 'Break To time must be greater than Zero', 'active', NULL, NULL, '2025-06-21 00:42:45', '2025-06-21 00:42:45'),
(2712, '9f34afcd-3d4d-4b56-98ee-4481cdd516b8', 1, 3, NULL, 'lunch_break.break_to_time_greater_than_from_time', 'messages', 'Break To time must be greater than Break From time.', 'active', NULL, NULL, '2025-06-21 00:42:45', '2025-06-21 00:42:45'),
(2713, '9f34afcd-409e-40bc-8073-24c32988a750', 1, 3, NULL, 'lunch_break.every_day', 'messages', 'Every Day', 'active', NULL, NULL, '2025-06-21 00:42:45', '2025-06-21 00:42:45'),
(2714, '9f34afcd-43e2-447f-8cfd-d604e0352adb', 1, 3, NULL, 'lunch_break.single_day', 'messages', 'Single Day', 'active', NULL, NULL, '2025-06-21 00:42:45', '2025-06-21 00:42:45'),
(2715, '9f34afcd-46ff-4ca6-abc6-a8c8c871beb0', 1, 3, NULL, 'lunch_break.date_required', 'messages', 'Date field is required.', 'active', NULL, NULL, '2025-06-21 00:42:45', '2025-06-21 00:42:45'),
(2716, '9f34afcd-4a26-49e5-9681-6aed7e095bff', 1, 3, NULL, 'lunch_break.ipd_timeline', 'messages', 'IPD Timeline', 'active', NULL, NULL, '2025-06-21 00:42:45', '2025-06-21 00:42:45'),
(2717, '9f34afcd-4d6e-4ff8-acf7-12cf57488d6a', 1, 3, NULL, 'lunch_break.professional_details', 'messages', 'Professional Details', 'active', NULL, NULL, '2025-06-21 00:42:45', '2025-06-21 00:42:45'),
(2718, '9f34afcd-50a3-4377-b843-3ce2e7a9b0b3', 1, 3, NULL, 'lunch_break.get_direction', 'messages', 'Get Direction', 'active', NULL, NULL, '2025-06-21 00:42:45', '2025-06-21 00:42:45'),
(2719, '9f34afcd-53d1-4e77-947e-c18ff565ced2', 1, 3, NULL, 'lunch_break.filters', 'messages', 'Filters', 'active', NULL, NULL, '2025-06-21 00:42:45', '2025-06-21 00:42:45'),
(2720, '9f34afcd-5716-417b-9c1c-78fa1993a78c', 1, 3, NULL, 'lunch_break.smart_card_template_saved', 'messages', 'Patient Smart Card Template saved successfully.', 'active', NULL, NULL, '2025-06-21 00:42:45', '2025-06-21 00:42:45'),
(2721, '9f34afcd-5a46-4dae-b326-507b38b47267', 1, 3, NULL, 'lunch_break.smart_card_template_update', 'messages', 'Patient Smart Card Template updated successfully.', 'active', NULL, NULL, '2025-06-21 00:42:45', '2025-06-21 00:42:45'),
(2722, '9f34afcd-5d8f-411a-bb24-5f72c0b926af', 1, 3, NULL, 'lunch_break.smart_card_saved', 'messages', 'Patient Smart Card Saved successfully.', 'active', NULL, NULL, '2025-06-21 00:42:45', '2025-06-21 00:42:45'),
(2723, '9f34afcd-60cf-411c-9822-08dba08e15a5', 1, 3, NULL, 'lunch_break.smart_patient_card_template', 'messages', 'Patient Smart Card Templates', 'active', NULL, NULL, '2025-06-21 00:42:45', '2025-06-21 00:42:45'),
(2724, '9f34afcd-6418-424d-90ca-324ca5777df3', 1, 3, NULL, 'lunch_break.new_smart_patient_card_template', 'messages', 'New Patient Smart Card Template', 'active', NULL, NULL, '2025-06-21 00:42:45', '2025-06-21 00:42:45'),
(2725, '9f34afcd-6748-4b60-a6a1-ad32ea877d2d', 1, 3, NULL, 'lunch_break.edit_smart_patient_card_template', 'messages', 'Edit Patient Smart Card Template', 'active', NULL, NULL, '2025-06-21 00:42:45', '2025-06-21 00:42:45'),
(2726, '9f34afcd-6bb0-457a-b3e6-0a94c0a73d8e', 1, 3, NULL, 'lunch_break.template_name', 'messages', 'Template Name', 'active', NULL, NULL, '2025-06-21 00:42:45', '2025-06-21 00:42:45'),
(2727, '9f34afcd-6eec-431d-b082-f8dad1340963', 1, 3, NULL, 'lunch_break.header_color', 'messages', 'Header Color', 'active', NULL, NULL, '2025-06-21 00:42:45', '2025-06-21 00:42:45'),
(2728, '9f34afcd-7223-468f-9198-1b0d44d9c84d', 1, 3, NULL, 'lunch_break.show_email', 'messages', 'Show Email', 'active', NULL, NULL, '2025-06-21 00:42:45', '2025-06-21 00:42:45'),
(2729, '9f34afcd-7539-45fb-b7ec-dc9e674d9d36', 1, 3, NULL, 'lunch_break.show_phone', 'messages', 'Show Phone', 'active', NULL, NULL, '2025-06-21 00:42:45', '2025-06-21 00:42:45'),
(2730, '9f34afcd-7860-4047-8515-988f5d872295', 1, 3, NULL, 'lunch_break.show_dob', 'messages', 'Show DOB', 'active', NULL, NULL, '2025-06-21 00:42:45', '2025-06-21 00:42:45'),
(2731, '9f34afcd-7b8e-4fc5-ae39-17e4619a532f', 1, 3, NULL, 'lunch_break.show_blood_group', 'messages', 'Show Blood Group', 'active', NULL, NULL, '2025-06-21 00:42:45', '2025-06-21 00:42:45'),
(2732, '9f34afcd-7ec3-4992-b841-cbea07d79d2c', 1, 3, NULL, 'lunch_break.show_address', 'messages', 'Show Address', 'active', NULL, NULL, '2025-06-21 00:42:45', '2025-06-21 00:42:45'),
(2733, '9f34afcd-81fa-4057-8c9f-25cddaa75d34', 1, 3, NULL, 'lunch_break.show_patient_unique_id', 'messages', 'Show Patient Unique ID', 'active', NULL, NULL, '2025-06-21 00:42:45', '2025-06-21 00:42:45'),
(2734, '9f34afcd-8532-4bd4-a208-0c2a7cb7e477', 1, 3, NULL, 'lunch_break.show_insurance', 'messages', 'Show Insurance', 'active', NULL, NULL, '2025-06-21 00:42:45', '2025-06-21 00:42:45'),
(2735, '9f34afcd-8881-4571-a785-0d6527ba9256', 1, 3, NULL, 'lunch_break.id', 'messages', 'ID', 'active', NULL, NULL, '2025-06-21 00:42:45', '2025-06-21 00:42:45'),
(2736, '9f34afcd-8bbf-4283-9178-ca78de5d528a', 1, 3, NULL, 'lunch_break.generate_smart_patient_card', 'messages', 'New Patient Smart Card', 'active', NULL, NULL, '2025-06-21 00:42:45', '2025-06-21 00:42:45'),
(2737, '9f34afcd-8f00-4c5c-8d39-f768ca217e1f', 1, 3, NULL, 'lunch_break.for_all_patient', 'messages', 'For All Patient', 'active', NULL, NULL, '2025-06-21 00:42:46', '2025-06-21 00:42:46'),
(2738, '9f34afcd-9227-4309-a0f3-bebbfadde458', 1, 3, NULL, 'lunch_break.only_one_patient', 'messages', 'Only One Patient', 'active', NULL, NULL, '2025-06-21 00:42:46', '2025-06-21 00:42:46'),
(2739, '9f34afcd-9560-4524-99de-ba1c30f880f5', 1, 3, NULL, 'lunch_break.remaining_patient', 'messages', 'Remaining Patient', 'active', NULL, NULL, '2025-06-21 00:42:46', '2025-06-21 00:42:46'),
(2740, '9f34afcd-98a0-46f6-b6b3-9560a6ef8720', 1, 3, NULL, 'lunch_break.generate_smart_patient_cards', 'messages', 'Generate Patient Smart Cards', 'active', NULL, NULL, '2025-06-21 00:42:46', '2025-06-21 00:42:46'),
(2741, '9f34afcd-9bd6-4995-84c9-a2c2442c6136', 1, 3, NULL, 'lunch_break.card_template', 'messages', 'Patient Smart Card Template', 'active', NULL, NULL, '2025-06-21 00:42:46', '2025-06-21 00:42:46'),
(2742, '9f34afcd-9f48-4d74-b0c6-3bddd11ac129', 1, 3, NULL, 'lunch_break.smart_patient_card', 'messages', 'Patient Smart Card', 'active', NULL, NULL, '2025-06-21 00:42:46', '2025-06-21 00:42:46'),
(2743, '9f34afcd-a261-4bbf-a565-23812d5a4398', 1, 3, NULL, 'lunch_break.template_required', 'messages', 'Template Name field is required.', 'active', NULL, NULL, '2025-06-21 00:42:46', '2025-06-21 00:42:46'),
(2744, '9f34afcd-a56e-4993-9498-cbc6e1140862', 1, 3, NULL, 'lunch_break.patient_required', 'messages', 'Patient field is required.', 'active', NULL, NULL, '2025-06-21 00:42:46', '2025-06-21 00:42:46'),
(2745, '9f34afcd-a8ba-485c-9d0c-cb903fd348ca', 1, 3, NULL, 'lunch_break.qr_code_not_found', 'messages', 'QR code not found.', 'active', NULL, NULL, '2025-06-21 00:42:46', '2025-06-21 00:42:46'),
(2746, '9f34afcd-abf7-4580-ad5f-0c8dbe84c65c', 1, 3, NULL, 'lunch_break.dob', 'messages', 'DOB', 'active', NULL, NULL, '2025-06-21 00:42:46', '2025-06-21 00:42:46'),
(2747, '9f34afcd-af5d-44df-94e4-ac2e654ef05c', 1, 3, NULL, 'lunch_break.reset_filter', 'messages', 'Reset Filter', 'active', NULL, NULL, '2025-06-21 00:42:46', '2025-06-21 00:42:46'),
(2748, '9f34afcd-b29f-40a3-9f54-0f909d510844', 1, 3, NULL, 'lunch_break.appointment_exist_time', 'messages', 'Appointment is already exist at this time.', 'active', NULL, NULL, '2025-06-21 00:42:46', '2025-06-21 00:42:46'),
(2749, '9f34afcd-b604-4bc5-b595-1b13f85ab976', 1, 3, NULL, 'lunch_break.appointment_exist_date', 'messages', 'Appointment is already exist at this Date.', 'active', NULL, NULL, '2025-06-21 00:42:46', '2025-06-21 00:42:46'),
(2750, '9f34afcd-b937-44fd-93b0-20b3fc062b56', 1, 3, NULL, 'lunch_break.are_u_sure', 'messages', 'Are you sure?', 'active', NULL, NULL, '2025-06-21 00:42:46', '2025-06-21 00:42:46'),
(2751, '9f34afcd-bc8b-4420-a316-5c3c98cb22a3', 1, 3, NULL, 'lunch_break.u_want_to_complete_this_payment', 'messages', 'You want to complete this payment!', 'active', NULL, NULL, '2025-06-21 00:42:46', '2025-06-21 00:42:46'),
(2752, '9f34afcd-bfe7-4dd7-b40a-3f3b305aebe1', 1, 3, NULL, 'lunch_break.patient_unique_id', 'messages', 'Patient Unique ID', 'active', NULL, NULL, '2025-06-21 00:42:46', '2025-06-21 00:42:46'),
(2753, '9f34afcd-c303-4d49-ac74-c93e1d970726', 1, 3, NULL, 'lunch_break.patient_smart_cards', 'messages', 'Patient Smart Cards', 'active', NULL, NULL, '2025-06-21 00:42:46', '2025-06-21 00:42:46'),
(2754, '9f34afcd-cf74-4e60-92f8-0adb1aecc91c', 1, 3, NULL, 'lunch_break.select_template', 'messages', 'Select Template', 'active', NULL, NULL, '2025-06-21 00:42:46', '2025-06-21 00:42:46'),
(2755, '9f34afcd-d346-4cc0-8770-d5915456ff17', 1, 3, NULL, 'lunch_break.print_discharge_slip', 'messages', 'Print Discharge Slip', 'active', NULL, NULL, '2025-06-21 00:42:46', '2025-06-21 00:42:46'),
(2756, '9f34afcd-d6f6-4042-869e-bf6addd98b75', 1, 3, NULL, 'lunch_break.discharge_slip', 'messages', 'Discharge Slip', 'active', NULL, NULL, '2025-06-21 00:42:46', '2025-06-21 00:42:46'),
(2757, '9f34afcd-da2d-4fd5-bcb5-e08d04689e38', 1, 3, NULL, 'lunch_break.bed_charge', 'messages', 'Bed Charge', 'active', NULL, NULL, '2025-06-21 00:42:46', '2025-06-21 00:42:46'),
(2758, '9f34afcd-dd54-4e3d-b0c1-52c44cafa8f1', 1, 3, NULL, 'lunch_break.discharge', 'messages', 'Discharge', 'active', NULL, NULL, '2025-06-21 00:42:46', '2025-06-21 00:42:46'),
(2759, '9f34afcd-e0bc-4f79-b929-1f4277df78f2', 1, 3, NULL, 'lunch_break.not_dischared', 'messages', 'Not Discharged', 'active', NULL, NULL, '2025-06-21 00:42:46', '2025-06-21 00:42:46'),
(2760, '9f34afcd-e3ed-43ca-9e54-ef916b4efee8', 1, 3, NULL, 'lunch_break.diagnosis_success', 'messages', 'Diagnosis Report status updated successfully.', 'active', NULL, NULL, '2025-06-21 00:42:46', '2025-06-21 00:42:46'),
(2761, '9f34afcd-e742-4d25-b576-80aa48fdb661', 1, 3, NULL, 'lunch_break.case_exist', 'messages', 'IPD Patient is already exists.', 'active', NULL, NULL, '2025-06-21 00:42:46', '2025-06-21 00:42:46'),
(2762, '9f34afcd-eaa3-4fe5-bc6e-9206f493a2cd', 1, 3, NULL, 'lunch_break.payment_request_send', 'messages', 'Payment request sent successfully.', 'active', NULL, NULL, '2025-06-21 00:42:46', '2025-06-21 00:42:46'),
(2763, '9f34afcd-ede2-4c0c-98ab-9679a19bc391', 1, 3, NULL, 'lunch_break.select_payment_mode', 'messages', 'Select payment mode', 'active', NULL, NULL, '2025-06-21 00:42:46', '2025-06-21 00:42:46'),
(2764, '9f34afcd-f10f-44a4-933d-27ae92315246', 1, 3, NULL, 'lunch_break.todays_appointments', 'messages', 'Today\'s Appointments', 'active', NULL, NULL, '2025-06-21 00:42:46', '2025-06-21 00:42:46'),
(2765, '9f34afcd-f42e-4d11-81da-65da766753c9', 1, 3, NULL, 'lunch_break.total_meetings', 'messages', 'Total Meetings', 'active', NULL, NULL, '2025-06-21 00:42:46', '2025-06-21 00:42:46'),
(2766, '9f34afcd-f74d-456b-96dd-b70e1aa59210', 1, 3, NULL, 'lunch_break.ipd_due_amount', 'messages', 'IPD Due Amount', 'active', NULL, NULL, '2025-06-21 00:42:46', '2025-06-21 00:42:46'),
(2767, '9f34afcd-fa7a-4df6-a61c-d9669232183e', 1, 3, NULL, 'lunch_break.recent_appointments', 'messages', 'Recent Appointments', 'active', NULL, NULL, '2025-06-21 00:42:46', '2025-06-21 00:42:46'),
(2768, '9f34afcd-fdb5-4265-a7a6-71b5eef7b1d9', 1, 3, NULL, 'custom_field.manual_instruction', 'messages', 'Manual Instruction', 'active', NULL, NULL, '2025-06-21 00:42:46', '2025-06-21 00:42:46'),
(2769, '9f34afce-00ec-4e61-85da-f8031712520e', 1, 3, NULL, 'custom_field.custom_field', 'messages', 'Custom Fields', 'active', NULL, NULL, '2025-06-21 00:42:46', '2025-06-21 00:42:46'),
(2770, '9f34afce-041a-4e65-89fa-5e57a8cf8dbe', 1, 3, NULL, 'custom_field.add_custom_field', 'messages', 'Add Custom Field', 'active', NULL, NULL, '2025-06-21 00:42:46', '2025-06-21 00:42:46'),
(2771, '9f34afce-0770-47a0-82d0-ce19bad969ba', 1, 3, NULL, 'custom_field.edit_custom_field', 'messages', 'Edit Custom Field', 'active', NULL, NULL, '2025-06-21 00:42:46', '2025-06-21 00:42:46'),
(2772, '9f34afce-0aee-4464-90ff-caa27d606fb5', 1, 3, NULL, 'custom_field.module_name', 'messages', 'Module Name', 'active', NULL, NULL, '2025-06-21 00:42:46', '2025-06-21 00:42:46'),
(2773, '9f34afce-0e47-4423-846b-712e40846000', 1, 3, NULL, 'custom_field.field_type', 'messages', 'Field Type', 'active', NULL, NULL, '2025-06-21 00:42:46', '2025-06-21 00:42:46'),
(2774, '9f34afce-117f-4136-ac5d-55234ee9d4fe', 1, 3, NULL, 'custom_field.field_name', 'messages', 'Field Name', 'active', NULL, NULL, '2025-06-21 00:42:46', '2025-06-21 00:42:46'),
(2775, '9f34afce-14d4-4477-9967-c92b894b97b1', 1, 3, NULL, 'custom_field.grid', 'messages', 'Grid', 'active', NULL, NULL, '2025-06-21 00:42:46', '2025-06-21 00:42:46'),
(2776, '9f34afce-17ff-4ba1-b7b5-0e406bc3c8ff', 1, 3, NULL, 'custom_field.value', 'messages', 'Value', 'active', NULL, NULL, '2025-06-21 00:42:46', '2025-06-21 00:42:46'),
(2777, '9f34afce-1cea-4ece-b257-00464dcb77c0', 1, 3, NULL, 'custom_field.seperated_by_comma', 'messages', 'Seperated by Comma', 'active', NULL, NULL, '2025-06-21 00:42:46', '2025-06-21 00:42:46'),
(2778, '9f34afce-2030-4856-8251-c72e47dd255e', 1, 3, NULL, 'custom_field.is_reqired', 'messages', 'Is Reqired', 'active', NULL, NULL, '2025-06-21 00:42:46', '2025-06-21 00:42:46'),
(2779, '9f34afce-2356-411f-968f-4dca395f9ef7', 1, 3, NULL, 'custom_field.input', 'messages', 'Input', 'active', NULL, NULL, '2025-06-21 00:42:46', '2025-06-21 00:42:46'),
(2780, '9f34afce-26a8-40c2-80f6-0391838833be', 1, 3, NULL, 'custom_field.textarea', 'messages', 'Textarea', 'active', NULL, NULL, '2025-06-21 00:42:46', '2025-06-21 00:42:46'),
(2781, '9f34afce-29db-4f9a-9995-bf0cc41c2bec', 1, 3, NULL, 'custom_field.checkbox', 'messages', 'Checkbox', 'active', NULL, NULL, '2025-06-21 00:42:46', '2025-06-21 00:42:46'),
(2782, '9f34afce-2d1b-4525-b9d1-69f458525c96', 1, 3, NULL, 'custom_field.number', 'messages', 'Number', 'active', NULL, NULL, '2025-06-21 00:42:46', '2025-06-21 00:42:46'),
(2783, '9f34afce-3051-4ac8-a1ce-be869e7ff1a3', 1, 3, NULL, 'custom_field.dropdown', 'messages', 'Dropdown', 'active', NULL, NULL, '2025-06-21 00:42:46', '2025-06-21 00:42:46'),
(2784, '9f34afce-33bc-4b66-a39a-fdb8d5c79017', 1, 3, NULL, 'custom_field.multi_select', 'messages', 'Multi select', 'active', NULL, NULL, '2025-06-21 00:42:46', '2025-06-21 00:42:46'),
(2785, '9f34afce-3702-4cb3-815d-64031f6a893a', 1, 3, NULL, 'custom_field.date', 'messages', 'Date', 'active', NULL, NULL, '2025-06-21 00:42:46', '2025-06-21 00:42:46'),
(2786, '9f34afce-3a50-45cf-8917-22715f7d12f4', 1, 3, NULL, 'custom_field.date_time', 'messages', 'Date & Time', 'active', NULL, NULL, '2025-06-21 00:42:46', '2025-06-21 00:42:46'),
(2787, '9f34afce-3d91-48e4-85f1-4e0f9b019429', 1, 3, NULL, 'custom_field.appointment', 'messages', 'Appointment', 'active', NULL, NULL, '2025-06-21 00:42:46', '2025-06-21 00:42:46'),
(2788, '9f34afce-40b8-4ed4-8374-c036ada408e6', 1, 3, NULL, 'custom_field.ipd_patient', 'messages', 'IPD Patient', 'active', NULL, NULL, '2025-06-21 00:42:46', '2025-06-21 00:42:46'),
(2789, '9f34afce-43e9-45ee-a8c6-8f51b6c92483', 1, 3, NULL, 'custom_field.opd_patient', 'messages', 'OPD Patient', 'active', NULL, NULL, '2025-06-21 00:42:46', '2025-06-21 00:42:46'),
(2790, '9f34afce-4730-41d5-a26b-35ff80fb6755', 1, 3, NULL, 'custom_field.patient', 'messages', 'Patient', 'active', NULL, NULL, '2025-06-21 00:42:46', '2025-06-21 00:42:46'),
(2791, '9f34afce-4a87-44fa-92cb-f75ecbc0be92', 1, 3, NULL, 'custom_field.value_must_be_greter_then', 'messages', 'Value must be greter then 1', 'active', NULL, NULL, '2025-06-21 00:42:46', '2025-06-21 00:42:46'),
(2792, '9f34afce-4dd1-4ae9-ab0d-50b57ced1db3', 1, 3, NULL, 'custom_field.select_module', 'messages', 'Select Module', 'active', NULL, NULL, '2025-06-21 00:42:46', '2025-06-21 00:42:46'),
(2793, '9f34afce-5101-4a71-bccd-eeb5d406ebaf', 1, 3, NULL, 'custom_field.select_field_type', 'messages', 'Select Field Type', 'active', NULL, NULL, '2025-06-21 00:42:46', '2025-06-21 00:42:46'),
(2794, '9f34afce-5412-472a-bca7-11544e899db5', 1, 3, NULL, 'custom_field.value_field_required', 'messages', 'The value field is required.', 'active', NULL, NULL, '2025-06-21 00:42:46', '2025-06-21 00:42:46'),
(2795, '9f34afce-5749-4bdf-be38-9b641a791e6a', 1, 3, NULL, 'custom_field.toggle', 'messages', 'Toggle', 'active', NULL, NULL, '2025-06-21 00:42:46', '2025-06-21 00:42:46'),
(2796, '9f34afce-5a8e-4890-90fd-1c371d5130c7', 1, 3, NULL, 'custom_field.text', 'messages', 'Text', 'active', NULL, NULL, '2025-06-21 00:42:46', '2025-06-21 00:42:46'),
(2797, '9f34afce-5de5-431a-9cbc-a5cfffe5999b', 1, 3, NULL, 'custom_field.grid_tooltip', 'messages', '(Bootstrap Column e.g. 6) - Max is 12', 'active', NULL, NULL, '2025-06-21 00:42:46', '2025-06-21 00:42:46'),
(2798, '9f34afce-6159-43eb-a091-f694441cf3d0', 1, 3, NULL, 'custom_field.diagnosis_success', 'messages', 'Diagnosis Report status updated successfully.', 'active', NULL, NULL, '2025-06-21 00:42:46', '2025-06-21 00:42:46'),
(2799, '9f34afce-648f-4573-b591-c4f7c67475bc', 1, 3, NULL, 'custom_field.case_exist', 'messages', 'IPD Patient is already exists.', 'active', NULL, NULL, '2025-06-21 00:42:46', '2025-06-21 00:42:46'),
(2800, '9f34afce-67c7-4805-9870-699e1fb71d4e', 1, 3, NULL, 'custom_field.payment_request_send', 'messages', 'Payment request sent successfully.', 'active', NULL, NULL, '2025-06-21 00:42:46', '2025-06-21 00:42:46'),
(2801, '9f34afce-6aff-4630-ae83-e180240b00b7', 1, 3, NULL, 'phonepe.phonepe', 'messages', 'PhonePe', 'active', NULL, NULL, '2025-06-21 00:42:46', '2025-06-21 00:42:46'),
(2802, '9f34afce-6e52-433d-a775-9f61fd2e6010', 1, 3, NULL, 'phonepe.phonepe_merchant_id', 'messages', 'Phonepe Merchant ID', 'active', NULL, NULL, '2025-06-21 00:42:46', '2025-06-21 00:42:46'),
(2803, '9f34afce-7187-44d6-b9f6-7cb590b17b1c', 1, 3, NULL, 'phonepe.phonepe_merchant_user_id', 'messages', 'Phonepe Merchant User ID', 'active', NULL, NULL, '2025-06-21 00:42:46', '2025-06-21 00:42:46'),
(2804, '9f34afce-74cc-4c19-8c41-ff79454df319', 1, 3, NULL, 'phonepe.phonepe_env', 'messages', 'Phonepe Env', 'active', NULL, NULL, '2025-06-21 00:42:46', '2025-06-21 00:42:46'),
(2805, '9f34afce-7829-41c3-acea-5411127076af', 1, 3, NULL, 'phonepe.phonepe_salt_key', 'messages', 'Phonepe Salt Key', 'active', NULL, NULL, '2025-06-21 00:42:46', '2025-06-21 00:42:46'),
(2806, '9f34afce-7b80-4c5f-89e3-174cc3364b6e', 1, 3, NULL, 'phonepe.phonepe_salt_index', 'messages', 'Phonepe Salt Index', 'active', NULL, NULL, '2025-06-21 00:42:46', '2025-06-21 00:42:46'),
(2807, '9f34afce-7ec3-4b9a-9c93-0e231e24c724', 1, 3, NULL, 'phonepe.phonepe_merchant_transaction_id', 'messages', 'Phonepe Merchant Transaction ID', 'active', NULL, NULL, '2025-06-21 00:42:46', '2025-06-21 00:42:46'),
(2808, '9f34afce-81fc-4102-bd5a-0b78493ce988', 1, 3, NULL, 'phonepe.currency_allowed', 'messages', 'Only INR Currency allowed', 'active', NULL, NULL, '2025-06-21 00:42:46', '2025-06-21 00:42:46'),
(2809, '9f34afce-8658-4570-b2b7-38a7e4c8000e', 1, 3, NULL, 'flutterwave.flutterwave', 'messages', 'FlutterWave', 'active', NULL, NULL, '2025-06-21 00:42:46', '2025-06-21 00:42:46'),
(2810, '9f34afce-89b1-4e11-8b23-5bc37bd0e627', 1, 3, NULL, 'flutterwave.set_flutterwave_credential', 'messages', 'Please Set your flutterwave Credentials.', 'active', NULL, NULL, '2025-06-21 00:42:46', '2025-06-21 00:42:46'),
(2811, '9f34afce-8d0a-4069-b604-4e5857febc02', 1, 3, NULL, 'flutterwave.currency_allowed', 'messages', 'Only \'GBP\',\'CAD\',\'XAF\',\'CLP\',\'COP\',\'EGP\',\'EUR\',\'GHS\',\'GNF\',\'KES\',\'MWK\',\'MAD\',\'NGN\',\'RWF\',\'SLL\',\'STD\',\'ZAR\',\'TZS\',\'UGX\',\'USD\',\'XOF\',\'ZMW\' Currency is Allowed.', 'active', NULL, NULL, '2025-06-21 00:42:46', '2025-06-21 00:42:46'),
(2812, '9f34afce-9049-4ae7-bb08-590ae28fbde0', 1, 3, NULL, 'flutterwave.flutterwave_public_key', 'messages', 'FlutterWave Public Key', 'active', NULL, NULL, '2025-06-21 00:42:46', '2025-06-21 00:42:46'),
(2813, '9f34afce-937c-478a-9c8a-171b5202c03c', 1, 3, NULL, 'flutterwave.flutterwave_secret_key', 'messages', 'FlutterWave Seceret Key', 'active', NULL, NULL, '2025-06-21 00:42:46', '2025-06-21 00:42:46'),
(2814, '9f34afce-96b0-4188-be82-b464cc55b233', 1, 3, NULL, 'google_meet.connect_calendar', 'messages', 'Connect your google calendar', 'active', NULL, NULL, '2025-06-21 00:42:46', '2025-06-21 00:42:46'),
(2815, '9f34afce-99f4-4213-8ea8-5caf71d4cbbb', 1, 3, NULL, 'google_meet.connect_google_meet', 'messages', 'Connect Google Calendar', 'active', NULL, NULL, '2025-06-21 00:42:46', '2025-06-21 00:42:46'),
(2816, '9f34afce-9d35-4685-afef-ebcf54652b34', 1, 3, NULL, 'google_meet.disconnect_google_calendar', 'messages', 'Disconnect your google calendar', 'active', NULL, NULL, '2025-06-21 00:42:46', '2025-06-21 00:42:46'),
(2817, '9f34afce-a094-40ff-8912-8600d2861031', 1, 3, NULL, 'google_meet.sync_google_calendar', 'messages', 'Sync your google calendar', 'active', NULL, NULL, '2025-06-21 00:42:46', '2025-06-21 00:42:46'),
(2818, '9f34afce-a3db-4b65-85d2-dd79f1310568', 1, 3, NULL, 'google_meet.validate_json_file', 'messages', 'Please set your google calendar credentials json file', 'active', NULL, NULL, '2025-06-21 00:42:46', '2025-06-21 00:42:46'),
(2819, '9f34afce-a70a-4d21-8956-05961e9f4305', 1, 3, NULL, 'google_meet.google_calendar_connect', 'messages', 'Google Calendar Connected Successfully', 'active', NULL, NULL, '2025-06-21 00:42:46', '2025-06-21 00:42:46'),
(2820, '9f34afce-aa5d-4198-8b1a-cced2f34cc63', 1, 3, NULL, 'google_meet.google_calendar_add', 'messages', 'Calendar added successfully', 'active', NULL, NULL, '2025-06-21 00:42:46', '2025-06-21 00:42:46'),
(2821, '9f34afce-add7-4c10-b75e-940404941a11', 1, 3, NULL, 'google_meet.google_calendar_update', 'messages', 'Google calender updated successfully.', 'active', NULL, NULL, '2025-06-21 00:42:46', '2025-06-21 00:42:46'),
(2822, '9f34afce-b154-4727-af18-9e2881743e21', 1, 3, NULL, 'google_meet.disconnect_or_reconnect', 'messages', 'Please disconnect and reconnect your google calendar', 'active', NULL, NULL, '2025-06-21 00:42:46', '2025-06-21 00:42:46'),
(2823, '9f34afce-b493-4c5b-abfa-13c635f79017', 1, 3, NULL, 'google_meet.google_calendar_disconnect', 'messages', 'Google calender disconnected', 'active', NULL, NULL, '2025-06-21 00:42:46', '2025-06-21 00:42:46'),
(2824, '9f34afce-b7d2-4fdb-8d01-7443ff42385a', 1, 3, NULL, 'google_meet.select_google_calendar', 'messages', 'Select your calendars (from Google Calendar) in which you want to create the events', 'active', NULL, NULL, '2025-06-21 00:42:46', '2025-06-21 00:42:46'),
(2825, '9f34afce-bb0c-4264-9367-d9f1b0b87764', 1, 3, NULL, 'google_meet.platform_type', 'messages', 'Platform Type', 'active', NULL, NULL, '2025-06-21 00:42:46', '2025-06-21 00:42:46'),
(2826, '9f34afce-be4f-4ff4-b119-cb0520976696', 1, 3, NULL, 'google_meet.opd_prescription', 'messages', 'OPD Prescription', 'active', NULL, NULL, '2025-06-21 00:42:46', '2025-06-21 00:42:46'),
(2827, '9f34afce-c190-4ce6-b369-a0ef2a4fdc50', 1, 3, NULL, 'google_meet.google_json_file', 'messages', 'Google JSON File', 'active', NULL, NULL, '2025-06-21 00:42:46', '2025-06-21 00:42:46'),
(2828, '9f34afce-c4b9-49c1-a176-6f0bf96a7887', 1, 3, NULL, 'google_meet.upload_json_file', 'messages', 'Please upload your google calendar credentials JSON file', 'active', NULL, NULL, '2025-06-21 00:42:46', '2025-06-21 00:42:46'),
(2829, '9f34afce-c808-40f4-9104-66ee2d3c62ef', 1, 3, NULL, 'google_meet.upload_file', 'messages', 'Please upload a JSON file.', 'active', NULL, NULL, '2025-06-21 00:42:46', '2025-06-21 00:42:46'),
(2830, '9f34afce-cb45-4a7e-9fbb-f36ee8fde521', 1, 3, NULL, 'google_meet.invalid_json_format', 'messages', 'Invalid input format. Please upload JSON format file.', 'active', NULL, NULL, '2025-06-21 00:42:46', '2025-06-21 00:42:46'),
(2831, '9f34afce-ce9a-496d-a816-a3abb62906f3', 1, 3, NULL, 'google_meet.json_file_saved_successfully', 'messages', 'Google Calendar JSON File Saved Successfully.', 'active', NULL, NULL, '2025-06-21 00:42:46', '2025-06-21 00:42:46'),
(2832, '9f34afce-d1f5-4505-83bb-ecc6d28bbe3d', 1, 3, NULL, 'google_meet.upload_again_json_file', 'messages', 'The Google JSON file does not exist. Please again upload JSON File.', 'active', NULL, NULL, '2025-06-21 00:42:46', '2025-06-21 00:42:46'),
(2833, '9f34afce-d55c-471b-8241-576a8f9f3c88', 1, 3, NULL, 'schedule_weekday.Monday', 'messages', 'Monday', 'active', NULL, NULL, '2025-06-21 00:42:46', '2025-06-21 00:42:46'),
(2834, '9f34afce-d8c7-4dd9-9208-31ec44eeccdf', 1, 3, NULL, 'schedule_weekday.Tuesday', 'messages', 'Tuesday', 'active', NULL, NULL, '2025-06-21 00:42:46', '2025-06-21 00:42:46'),
(2835, '9f34afce-dc08-4b40-b9ef-3ed26ea94283', 1, 3, NULL, 'schedule_weekday.Wednesday', 'messages', 'Wednesday', 'active', NULL, NULL, '2025-06-21 00:42:46', '2025-06-21 00:42:46'),
(2836, '9f34afce-df4f-4c6c-b1f1-679b260fd7fa', 1, 3, NULL, 'schedule_weekday.Thursday', 'messages', 'Thursday', 'active', NULL, NULL, '2025-06-21 00:42:46', '2025-06-21 00:42:46'),
(2837, '9f34afce-e28e-4ac2-9a7c-6dbf9547563e', 1, 3, NULL, 'schedule_weekday.Friday', 'messages', 'Friday', 'active', NULL, NULL, '2025-06-21 00:42:46', '2025-06-21 00:42:46'),
(2838, '9f34afce-e5c8-4085-adec-7448f07d5cd0', 1, 3, NULL, 'schedule_weekday.Saturday', 'messages', 'Saturday', 'active', NULL, NULL, '2025-06-21 00:42:46', '2025-06-21 00:42:46'),
(2839, '9f34afce-e8f7-415c-8351-e8bbb387ccd3', 1, 3, NULL, 'schedule_weekday.Sunday', 'messages', 'Sunday', 'active', NULL, NULL, '2025-06-21 00:42:46', '2025-06-21 00:42:46'),
(2840, '9f34afce-ec47-4d8f-8805-e4866e9a17b1', 1, 3, NULL, 'hospital_schedule_weekday.MON', 'messages', 'MON', 'active', NULL, NULL, '2025-06-21 00:42:46', '2025-06-21 00:42:46'),
(2841, '9f34afce-ef86-4d91-9449-f59ba50674b2', 1, 3, NULL, 'hospital_schedule_weekday.TUE', 'messages', 'TUE', 'active', NULL, NULL, '2025-06-21 00:42:46', '2025-06-21 00:42:46'),
(2842, '9f34afce-f2f1-472a-aa4f-6dbdc4b1991d', 1, 3, NULL, 'hospital_schedule_weekday.WED', 'messages', 'WED', 'active', NULL, NULL, '2025-06-21 00:42:46', '2025-06-21 00:42:46'),
(2843, '9f34afce-f649-47c0-824a-04abf5bc9781', 1, 3, NULL, 'hospital_schedule_weekday.THU', 'messages', 'THU', 'active', NULL, NULL, '2025-06-21 00:42:46', '2025-06-21 00:42:46'),
(2844, '9f34afce-f978-4163-a4b5-f5abcc5d3892', 1, 3, NULL, 'hospital_schedule_weekday.FRI', 'messages', 'FRI', 'active', NULL, NULL, '2025-06-21 00:42:46', '2025-06-21 00:42:46'),
(2845, '9f34afce-fcce-4045-83b1-382012470739', 1, 3, NULL, 'hospital_schedule_weekday.SAT', 'messages', 'SAT', 'active', NULL, NULL, '2025-06-21 00:42:46', '2025-06-21 00:42:46'),
(2846, '9f34afcf-0010-423d-817b-f91135bdab90', 1, 3, NULL, 'hospital_schedule_weekday.SUN', 'messages', 'SUN', 'active', NULL, NULL, '2025-06-21 00:42:46', '2025-06-21 00:42:46'),
(2847, '9f34afcf-0387-432a-b817-f468f67abe58', 1, 3, NULL, 'open_ai.open_ai', 'messages', 'Openai', 'active', NULL, NULL, '2025-06-21 00:42:46', '2025-06-21 00:42:46'),
(2848, '9f34afcf-06c8-45f2-b663-e95017a86fb1', 1, 3, NULL, 'open_ai.provide_prompt', 'messages', 'Please Provide Physical Information for Prompt.', 'active', NULL, NULL, '2025-06-21 00:42:46', '2025-06-21 00:42:46'),
(2849, '9f34afcf-0a19-4cc4-9c29-b7bb6efc83a2', 1, 3, NULL, 'open_ai.open_ai_key_not_found', 'messages', 'OpenAI API key not found.', 'active', NULL, NULL, '2025-06-21 00:42:46', '2025-06-21 00:42:46'),
(2850, '9f34afcf-0d5a-4e38-aa6b-b118341a897d', 1, 3, NULL, 'open_ai.repsonse_retrive_successfully', 'messages', 'Response retrieved successfully.', 'active', NULL, NULL, '2025-06-21 00:42:46', '2025-06-21 00:42:46'),
(2851, '9f34afcf-108d-4bb6-9c5f-e8a2705c376a', 1, 3, NULL, 'open_ai.open_ai_key', 'messages', 'Open AI Key', 'active', NULL, NULL, '2025-06-21 00:42:46', '2025-06-21 00:42:46'),
(2852, '9f34afcf-13eb-4f29-a5cb-48c4278afdd4', 1, 3, NULL, 'open_ai.suggest_medicines', 'messages', 'Suggest Medicines', 'active', NULL, NULL, '2025-06-21 00:42:46', '2025-06-21 00:42:46'),
(2853, '9f34afcf-171e-4e51-a956-5cd4fb3fbb9c', 1, 3, NULL, 'open_ai.suggested_medicines', 'messages', 'Suggested Medicines', 'active', NULL, NULL, '2025-06-21 00:42:47', '2025-06-21 00:42:47'),
(2854, '9f34afcf-1a6d-4613-a1fc-1de4cd297b55', 1, 3, NULL, 'plan_frequency.1', 'messages', 'Monthly', 'active', NULL, NULL, '2025-06-21 00:42:47', '2025-06-21 00:42:47'),
(2855, '9f34afcf-1dbb-4a2d-a05a-9d50cec41e09', 1, 3, NULL, 'plan_frequency.2', 'messages', 'Yearly', 'active', NULL, NULL, '2025-06-21 00:42:47', '2025-06-21 00:42:47'),
(2856, '9f34afcf-20fd-4dbf-9795-a85472a691ab', 1, 3, NULL, 'fields.the', 'messages', 'The', 'active', NULL, NULL, '2025-06-21 00:42:47', '2025-06-21 00:42:47'),
(2857, '9f34afcf-2452-4e5e-a8eb-009348d0313c', 1, 3, NULL, 'fields.required', 'messages', 'field is required.', 'active', NULL, NULL, '2025-06-21 00:42:47', '2025-06-21 00:42:47'),
(2858, '9f34afcf-2794-4152-9cd6-238715b4f934', 1, 3, NULL, 'fields.unique', 'messages', 'The email has already been taken.', 'active', NULL, NULL, '2025-06-21 00:42:47', '2025-06-21 00:42:47'),
(2859, '9f34afcf-2ae3-4a1a-81e1-12fa739b078f', 1, 3, NULL, 'fields.min_char', 'messages', 'The password must be at least 8 characters.', 'active', NULL, NULL, '2025-06-21 00:42:47', '2025-06-21 00:42:47'),
(2860, '9f34afcf-2e42-454b-a31d-a47735fb2e78', 1, 3, NULL, 'fields.confirm', 'messages', 'The confirm Password confirmation does not match.', 'active', NULL, NULL, '2025-06-21 00:42:47', '2025-06-21 00:42:47'),
(2861, '9f34afcf-31b2-43e9-acb9-c9dce122160f', 1, 3, NULL, 'translation', 'messages', 'Translations', 'active', NULL, NULL, '2025-06-21 00:42:47', '2025-06-21 00:42:47'),
(2862, '9f34afcf-335b-4619-985b-40ecebf950e9', 1, 4, NULL, 'accepted', 'validation', 'The :attribute must be accepted.', 'active', '[\"attribute\"]', NULL, '2025-06-21 00:42:47', '2025-06-21 00:42:47'),
(2863, '9f34afcf-3477-46fd-8c03-ec29cc12cb51', 1, 4, NULL, 'active_url', 'validation', 'The :attribute is not a valid URL.', 'active', '[\"attribute\"]', NULL, '2025-06-21 00:42:47', '2025-06-21 00:42:47'),
(2864, '9f34afcf-3587-44b2-aa0f-c6de2b5d0313', 1, 4, NULL, 'after', 'validation', 'The :attribute must be a date after :date.', 'active', '[\"attribute\", \"date\"]', NULL, '2025-06-21 00:42:47', '2025-06-21 00:42:47'),
(2865, '9f34afcf-36a6-4752-93fe-8a219e752c07', 1, 4, NULL, 'after_or_equal', 'validation', 'The :attribute must be a date after or equal to :date.', 'active', '[\"attribute\", \"date\"]', NULL, '2025-06-21 00:42:47', '2025-06-21 00:42:47'),
(2866, '9f34afcf-37bc-4bb8-b9e8-09d8a913d026', 1, 4, NULL, 'alpha', 'validation', 'The :attribute must only contain letters.', 'active', '[\"attribute\"]', NULL, '2025-06-21 00:42:47', '2025-06-21 00:42:47'),
(2867, '9f34afcf-38ca-4a6d-92aa-675f2357679f', 1, 4, NULL, 'alpha_dash', 'validation', 'The :attribute must only contain letters, numbers, dashes and underscores.', 'active', '[\"attribute\"]', NULL, '2025-06-21 00:42:47', '2025-06-21 00:42:47'),
(2868, '9f34afcf-39d3-47e3-ae4e-6d1adf59fac3', 1, 4, NULL, 'alpha_num', 'validation', 'The :attribute must only contain letters and numbers.', 'active', '[\"attribute\"]', NULL, '2025-06-21 00:42:47', '2025-06-21 00:42:47'),
(2869, '9f34afcf-3aec-4424-988b-b9ce4132aeca', 1, 4, NULL, 'array', 'validation', 'The :attribute must be an array.', 'active', '[\"attribute\"]', NULL, '2025-06-21 00:42:47', '2025-06-21 00:42:47'),
(2870, '9f34afcf-3bfd-4195-9732-ff113bf8fdaa', 1, 4, NULL, 'before', 'validation', 'The :attribute must be a date before :date.', 'active', '[\"attribute\", \"date\"]', NULL, '2025-06-21 00:42:47', '2025-06-21 00:42:47'),
(2871, '9f34afcf-3d24-4671-9d8b-a5c01213f50f', 1, 4, NULL, 'before_or_equal', 'validation', 'The :attribute must be a date before or equal to :date.', 'active', '[\"attribute\", \"date\"]', NULL, '2025-06-21 00:42:47', '2025-06-21 00:42:47'),
(2872, '9f34afcf-3e36-4a54-a9ad-c4ef0e4dd034', 1, 4, NULL, 'between.numeric', 'validation', 'The :attribute must be between :min and :max.', 'active', '[\"attribute\", \"min\", \"max\"]', NULL, '2025-06-21 00:42:47', '2025-06-21 00:42:47'),
(2873, '9f34afcf-3f4c-4422-8241-bfef16b5ed69', 1, 4, NULL, 'between.file', 'validation', 'The :attribute must be between :min and :max kilobytes.', 'active', '[\"attribute\", \"min\", \"max\"]', NULL, '2025-06-21 00:42:47', '2025-06-21 00:42:47'),
(2874, '9f34afcf-407b-4ed3-9473-152c24f939d2', 1, 4, NULL, 'between.string', 'validation', 'The :attribute must be between :min and :max characters.', 'active', '[\"attribute\", \"min\", \"max\"]', NULL, '2025-06-21 00:42:47', '2025-06-21 00:42:47'),
(2875, '9f34afcf-4193-4f93-aa10-2eca2c380b1a', 1, 4, NULL, 'between.array', 'validation', 'The :attribute must have between :min and :max items.', 'active', '[\"attribute\", \"min\", \"max\"]', NULL, '2025-06-21 00:42:47', '2025-06-21 00:42:47'),
(2876, '9f34afcf-429d-4a9a-8504-1f468758908a', 1, 4, NULL, 'confirmed', 'validation', 'The :attribute confirmation does not match.', 'active', '[\"attribute\"]', NULL, '2025-06-21 00:42:47', '2025-06-21 00:42:47'),
(2877, '9f34afcf-43e2-44f4-b2fd-36f217c44daf', 1, 4, NULL, 'date', 'validation', 'The :attribute is not a valid date.', 'active', '[\"attribute\"]', NULL, '2025-06-21 00:42:47', '2025-06-21 00:42:47'),
(2878, '9f34afcf-451b-4167-81f1-6bcf9e1ccbdb', 1, 4, NULL, 'date_equals', 'validation', 'The :attribute must be a date equal to :date.', 'active', '[\"attribute\", \"date\"]', NULL, '2025-06-21 00:42:47', '2025-06-21 00:42:47'),
(2879, '9f34afcf-462e-4229-aa70-b2860d55feb9', 1, 4, NULL, 'date_format', 'validation', 'The :attribute does not match the format :format.', 'active', '[\"attribute\", \"format\"]', NULL, '2025-06-21 00:42:47', '2025-06-21 00:42:47'),
(2880, '9f34afcf-4741-43aa-84fa-fd057b374d62', 1, 4, NULL, 'different', 'validation', 'The :attribute and :other must be different.', 'active', '[\"attribute\", \"other\"]', NULL, '2025-06-21 00:42:47', '2025-06-21 00:42:47'),
(2881, '9f34afcf-484e-4708-ba64-b40e83f428c7', 1, 4, NULL, 'digits', 'validation', 'The :attribute must be :digits digits.', 'active', '[\"attribute\", \"digits\"]', NULL, '2025-06-21 00:42:47', '2025-06-21 00:42:47'),
(2882, '9f34afcf-495c-4879-8ac9-1164f9b3bf79', 1, 4, NULL, 'digits_between', 'validation', 'The :attribute must be between :min and :max digits.', 'active', '[\"attribute\", \"min\", \"max\"]', NULL, '2025-06-21 00:42:47', '2025-06-21 00:42:47'),
(2883, '9f34afcf-4a8a-4ac0-82f8-0f7ce62644ee', 1, 4, NULL, 'dimensions', 'validation', 'The :attribute has invalid image dimensions.', 'active', '[\"attribute\"]', NULL, '2025-06-21 00:42:47', '2025-06-21 00:42:47'),
(2884, '9f34afcf-4ba5-41f0-836a-e58cb3cffb64', 1, 4, NULL, 'email', 'validation', 'The :attribute must be a valid email address.', 'active', '[\"attribute\"]', NULL, '2025-06-21 00:42:47', '2025-06-21 00:42:47'),
(2885, '9f34afcf-4ccf-46e9-89bd-f813ec3a2542', 1, 4, NULL, 'ends_with', 'validation', 'The :attribute must end with one of the following: :values.', 'active', '[\"attribute\", \"values\"]', NULL, '2025-06-21 00:42:47', '2025-06-21 00:42:47'),
(2886, '9f34afcf-4dec-4d25-bb22-bf0aee242a38', 1, 4, NULL, 'file', 'validation', 'The :attribute must be a file.', 'active', '[\"attribute\"]', NULL, '2025-06-21 00:42:47', '2025-06-21 00:42:47'),
(2887, '9f34afcf-4ef9-4049-8cd9-8d1314dfa57e', 1, 4, NULL, 'gt.numeric', 'validation', 'The :attribute must be greater than :value.', 'active', '[\"attribute\", \"value\"]', NULL, '2025-06-21 00:42:47', '2025-06-21 00:42:47'),
(2888, '9f34afcf-5014-4193-9e4f-07f2d2dd5ee7', 1, 4, NULL, 'gt.file', 'validation', 'The :attribute must be greater than :value kilobytes.', 'active', '[\"attribute\", \"value\"]', NULL, '2025-06-21 00:42:47', '2025-06-21 00:42:47'),
(2889, '9f34afcf-5131-4057-bdbb-587267be2a81', 1, 4, NULL, 'gt.string', 'validation', 'The :attribute must be greater than :value characters.', 'active', '[\"attribute\", \"value\"]', NULL, '2025-06-21 00:42:47', '2025-06-21 00:42:47'),
(2890, '9f34afcf-5265-4cae-9fef-858c9cf8372d', 1, 4, NULL, 'gt.array', 'validation', 'The :attribute must have more than :value items.', 'active', '[\"attribute\", \"value\"]', NULL, '2025-06-21 00:42:47', '2025-06-21 00:42:47'),
(2891, '9f34afcf-539e-4118-bb16-c54e62933da5', 1, 4, NULL, 'gte.numeric', 'validation', 'The :attribute must be greater than or equal :value.', 'active', '[\"attribute\", \"value\"]', NULL, '2025-06-21 00:42:47', '2025-06-21 00:42:47'),
(2892, '9f34afcf-55d2-4373-8799-eb7b9b00ebe9', 1, 4, NULL, 'gte.file', 'validation', 'The :attribute must be greater than or equal :value kilobytes.', 'active', '[\"attribute\", \"value\"]', NULL, '2025-06-21 00:42:47', '2025-06-21 00:42:47'),
(2893, '9f34afcf-5713-4808-9561-1532f594d9b7', 1, 4, NULL, 'gte.string', 'validation', 'The :attribute must be greater than or equal :value characters.', 'active', '[\"attribute\", \"value\"]', NULL, '2025-06-21 00:42:47', '2025-06-21 00:42:47'),
(2894, '9f34afcf-582a-48ab-b3c1-816dc2f881b2', 1, 4, NULL, 'gte.array', 'validation', 'The :attribute must have :value items or more.', 'active', '[\"attribute\", \"value\"]', NULL, '2025-06-21 00:42:47', '2025-06-21 00:42:47'),
(2895, '9f34afcf-5947-4634-8506-5791774f83f1', 1, 4, NULL, 'image', 'validation', 'The :attribute must be an image.', 'active', '[\"attribute\"]', NULL, '2025-06-21 00:42:47', '2025-06-21 00:42:47'),
(2896, '9f34afcf-5a62-4c4f-ba83-a05afcbee297', 1, 4, NULL, 'in_array', 'validation', 'The :attribute field does not exist in :other.', 'active', '[\"attribute\", \"other\"]', NULL, '2025-06-21 00:42:47', '2025-06-21 00:42:47'),
(2897, '9f34afcf-5b6d-43e5-af03-e7e426617a90', 1, 4, NULL, 'integer', 'validation', 'The :attribute must be an integer.', 'active', '[\"attribute\"]', NULL, '2025-06-21 00:42:47', '2025-06-21 00:42:47'),
(2898, '9f34afcf-5c7c-41e6-82fb-be06d007de13', 1, 4, NULL, 'ip', 'validation', 'The :attribute must be a valid IP address.', 'active', '[\"attribute\"]', NULL, '2025-06-21 00:42:47', '2025-06-21 00:42:47'),
(2899, '9f34afcf-5d9d-458c-887a-735ef1cc6040', 1, 4, NULL, 'ipv4', 'validation', 'The :attribute must be a valid IPv4 address.', 'active', '[\"attribute\"]', NULL, '2025-06-21 00:42:47', '2025-06-21 00:42:47'),
(2900, '9f34afcf-5ebc-4e02-a529-dda716307719', 1, 4, NULL, 'ipv6', 'validation', 'The :attribute must be a valid IPv6 address.', 'active', '[\"attribute\"]', NULL, '2025-06-21 00:42:47', '2025-06-21 00:42:47'),
(2901, '9f34afcf-5fca-4714-a418-2e32f74bae35', 1, 4, NULL, 'json', 'validation', 'The :attribute must be a valid JSON string.', 'active', '[\"attribute\"]', NULL, '2025-06-21 00:42:47', '2025-06-21 00:42:47'),
(2902, '9f34afcf-60df-478b-944c-beefc82f7cf2', 1, 4, NULL, 'lt.numeric', 'validation', 'The :attribute must be less than :value.', 'active', '[\"attribute\", \"value\"]', NULL, '2025-06-21 00:42:47', '2025-06-21 00:42:47'),
(2903, '9f34afcf-61f8-467a-814f-f918cfa8a008', 1, 4, NULL, 'lt.file', 'validation', 'The :attribute must be less than :value kilobytes.', 'active', '[\"attribute\", \"value\"]', NULL, '2025-06-21 00:42:47', '2025-06-21 00:42:47'),
(2904, '9f34afcf-630c-4b9e-9840-7caa56f9ae30', 1, 4, NULL, 'lt.string', 'validation', 'The :attribute must be less than :value characters.', 'active', '[\"attribute\", \"value\"]', NULL, '2025-06-21 00:42:47', '2025-06-21 00:42:47'),
(2905, '9f34afcf-642f-4eec-bcd6-4dc5c86aae96', 1, 4, NULL, 'lt.array', 'validation', 'The :attribute must have less than :value items.', 'active', '[\"attribute\", \"value\"]', NULL, '2025-06-21 00:42:47', '2025-06-21 00:42:47'),
(2906, '9f34afcf-6552-40b3-9469-1fe3b18dac7f', 1, 4, NULL, 'lte.numeric', 'validation', 'The :attribute must be less than or equal :value.', 'active', '[\"attribute\", \"value\"]', NULL, '2025-06-21 00:42:47', '2025-06-21 00:42:47'),
(2907, '9f34afcf-6676-45f2-afab-4aef656f2e74', 1, 4, NULL, 'lte.file', 'validation', 'The :attribute must be less than or equal :value kilobytes.', 'active', '[\"attribute\", \"value\"]', NULL, '2025-06-21 00:42:47', '2025-06-21 00:42:47'),
(2908, '9f34afcf-6788-4b3a-93d3-8178ffed36e7', 1, 4, NULL, 'lte.string', 'validation', 'The :attribute must be less than or equal :value characters.', 'active', '[\"attribute\", \"value\"]', NULL, '2025-06-21 00:42:47', '2025-06-21 00:42:47'),
(2909, '9f34afcf-68b3-40e0-8ecf-5c3585d165fc', 1, 4, NULL, 'lte.array', 'validation', 'The :attribute must not have more than :value items.', 'active', '[\"attribute\", \"value\"]', NULL, '2025-06-21 00:42:47', '2025-06-21 00:42:47'),
(2910, '9f34afcf-69d4-43b1-a741-2eb186f5e23e', 1, 4, NULL, 'max.numeric', 'validation', 'The :attribute must not be greater than :max.', 'active', '[\"attribute\", \"max\"]', NULL, '2025-06-21 00:42:47', '2025-06-21 00:42:47'),
(2911, '9f34afcf-6afa-4ec6-ab51-955f209a634a', 1, 4, NULL, 'max.file', 'validation', 'The :attribute must not be greater than :max kilobytes.', 'active', '[\"attribute\", \"max\"]', NULL, '2025-06-21 00:42:47', '2025-06-21 00:42:47'),
(2912, '9f34afcf-6c35-4d3f-ba75-463e03bed7d7', 1, 4, NULL, 'max.string', 'validation', 'The :attribute must not be greater than :max characters.', 'active', '[\"attribute\", \"max\"]', NULL, '2025-06-21 00:42:47', '2025-06-21 00:42:47'),
(2913, '9f34afcf-6d59-4ba6-bc93-de2074dbd848', 1, 4, NULL, 'max.array', 'validation', 'The :attribute must not have more than :max items.', 'active', '[\"attribute\", \"max\"]', NULL, '2025-06-21 00:42:47', '2025-06-21 00:42:47'),
(2914, '9f34afcf-6e73-42ef-9f46-745fbe25e5a2', 1, 4, NULL, 'mimes', 'validation', 'The :attribute must be a file of type: :values.', 'active', '[\"attribute\", \"values\"]', NULL, '2025-06-21 00:42:47', '2025-06-21 00:42:47'),
(2915, '9f34afcf-6f95-4b43-9338-f19f82ac03fb', 1, 4, NULL, 'mimetypes', 'validation', 'The :attribute must be a file of type: :values.', 'active', '[\"attribute\", \"values\"]', NULL, '2025-06-21 00:42:47', '2025-06-21 00:42:47');
INSERT INTO `ltu_phrases` (`id`, `uuid`, `translation_id`, `translation_file_id`, `phrase_id`, `key`, `group`, `value`, `status`, `parameters`, `note`, `created_at`, `updated_at`) VALUES
(2916, '9f34afcf-70af-45ef-850a-4ec7b32c8b6d', 1, 4, NULL, 'min.numeric', 'validation', 'The :attribute must be at least :min.', 'active', '[\"attribute\", \"min\"]', NULL, '2025-06-21 00:42:47', '2025-06-21 00:42:47'),
(2917, '9f34afcf-71f5-4708-a0c1-3a1a1340d97b', 1, 4, NULL, 'min.file', 'validation', 'The :attribute must be at least :min kilobytes.', 'active', '[\"attribute\", \"min\"]', NULL, '2025-06-21 00:42:47', '2025-06-21 00:42:47'),
(2918, '9f34afcf-731b-41b2-a5c5-b112a6cc576e', 1, 4, NULL, 'min.string', 'validation', 'The :attribute must be at least :min characters.', 'active', '[\"attribute\", \"min\"]', NULL, '2025-06-21 00:42:47', '2025-06-21 00:42:47'),
(2919, '9f34afcf-7430-4d27-b9a5-fa4033cf15fe', 1, 4, NULL, 'min.array', 'validation', 'The :attribute must have at least :min items.', 'active', '[\"attribute\", \"min\"]', NULL, '2025-06-21 00:42:47', '2025-06-21 00:42:47'),
(2920, '9f34afcf-756b-430a-ab35-a9e5d081dbd4', 1, 4, NULL, 'multiple_of', 'validation', 'The :attribute must be a multiple of :value.', 'active', '[\"attribute\", \"value\"]', NULL, '2025-06-21 00:42:47', '2025-06-21 00:42:47'),
(2921, '9f34afcf-768c-43a4-9ce4-183211f1380c', 1, 4, NULL, 'not_regex', 'validation', 'The :attribute format is invalid.', 'active', '[\"attribute\"]', NULL, '2025-06-21 00:42:47', '2025-06-21 00:42:47'),
(2922, '9f34afcf-77b0-4e84-890c-47171027c331', 1, 4, NULL, 'numeric', 'validation', 'The :attribute must be a number.', 'active', '[\"attribute\"]', NULL, '2025-06-21 00:42:47', '2025-06-21 00:42:47'),
(2923, '9f34afcf-78cd-48b0-ad96-79b36b509750', 1, 4, NULL, 'password', 'validation', 'The password is incorrect.', 'active', NULL, NULL, '2025-06-21 00:42:47', '2025-06-21 00:42:47'),
(2924, '9f34afcf-79e7-4100-92e3-a476a7c1154a', 1, 4, NULL, 'regex', 'validation', 'The :attribute format is invalid.', 'active', '[\"attribute\"]', NULL, '2025-06-21 00:42:47', '2025-06-21 00:42:47'),
(2925, '9f34afcf-7b03-4b88-be1f-3553c5c20d24', 1, 4, NULL, 'same', 'validation', 'The :attribute and :other must match.', 'active', '[\"attribute\", \"other\"]', NULL, '2025-06-21 00:42:47', '2025-06-21 00:42:47'),
(2926, '9f34afcf-7c38-4194-bdd7-82244a852f75', 1, 4, NULL, 'size.numeric', 'validation', 'The :attribute must be :size.', 'active', '[\"attribute\", \"size\"]', NULL, '2025-06-21 00:42:47', '2025-06-21 00:42:47'),
(2927, '9f34afcf-7d64-448c-9e9c-e5b95748ac8c', 1, 4, NULL, 'size.file', 'validation', 'The :attribute must be :size kilobytes.', 'active', '[\"attribute\", \"size\"]', NULL, '2025-06-21 00:42:47', '2025-06-21 00:42:47'),
(2928, '9f34afcf-7e8a-453c-96a9-27bc7225d9b0', 1, 4, NULL, 'size.string', 'validation', 'The :attribute must be :size characters.', 'active', '[\"attribute\", \"size\"]', NULL, '2025-06-21 00:42:47', '2025-06-21 00:42:47'),
(2929, '9f34afcf-7fa2-499a-95d1-362b887a8e6b', 1, 4, NULL, 'size.array', 'validation', 'The :attribute must contain :size items.', 'active', '[\"attribute\", \"size\"]', NULL, '2025-06-21 00:42:47', '2025-06-21 00:42:47'),
(2930, '9f34afcf-80be-4e7e-a60a-c0b8567f4887', 1, 4, NULL, 'starts_with', 'validation', 'The :attribute must start with one of the following: :values.', 'active', '[\"attribute\", \"values\"]', NULL, '2025-06-21 00:42:47', '2025-06-21 00:42:47'),
(2931, '9f34afcf-81e2-48bb-97e2-af9b7debe98f', 1, 4, NULL, 'string', 'validation', 'The :attribute must be a string.', 'active', '[\"attribute\"]', NULL, '2025-06-21 00:42:47', '2025-06-21 00:42:47'),
(2932, '9f34afcf-82fe-4403-83b4-90ebff9e0a87', 1, 4, NULL, 'timezone', 'validation', 'The :attribute must be a valid zone.', 'active', '[\"attribute\"]', NULL, '2025-06-21 00:42:47', '2025-06-21 00:42:47'),
(2933, '9f34afcf-8421-40e8-aaf8-b3742ca0c887', 1, 4, NULL, 'url', 'validation', 'The :attribute format is invalid.', 'active', '[\"attribute\"]', NULL, '2025-06-21 00:42:47', '2025-06-21 00:42:47'),
(2934, '9f34afcf-8541-4197-9715-7a66e9b91502', 1, 4, NULL, 'uuid', 'validation', 'The :attribute must be a valid UUID.', 'active', '[\"attribute\"]', NULL, '2025-06-21 00:42:47', '2025-06-21 00:42:47'),
(2935, '9f34afcf-8665-4b9d-b6c8-74815fb439df', 1, 4, NULL, 'is_unique', 'validation', 'The :attribute has already been taken.', 'active', '[\"attribute\"]', NULL, '2025-06-21 00:42:47', '2025-06-21 00:42:47'),
(2936, '9f34afcf-8787-45c0-860e-7b804c4ef396', 1, 4, NULL, 'custom.doctor_id.unique', 'validation', 'The doctor\'s name has already been taken.', 'active', NULL, NULL, '2025-06-21 00:42:47', '2025-06-21 00:42:47'),
(2937, '9f34afcf-88d3-43cf-a2c2-e6d5da44e0d9', 1, 5, NULL, 'departments', 'web', 'Departments', 'active', NULL, NULL, '2025-06-21 00:42:47', '2025-06-21 00:42:47'),
(2938, '9f34afcf-89e4-4447-842f-79a98e7c684e', 1, 5, NULL, 'backend_features', 'web', 'Backend Features', 'active', NULL, NULL, '2025-06-21 00:42:47', '2025-06-21 00:42:47'),
(2939, '9f34afcf-8af4-4673-9738-30c7c089cde4', 1, 5, NULL, 'testimonials', 'web', 'Testimonials', 'active', NULL, NULL, '2025-06-21 00:42:47', '2025-06-21 00:42:47'),
(2940, '9f34afcf-8c0c-401e-a110-377708000385', 1, 5, NULL, 'login', 'web', 'Login', 'active', NULL, NULL, '2025-06-21 00:42:47', '2025-06-21 00:42:47'),
(2941, '9f34afcf-8d20-4f4f-a877-b4745810f86d', 1, 5, NULL, 'register', 'web', 'Register', 'active', NULL, NULL, '2025-06-21 00:42:47', '2025-06-21 00:42:47'),
(2942, '9f34afcf-8e2d-4aa6-8022-b54cac773476', 1, 5, NULL, 'start_using_InfyHMS_now', 'web', 'Start Using InfyHMS now.', 'active', NULL, NULL, '2025-06-21 00:42:47', '2025-06-21 00:42:47'),
(2943, '9f34afcf-8f8d-4f1b-b48b-f845dda54c73', 1, 5, NULL, 'get_started', 'web', 'Get Started', 'active', NULL, NULL, '2025-06-21 00:42:47', '2025-06-21 00:42:47'),
(2944, '9f34afcf-90a7-4d61-9406-debc81b7864e', 1, 5, NULL, 'welcome_to', 'web', 'Welcome to', 'active', NULL, NULL, '2025-06-21 00:42:47', '2025-06-21 00:42:47'),
(2945, '9f34afcf-91c1-4053-a2ec-5f878b1744a0', 1, 5, NULL, 'infyhms', 'web', 'InfyHMS', 'active', NULL, NULL, '2025-06-21 00:42:47', '2025-06-21 00:42:47'),
(2946, '9f34afcf-92e2-48b9-9393-3f643188aaf9', 1, 5, NULL, 'manage_your_hospital_day_to_day_operations_digitally_with_ease_and_effortlessly', 'web', 'Manage your Hospital\'s day to day operations digitally with ease and effortlessly.', 'active', NULL, NULL, '2025-06-21 00:42:47', '2025-06-21 00:42:47'),
(2947, '9f34afcf-9418-47e0-a06e-a36176fefd61', 1, 5, NULL, 'buy_now', 'web', 'Buy Now', 'active', NULL, NULL, '2025-06-21 00:42:47', '2025-06-21 00:42:47'),
(2948, '9f34afcf-955c-4c39-9a84-7d030de7e05c', 1, 5, NULL, 'home', 'web', 'Home', 'active', NULL, NULL, '2025-06-21 00:42:47', '2025-06-21 00:42:47'),
(2949, '9f34afcf-9687-4bb6-882a-859db59c1164', 1, 5, NULL, 'about_us', 'web', 'About Us', 'active', NULL, NULL, '2025-06-21 00:42:47', '2025-06-21 00:42:47'),
(2950, '9f34afcf-97a1-4957-bc57-1221005c369d', 1, 5, NULL, 'features.features', 'web', 'Features', 'active', NULL, NULL, '2025-06-21 00:42:47', '2025-06-21 00:42:47'),
(2951, '9f34afcf-98da-4e5d-b0ef-df47e5334380', 1, 5, NULL, 'features.emergency_services', 'web', 'EMERGENCY SERVICES', 'active', NULL, NULL, '2025-06-21 00:42:47', '2025-06-21 00:42:47'),
(2952, '9f34afcf-99fc-4c70-9f20-2aba82186bd1', 1, 5, NULL, 'features.qualified_doctors', 'web', 'QUALIFIED DOCTORS', 'active', NULL, NULL, '2025-06-21 00:42:47', '2025-06-21 00:42:47'),
(2953, '9f34afcf-9b10-465a-b9b2-c7887552250f', 1, 5, NULL, 'features.outdoors_checkup', 'web', 'OUTDOORS CHECKUP', 'active', NULL, NULL, '2025-06-21 00:42:47', '2025-06-21 00:42:47'),
(2954, '9f34afcf-9c26-428a-a448-581cf652de87', 1, 5, NULL, 'features.hours_services', 'web', '24 HOURS SERVICE', 'active', NULL, NULL, '2025-06-21 00:42:47', '2025-06-21 00:42:47'),
(2955, '9f34afcf-9d39-4197-b77c-7f974f2b7d25', 1, 5, NULL, 'features.we_are_providing_advanced_emergency_services_We_have_well-equipped_emergency_and_trauma_center_with_facilities', 'web', 'We are providing advanced emergency services. We have well-equipped emergency and trauma center with facilities.', 'active', NULL, NULL, '2025-06-21 00:42:47', '2025-06-21 00:42:47'),
(2956, '9f34afcf-9e83-41cd-b055-dde8eec86495', 1, 5, NULL, 'features.our_team_of_pathologists_microbiologists_and_clinical_laboratory_scientists_are_always_ready_to_help_you_with_your_laboratory_needs', 'web', 'Our team of pathologists, microbiologists and clinical laboratory scientists are always ready to help you with your laboratory needs.', 'active', NULL, NULL, '2025-06-21 00:42:47', '2025-06-21 00:42:47'),
(2957, '9f34afcf-9fa7-48c5-b817-03e0448c6392', 1, 5, NULL, 'features.our_doctors_are_always_ready_for_outdoor_checkup_in_an_emergency_we_have_different_types_of_charges_as_per_checkup', 'web', 'Our doctors are always ready for outdoor checkup in an emergency. we have different types of charges as per checkup.', 'active', NULL, NULL, '2025-06-21 00:42:47', '2025-06-21 00:42:47'),
(2958, '9f34afcf-a0c0-4c3e-a5b8-93fb1fd9d4df', 1, 5, NULL, 'features.our_clinic_provides_extensive_medical_support_and_healthcare_services_24/7', 'web', 'Our clinic provides extensive medical support and healthcare services 24/7.', 'active', NULL, NULL, '2025-06-21 00:42:47', '2025-06-21 00:42:47'),
(2959, '9f34afcf-a1d3-458b-8004-bf4b9e748d76', 1, 5, NULL, 'backend_feature.dashboard', 'web', 'Dashboard', 'active', NULL, NULL, '2025-06-21 00:42:47', '2025-06-21 00:42:47'),
(2960, '9f34afcf-a320-4675-a61f-86981823c395', 1, 5, NULL, 'backend_feature.change_password', 'web', 'Change Password', 'active', NULL, NULL, '2025-06-21 00:42:47', '2025-06-21 00:42:47'),
(2961, '9f34afcf-a451-4881-a307-7ec72f7a285b', 1, 5, NULL, 'backend_feature.change_language', 'web', 'Change language', 'active', NULL, NULL, '2025-06-21 00:42:47', '2025-06-21 00:42:47'),
(2962, '9f34afcf-a56a-43bc-ad77-ae9452e82623', 1, 5, NULL, 'backend_feature.invoice_listing', 'web', 'Invoice Listing', 'active', NULL, NULL, '2025-06-21 00:42:47', '2025-06-21 00:42:47'),
(2963, '9f34afcf-a687-43e5-96d7-8bc0232d7c5d', 1, 5, NULL, 'backend_feature.create_invoice', 'web', 'Create Invoice', 'active', NULL, NULL, '2025-06-21 00:42:47', '2025-06-21 00:42:47'),
(2964, '9f34afcf-a798-4e7f-8402-205cbd1711be', 1, 5, NULL, 'backend_feature.create_bill', 'web', 'Create Bill', 'active', NULL, NULL, '2025-06-21 00:42:47', '2025-06-21 00:42:47'),
(2965, '9f34afcf-a8c1-43e3-aca1-b1d595890c0d', 1, 5, NULL, 'backend_feature.appointments', 'web', 'Appointments', 'active', NULL, NULL, '2025-06-21 00:42:47', '2025-06-21 00:42:47'),
(2966, '9f34afcf-a9dd-41d2-b7dd-8a3fd9f0bbfb', 1, 5, NULL, 'backend_feature.bed_listing', 'web', 'Bed Listing', 'active', NULL, NULL, '2025-06-21 00:42:47', '2025-06-21 00:42:47'),
(2967, '9f34afcf-aaf2-4e04-a3d5-cf1664907ae6', 1, 5, NULL, 'backend_feature.bed_details', 'web', 'Bed Details', 'active', NULL, NULL, '2025-06-21 00:42:47', '2025-06-21 00:42:47'),
(2968, '9f34afcf-ac0f-483b-a621-ad550b8cfe5d', 1, 5, NULL, 'backend_feature.bed_allotment', 'web', 'Bed Allotment', 'active', NULL, NULL, '2025-06-21 00:42:47', '2025-06-21 00:42:47'),
(2969, '9f34afcf-ad28-4da9-8068-03450f9050db', 1, 5, NULL, 'backend_feature.document', 'web', 'Document', 'active', NULL, NULL, '2025-06-21 00:42:47', '2025-06-21 00:42:47'),
(2970, '9f34afcf-ae4c-4c34-8b4a-a5f4666e83f5', 1, 5, NULL, 'backend_feature.add_ambulance', 'web', 'Add Ambulance', 'active', NULL, NULL, '2025-06-21 00:42:47', '2025-06-21 00:42:47'),
(2971, '9f34afcf-af57-441e-81d9-b5dd4b53e92c', 1, 5, NULL, 'backend_feature.create_insurance', 'web', 'Create Insurance', 'active', NULL, NULL, '2025-06-21 00:42:47', '2025-06-21 00:42:47'),
(2972, '9f34afcf-b06a-4e55-aaff-1fa5275fc35a', 1, 5, NULL, 'backend_feature.create_doctor', 'web', 'Create Doctor', 'active', NULL, NULL, '2025-06-21 00:42:47', '2025-06-21 00:42:47'),
(2973, '9f34afcf-b319-4264-868b-dd7664b164ba', 1, 5, NULL, 'backend_feature.create_medicine', 'web', 'Create Medicine', 'active', NULL, NULL, '2025-06-21 00:42:47', '2025-06-21 00:42:47'),
(2974, '9f34afcf-b443-45f2-a10a-c88bd0af94f5', 1, 5, NULL, 'backend_feature.add_employee_payroll_details', 'web', 'Add Employee Payroll Details', 'active', NULL, NULL, '2025-06-21 00:42:47', '2025-06-21 00:42:47'),
(2975, '9f34afcf-b67a-4049-8581-c3a50b414a80', 1, 5, NULL, 'backend_feature.employee_payroll_details', 'web', 'Employee Payroll Details', 'active', NULL, NULL, '2025-06-21 00:42:47', '2025-06-21 00:42:47'),
(2976, '9f34afcf-b790-415a-87ef-9d45c0dca8f9', 1, 5, NULL, 'backend_feature.payment_reports', 'web', 'Payment Reports', 'active', NULL, NULL, '2025-06-21 00:42:47', '2025-06-21 00:42:47'),
(2977, '9f34afcf-b8b6-41e7-8e86-cd66883699d1', 1, 5, NULL, 'backend_feature.enquiry_listing', 'web', 'Enquiry Listing', 'active', NULL, NULL, '2025-06-21 00:42:47', '2025-06-21 00:42:47'),
(2978, '9f34afcf-b9d4-4fdd-b4ae-17ff744b66bf', 1, 5, NULL, 'backend_feature.patient_admission_listing', 'web', 'Patient Admission Listing', 'active', NULL, NULL, '2025-06-21 00:42:47', '2025-06-21 00:42:47'),
(2979, '9f34afcf-baed-4f90-ac1a-e5330a1ee110', 1, 5, NULL, 'backend_feature.doctor_schedules', 'web', 'Doctor Schedules', 'active', NULL, NULL, '2025-06-21 00:42:47', '2025-06-21 00:42:47'),
(2980, '9f34afcf-bc06-4acb-9aa4-a302e6fb8288', 1, 5, NULL, 'backend_feature.birth_report_listing', 'web', 'Birth Report Listing', 'active', NULL, NULL, '2025-06-21 00:42:47', '2025-06-21 00:42:47'),
(2981, '9f34afcf-bd20-4deb-a374-078108d43abe', 1, 5, NULL, 'backend_feature.email_service', 'web', 'Email Service', 'active', NULL, NULL, '2025-06-21 00:42:47', '2025-06-21 00:42:47'),
(2982, '9f34afcf-be73-4b45-ade7-1fce2114ead1', 1, 5, NULL, 'backend_feature.settings', 'web', 'Settings', 'active', NULL, NULL, '2025-06-21 00:42:47', '2025-06-21 00:42:47'),
(2983, '9f34afcf-bfa0-4919-94f9-2fd4185791bf', 1, 5, NULL, 'miscellaneous_facilities.miscellaneous_facilities_of_infyhms', 'web', 'MISCELLANEOUS FACILITIES OF INFYHMS', 'active', NULL, NULL, '2025-06-21 00:42:47', '2025-06-21 00:42:47'),
(2984, '9f34afcf-c0bd-4ef7-9eeb-8d7ff6854870', 1, 5, NULL, 'miscellaneous_facilities.host_in_your_Own_secure_server', 'web', 'Host In Your Own Secure Server.', 'active', NULL, NULL, '2025-06-21 00:42:47', '2025-06-21 00:42:47'),
(2985, '9f34afcf-c1e1-416a-84c6-1069164ede1d', 1, 5, NULL, 'miscellaneous_facilities.no_monthly_or_yearly_fees', 'web', 'No Monthly Or Yearly Fees.', 'active', NULL, NULL, '2025-06-21 00:42:47', '2025-06-21 00:42:47'),
(2986, '9f34afcf-c2f6-43d4-9dca-c13576c7947f', 1, 5, NULL, 'miscellaneous_facilities.customer_support', 'web', '24/7 Customer Support', 'active', NULL, NULL, '2025-06-21 00:42:47', '2025-06-21 00:42:47'),
(2987, '9f34afcf-c40c-40e3-ba24-9261f4497b61', 1, 5, NULL, 'miscellaneous_facilities.multi_language_system', 'web', 'Multi Language System', 'active', NULL, NULL, '2025-06-21 00:42:47', '2025-06-21 00:42:47'),
(2988, '9f34afcf-c523-4562-8d39-698179502133', 1, 5, NULL, 'miscellaneous_facilities.admin_and_customer_has_separate_ui_and_login', 'web', 'Admin and Customer Has separate UI and Login', 'active', NULL, NULL, '2025-06-21 00:42:47', '2025-06-21 00:42:47'),
(2989, '9f34afcf-c648-4a68-a8e8-356cac5412f9', 1, 5, NULL, 'miscellaneous_facilities.email_and_sms_gateway_adding_for_marketing', 'web', 'Email and Sms gateway adding for marketing', 'active', NULL, NULL, '2025-06-21 00:42:47', '2025-06-21 00:42:47'),
(2990, '9f34afcf-c77c-4f57-92c5-95a00fac534c', 1, 5, NULL, 'miscellaneous_facilities.complete_hospital_management_solution', 'web', 'Complete Hospital Management Solution', 'active', NULL, NULL, '2025-06-21 00:42:47', '2025-06-21 00:42:47'),
(2991, '9f34afcf-c8a3-46b4-9cdc-685fa55b2ae2', 1, 5, NULL, 'miscellaneous_facilities.prescription_management_system', 'web', 'Prescription Management System', 'active', NULL, NULL, '2025-06-21 00:42:47', '2025-06-21 00:42:47'),
(2992, '9f34afcf-c9c2-4439-81be-52456b541362', 1, 5, NULL, 'miscellaneous_facilities.doctor_management_system', 'web', 'Doctor Management System', 'active', NULL, NULL, '2025-06-21 00:42:47', '2025-06-21 00:42:47'),
(2993, '9f34afcf-cadc-47be-a705-3984fd87ae85', 1, 5, NULL, 'miscellaneous_facilities.insurance_management_system', 'web', 'Insurance Management System', 'active', NULL, NULL, '2025-06-21 00:42:47', '2025-06-21 00:42:47'),
(2994, '9f34afcf-cc39-470a-9d9b-b59a29170603', 1, 5, NULL, 'miscellaneous_facilities.billing_management_system', 'web', 'Billing Management System', 'active', NULL, NULL, '2025-06-21 00:42:47', '2025-06-21 00:42:47'),
(2995, '9f34afcf-cd65-4950-abc8-5932b173a373', 1, 5, NULL, 'miscellaneous_facilities.role_based_permission_setup_system', 'web', 'Role Based Permission Setup System', 'active', NULL, NULL, '2025-06-21 00:42:47', '2025-06-21 00:42:47'),
(2996, '9f34afcf-ce8e-4c8f-aa96-87b9e2fc1616', 1, 5, NULL, 'miscellaneous_facilities.multiple_email_and_sms_gateway_added', 'web', 'Multiple Email and SMS gateway added', 'active', NULL, NULL, '2025-06-21 00:42:47', '2025-06-21 00:42:47'),
(2997, '9f34afcf-cfb1-4d59-8ffa-0ff0439d460f', 1, 5, NULL, 'miscellaneous_facilities.human_resource_system', 'web', 'Human Resource System', 'active', NULL, NULL, '2025-06-21 00:42:47', '2025-06-21 00:42:47'),
(2998, '9f34afcf-d0e5-49c5-afd0-99c397b0bdea', 1, 5, NULL, 'miscellaneous_facilities.complete_Bed_management_system', 'web', 'Complete Bed Management System', 'active', NULL, NULL, '2025-06-21 00:42:47', '2025-06-21 00:42:47'),
(2999, '9f34afcf-d1fb-4d0b-9d50-b2c98abff78d', 1, 5, NULL, 'miscellaneous_facilities.medication_and_visits_system', 'web', 'Medication and Visits System', 'active', NULL, NULL, '2025-06-21 00:42:47', '2025-06-21 00:42:47'),
(3000, '9f34afcf-d31a-4882-8a56-36bf3c33d9a6', 1, 5, NULL, 'miscellaneous_facilities.case_manager_management_system', 'web', 'Case Manager Management System', 'active', NULL, NULL, '2025-06-21 00:42:47', '2025-06-21 00:42:47'),
(3001, '9f34afcf-d433-4f9d-919a-38029b948575', 1, 5, NULL, 'miscellaneous_facilities.patient_separate_login_and_appointment_system', 'web', 'Patient Separate Login and Appointment System', 'active', NULL, NULL, '2025-06-21 00:42:47', '2025-06-21 00:42:47'),
(3002, '9f34afcf-d54e-4666-bf99-a6d52756a701', 1, 5, NULL, 'miscellaneous_facilities.hospital_enquiry_system', 'web', 'Hospital Enquiry System', 'active', NULL, NULL, '2025-06-21 00:42:47', '2025-06-21 00:42:47'),
(3003, '9f34afcf-d66f-4988-aab8-a0a0f07a4a46', 1, 5, NULL, 'miscellaneous_facilities.parmacy_management_system', 'web', 'Pharmacy Management System', 'active', NULL, NULL, '2025-06-21 00:42:47', '2025-06-21 00:42:47'),
(3004, '9f34afcf-d79f-462e-aac6-8d41344258a4', 1, 5, NULL, 'miscellaneous_facilities.appointment_management_system', 'web', 'Appointment Management System', 'active', NULL, NULL, '2025-06-21 00:42:47', '2025-06-21 00:42:47'),
(3005, '9f34afcf-d8bd-4ebb-a936-1f7233922a09', 1, 5, NULL, 'miscellaneous_facilities.investigation_reports', 'web', 'Investigation Reports', 'active', NULL, NULL, '2025-06-21 00:42:47', '2025-06-21 00:42:47'),
(3006, '9f34afcf-d9e2-4dee-95f0-f37a02205b93', 1, 5, NULL, 'footer.follow_us', 'web', 'FOLLOW US', 'active', NULL, NULL, '2025-06-21 00:42:47', '2025-06-21 00:42:47'),
(3007, '9f34afcf-daf6-4920-ac18-f1c4d1300dc0', 1, 5, NULL, 'footer.twitter', 'web', 'Twitter', 'active', NULL, NULL, '2025-06-21 00:42:47', '2025-06-21 00:42:47'),
(3008, '9f34afcf-dc1a-436f-a8bd-633cbecc64aa', 1, 5, NULL, 'footer.facebook', 'web', 'Facebook', 'active', NULL, NULL, '2025-06-21 00:42:47', '2025-06-21 00:42:47'),
(3009, '9f34afcf-dd37-4ae9-b603-d787d0054dc8', 1, 5, NULL, 'footer.linkedin', 'web', 'Linkedin', 'active', NULL, NULL, '2025-06-21 00:42:47', '2025-06-21 00:42:47'),
(3010, '9f34afcf-de53-4a90-a92e-0573c981afa4', 1, 5, NULL, 'footer.github', 'web', 'Github', 'active', NULL, NULL, '2025-06-21 00:42:47', '2025-06-21 00:42:47'),
(3011, '9f34afcf-df74-48c9-b900-294eb8f53435', 1, 5, NULL, 'footer.made_with_by_infyOm_technologies', 'web', 'Made with by InfyOm Technologies', 'active', NULL, NULL, '2025-06-21 00:42:47', '2025-06-21 00:42:47'),
(3012, '9f34afcf-e0a4-40fe-a7c8-1f93450d467e', 1, 5, NULL, 'footer.we_are_group', 'web', 'We are a group of creative nerds making awesome stuff for Web & Mobile. We just love to\n                contribute to open source technologies. We always try to build something which helps developers to\n                save their time. so they can spend a bit more time with their friends & family.', 'active', NULL, NULL, '2025-06-21 00:42:47', '2025-06-21 00:42:47'),
(3013, '9f34afcf-e1c6-45f2-893b-7d9199b36a01', 1, 5, NULL, 'footer.copyright', 'web', 'Copyright', 'active', NULL, NULL, '2025-06-21 00:42:47', '2025-06-21 00:42:47'),
(3014, '9f34afcf-e2e3-4f9d-9bff-40ba22567985', 1, 5, NULL, 'footer.all_rights_reserved', 'web', 'All rights reserved', 'active', NULL, NULL, '2025-06-21 00:42:47', '2025-06-21 00:42:47'),
(3015, '9f34afcf-ec23-4116-ada1-b5514e0475cd', 2, 1, NULL, 'failed', 'auth', 'بيانات الاعتماد هذه لا تتطابق مع سجلاتنا.', 'active', NULL, NULL, '2025-06-21 00:42:47', '2025-06-21 00:42:47'),
(3016, '9f34afcf-f026-409c-8bdc-dae0ba95edfa', 2, 1, NULL, 'throttle', 'auth', 'محاولات تسجيل دخول كثيرة. يرجى المحاولة مرة أخرى seconds: ثوانٍ.', 'active', NULL, NULL, '2025-06-21 00:42:47', '2025-06-21 00:42:47'),
(3017, '9f34afcf-f1eb-4f7b-b105-d15664e890b4', 2, 1, 2, 'save', 'auth', 'يحفظ', 'active', NULL, NULL, '2025-06-21 00:42:47', '2025-06-21 00:42:47'),
(3018, '9f34afcf-f3a5-4bcb-a985-fcf7d8df4fa9', 2, 1, 3, 'full_name', 'auth', 'الاسم الكامل', 'active', NULL, NULL, '2025-06-21 00:42:47', '2025-06-21 00:42:47'),
(3019, '9f34afcf-f53e-4da2-9123-27c51ecf6d85', 2, 1, 4, 'email', 'auth', 'بريد الالكتروني', 'active', NULL, NULL, '2025-06-21 00:42:47', '2025-06-21 00:42:47'),
(3020, '9f34afcf-f6eb-4314-94ea-63e9afb6e4c5', 2, 1, 1, 'password', 'auth', 'كلمه السر', 'active', NULL, NULL, '2025-06-21 00:42:47', '2025-06-21 00:42:47'),
(3021, '9f34afcf-f864-4ebe-9f9c-9ab8a87324cd', 2, 1, 5, 'confirm_password', 'auth', 'تأكيد كلمة المرور', 'active', NULL, NULL, '2025-06-21 00:42:47', '2025-06-21 00:42:47'),
(3022, '9f34afcf-f9f5-482d-af50-2c0f2e8fc998', 2, 1, 6, 'remember_me', 'auth', 'تذكرنى', 'active', NULL, NULL, '2025-06-21 00:42:47', '2025-06-21 00:42:47'),
(3023, '9f34afcf-fb68-4194-bdee-a023acb165dc', 2, 1, 7, 'sign_in', 'auth', 'تسجيل الدخول', 'active', NULL, NULL, '2025-06-21 00:42:47', '2025-06-21 00:42:47'),
(3024, '9f34afcf-fce2-4eb3-84ba-e9a755f4aeae', 2, 1, 8, 'sign_out', 'auth', 'خروج', 'active', NULL, NULL, '2025-06-21 00:42:47', '2025-06-21 00:42:47'),
(3025, '9f34afcf-fe64-47c5-b79c-06fe0c2b41ac', 2, 1, 9, 'register', 'auth', 'يسجل', 'active', NULL, NULL, '2025-06-21 00:42:47', '2025-06-21 00:42:47'),
(3026, '9f34afcf-ffe2-44a1-8aca-e46214290359', 2, 1, 11, 'login.title', 'auth', 'تسجيل الدخول لبدء الجلسة الخاصة بك', 'active', NULL, NULL, '2025-06-21 00:42:47', '2025-06-21 00:42:47'),
(3027, '9f34afd0-015a-44c3-942b-e405a859140b', 2, 1, 10, 'login.login', 'auth', 'تسجيل الدخول', 'active', NULL, NULL, '2025-06-21 00:42:47', '2025-06-21 00:42:47'),
(3028, '9f34afd0-02c6-4750-8417-c25048015355', 2, 1, 12, 'login.forgot_password', 'auth', 'هل نسيت كلمة السر', 'active', NULL, NULL, '2025-06-21 00:42:47', '2025-06-21 00:42:47'),
(3029, '9f34afd0-0454-47f7-871e-39abeed96fee', 2, 1, 13, 'login.register_membership', 'auth', 'تسجيل عضوية جديدة', 'active', NULL, NULL, '2025-06-21 00:42:47', '2025-06-21 00:42:47'),
(3030, '9f34afd0-05df-41df-bcd1-30872d14777c', 2, 1, 14, 'login.enter_email', 'auth', 'أدخل البريد الإلكتروني', 'active', NULL, NULL, '2025-06-21 00:42:47', '2025-06-21 00:42:47'),
(3031, '9f34afd0-0759-4bd7-9b8d-aca88dd9ab55', 2, 1, 15, 'login.enter_password', 'auth', 'أدخل كلمة المرور', 'active', NULL, NULL, '2025-06-21 00:42:47', '2025-06-21 00:42:47'),
(3032, '9f34afd0-08d0-4298-af21-b4aa48733ce5', 2, 1, 16, 'registration.hospital_registration', 'auth', 'التسجيل بالمستشفى', 'active', NULL, NULL, '2025-06-21 00:42:47', '2025-06-21 00:42:47'),
(3033, '9f34afd0-0c5b-4212-a969-5cdd29e030f9', 2, 1, NULL, 'registration.title', 'auth', 'تسجيل عضوية جديدة', 'active', NULL, NULL, '2025-06-21 00:42:47', '2025-06-21 00:42:47'),
(3034, '9f34afd0-0e03-4df4-a4df-370a0b00a579', 2, 1, 17, 'registration.already_user', 'auth', 'هل لديك حساب', 'active', NULL, NULL, '2025-06-21 00:42:47', '2025-06-21 00:42:47'),
(3035, '9f34afd0-0fa2-476d-b2ed-7fcf5a607c31', 2, 1, 18, 'registration.i_agree', 'auth', 'أوافق على', 'active', NULL, NULL, '2025-06-21 00:42:47', '2025-06-21 00:42:47'),
(3036, '9f34afd0-111d-4634-ac83-8d066a2a6a89', 2, 1, 19, 'registration.terms', 'auth', 'الشروط', 'active', NULL, NULL, '2025-06-21 00:42:47', '2025-06-21 00:42:47'),
(3037, '9f34afd0-1291-4ded-ba70-0975ec5b82e0', 2, 1, 20, 'registration.have_membership', 'auth', 'لدي عضوية بالفعل', 'active', NULL, NULL, '2025-06-21 00:42:47', '2025-06-21 00:42:47'),
(3038, '9f34afd0-1407-4f6a-9065-fd22d68ef99b', 2, 1, 21, 'registration.enter_hospital_name', 'auth', 'أدخل اسم المستشفى', 'active', NULL, NULL, '2025-06-21 00:42:47', '2025-06-21 00:42:47'),
(3039, '9f34afd0-157a-408f-a4ab-88d835c174e1', 2, 1, 22, 'registration.enter_username', 'auth', 'ادخل اسم المستخد,', 'active', NULL, NULL, '2025-06-21 00:42:47', '2025-06-21 00:42:47'),
(3040, '9f34afd0-16f1-4470-981d-1c51f6ad36c9', 2, 1, 23, 'registration.enter_password', 'auth', 'أدخل كلمة المرور', 'active', NULL, NULL, '2025-06-21 00:42:47', '2025-06-21 00:42:47'),
(3041, '9f34afd0-188f-43b2-a642-15f0e915ce7c', 2, 1, 24, 'registration.enter_confirm_password', 'auth', 'أدخل تأكيد كلمة المرور', 'active', NULL, NULL, '2025-06-21 00:42:47', '2025-06-21 00:42:47'),
(3042, '9f34afd0-1a12-414a-89ce-a2f4d5bdd7b7', 2, 1, 25, 'registration.registration', 'auth', 'التسجيل', 'active', NULL, NULL, '2025-06-21 00:42:47', '2025-06-21 00:42:47'),
(3043, '9f34afd0-1b8e-43e6-9410-6773ffec8cfb', 2, 1, 26, 'forgot_password.title', 'auth', 'أدخل البريد الإلكتروني لإعادة تعيين كلمة المرور', 'active', NULL, NULL, '2025-06-21 00:42:47', '2025-06-21 00:42:47'),
(3044, '9f34afd0-1d07-4d99-9794-cd0571639f62', 2, 1, 27, 'forgot_password.send_pwd_reset', 'auth', 'إرسال رابط إعادة تعيين كلمة السر', 'active', NULL, NULL, '2025-06-21 00:42:47', '2025-06-21 00:42:47'),
(3045, '9f34afd0-1e95-4d03-a17c-9afb8eac6a48', 2, 1, 28, 'forgot_password.enter_email', 'auth', 'أدخل البريد الإلكتروني', 'active', NULL, NULL, '2025-06-21 00:42:47', '2025-06-21 00:42:47'),
(3046, '9f34afd0-2014-4e32-b1eb-add88782280f', 2, 1, 29, 'reset_password.title', 'auth', 'اعد ضبط كلمه السر', 'active', NULL, NULL, '2025-06-21 00:42:47', '2025-06-21 00:42:47'),
(3047, '9f34afd0-218c-47db-a7bd-2de3969d003c', 2, 1, 30, 'reset_password.reset_pwd_btn', 'auth', 'إعادة تعيين كلمة المرور', 'active', NULL, NULL, '2025-06-21 00:42:47', '2025-06-21 00:42:47'),
(3048, '9f34afd0-244e-4dfd-9b28-be380d3fcfbf', 2, 1, 31, 'reset_password.already_reset', 'auth', 'بالفعل قمت بإعادة تعيين كلمة المرور الخاصة بك؟', 'active', NULL, NULL, '2025-06-21 00:42:47', '2025-06-21 00:42:47'),
(3049, '9f34afd0-25c6-4637-a759-7065f83d8445', 2, 1, 32, 'reset_password.password_reset', 'auth', 'إعادة تعيين كلمة المرور', 'active', NULL, NULL, '2025-06-21 00:42:47', '2025-06-21 00:42:47'),
(3050, '9f34afd0-2742-432a-90c9-92c38f79d1cd', 2, 1, 33, 'new_here', 'auth', 'جديد هنا؟', 'active', NULL, NULL, '2025-06-21 00:42:47', '2025-06-21 00:42:47'),
(3051, '9f34afd0-28c0-49e0-9443-b53299b3b52a', 2, 1, 34, 'create_an_account', 'auth', 'انشئ حساب', 'active', NULL, NULL, '2025-06-21 00:42:47', '2025-06-21 00:42:47'),
(3052, '9f34afd0-2a33-4781-b257-44a30dc7898e', 2, 1, 35, 'please_wait', 'auth', 'ارجوك انتظر...', 'active', NULL, NULL, '2025-06-21 00:42:47', '2025-06-21 00:42:47'),
(3053, '9f34afd0-2bad-495c-80d2-0d15c8d467d4', 2, 1, 36, 'submit', 'auth', 'إرسال', 'active', NULL, NULL, '2025-06-21 00:42:47', '2025-06-21 00:42:47'),
(3054, '9f34afd0-2d23-42b5-a87f-ef0497a9f3ba', 2, 1, 37, 'already_user', 'auth', 'بالفعل مستخدم؟', 'active', NULL, NULL, '2025-06-21 00:42:47', '2025-06-21 00:42:47'),
(3055, '9f34afd0-2e96-4f01-9259-29ca36220aa3', 2, 1, 38, 'hospital_name', 'auth', 'اسم المستشفى', 'active', NULL, NULL, '2025-06-21 00:42:47', '2025-06-21 00:42:47'),
(3056, '9f34afd0-300d-4d74-b2f1-26b71ab34f0f', 2, 1, 39, 'hospital_slug', 'auth', 'سبيكة مستشفى', 'active', NULL, NULL, '2025-06-21 00:42:47', '2025-06-21 00:42:47'),
(3057, '9f34afd0-3184-440f-9b78-4eb2019db7c5', 2, 1, 40, 'sent_verification_email', 'auth', 'تم إرسال ارتباط تحقق جديد إلى عنوان بريدك الإلكتروني', 'active', NULL, NULL, '2025-06-21 00:42:47', '2025-06-21 00:42:47'),
(3058, '9f34afd0-3301-4f8f-a603-3c6ceddedf42', 2, 1, 41, 'verify_email', 'auth', 'تحقق من عنوان بريدك الإلكتروني', 'active', NULL, NULL, '2025-06-21 00:42:47', '2025-06-21 00:42:47'),
(3059, '9f34afd0-3480-45a4-bc4e-f7432dc7c139', 2, 1, 42, 'check_email_before_verify', 'auth', 'قبل المتابعة ، يرجى التحقق من بريدك الإلكتروني بحثًا عن رابط التحقق. إذا لم تستلم البريد الإلكتروني', 'active', NULL, NULL, '2025-06-21 00:42:47', '2025-06-21 00:42:47'),
(3060, '9f34afd0-35fb-4edb-9528-7738347ac7e5', 2, 1, 43, 'request_another', 'auth', 'انقر هنا لطلب آخر', 'active', NULL, NULL, '2025-06-21 00:42:47', '2025-06-21 00:42:47'),
(3061, '9f34afd0-37b3-4750-9c79-d03e97d4eb8e', 2, 2, 44, 'select_time_slot', 'js', 'الرجاء تحديد الفترة الزمنية للموعد.', 'active', NULL, NULL, '2025-06-21 00:42:47', '2025-06-21 00:42:47'),
(3062, '9f34afd0-393c-4e2e-916e-02c1bd57049d', 2, 2, 45, 'please_select_doctor', 'js', 'الرجاء اختيار الطبيب', 'active', NULL, NULL, '2025-06-21 00:42:47', '2025-06-21 00:42:47'),
(3063, '9f34afd0-3ab6-4555-83dd-5ae93a810e7a', 2, 2, 46, 'sunday', 'js', 'الأحد', 'active', NULL, NULL, '2025-06-21 00:42:47', '2025-06-21 00:42:47'),
(3064, '9f34afd0-3c28-47d4-aff0-e10f2427a0bd', 2, 2, 47, 'monday', 'js', 'الأحد', 'active', NULL, NULL, '2025-06-21 00:42:47', '2025-06-21 00:42:47'),
(3065, '9f34afd0-3d9a-42dc-ac0e-f8b65b13de99', 2, 2, 48, 'tuesday', 'js', 'يوم الثلاثاء', 'active', NULL, NULL, '2025-06-21 00:42:47', '2025-06-21 00:42:47'),
(3066, '9f34afd0-3f0d-4bc1-aff5-640a92c7ba43', 2, 2, 49, 'wednesday', 'js', 'الأربعاء', 'active', NULL, NULL, '2025-06-21 00:42:47', '2025-06-21 00:42:47'),
(3067, '9f34afd0-409f-4c83-b8be-c4a368203d42', 2, 2, 50, 'thursday', 'js', 'يوم الخميس', 'active', NULL, NULL, '2025-06-21 00:42:47', '2025-06-21 00:42:47'),
(3068, '9f34afd0-4229-4ac3-82d3-2a20d9cea3e0', 2, 2, 51, 'friday', 'js', 'جمعة', 'active', NULL, NULL, '2025-06-21 00:42:47', '2025-06-21 00:42:47'),
(3069, '9f34afd0-43a5-4b1f-a3fe-2347e633306e', 2, 2, 52, 'saturday', 'js', 'السبت', 'active', NULL, NULL, '2025-06-21 00:42:47', '2025-06-21 00:42:47'),
(3070, '9f34afd0-4526-4dd1-9167-dc3a6328bc53', 2, 2, 53, 'doctor_schedule_not_available_on_this_date', 'js', 'جدول الطبيب غير متاح هذا التاريخ.', 'active', NULL, NULL, '2025-06-21 00:42:47', '2025-06-21 00:42:47'),
(3071, '9f34afd0-46bc-4153-8ac8-0b1c81932471', 2, 2, 54, 'custom', 'js', 'مخصص', 'active', NULL, NULL, '2025-06-21 00:42:47', '2025-06-21 00:42:47'),
(3072, '9f34afd0-4848-4b77-a60e-39450560ac35', 2, 2, 55, 'apply', 'js', 'يتقدم', 'active', NULL, NULL, '2025-06-21 00:42:47', '2025-06-21 00:42:47'),
(3073, '9f34afd0-49c1-4aec-a393-6332673513ab', 2, 2, 56, 'from', 'js', 'من', 'active', NULL, NULL, '2025-06-21 00:42:47', '2025-06-21 00:42:47'),
(3074, '9f34afd0-4b31-4b06-988d-1a5b7c9257f1', 2, 2, 57, 'to', 'js', 'ل', 'active', NULL, NULL, '2025-06-21 00:42:47', '2025-06-21 00:42:47'),
(3075, '9f34afd0-4ca9-4bf9-bfa7-83c15e127edd', 2, 2, 58, 'jan', 'js', 'يناير', 'active', NULL, NULL, '2025-06-21 00:42:47', '2025-06-21 00:42:47'),
(3076, '9f34afd0-4e14-4282-ab75-546dd4f366d5', 2, 2, 59, 'feb', 'js', 'شهر فبراير', 'active', NULL, NULL, '2025-06-21 00:42:47', '2025-06-21 00:42:47'),
(3077, '9f34afd0-4f93-457e-85b1-05e56a203d8d', 2, 2, 60, 'mar', 'js', 'يمشي', 'active', NULL, NULL, '2025-06-21 00:42:47', '2025-06-21 00:42:47'),
(3078, '9f34afd0-5109-4043-b825-c16fa570eeee', 2, 2, 61, 'apr', 'js', 'أبريل', 'active', NULL, NULL, '2025-06-21 00:42:47', '2025-06-21 00:42:47'),
(3079, '9f34afd0-5285-4fc0-95b3-7cb6bb9431f6', 2, 2, 62, 'may', 'js', 'يمكن', 'active', NULL, NULL, '2025-06-21 00:42:47', '2025-06-21 00:42:47'),
(3080, '9f34afd0-53f5-4e6c-bac3-9f45f3fd48a7', 2, 2, 63, 'jun', 'js', 'يونيو', 'active', NULL, NULL, '2025-06-21 00:42:47', '2025-06-21 00:42:47'),
(3081, '9f34afd0-5571-454d-848a-ee9830273e24', 2, 2, 64, 'jul', 'js', 'يوليو', 'active', NULL, NULL, '2025-06-21 00:42:47', '2025-06-21 00:42:47'),
(3082, '9f34afd0-56f1-4097-ad8b-70e73addfc85', 2, 2, 65, 'aug', 'js', 'أغسطس', 'active', NULL, NULL, '2025-06-21 00:42:47', '2025-06-21 00:42:47'),
(3083, '9f34afd0-588d-43d8-b6a8-579908abc15d', 2, 2, 66, 'sep', 'js', 'سبتمبر', 'active', NULL, NULL, '2025-06-21 00:42:47', '2025-06-21 00:42:47'),
(3084, '9f34afd0-5a07-45d8-9f8e-abedf4c581ad', 2, 2, 67, 'oct', 'js', 'اكتوبر', 'active', NULL, NULL, '2025-06-21 00:42:47', '2025-06-21 00:42:47'),
(3085, '9f34afd0-5b89-4c7a-883a-5153a8dfdd5e', 2, 2, 68, 'nov', 'js', 'شهر نوفمبر', 'active', NULL, NULL, '2025-06-21 00:42:47', '2025-06-21 00:42:47'),
(3086, '9f34afd0-5d10-482e-888b-d56cfa1afb52', 2, 2, 69, 'dec', 'js', 'ديسمبر', 'active', NULL, NULL, '2025-06-21 00:42:47', '2025-06-21 00:42:47'),
(3087, '9f34afd0-5e88-4fa6-b36b-809e5448ef21', 2, 2, 70, 'sun', 'js', 'شمس', 'active', NULL, NULL, '2025-06-21 00:42:47', '2025-06-21 00:42:47'),
(3088, '9f34afd0-5ffa-41f1-9e2c-f9811d714685', 2, 2, 71, 'mon', 'js', 'مون', 'active', NULL, NULL, '2025-06-21 00:42:47', '2025-06-21 00:42:47'),
(3089, '9f34afd0-619e-44b6-8d3e-4595e5e47f68', 2, 2, 72, 'tue', 'js', 'الثلاثاء', 'active', NULL, NULL, '2025-06-21 00:42:47', '2025-06-21 00:42:47'),
(3090, '9f34afd0-6325-4330-b4e4-fc2d3aa05e6a', 2, 2, 73, 'wed', 'js', 'تزوج', 'active', NULL, NULL, '2025-06-21 00:42:47', '2025-06-21 00:42:47'),
(3091, '9f34afd0-64a6-4443-8ebc-ca749cc3b83e', 2, 2, 74, 'thu', 'js', 'الخميس', 'active', NULL, NULL, '2025-06-21 00:42:47', '2025-06-21 00:42:47'),
(3092, '9f34afd0-661c-4979-bd6c-6c7b99f2c7b9', 2, 2, 75, 'fri', 'js', 'الجمعة', 'active', NULL, NULL, '2025-06-21 00:42:47', '2025-06-21 00:42:47'),
(3093, '9f34afd0-67b6-4989-b28f-de18d8df0c24', 2, 2, 76, 'sat', 'js', 'قعد', 'active', NULL, NULL, '2025-06-21 00:42:47', '2025-06-21 00:42:47'),
(3094, '9f34afd0-6964-427a-96cc-4d5f43663eb8', 2, 2, 77, 'today', 'js', 'اليوم', 'active', NULL, NULL, '2025-06-21 00:42:47', '2025-06-21 00:42:47'),
(3095, '9f34afd0-6c65-4879-a14a-d944733dee4d', 2, 2, 78, 'yesterday', 'js', 'أمس', 'active', NULL, NULL, '2025-06-21 00:42:47', '2025-06-21 00:42:47'),
(3096, '9f34afd0-6e50-44bd-aeb6-fde292dd723c', 2, 2, 79, 'this_week', 'js', 'هذا الاسبوع', 'active', NULL, NULL, '2025-06-21 00:42:47', '2025-06-21 00:42:47'),
(3097, '9f34afd0-6ff4-4f5f-b7b6-eee0e83feb24', 2, 2, 80, 'last_7_days', 'js', 'اخر 7 ايام', 'active', NULL, NULL, '2025-06-21 00:42:47', '2025-06-21 00:42:47'),
(3098, '9f34afd0-7173-46ae-bd68-248e53d77792', 2, 2, 81, 'last_30_days', 'js', 'آخر 30 يومًا', 'active', NULL, NULL, '2025-06-21 00:42:47', '2025-06-21 00:42:47'),
(3099, '9f34afd0-72ed-442c-8796-564a9b343b34', 2, 2, 82, 'this_month', 'js', 'هذا الشهر', 'active', NULL, NULL, '2025-06-21 00:42:47', '2025-06-21 00:42:47'),
(3100, '9f34afd0-7470-43b5-bc72-4a5c89ea3d5c', 2, 2, 83, 'last_month', 'js', 'الشهر الماضي', 'active', NULL, NULL, '2025-06-21 00:42:47', '2025-06-21 00:42:47'),
(3101, '9f34afd0-75f4-4e83-8d8a-17528d580594', 2, 2, 84, 'appointment', 'js', 'ميعاد', 'active', NULL, NULL, '2025-06-21 00:42:47', '2025-06-21 00:42:47'),
(3102, '9f34afd0-777a-4c8c-b936-4f82a657b2ab', 2, 2, 85, 'status', 'js', 'حالة', 'active', NULL, NULL, '2025-06-21 00:42:47', '2025-06-21 00:42:47'),
(3103, '9f34afd0-78fa-41b6-86a5-e14cb7b436e6', 2, 2, 86, 'are_you_sure_want_to_cancel', 'js', 'هل أنت متأكد أنك تريد الإلغاء', 'active', NULL, NULL, '2025-06-21 00:42:47', '2025-06-21 00:42:47'),
(3104, '9f34afd0-7a86-4ea0-8c0b-3894689b7a52', 2, 2, 87, 'canceled', 'js', 'ملغي', 'active', NULL, NULL, '2025-06-21 00:42:47', '2025-06-21 00:42:47'),
(3105, '9f34afd0-7c17-4f48-9045-e77c8b86c301', 2, 2, 88, 'appointment_cancel', 'js', 'تم إلغاء الموعد بنجاح.', 'active', NULL, NULL, '2025-06-21 00:42:47', '2025-06-21 00:42:47'),
(3106, '9f34afd0-7d9c-4612-bf2e-0ab52056b1ee', 2, 2, 89, 'change_status', 'js', 'تغيير الوضع', 'active', NULL, NULL, '2025-06-21 00:42:47', '2025-06-21 00:42:47'),
(3107, '9f34afd0-7f16-4e2c-bb8b-69b9d97a122e', 2, 2, 90, 'are_you_sure_want_to_change', 'js', 'هل أنت متأكد أنك تريد التغيير', 'active', NULL, NULL, '2025-06-21 00:42:47', '2025-06-21 00:42:47'),
(3108, '9f34afd0-808b-4803-87f0-eee1e69d7169', 2, 2, 91, 'changed_appointment', 'js', 'تم تغيير الموعد', 'active', NULL, NULL, '2025-06-21 00:42:47', '2025-06-21 00:42:47'),
(3109, '9f34afd0-820a-4dc1-99c1-16013e5e99a4', 2, 2, 92, 'has_been_changed', 'js', 'تغير.', 'active', NULL, NULL, '2025-06-21 00:42:47', '2025-06-21 00:42:47'),
(3110, '9f34afd0-84b9-4266-8a0d-e3c97aecd9b6', 2, 2, 93, 'department', 'js', 'قسم', 'active', NULL, NULL, '2025-06-21 00:42:47', '2025-06-21 00:42:47'),
(3111, '9f34afd0-8638-4f82-a0ac-19571a6a401f', 2, 2, 94, 'select_doctor', 'js', 'اختر دكتور', 'active', NULL, NULL, '2025-06-21 00:42:47', '2025-06-21 00:42:47'),
(3112, '9f34afd0-87b9-46cd-b81c-54d678d74df8', 2, 2, 95, 'select_appointment_date', 'js', 'الرجاء تحديد تاريخ الموعد.', 'active', NULL, NULL, '2025-06-21 00:42:47', '2025-06-21 00:42:47'),
(3113, '9f34afd0-893f-454d-aa81-fbbb459d8a93', 2, 2, 96, 'cancel', 'js', 'يلغي', 'active', NULL, NULL, '2025-06-21 00:42:47', '2025-06-21 00:42:47'),
(3114, '9f34afd0-8aeb-4b37-bfb8-8c66cfe32aa4', 2, 2, 97, 'select_ipd_patient', 'js', 'حدد مريض IPD', 'active', NULL, NULL, '2025-06-21 00:42:47', '2025-06-21 00:42:47'),
(3115, '9f34afd0-8c78-4911-a515-32f22cae9e52', 2, 2, 98, 'no_ipd_patient_found', 'js', 'لم يتم العثور على مريض IPD', 'active', NULL, NULL, '2025-06-21 00:42:47', '2025-06-21 00:42:47'),
(3116, '9f34afd0-8df7-4bca-9b2e-c4b3b368a4b1', 2, 2, 99, 'select_bed_type', 'js', 'حدد نوع السرير', 'active', NULL, NULL, '2025-06-21 00:42:47', '2025-06-21 00:42:47'),
(3117, '9f34afd0-8f82-4866-92e1-7b8a61ee5688', 2, 2, 100, 'are_u_sure', 'js', 'هل أنت متأكد؟', 'active', NULL, NULL, '2025-06-21 00:42:47', '2025-06-21 00:42:47'),
(3118, '9f34afd0-9102-4b2f-a377-727a3e416ba1', 2, 2, 101, 'u_want_to_complete_this_payment', 'js', 'تريد إكمال هذه الدفعة!', 'active', NULL, NULL, '2025-06-21 00:42:47', '2025-06-21 00:42:47'),
(3119, '9f34afd0-9292-477c-b97b-edd9d94bd1ed', 2, 2, 102, 'select_medicine', 'js', 'اختر الطب', 'active', NULL, NULL, '2025-06-21 00:42:47', '2025-06-21 00:42:47'),
(3120, '9f34afd0-9425-4602-a226-b296c6f5ba97', 2, 2, 103, 'select_charge_type', 'js', 'حدد نوع الفئة', 'active', NULL, NULL, '2025-06-21 00:42:47', '2025-06-21 00:42:47'),
(3121, '9f34afd0-95cd-4a2d-912d-9c4ef837f34b', 2, 2, 104, 'select_charge_category', 'js', 'حدد فئة الشحن', 'active', NULL, NULL, '2025-06-21 00:42:47', '2025-06-21 00:42:47'),
(3122, '9f34afd0-975a-4c82-98c6-2722609e6093', 2, 2, 105, 'currency', 'js', 'عملة', 'active', NULL, NULL, '2025-06-21 00:42:47', '2025-06-21 00:42:47'),
(3123, '9f34afd0-98d8-422e-b4a6-a291765d2d01', 2, 2, 106, 'notification_read', 'js', 'تمت قراءة الإشعار بنجاح.', 'active', NULL, NULL, '2025-06-21 00:42:47', '2025-06-21 00:42:47'),
(3124, '9f34afd0-9a64-4d48-bb99-0d74cef34d2d', 2, 2, 107, 'all_notification_read', 'js', 'تمت قراءة كافة الإخطارات بنجاح.', 'active', NULL, NULL, '2025-06-21 00:42:47', '2025-06-21 00:42:47'),
(3125, '9f34afd0-9bea-406e-b8d0-a3b8d7a09c36', 2, 2, 108, 'invalid_number', 'js', 'رقم غير صالح', 'active', NULL, NULL, '2025-06-21 00:42:47', '2025-06-21 00:42:47'),
(3126, '9f34afd0-9d86-4c33-8540-4cce5eb61f4a', 2, 2, 109, 'invalid_country_code', 'js', 'رمز البلد غير صالح', 'active', NULL, NULL, '2025-06-21 00:42:48', '2025-06-21 00:42:48'),
(3127, '9f34afd0-9efe-45db-b9b9-2c82c803c9cd', 2, 2, 110, 'too_short', 'js', 'قصير جدا', 'active', NULL, NULL, '2025-06-21 00:42:48', '2025-06-21 00:42:48'),
(3128, '9f34afd0-a077-4cc9-813b-4facafe87f24', 2, 2, 111, 'too_long', 'js', 'طويل جدا', 'active', NULL, NULL, '2025-06-21 00:42:48', '2025-06-21 00:42:48'),
(3129, '9f34afd0-a1ff-4fba-a484-b1eb2a0c3a59', 2, 2, 112, 'holiday', 'js', 'عطلة', 'active', NULL, NULL, '2025-06-21 00:42:48', '2025-06-21 00:42:48'),
(3130, '9f34afd0-a394-49de-94a0-0c92a1554274', 2, 2, 113, 'please_enter_valid_facebook_url', 'js', 'الرجاء إدخال عنوان URL صالح للفيسبوك', 'active', NULL, NULL, '2025-06-21 00:42:48', '2025-06-21 00:42:48'),
(3131, '9f34afd0-a526-4e18-ba2e-4c9febed69c1', 2, 2, 114, 'please_enter_valid_twitter_url', 'js', 'الرجاء إدخال عنوان URL صالح لتويتر', 'active', NULL, NULL, '2025-06-21 00:42:48', '2025-06-21 00:42:48'),
(3132, '9f34afd0-a6c9-4d80-b7da-989d6f9d71fa', 2, 2, 115, 'please_enter_valid_Instagram_url', 'js', 'الرجاء إدخال عنوان URL صالح لـ Instagram', 'active', NULL, NULL, '2025-06-21 00:42:48', '2025-06-21 00:42:48'),
(3133, '9f34afd0-a865-432c-aac5-07b918d34d38', 2, 2, 116, 'please_enter_valid_linkedin_url', 'js', 'الرجاء إدخال عنوان URL صالح لـ LinkedIn', 'active', NULL, NULL, '2025-06-21 00:42:48', '2025-06-21 00:42:48'),
(3134, '9f34afd0-a9e3-42c8-a5c0-99160dd0d815', 2, 2, 117, 'document_file_size', 'js', 'يجب أن يكون المستند ملفًا من النوع: jpeg، jpg، png، pdf، doc، docx.، mp3، mp4', 'active', NULL, NULL, '2025-06-21 00:42:48', '2025-06-21 00:42:48'),
(3135, '9f34afd0-ab6b-429d-967f-a6a6c6f4108a', 2, 2, 118, 'paid', 'js', 'مدفوع', 'active', NULL, NULL, '2025-06-21 00:42:48', '2025-06-21 00:42:48'),
(3136, '9f34afd0-acef-45c0-96df-a8a9a8760643', 2, 2, 119, 'unpaid', 'js', 'غير مدفوعة الأجر', 'active', NULL, NULL, '2025-06-21 00:42:48', '2025-06-21 00:42:48'),
(3137, '9f34afd0-ae9a-41de-9dee-4105892089cd', 2, 2, 120, 'deduction_not_greater_than_salary', 'js', 'لا يمكن أن تكون الاستقطاعات أكبر من الراتب الأساسي + العلاوة', 'active', NULL, NULL, '2025-06-21 00:42:48', '2025-06-21 00:42:48'),
(3138, '9f34afd0-b047-4146-9be7-5dbe9d95d7d7', 2, 2, 121, 'select_employee', 'js', 'حدد الموظف', 'active', NULL, NULL, '2025-06-21 00:42:48', '2025-06-21 00:42:48'),
(3139, '9f34afd0-b1df-4ffd-bb01-45a9dbef1509', 2, 2, 122, 'terms_conditions', 'js', 'البنود و الظروف', 'active', NULL, NULL, '2025-06-21 00:42:48', '2025-06-21 00:42:48'),
(3140, '9f34afd0-b3a0-4a64-94bf-b97917065b5f', 2, 2, 123, 'privacy_policy', 'js', 'سياسة الخصوصية', 'active', NULL, NULL, '2025-06-21 00:42:48', '2025-06-21 00:42:48'),
(3141, '9f34afd0-b549-4c41-979a-bc71a9182bfd', 2, 2, 124, 'terms_condition_required', 'js', 'الشروط والأحكام مطلوبة.', 'active', NULL, NULL, '2025-06-21 00:42:48', '2025-06-21 00:42:48'),
(3142, '9f34afd0-b6e0-47e6-b45e-37d732b05ef0', 2, 2, 125, 'image_must_be', 'js', 'يجب أن تكون الصورة ملفًا من النوع: jpg، jpeg، png.', 'active', NULL, NULL, '2025-06-21 00:42:48', '2025-06-21 00:42:48'),
(3143, '9f34afd0-b86f-46b7-ba38-0423b1d9e28f', 2, 2, 126, 'field_not_contain_white_space', 'js', 'لا يحتوي الحقل على مساحة بيضاء فقط', 'active', NULL, NULL, '2025-06-21 00:42:48', '2025-06-21 00:42:48'),
(3144, '9f34afd0-ba2b-49f7-afc8-49dee42591a6', 2, 2, 127, 'home_page_experience', 'js', 'تجربة الصفحة الرئيسية', 'active', NULL, NULL, '2025-06-21 00:42:48', '2025-06-21 00:42:48'),
(3145, '9f34afd0-bbca-4f72-84af-051e0b63c2fa', 2, 2, 128, 'home_page_title', 'js', 'عنوان الصفحة الرئيسية', 'active', NULL, NULL, '2025-06-21 00:42:48', '2025-06-21 00:42:48'),
(3146, '9f34afd0-bd59-4939-9d52-479f653e117c', 2, 2, 129, 'home_page_description', 'js', 'وصف الصفحة الرئيسية', 'active', NULL, NULL, '2025-06-21 00:42:48', '2025-06-21 00:42:48'),
(3147, '9f34afd0-bf11-46da-9a31-1094a270b44d', 2, 2, 130, 'home_page_box_title', 'js', 'عنوان مربع الصفحة الرئيسية', 'active', NULL, NULL, '2025-06-21 00:42:48', '2025-06-21 00:42:48'),
(3148, '9f34afd0-c0a7-4a3c-a0cf-9cc8b088094c', 2, 2, 131, 'home_page_box_description', 'js', 'وصف مربع الصفحة الرئيسية', 'active', NULL, NULL, '2025-06-21 00:42:48', '2025-06-21 00:42:48'),
(3149, '9f34afd0-c237-46b8-b177-9ed7eb9b91c3', 2, 2, 132, 'home_page_certified_doctor_text', 'js', 'الصفحة الرئيسية نص طبيب معتمد', 'active', NULL, NULL, '2025-06-21 00:42:48', '2025-06-21 00:42:48'),
(3150, '9f34afd0-c3c9-4ede-8780-700c09b255ca', 2, 2, 133, 'home_page_certified_doctor_title', 'js', 'الصفحة الرئيسية عنوان الطبيب المعتمد', 'active', NULL, NULL, '2025-06-21 00:42:48', '2025-06-21 00:42:48'),
(3151, '9f34afd0-c55f-4956-b3ed-abd848a3de84', 2, 2, 134, 'home_page_certified_doctor_description', 'js', 'الصفحة الرئيسية وصف الطبيب المعتمد', 'active', NULL, NULL, '2025-06-21 00:42:48', '2025-06-21 00:42:48'),
(3152, '9f34afd0-c6e4-4d06-a0d5-d7cec9693cd6', 2, 2, 135, 'home_page_certified_box_title', 'js', 'الصفحة الرئيسية عنوان الصندوق المعتمد', 'active', NULL, NULL, '2025-06-21 00:42:48', '2025-06-21 00:42:48'),
(3153, '9f34afd0-c877-49b7-9878-31c82f602db7', 2, 2, 136, 'home_page_certified_box_description', 'js', 'الصفحة الرئيسية وصف الصندوق المعتمد', 'active', NULL, NULL, '2025-06-21 00:42:48', '2025-06-21 00:42:48'),
(3154, '9f34afd0-ca1b-43ef-a6fa-0e90e6a83feb', 2, 2, 137, 'home_page_step_1_title', 'js', 'الصفحة الرئيسية الخطوة 1 العنوان', 'active', NULL, NULL, '2025-06-21 00:42:48', '2025-06-21 00:42:48'),
(3155, '9f34afd0-cbb0-472d-8d73-31d0f2f2af51', 2, 2, 138, 'home_page_step_1_description', 'js', 'الصفحة الرئيسية وصف الخطوة 1', 'active', NULL, NULL, '2025-06-21 00:42:48', '2025-06-21 00:42:48'),
(3156, '9f34afd0-cd4e-41a2-ac03-8f2fba43fd52', 2, 2, 139, 'home_page_step_2_title', 'js', 'الصفحة الرئيسية الخطوة 2 العنوان', 'active', NULL, NULL, '2025-06-21 00:42:48', '2025-06-21 00:42:48'),
(3157, '9f34afd0-ceea-4bf9-af43-7ec4590142ac', 2, 2, 140, 'home_page_step_2_description', 'js', 'الصفحة الرئيسية الخطوة 2 الوصف', 'active', NULL, NULL, '2025-06-21 00:42:48', '2025-06-21 00:42:48'),
(3158, '9f34afd0-d086-485c-b357-76bdd612e988', 2, 2, 141, 'home_page_step_3_title', 'js', 'الصفحة الرئيسية الخطوة 3 العنوان', 'active', NULL, NULL, '2025-06-21 00:42:48', '2025-06-21 00:42:48'),
(3159, '9f34afd0-d21a-4b02-90bc-45542caf9365', 2, 2, 142, 'home_page_step_3_description', 'js', 'الصفحة الرئيسية الخطوة 3 الوصف', 'active', NULL, NULL, '2025-06-21 00:42:48', '2025-06-21 00:42:48'),
(3160, '9f34afd0-d3ab-41c3-a249-b90bfd3ec10b', 2, 2, 143, 'home_page_step_4_title', 'js', 'الصفحة الرئيسية الخطوة 4 العنوان', 'active', NULL, NULL, '2025-06-21 00:42:48', '2025-06-21 00:42:48'),
(3161, '9f34afd0-d53a-4ab7-bbd1-177a6282da2f', 2, 2, 144, 'home_page_step_4_description', 'js', 'الصفحة الرئيسية وصف الخطوة 4', 'active', NULL, NULL, '2025-06-21 00:42:48', '2025-06-21 00:42:48'),
(3162, '9f34afd0-d6d5-4db1-9e3f-018c80f6359b', 2, 2, 145, 'about_us_title', 'js', 'عنوان', 'active', NULL, NULL, '2025-06-21 00:42:48', '2025-06-21 00:42:48'),
(3163, '9f34afd0-d86f-4026-ae3f-ab448b185ee3', 2, 2, 146, 'about_us_description', 'js', 'وصف', 'active', NULL, NULL, '2025-06-21 00:42:48', '2025-06-21 00:42:48'),
(3164, '9f34afd0-da06-42e5-88fe-31f5fbf6fd2a', 2, 2, 147, 'about_us_mission', 'js', 'مهمة', 'active', NULL, NULL, '2025-06-21 00:42:48', '2025-06-21 00:42:48'),
(3165, '9f34afd0-dbb3-4c1f-b2e2-916b6814a181', 2, 2, 148, 'warning', 'js', 'تحذير !', 'active', NULL, NULL, '2025-06-21 00:42:48', '2025-06-21 00:42:48'),
(3166, '9f34afd0-dd67-428a-8bd9-02b27e48b6bc', 2, 2, 149, 'document_must_be_file_type', 'js', 'يجب أن يكون المستند ملفًا من النوع: jpeg، jpg، png، pdf، doc، docx.', 'active', NULL, NULL, '2025-06-21 00:42:48', '2025-06-21 00:42:48'),
(3167, '9f34afd0-df08-4929-867a-8d6486cb6a6e', 2, 2, 150, 'sending', 'js', 'إرسال...', 'active', NULL, NULL, '2025-06-21 00:42:48', '2025-06-21 00:42:48'),
(3168, '9f34afd0-e0a0-49dd-bfe2-36a15f8f39d0', 2, 2, 151, 'send_mail', 'js', 'ارسل بريد', 'active', NULL, NULL, '2025-06-21 00:42:48', '2025-06-21 00:42:48'),
(3169, '9f34afd0-e237-4be9-849f-b8a37f18a18a', 2, 2, 152, 'select_account', 'js', 'حدد حساب', 'active', NULL, NULL, '2025-06-21 00:42:48', '2025-06-21 00:42:48'),
(3170, '9f34afd0-e3f9-478a-b335-1ec2b899fad7', 2, 2, 153, 'choose_case', 'js', 'اختر الحالة', 'active', NULL, NULL, '2025-06-21 00:42:48', '2025-06-21 00:42:48'),
(3171, '9f34afd0-e593-4ad3-9fbd-515f9112ba0b', 2, 2, 154, 'select_code', 'js', 'حدد الرمز', 'active', NULL, NULL, '2025-06-21 00:42:48', '2025-06-21 00:42:48'),
(3172, '9f34afd0-e86b-4237-a507-702789f996fe', 2, 2, 155, 'choose_bed', 'js', 'اختر السرير', 'active', NULL, NULL, '2025-06-21 00:42:48', '2025-06-21 00:42:48'),
(3173, '9f34afd0-ea50-4ba9-975c-cd5c6336a6a6', 2, 2, 156, 'your_payment_failed', 'js', 'فشل الدفع الخاص بك.', 'active', NULL, NULL, '2025-06-21 00:42:48', '2025-06-21 00:42:48'),
(3174, '9f34afd0-ebf4-407a-a34a-9c655c7c84df', 2, 2, 157, 'has_been_deleted', 'js', 'قد تم حذف.', 'active', NULL, NULL, '2025-06-21 00:42:48', '2025-06-21 00:42:48'),
(3175, '9f34afd0-ed97-4cd6-acde-d65cfed5f918', 2, 2, 158, 'available_quantity', 'js', 'الكمية المتوفرة', 'active', NULL, NULL, '2025-06-21 00:42:48', '2025-06-21 00:42:48'),
(3176, '9f34afd0-ef4c-4b9c-888f-2fc180b692e0', 2, 2, 159, 'medicine_required', 'js', 'مطلوب مجال الطب.', 'active', NULL, NULL, '2025-06-21 00:42:48', '2025-06-21 00:42:48'),
(3177, '9f34afd0-f0ef-475e-a015-ba4bffb3fc47', 2, 2, 160, 'are_you_sure_want_to_delete_this', 'js', 'هل تريد بالتأكيد حذف هذا', 'active', NULL, NULL, '2025-06-21 00:42:48', '2025-06-21 00:42:48'),
(3178, '9f34afd0-f293-4d03-be5f-d765dc99cc14', 2, 2, 161, 'ipd_timeline', 'js', 'IPD الجدول الزمني', 'active', NULL, NULL, '2025-06-21 00:42:48', '2025-06-21 00:42:48'),
(3179, '9f34afd0-f42f-4156-974c-100c11dafa7c', 2, 2, 162, 'deleted', 'js', 'تم الحذف', 'active', NULL, NULL, '2025-06-21 00:42:48', '2025-06-21 00:42:48'),
(3180, '9f34afd0-f5c0-4bdd-bb59-8dc717b971e5', 2, 2, 163, 'select_user', 'js', 'اختر المستخدم', 'active', NULL, NULL, '2025-06-21 00:42:48', '2025-06-21 00:42:48'),
(3181, '9f34afd0-f764-4258-953e-d5227ef1139d', 2, 2, 164, 'select_item', 'js', 'حدد العنصر', 'active', NULL, NULL, '2025-06-21 00:42:48', '2025-06-21 00:42:48'),
(3182, '9f34afd0-f8f7-445a-8527-971f12e9c4df', 2, 2, 165, 'qty_cannot_be_zero', 'js', 'لا يمكن أن تكون الكمية صفراً.', 'active', NULL, NULL, '2025-06-21 00:42:48', '2025-06-21 00:42:48'),
(3183, '9f34afd0-fa96-4da5-a927-b6272ac4dde2', 2, 2, 166, 'qty_must_be_less_than_available_qty', 'js', 'يجب أن تكون الكمية أقل من الكمية المتوفرة.', 'active', NULL, NULL, '2025-06-21 00:42:48', '2025-06-21 00:42:48');
INSERT INTO `ltu_phrases` (`id`, `uuid`, `translation_id`, `translation_file_id`, `phrase_id`, `key`, `group`, `value`, `status`, `parameters`, `note`, `created_at`, `updated_at`) VALUES
(3184, '9f34afd0-fc57-490c-a659-75b34508d094', 2, 2, 167, 'are_you_sure_want_to_return_this_item', 'js', 'هل أنت متأكد من أنك تريد إرجاع هذا العنصر', 'active', NULL, NULL, '2025-06-21 00:42:48', '2025-06-21 00:42:48'),
(3185, '9f34afd0-fe14-4363-90cc-2dc31bd8e5ba', 2, 2, 168, 'item_returned', 'js', 'هل أنت متأكد من أنك تريد إرجاع هذا العنصر', 'active', NULL, NULL, '2025-06-21 00:42:48', '2025-06-21 00:42:48'),
(3186, '9f34afd0-ffb7-4ff3-836d-9c40d4c0eb9b', 2, 2, 169, 'select_type_number', 'js', 'حدد رقم النوع', 'active', NULL, NULL, '2025-06-21 00:42:48', '2025-06-21 00:42:48'),
(3187, '9f34afd1-0152-467e-8b29-1df5ae76a890', 2, 2, 170, 'lunch_break', 'js', 'استراحة', 'active', NULL, NULL, '2025-06-21 00:42:48', '2025-06-21 00:42:48'),
(3188, '9f34afd1-02eb-485f-96f5-4c14ca618442', 2, 2, 171, 'break_time_greater_than_zero', 'js', 'يجب أن يكون وقت الاستراحة أكبر من الصفر', 'active', NULL, NULL, '2025-06-21 00:42:48', '2025-06-21 00:42:48'),
(3189, '9f34afd1-05bb-407f-8b1d-761bc2da5bd0', 2, 2, 172, 'break_to_time_greater_than_zero', 'js', 'يجب أن يكون وقت الاستراحة أكبر من الصفر', 'active', NULL, NULL, '2025-06-21 00:42:48', '2025-06-21 00:42:48'),
(3190, '9f34afd1-075f-4ab8-950b-4df05f0f9dfe', 2, 2, 173, 'break_to_time_greater_than_from_time', 'js', 'يجب أن يكون وقت الاستراحة أكبر من وقت الاستراحة.', 'active', NULL, NULL, '2025-06-21 00:42:48', '2025-06-21 00:42:48'),
(3191, '9f34afd1-0907-4794-878d-54d91833fea4', 2, 2, 174, 'date_required', 'js', 'حقل التاريخ مطلوب', 'active', NULL, NULL, '2025-06-21 00:42:48', '2025-06-21 00:42:48'),
(3192, '9f34afd1-0aac-4956-8476-8e360bc6ac87', 2, 2, 175, 'discount_less_than_amount', 'js', 'يجب أن يكون الخصم أقل من المبلغ الإجمالي.', 'active', NULL, NULL, '2025-06-21 00:42:48', '2025-06-21 00:42:48'),
(3193, '9f34afd1-0c72-4a25-83d6-105b92281627', 2, 2, 176, 'select_category', 'js', 'اختر الفئة', 'active', NULL, NULL, '2025-06-21 00:42:48', '2025-06-21 00:42:48'),
(3194, '9f34afd1-0e27-4746-a145-408a7d59e6ec', 2, 2, 177, 'update_quantity', 'js', 'يجب أن تكون كمية التحديث أقل من الكمية السابقة.', 'active', NULL, NULL, '2025-06-21 00:42:48', '2025-06-21 00:42:48'),
(3195, '9f34afd1-0fd3-48cc-bbbe-a1b6794ac10d', 2, 2, 178, 'tax_less_100', 'js', 'يجب أن تكون الضرائب أقل من 100%.', 'active', NULL, NULL, '2025-06-21 00:42:48', '2025-06-21 00:42:48'),
(3196, '9f34afd1-119b-445d-abd4-ce6dcdf51c30', 2, 2, 179, 'net_amount_not_empty', 'js', 'لا يمكن أن يكون المبلغ الصافي فارغًا.', 'active', NULL, NULL, '2025-06-21 00:42:48', '2025-06-21 00:42:48'),
(3197, '9f34afd1-134e-4534-8ab0-6cf1c27deefe', 2, 2, 180, 'net_amount_not_zero', 'js', 'لا يمكن أن يكون المبلغ الصافي صفراً.', 'active', NULL, NULL, '2025-06-21 00:42:48', '2025-06-21 00:42:48'),
(3198, '9f34afd1-14f9-4476-ab8a-58f0a13aeb13', 2, 2, 181, 'quantity_not_empty', 'js', 'لا يمكن أن تكون الكمية صفرًا أو فارغة.', 'active', NULL, NULL, '2025-06-21 00:42:48', '2025-06-21 00:42:48'),
(3199, '9f34afd1-16f3-448e-9b90-f63b311150be', 2, 2, 182, 'select_patient', 'js', 'اختر المريض', 'active', NULL, NULL, '2025-06-21 00:42:48', '2025-06-21 00:42:48'),
(3200, '9f34afd1-18a9-4c1f-b834-8a3e79d27041', 2, 2, 183, 'medicine_bill', 'js', 'فاتورة الطب', 'active', NULL, NULL, '2025-06-21 00:42:48', '2025-06-21 00:42:48'),
(3201, '9f34afd1-1a8f-46e5-bd57-dddb2c970665', 2, 2, 184, 'medicine_bill_already_use', 'js', 'هذا الدواء مستخدم بالفعل في فواتير الأدوية، هل أنت متأكد من رغبتك في حذفه؟', 'active', NULL, NULL, '2025-06-21 00:42:48', '2025-06-21 00:42:48'),
(3202, '9f34afd1-1c46-428f-886c-dde2492fea53', 2, 2, 185, 'select_service', 'js', 'اختر الخدمة', 'active', NULL, NULL, '2025-06-21 00:42:48', '2025-06-21 00:42:48'),
(3203, '9f34afd1-1dec-408a-aca1-506e235d9195', 2, 2, 186, 'select_parameter_name', 'js', 'حدد اسم المعلمة', 'active', NULL, NULL, '2025-06-21 00:42:48', '2025-06-21 00:42:48'),
(3204, '9f34afd1-211c-4d9e-a755-7f26cad09200', 2, 2, 187, 'active', 'js', 'نشيط', 'active', NULL, NULL, '2025-06-21 00:42:48', '2025-06-21 00:42:48'),
(3205, '9f34afd1-22fd-48a9-a41e-025494977571', 2, 2, 188, 'deactive', 'js', 'غير نشط', 'active', NULL, NULL, '2025-06-21 00:42:48', '2025-06-21 00:42:48'),
(3206, '9f34afd1-24aa-437c-ac54-7535c1b57a9b', 2, 2, 189, 'select_duration', 'js', 'حدد المدة', 'active', NULL, NULL, '2025-06-21 00:42:48', '2025-06-21 00:42:48'),
(3207, '9f34afd1-2665-4d79-b5bc-971203f8e779', 2, 2, 190, 'select_dose_interval', 'js', 'حدد الفاصل الزمني للجرعة', 'active', NULL, NULL, '2025-06-21 00:42:48', '2025-06-21 00:42:48'),
(3208, '9f34afd1-280c-4578-88c3-4f1087ac1ea7', 2, 2, 191, 'enter_lot_no', 'js', 'أدخل رقم القطعة.', 'active', NULL, NULL, '2025-06-21 00:42:48', '2025-06-21 00:42:48'),
(3209, '9f34afd1-29b4-4a19-a672-4616f39125c2', 2, 2, 192, 'enter_sale_price', 'js', 'أدخل سعر البيع.', 'active', NULL, NULL, '2025-06-21 00:42:48', '2025-06-21 00:42:48'),
(3210, '9f34afd1-2b61-41b9-af8c-b50c51b09aeb', 2, 2, 193, 'enter_purchase_price', 'js', 'أدخل سعر الشراء.', 'active', NULL, NULL, '2025-06-21 00:42:48', '2025-06-21 00:42:48'),
(3211, '9f34afd1-2d2d-46b3-80bb-27adba6bd1c5', 2, 2, 194, 'quantity_greater_than_0', 'js', 'يجب أن تكون الكمية أكبر من 0.', 'active', NULL, NULL, '2025-06-21 00:42:48', '2025-06-21 00:42:48'),
(3212, '9f34afd1-2eea-405e-a1aa-21d636ca0546', 2, 2, 195, 'tax_not_empty', 'js', 'لا يمكن أن يكون مبلغ الضريبة صفرًا أو فارغًا.', 'active', NULL, NULL, '2025-06-21 00:42:48', '2025-06-21 00:42:48'),
(3213, '9f34afd1-309b-4cba-b424-8d909050deda', 2, 2, 196, 'purchase_medicine', 'js', 'شراء الطب', 'active', NULL, NULL, '2025-06-21 00:42:48', '2025-06-21 00:42:48'),
(3214, '9f34afd1-324d-438e-a626-483e64fe80b4', 2, 2, 197, 'select_charge', 'js', 'حدد الشحن', 'active', NULL, NULL, '2025-06-21 00:42:48', '2025-06-21 00:42:48'),
(3215, '9f34afd1-33fa-4c1d-a350-debf36471023', 2, 2, 198, 'stripe_key', 'js', 'الرجاء إدخال مفتاح الشريط.', 'active', NULL, NULL, '2025-06-21 00:42:48', '2025-06-21 00:42:48'),
(3216, '9f34afd1-35c1-4e99-b0d2-a1e2eea6f1d2', 2, 2, 199, 'stripe_secret', 'js', 'الرجاء إدخال سر الشريط.', 'active', NULL, NULL, '2025-06-21 00:42:48', '2025-06-21 00:42:48'),
(3217, '9f34afd1-378a-426f-9d81-e32b10403bde', 2, 2, 200, 'paypal_client_id', 'js', 'الرجاء إدخال معرف عميل Paypal.', 'active', NULL, NULL, '2025-06-21 00:42:48', '2025-06-21 00:42:48'),
(3218, '9f34afd1-395e-423e-8acf-29ebea390c02', 2, 2, 201, 'paypal_secret', 'js', 'الرجاء إدخال سر باي بال.', 'active', NULL, NULL, '2025-06-21 00:42:48', '2025-06-21 00:42:48'),
(3219, '9f34afd1-3b12-41a8-9e09-8571ea85fa86', 2, 2, 202, 'paypal_mode', 'js', 'الرجاء إدخال وضع باي بال.', 'active', NULL, NULL, '2025-06-21 00:42:48', '2025-06-21 00:42:48'),
(3220, '9f34afd1-3cd8-4989-9dc8-f4bc4984c82d', 2, 2, 203, 'razorpay_key', 'js', 'الرجاء إدخال مفتاح razorpay.', 'active', NULL, NULL, '2025-06-21 00:42:48', '2025-06-21 00:42:48'),
(3221, '9f34afd1-3e93-4a7c-bbf3-876ec8af7b53', 2, 2, 204, 'razor_pay_secret', 'js', 'الرجاء إدخال سر razorpay.', 'active', NULL, NULL, '2025-06-21 00:42:48', '2025-06-21 00:42:48'),
(3222, '9f34afd1-404b-4ebd-8008-5f86cb1e90b7', 2, 2, 205, 'paytm_id', 'js', 'الرجاء إدخال معرف التاجر paytm.', 'active', NULL, NULL, '2025-06-21 00:42:48', '2025-06-21 00:42:48'),
(3223, '9f34afd1-41f9-4063-9097-ba0b03259aa8', 2, 2, 206, 'paytm_key', 'js', 'الرجاء إدخال مفتاح التاجر paytm.', 'active', NULL, NULL, '2025-06-21 00:42:48', '2025-06-21 00:42:48'),
(3224, '9f34afd1-43a9-42d4-8159-e5f6e4bb69c7', 2, 2, 207, 'paystack_key', 'js', 'الرجاء إدخال مفتاح paystack العام.', 'active', NULL, NULL, '2025-06-21 00:42:48', '2025-06-21 00:42:48'),
(3225, '9f34afd1-4567-4ca2-b97b-47a2faeaa586', 2, 2, 208, 'paystack_secret', 'js', 'الرجاء إدخال مفتاح paystack السري.', 'active', NULL, NULL, '2025-06-21 00:42:48', '2025-06-21 00:42:48'),
(3226, '9f34afd1-471d-484e-a106-35283b5d4801', 2, 2, 209, 'card_template', 'js', 'نموذج البطاقة الذكية للمريض', 'active', NULL, NULL, '2025-06-21 00:42:48', '2025-06-21 00:42:48'),
(3227, '9f34afd1-48d1-43d7-8b94-1e9f252b2cba', 2, 2, 210, 'smart_patient_card', 'js', 'البطاقة الذكية للمريض', 'active', NULL, NULL, '2025-06-21 00:42:48', '2025-06-21 00:42:48'),
(3228, '9f34afd1-4a80-4bf8-993f-f112efff5241', 2, 2, 211, 'template_required', 'js', 'حقل اسم القالب مطلوب.', 'active', NULL, NULL, '2025-06-21 00:42:48', '2025-06-21 00:42:48'),
(3229, '9f34afd1-4c34-4377-8a9e-861e783f31a4', 2, 2, 212, 'patient_required', 'js', 'حقل المريض مطلوب.', 'active', NULL, NULL, '2025-06-21 00:42:48', '2025-06-21 00:42:48'),
(3230, '9f34afd1-4de5-4d9c-805e-059f0c8f43af', 2, 2, 213, 'qr_code_not_found', 'js', 'لم يتم العثور على رمز الاستجابة السريعة.', 'active', NULL, NULL, '2025-06-21 00:42:48', '2025-06-21 00:42:48'),
(3231, '9f34afd1-4f95-42ef-9523-53011c3ab62d', 2, 2, 214, 'charchter_160', 'js', 'لا يجوز أن تزيد الرسالة عن 160 حرفًا.', 'active', NULL, NULL, '2025-06-21 00:42:48', '2025-06-21 00:42:48'),
(3232, '9f34afd1-5147-4e9e-a79e-0bcf13980ec9', 2, 2, 215, 'captcha_key', 'js', 'الرجاء إدخال مفتاح Google captcha.', 'active', NULL, NULL, '2025-06-21 00:42:48', '2025-06-21 00:42:48'),
(3233, '9f34afd1-530d-44f9-8779-3e87c0ea6936', 2, 2, 216, 'captcha_secret', 'js', 'الرجاء إدخال سر كلمة التحقق في Google.', 'active', NULL, NULL, '2025-06-21 00:42:48', '2025-06-21 00:42:48'),
(3234, '9f34afd1-54be-4f53-af79-91384a9c89c4', 2, 2, 217, 'phone_number', 'js', 'رقم التليفون', 'active', NULL, NULL, '2025-06-21 00:42:48', '2025-06-21 00:42:48'),
(3235, '9f34afd1-57bd-4251-8974-1163919d5fab', 2, 2, 218, 'all_required_fields', 'js', 'يرجى ملء كافة الحقول المطلوبة.', 'active', NULL, NULL, '2025-06-21 00:42:48', '2025-06-21 00:42:48'),
(3236, '9f34afd1-5987-48c2-a385-9401e679a8b4', 2, 2, 219, 'select_doctors', 'js', 'اختر الأطباء', 'active', NULL, NULL, '2025-06-21 00:42:48', '2025-06-21 00:42:48'),
(3237, '9f34afd1-5b3c-46df-ad52-8c14383a8a85', 2, 2, 220, 'patient_not_exists_or_status_is_not_active', 'js', 'المريض غير موجود أو الحالة غير نشطة.', 'active', NULL, NULL, '2025-06-21 00:42:48', '2025-06-21 00:42:48'),
(3238, '9f34afd1-5d03-4412-a0c1-0051c871bb24', 2, 2, 221, 'password_not_match', 'js', 'كلمة المرور وتأكيد كلمة المرور غير متطابقين.', 'active', NULL, NULL, '2025-06-21 00:42:48', '2025-06-21 00:42:48'),
(3239, '9f34afd1-5edc-4731-8d90-67ee6e862c87', 2, 2, 222, 'disconnect_or_reconnect', 'js', 'يرجى قطع الاتصال وإعادة توصيل تقويم Google الخاص بك', 'active', NULL, NULL, '2025-06-21 00:42:48', '2025-06-21 00:42:48'),
(3240, '9f34afd1-60ad-47a4-a32a-e1bcad079a56', 2, 2, 223, 'select_calendar', 'js', 'الرجاء تحديد التقويم.', 'active', NULL, NULL, '2025-06-21 00:42:48', '2025-06-21 00:42:48'),
(3241, '9f34afd1-6279-47dd-b529-fd7fc0181def', 2, 2, 224, 'value_must_be_greter_then', 'js', 'يجب أن تكون القيمة أكبر من 1', 'active', NULL, NULL, '2025-06-21 00:42:48', '2025-06-21 00:42:48'),
(3242, '9f34afd1-6448-4cd5-9101-152b1ea76bba', 2, 2, 225, 'value_field_required', 'js', 'حقل القيمة مطلوب.', 'active', NULL, NULL, '2025-06-21 00:42:48', '2025-06-21 00:42:48'),
(3243, '9f34afd1-6609-40c0-b18d-2bc71a26d4d7', 2, 2, 227, 'google_meet', 'js', 'جوجل ميت', 'active', NULL, NULL, '2025-06-21 00:42:48', '2025-06-21 00:42:48'),
(3244, '9f34afd1-67bf-4d93-b96f-39434ccb8a4d', 2, 2, 228, 'zoom', 'js', 'تكبير', 'active', NULL, NULL, '2025-06-21 00:42:48', '2025-06-21 00:42:48'),
(3245, '9f34afd1-6983-419f-8ea4-b2e8f596a9a0', 2, 2, 229, 'field_required', 'js', 'الحقل مطلوب.', 'active', NULL, NULL, '2025-06-21 00:42:48', '2025-06-21 00:42:48'),
(3246, '9f34afd1-6b37-47ec-a254-c538ec66418c', 2, 2, 230, 'payment_type', 'js', 'اختر نوع الدفع', 'active', NULL, NULL, '2025-06-21 00:42:48', '2025-06-21 00:42:48'),
(3247, '9f34afd1-6d20-4480-a43d-cc256c9987d6', 2, 2, 231, 'expiry_date', 'js', 'تاريخ الانتهاء', 'active', NULL, NULL, '2025-06-21 00:42:48', '2025-06-21 00:42:48'),
(3248, '9f34afd1-6f37-46b5-a05d-229cfb35a27e', 2, 2, 232, 'bill_date', 'js', 'الرجاء تحديد تاريخ الفاتورة.', 'active', NULL, NULL, '2025-06-21 00:42:48', '2025-06-21 00:42:48'),
(3249, '9f34afd1-7111-43a7-ae44-c8202e45cc25', 2, 2, 233, 'select_medicine_category', 'js', 'الرجاء تحديد فئة الدواء', 'active', NULL, NULL, '2025-06-21 00:42:48', '2025-06-21 00:42:48'),
(3250, '9f34afd1-72dd-41d2-bd76-d507ed57df6a', 2, 2, 234, 'amount_not_zero', 'js', 'لا يمكن أن يكون المبلغ صفراً.', 'active', NULL, NULL, '2025-06-21 00:42:48', '2025-06-21 00:42:48'),
(3251, '9f34afd1-74e5-4aad-a00f-423a9e2e3b71', 2, 2, 235, 'phonepe_merchant_id', 'js', 'الرجاء إدخال معرف تاجر Phonepe.', 'active', NULL, NULL, '2025-06-21 00:42:48', '2025-06-21 00:42:48'),
(3252, '9f34afd1-76b1-4a15-a347-721170538973', 2, 2, 236, 'phonepe_merchant_user_id', 'js', 'الرجاء إدخال معرف مستخدم Phonepe التاجر.', 'active', NULL, NULL, '2025-06-21 00:42:48', '2025-06-21 00:42:48'),
(3253, '9f34afd1-78ab-4c10-98a6-093b892bba0c', 2, 2, 237, 'phonepe_env', 'js', 'الرجاء إدخال Phonepe Env.', 'active', NULL, NULL, '2025-06-21 00:42:48', '2025-06-21 00:42:48'),
(3254, '9f34afd1-7ab7-4dac-be67-1e13e98644b5', 2, 2, 238, 'phonepe_salt_key', 'js', 'الرجاء إدخال Phonepe Salt Key.', 'active', NULL, NULL, '2025-06-21 00:42:48', '2025-06-21 00:42:48'),
(3255, '9f34afd1-7ca1-43cf-8086-bb643a40d365', 2, 2, 239, 'phonepe_salt_index', 'js', 'الرجاء إدخال مؤشر ملح Phonepe.', 'active', NULL, NULL, '2025-06-21 00:42:48', '2025-06-21 00:42:48'),
(3256, '9f34afd1-7e99-4485-b6c4-e182792e5dc5', 2, 2, 240, 'phonepe_merchant_transaction_id', 'js', 'الرجاء إدخال معرف معاملة تاجر Phonepe.', 'active', NULL, NULL, '2025-06-21 00:42:48', '2025-06-21 00:42:48'),
(3257, '9f34afd1-8072-443e-ae5a-23ad038bd07d', 2, 2, 241, 'flutterWave_public_key', 'js', 'الرجاء إدخال المفتاح العام FlutterWave.', 'active', NULL, NULL, '2025-06-21 00:42:48', '2025-06-21 00:42:48'),
(3258, '9f34afd1-8253-448a-93ad-4c9e9163b0e9', 2, 2, 242, 'flutterWave_secret_key', 'js', 'الرجاء إدخال مفتاح FlutterWave السري.', 'active', NULL, NULL, '2025-06-21 00:42:48', '2025-06-21 00:42:48'),
(3259, '9f34afd1-841e-4c75-888a-2f8da3c1a8b8', 2, 2, 243, 'open_ai_key', 'js', 'الرجاء إدخال مفتاح Openai.', 'active', NULL, NULL, '2025-06-21 00:42:48', '2025-06-21 00:42:48'),
(3260, '9f34afd1-8630-4cba-bfef-6735147d061b', 2, 2, 244, 'fill_physical_info', 'js', 'املأ أي تفاصيل عن المعلومات المادية.', 'active', NULL, NULL, '2025-06-21 00:42:48', '2025-06-21 00:42:48'),
(3261, '9f34afd1-8824-4092-a27c-6c8708fb29d6', 2, 2, 250, 'old_patient_email_exists', 'js', 'البريد الإلكتروني موجود بالفعل، يرجى اختيار مريض قديم.', 'active', NULL, NULL, '2025-06-21 00:42:48', '2025-06-21 00:42:48'),
(3262, '9f34afd1-89f0-4565-a578-25996cba796f', 2, 2, 251, 'appointment_saved', 'js', 'تم حفظ الموعد بنجاح.', 'active', NULL, NULL, '2025-06-21 00:42:48', '2025-06-21 00:42:48'),
(3263, '9f34afd1-8bd0-4f5d-b5a4-fc0c6326dc4e', 2, 2, 245, 'hospital_type', 'js', 'نوع المستشفى', 'active', NULL, NULL, '2025-06-21 00:42:48', '2025-06-21 00:42:48'),
(3264, '9f34afd1-8da9-4a26-a2fd-0b5444c92cb5', 2, 2, 246, 'hospital', 'js', 'مستشفى', 'active', NULL, NULL, '2025-06-21 00:42:48', '2025-06-21 00:42:48'),
(3265, '9f34afd1-8f72-41cf-bac0-0fbf12b09941', 2, 2, 247, 'n/a', 'js', 'لا يوجد', 'active', NULL, NULL, '2025-06-21 00:42:48', '2025-06-21 00:42:48'),
(3266, '9f34afd1-913d-4023-8bee-024f1593edce', 2, 2, 248, 'pending', 'js', 'قيد الانتظار', 'active', NULL, NULL, '2025-06-21 00:42:48', '2025-06-21 00:42:48'),
(3267, '9f34afd1-9303-4572-bf8b-da8e1dfe278e', 2, 2, 249, 'completed', 'js', 'مكتمل', 'active', NULL, NULL, '2025-06-21 00:42:48', '2025-06-21 00:42:48'),
(3268, '9f34afd1-94c7-41cb-b147-cf35e20c5876', 2, 2, 226, 'select_blood_group', 'js', 'اختر فصيلة الدم', 'active', NULL, NULL, '2025-06-21 00:42:48', '2025-06-21 00:42:48'),
(3269, '9f34afd1-96bb-49f3-b2cc-a14cc45c8993', 2, 3, 252, 'admin_details', 'messages', 'تفاصيل المسؤول', 'active', NULL, NULL, '2025-06-21 00:42:48', '2025-06-21 00:42:48'),
(3270, '9f34afd1-9878-4de3-b570-ddf7ee890f10', 2, 3, 253, 'admins', 'messages', 'المشرفون', 'active', NULL, NULL, '2025-06-21 00:42:48', '2025-06-21 00:42:48'),
(3271, '9f34afd1-9a41-41d8-9639-ac4af94c8b12', 2, 3, 254, 'admin', 'messages', 'مسؤل', 'active', NULL, NULL, '2025-06-21 00:42:48', '2025-06-21 00:42:48'),
(3272, '9f34afd1-9c0a-40e1-ad71-cc39473d750a', 2, 3, 255, 'roles', 'messages', 'الأدوار', 'active', NULL, NULL, '2025-06-21 00:42:48', '2025-06-21 00:42:48'),
(3273, '9f34afd1-9dd1-4526-aaec-0dae61024c12', 2, 3, 256, 'doctor_departments', 'messages', 'أقسام الطبيب', 'active', NULL, NULL, '2025-06-21 00:42:48', '2025-06-21 00:42:48'),
(3274, '9f34afd1-9f94-4869-a9ee-6607069d637d', 2, 3, 257, 'nurses', 'messages', 'الممرضات', 'active', NULL, NULL, '2025-06-21 00:42:48', '2025-06-21 00:42:48'),
(3275, '9f34afd1-a15f-4b44-aa28-5f5804aeb5b1', 2, 3, 258, 'doctors', 'messages', 'الأطباء', 'active', NULL, NULL, '2025-06-21 00:42:48', '2025-06-21 00:42:48'),
(3276, '9f34afd1-a324-4d05-a7f4-99b4cb644988', 2, 3, 259, 'patients', 'messages', 'المرضى', 'active', NULL, NULL, '2025-06-21 00:42:48', '2025-06-21 00:42:48'),
(3277, '9f34afd1-a4e9-47b1-83e4-a2699920f20d', 2, 3, 260, 'lab_technicians', 'messages', 'فنيو المختبرات', 'active', NULL, NULL, '2025-06-21 00:42:48', '2025-06-21 00:42:48'),
(3278, '9f34afd1-a6b7-4a70-b498-3841d0b0d118', 2, 3, 261, 'receptionists', 'messages', 'الاستقبال', 'active', NULL, NULL, '2025-06-21 00:42:48', '2025-06-21 00:42:48'),
(3279, '9f34afd1-a8b5-4299-b900-f5d4a0500bb9', 2, 3, 262, 'pharmacists', 'messages', 'الصيادلة', 'active', NULL, NULL, '2025-06-21 00:42:48', '2025-06-21 00:42:48'),
(3280, '9f34afd1-af8e-4ba8-8368-d796b885f826', 2, 3, 263, 'accountants', 'messages', 'المحاسبين', 'active', NULL, NULL, '2025-06-21 00:42:48', '2025-06-21 00:42:48'),
(3281, '9f34afd1-b160-42b8-9748-5155489a542a', 2, 3, 264, 'appointments', 'messages', 'تعيينات', 'active', NULL, NULL, '2025-06-21 00:42:48', '2025-06-21 00:42:48'),
(3282, '9f34afd1-b344-448c-bc44-f4b542dc2157', 2, 3, 265, 'insurances', 'messages', 'تأمين', 'active', NULL, NULL, '2025-06-21 00:42:48', '2025-06-21 00:42:48'),
(3283, '9f34afd1-b52c-4bae-b9cc-14fc1186d948', 2, 3, 266, 'investigation_reports', 'messages', 'تقارير التحقيق', 'active', NULL, NULL, '2025-06-21 00:42:48', '2025-06-21 00:42:48'),
(3284, '9f34afd1-b6ee-4bb4-8d69-f9c854bb0984', 2, 3, 267, 'death_reports', 'messages', 'تقارير الوفاة', 'active', NULL, NULL, '2025-06-21 00:42:48', '2025-06-21 00:42:48'),
(3285, '9f34afd1-b8c1-445b-80c0-b7ec6d2817ba', 2, 3, 268, 'birth_reports', 'messages', 'تقارير الميلاد', 'active', NULL, NULL, '2025-06-21 00:42:48', '2025-06-21 00:42:48'),
(3286, '9f34afd1-ba8f-4dde-ab2d-c629e38c3bcc', 2, 3, 269, 'operation_reports', 'messages', 'تقارير التشغيل', 'active', NULL, NULL, '2025-06-21 00:42:48', '2025-06-21 00:42:48'),
(3287, '9f34afd1-bc6a-459a-a2bf-b93362a43403', 2, 3, 270, 'medicine_categories', 'messages', 'فئات الطب', 'active', NULL, NULL, '2025-06-21 00:42:48', '2025-06-21 00:42:48'),
(3288, '9f34afd1-be32-4205-be6f-b68b6070d037', 2, 3, 271, 'medicine_brands', 'messages', 'ماركات الطب', 'active', NULL, NULL, '2025-06-21 00:42:48', '2025-06-21 00:42:48'),
(3289, '9f34afd1-c005-4b7f-aca7-de9a5836c0c5', 2, 3, 272, 'medicines', 'messages', 'أدوية', 'active', NULL, NULL, '2025-06-21 00:42:48', '2025-06-21 00:42:48'),
(3290, '9f34afd1-c1ff-4f0a-94e4-f666225dcc91', 2, 3, 273, 'cases', 'messages', 'الحالات', 'active', NULL, NULL, '2025-06-21 00:42:48', '2025-06-21 00:42:48'),
(3291, '9f34afd1-c3d6-4502-86a3-219ab3d4cf36', 2, 3, 274, 'case_handlers', 'messages', 'معالجات الحالة', 'active', NULL, NULL, '2025-06-21 00:42:48', '2025-06-21 00:42:48'),
(3292, '9f34afd1-c5a8-4e0d-9bbf-a99b5a7003c2', 2, 3, 275, 'bed_types', 'messages', 'أنواع السرير', 'active', NULL, NULL, '2025-06-21 00:42:48', '2025-06-21 00:42:48'),
(3293, '9f34afd1-c77d-4535-9be1-c8c55a5cc2ac', 2, 3, 276, 'beds', 'messages', 'سرير', 'active', NULL, NULL, '2025-06-21 00:42:48', '2025-06-21 00:42:48'),
(3294, '9f34afd1-c960-4844-9c8c-84d5301eab33', 2, 3, 277, 'bed_assigns', 'messages', 'تعيينات السرير', 'active', NULL, NULL, '2025-06-21 00:42:48', '2025-06-21 00:42:48'),
(3295, '9f34afd1-cb2b-47f0-89e5-bcb726e8b5cb', 2, 3, 278, 'packages', 'messages', 'الحزم', 'active', NULL, NULL, '2025-06-21 00:42:48', '2025-06-21 00:42:48'),
(3296, '9f34afd1-ce3d-47cf-8493-3e675c3ea305', 2, 3, 279, 'schedules', 'messages', 'جداول', 'active', NULL, NULL, '2025-06-21 00:42:48', '2025-06-21 00:42:48'),
(3297, '9f34afd1-d1ad-41ee-8834-fbb2c50c632e', 2, 3, 280, 'schedule_label', 'messages', 'جدول', 'active', NULL, NULL, '2025-06-21 00:42:48', '2025-06-21 00:42:48'),
(3298, '9f34afd1-d3a0-47de-88f2-6b4407ad9ed7', 2, 3, 281, 'services', 'messages', 'خدمات', 'active', NULL, NULL, '2025-06-21 00:42:48', '2025-06-21 00:42:48'),
(3299, '9f34afd1-d587-4d7b-9344-56617a17ae2d', 2, 3, 282, 'accounts', 'messages', 'حسابات', 'active', NULL, NULL, '2025-06-21 00:42:48', '2025-06-21 00:42:48'),
(3300, '9f34afd1-d76f-471c-b0e2-09af8070bf26', 2, 3, 283, 'payments', 'messages', 'المدفوعات', 'active', NULL, NULL, '2025-06-21 00:42:48', '2025-06-21 00:42:48'),
(3301, '9f34afd1-d952-4379-8cbd-4a6d09a56867', 2, 3, 284, 'bills', 'messages', 'فواتير', 'active', NULL, NULL, '2025-06-21 00:42:48', '2025-06-21 00:42:48'),
(3302, '9f34afd1-db21-468d-ba45-324415a13c9f', 2, 3, 285, 'employee_payrolls', 'messages', 'كشوف مرتبات الموظفين', 'active', NULL, NULL, '2025-06-21 00:42:48', '2025-06-21 00:42:48'),
(3303, '9f34afd1-dd47-4d4c-8b1b-9067ad0723b1', 2, 3, 286, 'documents', 'messages', 'مستندات', 'active', NULL, NULL, '2025-06-21 00:42:48', '2025-06-21 00:42:48'),
(3304, '9f34afd1-df25-4a38-945c-b732dd1f518c', 2, 3, 287, 'document_types', 'messages', 'أنواع المستندات', 'active', NULL, NULL, '2025-06-21 00:42:48', '2025-06-21 00:42:48'),
(3305, '9f34afd1-e0f2-4b9d-b328-649a346e1ecc', 2, 3, 288, 'notice_boards', 'messages', 'لافتات تنبيه', 'active', NULL, NULL, '2025-06-21 00:42:48', '2025-06-21 00:42:48'),
(3306, '9f34afd1-e2d4-4c2e-bc37-6377f207dca2', 2, 3, 289, 'settings', 'messages', 'الإعدادات', 'active', NULL, NULL, '2025-06-21 00:42:48', '2025-06-21 00:42:48'),
(3307, '9f34afd1-e4ac-4c29-9d5c-3c3a779ba22a', 2, 3, 290, 'doctors_list', 'messages', 'قائمة الأطباء', 'active', NULL, NULL, '2025-06-21 00:42:48', '2025-06-21 00:42:48'),
(3308, '9f34afd1-e67e-4b5e-8803-be8b1c676d61', 2, 3, 291, 'my_payrolls', 'messages', 'رواتبي', 'active', NULL, NULL, '2025-06-21 00:42:48', '2025-06-21 00:42:48'),
(3309, '9f34afd1-e85b-4d87-b292-99118580aa41', 2, 3, 292, 'blood_banks', 'messages', 'بنوك الدم', 'active', NULL, NULL, '2025-06-21 00:42:48', '2025-06-21 00:42:48'),
(3310, '9f34afd1-ea41-46e9-b63f-f1fc0f334fa7', 2, 3, 293, 'blood_donors', 'messages', 'المتبرعين بالدم', 'active', NULL, NULL, '2025-06-21 00:42:48', '2025-06-21 00:42:48'),
(3311, '9f34afd1-ec11-48c5-8392-6a70fb7f8f80', 2, 3, 294, 'invoices', 'messages', 'فواتير', 'active', NULL, NULL, '2025-06-21 00:42:48', '2025-06-21 00:42:48'),
(3312, '9f34afd1-edda-407d-9f5c-a236d2059a59', 2, 3, 295, 'patients_cases', 'messages', 'حالات المرضى', 'active', NULL, NULL, '2025-06-21 00:42:48', '2025-06-21 00:42:48'),
(3313, '9f34afd1-efbb-4525-81cd-0c9470b527eb', 2, 3, 296, 'patients_case_details', 'messages', 'تفاصيل حالة المرضى', 'active', NULL, NULL, '2025-06-21 00:42:48', '2025-06-21 00:42:48'),
(3314, '9f34afd1-f1b8-4431-8d7f-553ba8b39ea8', 2, 3, 297, 'account_manager', 'messages', 'إدارة حساب المستخدم', 'active', NULL, NULL, '2025-06-21 00:42:48', '2025-06-21 00:42:48'),
(3315, '9f34afd1-f3a1-4b54-a2a9-865432921ca3', 2, 3, 298, 'bed_management', 'messages', 'إدارة السرير', 'active', NULL, NULL, '2025-06-21 00:42:48', '2025-06-21 00:42:48'),
(3316, '9f34afd1-f581-4ca7-8d26-f45e4f30c1c9', 2, 3, 299, 'blood_bank', 'messages', 'بنك الدم', 'active', NULL, NULL, '2025-06-21 00:42:48', '2025-06-21 00:42:48'),
(3317, '9f34afd1-f767-48b6-9237-dde960c9437b', 2, 3, 300, 'billing', 'messages', 'الفواتير', 'active', NULL, NULL, '2025-06-21 00:42:48', '2025-06-21 00:42:48'),
(3318, '9f34afd1-f94d-4770-8e29-3a3671a1e3aa', 2, 3, 301, 'case_manager', 'messages', 'مدير الحالة', 'active', NULL, NULL, '2025-06-21 00:42:48', '2025-06-21 00:42:48'),
(3319, '9f34afd1-fb19-4df5-ac0f-d72a5e64d3f0', 2, 3, 302, 'cms', 'messages', 'نظام إدارة المحتوى', 'active', NULL, NULL, '2025-06-21 00:42:48', '2025-06-21 00:42:48'),
(3320, '9f34afd1-fcf9-4162-bccb-ac1861ad3baf', 2, 3, 304, 'department', 'messages', 'قسم', 'active', NULL, NULL, '2025-06-21 00:42:48', '2025-06-21 00:42:48'),
(3321, '9f34afd1-fee3-4def-a625-ab512a0fa0fa', 2, 3, 305, 'departments', 'messages', 'الأقسام', 'active', NULL, NULL, '2025-06-21 00:42:48', '2025-06-21 00:42:48'),
(3322, '9f34afd2-00ff-4665-93fb-90f4b29f451c', 2, 3, 306, 'hospital_activities', 'messages', 'أنشطة المستشفى', 'active', NULL, NULL, '2025-06-21 00:42:48', '2025-06-21 00:42:48'),
(3323, '9f34afd2-0304-4b20-b394-596fb63d3e85', 2, 3, 307, 'advanced_payments', 'messages', 'دفعات مقدمة', 'active', NULL, NULL, '2025-06-21 00:42:48', '2025-06-21 00:42:48'),
(3324, '9f34afd2-04fd-4d50-b367-b61dd7fca043', 2, 3, 308, 'patient_admissions', 'messages', 'قبول المرضى', 'active', NULL, NULL, '2025-06-21 00:42:48', '2025-06-21 00:42:48'),
(3325, '9f34afd2-06e0-4463-8cd8-c63bbfa15862', 2, 3, 309, 'appointment_calendar', 'messages', 'عيّن. التقويم', 'active', NULL, NULL, '2025-06-21 00:42:48', '2025-06-21 00:42:48'),
(3326, '9f34afd2-08b9-4b04-89ed-22043840921a', 2, 3, 310, 'bed_mgt', 'messages', 'إدارة السرير', 'active', NULL, NULL, '2025-06-21 00:42:48', '2025-06-21 00:42:48'),
(3327, '9f34afd2-0a97-4406-a3ba-7555526930e9', 2, 3, 311, 'reports', 'messages', 'التقارير', 'active', NULL, NULL, '2025-06-21 00:42:48', '2025-06-21 00:42:48'),
(3328, '9f34afd2-0c7c-454f-b9b8-272d3ee469e9', 2, 3, 312, 'enquiries', 'messages', 'استفسارات', 'active', NULL, NULL, '2025-06-21 00:42:48', '2025-06-21 00:42:48'),
(3329, '9f34afd2-0e60-4d3a-9a55-53ed700c8ae7', 2, 3, 313, 'mail', 'messages', 'بريد', 'active', NULL, NULL, '2025-06-21 00:42:48', '2025-06-21 00:42:48'),
(3330, '9f34afd2-103c-404b-beb2-d3716603c0ed', 2, 3, 314, 'ambulances', 'messages', 'سيارات الإسعاف', 'active', NULL, NULL, '2025-06-21 00:42:48', '2025-06-21 00:42:48'),
(3331, '9f34afd2-120c-44a8-afd0-131741ed0cde', 2, 3, 315, 'ambulance_calls', 'messages', 'مكالمات الإسعاف', 'active', NULL, NULL, '2025-06-21 00:42:48', '2025-06-21 00:42:48'),
(3332, '9f34afd2-13e1-492d-abd3-4d01df731acc', 2, 3, 316, 'prescriptions', 'messages', 'الوصفات الطبية', 'active', NULL, NULL, '2025-06-21 00:42:48', '2025-06-21 00:42:48'),
(3333, '9f34afd2-15cb-49d6-9bb0-9f89565a824e', 2, 3, 317, 'hospital_charges', 'messages', 'رسوم المستشفى', 'active', NULL, NULL, '2025-06-21 00:42:48', '2025-06-21 00:42:48'),
(3334, '9f34afd2-17b6-4a23-ba83-178fcb76f67b', 2, 3, 318, 'charge_categories', 'messages', 'فئات الرسوم', 'active', NULL, NULL, '2025-06-21 00:42:48', '2025-06-21 00:42:48'),
(3335, '9f34afd2-198e-4f6e-8a59-e645a8b80aab', 2, 3, 319, 'charges', 'messages', 'شحنة', 'active', NULL, NULL, '2025-06-21 00:42:48', '2025-06-21 00:42:48'),
(3336, '9f34afd2-1b67-4932-ab99-9e518ac5d9e7', 2, 3, 320, 'radiologies', 'messages', 'الأشعة', 'active', NULL, NULL, '2025-06-21 00:42:48', '2025-06-21 00:42:48'),
(3337, '9f34afd2-1d48-4f78-8647-6888163f5844', 2, 3, 321, 'radiology_categories', 'messages', 'فئة الأشعة', 'active', NULL, NULL, '2025-06-21 00:42:48', '2025-06-21 00:42:48'),
(3338, '9f34afd2-1f1f-482c-be9d-31f8a41851d6', 2, 3, 322, 'pathologies', 'messages', 'علم الأمراض', 'active', NULL, NULL, '2025-06-21 00:42:48', '2025-06-21 00:42:48'),
(3339, '9f34afd2-210d-4f16-a37b-eddf2dbb4914', 2, 3, 323, 'pathology_categories', 'messages', 'فئة علم الأمراض', 'active', NULL, NULL, '2025-06-21 00:42:48', '2025-06-21 00:42:48'),
(3340, '9f34afd2-22eb-4259-b30d-376f914c01ed', 2, 3, 324, 'radiology_tests', 'messages', 'اختبارات الأشعة', 'active', NULL, NULL, '2025-06-21 00:42:49', '2025-06-21 00:42:49'),
(3341, '9f34afd2-24d4-4dba-b9c6-e357175b8a52', 2, 3, 325, 'doctor_opd_charges', 'messages', 'رسوم طبيب العيادات الخارجية', 'active', NULL, NULL, '2025-06-21 00:42:49', '2025-06-21 00:42:49'),
(3342, '9f34afd2-26b3-4ef9-9434-6d55aa212e0d', 2, 3, 326, 'pathology_tests', 'messages', 'اختبارات علم الأمراض', 'active', NULL, NULL, '2025-06-21 00:42:49', '2025-06-21 00:42:49'),
(3343, '9f34afd2-28a5-4a82-977e-6fea78e91481', 2, 3, 327, 'expenses', 'messages', 'نفقات', 'active', NULL, NULL, '2025-06-21 00:42:49', '2025-06-21 00:42:49'),
(3344, '9f34afd2-2aa1-4283-adf5-57013cfda87e', 2, 3, 328, 'income', 'messages', 'الإيرادات', 'active', NULL, NULL, '2025-06-21 00:42:49', '2025-06-21 00:42:49'),
(3345, '9f34afd2-2c6d-475b-94ba-f45682fe6bf7', 2, 3, 329, 'finance', 'messages', 'المالية', 'active', NULL, NULL, '2025-06-21 00:42:49', '2025-06-21 00:42:49'),
(3346, '9f34afd2-2e67-474a-8101-07b84d821081', 2, 3, 344, 'inventory', 'messages', 'المخزون', 'active', NULL, NULL, '2025-06-21 00:42:49', '2025-06-21 00:42:49'),
(3347, '9f34afd2-305a-4020-8bf2-6a09d5930a76', 2, 3, 345, 'items_categories', 'messages', 'فئات العناصر', 'active', NULL, NULL, '2025-06-21 00:42:49', '2025-06-21 00:42:49'),
(3348, '9f34afd2-3256-4ab4-9fb7-d928430be046', 2, 3, 346, 'items', 'messages', 'العناصر', 'active', NULL, NULL, '2025-06-21 00:42:49', '2025-06-21 00:42:49'),
(3349, '9f34afd2-343e-40f7-9ebe-cd38b05e9324', 2, 3, 347, 'items_stocks', 'messages', 'مخزون البند', 'active', NULL, NULL, '2025-06-21 00:42:49', '2025-06-21 00:42:49'),
(3350, '9f34afd2-3619-4e44-b179-535333cd83bb', 2, 3, 330, 'issued_items', 'messages', 'العناصر المصدرة', 'active', NULL, NULL, '2025-06-21 00:42:49', '2025-06-21 00:42:49'),
(3351, '9f34afd2-3830-4cfd-9de7-4a079f23a415', 2, 3, 331, 'ipd_patients', 'messages', 'مرضى IPD', 'active', NULL, NULL, '2025-06-21 00:42:49', '2025-06-21 00:42:49'),
(3352, '9f34afd2-3a2f-4bd7-a0fa-375eff72feca', 2, 3, 332, 'ipd_opd', 'messages', 'IPD / العيادات الخارجية', 'active', NULL, NULL, '2025-06-21 00:42:49', '2025-06-21 00:42:49'),
(3353, '9f34afd2-3c22-4171-bb55-238a4e797010', 2, 3, 333, 'ipd_diagnosis', 'messages', 'التشخيص', 'active', NULL, NULL, '2025-06-21 00:42:49', '2025-06-21 00:42:49'),
(3354, '9f34afd2-3e14-4462-bb16-9c08d9f19c56', 2, 3, 334, 'ipd_consultant_register', 'messages', 'تعليمات استشاري', 'active', NULL, NULL, '2025-06-21 00:42:49', '2025-06-21 00:42:49'),
(3355, '9f34afd2-3ffd-44c5-9f36-b89d1860725f', 2, 3, 335, 'ipd_charges', 'messages', 'شحنة', 'active', NULL, NULL, '2025-06-21 00:42:49', '2025-06-21 00:42:49'),
(3356, '9f34afd2-41e5-48d8-b6c6-6ab2dc433783', 2, 3, 336, 'ipd_prescription', 'messages', 'الوصفات الطبية', 'active', NULL, NULL, '2025-06-21 00:42:49', '2025-06-21 00:42:49'),
(3357, '9f34afd2-43f8-412f-b93a-94397cd0dbc1', 2, 3, 337, 'ipd_timelines', 'messages', 'الجداول الزمنية', 'active', NULL, NULL, '2025-06-21 00:42:49', '2025-06-21 00:42:49'),
(3358, '9f34afd2-45e4-4f46-bab9-1e41d8b9a9c0', 2, 3, 338, 'opd_patients', 'messages', 'مرضى العيادات الخارجية', 'active', NULL, NULL, '2025-06-21 00:42:49', '2025-06-21 00:42:49'),
(3359, '9f34afd2-47d1-4b92-860f-59ed1a5ff035', 2, 3, 339, 'call_logs', 'messages', 'سجلات المكالمات', 'active', NULL, NULL, '2025-06-21 00:42:49', '2025-06-21 00:42:49'),
(3360, '9f34afd2-4b0c-4f17-8f9b-0aa57cbedfed', 2, 3, 340, 'visitors', 'messages', 'الزائرين', 'active', NULL, NULL, '2025-06-21 00:42:49', '2025-06-21 00:42:49'),
(3361, '9f34afd2-4cea-468d-af12-9adbd803f3ba', 2, 3, 341, 'front_office', 'messages', 'مكتب الإستقبال', 'active', NULL, NULL, '2025-06-21 00:42:49', '2025-06-21 00:42:49'),
(3362, '9f34afd2-4eda-4d5d-847d-6e73f67d91df', 2, 3, 342, 'postal_receive', 'messages', 'استلام بريدي', 'active', NULL, NULL, '2025-06-21 00:42:49', '2025-06-21 00:42:49'),
(3363, '9f34afd2-50cc-4c0c-bef4-6c3d9b5a4f83', 2, 3, 343, 'postal_dispatch', 'messages', 'الإرسال البريدي', 'active', NULL, NULL, '2025-06-21 00:42:49', '2025-06-21 00:42:49'),
(3364, '9f34afd2-52de-42ec-80ad-e0c5ab1d04fc', 2, 3, 348, 'general', 'messages', 'جنرال لواء', 'active', NULL, NULL, '2025-06-21 00:42:49', '2025-06-21 00:42:49'),
(3365, '9f34afd2-54cc-428b-a19d-cbdfd548b799', 2, 3, 349, 'sidebar_setting', 'messages', 'إعدادات الشريط الجانبي', 'active', NULL, NULL, '2025-06-21 00:42:49', '2025-06-21 00:42:49'),
(3366, '9f34afd2-56cd-4e9c-9101-3e49a1c6f8a9', 2, 3, 350, 'testimonials', 'messages', 'الشهادات', 'active', NULL, NULL, '2025-06-21 00:42:49', '2025-06-21 00:42:49'),
(3367, '9f34afd2-58ea-468c-b606-0a7724be2ef8', 2, 3, 351, 'blood_donations', 'messages', 'تبرع بالدم', 'active', NULL, NULL, '2025-06-21 00:42:49', '2025-06-21 00:42:49'),
(3368, '9f34afd2-5acd-4dbe-8249-063f710cc604', 2, 3, 352, 'blood_issues', 'messages', 'مشاكل الدم', 'active', NULL, NULL, '2025-06-21 00:42:49', '2025-06-21 00:42:49'),
(3369, '9f34afd2-5caf-4753-a4b2-244afe3d112f', 2, 3, 353, 'live_consultations', 'messages', 'استشارات مباشرة', 'active', NULL, NULL, '2025-06-21 00:42:49', '2025-06-21 00:42:49'),
(3370, '9f34afd2-5ea5-49e2-819e-f701b6a82e73', 2, 3, 355, 'vaccinations', 'messages', 'التطعيمات', 'active', NULL, NULL, '2025-06-21 00:42:49', '2025-06-21 00:42:49'),
(3371, '9f34afd2-608d-4f18-931f-d1873c9273b4', 2, 3, 356, 'vaccinated_patients', 'messages', 'المرضى الذين تم تطعيمهم', 'active', NULL, NULL, '2025-06-21 00:42:49', '2025-06-21 00:42:49'),
(3372, '9f34afd2-6279-49e9-919e-045a39867e1c', 2, 3, 359, 'front_settings', 'messages', 'الإعدادات الأمامية', 'active', NULL, NULL, '2025-06-21 00:42:49', '2025-06-21 00:42:49'),
(3373, '9f34afd2-647b-4830-9fe9-cd3692b413c2', 2, 3, 360, 'about_us', 'messages', 'معلومات عنا', 'active', NULL, NULL, '2025-06-21 00:42:49', '2025-06-21 00:42:49'),
(3374, '9f34afd2-6673-4375-a841-b5da690b9db6', 2, 3, 361, 'make_an_appointment', 'messages', 'إحجز موعد', 'active', NULL, NULL, '2025-06-21 00:42:49', '2025-06-21 00:42:49'),
(3375, '9f34afd2-684f-4812-a5b5-0a31fc3b41a6', 2, 3, 362, 'patient_appointment', 'messages', 'موعد المريض', 'active', NULL, NULL, '2025-06-21 00:42:49', '2025-06-21 00:42:49'),
(3376, '9f34afd2-6a3c-4dd4-a80d-a231631a5338', 2, 3, 363, 'old_patient', 'messages', 'مريض قديم', 'active', NULL, NULL, '2025-06-21 00:42:49', '2025-06-21 00:42:49'),
(3377, '9f34afd2-6c2a-4b36-8c82-206359272ac9', 2, 3, 364, 'new_patient', 'messages', 'مريض جديد', 'active', NULL, NULL, '2025-06-21 00:42:49', '2025-06-21 00:42:49'),
(3378, '9f34afd2-6e18-46c4-8ba0-af40e8993655', 2, 3, 365, 'available_slot', 'messages', 'الفتحة المتاحة', 'active', NULL, NULL, '2025-06-21 00:42:49', '2025-06-21 00:42:49'),
(3379, '9f34afd2-7001-4e84-8f9e-99efba9318b4', 2, 3, 367, 'contact_us', 'messages', 'اتصل بنا', 'active', NULL, NULL, '2025-06-21 00:42:49', '2025-06-21 00:42:49'),
(3380, '9f34afd2-7215-444f-ad2d-75a21873f7a0', 2, 3, 370, 'front_cms', 'messages', 'الجبهة نظام إدارة المحتوى', 'active', NULL, NULL, '2025-06-21 00:42:49', '2025-06-21 00:42:49'),
(3381, '9f34afd2-741a-4b80-8330-15c7d8962345', 2, 3, 357, 'users', 'messages', 'المستخدمون', 'active', NULL, NULL, '2025-06-21 00:42:49', '2025-06-21 00:42:49'),
(3382, '9f34afd2-7602-4c2e-8006-5455a3806180', 2, 3, 358, 'posts', 'messages', 'المنشورات', 'active', NULL, NULL, '2025-06-21 00:42:49', '2025-06-21 00:42:49'),
(3383, '9f34afd2-77fc-48f0-85c6-9445702177ff', 2, 3, 375, 'hospital_schedule', 'messages', 'جدول المستشفى', 'active', NULL, NULL, '2025-06-21 00:42:49', '2025-06-21 00:42:49'),
(3384, '9f34afd2-79eb-4608-b69a-26c4f8a40936', 2, 3, 376, 'impersonate', 'messages', 'انتحال الشخصية', 'active', NULL, NULL, '2025-06-21 00:42:49', '2025-06-21 00:42:49'),
(3385, '9f34afd2-7c00-483d-bf81-2d38316f8120', 2, 3, 377, 'subscription_plan', 'messages', 'خطة الاشتراك', 'active', NULL, NULL, '2025-06-21 00:42:49', '2025-06-21 00:42:49'),
(3386, '9f34afd2-7e0c-4f2b-83bf-5237f41b85b8', 2, 3, 378, 'subscription_days_plan_not_found', 'messages', 'لم نتمكن من العثور على خطط اشتراك أيام', 'active', NULL, NULL, '2025-06-21 00:42:49', '2025-06-21 00:42:49'),
(3387, '9f34afd2-8025-4f7e-95b7-fcc60e551ed1', 2, 3, 379, 'subscription_month_plan_not_found', 'messages', 'لم نتمكن من العثور على أي خطط اشتراك شهرية', 'active', NULL, NULL, '2025-06-21 00:42:49', '2025-06-21 00:42:49'),
(3388, '9f34afd2-8226-4fc1-b86b-4a6141d41056', 2, 3, 380, 'subscription_year_plan_not_found', 'messages', 'لم نتمكن من العثور على أي خطط اشتراك سنوية', 'active', NULL, NULL, '2025-06-21 00:42:49', '2025-06-21 00:42:49'),
(3389, '9f34afd2-8407-4c90-a89f-fb10387de8fa', 2, 3, 381, 'subscription_plan_not_found', 'messages', 'خطة الاشتراك غير موجودة', 'active', NULL, NULL, '2025-06-21 00:42:49', '2025-06-21 00:42:49'),
(3390, '9f34afd2-8618-4ce1-ae2d-1603be35120b', 2, 3, 382, 'month', 'messages', 'شهر', 'active', NULL, NULL, '2025-06-21 00:42:49', '2025-06-21 00:42:49'),
(3391, '9f34afd2-8822-41b4-a754-acda027d885c', 2, 3, 383, 'year', 'messages', 'عام', 'active', NULL, NULL, '2025-06-21 00:42:49', '2025-06-21 00:42:49'),
(3392, '9f34afd2-8a24-449e-8773-0bb6915c6cfa', 2, 3, 384, 'day', 'messages', 'يوم', 'active', NULL, NULL, '2025-06-21 00:42:49', '2025-06-21 00:42:49'),
(3393, '9f34afd2-8c17-474a-a894-e541b5e7729f', 2, 3, 386, 'view_all', 'messages', 'مشاهدة الكل', 'active', NULL, NULL, '2025-06-21 00:42:49', '2025-06-21 00:42:49'),
(3394, '9f34afd2-8e0c-4d03-8336-974f419b8d1c', 2, 3, 387, 'hospitals', 'messages', 'المستشفيات', 'active', NULL, NULL, '2025-06-21 00:42:49', '2025-06-21 00:42:49'),
(3395, '9f34afd2-9001-4d7f-a985-8ebb3174c838', 2, 3, 388, 'hospitals_type', 'messages', 'نوع المستشفى', 'active', NULL, NULL, '2025-06-21 00:42:49', '2025-06-21 00:42:49'),
(3396, '9f34afd2-91f3-4044-8dc4-716dbd6a0e3d', 2, 3, 389, 'hospital', 'messages', 'مستشفى', 'active', NULL, NULL, '2025-06-21 00:42:49', '2025-06-21 00:42:49'),
(3397, '9f34afd2-93eb-47fa-985b-627fe36520d0', 2, 3, 390, 'hospital_details', 'messages', 'تفاصيل المستشفى', 'active', NULL, NULL, '2025-06-21 00:42:49', '2025-06-21 00:42:49'),
(3398, '9f34afd2-95e0-4d28-87bb-f24acf820c6c', 2, 3, 391, 'overview', 'messages', 'ملخص', 'active', NULL, NULL, '2025-06-21 00:42:49', '2025-06-21 00:42:49'),
(3399, '9f34afd2-97da-4aea-8457-d7f4ac1afc88', 2, 3, 392, 'billings', 'messages', 'بيلينغز', 'active', NULL, NULL, '2025-06-21 00:42:49', '2025-06-21 00:42:49'),
(3400, '9f34afd2-99e7-4998-ade6-e87cc4a81d6b', 2, 3, 393, 'billing_detail', 'messages', 'تفاصيل الفواتير', 'active', NULL, NULL, '2025-06-21 00:42:49', '2025-06-21 00:42:49'),
(3401, '9f34afd2-9d85-41b4-bbca-8f25032f4828', 2, 3, 394, 'our_hospitals', 'messages', 'مستشفياتنا', 'active', NULL, NULL, '2025-06-21 00:42:49', '2025-06-21 00:42:49'),
(3402, '9f34afd2-9fbb-4823-a35d-bf48808c4464', 2, 3, 303, 'front_cms_services', 'messages', 'أمامي نظام إدارة المحتوى خدمات', 'active', NULL, NULL, '2025-06-21 00:42:49', '2025-06-21 00:42:49'),
(3403, '9f34afd2-a1d6-4cdb-9baa-5921fcb2e9e9', 2, 3, 395, 'hospital_schedules', 'messages', 'جداول المستشفى', 'active', NULL, NULL, '2025-06-21 00:42:49', '2025-06-21 00:42:49'),
(3404, '9f34afd2-a3fe-4b69-b1fc-69a6a9b0adc3', 2, 3, 396, 'plan_expire_notifications', 'messages', 'إشعار انتهاء صلاحية الخطة (بالأيام)', 'active', NULL, NULL, '2025-06-21 00:42:49', '2025-06-21 00:42:49'),
(3405, '9f34afd2-a808-4b6f-bc4a-eb2454bb3d90', 2, 3, NULL, 'login', 'messages', 'تسجيل الدخول', 'active', NULL, NULL, '2025-06-21 00:42:49', '2025-06-21 00:42:49'),
(3406, '9f34afd2-ac23-4c01-a175-d73d026f7aca', 2, 3, NULL, 'registration', 'messages', 'تسجيل', 'active', NULL, NULL, '2025-06-21 00:42:49', '2025-06-21 00:42:49'),
(3407, '9f34afd2-ae59-4f16-97ba-5427d25f7ae6', 2, 3, 371, 'facebook_url', 'messages', 'URL الفيسبوك', 'active', NULL, NULL, '2025-06-21 00:42:49', '2025-06-21 00:42:49'),
(3408, '9f34afd2-b045-45b8-9fa2-e461353608c9', 2, 3, 372, 'twitter_url', 'messages', 'عنوان URL لتويتر', 'active', NULL, NULL, '2025-06-21 00:42:49', '2025-06-21 00:42:49'),
(3409, '9f34afd2-b236-42c8-b390-c0dd06a6e0b3', 2, 3, 373, 'instagram_url', 'messages', 'URL انستغرام', 'active', NULL, NULL, '2025-06-21 00:42:49', '2025-06-21 00:42:49'),
(3410, '9f34afd2-b431-4565-8064-9b75a75a292e', 2, 3, 374, 'linkedIn_url', 'messages', 'لينكد إن لينكد إن', 'active', NULL, NULL, '2025-06-21 00:42:49', '2025-06-21 00:42:49'),
(3411, '9f34afd2-b64f-4f8b-af7e-da10130c8abd', 2, 3, 354, 'live_meetings', 'messages', 'اجتماعات مباشرة', 'active', NULL, NULL, '2025-06-21 00:42:49', '2025-06-21 00:42:49'),
(3412, '9f34afd2-b854-4b36-9c0d-1034f5396644', 2, 3, 385, 'file_name', 'messages', 'اسم الملف', 'active', NULL, NULL, '2025-06-21 00:42:49', '2025-06-21 00:42:49'),
(3413, '9f34afd2-ba4f-44c3-a32c-849c93c6417b', 2, 3, 368, 'short_description', 'messages', 'وصف قصير', 'active', NULL, NULL, '2025-06-21 00:42:49', '2025-06-21 00:42:49'),
(3414, '9f34afd2-bc4a-48db-883e-92c0ffd06a63', 2, 3, 369, 'icon', 'messages', 'أيقونة', 'active', NULL, NULL, '2025-06-21 00:42:49', '2025-06-21 00:42:49'),
(3415, '9f34afd2-be38-436d-8154-1151c2acbb25', 2, 3, 397, 'valid', 'messages', 'صالح', 'active', NULL, NULL, '2025-06-21 00:42:49', '2025-06-21 00:42:49'),
(3416, '9f34afd2-c040-4bd6-b78b-07aa99473221', 2, 3, 398, 'paytm', 'messages', 'بايتم', 'active', NULL, NULL, '2025-06-21 00:42:49', '2025-06-21 00:42:49'),
(3417, '9f34afd2-c233-4db6-becc-9c898e77e906', 2, 3, 399, 'appointment_charge', 'messages', 'رسوم التعيين', 'active', NULL, NULL, '2025-06-21 00:42:49', '2025-06-21 00:42:49'),
(3418, '9f34afd2-c442-4bfc-bfaa-a28fb84cb279', 2, 3, 400, 'manual_billing_payments', 'messages', 'دفع الفواتير يدوياً', 'active', NULL, NULL, '2025-06-21 00:42:49', '2025-06-21 00:42:49'),
(3419, '9f34afd2-c669-4118-9ea1-68ec92cebb38', 2, 3, 401, 'faq', 'messages', 'التعليمات', 'active', NULL, NULL, '2025-06-21 00:42:49', '2025-06-21 00:42:49'),
(3420, '9f34afd2-c874-41a9-a33c-83542b2989e9', 2, 3, 402, 'paid', 'messages', 'مدفوع', 'active', NULL, NULL, '2025-06-21 00:42:49', '2025-06-21 00:42:49'),
(3421, '9f34afd2-ca7b-4d1d-bf76-ed6af31dd4e8', 2, 3, 403, 'unpaid', 'messages', 'غير مدفوع', 'active', NULL, NULL, '2025-06-21 00:42:49', '2025-06-21 00:42:49'),
(3422, '9f34afd2-cdd5-4c38-b3b1-029968dd7fbd', 2, 3, 404, 'hospital_type', 'messages', 'نوع المستشفى', 'active', NULL, NULL, '2025-06-21 00:42:49', '2025-06-21 00:42:49'),
(3423, '9f34afd2-d015-4877-bc8e-db36f485228d', 2, 3, 405, 'minutes', 'messages', 'الدقائق', 'active', NULL, NULL, '2025-06-21 00:42:49', '2025-06-21 00:42:49'),
(3424, '9f34afd2-d20f-464b-8c46-e1cb04b94ec8', 2, 3, 406, 'hours', 'messages', 'ساعات', 'active', NULL, NULL, '2025-06-21 00:42:49', '2025-06-21 00:42:49'),
(3425, '9f34afd2-d420-4875-9461-68adb90661bc', 2, 3, 408, 'language.Arabic', 'messages', 'عربي', 'active', NULL, NULL, '2025-06-21 00:42:49', '2025-06-21 00:42:49'),
(3426, '9f34afd2-d622-407f-832f-20502752a419', 2, 3, 409, 'language.Chinese', 'messages', 'صينى', 'active', NULL, NULL, '2025-06-21 00:42:49', '2025-06-21 00:42:49'),
(3427, '9f34afd2-d82d-481d-a125-c5a490ee7805', 2, 3, 410, 'language.English', 'messages', 'إنجليزي', 'active', NULL, NULL, '2025-06-21 00:42:49', '2025-06-21 00:42:49'),
(3428, '9f34afd2-da48-40dd-85ea-a87d9fa13dca', 2, 3, 411, 'language.French', 'messages', 'فرنسي', 'active', NULL, NULL, '2025-06-21 00:42:49', '2025-06-21 00:42:49'),
(3429, '9f34afd2-dc45-47e9-a48a-ef11485517d4', 2, 3, 412, 'language.German', 'messages', 'ألمانية', 'active', NULL, NULL, '2025-06-21 00:42:49', '2025-06-21 00:42:49'),
(3430, '9f34afd2-de4b-4f92-8b5c-fa6d0b69c8a6', 2, 3, 413, 'language.Portuguese', 'messages', 'البرتغالية', 'active', NULL, NULL, '2025-06-21 00:42:49', '2025-06-21 00:42:49'),
(3431, '9f34afd2-e043-4841-a808-8ae1ca457f59', 2, 3, 414, 'language.Russian', 'messages', 'الروسية', 'active', NULL, NULL, '2025-06-21 00:42:49', '2025-06-21 00:42:49'),
(3432, '9f34afd2-e24d-4800-b18a-228ff1a1b06e', 2, 3, 415, 'language.Spanish', 'messages', 'الأسبانية', 'active', NULL, NULL, '2025-06-21 00:42:49', '2025-06-21 00:42:49'),
(3433, '9f34afd2-e452-439e-8956-9d4729753d5d', 2, 3, 416, 'language.Turkish', 'messages', 'اللغة التركية', 'active', NULL, NULL, '2025-06-21 00:42:49', '2025-06-21 00:42:49'),
(3434, '9f34afd2-e662-4c20-8924-348128728501', 2, 3, 417, 'admin_user.new_admin', 'messages', 'المشرف الجديد', 'active', NULL, NULL, '2025-06-21 00:42:49', '2025-06-21 00:42:49'),
(3435, '9f34afd2-e889-4155-a270-a2b29f091873', 2, 3, 418, 'admin_user.admin_saved_successfully', 'messages', 'حفظ المسؤول بنجاح', 'active', NULL, NULL, '2025-06-21 00:42:49', '2025-06-21 00:42:49'),
(3436, '9f34afd2-ea94-4004-a537-ce8314e75271', 2, 3, 419, 'admin_user.admin_updated_successfully', 'messages', 'تم تحديث المسؤول بنجاح', 'active', NULL, NULL, '2025-06-21 00:42:49', '2025-06-21 00:42:49'),
(3437, '9f34afd2-eccf-4ded-be1b-f785ccc38752', 2, 3, 420, 'admin_user.admin_deleted_successfully', 'messages', 'تم حذف المسؤول بنجاح', 'active', NULL, NULL, '2025-06-21 00:42:49', '2025-06-21 00:42:49'),
(3438, '9f34afd2-eed3-4efb-9be1-ddcf87144efb', 2, 3, 421, 'role.new_role', 'messages', 'دور جديد', 'active', NULL, NULL, '2025-06-21 00:42:49', '2025-06-21 00:42:49'),
(3439, '9f34afd2-f0e3-418d-9a94-c5b202951bdd', 2, 3, 422, 'role.edit_role', 'messages', 'تحرير الدور', 'active', NULL, NULL, '2025-06-21 00:42:49', '2025-06-21 00:42:49'),
(3440, '9f34afd2-f2ed-49f2-a7dd-f05ae4374484', 2, 3, 423, 'role.admin', 'messages', 'مسؤل', 'active', NULL, NULL, '2025-06-21 00:42:49', '2025-06-21 00:42:49'),
(3441, '9f34afd2-f50b-4964-b277-895b57140a0b', 2, 3, 424, 'role.doctor', 'messages', 'طبيب', 'active', NULL, NULL, '2025-06-21 00:42:49', '2025-06-21 00:42:49'),
(3442, '9f34afd2-f73e-4f10-8087-bad6a4fdee9c', 2, 3, 425, 'role.patient', 'messages', 'صبور', 'active', NULL, NULL, '2025-06-21 00:42:49', '2025-06-21 00:42:49'),
(3443, '9f34afd2-f960-43d2-9181-f25fb7e16948', 2, 3, 426, 'role.nurse', 'messages', 'ممرضة', 'active', NULL, NULL, '2025-06-21 00:42:49', '2025-06-21 00:42:49'),
(3444, '9f34afd2-fb7c-4f61-ac5d-648d8c57535e', 2, 3, 427, 'role.receptionist', 'messages', 'موظف الإستقبال', 'active', NULL, NULL, '2025-06-21 00:42:49', '2025-06-21 00:42:49'),
(3445, '9f34afd2-fd92-42c0-9687-89128550b191', 2, 3, 428, 'role.pharmacist', 'messages', 'صيدلاني', 'active', NULL, NULL, '2025-06-21 00:42:49', '2025-06-21 00:42:49'),
(3446, '9f34afd2-ffb8-4e46-a9a0-2f1e17863df8', 2, 3, 429, 'role.accountant', 'messages', 'محاسب', 'active', NULL, NULL, '2025-06-21 00:42:49', '2025-06-21 00:42:49'),
(3447, '9f34afd3-01d7-4443-bf59-403d995c1c75', 2, 3, 430, 'role.case_manager', 'messages', 'مدير الحالة', 'active', NULL, NULL, '2025-06-21 00:42:49', '2025-06-21 00:42:49'),
(3448, '9f34afd3-03e4-41d7-8fa0-c7e161185294', 2, 3, 431, 'role.lab_technician', 'messages', 'فني مختبر', 'active', NULL, NULL, '2025-06-21 00:42:49', '2025-06-21 00:42:49'),
(3449, '9f34afd3-05f1-4e42-aa94-de6c23092af4', 2, 3, 432, 'filter.all', 'messages', 'الجميع', 'active', NULL, NULL, '2025-06-21 00:42:49', '2025-06-21 00:42:49'),
(3450, '9f34afd3-0801-41a0-8bcc-57b143a26e19', 2, 3, 433, 'filter.active', 'messages', 'نشيط', 'active', NULL, NULL, '2025-06-21 00:42:49', '2025-06-21 00:42:49'),
(3451, '9f34afd3-0a1e-47ef-b989-d694faaa053c', 2, 3, 434, 'filter.deactive', 'messages', 'معطل', 'active', NULL, NULL, '2025-06-21 00:42:49', '2025-06-21 00:42:49'),
(3452, '9f34afd3-0c17-47a7-b82b-a392105a5361', 2, 3, 435, 'filter.inactive', 'messages', 'غير نشط', 'active', NULL, NULL, '2025-06-21 00:42:49', '2025-06-21 00:42:49'),
(3453, '9f34afd3-0e3d-4d8e-955d-6b636e1062e4', 2, 3, 436, 'user.first_name', 'messages', 'الاسم الاول', 'active', NULL, NULL, '2025-06-21 00:42:49', '2025-06-21 00:42:49'),
(3454, '9f34afd3-1050-4763-874d-3a81b89c4571', 2, 3, 437, 'user.last_name', 'messages', 'الكنية', 'active', NULL, NULL, '2025-06-21 00:42:49', '2025-06-21 00:42:49'),
(3455, '9f34afd3-1259-4de3-a22a-515f501d33e7', 2, 3, 439, 'user.name', 'messages', 'اسم', 'active', NULL, NULL, '2025-06-21 00:42:49', '2025-06-21 00:42:49'),
(3456, '9f34afd3-1477-4b56-bb6f-d33a585b7fec', 2, 3, 440, 'user.email', 'messages', 'البريد الإلكتروني', 'active', NULL, NULL, '2025-06-21 00:42:49', '2025-06-21 00:42:49'),
(3457, '9f34afd3-16be-4f46-b6d9-37781616a7a5', 2, 3, 441, 'user.phone', 'messages', 'هاتف', 'active', NULL, NULL, '2025-06-21 00:42:49', '2025-06-21 00:42:49'),
(3458, '9f34afd3-18e0-4aa7-a688-6732d6d0c2bc', 2, 3, 442, 'user.designation', 'messages', 'تعيين', 'active', NULL, NULL, '2025-06-21 00:42:49', '2025-06-21 00:42:49'),
(3459, '9f34afd3-1aed-42ba-b74a-d725dd0fdd97', 2, 3, 443, 'user.gender', 'messages', 'جنس', 'active', NULL, NULL, '2025-06-21 00:42:49', '2025-06-21 00:42:49'),
(3460, '9f34afd3-1d05-46d7-a65f-2667ec00f919', 2, 3, 444, 'user.male', 'messages', 'ذكر', 'active', NULL, NULL, '2025-06-21 00:42:49', '2025-06-21 00:42:49'),
(3461, '9f34afd3-1f3d-42c5-a5c4-56106a8ca513', 2, 3, 445, 'user.female', 'messages', 'أنثى', 'active', NULL, NULL, '2025-06-21 00:42:49', '2025-06-21 00:42:49'),
(3462, '9f34afd3-2178-4182-9e94-03cae9cda13c', 2, 3, 446, 'user.qualification', 'messages', 'المؤهل', 'active', NULL, NULL, '2025-06-21 00:42:49', '2025-06-21 00:42:49'),
(3463, '9f34afd3-239d-46a2-9ccb-2a0e428e004f', 2, 3, 447, 'user.dob', 'messages', 'تاريخ الولادة', 'active', NULL, NULL, '2025-06-21 00:42:49', '2025-06-21 00:42:49'),
(3464, '9f34afd3-25b6-4c8c-8635-44daf6551241', 2, 3, 448, 'user.blood_group', 'messages', 'فصيلة الدم', 'active', NULL, NULL, '2025-06-21 00:42:49', '2025-06-21 00:42:49'),
(3465, '9f34afd3-27d4-40cb-9475-ebe03d720d64', 2, 3, 449, 'user.select_blood_group', 'messages', 'حدد فصيلة الدم', 'active', NULL, NULL, '2025-06-21 00:42:49', '2025-06-21 00:42:49'),
(3466, '9f34afd3-29ee-48de-b0a9-21f9847615dc', 2, 3, 452, 'user.password', 'messages', 'كلمه السر', 'active', NULL, NULL, '2025-06-21 00:42:49', '2025-06-21 00:42:49'),
(3467, '9f34afd3-2c04-461a-ad73-1c30b9fb7b46', 2, 3, 453, 'user.password_confirmation', 'messages', 'تأكيد كلمة المرور', 'active', NULL, NULL, '2025-06-21 00:42:49', '2025-06-21 00:42:49'),
(3468, '9f34afd3-2e21-44da-9463-59f2f2fc61a4', 2, 3, 454, 'user.address1', 'messages', 'العنوان 1', 'active', NULL, NULL, '2025-06-21 00:42:49', '2025-06-21 00:42:49'),
(3469, '9f34afd3-3036-4aab-ac2d-262baa3f8e9e', 2, 3, 455, 'user.address2', 'messages', 'العنوان 2', 'active', NULL, NULL, '2025-06-21 00:42:49', '2025-06-21 00:42:49'),
(3470, '9f34afd3-324d-484d-a4c3-490781506678', 2, 3, 456, 'user.city', 'messages', 'مدينة', 'active', NULL, NULL, '2025-06-21 00:42:49', '2025-06-21 00:42:49'),
(3471, '9f34afd3-3469-488c-9f81-09519894edf2', 2, 3, 457, 'user.zip', 'messages', 'الرمز البريدي', 'active', NULL, NULL, '2025-06-21 00:42:49', '2025-06-21 00:42:49');
INSERT INTO `ltu_phrases` (`id`, `uuid`, `translation_id`, `translation_file_id`, `phrase_id`, `key`, `group`, `value`, `status`, `parameters`, `note`, `created_at`, `updated_at`) VALUES
(3472, '9f34afd3-3688-4c4c-b453-22a6e9d4f814', 2, 3, 458, 'user.address_details', 'messages', 'تفاصيل العنوان', 'active', NULL, NULL, '2025-06-21 00:42:49', '2025-06-21 00:42:49'),
(3473, '9f34afd3-3897-419c-b6fb-55ff3bb1ee0a', 2, 3, 459, 'user.address_not_found', 'messages', 'لم يتم العثور على تفاصيل العنوان', 'active', NULL, NULL, '2025-06-21 00:42:49', '2025-06-21 00:42:49'),
(3474, '9f34afd3-3abb-412b-b165-a8187ac1dcd4', 2, 3, 460, 'user.education', 'messages', 'التعليم', 'active', NULL, NULL, '2025-06-21 00:42:49', '2025-06-21 00:42:49'),
(3475, '9f34afd3-3cfe-4093-ab72-fb852e9a1027', 2, 3, 461, 'user.status', 'messages', 'الحالة', 'active', NULL, NULL, '2025-06-21 00:42:49', '2025-06-21 00:42:49'),
(3476, '9f34afd3-3f30-46d7-9842-ce95d3c1612d', 2, 3, 462, 'user.edit_profile', 'messages', 'تعديل الملف الشخصي', 'active', NULL, NULL, '2025-06-21 00:42:49', '2025-06-21 00:42:49'),
(3477, '9f34afd3-4149-4c80-a3cf-b1ca653e539b', 2, 3, 463, 'user.change_password', 'messages', 'تغيير كلمة السر', 'active', NULL, NULL, '2025-06-21 00:42:49', '2025-06-21 00:42:49'),
(3478, '9f34afd3-436f-44e5-820d-ce6adc207f69', 2, 3, 464, 'user.logout', 'messages', 'تسجيل خروج', 'active', NULL, NULL, '2025-06-21 00:42:49', '2025-06-21 00:42:49'),
(3479, '9f34afd3-45a7-43a8-852f-a98beb2ad74b', 2, 3, 465, 'user.new_user', 'messages', 'مستخدم جديد', 'active', NULL, NULL, '2025-06-21 00:42:49', '2025-06-21 00:42:49'),
(3480, '9f34afd3-47de-42eb-a84c-f74c413ee1da', 2, 3, 466, 'user.edit_user', 'messages', 'تحرير العضو', 'active', NULL, NULL, '2025-06-21 00:42:49', '2025-06-21 00:42:49'),
(3481, '9f34afd3-4a4d-4de6-924e-b2ce6c976928', 2, 3, 467, 'user.user_details', 'messages', 'بيانات المستخدم', 'active', NULL, NULL, '2025-06-21 00:42:49', '2025-06-21 00:42:49'),
(3482, '9f34afd3-4c77-4af4-988f-617ed5247666', 2, 3, 468, 'user.email_verified', 'messages', 'تم التحقق من البريد الإلكتروني', 'active', NULL, NULL, '2025-06-21 00:42:49', '2025-06-21 00:42:49'),
(3483, '9f34afd3-4ea8-4b98-8857-84b590402828', 2, 3, 469, 'user.email_not_verified', 'messages', 'لم يتم التحقق من البريد الإلكتروني', 'active', NULL, NULL, '2025-06-21 00:42:49', '2025-06-21 00:42:49'),
(3484, '9f34afd3-50d4-43c0-aa0e-7787f49d95c4', 2, 3, 470, 'user.back_to_admin', 'messages', 'العودة إلى المشرف المتميز', 'active', NULL, NULL, '2025-06-21 00:42:49', '2025-06-21 00:42:49'),
(3485, '9f34afd3-542d-4b32-a212-f8b7697e28f6', 2, 3, 471, 'user.hospital_slug', 'messages', 'سبيكة مستشفى', 'active', NULL, NULL, '2025-06-21 00:42:49', '2025-06-21 00:42:49'),
(3486, '9f34afd3-5662-44ad-acdb-770df2f7e1ab', 2, 3, 472, 'user.enter_hospital_name', 'messages', 'أدخل اسم المستشفى', 'active', NULL, NULL, '2025-06-21 00:42:49', '2025-06-21 00:42:49'),
(3487, '9f34afd3-5862-4875-b1d3-a0891f874518', 2, 3, 473, 'user.enter_hospital_slug', 'messages', 'أدخل سبيكة المستشفى', 'active', NULL, NULL, '2025-06-21 00:42:49', '2025-06-21 00:42:49'),
(3488, '9f34afd3-5a7e-4bd0-9287-4443d7eb081b', 2, 3, 474, 'user.enter_email', 'messages', 'أدخل البريد الإلكتروني', 'active', NULL, NULL, '2025-06-21 00:42:49', '2025-06-21 00:42:49'),
(3489, '9f34afd3-5ca2-485b-ad84-69210b37d9db', 2, 3, 450, 'user.select_donor_name', 'messages', 'اختر اسم المتبرع', 'active', NULL, NULL, '2025-06-21 00:42:49', '2025-06-21 00:42:49'),
(3490, '9f34afd3-5ebb-4dd1-84f5-ea1673af0b71', 2, 3, 451, 'user.select_patient_name', 'messages', 'حدد اسم المريض', 'active', NULL, NULL, '2025-06-21 00:42:49', '2025-06-21 00:42:49'),
(3491, '9f34afd3-60d5-4f92-8aca-fda95557dd6e', 2, 3, 438, 'user.username', 'messages', 'اسم المستخدم', 'active', NULL, NULL, '2025-06-21 00:42:49', '2025-06-21 00:42:49'),
(3492, '9f34afd3-62f4-4a35-a229-fdb32b4b135b', 2, 3, 482, 'common.default_country_code', 'messages', 'رمز البلد الافتراضي', 'active', NULL, NULL, '2025-06-21 00:42:49', '2025-06-21 00:42:49'),
(3493, '9f34afd3-6561-4e48-ab79-ff7f16d365bf', 2, 3, 483, 'common.profile', 'messages', 'الملف الشخصي', 'active', NULL, NULL, '2025-06-21 00:42:49', '2025-06-21 00:42:49'),
(3494, '9f34afd3-6781-4d9b-bdd9-0b1c5318141b', 2, 3, 485, 'common.status', 'messages', 'الحالة', 'active', NULL, NULL, '2025-06-21 00:42:49', '2025-06-21 00:42:49'),
(3495, '9f34afd3-69c3-426b-8dd5-07c3f436898c', 2, 3, 486, 'common.action', 'messages', 'عمل', 'active', NULL, NULL, '2025-06-21 00:42:49', '2025-06-21 00:42:49'),
(3496, '9f34afd3-6be8-41c9-bb8f-b22e3ff3bc98', 2, 3, 487, 'common.save', 'messages', 'حفظ', 'active', NULL, NULL, '2025-06-21 00:42:49', '2025-06-21 00:42:49'),
(3497, '9f34afd3-6e05-4132-8e86-e71f39665b7f', 2, 3, 488, 'common.cancel', 'messages', 'إلغاء', 'active', NULL, NULL, '2025-06-21 00:42:49', '2025-06-21 00:42:49'),
(3498, '9f34afd3-706d-459d-9bff-36178e14d35e', 2, 3, 489, 'common.canceled', 'messages', 'ألغيت', 'active', NULL, NULL, '2025-06-21 00:42:49', '2025-06-21 00:42:49'),
(3499, '9f34afd3-72b3-4efe-ac86-e2f30d272003', 2, 3, 490, 'common.confirm', 'messages', 'تؤكد', 'active', NULL, NULL, '2025-06-21 00:42:49', '2025-06-21 00:42:49'),
(3500, '9f34afd3-74e2-47d0-a495-ebc651706377', 2, 3, 491, 'common.back', 'messages', 'عودة', 'active', NULL, NULL, '2025-06-21 00:42:49', '2025-06-21 00:42:49'),
(3501, '9f34afd3-76fe-4f74-ad58-c28f58a5ca69', 2, 3, 492, 'common.created_on', 'messages', 'تم إنشاؤها على', 'active', NULL, NULL, '2025-06-21 00:42:49', '2025-06-21 00:42:49'),
(3502, '9f34afd3-791b-4862-8d05-422cf99c139f', 2, 3, 493, 'common.updated_on', 'messages', 'تم التحديث بتاريخ', 'active', NULL, NULL, '2025-06-21 00:42:49', '2025-06-21 00:42:49'),
(3503, '9f34afd3-7b73-498f-ad4b-010391d57cdc', 2, 3, 494, 'common.last_updated', 'messages', 'آخر تحديث', 'active', NULL, NULL, '2025-06-21 00:42:49', '2025-06-21 00:42:49'),
(3504, '9f34afd3-7dab-4d2d-b0c3-a4013a79c395', 2, 3, 495, 'common.n/a', 'messages', 'لا يوجد', 'active', NULL, NULL, '2025-06-21 00:42:49', '2025-06-21 00:42:49'),
(3505, '9f34afd3-7fcd-4f5b-b915-1f855baabb18', 2, 3, 496, 'common.new', 'messages', 'جديد', 'active', NULL, NULL, '2025-06-21 00:42:49', '2025-06-21 00:42:49'),
(3506, '9f34afd3-81ed-4ea5-9459-b1b971d21c55', 2, 3, 497, 'common.total', 'messages', 'المجموع', 'active', NULL, NULL, '2025-06-21 00:42:49', '2025-06-21 00:42:49'),
(3507, '9f34afd3-840f-4e5a-9c8a-50bb979df16d', 2, 3, 498, 'common.add', 'messages', 'أضف', 'active', NULL, NULL, '2025-06-21 00:42:49', '2025-06-21 00:42:49'),
(3508, '9f34afd3-8620-4ca4-aec8-8a90ab28615f', 2, 3, 499, 'common.active', 'messages', 'نشيط', 'active', NULL, NULL, '2025-06-21 00:42:49', '2025-06-21 00:42:49'),
(3509, '9f34afd3-8850-44b3-9294-4f984bae04b6', 2, 3, 500, 'common.deactive', 'messages', 'غير نشط', 'active', NULL, NULL, '2025-06-21 00:42:49', '2025-06-21 00:42:49'),
(3510, '9f34afd3-8a74-4b14-a9cf-97027b473b14', 2, 3, 501, 'common.name', 'messages', 'اسم', 'active', NULL, NULL, '2025-06-21 00:42:49', '2025-06-21 00:42:49'),
(3511, '9f34afd3-8ca4-4d6d-9396-9c7a8b44eae5', 2, 3, 502, 'common.edit', 'messages', 'تعديل', 'active', NULL, NULL, '2025-06-21 00:42:49', '2025-06-21 00:42:49'),
(3512, '9f34afd3-9070-47bf-b9e9-2f2d9257757b', 2, 3, 503, 'common.delete', 'messages', 'حذف', 'active', NULL, NULL, '2025-06-21 00:42:49', '2025-06-21 00:42:49'),
(3513, '9f34afd3-92d4-4654-a981-9a4dc2d91cc2', 2, 3, 504, 'common.view', 'messages', 'رأي', 'active', NULL, NULL, '2025-06-21 00:42:49', '2025-06-21 00:42:49'),
(3514, '9f34afd3-9500-4668-b359-2f5b5a8399ce', 2, 3, 505, 'common.view_attachment', 'messages', 'عرض المرفقات', 'active', NULL, NULL, '2025-06-21 00:42:49', '2025-06-21 00:42:49'),
(3515, '9f34afd3-9729-4a06-85d9-4fcfe29a0b1c', 2, 3, 506, 'common.de_active', 'messages', 'غير نشط', 'active', NULL, NULL, '2025-06-21 00:42:49', '2025-06-21 00:42:49'),
(3516, '9f34afd3-9989-4401-a2e2-fd261de6b3f0', 2, 3, 507, 'common.description', 'messages', 'وصف', 'active', NULL, NULL, '2025-06-21 00:42:49', '2025-06-21 00:42:49'),
(3517, '9f34afd3-9bcc-4c4e-acbc-57e8cb7bcac1', 2, 3, 508, 'common.created_at', 'messages', 'تم إنشاؤها على', 'active', NULL, NULL, '2025-06-21 00:42:49', '2025-06-21 00:42:49'),
(3518, '9f34afd3-9e0a-4105-9b80-73f532159333', 2, 3, 509, 'common.updated_at', 'messages', 'آخر تحديث', 'active', NULL, NULL, '2025-06-21 00:42:49', '2025-06-21 00:42:49'),
(3519, '9f34afd3-a039-4dcb-a8fd-23a8d876acdc', 2, 3, 510, 'common.is_available', 'messages', 'متاح', 'active', NULL, NULL, '2025-06-21 00:42:49', '2025-06-21 00:42:49'),
(3520, '9f34afd3-a25b-40a6-ae5c-fa8607cc4fde', 2, 3, 511, 'common.choose', 'messages', 'أختر', 'active', NULL, NULL, '2025-06-21 00:42:49', '2025-06-21 00:42:49'),
(3521, '9f34afd3-a483-4722-a4f0-84cb9c878352', 2, 3, 512, 'common.yes', 'messages', 'نعم', 'active', NULL, NULL, '2025-06-21 00:42:49', '2025-06-21 00:42:49'),
(3522, '9f34afd3-a6a0-47aa-869b-aa555288a96f', 2, 3, 513, 'common.no', 'messages', 'لا', 'active', NULL, NULL, '2025-06-21 00:42:49', '2025-06-21 00:42:49'),
(3523, '9f34afd3-a8c4-4449-a99e-07a176d7f85e', 2, 3, 514, 'common.address', 'messages', 'عنوان', 'active', NULL, NULL, '2025-06-21 00:42:49', '2025-06-21 00:42:49'),
(3524, '9f34afd3-ab14-4045-8852-894afa4e0c1e', 2, 3, 515, 'common.export_to_excel', 'messages', 'تصدير الى اكسل', 'active', NULL, NULL, '2025-06-21 00:42:50', '2025-06-21 00:42:50'),
(3525, '9f34afd3-ad46-41ba-a626-40758c8816a6', 2, 3, 516, 'common.reset', 'messages', 'إعادة ضبط', 'active', NULL, NULL, '2025-06-21 00:42:50', '2025-06-21 00:42:50'),
(3526, '9f34afd3-af84-48c7-bb60-5163aa9eec0e', 2, 3, 517, 'common.actions', 'messages', 'أجراءات', 'active', NULL, NULL, '2025-06-21 00:42:50', '2025-06-21 00:42:50'),
(3527, '9f34afd3-b376-4ddb-876d-942e70527eb8', 2, 3, NULL, 'common.live_meetings', 'messages', 'اجتماعات مباشرة', 'active', NULL, NULL, '2025-06-21 00:42:50', '2025-06-21 00:42:50'),
(3528, '9f34afd3-b607-4920-8f06-ed45bded85ba', 2, 3, 533, 'common.search', 'messages', 'بحث', 'active', NULL, NULL, '2025-06-21 00:42:50', '2025-06-21 00:42:50'),
(3529, '9f34afd3-b862-4706-82f5-6e1f1438827b', 2, 3, 534, 'common.no_matching_records_found', 'messages', 'لم يتم العثور على سجلات مطابقة', 'active', NULL, NULL, '2025-06-21 00:42:50', '2025-06-21 00:42:50'),
(3530, '9f34afd3-ba9b-4dcb-8691-15f4a8535ed8', 2, 3, 531, 'common.no_data_available', 'messages', 'لا توجد بيانات متوفرة في الجدول', 'active', NULL, NULL, '2025-06-21 00:42:50', '2025-06-21 00:42:50'),
(3531, '9f34afd3-bccd-4f94-94e6-5fc850c6c179', 2, 3, 535, 'common.custom', 'messages', 'العادة', 'active', NULL, NULL, '2025-06-21 00:42:50', '2025-06-21 00:42:50'),
(3532, '9f34afd3-bef5-4c1d-8c06-a412a3364a1c', 2, 3, 536, 'common.apply', 'messages', 'يتقدم', 'active', NULL, NULL, '2025-06-21 00:42:50', '2025-06-21 00:42:50'),
(3533, '9f34afd3-c17f-4d95-b1d3-0954673754cb', 2, 3, 537, 'common.from', 'messages', 'من', 'active', NULL, NULL, '2025-06-21 00:42:50', '2025-06-21 00:42:50'),
(3534, '9f34afd3-c3e7-40f0-b95c-759b52a7e37b', 2, 3, 538, 'common.to', 'messages', 'إلى', 'active', NULL, NULL, '2025-06-21 00:42:50', '2025-06-21 00:42:50'),
(3535, '9f34afd3-c61d-4310-ac59-b701e194eec6', 2, 3, 484, 'common.post_image', 'messages', 'صورة المنشور', 'active', NULL, NULL, '2025-06-21 00:42:50', '2025-06-21 00:42:50'),
(3536, '9f34afd3-c846-428f-aaed-edd90362b13f', 2, 3, 539, 'common.invalid_number', 'messages', 'رقم غير صالح', 'active', NULL, NULL, '2025-06-21 00:42:50', '2025-06-21 00:42:50'),
(3537, '9f34afd3-ca78-4aec-91f6-fd1977a110fb', 2, 3, 540, 'common.invalid_country_code', 'messages', 'رمز الدولة غير صحيح', 'active', NULL, NULL, '2025-06-21 00:42:50', '2025-06-21 00:42:50'),
(3538, '9f34afd3-ccb1-4887-ac14-67541e32dc77', 2, 3, 541, 'common.too_short', 'messages', 'قصير جدا', 'active', NULL, NULL, '2025-06-21 00:42:50', '2025-06-21 00:42:50'),
(3539, '9f34afd3-ceec-4e3a-8813-cdc27f8da448', 2, 3, 542, 'common.too_long', 'messages', 'طويل جدا', 'active', NULL, NULL, '2025-06-21 00:42:50', '2025-06-21 00:42:50'),
(3540, '9f34afd3-d129-4e7c-9bdb-a0fc0a0f38db', 2, 3, 543, 'common.undefined', 'messages', 'غير معرف', 'active', NULL, NULL, '2025-06-21 00:42:50', '2025-06-21 00:42:50'),
(3541, '9f34afd3-d35e-45b6-999a-671e2671ceff', 2, 3, 544, 'common.not_found', 'messages', 'لم يتم العثور على', 'active', NULL, NULL, '2025-06-21 00:42:50', '2025-06-21 00:42:50'),
(3542, '9f34afd3-d58c-458b-8be2-06d727a2597f', 2, 3, 519, 'common.select_status', 'messages', 'اختر ولايه', 'active', NULL, NULL, '2025-06-21 00:42:50', '2025-06-21 00:42:50'),
(3543, '9f34afd3-d7af-434e-af58-a6a159186f2f', 2, 3, 520, 'common.showing', 'messages', 'تبين', 'active', NULL, NULL, '2025-06-21 00:42:50', '2025-06-21 00:42:50'),
(3544, '9f34afd3-d9ec-4799-95c5-81f07fb397ad', 2, 3, 521, 'common.of', 'messages', 'من', 'active', NULL, NULL, '2025-06-21 00:42:50', '2025-06-21 00:42:50'),
(3545, '9f34afd3-dc21-4f5c-bcc0-74bfef4bb129', 2, 3, 522, 'common.results', 'messages', 'نتيجة', 'active', NULL, NULL, '2025-06-21 00:42:50', '2025-06-21 00:42:50'),
(3546, '9f34afd3-de5a-4cba-8bc6-b4b29c6493b0', 2, 3, 523, 'common.show', 'messages', 'برنامج', 'active', NULL, NULL, '2025-06-21 00:42:50', '2025-06-21 00:42:50'),
(3547, '9f34afd3-e1f9-4e60-bebe-c28c3f950e94', 2, 3, 524, 'common.previous', 'messages', 'سابق', 'active', NULL, NULL, '2025-06-21 00:42:50', '2025-06-21 00:42:50'),
(3548, '9f34afd3-e454-40ee-9a09-866a71096246', 2, 3, 525, 'common.next', 'messages', 'التالي', 'active', NULL, NULL, '2025-06-21 00:42:50', '2025-06-21 00:42:50'),
(3549, '9f34afd3-e692-450c-a0cf-0c09fdc4fe3f', 2, 3, 532, 'common.allow_img_text', 'messages', 'أنواع الملفات المسموح بها: png، jpg، jpeg، svg.', 'active', NULL, NULL, '2025-06-21 00:42:50', '2025-06-21 00:42:50'),
(3550, '9f34afd3-e8d6-43c9-858f-dab8ccef28ac', 2, 3, 526, 'common.default_plan', 'messages', 'الخطة الافتراضية', 'active', NULL, NULL, '2025-06-21 00:42:50', '2025-06-21 00:42:50'),
(3551, '9f34afd3-eb4a-43c7-a225-5aed1777fd76', 2, 3, 527, 'common.select_type', 'messages', 'اختر صنف', 'active', NULL, NULL, '2025-06-21 00:42:50', '2025-06-21 00:42:50'),
(3552, '9f34afd3-ed8a-4db5-9490-b71430286c03', 2, 3, 528, 'common.select_type_number', 'messages', 'اختر نموذجا', 'active', NULL, NULL, '2025-06-21 00:42:50', '2025-06-21 00:42:50'),
(3553, '9f34afd3-efc8-4f38-ae7d-c62dbe46ee96', 2, 3, 518, 'common.filter_options', 'messages', 'خيارات التصفية', 'active', NULL, NULL, '2025-06-21 00:42:50', '2025-06-21 00:42:50'),
(3554, '9f34afd3-f221-40b1-9915-15a1b82dfd8e', 2, 3, 546, 'common.status_updated_successfully', 'messages', 'تم تحديث الحالة بنجاح.', 'active', NULL, NULL, '2025-06-21 00:42:50', '2025-06-21 00:42:50'),
(3555, '9f34afd3-f453-4f9f-8a42-875c419085d5', 2, 3, 547, 'common.saved_successfully', 'messages', 'حفظ بنجاح.', 'active', NULL, NULL, '2025-06-21 00:42:50', '2025-06-21 00:42:50'),
(3556, '9f34afd3-f691-43fc-9c23-de85e061b6e3', 2, 3, 548, 'common.updated_successfully', 'messages', 'تم التحديث بنجاح', 'active', NULL, NULL, '2025-06-21 00:42:50', '2025-06-21 00:42:50'),
(3557, '9f34afd3-f8ac-4968-abfd-61db0be87800', 2, 3, 549, 'common.deleted_successfully', 'messages', 'حذف بنجاح', 'active', NULL, NULL, '2025-06-21 00:42:50', '2025-06-21 00:42:50'),
(3558, '9f34afd3-fae9-459b-a3db-23800949a839', 2, 3, 550, 'common.are_you_sure_want_to_delete_this', 'messages', 'هل تريد بالتأكيد حذف هذا ', 'active', NULL, NULL, '2025-06-21 00:42:50', '2025-06-21 00:42:50'),
(3559, '9f34afd3-fd11-4240-a3db-3c569c4358e4', 2, 3, 551, 'common.deleted', 'messages', 'تم الحذف', 'active', NULL, NULL, '2025-06-21 00:42:50', '2025-06-21 00:42:50'),
(3560, '9f34afd3-ff59-405d-bff9-735b306d46b4', 2, 3, 552, 'common.has_been_deleted', 'messages', 'قد تم حذف.', 'active', NULL, NULL, '2025-06-21 00:42:50', '2025-06-21 00:42:50'),
(3561, '9f34afd4-01a7-49a6-9a24-dbcc5860a6ec', 2, 3, 553, 'common.cant_be_deleted', 'messages', 'لا يمكن حذفها', 'active', NULL, NULL, '2025-06-21 00:42:50', '2025-06-21 00:42:50'),
(3562, '9f34afd4-03ec-4dc6-bd0b-2ea081ee3a35', 2, 3, 554, 'common.ok', 'messages', 'موافق', 'active', NULL, NULL, '2025-06-21 00:42:50', '2025-06-21 00:42:50'),
(3563, '9f34afd4-0644-4416-9d18-cfd3739de883', 2, 3, 555, 'common.this_action_is_not_allowed_for_default_record', 'messages', 'هذا الإجراء غير مسموح به للسجل الافتراضي.', 'active', NULL, NULL, '2025-06-21 00:42:50', '2025-06-21 00:42:50'),
(3564, '9f34afd4-08a5-46d9-9f05-bd104f515fe5', 2, 3, 556, 'common.please_enter_valid_facebook_url', 'messages', 'الرجاء إدخال عنوان URL صالح للفيسبوك.', 'active', NULL, NULL, '2025-06-21 00:42:50', '2025-06-21 00:42:50'),
(3565, '9f34afd4-0adf-40cb-8605-d7a3450ed239', 2, 3, 557, 'common.please_enter_valid_twitter_url', 'messages', 'الرجاء إدخال عنوان URL صالح على Twitter.', 'active', NULL, NULL, '2025-06-21 00:42:50', '2025-06-21 00:42:50'),
(3566, '9f34afd4-0d2e-47dd-a31a-e62f234ec0cb', 2, 3, 558, 'common.please_enter_valid_linkedin_url', 'messages', 'الرجاء إدخال عنوان URL صالح لـ LinkedIn.', 'active', NULL, NULL, '2025-06-21 00:42:50', '2025-06-21 00:42:50'),
(3567, '9f34afd4-0f85-42fe-ade5-dcfb0b735dea', 2, 3, 559, 'common.please_enter_valid_Instagram_url', 'messages', 'يرجى إدخال عنوان URL صالح لـ Instagram', 'active', NULL, NULL, '2025-06-21 00:42:50', '2025-06-21 00:42:50'),
(3568, '9f34afd4-1223-47a9-bc3a-389339805be9', 2, 3, 560, 'common.select_payment', 'messages', 'حدد حالة الدفع', 'active', NULL, NULL, '2025-06-21 00:42:50', '2025-06-21 00:42:50'),
(3569, '9f34afd4-1481-4021-b096-7fa0ea59e447', 2, 3, 561, 'common.logged_in_successfully', 'messages', 'تم تسجيل الدخول بنجاح.', 'active', NULL, NULL, '2025-06-21 00:42:50', '2025-06-21 00:42:50'),
(3570, '9f34afd4-16c1-43e4-a04b-eb648b0f6795', 2, 3, 562, 'common.logout_successfully', 'messages', 'تم تسجيل الخروج بنجاح.', 'active', NULL, NULL, '2025-06-21 00:42:50', '2025-06-21 00:42:50'),
(3571, '9f34afd4-18f7-43b5-a131-9b9a5c844e70', 2, 3, 563, 'common.we_have_your_password_resetk_link', 'messages', 'لقد قمنا بإرسال رابط إعادة تعيين كلمة المرور إلى بريدك الإلكتروني!', 'active', NULL, NULL, '2025-06-21 00:42:50', '2025-06-21 00:42:50'),
(3572, '9f34afd4-1b30-464a-9c18-700120e0e63c', 2, 3, 564, 'common.we_cant_find_user', 'messages', 'لا يمكننا العثور على مستخدم بهذا البريد الإلكتروني.', 'active', NULL, NULL, '2025-06-21 00:42:50', '2025-06-21 00:42:50'),
(3573, '9f34afd4-1d83-4406-8f07-e5f6b73ee081', 2, 3, 565, 'common.this_password_reset_token_is_invalid', 'messages', 'رمز إعادة تعيين كلمة المرور هذا غير صالح.', 'active', NULL, NULL, '2025-06-21 00:42:50', '2025-06-21 00:42:50'),
(3574, '9f34afd4-1fcb-4426-a85b-ab5439f52a68', 2, 3, 566, 'common.password_reset_successfully', 'messages', 'تم إعادة تعيين كلمة المرور بنجاح.', 'active', NULL, NULL, '2025-06-21 00:42:50', '2025-06-21 00:42:50'),
(3575, '9f34afd4-220b-49ec-a405-e888d351c0c5', 2, 3, 567, 'common.please_enter_correct_old_password', 'messages', 'يرجى إدخال كلمة المرور القديمة الصحيحة.', 'active', NULL, NULL, '2025-06-21 00:42:50', '2025-06-21 00:42:50'),
(3576, '9f34afd4-2440-4d7b-a826-ce0c06d88312', 2, 3, 568, 'common.password_updated', 'messages', 'لقد تم تحديث كلمة المرور الخاصة بك بنجاح.', 'active', NULL, NULL, '2025-06-21 00:42:50', '2025-06-21 00:42:50'),
(3577, '9f34afd4-26c4-40dd-b4bd-126ef36e79a2', 2, 3, 569, 'common.doctor_scheduled', 'messages', 'تم جدولة الطبيب.', 'active', NULL, NULL, '2025-06-21 00:42:50', '2025-06-21 00:42:50'),
(3578, '9f34afd4-2933-4c5e-a7a9-655906dfc91f', 2, 3, 570, 'common.patient_registered_successfully', 'messages', 'تم تسجيل المريض بنجاح.', 'active', NULL, NULL, '2025-06-21 00:42:50', '2025-06-21 00:42:50'),
(3579, '9f34afd4-2bb5-4655-a91c-6b7d44d1e59c', 2, 3, 571, 'common.appointment_confirmed_successfully', 'messages', 'تم تأكيد الموعد بنجاح.', 'active', NULL, NULL, '2025-06-21 00:42:50', '2025-06-21 00:42:50'),
(3580, '9f34afd4-2e28-4473-b63b-45de57908eb0', 2, 3, 572, 'common.bed_assigned_successfully', 'messages', 'تم تعيين السرير بنجاح.', 'active', NULL, NULL, '2025-06-21 00:42:50', '2025-06-21 00:42:50'),
(3581, '9f34afd4-3095-48ca-981e-214cc7d61167', 2, 3, 573, 'common.username_and_password_required', 'messages', 'اسم المستخدم وكلمة المرور مطلوبين.', 'active', NULL, NULL, '2025-06-21 00:42:50', '2025-06-21 00:42:50'),
(3582, '9f34afd4-32f9-4722-9db4-6bb6d854c154', 2, 3, 574, 'common.meeting_finished_or_cancelled', 'messages', 'انتهت هذا الاجتماع أو تم إلغاؤه.', 'active', NULL, NULL, '2025-06-21 00:42:50', '2025-06-21 00:42:50'),
(3583, '9f34afd4-3553-44a3-a653-8e01b41c86f1', 2, 3, 575, 'common.something_want_wrong', 'messages', 'حدث خطأ ما.', 'active', NULL, NULL, '2025-06-21 00:42:50', '2025-06-21 00:42:50'),
(3584, '9f34afd4-3797-40f8-9967-2888d6b6f7a6', 2, 3, 578, 'common.invalid_username_password', 'messages', 'خطأ في اسم المستخدم أو كلمة مرور', 'active', NULL, NULL, '2025-06-21 00:42:50', '2025-06-21 00:42:50'),
(3585, '9f34afd4-39f0-4a5c-b8d3-8952060be476', 2, 3, 579, 'common.appointment_transaction', 'messages', 'معاملة التعيين', 'active', NULL, NULL, '2025-06-21 00:42:50', '2025-06-21 00:42:50'),
(3586, '9f34afd4-3c83-4693-83cf-a880d970d0d5', 2, 3, 580, 'common.no_data_found', 'messages', 'لم يتم العثور على بيانات', 'active', NULL, NULL, '2025-06-21 00:42:50', '2025-06-21 00:42:50'),
(3587, '9f34afd4-3ec8-4539-875c-5c6b1e1d05b2', 2, 3, 581, 'common.is_already_exists', 'messages', 'موجود بالفعل', 'active', NULL, NULL, '2025-06-21 00:42:50', '2025-06-21 00:42:50'),
(3588, '9f34afd4-4141-4fc8-ad93-e50a5cc6ad29', 2, 3, 582, 'common.close', 'messages', 'يغلق', 'active', NULL, NULL, '2025-06-21 00:42:50', '2025-06-21 00:42:50'),
(3589, '9f34afd4-4398-4dd0-b1bf-aae27193ca29', 2, 3, 529, 'common.filter', 'messages', 'فلتر', 'active', NULL, NULL, '2025-06-21 00:42:50', '2025-06-21 00:42:50'),
(3590, '9f34afd4-45cf-481e-afb2-c5e5091317d8', 2, 3, 530, 'common.user_details', 'messages', 'مستخدم', 'active', NULL, NULL, '2025-06-21 00:42:50', '2025-06-21 00:42:50'),
(3591, '9f34afd4-4819-4d04-addd-fb52028c4f66', 2, 3, 545, 'common.no data available in table', 'messages', 'لا توجد بيانات متوفرة في الجدول', 'active', NULL, NULL, '2025-06-21 00:42:50', '2025-06-21 00:42:50'),
(3592, '9f34afd4-4a3d-4210-b1c7-b0f4aa5c644f', 2, 3, 576, 'common.cancelled_successfully', 'messages', 'تم إلغاؤه بنجاح', 'active', NULL, NULL, '2025-06-21 00:42:50', '2025-06-21 00:42:50'),
(3593, '9f34afd4-4ca5-4e62-9f24-325df3518bd9', 2, 3, 577, 'common.not_updated', 'messages', 'لم يتم تحديثه', 'active', NULL, NULL, '2025-06-21 00:42:50', '2025-06-21 00:42:50'),
(3594, '9f34afd4-4ef8-4c93-b8d0-423c893e3fc7', 2, 3, 583, 'months.jan', 'messages', 'يناير', 'active', NULL, NULL, '2025-06-21 00:42:50', '2025-06-21 00:42:50'),
(3595, '9f34afd4-5120-436c-b31f-d4ef19e86467', 2, 3, 584, 'months.feb', 'messages', 'شهر فبراير', 'active', NULL, NULL, '2025-06-21 00:42:50', '2025-06-21 00:42:50'),
(3596, '9f34afd4-5366-45fb-b5b0-5af3b681f584', 2, 3, 585, 'months.mar', 'messages', 'يمشي', 'active', NULL, NULL, '2025-06-21 00:42:50', '2025-06-21 00:42:50'),
(3597, '9f34afd4-559e-4fe0-81eb-6de87a8bc73e', 2, 3, 586, 'months.apr', 'messages', 'أبريل', 'active', NULL, NULL, '2025-06-21 00:42:50', '2025-06-21 00:42:50'),
(3598, '9f34afd4-5805-4644-b699-19780f2bbabf', 2, 3, 587, 'months.may', 'messages', 'مايو', 'active', NULL, NULL, '2025-06-21 00:42:50', '2025-06-21 00:42:50'),
(3599, '9f34afd4-5a58-4072-9b7a-47abdbe5993c', 2, 3, 588, 'months.jun', 'messages', 'يونيه', 'active', NULL, NULL, '2025-06-21 00:42:50', '2025-06-21 00:42:50'),
(3600, '9f34afd4-5cbb-4747-b8f2-8088454d2a52', 2, 3, 589, 'months.jul', 'messages', 'يوليو', 'active', NULL, NULL, '2025-06-21 00:42:50', '2025-06-21 00:42:50'),
(3601, '9f34afd4-5f06-45f7-b6a0-d2f1f822d31f', 2, 3, 590, 'months.aug', 'messages', 'أغسطس', 'active', NULL, NULL, '2025-06-21 00:42:50', '2025-06-21 00:42:50'),
(3602, '9f34afd4-6155-4cfc-86c8-d079bb260e64', 2, 3, 591, 'months.sep', 'messages', 'سبتمبر', 'active', NULL, NULL, '2025-06-21 00:42:50', '2025-06-21 00:42:50'),
(3603, '9f34afd4-640b-4733-9128-4bfbba58d6c5', 2, 3, 592, 'months.oct', 'messages', 'اكتوبر', 'active', NULL, NULL, '2025-06-21 00:42:50', '2025-06-21 00:42:50'),
(3604, '9f34afd4-6672-4051-917c-5d797f8792a0', 2, 3, 593, 'months.nov', 'messages', 'شهر نوفمبر', 'active', NULL, NULL, '2025-06-21 00:42:50', '2025-06-21 00:42:50'),
(3605, '9f34afd4-68c4-4d57-bfbb-1a8cd333934d', 2, 3, 594, 'months.dec', 'messages', 'ديسمبر', 'active', NULL, NULL, '2025-06-21 00:42:50', '2025-06-21 00:42:50'),
(3606, '9f34afd4-6b09-41ac-b53c-d98e8c1e683c', 2, 3, 595, 'weekdays.sun', 'messages', 'الشمس', 'active', NULL, NULL, '2025-06-21 00:42:50', '2025-06-21 00:42:50'),
(3607, '9f34afd4-6edc-4881-8507-93e6707d6b93', 2, 3, 596, 'weekdays.mon', 'messages', 'العالمية', 'active', NULL, NULL, '2025-06-21 00:42:50', '2025-06-21 00:42:50'),
(3608, '9f34afd4-7168-4d9a-ac2b-d92a8f197668', 2, 3, 597, 'weekdays.tue', 'messages', 'الثلاثاء', 'active', NULL, NULL, '2025-06-21 00:42:50', '2025-06-21 00:42:50'),
(3609, '9f34afd4-74e6-4599-83b1-b1c9a7b555c6', 2, 3, 598, 'weekdays.wed', 'messages', 'الأربعاء', 'active', NULL, NULL, '2025-06-21 00:42:50', '2025-06-21 00:42:50'),
(3610, '9f34afd4-776f-4173-9e33-57603124fa6d', 2, 3, 599, 'weekdays.thu', 'messages', 'الخميس', 'active', NULL, NULL, '2025-06-21 00:42:50', '2025-06-21 00:42:50'),
(3611, '9f34afd4-79c6-4220-bbb3-bcfb7d61b38f', 2, 3, 600, 'weekdays.fri', 'messages', 'جمهورية مقدونيا', 'active', NULL, NULL, '2025-06-21 00:42:50', '2025-06-21 00:42:50'),
(3612, '9f34afd4-7c14-4e38-883d-250cbbc8d92c', 2, 3, 601, 'weekdays.sat', 'messages', 'جلس', 'active', NULL, NULL, '2025-06-21 00:42:50', '2025-06-21 00:42:50'),
(3613, '9f34afd4-7e5e-44c2-906e-06fb308b1e29', 2, 3, 602, 'receptionist.receptionist', 'messages', 'موظف الإستقبال', 'active', NULL, NULL, '2025-06-21 00:42:50', '2025-06-21 00:42:50'),
(3614, '9f34afd4-80c5-4633-9430-94b419fa5961', 2, 3, 603, 'receptionist.receptionists', 'messages', 'موظف الإستقبال', 'active', NULL, NULL, '2025-06-21 00:42:50', '2025-06-21 00:42:50'),
(3615, '9f34afd4-8338-4444-8644-a86dd4d8852f', 2, 3, 604, 'receptionist.receptionist_details', 'messages', 'تفاصيل موظف الاستقبال', 'active', NULL, NULL, '2025-06-21 00:42:50', '2025-06-21 00:42:50'),
(3616, '9f34afd4-85b3-4bad-b0bb-537b035ba571', 2, 3, 605, 'receptionist.new_receptionist', 'messages', 'موظف استقبال جديد', 'active', NULL, NULL, '2025-06-21 00:42:50', '2025-06-21 00:42:50'),
(3617, '9f34afd4-881e-4954-b08b-de50d2e736b2', 2, 3, 606, 'receptionist.edit_receptionist', 'messages', 'تحرير موظف استقبال', 'active', NULL, NULL, '2025-06-21 00:42:50', '2025-06-21 00:42:50'),
(3618, '9f34afd4-8a73-43ad-87e5-de9d5c2e2d90', 2, 3, 607, 'insurance.insurance', 'messages', 'تأمين', 'active', NULL, NULL, '2025-06-21 00:42:50', '2025-06-21 00:42:50'),
(3619, '9f34afd4-8d17-4686-8341-3bd1126e0e34', 2, 3, 608, 'insurance.insurances', 'messages', 'تأمين', 'active', NULL, NULL, '2025-06-21 00:42:50', '2025-06-21 00:42:50'),
(3620, '9f34afd4-8f5c-453f-a4b1-a26c4230d2d0', 2, 3, 609, 'insurance.insurance_details', 'messages', 'تفاصيل التأمين', 'active', NULL, NULL, '2025-06-21 00:42:50', '2025-06-21 00:42:50'),
(3621, '9f34afd4-91b4-48d4-bc78-c447e710e4b9', 2, 3, 610, 'insurance.new_insurance', 'messages', 'تأمين جديد', 'active', NULL, NULL, '2025-06-21 00:42:50', '2025-06-21 00:42:50'),
(3622, '9f34afd4-9401-44d3-b651-75f6df6400bb', 2, 3, 611, 'insurance.edit_insurance', 'messages', 'تحرير التأمين', 'active', NULL, NULL, '2025-06-21 00:42:50', '2025-06-21 00:42:50'),
(3623, '9f34afd4-965d-456a-872a-24bd76dca9c0', 2, 3, 612, 'insurance.service_tax', 'messages', 'ضريبة الخدمة', 'active', NULL, NULL, '2025-06-21 00:42:50', '2025-06-21 00:42:50'),
(3624, '9f34afd4-98ab-4d62-aaec-f6190097ae44', 2, 3, 613, 'insurance.insurance_no', 'messages', 'رقم التأمين', 'active', NULL, NULL, '2025-06-21 00:42:50', '2025-06-21 00:42:50'),
(3625, '9f34afd4-9afc-4f58-b805-f12c50535803', 2, 3, 614, 'insurance.insurance_code', 'messages', 'قانون التأمين', 'active', NULL, NULL, '2025-06-21 00:42:50', '2025-06-21 00:42:50'),
(3626, '9f34afd4-9d52-4980-b0d6-ad310ac75ac6', 2, 3, 615, 'insurance.hospital_rate', 'messages', 'معدل المستشفى', 'active', NULL, NULL, '2025-06-21 00:42:50', '2025-06-21 00:42:50'),
(3627, '9f34afd4-9f94-4883-8e9a-56fe4a555606', 2, 3, 616, 'insurance.discount', 'messages', 'خصم', 'active', NULL, NULL, '2025-06-21 00:42:50', '2025-06-21 00:42:50'),
(3628, '9f34afd4-a1e6-454e-be6c-9c8b9925204b', 2, 3, 617, 'insurance.remark', 'messages', 'ملاحظة', 'active', NULL, NULL, '2025-06-21 00:42:50', '2025-06-21 00:42:50'),
(3629, '9f34afd4-a438-4038-9101-0ccbf62e658d', 2, 3, 618, 'insurance.disease_details', 'messages', 'تفاصيل المرض', 'active', NULL, NULL, '2025-06-21 00:42:50', '2025-06-21 00:42:50'),
(3630, '9f34afd4-a67d-4575-90b4-92ab34fad5f4', 2, 3, 619, 'insurance.diseases_name', 'messages', 'اسم الأمراض', 'active', NULL, NULL, '2025-06-21 00:42:50', '2025-06-21 00:42:50'),
(3631, '9f34afd4-a8d3-4e88-8720-7cae2f6f36f1', 2, 3, 620, 'insurance.diseases_charge', 'messages', 'رسوم الأمراض', 'active', NULL, NULL, '2025-06-21 00:42:50', '2025-06-21 00:42:50'),
(3632, '9f34afd4-ab48-4398-8c20-98aeed3cde77', 2, 3, 621, 'insurance.total_amount', 'messages', 'المبلغ الإجمالي', 'active', NULL, NULL, '2025-06-21 00:42:50', '2025-06-21 00:42:50'),
(3633, '9f34afd4-ad9f-422a-85b0-3a2f224bc38d', 2, 3, 622, 'doctor_department.doctor_departments', 'messages', 'أقسام الطبيب', 'active', NULL, NULL, '2025-06-21 00:42:50', '2025-06-21 00:42:50'),
(3634, '9f34afd4-afee-499b-9d90-dcf610a02442', 2, 3, 623, 'doctor_department.doctor_department', 'messages', 'قسم الطبيب', 'active', NULL, NULL, '2025-06-21 00:42:50', '2025-06-21 00:42:50'),
(3635, '9f34afd4-b24e-4010-ae4e-07f6c9c427e9', 2, 3, 624, 'doctor_department.doctor_department_details', 'messages', 'تفاصيل قسم الطبيب', 'active', NULL, NULL, '2025-06-21 00:42:50', '2025-06-21 00:42:50'),
(3636, '9f34afd4-b4db-45b2-8274-c94eac5e6ded', 2, 3, 625, 'doctor_department.new_doctor_department', 'messages', 'قسم الأطباء الجديد', 'active', NULL, NULL, '2025-06-21 00:42:50', '2025-06-21 00:42:50'),
(3637, '9f34afd4-b728-4cf0-bcbf-ea680af18215', 2, 3, 626, 'doctor_department.edit_doctor_department', 'messages', 'تعديل قسم الطبيب', 'active', NULL, NULL, '2025-06-21 00:42:50', '2025-06-21 00:42:50'),
(3638, '9f34afd4-b97c-4819-b215-648f6a6b78da', 2, 3, 627, 'doctor_department.title', 'messages', 'عنوان', 'active', NULL, NULL, '2025-06-21 00:42:50', '2025-06-21 00:42:50'),
(3639, '9f34afd4-bbe1-4dc1-94eb-900e1ec4e0ff', 2, 3, 628, 'doctor_department.description', 'messages', 'وصف', 'active', NULL, NULL, '2025-06-21 00:42:50', '2025-06-21 00:42:50'),
(3640, '9f34afd4-be32-42a0-8a19-f0a3821a8b04', 2, 3, 629, 'investigation_report.investigation_reports', 'messages', 'تقارير التحقيق', 'active', NULL, NULL, '2025-06-21 00:42:50', '2025-06-21 00:42:50'),
(3641, '9f34afd4-c07b-45ff-aa55-ef5e2574de1c', 2, 3, 630, 'investigation_report.investigation_report', 'messages', 'تقرير التحقيق', 'active', NULL, NULL, '2025-06-21 00:42:50', '2025-06-21 00:42:50'),
(3642, '9f34afd4-c2c7-4b33-8ca3-7e56f8a7d9c8', 2, 3, 632, 'investigation_report.new_investigation_report', 'messages', 'تقرير تحقيق جديد', 'active', NULL, NULL, '2025-06-21 00:42:50', '2025-06-21 00:42:50'),
(3643, '9f34afd4-c51a-4e23-98e4-b74be0e91360', 2, 3, 631, 'investigation_report.investigation_report_details', 'messages', 'تفاصيل تقرير التحقيق', 'active', NULL, NULL, '2025-06-21 00:42:50', '2025-06-21 00:42:50'),
(3644, '9f34afd4-c778-4aa7-9055-fc5d803bd77a', 2, 3, 633, 'investigation_report.edit_investigation_report', 'messages', 'تحرير تقرير التحقيق', 'active', NULL, NULL, '2025-06-21 00:42:50', '2025-06-21 00:42:50'),
(3645, '9f34afd4-c9d5-4035-a960-a9fba64f31fd', 2, 3, 634, 'investigation_report.patient', 'messages', 'صبور', 'active', NULL, NULL, '2025-06-21 00:42:50', '2025-06-21 00:42:50'),
(3646, '9f34afd4-cc38-4860-b293-1bae173f455b', 2, 3, 635, 'investigation_report.date', 'messages', 'تاريخ', 'active', NULL, NULL, '2025-06-21 00:42:50', '2025-06-21 00:42:50'),
(3647, '9f34afd4-ce7b-4c7c-a446-5302694baf41', 2, 3, 636, 'investigation_report.title', 'messages', 'عنوان', 'active', NULL, NULL, '2025-06-21 00:42:50', '2025-06-21 00:42:50'),
(3648, '9f34afd4-d0c8-4df6-8e3c-80be131e63b1', 2, 3, 637, 'investigation_report.doctor', 'messages', 'عنوان', 'active', NULL, NULL, '2025-06-21 00:42:50', '2025-06-21 00:42:50'),
(3649, '9f34afd4-d36c-4320-931d-199972117f04', 2, 3, 638, 'investigation_report.description', 'messages', 'وصف', 'active', NULL, NULL, '2025-06-21 00:42:50', '2025-06-21 00:42:50'),
(3650, '9f34afd4-d5dc-47a9-b058-512ed7b639de', 2, 3, 639, 'investigation_report.attachment', 'messages', 'المرفق', 'active', NULL, NULL, '2025-06-21 00:42:50', '2025-06-21 00:42:50'),
(3651, '9f34afd4-d83b-41dc-a28c-cbad57142824', 2, 3, 640, 'investigation_report.solved', 'messages', 'تم حلها', 'active', NULL, NULL, '2025-06-21 00:42:50', '2025-06-21 00:42:50'),
(3652, '9f34afd4-daa6-4ceb-94d6-e3ae537163dd', 2, 3, 641, 'investigation_report.not_solved', 'messages', 'غير محلول', 'active', NULL, NULL, '2025-06-21 00:42:50', '2025-06-21 00:42:50'),
(3653, '9f34afd4-dd61-4d04-b09e-ba205ff6c2db', 2, 3, 642, 'pharmacist.new_pharmacist', 'messages', 'صيدلي جديد', 'active', NULL, NULL, '2025-06-21 00:42:50', '2025-06-21 00:42:50'),
(3654, '9f34afd4-dfdb-4847-81f2-57b964fca57a', 2, 3, 643, 'pharmacist.edit_pharmacist', 'messages', 'تحرير صيدلي', 'active', NULL, NULL, '2025-06-21 00:42:50', '2025-06-21 00:42:50'),
(3655, '9f34afd4-e22d-4e53-8c1e-215072754e26', 2, 3, 644, 'pharmacist.pharmacists', 'messages', 'الصيادلة', 'active', NULL, NULL, '2025-06-21 00:42:50', '2025-06-21 00:42:50'),
(3656, '9f34afd4-e48b-4f5e-99f0-4e3120e7ce48', 2, 3, 645, 'pharmacist.pharmacist_details', 'messages', 'تفاصيل الصيدلي', 'active', NULL, NULL, '2025-06-21 00:42:50', '2025-06-21 00:42:50'),
(3657, '9f34afd4-e6df-410a-a68e-0b4f5faae68b', 2, 3, 646, 'death_report.death_report', 'messages', 'تقرير الوفاة', 'active', NULL, NULL, '2025-06-21 00:42:50', '2025-06-21 00:42:50'),
(3658, '9f34afd4-e93a-4e96-8ac8-ae969a58dd05', 2, 3, 647, 'death_report.death_reports', 'messages', 'تقارير الوفاة', 'active', NULL, NULL, '2025-06-21 00:42:50', '2025-06-21 00:42:50'),
(3659, '9f34afd4-ebc6-4969-bf22-ad2b92c94fa0', 2, 3, 648, 'death_report.new_death_report', 'messages', 'تقرير وفاة جديد', 'active', NULL, NULL, '2025-06-21 00:42:50', '2025-06-21 00:42:50'),
(3660, '9f34afd4-ee24-46a5-bff7-e98f476956d4', 2, 3, 649, 'death_report.edit_death_report', 'messages', 'تحرير تقرير الوفاة', 'active', NULL, NULL, '2025-06-21 00:42:50', '2025-06-21 00:42:50'),
(3661, '9f34afd4-f09a-4200-9166-f2721a7da359', 2, 3, 650, 'death_report.death_report_details', 'messages', 'تفاصيل تقرير الوفاة', 'active', NULL, NULL, '2025-06-21 00:42:50', '2025-06-21 00:42:50'),
(3662, '9f34afd4-f2ef-46e6-ba0f-a5fe1936d374', 2, 3, 651, 'death_report.patient_name', 'messages', 'اسم المريض', 'active', NULL, NULL, '2025-06-21 00:42:50', '2025-06-21 00:42:50'),
(3663, '9f34afd4-f56b-485f-ab98-b8e9217dd199', 2, 3, 652, 'death_report.case_id', 'messages', 'ID القضية', 'active', NULL, NULL, '2025-06-21 00:42:50', '2025-06-21 00:42:50'),
(3664, '9f34afd4-f7d5-49d3-a51f-b955b0c6925f', 2, 3, 653, 'death_report.doctor_name', 'messages', 'اسم الطبيب', 'active', NULL, NULL, '2025-06-21 00:42:50', '2025-06-21 00:42:50'),
(3665, '9f34afd4-fa37-40d0-9334-21e3e5e3e671', 2, 3, 654, 'death_report.date', 'messages', 'تاريخ', 'active', NULL, NULL, '2025-06-21 00:42:50', '2025-06-21 00:42:50'),
(3666, '9f34afd4-fcc7-461c-a2ef-9b0fee18c951', 2, 3, 655, 'death_report.description', 'messages', 'وصف', 'active', NULL, NULL, '2025-06-21 00:42:50', '2025-06-21 00:42:50'),
(3667, '9f34afd4-ff1f-4edd-a313-fa91d16e9313', 2, 3, 656, 'birth_report.birth_report', 'messages', 'تقرير الميلاد', 'active', NULL, NULL, '2025-06-21 00:42:50', '2025-06-21 00:42:50'),
(3668, '9f34afd5-0185-4568-9417-8e7c86a5c150', 2, 3, 657, 'birth_report.birth_reports', 'messages', 'تقارير الميلاد', 'active', NULL, NULL, '2025-06-21 00:42:50', '2025-06-21 00:42:50'),
(3669, '9f34afd5-041a-42e6-83fc-fc8ec59b1b14', 2, 3, 658, 'birth_report.birth_report_details', 'messages', 'تفاصيل تقرير الولادة', 'active', NULL, NULL, '2025-06-21 00:42:50', '2025-06-21 00:42:50'),
(3670, '9f34afd5-06b8-4eba-85bb-4e8e760d29f5', 2, 3, 659, 'birth_report.new_birth_report', 'messages', 'تقرير الميلاد الجديد', 'active', NULL, NULL, '2025-06-21 00:42:50', '2025-06-21 00:42:50'),
(3671, '9f34afd5-0923-4e0a-b4ac-55eae506ae47', 2, 3, 660, 'birth_report.edit_birth_report', 'messages', 'تحرير تقرير الميلاد', 'active', NULL, NULL, '2025-06-21 00:42:50', '2025-06-21 00:42:50'),
(3672, '9f34afd5-0cbf-4d72-b0bf-e8ac47f4abea', 2, 3, 661, 'birth_report.patient_name', 'messages', 'اسم المريض', 'active', NULL, NULL, '2025-06-21 00:42:50', '2025-06-21 00:42:50'),
(3673, '9f34afd5-0f42-4cef-b95c-508a051a50a6', 2, 3, 662, 'birth_report.case_id', 'messages', 'ID القضية', 'active', NULL, NULL, '2025-06-21 00:42:50', '2025-06-21 00:42:50'),
(3674, '9f34afd5-11bf-41be-b2ce-514b92f2f08c', 2, 3, 663, 'birth_report.doctor_name', 'messages', 'اسم الطبيب', 'active', NULL, NULL, '2025-06-21 00:42:50', '2025-06-21 00:42:50'),
(3675, '9f34afd5-1430-4039-b410-cfce58755e27', 2, 3, 664, 'birth_report.date', 'messages', 'تاريخ', 'active', NULL, NULL, '2025-06-21 00:42:50', '2025-06-21 00:42:50'),
(3676, '9f34afd5-16ae-4924-bdcf-9fa5c659d364', 2, 3, 665, 'birth_report.description', 'messages', 'وصف', 'active', NULL, NULL, '2025-06-21 00:42:50', '2025-06-21 00:42:50'),
(3677, '9f34afd5-193b-4687-8722-b8645e03e44f', 2, 3, 666, 'odontogram.odontogram', 'messages', 'مخطط الأسنان', 'active', NULL, NULL, '2025-06-21 00:42:50', '2025-06-21 00:42:50'),
(3678, '9f34afd5-1bb6-4175-bb03-45194e595f1b', 2, 3, 667, 'odontogram.odontograms', 'messages', 'مخططات الأسنان', 'active', NULL, NULL, '2025-06-21 00:42:50', '2025-06-21 00:42:50'),
(3679, '9f34afd5-1e2f-4f72-9c7a-3706c21d2a0e', 2, 3, 668, 'accountant.new_accountant', 'messages', 'محاسب جديد', 'active', NULL, NULL, '2025-06-21 00:42:50', '2025-06-21 00:42:50'),
(3680, '9f34afd5-209e-405c-b556-02cbddef5a21', 2, 3, 669, 'accountant.edit_accountant', 'messages', 'تحرير محاسب', 'active', NULL, NULL, '2025-06-21 00:42:50', '2025-06-21 00:42:50'),
(3681, '9f34afd5-2323-497e-9cf5-e2cbbaf0519b', 2, 3, 670, 'accountant.accountants', 'messages', 'المحاسبين', 'active', NULL, NULL, '2025-06-21 00:42:50', '2025-06-21 00:42:50'),
(3682, '9f34afd5-25b0-4756-b49a-0df575d54663', 2, 3, 671, 'accountant.accountant_details', 'messages', 'تفاصيل المحاسب', 'active', NULL, NULL, '2025-06-21 00:42:50', '2025-06-21 00:42:50'),
(3683, '9f34afd5-2816-4b0d-a02b-21907e8efdd7', 2, 3, 672, 'accountant.credit', 'messages', 'ائتمان', 'active', NULL, NULL, '2025-06-21 00:42:50', '2025-06-21 00:42:50'),
(3684, '9f34afd5-2a8a-428e-8a66-63b5296e3e00', 2, 3, 673, 'accountant.debit', 'messages', 'مدين', 'active', NULL, NULL, '2025-06-21 00:42:50', '2025-06-21 00:42:50'),
(3685, '9f34afd5-2d1e-44ba-83a9-cf1453d8ade4', 2, 3, 674, 'employee_payroll.employee_payroll', 'messages', 'كشوف مرتبات الموظفين', 'active', NULL, NULL, '2025-06-21 00:42:50', '2025-06-21 00:42:50'),
(3686, '9f34afd5-2fa5-46cc-9279-ddc9899b279e', 2, 3, 675, 'employee_payroll.employee_payrolls', 'messages', 'كشوف مرتبات الموظفين', 'active', NULL, NULL, '2025-06-21 00:42:50', '2025-06-21 00:42:50'),
(3687, '9f34afd5-321e-4b8f-908b-c317594f7b5a', 2, 3, 676, 'employee_payroll.employee_payroll_details', 'messages', 'تفاصيل رواتب الموظفين', 'active', NULL, NULL, '2025-06-21 00:42:51', '2025-06-21 00:42:51'),
(3688, '9f34afd5-3498-4fdd-ac8f-b035b3c58fba', 2, 3, 677, 'employee_payroll.new_employee_payroll', 'messages', 'رواتب الموظفين الجدد', 'active', NULL, NULL, '2025-06-21 00:42:51', '2025-06-21 00:42:51'),
(3689, '9f34afd5-3718-4d66-bab2-a82b4f2ac7c9', 2, 3, 678, 'employee_payroll.edit_employee_payroll', 'messages', 'تحرير رواتب الموظفين', 'active', NULL, NULL, '2025-06-21 00:42:51', '2025-06-21 00:42:51'),
(3690, '9f34afd5-397d-4160-a261-2f45ef495bba', 2, 3, 679, 'employee_payroll.sr_no', 'messages', 'الأب رقم', 'active', NULL, NULL, '2025-06-21 00:42:51', '2025-06-21 00:42:51'),
(3691, '9f34afd5-3c02-461b-adf0-786aa21b8b0f', 2, 3, 680, 'employee_payroll.payroll_id', 'messages', 'معرف الرواتب', 'active', NULL, NULL, '2025-06-21 00:42:51', '2025-06-21 00:42:51'),
(3692, '9f34afd5-3e76-40f8-b56a-eb5df73890c4', 2, 3, 681, 'employee_payroll.month', 'messages', 'شهر', 'active', NULL, NULL, '2025-06-21 00:42:51', '2025-06-21 00:42:51'),
(3693, '9f34afd5-40e5-4a22-bb25-1e6cec3e9a90', 2, 3, 682, 'employee_payroll.year', 'messages', 'عام', 'active', NULL, NULL, '2025-06-21 00:42:51', '2025-06-21 00:42:51'),
(3694, '9f34afd5-4372-467a-b5a2-61f95cf92420', 2, 3, 683, 'employee_payroll.role', 'messages', 'وظيفة', 'active', NULL, NULL, '2025-06-21 00:42:51', '2025-06-21 00:42:51'),
(3695, '9f34afd5-45e1-4afc-82b2-b135a2b2bb30', 2, 3, 684, 'employee_payroll.employee', 'messages', 'موظف', 'active', NULL, NULL, '2025-06-21 00:42:51', '2025-06-21 00:42:51'),
(3696, '9f34afd5-4872-458c-a291-03ff1e867f96', 2, 3, 685, 'employee_payroll.basic_salary', 'messages', 'راتب اساسي', 'active', NULL, NULL, '2025-06-21 00:42:51', '2025-06-21 00:42:51'),
(3697, '9f34afd5-4afe-4355-b2e8-51815613825d', 2, 3, 686, 'employee_payroll.allowance', 'messages', 'مخصص', 'active', NULL, NULL, '2025-06-21 00:42:51', '2025-06-21 00:42:51'),
(3698, '9f34afd5-4da6-4dec-a491-3f6e278b8748', 2, 3, 687, 'employee_payroll.deductions', 'messages', 'الخصومات', 'active', NULL, NULL, '2025-06-21 00:42:51', '2025-06-21 00:42:51'),
(3699, '9f34afd5-501c-41d5-b8f5-674315223764', 2, 3, 688, 'employee_payroll.net_salary', 'messages', 'صافي الراتب', 'active', NULL, NULL, '2025-06-21 00:42:51', '2025-06-21 00:42:51'),
(3700, '9f34afd5-52a1-48da-b5b2-898e050369c0', 2, 3, 689, 'employee_payroll.paid', 'messages', 'دفع', 'active', NULL, NULL, '2025-06-21 00:42:51', '2025-06-21 00:42:51'),
(3701, '9f34afd5-5540-4149-8058-e3939a95e464', 2, 3, 690, 'employee_payroll.not_paid', 'messages', 'غير مدفوع', 'active', NULL, NULL, '2025-06-21 00:42:51', '2025-06-21 00:42:51'),
(3702, '9f34afd5-57f3-41c0-954b-54f477739fb5', 2, 3, 691, 'employee_payroll.unpaid', 'messages', 'غير مدفوعة', 'active', NULL, NULL, '2025-06-21 00:42:51', '2025-06-21 00:42:51'),
(3703, '9f34afd5-5a7d-45d0-b6de-341e822983d1', 2, 3, 692, 'employee_payroll.employee_name', 'messages', 'اسم الموظف', 'active', NULL, NULL, '2025-06-21 00:42:51', '2025-06-21 00:42:51'),
(3704, '9f34afd5-5ce6-490f-b572-0b68ffb5eb04', 2, 3, 693, 'employee_payroll.select_employee', 'messages', 'حدد الموظف', 'active', NULL, NULL, '2025-06-21 00:42:51', '2025-06-21 00:42:51'),
(3705, '9f34afd5-5f55-4a4a-81c8-d7c1c7603ab3', 2, 3, 694, 'operation_report.operation_report', 'messages', 'تقرير العملية', 'active', NULL, NULL, '2025-06-21 00:42:51', '2025-06-21 00:42:51'),
(3706, '9f34afd5-61dc-4b7c-91fb-ecf57c62b67e', 2, 3, 695, 'operation_report.operation_reports', 'messages', 'تقارير التشغيل', 'active', NULL, NULL, '2025-06-21 00:42:51', '2025-06-21 00:42:51'),
(3707, '9f34afd5-6447-4288-a29d-624929b31fd2', 2, 3, 696, 'operation_report.operation_report_details', 'messages', 'تفاصيل تقرير العملية', 'active', NULL, NULL, '2025-06-21 00:42:51', '2025-06-21 00:42:51'),
(3708, '9f34afd5-66c5-4ade-90a2-95682e8df968', 2, 3, 697, 'operation_report.new_operation_report', 'messages', 'تقرير العملية الجديد', 'active', NULL, NULL, '2025-06-21 00:42:51', '2025-06-21 00:42:51'),
(3709, '9f34afd5-6942-4e2a-b948-ad6addeb3928', 2, 3, 698, 'operation_report.edit_operation_report', 'messages', 'تحرير تقرير العملية', 'active', NULL, NULL, '2025-06-21 00:42:51', '2025-06-21 00:42:51'),
(3710, '9f34afd5-6bb3-496d-8811-faea527473f1', 2, 3, 699, 'operation_report.patient_name', 'messages', 'اسم المريض', 'active', NULL, NULL, '2025-06-21 00:42:51', '2025-06-21 00:42:51'),
(3711, '9f34afd5-6e1e-488b-b695-4d820a38c669', 2, 3, 700, 'operation_report.case_id', 'messages', 'ID القضية', 'active', NULL, NULL, '2025-06-21 00:42:51', '2025-06-21 00:42:51'),
(3712, '9f34afd5-7215-45cc-a996-aeb71d3498fa', 2, 3, 701, 'operation_report.doctor_name', 'messages', 'اسم الطبيب', 'active', NULL, NULL, '2025-06-21 00:42:51', '2025-06-21 00:42:51'),
(3713, '9f34afd5-74d7-40ae-ad74-ecc8c4078765', 2, 3, 702, 'operation_report.date', 'messages', 'تاريخ', 'active', NULL, NULL, '2025-06-21 00:42:51', '2025-06-21 00:42:51'),
(3714, '9f34afd5-776d-4d5b-896e-68185bb8b183', 2, 3, 703, 'operation_report.description', 'messages', 'وصف', 'active', NULL, NULL, '2025-06-21 00:42:51', '2025-06-21 00:42:51'),
(3715, '9f34afd5-79f8-45f2-a67a-15e2f20debf6', 2, 3, 704, 'account.account', 'messages', 'الحساب', 'active', NULL, NULL, '2025-06-21 00:42:51', '2025-06-21 00:42:51'),
(3716, '9f34afd5-7c7d-4c9c-adc2-f922eed4976c', 2, 3, 705, 'account.accounts', 'messages', 'حسابات', 'active', NULL, NULL, '2025-06-21 00:42:51', '2025-06-21 00:42:51'),
(3717, '9f34afd5-7f2b-44eb-a68d-4211bb86b21f', 2, 3, 706, 'account.account_details', 'messages', 'تفاصيل الحساب', 'active', NULL, NULL, '2025-06-21 00:42:51', '2025-06-21 00:42:51'),
(3718, '9f34afd5-81c1-4f22-aa1a-70c48dc8619a', 2, 3, 707, 'account.new_account', 'messages', 'حساب جديد', 'active', NULL, NULL, '2025-06-21 00:42:51', '2025-06-21 00:42:51'),
(3719, '9f34afd5-8448-4b13-890b-cd4f5fc502ee', 2, 3, 708, 'account.edit_account', 'messages', 'تحرير الحساب', 'active', NULL, NULL, '2025-06-21 00:42:51', '2025-06-21 00:42:51'),
(3720, '9f34afd5-86e2-4ece-bec8-a83826146aac', 2, 3, 709, 'account.name', 'messages', 'اسم', 'active', NULL, NULL, '2025-06-21 00:42:51', '2025-06-21 00:42:51'),
(3721, '9f34afd5-897c-4a32-800b-035945d4e3ab', 2, 3, 710, 'account.description', 'messages', 'وصف', 'active', NULL, NULL, '2025-06-21 00:42:51', '2025-06-21 00:42:51'),
(3722, '9f34afd5-8c15-46b9-ab89-ceec419f5ea0', 2, 3, 711, 'account.type', 'messages', 'اكتب', 'active', NULL, NULL, '2025-06-21 00:42:51', '2025-06-21 00:42:51'),
(3723, '9f34afd5-8e95-4e0f-bc5a-69e038402a98', 2, 3, 712, 'account.status', 'messages', 'الحالة', 'active', NULL, NULL, '2025-06-21 00:42:51', '2025-06-21 00:42:51'),
(3724, '9f34afd5-9112-4565-9086-8f369b72841d', 2, 3, 713, 'account.payments', 'messages', 'المدفوعات', 'active', NULL, NULL, '2025-06-21 00:42:51', '2025-06-21 00:42:51'),
(3725, '9f34afd5-939c-44df-a499-a13bac0cccbc', 2, 3, 714, 'invoice.send_mail', 'messages', 'ارسل بريد', 'active', NULL, NULL, '2025-06-21 00:42:51', '2025-06-21 00:42:51'),
(3726, '9f34afd5-961d-4a58-9c59-8aceab47a84a', 2, 3, 715, 'invoice.invoice_id', 'messages', 'هوية صوتية', 'active', NULL, NULL, '2025-06-21 00:42:51', '2025-06-21 00:42:51'),
(3727, '9f34afd5-98be-40c4-bcdd-e7b72a0e8ed5', 2, 3, 716, 'invoice.invoice', 'messages', 'فاتورة', 'active', NULL, NULL, '2025-06-21 00:42:51', '2025-06-21 00:42:51'),
(3728, '9f34afd5-9b46-4c92-8e3d-89a6f35cd108', 2, 3, 717, 'invoice.invoices', 'messages', 'فواتير', 'active', NULL, NULL, '2025-06-21 00:42:51', '2025-06-21 00:42:51'),
(3729, '9f34afd5-9e90-44c8-9e53-69ff2851e004', 2, 3, 718, 'invoice.invoice_details', 'messages', 'تفاصيل الفاتورة', 'active', NULL, NULL, '2025-06-21 00:42:51', '2025-06-21 00:42:51'),
(3730, '9f34afd5-a397-4d3e-b283-9a58a6799c25', 2, 3, 719, 'invoice.new_invoice', 'messages', 'فاتورة جديدة', 'active', NULL, NULL, '2025-06-21 00:42:51', '2025-06-21 00:42:51'),
(3731, '9f34afd5-a659-4ffe-89a2-fccfcfd20f9e', 2, 3, 720, 'invoice.edit_invoice', 'messages', 'تحرير الفاتورة', 'active', NULL, NULL, '2025-06-21 00:42:51', '2025-06-21 00:42:51'),
(3732, '9f34afd5-a8dd-467a-95d1-066b19cab037', 2, 3, 721, 'invoice.patient', 'messages', 'صبور', 'active', NULL, NULL, '2025-06-21 00:42:51', '2025-06-21 00:42:51'),
(3733, '9f34afd5-ab82-435d-b7c0-7a6398db50e6', 2, 3, 722, 'invoice.invoice_date', 'messages', 'تاريخ الفاتورة', 'active', NULL, NULL, '2025-06-21 00:42:51', '2025-06-21 00:42:51'),
(3734, '9f34afd5-af91-4f50-91ec-3f32d55a5082', 2, 3, 723, 'invoice.amount', 'messages', 'كمية', 'active', NULL, NULL, '2025-06-21 00:42:51', '2025-06-21 00:42:51'),
(3735, '9f34afd5-b267-4264-90a9-4c71091d816f', 2, 3, 724, 'invoice.patient_id', 'messages', 'رقم المريض', 'active', NULL, NULL, '2025-06-21 00:42:51', '2025-06-21 00:42:51'),
(3736, '9f34afd5-b515-41c2-821a-0494f2d15a36', 2, 3, 725, 'invoice.discount', 'messages', 'خصم', 'active', NULL, NULL, '2025-06-21 00:42:51', '2025-06-21 00:42:51'),
(3737, '9f34afd5-b792-41f2-8325-3483929282c1', 2, 3, 726, 'invoice.account_name', 'messages', 'أسم الحساب', 'active', NULL, NULL, '2025-06-21 00:42:51', '2025-06-21 00:42:51'),
(3738, '9f34afd5-bbef-413e-8180-a09dcaf0e877', 2, 3, 727, 'invoice.description', 'messages', 'وصف', 'active', NULL, NULL, '2025-06-21 00:42:51', '2025-06-21 00:42:51'),
(3739, '9f34afd5-be62-446e-8f0d-6b80ee1280c6', 2, 3, 728, 'invoice.qty', 'messages', 'الكمية', 'active', NULL, NULL, '2025-06-21 00:42:51', '2025-06-21 00:42:51'),
(3740, '9f34afd5-c0ed-4e93-9000-2e3a5696245a', 2, 3, 729, 'invoice.price', 'messages', 'السعر', 'active', NULL, NULL, '2025-06-21 00:42:51', '2025-06-21 00:42:51'),
(3741, '9f34afd5-c49c-41e7-a5ae-a427d0d582cf', 2, 3, 730, 'invoice.add', 'messages', 'أضف', 'active', NULL, NULL, '2025-06-21 00:42:51', '2025-06-21 00:42:51'),
(3742, '9f34afd5-c838-46fa-a459-ec35d28ae88b', 2, 3, 731, 'invoice.sub_total', 'messages', 'المجموع الفرعي', 'active', NULL, NULL, '2025-06-21 00:42:51', '2025-06-21 00:42:51'),
(3743, '9f34afd5-cae0-4136-b836-24c8708e0cbc', 2, 3, 732, 'invoice.total', 'messages', 'المبلغ الإجمالي', 'active', NULL, NULL, '2025-06-21 00:42:51', '2025-06-21 00:42:51'),
(3744, '9f34afd5-cd83-41ef-8778-b6e01675a44c', 2, 3, 733, 'invoice.edit', 'messages', 'تعديل', 'active', NULL, NULL, '2025-06-21 00:42:51', '2025-06-21 00:42:51'),
(3745, '9f34afd5-d083-4f13-bdde-abf1edec64c6', 2, 3, 734, 'invoice.hospital_address', 'messages', 'عنوان المستشفى', 'active', NULL, NULL, '2025-06-21 00:42:51', '2025-06-21 00:42:51'),
(3746, '9f34afd5-d311-4ba6-a2c0-1030f2940dc6', 2, 3, 735, 'invoice.paid', 'messages', 'دفع', 'active', NULL, NULL, '2025-06-21 00:42:51', '2025-06-21 00:42:51'),
(3747, '9f34afd5-d5a6-4c47-8449-e623ccb0d570', 2, 3, 736, 'invoice.not_paid', 'messages', 'غير مدفوع', 'active', NULL, NULL, '2025-06-21 00:42:51', '2025-06-21 00:42:51'),
(3748, '9f34afd5-da36-4f79-ba09-3077bc768f58', 2, 3, 737, 'invoice.print_invoice', 'messages', 'طباعة الفاتورة', 'active', NULL, NULL, '2025-06-21 00:42:51', '2025-06-21 00:42:51');
INSERT INTO `ltu_phrases` (`id`, `uuid`, `translation_id`, `translation_file_id`, `phrase_id`, `key`, `group`, `value`, `status`, `parameters`, `note`, `created_at`, `updated_at`) VALUES
(3749, '9f34afd5-e085-4e74-a765-e4fe485978da', 2, 3, NULL, 'invoice.payment_term', 'messages', 'مصطلح الدفع', 'active', NULL, NULL, '2025-06-21 00:42:51', '2025-06-21 00:42:51'),
(3750, '9f34afd5-e5d6-48df-9ec8-c0effb833019', 2, 3, NULL, 'invoice.select_payment_term', 'messages', 'حدد مصطلح الدفع', 'active', NULL, NULL, '2025-06-21 00:42:51', '2025-06-21 00:42:51'),
(3751, '9f34afd5-eb4a-451e-afb0-2fc427b7bc94', 2, 3, NULL, 'invoice.bill_to', 'messages', 'مشروع قانون ل', 'active', NULL, NULL, '2025-06-21 00:42:51', '2025-06-21 00:42:51'),
(3752, '9f34afd5-ef4a-4e61-8ea7-371e58305c32', 2, 3, 738, 'nurse.new_nurse', 'messages', 'ممرضة جديدة', 'active', NULL, NULL, '2025-06-21 00:42:51', '2025-06-21 00:42:51'),
(3753, '9f34afd5-f22f-4196-bb6d-b458ebba3b3e', 2, 3, 739, 'nurse.edit_nurse', 'messages', 'تحرير ممرضة', 'active', NULL, NULL, '2025-06-21 00:42:51', '2025-06-21 00:42:51'),
(3754, '9f34afd5-f614-4ffb-9bd4-ec1dfe67934d', 2, 3, 740, 'nurse.nurse_details', 'messages', 'تفاصيل الممرضة', 'active', NULL, NULL, '2025-06-21 00:42:51', '2025-06-21 00:42:51'),
(3755, '9f34afd5-fa40-4604-8e94-0005def29539', 2, 3, 741, 'nurse.phone_no', 'messages', 'رقم الهاتف', 'active', NULL, NULL, '2025-06-21 00:42:51', '2025-06-21 00:42:51'),
(3756, '9f34afd5-fd97-4e6e-98c3-966d73259cc0', 2, 3, 742, 'nurse.birth_date', 'messages', 'تاريخ الميلاد', 'active', NULL, NULL, '2025-06-21 00:42:51', '2025-06-21 00:42:51'),
(3757, '9f34afd6-0019-4703-ad7a-09b6d237b3a2', 2, 3, 743, 'nurse.choose', 'messages', 'أختر', 'active', NULL, NULL, '2025-06-21 00:42:51', '2025-06-21 00:42:51'),
(3758, '9f34afd6-0436-4c67-8c2a-98017b19817e', 2, 3, 744, 'patient.new_patient', 'messages', 'مريض جديد', 'active', NULL, NULL, '2025-06-21 00:42:51', '2025-06-21 00:42:51'),
(3759, '9f34afd6-07f2-45d8-aab3-73c7f4eaec4f', 2, 3, 745, 'patient.edit_patient', 'messages', 'تحرير المريض', 'active', NULL, NULL, '2025-06-21 00:42:51', '2025-06-21 00:42:51'),
(3760, '9f34afd6-0c32-4618-9408-3610fab07846', 2, 3, 746, 'patient.patient_details', 'messages', 'تفاصيل المريض', 'active', NULL, NULL, '2025-06-21 00:42:51', '2025-06-21 00:42:51'),
(3761, '9f34afd6-0f31-49b8-989e-1e3530e65d0f', 2, 3, 747, 'patient.total_cases', 'messages', 'إجمالي الحالات', 'active', NULL, NULL, '2025-06-21 00:42:51', '2025-06-21 00:42:51'),
(3762, '9f34afd6-11c4-4c8b-bb15-c9e28e049185', 2, 3, 748, 'patient.total_admissions', 'messages', 'إجمالي القبول', 'active', NULL, NULL, '2025-06-21 00:42:51', '2025-06-21 00:42:51'),
(3763, '9f34afd6-14c9-4a1f-bac3-4fabc5bfe2c6', 2, 3, 749, 'patient.total_appointments', 'messages', 'إجمالي المواعيد', 'active', NULL, NULL, '2025-06-21 00:42:51', '2025-06-21 00:42:51'),
(3764, '9f34afd6-1781-4760-8cb2-b809dde38632', 2, 3, 750, 'payment.payment', 'messages', 'دفع', 'active', NULL, NULL, '2025-06-21 00:42:51', '2025-06-21 00:42:51'),
(3765, '9f34afd6-1ba4-47a3-a8ba-4797ba471356', 2, 3, 751, 'payment.payments', 'messages', 'المدفوعات', 'active', NULL, NULL, '2025-06-21 00:42:51', '2025-06-21 00:42:51'),
(3766, '9f34afd6-1f4b-40b2-bfaf-04da5b832d22', 2, 3, 752, 'payment.payment_details', 'messages', 'بيانات الدفع', 'active', NULL, NULL, '2025-06-21 00:42:51', '2025-06-21 00:42:51'),
(3767, '9f34afd6-2227-4d00-b292-dc9caeba8980', 2, 3, 753, 'payment.new_payment', 'messages', 'دفع جديد', 'active', NULL, NULL, '2025-06-21 00:42:51', '2025-06-21 00:42:51'),
(3768, '9f34afd6-2653-4c62-a445-86292a515357', 2, 3, 754, 'payment.edit_payment', 'messages', 'تحرير الدفع', 'active', NULL, NULL, '2025-06-21 00:42:51', '2025-06-21 00:42:51'),
(3769, '9f34afd6-2921-4307-a5d1-e3be494ac308', 2, 3, 755, 'payment.account_name', 'messages', 'أسم الحساب', 'active', NULL, NULL, '2025-06-21 00:42:51', '2025-06-21 00:42:51'),
(3770, '9f34afd6-2be0-490f-8fcf-315202f8d7cd', 2, 3, 756, 'payment.payment_date', 'messages', 'موعد الدفع', 'active', NULL, NULL, '2025-06-21 00:42:51', '2025-06-21 00:42:51'),
(3771, '9f34afd6-2f32-46c9-ab70-0bc918c9a222', 2, 3, 757, 'payment.pay_to', 'messages', 'دفع ل', 'active', NULL, NULL, '2025-06-21 00:42:51', '2025-06-21 00:42:51'),
(3772, '9f34afd6-33db-4991-816b-3d0485b8bb5f', 2, 3, 758, 'payment.amount', 'messages', 'كمية', 'active', NULL, NULL, '2025-06-21 00:42:51', '2025-06-21 00:42:51'),
(3773, '9f34afd6-36c3-48b2-85de-edba6e43d32a', 2, 3, 759, 'payment.account', 'messages', 'الحساب', 'active', NULL, NULL, '2025-06-21 00:42:51', '2025-06-21 00:42:51'),
(3774, '9f34afd6-3975-408b-a777-f0d5ccc80f54', 2, 3, 760, 'payment.description', 'messages', 'وصف', 'active', NULL, NULL, '2025-06-21 00:42:51', '2025-06-21 00:42:51'),
(3775, '9f34afd6-3c2d-4a77-90f7-72b56b0e21e7', 2, 3, 761, 'payment.payment_reports', 'messages', 'تقارير الدفع', 'active', NULL, NULL, '2025-06-21 00:42:51', '2025-06-21 00:42:51'),
(3776, '9f34afd6-3ef6-4450-99fd-73357131860b', 2, 3, 762, 'payment.your_payment_is_successfully_completed', 'messages', 'اكتملت عملية الدفع الخاصة بك بنجاح', 'active', NULL, NULL, '2025-06-21 00:42:51', '2025-06-21 00:42:51'),
(3777, '9f34afd6-41b5-4309-96bf-1e2a27645bf7', 2, 3, 763, 'payment.payment_failed', 'messages', 'آسف! فشل الدفع، حاول مرة أخرى بعد مرور بعض الوقت', 'active', NULL, NULL, '2025-06-21 00:42:51', '2025-06-21 00:42:51'),
(3778, '9f34afd6-4502-459a-9616-b58655a2dd2a', 2, 3, 764, 'transaction_filter.manual', 'messages', 'Manual', 'active', NULL, NULL, '2025-06-21 00:42:51', '2025-06-21 00:42:51'),
(3779, '9f34afd6-48f6-47bd-bbd4-b823d2566c5b', 2, 3, 765, 'transaction_filter.razorpay', 'messages', 'Razorpay', 'active', NULL, NULL, '2025-06-21 00:42:51', '2025-06-21 00:42:51'),
(3780, '9f34afd6-4e99-4dae-8250-e7337533b1d7', 2, 3, 766, 'transaction_filter.paypal', 'messages', 'PayPal', 'active', NULL, NULL, '2025-06-21 00:42:51', '2025-06-21 00:42:51'),
(3781, '9f34afd6-53de-46cf-8c0c-340ce2efd724', 2, 3, 767, 'transaction_filter.stripe', 'messages', 'Stripe', 'active', NULL, NULL, '2025-06-21 00:42:51', '2025-06-21 00:42:51'),
(3782, '9f34afd6-56bb-4d5b-bc6e-ca6c7ad24f90', 2, 3, 768, 'transaction_filter.paystack', 'messages', 'PayStack', 'active', NULL, NULL, '2025-06-21 00:42:51', '2025-06-21 00:42:51'),
(3783, '9f34afd6-5b5d-41a1-9d5e-b3b1fe75befa', 2, 3, 769, 'transaction_filter.paytm', 'messages', 'Paytm', 'active', NULL, NULL, '2025-06-21 00:42:51', '2025-06-21 00:42:51'),
(3784, '9f34afd6-5e24-4519-9db9-007c8d3fba1e', 2, 3, 770, 'transaction_filter.cash', 'messages', 'Cash', 'active', NULL, NULL, '2025-06-21 00:42:51', '2025-06-21 00:42:51'),
(3785, '9f34afd6-61ad-46d3-9450-543899cdfb12', 2, 3, 771, 'transaction_filter.cheque', 'messages', 'Cheque', 'active', NULL, NULL, '2025-06-21 00:42:51', '2025-06-21 00:42:51'),
(3786, '9f34afd6-647b-4af2-9aa2-600f71b8e09c', 2, 3, 772, 'advanced_payment.advanced_payment', 'messages', 'دفعه مقدمه', 'active', NULL, NULL, '2025-06-21 00:42:51', '2025-06-21 00:42:51'),
(3787, '9f34afd6-672b-4766-bb7c-6626370bf4df', 2, 3, 773, 'advanced_payment.advanced_payments', 'messages', 'دفعات مقدمة', 'active', NULL, NULL, '2025-06-21 00:42:51', '2025-06-21 00:42:51'),
(3788, '9f34afd6-6b71-4e28-9671-d0bc17f187d0', 2, 3, 774, 'advanced_payment.advanced_payment_details', 'messages', 'تفاصيل الدفع المسبق', 'active', NULL, NULL, '2025-06-21 00:42:51', '2025-06-21 00:42:51'),
(3789, '9f34afd6-6e1e-444f-837e-2827a1a8793f', 2, 3, 775, 'advanced_payment.new_advanced_payment', 'messages', 'دفعة مقدمة جديدة', 'active', NULL, NULL, '2025-06-21 00:42:51', '2025-06-21 00:42:51'),
(3790, '9f34afd6-722c-4d52-ace6-35fa1b64cfc6', 2, 3, 776, 'advanced_payment.edit_advanced_payment', 'messages', 'تحرير الدفع المسبق', 'active', NULL, NULL, '2025-06-21 00:42:51', '2025-06-21 00:42:51'),
(3791, '9f34afd6-7704-4474-b9cf-08d474a29ea1', 2, 3, 777, 'advanced_payment.patient', 'messages', 'صبور', 'active', NULL, NULL, '2025-06-21 00:42:51', '2025-06-21 00:42:51'),
(3792, '9f34afd6-79b4-4d06-8f58-7c90ac0474a1', 2, 3, 778, 'advanced_payment.receipt_no', 'messages', 'رقم الإيصال', 'active', NULL, NULL, '2025-06-21 00:42:51', '2025-06-21 00:42:51'),
(3793, '9f34afd6-7c53-4d6a-b4b6-638bef1b67a1', 2, 3, 779, 'advanced_payment.amount', 'messages', 'كمية', 'active', NULL, NULL, '2025-06-21 00:42:51', '2025-06-21 00:42:51'),
(3794, '9f34afd6-8232-47fa-a478-b6d047f7ea84', 2, 3, 780, 'advanced_payment.date', 'messages', 'تاريخ', 'active', NULL, NULL, '2025-06-21 00:42:51', '2025-06-21 00:42:51'),
(3795, '9f34afd6-84eb-49b7-99f1-2e3fb017cd1d', 2, 3, 781, 'advanced_payment.patient_name', 'messages', 'اسم المريض', 'active', NULL, NULL, '2025-06-21 00:42:51', '2025-06-21 00:42:51'),
(3796, '9f34afd6-893d-470d-ac94-221811b5eb0e', 2, 3, 782, 'bed.bed', 'messages', 'سرير جديد', 'active', NULL, NULL, '2025-06-21 00:42:51', '2025-06-21 00:42:51'),
(3797, '9f34afd6-8d41-46a8-9bcd-bc0c804483fd', 2, 3, 783, 'bed.beds', 'messages', 'سرير', 'active', NULL, NULL, '2025-06-21 00:42:51', '2025-06-21 00:42:51'),
(3798, '9f34afd6-9203-4de5-a149-8e818e3c6bc0', 2, 3, 784, 'bed.bed_details', 'messages', 'تفاصيل السرير', 'active', NULL, NULL, '2025-06-21 00:42:51', '2025-06-21 00:42:51'),
(3799, '9f34afd6-94c0-410f-a346-e0068d61031a', 2, 3, 785, 'bed.new_bed', 'messages', 'سرير جديد', 'active', NULL, NULL, '2025-06-21 00:42:51', '2025-06-21 00:42:51'),
(3800, '9f34afd6-976f-4c6a-8048-828862dc898b', 2, 3, 786, 'bed.edit_bed', 'messages', 'تحرير السرير', 'active', NULL, NULL, '2025-06-21 00:42:51', '2025-06-21 00:42:51'),
(3801, '9f34afd6-9a12-4c04-acfe-9c84e5e9b2ea', 2, 3, 787, 'bed.new_bulk_bed', 'messages', 'سرير ضخم جديد', 'active', NULL, NULL, '2025-06-21 00:42:51', '2025-06-21 00:42:51'),
(3802, '9f34afd6-9dbf-477d-98cd-ed809d2e934c', 2, 3, 788, 'bed.name', 'messages', 'اسم', 'active', NULL, NULL, '2025-06-21 00:42:51', '2025-06-21 00:42:51'),
(3803, '9f34afd6-a1d3-4d76-8ca4-6f0da542f247', 2, 3, 789, 'bed.bed_type', 'messages', 'نوع السرير', 'active', NULL, NULL, '2025-06-21 00:42:51', '2025-06-21 00:42:51'),
(3804, '9f34afd6-a639-4bd6-89b3-1e6343279cd0', 2, 3, 790, 'bed.charge', 'messages', 'الشحنة', 'active', NULL, NULL, '2025-06-21 00:42:51', '2025-06-21 00:42:51'),
(3805, '9f34afd6-a8f3-42e3-98ea-4428ee2767a7', 2, 3, 791, 'bed.available', 'messages', 'متاح', 'active', NULL, NULL, '2025-06-21 00:42:51', '2025-06-21 00:42:51'),
(3806, '9f34afd6-aba3-42aa-b278-eaa8ee49156f', 2, 3, 792, 'bed.not_available', 'messages', 'غير متوفر', 'active', NULL, NULL, '2025-06-21 00:42:51', '2025-06-21 00:42:51'),
(3807, '9f34afd6-afab-45b7-98a9-ebcfd3fde330', 2, 3, 793, 'bed.description', 'messages', 'وصف', 'active', NULL, NULL, '2025-06-21 00:42:51', '2025-06-21 00:42:51'),
(3808, '9f34afd6-b46d-4348-bbea-d73120fcfc9e', 2, 3, 794, 'bed.add', 'messages', 'أضف', 'active', NULL, NULL, '2025-06-21 00:42:51', '2025-06-21 00:42:51'),
(3809, '9f34afd6-b7c7-48b1-86c0-325cc6bafa0e', 2, 3, 795, 'bed.bed_id', 'messages', 'معرف السرير', 'active', NULL, NULL, '2025-06-21 00:42:52', '2025-06-21 00:42:52'),
(3810, '9f34afd6-ba8c-47ef-8856-ff0f1b0ef19e', 2, 3, 796, 'bed.select_bed_type', 'messages', 'اختر نوع السرير', 'active', NULL, NULL, '2025-06-21 00:42:52', '2025-06-21 00:42:52'),
(3811, '9f34afd6-bd33-42f0-9227-e5e7a72957a9', 2, 3, 797, 'bed.select_bed', 'messages', 'اختر السرير', 'active', NULL, NULL, '2025-06-21 00:42:52', '2025-06-21 00:42:52'),
(3812, '9f34afd6-c27d-4fe7-a070-67892496688c', 2, 3, 798, 'bed.choose_bed', 'messages', 'اختر السرير', 'active', NULL, NULL, '2025-06-21 00:42:52', '2025-06-21 00:42:52'),
(3813, '9f34afd6-c586-44ea-b40b-26afe31a5c2e', 2, 3, 799, 'bed_type.bed_type', 'messages', 'نوع السرير', 'active', NULL, NULL, '2025-06-21 00:42:52', '2025-06-21 00:42:52'),
(3814, '9f34afd6-c84c-477d-b3ca-77d87b5179c7', 2, 3, 800, 'bed_type.bed_types', 'messages', 'أنواع السرير', 'active', NULL, NULL, '2025-06-21 00:42:52', '2025-06-21 00:42:52'),
(3815, '9f34afd6-caf5-40a8-ad37-0c15604f77fb', 2, 3, 801, 'bed_type.bed_type_details', 'messages', 'تفاصيل نوع السرير', 'active', NULL, NULL, '2025-06-21 00:42:52', '2025-06-21 00:42:52'),
(3816, '9f34afd6-d084-4fab-992c-505f38ece465', 2, 3, 802, 'bed_type.new_bed_type', 'messages', 'نوع سرير جديد', 'active', NULL, NULL, '2025-06-21 00:42:52', '2025-06-21 00:42:52'),
(3817, '9f34afd6-d44a-4922-a538-9c88362e9b18', 2, 3, 803, 'bed_type.edit_bed_type', 'messages', 'تحرير نوع السرير', 'active', NULL, NULL, '2025-06-21 00:42:52', '2025-06-21 00:42:52'),
(3818, '9f34afd6-d704-4b3a-904f-8075820687b9', 2, 3, 804, 'bed_type.title', 'messages', 'عنوان', 'active', NULL, NULL, '2025-06-21 00:42:52', '2025-06-21 00:42:52'),
(3819, '9f34afd6-d9bf-43ce-a5e5-15be1db83f29', 2, 3, 805, 'bed_type.description', 'messages', 'وصف', 'active', NULL, NULL, '2025-06-21 00:42:52', '2025-06-21 00:42:52'),
(3820, '9f34afd6-dd1a-4f8f-b00a-efa1a8d26652', 2, 3, 806, 'doctor.new_doctor', 'messages', 'دكتور جديد', 'active', NULL, NULL, '2025-06-21 00:42:52', '2025-06-21 00:42:52'),
(3821, '9f34afd6-e1f2-4299-a18d-22e2d5ebf05d', 2, 3, 807, 'doctor.edit_doctor', 'messages', 'تحرير الطبيب', 'active', NULL, NULL, '2025-06-21 00:42:52', '2025-06-21 00:42:52'),
(3822, '9f34afd6-e5c0-4d3f-9a93-0f5e1472d8c2', 2, 3, 808, 'doctor.doctor_details', 'messages', 'تفاصيل الطبيب', 'active', NULL, NULL, '2025-06-21 00:42:52', '2025-06-21 00:42:52'),
(3823, '9f34afd6-eab8-445d-8db6-121dbe45f4f2', 2, 3, 809, 'doctor.specialist', 'messages', 'متخصص', 'active', NULL, NULL, '2025-06-21 00:42:52', '2025-06-21 00:42:52'),
(3824, '9f34afd6-efa7-40c2-905f-a79cbd280958', 2, 3, 810, 'doctor.name', 'messages', 'اسم', 'active', NULL, NULL, '2025-06-21 00:42:52', '2025-06-21 00:42:52'),
(3825, '9f34afd6-f26d-41d5-aff4-c343bd795587', 2, 3, 811, 'bed_assign.bed_assign', 'messages', 'تعيين السرير', 'active', NULL, NULL, '2025-06-21 00:42:52', '2025-06-21 00:42:52'),
(3826, '9f34afd6-f7da-4c67-8fe7-898c4ab0ff79', 2, 3, 812, 'bed_assign.bed_assigns', 'messages', 'تعيينات السرير', 'active', NULL, NULL, '2025-06-21 00:42:52', '2025-06-21 00:42:52'),
(3827, '9f34afd6-fc7e-4072-a25c-cea3f283f3a7', 2, 3, 813, 'bed_assign.bed_assign_details', 'messages', 'تفاصيل تعيين السرير', 'active', NULL, NULL, '2025-06-21 00:42:52', '2025-06-21 00:42:52'),
(3828, '9f34afd6-ff57-4542-bdc9-b579e095b4ed', 2, 3, 814, 'bed_assign.new_bed_assign', 'messages', 'تعيين سرير جديد', 'active', NULL, NULL, '2025-06-21 00:42:52', '2025-06-21 00:42:52'),
(3829, '9f34afd7-0394-4e5d-9fb5-f6b868260057', 2, 3, 815, 'bed_assign.edit_bed_assign', 'messages', 'تحرير تعيين السرير', 'active', NULL, NULL, '2025-06-21 00:42:52', '2025-06-21 00:42:52'),
(3830, '9f34afd7-075e-4000-b704-7aabc1309979', 2, 3, 816, 'bed_assign.patient_name', 'messages', 'اسم المريض', 'active', NULL, NULL, '2025-06-21 00:42:52', '2025-06-21 00:42:52'),
(3831, '9f34afd7-0a50-455f-9883-4201c11d4988', 2, 3, 817, 'bed_assign.bed_name', 'messages', 'اسم السرير', 'active', NULL, NULL, '2025-06-21 00:42:52', '2025-06-21 00:42:52'),
(3832, '9f34afd7-0d15-49a0-adc5-5d9da65bede1', 2, 3, 818, 'bed_assign.case_id', 'messages', 'ID القضية', 'active', NULL, NULL, '2025-06-21 00:42:52', '2025-06-21 00:42:52'),
(3833, '9f34afd7-0fc6-4e30-b06f-dd32e916005c', 2, 3, 819, 'bed_assign.assign_date', 'messages', 'تعيين التاريخ', 'active', NULL, NULL, '2025-06-21 00:42:52', '2025-06-21 00:42:52'),
(3834, '9f34afd7-14f4-442f-9fce-1dc5073daef5', 2, 3, 820, 'bed_assign.discharge_date', 'messages', 'تاريخ التفريغ', 'active', NULL, NULL, '2025-06-21 00:42:52', '2025-06-21 00:42:52'),
(3835, '9f34afd7-193f-4402-b8c0-8d1dd385712b', 2, 3, 821, 'bed_assign.bed', 'messages', 'السرير', 'active', NULL, NULL, '2025-06-21 00:42:52', '2025-06-21 00:42:52'),
(3836, '9f34afd7-1bfc-4847-891c-128a10e557ef', 2, 3, 822, 'bed_assign.description', 'messages', 'وصف', 'active', NULL, NULL, '2025-06-21 00:42:52', '2025-06-21 00:42:52'),
(3837, '9f34afd7-1fa4-4118-b830-ac073d811ed5', 2, 3, 823, 'bed_assign.assigned', 'messages', 'تعيين', 'active', NULL, NULL, '2025-06-21 00:42:52', '2025-06-21 00:42:52'),
(3838, '9f34afd7-2420-449a-b05d-d948a9c12ac9', 2, 3, 824, 'bed_assign.not_assigned', 'messages', 'غيرمعتمد', 'active', NULL, NULL, '2025-06-21 00:42:52', '2025-06-21 00:42:52'),
(3839, '9f34afd7-2b26-44fd-988f-0c32d3803a94', 2, 3, 825, 'bed_assign.ipd_patient_id', 'messages', 'معرف المريض IPD', 'active', NULL, NULL, '2025-06-21 00:42:52', '2025-06-21 00:42:52'),
(3840, '9f34afd7-2f01-4373-b11f-8952ee64c7f1', 2, 3, 826, 'bed_assign.assign_date_should_not_be_smaller_than_patient_birth_date', 'messages', 'يجب ألا يكون تاريخ تخصيص السرير أصغر من تاريخ ميلاد المريض.', 'active', NULL, NULL, '2025-06-21 00:42:52', '2025-06-21 00:42:52'),
(3841, '9f34afd7-3324-4cd9-be79-1709e467454d', 2, 3, 827, 'package.package', 'messages', 'صفقة', 'active', NULL, NULL, '2025-06-21 00:42:52', '2025-06-21 00:42:52'),
(3842, '9f34afd7-35da-4f04-b2fc-d33a99becd7c', 2, 3, 828, 'package.packages', 'messages', 'الحزم', 'active', NULL, NULL, '2025-06-21 00:42:52', '2025-06-21 00:42:52'),
(3843, '9f34afd7-389f-43cb-82fd-a9eab2ae767c', 2, 3, 829, 'package.package_details', 'messages', 'حزمة من التفاصيل', 'active', NULL, NULL, '2025-06-21 00:42:52', '2025-06-21 00:42:52'),
(3844, '9f34afd7-3c01-40ae-9d3c-8b8823b1ef2a', 2, 3, 830, 'package.new_package', 'messages', 'حزمة جديدة', 'active', NULL, NULL, '2025-06-21 00:42:52', '2025-06-21 00:42:52'),
(3845, '9f34afd7-3efc-4a6a-a972-2e2417039135', 2, 3, 831, 'package.edit_package', 'messages', 'تحرير الحزمة', 'active', NULL, NULL, '2025-06-21 00:42:52', '2025-06-21 00:42:52'),
(3846, '9f34afd7-41ee-4f7b-9701-255be9f22eed', 2, 3, 832, 'package.name', 'messages', 'اسم', 'active', NULL, NULL, '2025-06-21 00:42:52', '2025-06-21 00:42:52'),
(3847, '9f34afd7-469b-4c05-9037-4682ef5e0607', 2, 3, 833, 'package.description', 'messages', 'وصف', 'active', NULL, NULL, '2025-06-21 00:42:52', '2025-06-21 00:42:52'),
(3848, '9f34afd7-4ad8-41d8-85d8-8aee45cb0088', 2, 3, 834, 'package.discount', 'messages', 'خصم', 'active', NULL, NULL, '2025-06-21 00:42:52', '2025-06-21 00:42:52'),
(3849, '9f34afd7-4db8-4891-9aa1-b692c8f25587', 2, 3, 835, 'package.total_amount', 'messages', 'المبلغ الإجمالي', 'active', NULL, NULL, '2025-06-21 00:42:52', '2025-06-21 00:42:52'),
(3850, '9f34afd7-52c9-4b0f-9370-185e7375a26f', 2, 3, 836, 'package.service', 'messages', 'الخدمات', 'active', NULL, NULL, '2025-06-21 00:42:52', '2025-06-21 00:42:52'),
(3851, '9f34afd7-55a6-4391-b8c7-bf87a38a2586', 2, 3, 837, 'package.qty', 'messages', 'الكمية', 'active', NULL, NULL, '2025-06-21 00:42:52', '2025-06-21 00:42:52'),
(3852, '9f34afd7-5885-426e-afa8-7ad9b7e1bc35', 2, 3, 838, 'package.rate', 'messages', 'معدل', 'active', NULL, NULL, '2025-06-21 00:42:52', '2025-06-21 00:42:52'),
(3853, '9f34afd7-5fd2-4887-a05e-5e64e5bd9e91', 2, 3, 839, 'package.amount', 'messages', 'كمية', 'active', NULL, NULL, '2025-06-21 00:42:52', '2025-06-21 00:42:52'),
(3854, '9f34afd7-66b8-4495-a2f7-ae2fa63cb1e0', 2, 3, 840, 'package.select_service', 'messages', 'حدد الخدمة', 'active', NULL, NULL, '2025-06-21 00:42:52', '2025-06-21 00:42:52'),
(3855, '9f34afd7-6c3d-4dbe-a9e5-aa82b801fcbc', 2, 3, 841, 'bill.print_bill', 'messages', 'طباعة الفاتورة', 'active', NULL, NULL, '2025-06-21 00:42:52', '2025-06-21 00:42:52'),
(3856, '9f34afd7-6f3b-4c6c-b5b1-e47d596d0616', 2, 3, 842, 'bill.bill_id', 'messages', 'معرف الفاتورة', 'active', NULL, NULL, '2025-06-21 00:42:52', '2025-06-21 00:42:52'),
(3857, '9f34afd7-71e9-48f9-a902-140fef237aff', 2, 3, 843, 'bill.bill', 'messages', 'مشروع قانون', 'active', NULL, NULL, '2025-06-21 00:42:52', '2025-06-21 00:42:52'),
(3858, '9f34afd7-74c6-4bcf-a242-a13f48be1f33', 2, 3, 844, 'bill.bills', 'messages', 'فواتير', 'active', NULL, NULL, '2025-06-21 00:42:52', '2025-06-21 00:42:52'),
(3859, '9f34afd7-7896-4975-8767-4ffa37d765e0', 2, 3, 845, 'bill.bill_details', 'messages', 'تفاصيل الفاتورة', 'active', NULL, NULL, '2025-06-21 00:42:52', '2025-06-21 00:42:52'),
(3860, '9f34afd7-7b7e-469b-81fa-b7c13765e79d', 2, 3, 846, 'bill.new_bill', 'messages', 'مشروع قانون جديد', 'active', NULL, NULL, '2025-06-21 00:42:52', '2025-06-21 00:42:52'),
(3861, '9f34afd7-800a-402b-92e9-8f7ad220ab85', 2, 3, 847, 'bill.edit_bill', 'messages', 'تحرير بيل', 'active', NULL, NULL, '2025-06-21 00:42:52', '2025-06-21 00:42:52'),
(3862, '9f34afd7-82ce-49ca-aab5-a92a3df0ba09', 2, 3, 848, 'bill.patient', 'messages', 'صبور', 'active', NULL, NULL, '2025-06-21 00:42:52', '2025-06-21 00:42:52'),
(3863, '9f34afd7-8587-482a-8304-f2350f7e12ac', 2, 3, 849, 'bill.bill_date', 'messages', 'تاريخ الفاتورة', 'active', NULL, NULL, '2025-06-21 00:42:52', '2025-06-21 00:42:52'),
(3864, '9f34afd7-8937-4d18-9397-0f0d8f8927c4', 2, 3, 850, 'bill.amount', 'messages', 'كمية', 'active', NULL, NULL, '2025-06-21 00:42:52', '2025-06-21 00:42:52'),
(3865, '9f34afd7-8e0a-4610-be29-46f6d06eee4d', 2, 3, 851, 'bill.admission_id', 'messages', 'معرف القبول', 'active', NULL, NULL, '2025-06-21 00:42:52', '2025-06-21 00:42:52'),
(3866, '9f34afd7-910f-4128-93fd-5c3ee9aa1cbd', 2, 3, 852, 'bill.patient_name', 'messages', 'اسم المريض', 'active', NULL, NULL, '2025-06-21 00:42:52', '2025-06-21 00:42:52'),
(3867, '9f34afd7-955e-48e2-b365-060a05b538e0', 2, 3, 853, 'bill.patient_email', 'messages', 'البريد الإلكتروني للمريض', 'active', NULL, NULL, '2025-06-21 00:42:52', '2025-06-21 00:42:52'),
(3868, '9f34afd7-98e7-4c67-84b6-ee7de7fd0d79', 2, 3, 854, 'bill.patient_cell_no', 'messages', 'رقم خلية المريض', 'active', NULL, NULL, '2025-06-21 00:42:52', '2025-06-21 00:42:52'),
(3869, '9f34afd7-9bb1-4eeb-b0bf-0859e039a6e2', 2, 3, 855, 'bill.patient_gender', 'messages', 'جنس المريض', 'active', NULL, NULL, '2025-06-21 00:42:52', '2025-06-21 00:42:52'),
(3870, '9f34afd7-9e6a-4118-b29c-97a15dd2828a', 2, 3, 856, 'bill.patient_dob', 'messages', 'المريض DOB', 'active', NULL, NULL, '2025-06-21 00:42:52', '2025-06-21 00:42:52'),
(3871, '9f34afd7-a12e-4fbe-811a-b7912e3325c5', 2, 3, 857, 'bill.doctor_name', 'messages', 'اسم الطبيب', 'active', NULL, NULL, '2025-06-21 00:42:52', '2025-06-21 00:42:52'),
(3872, '9f34afd7-a3de-40c5-855a-d52431819313', 2, 3, 858, 'bill.admission_date', 'messages', 'تاريخ القبول', 'active', NULL, NULL, '2025-06-21 00:42:52', '2025-06-21 00:42:52'),
(3873, '9f34afd7-a68f-4c56-bebd-223e79f3c411', 2, 3, 859, 'bill.discharge_date', 'messages', 'تاريخ التفريغ', 'active', NULL, NULL, '2025-06-21 00:42:52', '2025-06-21 00:42:52'),
(3874, '9f34afd7-aa9a-4224-a4af-3d102543c6fd', 2, 3, 860, 'bill.package_name', 'messages', 'اسم الحزمة', 'active', NULL, NULL, '2025-06-21 00:42:52', '2025-06-21 00:42:52'),
(3875, '9f34afd7-af9f-4a4b-ac65-01e4808ccd72', 2, 3, 861, 'bill.insurance_name', 'messages', 'اسم التأمين', 'active', NULL, NULL, '2025-06-21 00:42:52', '2025-06-21 00:42:52'),
(3876, '9f34afd7-b2f2-4b87-9244-8bf70bd54bf6', 2, 3, 862, 'bill.total_days', 'messages', 'مجموع الأيام', 'active', NULL, NULL, '2025-06-21 00:42:52', '2025-06-21 00:42:52'),
(3877, '9f34afd7-b776-436d-b490-939af993f114', 2, 3, 863, 'bill.policy_no', 'messages', 'لا توجد سياسة', 'active', NULL, NULL, '2025-06-21 00:42:52', '2025-06-21 00:42:52'),
(3878, '9f34afd7-be28-4a71-a529-0f0b77391707', 2, 3, 864, 'bill.item_name', 'messages', 'اسم العنصر', 'active', NULL, NULL, '2025-06-21 00:42:52', '2025-06-21 00:42:52'),
(3879, '9f34afd7-c1a2-402b-a504-3d46dd8444a0', 2, 3, 865, 'bill.qty', 'messages', 'الكمية', 'active', NULL, NULL, '2025-06-21 00:42:52', '2025-06-21 00:42:52'),
(3880, '9f34afd7-c4b8-47ca-8457-ea8914ca9dfc', 2, 3, 866, 'bill.price', 'messages', 'السعر', 'active', NULL, NULL, '2025-06-21 00:42:52', '2025-06-21 00:42:52'),
(3881, '9f34afd7-c79a-4ddd-9f3d-6e4ef3f22896', 2, 3, 867, 'bill.add', 'messages', 'السعر', 'active', NULL, NULL, '2025-06-21 00:42:52', '2025-06-21 00:42:52'),
(3882, '9f34afd7-cc15-4c97-aa98-aeaa553ab699', 2, 3, 868, 'bill.total_amount', 'messages', 'المبلغ الإجمالي', 'active', NULL, NULL, '2025-06-21 00:42:52', '2025-06-21 00:42:52'),
(3883, '9f34afd7-d282-46e6-b024-b132118bcc16', 2, 3, 869, 'bill.edit', 'messages', 'تعديل', 'active', NULL, NULL, '2025-06-21 00:42:52', '2025-06-21 00:42:52'),
(3884, '9f34afd7-d54f-4988-99a1-716835fdd97a', 2, 3, 870, 'bill.cell_no', 'messages', 'خلية لا', 'active', NULL, NULL, '2025-06-21 00:42:52', '2025-06-21 00:42:52'),
(3885, '9f34afd7-d885-46ce-858c-0d622f8040e5', 2, 3, 871, 'bill.bill_summary', 'messages', 'ملخص الفاتورة', 'active', NULL, NULL, '2025-06-21 00:42:52', '2025-06-21 00:42:52'),
(3886, '9f34afd7-db34-4cb1-abcf-0c30976e36f0', 2, 3, 872, 'bill.generate_bill', 'messages', 'توليد بيل', 'active', NULL, NULL, '2025-06-21 00:42:52', '2025-06-21 00:42:52'),
(3887, '9f34afd7-e03b-456f-96dc-38500292e677', 2, 3, 873, 'bill.update_bill', 'messages', 'تحديث الفاتورة', 'active', NULL, NULL, '2025-06-21 00:42:52', '2025-06-21 00:42:52'),
(3888, '9f34afd7-e344-4df9-a43e-8a35c3fbffa4', 2, 3, 874, 'bill.calculate', 'messages', 'احسب', 'active', NULL, NULL, '2025-06-21 00:42:52', '2025-06-21 00:42:52'),
(3889, '9f34afd7-e633-4525-8752-2475ff2ec3d4', 2, 3, 875, 'blood_donor.blood_donor', 'messages', 'متبرع بالدم', 'active', NULL, NULL, '2025-06-21 00:42:52', '2025-06-21 00:42:52'),
(3890, '9f34afd7-e900-44a2-b986-475d77fb4892', 2, 3, 876, 'blood_donor.blood_donors', 'messages', 'المتبرعين بالدم', 'active', NULL, NULL, '2025-06-21 00:42:52', '2025-06-21 00:42:52'),
(3891, '9f34afd7-ebc6-4d13-883c-3e9c4c7d4cca', 2, 3, 877, 'blood_donor.blood_donor_details', 'messages', 'تفاصيل المتبرعين بالدم', 'active', NULL, NULL, '2025-06-21 00:42:52', '2025-06-21 00:42:52'),
(3892, '9f34afd7-f0d6-4a0a-b935-8255f0fe1c9b', 2, 3, 878, 'blood_donor.new_blood_donor', 'messages', 'متبرع جديد بالدم', 'active', NULL, NULL, '2025-06-21 00:42:52', '2025-06-21 00:42:52'),
(3893, '9f34afd7-f3de-4988-8dec-cd96c7c97f93', 2, 3, 879, 'blood_donor.edit_blood_donor', 'messages', 'تحرير متبرع بالدم', 'active', NULL, NULL, '2025-06-21 00:42:52', '2025-06-21 00:42:52'),
(3894, '9f34afd7-f6b7-42a0-95a3-ce3e678869ae', 2, 3, 880, 'blood_donor.name', 'messages', 'اسم', 'active', NULL, NULL, '2025-06-21 00:42:52', '2025-06-21 00:42:52'),
(3895, '9f34afd7-fb04-4f28-873b-50f6726bfb75', 2, 3, 881, 'blood_donor.age', 'messages', 'عمر', 'active', NULL, NULL, '2025-06-21 00:42:52', '2025-06-21 00:42:52'),
(3896, '9f34afd7-ff16-4f2f-8c68-f6a5665f92aa', 2, 3, 882, 'blood_donor.gender', 'messages', 'جنس', 'active', NULL, NULL, '2025-06-21 00:42:52', '2025-06-21 00:42:52'),
(3897, '9f34afd8-03f3-49d2-b0e6-e8097f0ca825', 2, 3, 883, 'blood_donor.blood_group', 'messages', 'فصيلة الدم', 'active', NULL, NULL, '2025-06-21 00:42:52', '2025-06-21 00:42:52'),
(3898, '9f34afd8-06dc-4270-a590-214b5837a228', 2, 3, 884, 'blood_donor.donation_date', 'messages', 'تاريخ التبرع', 'active', NULL, NULL, '2025-06-21 00:42:52', '2025-06-21 00:42:52'),
(3899, '9f34afd8-09d3-4c5a-93ce-4d08a08227ae', 2, 3, 885, 'blood_donor.last_donation_date', 'messages', 'تاريخ آخر تبرع', 'active', NULL, NULL, '2025-06-21 00:42:52', '2025-06-21 00:42:52'),
(3900, '9f34afd8-0f5c-4b12-8438-0095a9018ca1', 2, 3, 886, 'hospital_blood_bank.blood_bank', 'messages', 'بنك الدم', 'active', NULL, NULL, '2025-06-21 00:42:52', '2025-06-21 00:42:52'),
(3901, '9f34afd8-1423-4e8e-b097-b3e5e06de45a', 2, 3, 887, 'hospital_blood_bank.blood_banks', 'messages', 'بنوك الدم', 'active', NULL, NULL, '2025-06-21 00:42:52', '2025-06-21 00:42:52'),
(3902, '9f34afd8-1715-40ea-a542-0c1cc5470b31', 2, 3, 888, 'hospital_blood_bank.blood_bank_details', 'messages', 'تفاصيل بنك الدم', 'active', NULL, NULL, '2025-06-21 00:42:52', '2025-06-21 00:42:52'),
(3903, '9f34afd8-1b07-4b1e-9acb-89257616a688', 2, 3, 889, 'hospital_blood_bank.new_blood_group', 'messages', 'فصيلة الدم الجديدة', 'active', NULL, NULL, '2025-06-21 00:42:52', '2025-06-21 00:42:52'),
(3904, '9f34afd8-1f05-4c01-b6c2-aecf65390bd1', 2, 3, 890, 'hospital_blood_bank.edit_blood_group', 'messages', 'تحرير فصيلة الدم', 'active', NULL, NULL, '2025-06-21 00:42:52', '2025-06-21 00:42:52'),
(3905, '9f34afd8-2205-40f2-83f3-49e1159befdd', 2, 3, 891, 'hospital_blood_bank.blood_group', 'messages', 'فصيلة الدم', 'active', NULL, NULL, '2025-06-21 00:42:52', '2025-06-21 00:42:52'),
(3906, '9f34afd8-257f-4905-9d54-16bd6e5c48df', 2, 3, 892, 'hospital_blood_bank.remained_bags', 'messages', 'أكياس متبقية', 'active', NULL, NULL, '2025-06-21 00:42:52', '2025-06-21 00:42:52'),
(3907, '9f34afd8-2849-4742-bf3e-d4e2c4681958', 2, 3, 893, 'case.case', 'messages', 'قضية', 'active', NULL, NULL, '2025-06-21 00:42:52', '2025-06-21 00:42:52'),
(3908, '9f34afd8-2d6e-42cd-ae91-e2915e099432', 2, 3, 894, 'case.select_case', 'messages', 'إختر حالة', 'active', NULL, NULL, '2025-06-21 00:42:52', '2025-06-21 00:42:52'),
(3909, '9f34afd8-3080-4d45-a7fe-ccdb9aed1029', 2, 3, 895, 'case.case_date', 'messages', 'تاريخ القضية', 'active', NULL, NULL, '2025-06-21 00:42:52', '2025-06-21 00:42:52'),
(3910, '9f34afd8-336f-462d-b386-f63ead2b3695', 2, 3, 896, 'case.new_case', 'messages', 'حالة جديدة', 'active', NULL, NULL, '2025-06-21 00:42:52', '2025-06-21 00:42:52'),
(3911, '9f34afd8-365d-4b4b-b50f-0326a92c72b3', 2, 3, 897, 'case.edit_case', 'messages', 'تحرير الحالة', 'active', NULL, NULL, '2025-06-21 00:42:52', '2025-06-21 00:42:52'),
(3912, '9f34afd8-39eb-435b-bb07-7fd035481126', 2, 3, 898, 'case.case_details', 'messages', 'تفاصيل الحالة', 'active', NULL, NULL, '2025-06-21 00:42:52', '2025-06-21 00:42:52'),
(3913, '9f34afd8-3d0e-4c7e-b9d3-5f710056d268', 2, 3, 899, 'case.phone', 'messages', 'هاتف', 'active', NULL, NULL, '2025-06-21 00:42:52', '2025-06-21 00:42:52'),
(3914, '9f34afd8-3fcb-41ca-898f-1e7290ffabbc', 2, 3, 900, 'case.fee', 'messages', 'الرسوم', 'active', NULL, NULL, '2025-06-21 00:42:53', '2025-06-21 00:42:53'),
(3915, '9f34afd8-42a2-4edd-bb91-d8aa83073112', 2, 3, 901, 'case.patient', 'messages', 'صبور', 'active', NULL, NULL, '2025-06-21 00:42:53', '2025-06-21 00:42:53'),
(3916, '9f34afd8-482e-4608-8dac-59b100c2c035', 2, 3, 902, 'case.doctor', 'messages', 'طبيب', 'active', NULL, NULL, '2025-06-21 00:42:53', '2025-06-21 00:42:53'),
(3917, '9f34afd8-4b4a-4858-bd64-823eb2c66505', 2, 3, 903, 'case.case_id', 'messages', 'ID القضية', 'active', NULL, NULL, '2025-06-21 00:42:53', '2025-06-21 00:42:53'),
(3918, '9f34afd8-4f53-4d6c-acde-301a6d8d0e04', 2, 3, 904, 'case.date', 'messages', 'تاريخ', 'active', NULL, NULL, '2025-06-21 00:42:53', '2025-06-21 00:42:53'),
(3919, '9f34afd8-546d-4097-9ce4-70c30c194064', 2, 3, 905, 'case.description', 'messages', 'وصف', 'active', NULL, NULL, '2025-06-21 00:42:53', '2025-06-21 00:42:53'),
(3920, '9f34afd8-57ad-48d1-adb5-c7fa86a69c31', 2, 3, 906, 'service.new_service', 'messages', 'خدمة جديدة', 'active', NULL, NULL, '2025-06-21 00:42:53', '2025-06-21 00:42:53'),
(3921, '9f34afd8-5aa5-4c01-8f3d-fa087fdd9f39', 2, 3, 907, 'service.edit_service', 'messages', 'تحرير الخدمة', 'active', NULL, NULL, '2025-06-21 00:42:53', '2025-06-21 00:42:53'),
(3922, '9f34afd8-6221-4395-9ae6-013961864fa0', 2, 3, 908, 'service.service_details', 'messages', 'تفاصيل الخدمة', 'active', NULL, NULL, '2025-06-21 00:42:53', '2025-06-21 00:42:53'),
(3923, '9f34afd8-652e-4d12-b815-533e2bf5d608', 2, 3, 909, 'service.quantity', 'messages', 'كمية', 'active', NULL, NULL, '2025-06-21 00:42:53', '2025-06-21 00:42:53'),
(3924, '9f34afd8-680a-457d-bf5c-f0156855f709', 2, 3, 910, 'service.rate', 'messages', 'معدل', 'active', NULL, NULL, '2025-06-21 00:42:53', '2025-06-21 00:42:53'),
(3925, '9f34afd8-6be5-4c93-9483-88cd1dac1227', 2, 3, 911, 'service.given', 'messages', 'معطى', 'active', NULL, NULL, '2025-06-21 00:42:53', '2025-06-21 00:42:53'),
(3926, '9f34afd8-7035-447c-b67d-8a24f5c41888', 2, 3, 912, 'service.not_given', 'messages', 'غير معطى', 'active', NULL, NULL, '2025-06-21 00:42:53', '2025-06-21 00:42:53'),
(3927, '9f34afd8-73e4-4491-86fa-ceaa4e953aff', 2, 3, 913, 'appointment.new_appointment', 'messages', 'موعد جديد', 'active', NULL, NULL, '2025-06-21 00:42:53', '2025-06-21 00:42:53'),
(3928, '9f34afd8-76c7-44ca-b78d-59b74ae18e52', 2, 3, 914, 'appointment.edit_appointment', 'messages', 'تحرير موعد', 'active', NULL, NULL, '2025-06-21 00:42:53', '2025-06-21 00:42:53'),
(3929, '9f34afd8-7998-496c-9088-22679a935061', 2, 3, 915, 'appointment.appointment_details', 'messages', 'تفاصيل الموعد', 'active', NULL, NULL, '2025-06-21 00:42:53', '2025-06-21 00:42:53'),
(3930, '9f34afd8-7c62-461d-b719-4e616808701d', 2, 3, 916, 'appointment.calendar_view', 'messages', 'عرض التقويم', 'active', NULL, NULL, '2025-06-21 00:42:53', '2025-06-21 00:42:53'),
(3931, '9f34afd8-7f3a-4382-8ae3-ddf7dd96a2af', 2, 3, 917, 'appointment.patient_name', 'messages', 'اسم المريض', 'active', NULL, NULL, '2025-06-21 00:42:53', '2025-06-21 00:42:53'),
(3932, '9f34afd8-8327-4525-9b89-7419aeb22322', 2, 3, 918, 'appointment.doctor_name', 'messages', 'اسم الطبيب', 'active', NULL, NULL, '2025-06-21 00:42:53', '2025-06-21 00:42:53'),
(3933, '9f34afd8-8645-446c-8e24-f6e0926e20d5', 2, 3, 919, 'appointment.department_name', 'messages', 'اسم القسم', 'active', NULL, NULL, '2025-06-21 00:42:53', '2025-06-21 00:42:53'),
(3934, '9f34afd8-8af3-42df-ae32-4459f1c55c29', 2, 3, 920, 'appointment.date', 'messages', 'تاريخ', 'active', NULL, NULL, '2025-06-21 00:42:53', '2025-06-21 00:42:53'),
(3935, '9f34afd8-8dd5-41c2-8e6f-7603ba7e7206', 2, 3, 921, 'appointment.doctor_department', 'messages', 'قسم الطبيب', 'active', NULL, NULL, '2025-06-21 00:42:53', '2025-06-21 00:42:53'),
(3936, '9f34afd8-9287-45e0-967f-4f96e9598557', 2, 3, 922, 'appointment.doctor_department_name', 'messages', 'اسم قسم الطبيب', 'active', NULL, NULL, '2025-06-21 00:42:53', '2025-06-21 00:42:53'),
(3937, '9f34afd8-9558-457b-9132-c5ddd2192b2e', 2, 3, 923, 'appointment.doctor', 'messages', 'طبيب', 'active', NULL, NULL, '2025-06-21 00:42:53', '2025-06-21 00:42:53'),
(3938, '9f34afd8-9bd7-4cf7-b269-2358a5ef4774', 2, 3, 924, 'appointment.description', 'messages', 'وصف', 'active', NULL, NULL, '2025-06-21 00:42:53', '2025-06-21 00:42:53'),
(3939, '9f34afd8-9ecc-47ed-82cd-26ab65d13b1b', 2, 3, 925, 'appointment.patient', 'messages', 'صبور', 'active', NULL, NULL, '2025-06-21 00:42:53', '2025-06-21 00:42:53'),
(3940, '9f34afd8-a292-44bb-b41b-d1e05ff29a3b', 2, 3, 926, 'appointment.appointment_calendar', 'messages', 'تقويم المواعيد', 'active', NULL, NULL, '2025-06-21 00:42:53', '2025-06-21 00:42:53'),
(3941, '9f34afd8-a574-4dc2-a512-497ca43f1188', 2, 3, 927, 'appointment.appointment_list', 'messages', 'قائمة التعيين', 'active', NULL, NULL, '2025-06-21 00:42:53', '2025-06-21 00:42:53'),
(3942, '9f34afd8-a85b-4c5c-904b-9397f4ba9567', 2, 3, 928, 'appointment.completed', 'messages', 'منجز', 'active', NULL, NULL, '2025-06-21 00:42:53', '2025-06-21 00:42:53'),
(3943, '9f34afd8-ab71-419a-aa19-8d7efc8e1897', 2, 3, 929, 'appointment.pending', 'messages', 'قيد الانتظار', 'active', NULL, NULL, '2025-06-21 00:42:53', '2025-06-21 00:42:53'),
(3944, '9f34afd8-af79-42c6-a2cd-5cffc421bdc5', 2, 3, 930, 'appointment.available_slot', 'messages', 'الفتحة المتاحة', 'active', NULL, NULL, '2025-06-21 00:42:53', '2025-06-21 00:42:53'),
(3945, '9f34afd8-b3ad-4d57-99db-b3e0797401d3', 2, 3, 931, 'appointment.no_available', 'messages', 'غير متاح', 'active', NULL, NULL, '2025-06-21 00:42:53', '2025-06-21 00:42:53'),
(3946, '9f34afd8-b6a4-4631-a627-3b2f7b51a6b2', 2, 3, 932, 'appointment.today', 'messages', 'اليوم', 'active', NULL, NULL, '2025-06-21 00:42:53', '2025-06-21 00:42:53'),
(3947, '9f34afd8-b978-4965-a055-5efcfcdfbd96', 2, 3, 933, 'appointment.month', 'messages', 'شهر', 'active', NULL, NULL, '2025-06-21 00:42:53', '2025-06-21 00:42:53'),
(3948, '9f34afd8-bcc4-428d-ac5a-e0521f69484c', 2, 3, 934, 'appointment.week', 'messages', 'أسبوع', 'active', NULL, NULL, '2025-06-21 00:42:53', '2025-06-21 00:42:53'),
(3949, '9f34afd8-c1c5-49a8-831c-59f06bc24b7c', 2, 3, 935, 'appointment.day', 'messages', 'يوم', 'active', NULL, NULL, '2025-06-21 00:42:53', '2025-06-21 00:42:53'),
(3950, '9f34afd8-c4e1-4cb8-a04b-d2c0be2a71c4', 2, 3, 936, 'appointment.opd_date', 'messages', 'تاريخ Opd', 'active', NULL, NULL, '2025-06-21 00:42:53', '2025-06-21 00:42:53'),
(3951, '9f34afd8-c8e4-41b1-a8e3-6c124fc75a08', 2, 3, 937, 'appointment.yesterday', 'messages', 'في الامس', 'active', NULL, NULL, '2025-06-21 00:42:53', '2025-06-21 00:42:53'),
(3952, '9f34afd8-cbd5-479a-9898-55fc84a9a001', 2, 3, 938, 'appointment.this_week', 'messages', 'هذا الاسبوع', 'active', NULL, NULL, '2025-06-21 00:42:53', '2025-06-21 00:42:53'),
(3953, '9f34afd8-cebd-4041-a3a8-8489f6c2954b', 2, 3, 939, 'appointment.last_7_days', 'messages', 'اخر 7 ايام', 'active', NULL, NULL, '2025-06-21 00:42:53', '2025-06-21 00:42:53'),
(3954, '9f34afd8-d247-44d7-a4e0-5049332459fc', 2, 3, 940, 'appointment.last_30_days', 'messages', 'آخر 30 يومًا', 'active', NULL, NULL, '2025-06-21 00:42:53', '2025-06-21 00:42:53'),
(3955, '9f34afd8-d761-4973-ba33-ec50073ddfac', 2, 3, 941, 'appointment.this_month', 'messages', 'هذا الشهر', 'active', NULL, NULL, '2025-06-21 00:42:53', '2025-06-21 00:42:53'),
(3956, '9f34afd8-db20-4bc0-be22-0aed1b94a9d4', 2, 3, 942, 'appointment.last_month', 'messages', 'الشهر الماضي', 'active', NULL, NULL, '2025-06-21 00:42:53', '2025-06-21 00:42:53'),
(3957, '9f34afd8-de36-4df9-999c-ae02b37a2886', 2, 3, 943, 'appointment.custom', 'messages', 'مخصص', 'active', NULL, NULL, '2025-06-21 00:42:53', '2025-06-21 00:42:53'),
(3958, '9f34afd8-e13e-41b2-b8c0-090057ce9040', 2, 3, 944, 'appointment.start_date', 'messages', 'تاريخ البدء', 'active', NULL, NULL, '2025-06-21 00:42:53', '2025-06-21 00:42:53'),
(3959, '9f34afd8-e4fa-4d82-b217-0c6fa3d802c2', 2, 3, 945, 'appointment.end_date', 'messages', 'تاريخ الانتهاء', 'active', NULL, NULL, '2025-06-21 00:42:53', '2025-06-21 00:42:53'),
(3960, '9f34afd8-e7e7-4d0d-886a-83bbe0adc7f1', 2, 3, 946, 'appointment.change_status', 'messages', 'تغيير الوضع', 'active', NULL, NULL, '2025-06-21 00:42:53', '2025-06-21 00:42:53'),
(3961, '9f34afd8-eace-4f32-8469-f10e08c6b92d', 2, 3, 947, 'appointment.are_you_sure_want_to_change', 'messages', 'هل أنت متأكد أنك تريد التغيير', 'active', NULL, NULL, '2025-06-21 00:42:53', '2025-06-21 00:42:53'),
(3962, '9f34afd8-f05f-4e79-b465-37a0ea11d0bb', 2, 3, 948, 'appointment.changed_appointment', 'messages', 'موعد تم تغييره', 'active', NULL, NULL, '2025-06-21 00:42:53', '2025-06-21 00:42:53'),
(3963, '9f34afd8-f35b-4890-8f0e-98120ff4a436', 2, 3, 949, 'appointment.has_been_changed', 'messages', 'تغير.', 'active', NULL, NULL, '2025-06-21 00:42:53', '2025-06-21 00:42:53'),
(3964, '9f34afd8-f6f3-4f51-be54-86741b45f0a1', 2, 3, 950, 'appointment.are_you_sure_want_to_cancel', 'messages', 'هل أنت متأكد من أنك تريد الإلغاء', 'active', NULL, NULL, '2025-06-21 00:42:53', '2025-06-21 00:42:53'),
(3965, '9f34afd8-f9d0-4245-aad9-e0f383160719', 2, 3, 951, 'appointment.has_been_cancelled', 'messages', 'تم إلغاء.', 'active', NULL, NULL, '2025-06-21 00:42:53', '2025-06-21 00:42:53'),
(3966, '9f34afd8-fce0-4f94-a4b5-d702c855d121', 2, 3, 952, 'appointment.please_select_doctor', 'messages', 'الرجاء تحديد دكتور', 'active', NULL, NULL, '2025-06-21 00:42:53', '2025-06-21 00:42:53'),
(3967, '9f34afd9-0006-4761-b824-0382ea6e8fba', 2, 3, 953, 'appointment.doctor_schedule_not_available_on_this_date', 'messages', 'جدول الطبيب غير متوفر هذا التاريخ.', 'active', NULL, NULL, '2025-06-21 00:42:53', '2025-06-21 00:42:53'),
(3968, '9f34afd9-0373-467c-84b2-a146feb3bb18', 2, 3, 954, 'appointment.patient_not_exists_or_status_is_not_active', 'messages', 'المريض غير موجود أو الحالة غير نشطة.', 'active', NULL, NULL, '2025-06-21 00:42:53', '2025-06-21 00:42:53'),
(3969, '9f34afd9-066f-4377-b541-dcb86ef71dd1', 2, 3, 955, 'appointment.please_select_appointment_time_slot', 'messages', 'الرجاء تحديد الفترة الزمنية للموعد', 'active', NULL, NULL, '2025-06-21 00:42:53', '2025-06-21 00:42:53'),
(3970, '9f34afd9-0a9b-4671-97bc-cf92f0677d6b', 2, 3, 956, 'appointment.time', 'messages', 'وقت', 'active', NULL, NULL, '2025-06-21 00:42:53', '2025-06-21 00:42:53'),
(3971, '9f34afd9-0d98-43ba-8a36-6b1bc425ca55', 2, 3, 957, 'case_handler.new_case_handler', 'messages', 'معالج الحالة الجديد', 'active', NULL, NULL, '2025-06-21 00:42:53', '2025-06-21 00:42:53'),
(3972, '9f34afd9-13cf-4360-9444-4ebf535255a5', 2, 3, 958, 'case_handler.edit_case_handler', 'messages', 'تحرير معالج الحالة', 'active', NULL, NULL, '2025-06-21 00:42:53', '2025-06-21 00:42:53'),
(3973, '9f34afd9-16ef-48a0-959b-df4422f87589', 2, 3, 959, 'case_handler.case_handler_detail', 'messages', 'تفاصيل معالج الحالة', 'active', NULL, NULL, '2025-06-21 00:42:53', '2025-06-21 00:42:53'),
(3974, '9f34afd9-1c2c-4dec-b00d-2711f8d022e7', 2, 3, 960, 'lab_tech.new_lab_tech', 'messages', 'فني مختبر جديد', 'active', NULL, NULL, '2025-06-21 00:42:53', '2025-06-21 00:42:53'),
(3975, '9f34afd9-1f67-46df-ad93-594530158e8c', 2, 3, 961, 'lab_tech.edit_lab_tech', 'messages', 'تحرير فني مختبر', 'active', NULL, NULL, '2025-06-21 00:42:53', '2025-06-21 00:42:53'),
(3976, '9f34afd9-22e8-4cc2-8618-9a3474a92dc8', 2, 3, 962, 'lab_tech.lab_tech_detail', 'messages', 'تفاصيل فني مختبر', 'active', NULL, NULL, '2025-06-21 00:42:53', '2025-06-21 00:42:53'),
(3977, '9f34afd9-260a-4044-8c1d-788d5500df91', 2, 3, 963, 'doc_type.new_doc_type', 'messages', 'نوع مستند جديد', 'active', NULL, NULL, '2025-06-21 00:42:53', '2025-06-21 00:42:53'),
(3978, '9f34afd9-292f-48a8-9724-bc6128f18078', 2, 3, 964, 'doc_type.edit_doc_type', 'messages', 'تحرير نوع المستند', 'active', NULL, NULL, '2025-06-21 00:42:53', '2025-06-21 00:42:53'),
(3979, '9f34afd9-2c3a-4b08-a538-183bfdb7cea2', 2, 3, 965, 'doc_type.name', 'messages', 'اسم', 'active', NULL, NULL, '2025-06-21 00:42:53', '2025-06-21 00:42:53'),
(3980, '9f34afd9-2f3e-40d3-9459-0912dfe3d5d6', 2, 3, 967, 'document.documents', 'messages', 'مستندات', 'active', NULL, NULL, '2025-06-21 00:42:53', '2025-06-21 00:42:53'),
(3981, '9f34afd9-322e-4dca-9f51-c5c7d991f8a0', 2, 3, 966, 'document.document', 'messages', 'المستند', 'active', NULL, NULL, '2025-06-21 00:42:53', '2025-06-21 00:42:53'),
(3982, '9f34afd9-351e-473f-99b2-32cbb5ded696', 2, 3, 968, 'document.new_document', 'messages', 'مستند جديد', 'active', NULL, NULL, '2025-06-21 00:42:53', '2025-06-21 00:42:53'),
(3983, '9f34afd9-380a-4f98-84c6-ab2897f8bfa3', 2, 3, 969, 'document.edit_document', 'messages', 'تحرير المستند', 'active', NULL, NULL, '2025-06-21 00:42:53', '2025-06-21 00:42:53'),
(3984, '9f34afd9-3c21-4e82-8b4b-4271135f2e7a', 2, 3, 970, 'document.title', 'messages', 'عنوان', 'active', NULL, NULL, '2025-06-21 00:42:53', '2025-06-21 00:42:53'),
(3985, '9f34afd9-3f4c-4480-b8d5-22f5273dd893', 2, 3, 971, 'document.document_type', 'messages', 'نوع الوثيقة', 'active', NULL, NULL, '2025-06-21 00:42:53', '2025-06-21 00:42:53'),
(3986, '9f34afd9-426c-4415-ae85-c17aa709494e', 2, 3, 972, 'document.document_type_details', 'messages', 'تفاصيل نوع المستند', 'active', NULL, NULL, '2025-06-21 00:42:53', '2025-06-21 00:42:53'),
(3987, '9f34afd9-4569-44a4-9699-98df88b5db07', 2, 3, 973, 'document.patient', 'messages', 'صبور', 'active', NULL, NULL, '2025-06-21 00:42:53', '2025-06-21 00:42:53'),
(3988, '9f34afd9-4892-4298-961a-c7b3f60d3a76', 2, 3, 974, 'document.download', 'messages', 'تحميل', 'active', NULL, NULL, '2025-06-21 00:42:53', '2025-06-21 00:42:53'),
(3989, '9f34afd9-4bc4-4ab3-a9e6-e60402cad356', 2, 3, 975, 'document.select_patient', 'messages', 'حدد المريض', 'active', NULL, NULL, '2025-06-21 00:42:53', '2025-06-21 00:42:53'),
(3990, '9f34afd9-4efc-4499-9114-3b6f53adcaf4', 2, 3, 979, 'document.select_document_type', 'messages', 'حدد نوع المستند', 'active', NULL, NULL, '2025-06-21 00:42:53', '2025-06-21 00:42:53'),
(3991, '9f34afd9-520a-4543-8dc7-be54008c88a0', 2, 3, 981, 'document.document_detail', 'messages', 'تفاصيل الوثيقة', 'active', NULL, NULL, '2025-06-21 00:42:53', '2025-06-21 00:42:53'),
(3992, '9f34afd9-5509-45e4-a8e1-69e0dffd75b6', 2, 3, 982, 'document.notes', 'messages', 'ملاحظات', 'active', NULL, NULL, '2025-06-21 00:42:53', '2025-06-21 00:42:53'),
(3993, '9f34afd9-57fd-40bc-bbd6-4238de5ace47', 2, 3, 984, 'document.attachment', 'messages', 'المرفق', 'active', NULL, NULL, '2025-06-21 00:42:53', '2025-06-21 00:42:53'),
(3994, '9f34afd9-5af1-4a23-b963-650ace4712c8', 2, 3, 976, 'document.select_account', 'messages', 'حدد حساب', 'active', NULL, NULL, '2025-06-21 00:42:53', '2025-06-21 00:42:53'),
(3995, '9f34afd9-5dee-48e2-b42c-fd5bc5d09734', 2, 3, 978, 'document.in_percentage', 'messages', 'النسبة المئوية', 'active', NULL, NULL, '2025-06-21 00:42:53', '2025-06-21 00:42:53'),
(3996, '9f34afd9-6219-4d60-b9c0-c3b512b56c10', 2, 3, 977, 'document.select_admission_id', 'messages', 'حدد رقم التسجيل', 'active', NULL, NULL, '2025-06-21 00:42:53', '2025-06-21 00:42:53'),
(3997, '9f34afd9-6518-4b65-8186-68e2797bb511', 2, 3, 985, 'document.change_attachment', 'messages', 'تغيير المرفق', 'active', NULL, NULL, '2025-06-21 00:42:53', '2025-06-21 00:42:53'),
(3998, '9f34afd9-69af-4545-8b3a-66f7fb70e5a8', 2, 3, 986, 'document.document_file_size', 'messages', 'يجب أن يكون الملف من النوع: jpeg، jpg، png، pdf، doc، docx.، mp3، mp4', 'active', NULL, NULL, '2025-06-21 00:42:53', '2025-06-21 00:42:53'),
(3999, '9f34afd9-717f-4bfb-b4ac-c95e8965027a', 2, 3, 980, 'document.uploaded_by', 'messages', 'تم الرفع بواسطة', 'active', NULL, NULL, '2025-06-21 00:42:53', '2025-06-21 00:42:53'),
(4000, '9f34afd9-754c-434e-b195-49c73a584df3', 2, 3, 983, 'document.view', 'messages', 'منظر', 'active', NULL, NULL, '2025-06-21 00:42:53', '2025-06-21 00:42:53'),
(4001, '9f34afd9-78af-4671-bbe7-cae51718df9e', 2, 3, 987, 'patient_admission.patient_admission', 'messages', 'قبول المريض', 'active', NULL, NULL, '2025-06-21 00:42:53', '2025-06-21 00:42:53'),
(4002, '9f34afd9-7db5-4871-8af3-9598ebe3f0cc', 2, 3, 988, 'patient_admission.new_patient_admission', 'messages', 'قبول المريض الجديد', 'active', NULL, NULL, '2025-06-21 00:42:53', '2025-06-21 00:42:53'),
(4003, '9f34afd9-837a-4981-810a-4ab28547c5d0', 2, 3, 989, 'patient_admission.edit_patient_admission', 'messages', 'تحرير قبول المريض', 'active', NULL, NULL, '2025-06-21 00:42:53', '2025-06-21 00:42:53'),
(4004, '9f34afd9-8852-4e7c-b39d-a785cd475870', 2, 3, 990, 'patient_admission.details', 'messages', 'تفاصيل قبول المريض', 'active', NULL, NULL, '2025-06-21 00:42:53', '2025-06-21 00:42:53'),
(4005, '9f34afd9-8ce6-46af-8cb0-4dcca03456d2', 2, 3, 991, 'patient_admission.patient', 'messages', 'صبور', 'active', NULL, NULL, '2025-06-21 00:42:53', '2025-06-21 00:42:53'),
(4006, '9f34afd9-8ffc-48e5-a655-3bcbfcf6a648', 2, 3, 992, 'patient_admission.patient_name', 'messages', 'اسم المريض', 'active', NULL, NULL, '2025-06-21 00:42:53', '2025-06-21 00:42:53'),
(4007, '9f34afd9-93c9-45ce-be97-a8e7d5a07065', 2, 3, 993, 'patient_admission.doctor', 'messages', 'طبيب', 'active', NULL, NULL, '2025-06-21 00:42:53', '2025-06-21 00:42:53'),
(4008, '9f34afd9-96d8-4699-9427-cda2dcb4cd59', 2, 3, 994, 'patient_admission.doctor_name', 'messages', 'اسم الطبيب', 'active', NULL, NULL, '2025-06-21 00:42:53', '2025-06-21 00:42:53'),
(4009, '9f34afd9-99df-4f40-b2d2-c072fad223a7', 2, 3, 995, 'patient_admission.admission_date', 'messages', 'تاريخ القبول', 'active', NULL, NULL, '2025-06-21 00:42:53', '2025-06-21 00:42:53'),
(4010, '9f34afd9-9cc3-474d-b09f-f4a3f0be311d', 2, 3, 996, 'patient_admission.discharge_date', 'messages', 'تاريخ التفريغ', 'active', NULL, NULL, '2025-06-21 00:42:53', '2025-06-21 00:42:53'),
(4011, '9f34afd9-9fe4-444d-9e98-9d6b5122e76f', 2, 3, 997, 'patient_admission.package', 'messages', 'صفقة', 'active', NULL, NULL, '2025-06-21 00:42:53', '2025-06-21 00:42:53'),
(4012, '9f34afd9-a328-4493-9f10-aee7ae1cd5f3', 2, 3, 998, 'patient_admission.package_name', 'messages', 'اسم الحزمة', 'active', NULL, NULL, '2025-06-21 00:42:53', '2025-06-21 00:42:53'),
(4013, '9f34afd9-a634-441f-910d-ad8b0ea23fd7', 2, 3, 999, 'patient_admission.insurance', 'messages', 'تأمين', 'active', NULL, NULL, '2025-06-21 00:42:53', '2025-06-21 00:42:53'),
(4014, '9f34afd9-a934-4d5f-971c-5527c01f9eeb', 2, 3, 1000, 'patient_admission.insurance_name', 'messages', 'اسم التأمين', 'active', NULL, NULL, '2025-06-21 00:42:53', '2025-06-21 00:42:53'),
(4015, '9f34afd9-ac5a-484f-9b49-7af3397bba19', 2, 3, 1001, 'patient_admission.policy_no', 'messages', 'لا توجد سياسة', 'active', NULL, NULL, '2025-06-21 00:42:53', '2025-06-21 00:42:53'),
(4016, '9f34afd9-af74-4965-bcf3-2b007552f60a', 2, 3, 1002, 'patient_admission.bed', 'messages', 'السرير', 'active', NULL, NULL, '2025-06-21 00:42:53', '2025-06-21 00:42:53'),
(4017, '9f34afd9-b28a-4c5f-9c28-b7a780169593', 2, 3, 1003, 'patient_admission.agent_name', 'messages', 'اسم العميل', 'active', NULL, NULL, '2025-06-21 00:42:53', '2025-06-21 00:42:53'),
(4018, '9f34afd9-b590-47ea-afb2-ac1791b7b143', 2, 3, 1004, 'patient_admission.guardian_name', 'messages', 'اسم الوصي', 'active', NULL, NULL, '2025-06-21 00:42:53', '2025-06-21 00:42:53'),
(4019, '9f34afd9-b89d-4636-83b7-421bc6c327dc', 2, 3, 1005, 'patient_admission.guardian_relation', 'messages', 'علاقة الوصي', 'active', NULL, NULL, '2025-06-21 00:42:53', '2025-06-21 00:42:53'),
(4020, '9f34afd9-bbc6-458e-9821-1d33e7940c3f', 2, 3, 1006, 'patient_admission.guardian_contact', 'messages', 'جهة اتصال الوصي', 'active', NULL, NULL, '2025-06-21 00:42:53', '2025-06-21 00:42:53'),
(4021, '9f34afd9-beda-4b8b-ac9b-2838b071e182', 2, 3, 1007, 'patient_admission.guardian_address', 'messages', 'عنوان ولي الأمر', 'active', NULL, NULL, '2025-06-21 00:42:53', '2025-06-21 00:42:53'),
(4022, '9f34afd9-c1d8-4701-af0e-6801945aa897', 2, 3, 1008, 'patient_admission.patient_admission_id', 'messages', 'معرف قبول المريض', 'active', NULL, NULL, '2025-06-21 00:42:53', '2025-06-21 00:42:53'),
(4023, '9f34afd9-c506-4be7-91c5-a17ce4940c30', 2, 3, 1009, 'patient_admission.select_package', 'messages', 'اختر الباقة', 'active', NULL, NULL, '2025-06-21 00:42:54', '2025-06-21 00:42:54'),
(4024, '9f34afd9-c9ca-4ba2-9d81-2fd2a72ba9a7', 2, 3, 1010, 'patient_admission.select_insurance', 'messages', 'حدد التأمين', 'active', NULL, NULL, '2025-06-21 00:42:54', '2025-06-21 00:42:54'),
(4025, '9f34afd9-ccf9-406c-8e94-d1058df75ff6', 2, 3, 1011, 'setting.paystack', 'messages', 'الراتب', 'active', NULL, NULL, '2025-06-21 00:42:54', '2025-06-21 00:42:54'),
(4026, '9f34afd9-d00f-4b7f-8e2d-8697f1cecfa7', 2, 3, 1012, 'setting.paystack_public_key', 'messages', 'المفتاح العمومي الراتب', 'active', NULL, NULL, '2025-06-21 00:42:54', '2025-06-21 00:42:54'),
(4027, '9f34afd9-d30f-4f85-9704-23489c69051d', 2, 3, 1013, 'setting.paystack_secret_key', 'messages', 'المفتاح السري الراتب', 'active', NULL, NULL, '2025-06-21 00:42:54', '2025-06-21 00:42:54'),
(4028, '9f34afd9-d606-4e97-b914-77b5a47c881d', 2, 3, 1014, 'setting.paytm', 'messages', 'بايتم', 'active', NULL, NULL, '2025-06-21 00:42:54', '2025-06-21 00:42:54');
INSERT INTO `ltu_phrases` (`id`, `uuid`, `translation_id`, `translation_file_id`, `phrase_id`, `key`, `group`, `value`, `status`, `parameters`, `note`, `created_at`, `updated_at`) VALUES
(4029, '9f34afd9-d916-4436-a599-b9ac201bf527', 2, 3, 1015, 'setting.paytm_merchant_id', 'messages', 'معرف تاجر بايتم', 'active', NULL, NULL, '2025-06-21 00:42:54', '2025-06-21 00:42:54'),
(4030, '9f34afd9-dc28-44d6-80c3-78ca28479ef1', 2, 3, 1016, 'setting.paytm_merchant_key', 'messages', 'مفتاح تاجر بايتم', 'active', NULL, NULL, '2025-06-21 00:42:54', '2025-06-21 00:42:54'),
(4031, '9f34afd9-df52-45e0-b08f-e21b91444f38', 2, 3, 1017, 'setting.app_name', 'messages', 'اسم التطبيق', 'active', NULL, NULL, '2025-06-21 00:42:54', '2025-06-21 00:42:54'),
(4032, '9f34afd9-e286-4bef-9800-fa3ec649b7e8', 2, 3, 1018, 'setting.company_name', 'messages', 'اسم الشركة', 'active', NULL, NULL, '2025-06-21 00:42:54', '2025-06-21 00:42:54'),
(4033, '9f34afd9-e5bf-4638-9de8-1f22941dc038', 2, 3, 1019, 'setting.app_logo', 'messages', 'شعار التطبيق', 'active', NULL, NULL, '2025-06-21 00:42:54', '2025-06-21 00:42:54'),
(4034, '9f34afd9-e8ed-40d9-bf49-55b95b435fa0', 2, 3, 1021, 'setting.currency', 'messages', 'العملة الحالية', 'active', NULL, NULL, '2025-06-21 00:42:54', '2025-06-21 00:42:54'),
(4035, '9f34afd9-ec03-4601-8c86-96f5d8eae8aa', 2, 3, 1022, 'setting.address', 'messages', 'عنوان المستشفى', 'active', NULL, NULL, '2025-06-21 00:42:54', '2025-06-21 00:42:54'),
(4036, '9f34afd9-ef0a-4e9c-ae5b-590bb1babc4e', 2, 3, 1023, 'setting.hospital_email', 'messages', 'البريد الإلكتروني للمستشفى', 'active', NULL, NULL, '2025-06-21 00:42:54', '2025-06-21 00:42:54'),
(4037, '9f34afd9-f269-48ab-b027-62e46566194e', 2, 3, 1024, 'setting.hospital_phone', 'messages', 'هاتف المستشفى', 'active', NULL, NULL, '2025-06-21 00:42:54', '2025-06-21 00:42:54'),
(4038, '9f34afd9-f589-44f3-a5c6-154124757d08', 2, 3, 1025, 'setting.hospital_from_day', 'messages', 'المستشفى من اليوم', 'active', NULL, NULL, '2025-06-21 00:42:54', '2025-06-21 00:42:54'),
(4039, '9f34afd9-f89d-4b64-bf52-930ab69bece4', 2, 3, 1026, 'setting.hospital_from_time', 'messages', 'المستشفى من حين لآخر', 'active', NULL, NULL, '2025-06-21 00:42:54', '2025-06-21 00:42:54'),
(4040, '9f34afd9-fbbb-4d10-a7d2-97c646ead6cf', 2, 3, 1027, 'setting.about_us', 'messages', 'معلومات عنا', 'active', NULL, NULL, '2025-06-21 00:42:54', '2025-06-21 00:42:54'),
(4041, '9f34afd9-fef4-48dc-9093-1b632e3d8587', 2, 3, 1028, 'setting.image_validation', 'messages', 'يجب أن تكون الصورة بمقاس 90 × 60 بكسل.', 'active', NULL, NULL, '2025-06-21 00:42:54', '2025-06-21 00:42:54'),
(4042, '9f34afda-01f1-4ecd-8779-5c77b49e8245', 2, 3, 1029, 'setting.favicon', 'messages', 'فافيكون', 'active', NULL, NULL, '2025-06-21 00:42:54', '2025-06-21 00:42:54'),
(4043, '9f34afda-04f8-4023-a12f-50ff36c24703', 2, 3, 1031, 'setting.favicon_validation', 'messages', 'يجب أن تكون الصورة بمقاس 34 × 34 بكسل.', 'active', NULL, NULL, '2025-06-21 00:42:54', '2025-06-21 00:42:54'),
(4044, '9f34afda-0801-4cfb-a439-f29aec07749a', 2, 3, 1032, 'setting.social_details', 'messages', 'التفاصيل الاجتماعية', 'active', NULL, NULL, '2025-06-21 00:42:54', '2025-06-21 00:42:54'),
(4045, '9f34afda-0b38-4da0-b22b-2c20af071597', 2, 3, 1033, 'setting.enable_google_reCAPTCHA', 'messages', 'تمكين جوجل ريكابتشا', 'active', NULL, NULL, '2025-06-21 00:42:54', '2025-06-21 00:42:54'),
(4046, '9f34afda-0f87-4190-a14f-5c0339980a58', 2, 3, 1020, 'setting.change_logo', 'messages', 'تغيير الشعار', 'active', NULL, NULL, '2025-06-21 00:42:54', '2025-06-21 00:42:54'),
(4047, '9f34afda-12c6-42cb-91aa-78f14b85a9e4', 2, 3, 1030, 'setting.change_favicon', 'messages', 'تغيير الرمز المفضل', 'active', NULL, NULL, '2025-06-21 00:42:54', '2025-06-21 00:42:54'),
(4048, '9f34afda-15da-4042-8aa9-4a5852487821', 2, 3, 1037, 'setting.stripe', 'messages', 'شريط', 'active', NULL, NULL, '2025-06-21 00:42:54', '2025-06-21 00:42:54'),
(4049, '9f34afda-1944-44cc-a751-125b7a60b3cd', 2, 3, 1038, 'setting.stripe_key', 'messages', 'مفتاح الشريط', 'active', NULL, NULL, '2025-06-21 00:42:54', '2025-06-21 00:42:54'),
(4050, '9f34afda-1c92-4f86-8467-cb78d0a6d047', 2, 3, 1039, 'setting.stripe_secret', 'messages', 'سر الشريط ،', 'active', NULL, NULL, '2025-06-21 00:42:54', '2025-06-21 00:42:54'),
(4051, '9f34afda-1fea-4c54-b00a-5947cf43a0a3', 2, 3, 1040, 'setting.paypal_secret', 'messages', 'سر باي بال', 'active', NULL, NULL, '2025-06-21 00:42:54', '2025-06-21 00:42:54'),
(4052, '9f34afda-230c-47c1-8554-c139bc0e9aa6', 2, 3, 1041, 'setting.paypal_client_id', 'messages', 'معرف عميل باي بال', 'active', NULL, NULL, '2025-06-21 00:42:54', '2025-06-21 00:42:54'),
(4053, '9f34afda-262e-4d50-b4df-2a278dec3b2e', 2, 3, 1042, 'setting.paypal_mode', 'messages', 'وضع باي بال', 'active', NULL, NULL, '2025-06-21 00:42:54', '2025-06-21 00:42:54'),
(4054, '9f34afda-2924-4911-b997-b97ff6b6b609', 2, 3, 1043, 'setting.paypal', 'messages', 'باي بال', 'active', NULL, NULL, '2025-06-21 00:42:54', '2025-06-21 00:42:54'),
(4055, '9f34afda-2c34-419a-9e8f-a1ba903ca7a7', 2, 3, 1044, 'setting.paypal_key', 'messages', 'مفتاح باي بال', 'active', NULL, NULL, '2025-06-21 00:42:54', '2025-06-21 00:42:54'),
(4056, '9f34afda-2f32-4029-9994-3de8c85a43a6', 2, 3, 1045, 'setting.razorpay_key', 'messages', 'مفتاح رازورباي', 'active', NULL, NULL, '2025-06-21 00:42:54', '2025-06-21 00:42:54'),
(4057, '9f34afda-3238-436f-a540-237b2ac4b981', 2, 3, 1046, 'setting.razorpay_secret', 'messages', 'سر رازورباي', 'active', NULL, NULL, '2025-06-21 00:42:54', '2025-06-21 00:42:54'),
(4058, '9f34afda-3586-4d94-97e7-7ed92711230e', 2, 3, 1047, 'setting.razorpay', 'messages', 'رازورباي', 'active', NULL, NULL, '2025-06-21 00:42:54', '2025-06-21 00:42:54'),
(4059, '9f34afda-38c4-44b3-9eee-3cc21fed4bce', 2, 3, 1048, 'setting.payment_gateway', 'messages', 'بوابة الدفع', 'active', NULL, NULL, '2025-06-21 00:42:54', '2025-06-21 00:42:54'),
(4060, '9f34afda-3be9-4de5-9f57-c0297994e415', 2, 3, 1034, 'setting.credential', 'messages', 'بيانات الاعتماد', 'active', NULL, NULL, '2025-06-21 00:42:54', '2025-06-21 00:42:54'),
(4061, '9f34afda-3efc-4ef6-9677-87c1f33e6daa', 2, 3, 1035, 'setting.clinic_name', 'messages', 'اسم العيادة', 'active', NULL, NULL, '2025-06-21 00:42:54', '2025-06-21 00:42:54'),
(4062, '9f34afda-425e-4af5-80eb-063511054913', 2, 3, 1036, 'setting.credentials', 'messages', 'أوراق اعتماد', 'active', NULL, NULL, '2025-06-21 00:42:54', '2025-06-21 00:42:54'),
(4063, '9f34afda-456f-4a31-b006-f5d4a51e6992', 2, 3, 1049, 'currency.currencies', 'messages', 'العملات', 'active', NULL, NULL, '2025-06-21 00:42:54', '2025-06-21 00:42:54'),
(4064, '9f34afda-4892-4414-b946-34ccfe310dfc', 2, 3, 1050, 'currency.new_currency', 'messages', 'عملة جديدة', 'active', NULL, NULL, '2025-06-21 00:42:54', '2025-06-21 00:42:54'),
(4065, '9f34afda-4bae-4a62-a19d-2003bec4e335', 2, 3, 1051, 'currency.edit_currency', 'messages', 'تحرير العملة', 'active', NULL, NULL, '2025-06-21 00:42:54', '2025-06-21 00:42:54'),
(4066, '9f34afda-4ee6-42e4-8fe0-e29f2dd2b318', 2, 3, 1052, 'currency.currency_name', 'messages', 'اسم العملة', 'active', NULL, NULL, '2025-06-21 00:42:54', '2025-06-21 00:42:54'),
(4067, '9f34afda-51f1-4117-9595-e44aa6c3ec19', 2, 3, 1053, 'currency.currency_code', 'messages', 'رمز العملة', 'active', NULL, NULL, '2025-06-21 00:42:54', '2025-06-21 00:42:54'),
(4068, '9f34afda-5507-4df0-a375-db0972af650c', 2, 3, 1054, 'currency.currency_icon', 'messages', 'رمز العملة', 'active', NULL, NULL, '2025-06-21 00:42:54', '2025-06-21 00:42:54'),
(4069, '9f34afda-5819-4250-abe1-edecdfe1e922', 2, 3, 1055, 'currency.add_currency_code_as_per_three_letter_iso_code', 'messages', 'أضف رمز العملة وفقًا لرمز ISO المكون من ثلاثة أحرف.', 'active', NULL, NULL, '2025-06-21 00:42:54', '2025-06-21 00:42:54'),
(4070, '9f34afda-5b34-43d9-9695-288246f6cfb0', 2, 3, 1056, 'currency.you_can_find_out_here', 'messages', 'يمكنك ان تجد هنا', 'active', NULL, NULL, '2025-06-21 00:42:54', '2025-06-21 00:42:54'),
(4071, '9f34afda-5e59-473e-b5f7-6c13324a76de', 2, 3, 1057, 'schedule.new', 'messages', 'جدول جديد', 'active', NULL, NULL, '2025-06-21 00:42:54', '2025-06-21 00:42:54'),
(4072, '9f34afda-6187-4af1-b05b-9b7f40a18b34', 2, 3, 1058, 'schedule.edit', 'messages', 'تحرير الجدول', 'active', NULL, NULL, '2025-06-21 00:42:54', '2025-06-21 00:42:54'),
(4073, '9f34afda-64a3-41d5-9af6-3d5a5471df50', 2, 3, 1059, 'schedule.details', 'messages', 'تفاصيل الجدول', 'active', NULL, NULL, '2025-06-21 00:42:54', '2025-06-21 00:42:54'),
(4074, '9f34afda-6805-4bfe-afba-2d2dce592477', 2, 3, 1060, 'schedule.doctor_name', 'messages', 'اسم الطبيب', 'active', NULL, NULL, '2025-06-21 00:42:54', '2025-06-21 00:42:54'),
(4075, '9f34afda-6b63-44ab-b6a6-1d2de5dfdbdc', 2, 3, 1061, 'schedule.select_doctor_name', 'messages', 'حدد اسم الطبيب', 'active', NULL, NULL, '2025-06-21 00:42:54', '2025-06-21 00:42:54'),
(4076, '9f34afda-6e9d-410c-9563-29b6274b8638', 2, 3, 1062, 'schedule.per_patient_time', 'messages', 'لكل مريض', 'active', NULL, NULL, '2025-06-21 00:42:54', '2025-06-21 00:42:54'),
(4077, '9f34afda-71b6-4305-8f1b-aa3202746dcc', 2, 3, 1063, 'schedule.serial_visibility', 'messages', 'الرؤية التسلسلية', 'active', NULL, NULL, '2025-06-21 00:42:54', '2025-06-21 00:42:54'),
(4078, '9f34afda-74d4-4c4a-b395-ee7027a7563d', 2, 3, 1064, 'schedule.select_serial_visibility', 'messages', 'حدد الرؤية التسلسلية', 'active', NULL, NULL, '2025-06-21 00:42:54', '2025-06-21 00:42:54'),
(4079, '9f34afda-77e0-46ff-b5cc-38367c092c07', 2, 3, 1065, 'schedule.available_on', 'messages', 'متاح على', 'active', NULL, NULL, '2025-06-21 00:42:54', '2025-06-21 00:42:54'),
(4080, '9f34afda-7afe-48d6-a76b-536761571724', 2, 3, 1066, 'schedule.available_from', 'messages', 'متاح من', 'active', NULL, NULL, '2025-06-21 00:42:54', '2025-06-21 00:42:54'),
(4081, '9f34afda-7e07-4da4-b844-d16b2b5e546d', 2, 3, 1067, 'schedule.available_to', 'messages', 'متاحة لل', 'active', NULL, NULL, '2025-06-21 00:42:54', '2025-06-21 00:42:54'),
(4082, '9f34afda-811a-4da3-8e8b-cede64ce62f5', 2, 3, 1068, 'schedule.sequential', 'messages', 'تسلسلي', 'active', NULL, NULL, '2025-06-21 00:42:54', '2025-06-21 00:42:54'),
(4083, '9f34afda-844a-42e9-a730-ad92f69d1a10', 2, 3, 1069, 'schedule.timestamp', 'messages', 'الطابع الزمني', 'active', NULL, NULL, '2025-06-21 00:42:54', '2025-06-21 00:42:54'),
(4084, '9f34afda-8763-4789-a3b9-440e3e64b690', 2, 3, 1070, 'notice_board.new', 'messages', 'لوحة الإعلانات الجديدة', 'active', NULL, NULL, '2025-06-21 00:42:54', '2025-06-21 00:42:54'),
(4085, '9f34afda-8aaa-4574-853c-37bb50dfe143', 2, 3, 1071, 'notice_board.edit', 'messages', 'تحرير لوحة الإعلانات', 'active', NULL, NULL, '2025-06-21 00:42:54', '2025-06-21 00:42:54'),
(4086, '9f34afda-8dd2-400c-bf0c-642e58cfb9d7', 2, 3, 1072, 'notice_board.details', 'messages', 'تفاصيل لوحة الإعلانات', 'active', NULL, NULL, '2025-06-21 00:42:54', '2025-06-21 00:42:54'),
(4087, '9f34afda-9105-4490-a073-687a9e8afce9', 2, 3, 1073, 'notice_board.title', 'messages', 'عنوان', 'active', NULL, NULL, '2025-06-21 00:42:54', '2025-06-21 00:42:54'),
(4088, '9f34afda-9455-453b-9723-d92a8edd72a3', 2, 3, 1074, 'notice_board.description', 'messages', 'وصف', 'active', NULL, NULL, '2025-06-21 00:42:54', '2025-06-21 00:42:54'),
(4089, '9f34afda-9776-407f-8d73-bc1b3b282dce', 2, 3, 1075, 'notice_board.created_at', 'messages', 'أنشئت في', 'active', NULL, NULL, '2025-06-21 00:42:54', '2025-06-21 00:42:54'),
(4090, '9f34afda-9a84-4153-8c0e-8e09ff4eeece', 2, 3, 1076, 'my_payroll.my_payrolls', 'messages', 'رواتبي', 'active', NULL, NULL, '2025-06-21 00:42:54', '2025-06-21 00:42:54'),
(4091, '9f34afda-9db1-48d3-9508-f04cd22657c2', 2, 3, 1077, 'my_payroll.basic_salary', 'messages', 'راتب اساسي', 'active', NULL, NULL, '2025-06-21 00:42:54', '2025-06-21 00:42:54'),
(4092, '9f34afda-a0d7-4a16-9087-98c2b966816a', 2, 3, 1078, 'my_payroll.allowance', 'messages', 'Allowance', 'active', NULL, NULL, '2025-06-21 00:42:54', '2025-06-21 00:42:54'),
(4093, '9f34afda-a3fe-4dc5-9558-72caacb257ec', 2, 3, 1079, 'my_payroll.deductions', 'messages', 'الخصومات', 'active', NULL, NULL, '2025-06-21 00:42:54', '2025-06-21 00:42:54'),
(4094, '9f34afda-a728-4cd8-99fa-33f1505868de', 2, 3, 1080, 'my_payroll.net_salary', 'messages', 'صافي الراتب', 'active', NULL, NULL, '2025-06-21 00:42:54', '2025-06-21 00:42:54'),
(4095, '9f34afda-aa68-4ecf-aa15-0a6bb3764789', 2, 3, 1081, 'medicine.medicine', 'messages', 'دواء', 'active', NULL, NULL, '2025-06-21 00:42:54', '2025-06-21 00:42:54'),
(4096, '9f34afda-adc0-4470-8e49-4ce19b7fbe3b', 2, 3, 1082, 'medicine.medicine_category', 'messages', 'فئة الطب', 'active', NULL, NULL, '2025-06-21 00:42:54', '2025-06-21 00:42:54'),
(4097, '9f34afda-b0fb-4288-bb61-19ec7199a810', 2, 3, 1083, 'medicine.medicine_category_details', 'messages', 'تفاصيل فئة الدواء', 'active', NULL, NULL, '2025-06-21 00:42:54', '2025-06-21 00:42:54'),
(4098, '9f34afda-b42e-4e87-ae63-11c5cfbdd46a', 2, 3, 1084, 'medicine.medicines', 'messages', 'أدوية', 'active', NULL, NULL, '2025-06-21 00:42:54', '2025-06-21 00:42:54'),
(4099, '9f34afda-b746-486f-8a88-a2d8254925c6', 2, 3, 1085, 'medicine.medicine_details', 'messages', 'تفاصيل الدواء', 'active', NULL, NULL, '2025-06-21 00:42:54', '2025-06-21 00:42:54'),
(4100, '9f34afda-ba9b-4237-8a98-1f86b55b89a5', 2, 3, 1086, 'medicine.new_medicine', 'messages', 'الطب الجديد', 'active', NULL, NULL, '2025-06-21 00:42:54', '2025-06-21 00:42:54'),
(4101, '9f34afda-bdd6-46d7-ae3a-910aa6ed545c', 2, 3, 1087, 'medicine.new_medicine_category', 'messages', 'فئة الطب الجديد', 'active', NULL, NULL, '2025-06-21 00:42:54', '2025-06-21 00:42:54'),
(4102, '9f34afda-c0ed-4b93-a4a3-d19489c9a356', 2, 3, 1088, 'medicine.edit_medicine_category', 'messages', 'تحرير فئة الدواء', 'active', NULL, NULL, '2025-06-21 00:42:54', '2025-06-21 00:42:54'),
(4103, '9f34afda-c420-4611-89ab-c71cec388b4c', 2, 3, 1089, 'medicine.edit_medicine', 'messages', 'تحرير الطب', 'active', NULL, NULL, '2025-06-21 00:42:54', '2025-06-21 00:42:54'),
(4104, '9f34afda-c74e-41b7-87e0-03d9c6b664c4', 2, 3, 1090, 'medicine.name', 'messages', 'اسم', 'active', NULL, NULL, '2025-06-21 00:42:54', '2025-06-21 00:42:54'),
(4105, '9f34afda-ca61-40ca-8e7c-56223bc627c2', 2, 3, 1091, 'medicine.brand', 'messages', 'العلامة التجارية', 'active', NULL, NULL, '2025-06-21 00:42:54', '2025-06-21 00:42:54'),
(4106, '9f34afda-cd9d-4381-8fd4-21f37ce63260', 2, 3, 1092, 'medicine.selling_price', 'messages', 'سعر البيع', 'active', NULL, NULL, '2025-06-21 00:42:54', '2025-06-21 00:42:54'),
(4107, '9f34afda-d0c9-4ae5-a8e1-bb9eaab69da2', 2, 3, 1093, 'medicine.buying_price', 'messages', 'سعر الشراء', 'active', NULL, NULL, '2025-06-21 00:42:54', '2025-06-21 00:42:54'),
(4108, '9f34afda-d3fe-45bf-a3db-fd8966e21a4b', 2, 3, 1094, 'medicine.category', 'messages', 'فئة', 'active', NULL, NULL, '2025-06-21 00:42:54', '2025-06-21 00:42:54'),
(4109, '9f34afda-d880-4706-bf5a-caa26ef7ba3f', 2, 3, 1095, 'medicine.salt_composition', 'messages', 'تكوين الملح', 'active', NULL, NULL, '2025-06-21 00:42:54', '2025-06-21 00:42:54'),
(4110, '9f34afda-dbc9-4231-899f-140f1c3730a9', 2, 3, 1096, 'medicine.side_effects', 'messages', 'آثار جانبية', 'active', NULL, NULL, '2025-06-21 00:42:54', '2025-06-21 00:42:54'),
(4111, '9f34afda-df07-4abb-bd46-336e504914c5', 2, 3, 1097, 'medicine.description', 'messages', 'وصف', 'active', NULL, NULL, '2025-06-21 00:42:54', '2025-06-21 00:42:54'),
(4112, '9f34afda-e245-41b0-96e4-59a746ca38e6', 2, 3, 1098, 'medicine.category_id', 'messages', 'معرف الفئة', 'active', NULL, NULL, '2025-06-21 00:42:54', '2025-06-21 00:42:54'),
(4113, '9f34afda-e5c1-4d2c-8b4e-838bd3930bef', 2, 3, 1099, 'medicine.brand_name', 'messages', 'اسم العلامة التجارية', 'active', NULL, NULL, '2025-06-21 00:42:54', '2025-06-21 00:42:54'),
(4114, '9f34afda-e8df-4698-8e56-ba0a36c3b22a', 2, 3, 1101, 'medicine.medicine_brands_details', 'messages', 'تفاصيل العلامة التجارية للأدوية', 'active', NULL, NULL, '2025-06-21 00:42:54', '2025-06-21 00:42:54'),
(4115, '9f34afda-ec20-4f05-9744-41745f9979b3', 2, 3, 1102, 'medicine.new_brand', 'messages', 'العلامة التجارية الجديدة', 'active', NULL, NULL, '2025-06-21 00:42:54', '2025-06-21 00:42:54'),
(4116, '9f34afda-ef54-4bb8-8b78-9cb07b5430d7', 2, 3, 1103, 'medicine.new_medicine_brand', 'messages', 'العلامة التجارية للطب الجديد', 'active', NULL, NULL, '2025-06-21 00:42:54', '2025-06-21 00:42:54'),
(4117, '9f34afda-f27b-46b5-a2d0-c0ef1d7b5f80', 2, 3, 1104, 'medicine.edit_medicine_brand', 'messages', 'تعديل العلامة التجارية للطب', 'active', NULL, NULL, '2025-06-21 00:42:54', '2025-06-21 00:42:54'),
(4118, '9f34afda-f5a1-4698-b0bb-3f3400f730e4', 2, 3, 1100, 'medicine.medicine_brands', 'messages', 'ماركات الطب', 'active', NULL, NULL, '2025-06-21 00:42:54', '2025-06-21 00:42:54'),
(4119, '9f34afda-f8d5-4960-b56d-146e158ba9f2', 2, 3, 1105, 'medicine.select_category', 'messages', 'اختر الفئة', 'active', NULL, NULL, '2025-06-21 00:42:54', '2025-06-21 00:42:54'),
(4120, '9f34afda-fc34-4f18-a07c-2c1bb322dc9f', 2, 3, 1106, 'medicine.select_brand', 'messages', 'اختر الماركة', 'active', NULL, NULL, '2025-06-21 00:42:54', '2025-06-21 00:42:54'),
(4121, '9f34afda-ff9b-4d26-8bda-16b34ade28df', 2, 3, 1107, 'medicine.is_active', 'messages', 'نشيط', 'active', NULL, NULL, '2025-06-21 00:42:54', '2025-06-21 00:42:54'),
(4122, '9f34afdb-02e5-45a7-a7f9-3bb9f4406e32', 2, 3, 1108, 'profile.change_language', 'messages', 'تغيير اللغة', 'active', NULL, NULL, '2025-06-21 00:42:54', '2025-06-21 00:42:54'),
(4123, '9f34afdb-0642-4b5b-be7f-085e59549ba1', 2, 3, 1111, 'profile.language', 'messages', 'لغة', 'active', NULL, NULL, '2025-06-21 00:42:54', '2025-06-21 00:42:54'),
(4124, '9f34afdb-0966-4063-a9f4-e83a2f099285', 2, 3, 1112, 'profile.edit_profile', 'messages', 'تعديل الملف الشخصي', 'active', NULL, NULL, '2025-06-21 00:42:54', '2025-06-21 00:42:54'),
(4125, '9f34afdb-0cea-43cd-bd17-091bfc02f8f2', 2, 3, 1114, 'profile.first_name', 'messages', 'الاسم الأول', 'active', NULL, NULL, '2025-06-21 00:42:54', '2025-06-21 00:42:54'),
(4126, '9f34afdb-1026-4003-9c8f-1d17149c1aa6', 2, 3, 1115, 'profile.last_name', 'messages', 'الكنية', 'active', NULL, NULL, '2025-06-21 00:42:54', '2025-06-21 00:42:54'),
(4127, '9f34afdb-136a-4dc9-b430-ef88f073a175', 2, 3, 1116, 'profile.email', 'messages', 'بريد إلكتروني', 'active', NULL, NULL, '2025-06-21 00:42:54', '2025-06-21 00:42:54'),
(4128, '9f34afdb-16a8-450e-87d9-74f733ca93b8', 2, 3, 1117, 'profile.phone', 'messages', 'هاتف', 'active', NULL, NULL, '2025-06-21 00:42:54', '2025-06-21 00:42:54'),
(4129, '9f34afdb-19e0-445c-8b1a-ee4ae5051dd5', 2, 3, 1118, 'profile.profile', 'messages', 'الملف الشخصي', 'active', NULL, NULL, '2025-06-21 00:42:54', '2025-06-21 00:42:54'),
(4130, '9f34afdb-1d12-4dc9-b79f-6a69516dec51', 2, 3, 1109, 'profile.change_Profile', 'messages', 'تغيير ملف التكوين', 'active', NULL, NULL, '2025-06-21 00:42:54', '2025-06-21 00:42:54'),
(4131, '9f34afdb-203a-4b80-b4dc-6a2d4afc737b', 2, 3, 1113, 'profile.full_name', 'messages', 'الاسم الكامل', 'active', NULL, NULL, '2025-06-21 00:42:54', '2025-06-21 00:42:54'),
(4132, '9f34afdb-2362-4f21-914c-40f40cd53dc3', 2, 3, 1119, 'profile.type', 'messages', 'يكتب', 'active', NULL, NULL, '2025-06-21 00:42:54', '2025-06-21 00:42:54'),
(4133, '9f34afdb-268e-4064-8195-8393172883bd', 2, 3, 1110, 'profile.change_post_image', 'messages', 'تغيير صورة ما بعد', 'active', NULL, NULL, '2025-06-21 00:42:54', '2025-06-21 00:42:54'),
(4134, '9f34afdb-29d7-4664-b5ba-8cedcdb1a5b7', 2, 3, 1120, 'dashboard.dashboard', 'messages', 'لوحة القيادة', 'active', NULL, NULL, '2025-06-21 00:42:54', '2025-06-21 00:42:54'),
(4135, '9f34afdb-2ea4-4236-a51e-4e1b5738f018', 2, 3, 1121, 'dashboard.total_invoices', 'messages', 'المبلغ الإجمالي للفاتورة', 'active', NULL, NULL, '2025-06-21 00:42:54', '2025-06-21 00:42:54'),
(4136, '9f34afdb-320a-4ace-81e1-a2b85c170323', 2, 3, 1122, 'dashboard.total_bills', 'messages', 'المبلغ المفوتر', 'active', NULL, NULL, '2025-06-21 00:42:54', '2025-06-21 00:42:54'),
(4137, '9f34afdb-357e-4751-968d-2e9bbf36c271', 2, 3, 1123, 'dashboard.total_payments', 'messages', 'المبلغ الإجمالي للدفع', 'active', NULL, NULL, '2025-06-21 00:42:54', '2025-06-21 00:42:54'),
(4138, '9f34afdb-38c4-4d37-bd06-c10335a62f84', 2, 3, 1124, 'dashboard.total_advance_payments', 'messages', 'المبلغ الإجمالي للدفع المسبق', 'active', NULL, NULL, '2025-06-21 00:42:54', '2025-06-21 00:42:54'),
(4139, '9f34afdb-3bfe-4e01-9303-8959201f6dc1', 2, 3, 1125, 'dashboard.notice_boards', 'messages', 'لافتات تنبيه', 'active', NULL, NULL, '2025-06-21 00:42:54', '2025-06-21 00:42:54'),
(4140, '9f34afdb-3f44-41e9-b3ae-a9b9f20ebe81', 2, 3, 1126, 'dashboard.title', 'messages', 'عنوان', 'active', NULL, NULL, '2025-06-21 00:42:54', '2025-06-21 00:42:54'),
(4141, '9f34afdb-427b-4fc4-a682-15cea9ff4663', 2, 3, 1127, 'dashboard.doctors', 'messages', 'الأطباء', 'active', NULL, NULL, '2025-06-21 00:42:54', '2025-06-21 00:42:54'),
(4142, '9f34afdb-45a4-429f-bb17-d8fd25c930fb', 2, 3, 1128, 'dashboard.available_beds', 'messages', 'الأسرة المتاحة', 'active', NULL, NULL, '2025-06-21 00:42:54', '2025-06-21 00:42:54'),
(4143, '9f34afdb-48e0-4f95-bdca-ca44132a8fc8', 2, 3, 1129, 'dashboard.patients', 'messages', 'المرضى', 'active', NULL, NULL, '2025-06-21 00:42:54', '2025-06-21 00:42:54'),
(4144, '9f34afdb-4c18-4563-8ad7-25bd558c294c', 2, 3, 1130, 'dashboard.income_and_expense_report', 'messages', 'تقرير الدخل والمصروفات', 'active', NULL, NULL, '2025-06-21 00:42:55', '2025-06-21 00:42:55'),
(4145, '9f34afdb-4f48-40ec-92f9-e6b9d44b2a2e', 2, 3, 1131, 'dashboard.income_and_expense_reports', 'messages', 'تقارير الدخل والمصروفات', 'active', NULL, NULL, '2025-06-21 00:42:55', '2025-06-21 00:42:55'),
(4146, '9f34afdb-5293-4591-bfab-4faaf135d9cd', 2, 3, 1132, 'dashboard.no_enquiries_yet', 'messages', 'لا توجد استفسارات حتى الآن', 'active', NULL, NULL, '2025-06-21 00:42:55', '2025-06-21 00:42:55'),
(4147, '9f34afdb-55ca-4013-a647-2bfadad95659', 2, 3, 1133, 'dashboard.no_notice_yet', 'messages', 'لا إشعار حتى الآن', 'active', NULL, NULL, '2025-06-21 00:42:55', '2025-06-21 00:42:55'),
(4148, '9f34afdb-590d-4197-90f3-1dfb79f4460d', 2, 3, 1134, 'dashboard.total_hospitals', 'messages', 'إجمالي المستشفيات', 'active', NULL, NULL, '2025-06-21 00:42:55', '2025-06-21 00:42:55'),
(4149, '9f34afdb-5d0d-44dc-afc0-5d38e9f8a283', 2, 3, 1135, 'dashboard.total_subscription_plans', 'messages', 'إجمالي خطط الاشتراك', 'active', NULL, NULL, '2025-06-21 00:42:55', '2025-06-21 00:42:55'),
(4150, '9f34afdb-60fd-4297-9519-2d801b388fa4', 2, 3, 1136, 'dashboard.total_subscribers', 'messages', 'إجمالي المشتركين', 'active', NULL, NULL, '2025-06-21 00:42:55', '2025-06-21 00:42:55'),
(4151, '9f34afdb-6480-45b7-8cab-0a8370441772', 2, 3, 1137, 'dashboard.total_enquiries', 'messages', 'إجمالي الاستفسارات', 'active', NULL, NULL, '2025-06-21 00:42:55', '2025-06-21 00:42:55'),
(4152, '9f34afdb-67e6-4c25-b943-7f3de14730dc', 2, 3, 1138, 'dashboard.total_revenue', 'messages', 'إجمالي الإيرادات', 'active', NULL, NULL, '2025-06-21 00:42:55', '2025-06-21 00:42:55'),
(4153, '9f34afdb-6b34-4636-911d-9eb49fa68fdc', 2, 3, 1139, 'dashboard.total_active_hospital_plan', 'messages', 'إجمالي خطط المستشفى النشطة', 'active', NULL, NULL, '2025-06-21 00:42:55', '2025-06-21 00:42:55'),
(4154, '9f34afdb-6e96-4096-bce6-32483104c5c8', 2, 3, 1140, 'dashboard.total_expired_hospital_plan', 'messages', 'إجمالي خطط المستشفى المنتهية الصلاحية', 'active', NULL, NULL, '2025-06-21 00:42:55', '2025-06-21 00:42:55'),
(4155, '9f34afdb-7201-4889-833d-e4dc5414b24a', 2, 3, 1141, 'dashboard.income_report', 'messages', 'نظرة عامة على الدخل', 'active', NULL, NULL, '2025-06-21 00:42:55', '2025-06-21 00:42:55'),
(4156, '9f34afdb-7557-4705-ae8f-cb0e09466416', 2, 3, 1142, 'dashboard.please_select_rang_picker', 'messages', 'يرجى تحديد Rang Picker', 'active', NULL, NULL, '2025-06-21 00:42:55', '2025-06-21 00:42:55'),
(4157, '9f34afdb-78c0-4019-badb-5cadad39f510', 2, 3, 1143, 'enquiry.name', 'messages', 'اسم', 'active', NULL, NULL, '2025-06-21 00:42:55', '2025-06-21 00:42:55'),
(4158, '9f34afdb-7bff-4b8d-a605-3d1098f31b03', 2, 3, 1144, 'enquiry.email', 'messages', 'البريد الإلكتروني', 'active', NULL, NULL, '2025-06-21 00:42:55', '2025-06-21 00:42:55'),
(4159, '9f34afdb-7f1e-44c4-9d2a-1885377da978', 2, 3, 1145, 'enquiry.contact', 'messages', 'اتصل', 'active', NULL, NULL, '2025-06-21 00:42:55', '2025-06-21 00:42:55'),
(4160, '9f34afdb-8256-4acd-b3ac-894e922299f1', 2, 3, 1146, 'enquiry.type', 'messages', 'اكتب', 'active', NULL, NULL, '2025-06-21 00:42:55', '2025-06-21 00:42:55'),
(4161, '9f34afdb-85a5-4cb5-9900-9e7c08258906', 2, 3, 1147, 'enquiry.message', 'messages', 'رسالة', 'active', NULL, NULL, '2025-06-21 00:42:55', '2025-06-21 00:42:55'),
(4162, '9f34afdb-8924-46b8-a532-6d2d3530e584', 2, 3, 1148, 'enquiry.viewed_by', 'messages', 'تم عرضها بواسطة', 'active', NULL, NULL, '2025-06-21 00:42:55', '2025-06-21 00:42:55'),
(4163, '9f34afdb-8c73-4a79-89ff-49e8e0bc3d44', 2, 3, 1149, 'enquiry.enquiry_details', 'messages', 'تفاصيل الإستفسار', 'active', NULL, NULL, '2025-06-21 00:42:55', '2025-06-21 00:42:55'),
(4164, '9f34afdb-8fb8-4318-aa2b-4a8057ef98b4', 2, 3, 1150, 'enquiry.read', 'messages', 'اقرأ', 'active', NULL, NULL, '2025-06-21 00:42:55', '2025-06-21 00:42:55'),
(4165, '9f34afdb-931c-44ac-8842-72eab5c353a2', 2, 3, 1151, 'enquiry.unread', 'messages', 'غير مقروء', 'active', NULL, NULL, '2025-06-21 00:42:55', '2025-06-21 00:42:55'),
(4166, '9f34afdb-9662-4232-b12e-51d8ac803018', 2, 3, 1152, 'enquiry.not_viewed', 'messages', 'لم يشاهد', 'active', NULL, NULL, '2025-06-21 00:42:55', '2025-06-21 00:42:55'),
(4167, '9f34afdb-99e7-41b7-868e-ccfe094ecb13', 2, 3, 1153, 'enquiry.received_on', 'messages', 'وردت في', 'active', NULL, NULL, '2025-06-21 00:42:55', '2025-06-21 00:42:55'),
(4168, '9f34afdb-9d38-495e-b70b-200925865420', 2, 3, 1154, 'enquiry.send_enquiry', 'messages', 'أرسل إستفسار', 'active', NULL, NULL, '2025-06-21 00:42:55', '2025-06-21 00:42:55'),
(4169, '9f34afdb-a0b2-4589-9580-f6aff3de943b', 2, 3, 1155, 'enquiry.general_enquiry', 'messages', 'استفسار عام', 'active', NULL, NULL, '2025-06-21 00:42:55', '2025-06-21 00:42:55'),
(4170, '9f34afdb-a408-4efc-ae47-904bd67331af', 2, 3, 1156, 'enquiry.residential_care', 'messages', 'الرعاية السكنية', 'active', NULL, NULL, '2025-06-21 00:42:55', '2025-06-21 00:42:55'),
(4171, '9f34afdb-a87d-4c79-9ba3-0977680cf3f0', 2, 3, 1157, 'enquiry.feedback/suggestions', 'messages', 'ردود الفعل / الاقتراحات', 'active', NULL, NULL, '2025-06-21 00:42:55', '2025-06-21 00:42:55'),
(4172, '9f34afdb-abe7-4a67-bb2c-474296a903e8', 2, 3, 1158, 'email.to', 'messages', 'إلى', 'active', NULL, NULL, '2025-06-21 00:42:55', '2025-06-21 00:42:55'),
(4173, '9f34afdb-af44-4ae1-9c18-295ca691bd69', 2, 3, 1159, 'email.subject', 'messages', 'موضوع', 'active', NULL, NULL, '2025-06-21 00:42:55', '2025-06-21 00:42:55'),
(4174, '9f34afdb-b2a3-4938-aa21-426447d368e2', 2, 3, 1160, 'email.message', 'messages', 'رسالة', 'active', NULL, NULL, '2025-06-21 00:42:55', '2025-06-21 00:42:55'),
(4175, '9f34afdb-b5fc-47ea-875c-3cebbd9d6d8d', 2, 3, 1161, 'email.attachment', 'messages', 'المرفقات', 'active', NULL, NULL, '2025-06-21 00:42:55', '2025-06-21 00:42:55'),
(4176, '9f34afdb-b968-4dc1-aa9c-3ed4ad1095f5', 2, 3, 1162, 'ambulance.ambulance', 'messages', 'سيارة إسعاف', 'active', NULL, NULL, '2025-06-21 00:42:55', '2025-06-21 00:42:55'),
(4177, '9f34afdb-bca7-4e32-9cc9-c32af88cbea5', 2, 3, 1163, 'ambulance.ambulances', 'messages', 'سيارات الإسعاف', 'active', NULL, NULL, '2025-06-21 00:42:55', '2025-06-21 00:42:55'),
(4178, '9f34afdb-c016-4100-a9b8-8a87228b79fb', 2, 3, 1164, 'ambulance.ambulance_details', 'messages', 'تفاصيل سيارة الإسعاف', 'active', NULL, NULL, '2025-06-21 00:42:55', '2025-06-21 00:42:55'),
(4179, '9f34afdb-c364-43a9-9f01-47de4eca381b', 2, 3, 1165, 'ambulance.vehicle_number', 'messages', 'رقم المركبة', 'active', NULL, NULL, '2025-06-21 00:42:55', '2025-06-21 00:42:55'),
(4180, '9f34afdb-c6a6-469c-bea3-1734f179268a', 2, 3, 1166, 'ambulance.vehicle_model', 'messages', 'موديل المركبة', 'active', NULL, NULL, '2025-06-21 00:42:55', '2025-06-21 00:42:55'),
(4181, '9f34afdb-ca15-4bab-a631-5afd4427691a', 2, 3, 1167, 'ambulance.year_made', 'messages', 'سنة الصنع', 'active', NULL, NULL, '2025-06-21 00:42:55', '2025-06-21 00:42:55'),
(4182, '9f34afdb-cd68-488b-bbed-43be2a3ee064', 2, 3, 1168, 'ambulance.driver_name', 'messages', 'اسم السائق', 'active', NULL, NULL, '2025-06-21 00:42:55', '2025-06-21 00:42:55'),
(4183, '9f34afdb-d0de-4fa8-84dc-1e9cd8ce5058', 2, 3, 1169, 'ambulance.driver_license', 'messages', 'رخصة القيادة', 'active', NULL, NULL, '2025-06-21 00:42:55', '2025-06-21 00:42:55'),
(4184, '9f34afdb-d433-497f-8893-1c64a529aa28', 2, 3, 1170, 'ambulance.driver_contact', 'messages', 'الاتصال بالسائق', 'active', NULL, NULL, '2025-06-21 00:42:55', '2025-06-21 00:42:55'),
(4185, '9f34afdb-d794-4a4f-862c-4aa2203482e8', 2, 3, 1171, 'ambulance.note', 'messages', 'مذكرة', 'active', NULL, NULL, '2025-06-21 00:42:55', '2025-06-21 00:42:55'),
(4186, '9f34afdb-db2f-472a-8ac3-8640c68f9d86', 2, 3, 1172, 'ambulance.vehicle_type', 'messages', 'نوع المركبة', 'active', NULL, NULL, '2025-06-21 00:42:55', '2025-06-21 00:42:55'),
(4187, '9f34afdb-de96-4121-bac1-d5ec214410af', 2, 3, 1173, 'ambulance.is_available', 'messages', 'متاح', 'active', NULL, NULL, '2025-06-21 00:42:55', '2025-06-21 00:42:55'),
(4188, '9f34afdb-e1db-4974-ae68-f620312bab96', 2, 3, 1174, 'ambulance.new_ambulance', 'messages', 'سيارة إسعاف جديدة', 'active', NULL, NULL, '2025-06-21 00:42:55', '2025-06-21 00:42:55'),
(4189, '9f34afdb-e529-492c-96fb-2046f8445626', 2, 3, 1175, 'ambulance.edit_ambulance', 'messages', 'تحرير سيارة إسعاف', 'active', NULL, NULL, '2025-06-21 00:42:55', '2025-06-21 00:42:55'),
(4190, '9f34afdb-e886-4bf9-b563-64c750135ef7', 2, 3, 1176, 'ambulance.select_ambulance', 'messages', 'اختر سيارة إسعاف', 'active', NULL, NULL, '2025-06-21 00:42:55', '2025-06-21 00:42:55'),
(4191, '9f34afdb-ebea-48b0-8a6a-57f7d0815124', 2, 3, 1177, 'ambulance.owned', 'messages', 'مملوكة', 'active', NULL, NULL, '2025-06-21 00:42:55', '2025-06-21 00:42:55'),
(4192, '9f34afdb-ef5d-4dac-8a2b-9f45c842bb41', 2, 3, 1178, 'ambulance.contractual', 'messages', 'تعاقدي', 'active', NULL, NULL, '2025-06-21 00:42:55', '2025-06-21 00:42:55'),
(4193, '9f34afdb-f2ca-4b11-9155-1559a53976a5', 2, 3, 1179, 'ambulance_call.ambulance_call', 'messages', 'نداء إسعاف', 'active', NULL, NULL, '2025-06-21 00:42:55', '2025-06-21 00:42:55'),
(4194, '9f34afdb-f624-4669-a4ab-7b7692013882', 2, 3, 1180, 'ambulance_call.ambulance_calls', 'messages', 'مكالمات الإسعاف', 'active', NULL, NULL, '2025-06-21 00:42:55', '2025-06-21 00:42:55'),
(4195, '9f34afdb-f97e-4e70-98e9-0b4ca125fb8f', 2, 3, 1181, 'ambulance_call.ambulance_call_details', 'messages', 'تفاصيل مكالمة سيارة إسعاف', 'active', NULL, NULL, '2025-06-21 00:42:55', '2025-06-21 00:42:55'),
(4196, '9f34afdb-fce2-4537-9249-1c369a954bcb', 2, 3, 1182, 'ambulance_call.vehicle_model', 'messages', 'موديل المركبة', 'active', NULL, NULL, '2025-06-21 00:42:55', '2025-06-21 00:42:55'),
(4197, '9f34afdc-0023-4896-9fe0-573459c930a9', 2, 3, 1183, 'ambulance_call.patient', 'messages', 'صبور', 'active', NULL, NULL, '2025-06-21 00:42:55', '2025-06-21 00:42:55'),
(4198, '9f34afdc-03de-4dee-97d1-96f7d0b22dd7', 2, 3, 1184, 'ambulance_call.driver_name', 'messages', 'اسم السائق', 'active', NULL, NULL, '2025-06-21 00:42:55', '2025-06-21 00:42:55'),
(4199, '9f34afdc-074c-46ae-a7d0-e77d7f63491c', 2, 3, 1185, 'ambulance_call.date', 'messages', 'تاريخ', 'active', NULL, NULL, '2025-06-21 00:42:55', '2025-06-21 00:42:55'),
(4200, '9f34afdc-0ab0-4f10-a948-99fd3ab9e608', 2, 3, 1186, 'ambulance_call.amount', 'messages', 'كمية', 'active', NULL, NULL, '2025-06-21 00:42:55', '2025-06-21 00:42:55'),
(4201, '9f34afdc-0e0f-47d4-bb74-1aa6d904be13', 2, 3, 1187, 'ambulance_call.new_ambulance_call', 'messages', 'مكالمة إسعاف جديدة', 'active', NULL, NULL, '2025-06-21 00:42:55', '2025-06-21 00:42:55'),
(4202, '9f34afdc-1182-4c60-9151-13a6024074b4', 2, 3, 1188, 'ambulance_call.edit_ambulance_call', 'messages', 'تحرير مكالمة الإسعاف', 'active', NULL, NULL, '2025-06-21 00:42:55', '2025-06-21 00:42:55'),
(4203, '9f34afdc-14ce-452b-8816-272a3b2b8315', 2, 3, 1189, 'ambulance_call.select_ambulance', 'messages', 'حدد الإسعاف', 'active', NULL, NULL, '2025-06-21 00:42:55', '2025-06-21 00:42:55'),
(4204, '9f34afdc-1850-4170-9971-411832e5ecfc', 2, 3, 1190, 'prescription.prescription', 'messages', 'وصفة طبية', 'active', NULL, NULL, '2025-06-21 00:42:55', '2025-06-21 00:42:55'),
(4205, '9f34afdc-1bd1-4d86-bdab-17803a8f430e', 2, 3, 1191, 'prescription.prescriptions', 'messages', 'الوصفات الطبية', 'active', NULL, NULL, '2025-06-21 00:42:55', '2025-06-21 00:42:55'),
(4206, '9f34afdc-1f2e-420a-8cb0-a009b6315f78', 2, 3, 1192, 'prescription.prescription_details', 'messages', 'تفاصيل الوصفة الطبية', 'active', NULL, NULL, '2025-06-21 00:42:55', '2025-06-21 00:42:55'),
(4207, '9f34afdc-2295-4382-a139-d654613835c3', 2, 3, 1193, 'prescription.new_prescription', 'messages', 'وصفة طبية جديدة', 'active', NULL, NULL, '2025-06-21 00:42:55', '2025-06-21 00:42:55'),
(4208, '9f34afdc-25f6-4a93-80eb-6cd0cb9a5a09', 2, 3, 1194, 'prescription.edit_prescription', 'messages', 'تحرير الوصفة الطبية', 'active', NULL, NULL, '2025-06-21 00:42:55', '2025-06-21 00:42:55'),
(4209, '9f34afdc-299f-4994-baf2-a1053db2f94c', 2, 3, 1195, 'prescription.patient', 'messages', 'صبور', 'active', NULL, NULL, '2025-06-21 00:42:55', '2025-06-21 00:42:55'),
(4210, '9f34afdc-2d10-414d-bf7d-bae6df6062e0', 2, 3, 1197, 'prescription.food_allergies', 'messages', 'حساسية الطعام', 'active', NULL, NULL, '2025-06-21 00:42:55', '2025-06-21 00:42:55'),
(4211, '9f34afdc-3075-4888-a486-d788989c4e8d', 2, 3, 1198, 'prescription.tendency_bleed', 'messages', 'تيار النزف', 'active', NULL, NULL, '2025-06-21 00:42:55', '2025-06-21 00:42:55'),
(4212, '9f34afdc-33f6-4a2f-8cd5-81f9b128b259', 2, 3, 1199, 'prescription.heart_disease', 'messages', 'مرض القلب', 'active', NULL, NULL, '2025-06-21 00:42:55', '2025-06-21 00:42:55'),
(4213, '9f34afdc-3778-4388-89de-9175920952d8', 2, 3, 1200, 'prescription.high_blood_pressure', 'messages', 'ضغط دم مرتفع', 'active', NULL, NULL, '2025-06-21 00:42:55', '2025-06-21 00:42:55'),
(4214, '9f34afdc-3ac7-4a30-a8b7-5855043cde69', 2, 3, 1201, 'prescription.diabetic', 'messages', 'مريض بالسكر', 'active', NULL, NULL, '2025-06-21 00:42:55', '2025-06-21 00:42:55'),
(4215, '9f34afdc-3e22-462f-9bb9-adf0c431b66f', 2, 3, 1202, 'prescription.surgery', 'messages', 'الجراحة', 'active', NULL, NULL, '2025-06-21 00:42:55', '2025-06-21 00:42:55'),
(4216, '9f34afdc-41d2-4f73-91cd-c4fabfb3bbf9', 2, 3, 1203, 'prescription.accident', 'messages', 'حادث', 'active', NULL, NULL, '2025-06-21 00:42:55', '2025-06-21 00:42:55'),
(4217, '9f34afdc-4542-4db5-861a-38c1541afa03', 2, 3, 1204, 'prescription.others', 'messages', 'الآخرين', 'active', NULL, NULL, '2025-06-21 00:42:55', '2025-06-21 00:42:55'),
(4218, '9f34afdc-48ad-4467-beeb-d520f85cc040', 2, 3, 1205, 'prescription.medical_history', 'messages', 'تاريخ طبى', 'active', NULL, NULL, '2025-06-21 00:42:55', '2025-06-21 00:42:55'),
(4219, '9f34afdc-4c09-4d2b-b90f-cebfdec5b418', 2, 3, 1206, 'prescription.current_medication', 'messages', 'الدواء الحالي', 'active', NULL, NULL, '2025-06-21 00:42:55', '2025-06-21 00:42:55'),
(4220, '9f34afdc-4f5d-4b10-985d-dd05dc3a2ccb', 2, 3, 1207, 'prescription.female_pregnancy', 'messages', 'الحمل الأنثوي', 'active', NULL, NULL, '2025-06-21 00:42:55', '2025-06-21 00:42:55'),
(4221, '9f34afdc-5329-481e-8a95-96e76c804b24', 2, 3, 1208, 'prescription.breast_feeding', 'messages', 'الرضاعة الطبيعية', 'active', NULL, NULL, '2025-06-21 00:42:55', '2025-06-21 00:42:55'),
(4222, '9f34afdc-5684-40b3-a183-d260d21acf65', 2, 3, 1209, 'prescription.health_insurance', 'messages', 'تأمين صحي', 'active', NULL, NULL, '2025-06-21 00:42:55', '2025-06-21 00:42:55'),
(4223, '9f34afdc-5a06-410b-9e11-3340c1ebfd1b', 2, 3, 1210, 'prescription.low_income', 'messages', 'دخل منخفض', 'active', NULL, NULL, '2025-06-21 00:42:55', '2025-06-21 00:42:55'),
(4224, '9f34afdc-5d62-40f1-bb10-027ce1621dd4', 2, 3, 1211, 'prescription.reference', 'messages', 'مرجع', 'active', NULL, NULL, '2025-06-21 00:42:55', '2025-06-21 00:42:55'),
(4225, '9f34afdc-60c3-401e-b4af-222cccc3875d', 2, 3, 1212, 'prescription.physical_information', 'messages', 'المعلومات المادية', 'active', NULL, NULL, '2025-06-21 00:42:55', '2025-06-21 00:42:55'),
(4226, '9f34afdc-6413-47f5-b57f-870c46545720', 2, 3, 1213, 'prescription.new_medicine', 'messages', 'الطب الجديد', 'active', NULL, NULL, '2025-06-21 00:42:55', '2025-06-21 00:42:55'),
(4227, '9f34afdc-676b-4671-a7cb-44a33bf39735', 2, 3, 1214, 'prescription.plus_rate', 'messages', 'معدل نبض', 'active', NULL, NULL, '2025-06-21 00:42:55', '2025-06-21 00:42:55'),
(4228, '9f34afdc-6af8-43d5-9268-e6a2c9cb13d7', 2, 3, 1215, 'prescription.temperature', 'messages', 'درجة الحرارة', 'active', NULL, NULL, '2025-06-21 00:42:55', '2025-06-21 00:42:55'),
(4229, '9f34afdc-6e5b-4def-bf14-ce569c033521', 2, 3, 1216, 'prescription.problem_description', 'messages', 'وصف المشكلة', 'active', NULL, NULL, '2025-06-21 00:42:55', '2025-06-21 00:42:55'),
(4230, '9f34afdc-7354-48fe-9477-414eacfee9fd', 2, 3, 1217, 'prescription.test', 'messages', 'اختبار', 'active', NULL, NULL, '2025-06-21 00:42:55', '2025-06-21 00:42:55'),
(4231, '9f34afdc-76fe-4984-80a9-5166e21614e4', 2, 3, 1218, 'prescription.advice', 'messages', 'النصيحة', 'active', NULL, NULL, '2025-06-21 00:42:55', '2025-06-21 00:42:55'),
(4232, '9f34afdc-7a95-4ba9-b0f0-80cd1baab6c5', 2, 3, 1219, 'prescription.next_visit', 'messages', 'في المرة القادمة', 'active', NULL, NULL, '2025-06-21 00:42:55', '2025-06-21 00:42:55'),
(4233, '9f34afdc-7e16-42ca-9c87-8dca03fdf1d7', 2, 3, 1220, 'prescription.time', 'messages', 'زمن', 'active', NULL, NULL, '2025-06-21 00:42:55', '2025-06-21 00:42:55'),
(4234, '9f34afdc-82a5-49b7-982f-29023bf52f62', 2, 3, 1221, 'prescription.comment', 'messages', 'تعليق', 'active', NULL, NULL, '2025-06-21 00:42:55', '2025-06-21 00:42:55'),
(4235, '9f34afdc-8651-4e58-b576-041595f32507', 2, 3, 1222, 'prescription.problem', 'messages', 'مشكلة', 'active', NULL, NULL, '2025-06-21 00:42:55', '2025-06-21 00:42:55'),
(4236, '9f34afdc-89d3-413e-b611-1fbf6704ffab', 2, 3, 1223, 'prescription.rx', 'messages', 'آر إكس', 'active', NULL, NULL, '2025-06-21 00:42:55', '2025-06-21 00:42:55'),
(4237, '9f34afdc-8d5d-46b5-8a74-ed11786f1e00', 2, 3, 1224, 'prescription.medicine_name', 'messages', 'اسم_الطب', 'active', NULL, NULL, '2025-06-21 00:42:55', '2025-06-21 00:42:55'),
(4238, '9f34afdc-90d7-4b3f-9404-db502ddf3a49', 2, 3, 1225, 'prescription.duration', 'messages', 'مدة', 'active', NULL, NULL, '2025-06-21 00:42:55', '2025-06-21 00:42:55'),
(4239, '9f34afdc-946b-4b3f-96d7-ee4b587c0012', 2, 3, 1226, 'prescription.days', 'messages', 'أيام', 'active', NULL, NULL, '2025-06-21 00:42:55', '2025-06-21 00:42:55'),
(4240, '9f34afdc-97ed-45e8-8275-71b9da85e58d', 2, 3, 1227, 'prescription.after_meal', 'messages', 'بعد الوجبة', 'active', NULL, NULL, '2025-06-21 00:42:55', '2025-06-21 00:42:55'),
(4241, '9f34afdc-9b6d-4689-a878-e61460c8f702', 2, 3, 1228, 'prescription.before_meal', 'messages', 'قبل الوجبة', 'active', NULL, NULL, '2025-06-21 00:42:55', '2025-06-21 00:42:55'),
(4242, '9f34afdc-9ed6-44fc-a6c1-59aaa661fae6', 2, 3, 1229, 'prescription.fill_physical_information', 'messages', 'املأ أي تفاصيل عن المعلومات المادية', 'active', NULL, NULL, '2025-06-21 00:42:55', '2025-06-21 00:42:55'),
(4243, '9f34afdc-a256-4ec3-9866-883ecb24db6b', 2, 3, 1230, 'prescription.data_retrive_from_openai', 'messages', 'تم استرداد البيانات بنجاح من OpenAI', 'active', NULL, NULL, '2025-06-21 00:42:55', '2025-06-21 00:42:55'),
(4244, '9f34afdc-a5f6-4711-949b-c4fd78651775', 2, 3, 1196, 'prescription.doctor', 'messages', 'طبيب', 'active', NULL, NULL, '2025-06-21 00:42:55', '2025-06-21 00:42:55'),
(4245, '9f34afdc-a961-4f89-9f8b-4e9900d7e26d', 2, 3, 1231, 'charge_category.charge_categories', 'messages', 'فئات الرسوم', 'active', NULL, NULL, '2025-06-21 00:42:55', '2025-06-21 00:42:55'),
(4246, '9f34afdc-acf2-4783-b78d-ed9c49998c47', 2, 3, 1232, 'charge_category.new_charge_category', 'messages', 'فئة الشحن الجديدة', 'active', NULL, NULL, '2025-06-21 00:42:55', '2025-06-21 00:42:55'),
(4247, '9f34afdc-b06e-4ede-95d6-169264fb84fb', 2, 3, 1233, 'charge_category.edit_charge_category', 'messages', 'تحرير فئة الرسوم', 'active', NULL, NULL, '2025-06-21 00:42:55', '2025-06-21 00:42:55'),
(4248, '9f34afdc-b3f8-40dd-9b6e-78f2deae7b09', 2, 3, 1234, 'charge_category.charge_type', 'messages', 'نوع التهمة', 'active', NULL, NULL, '2025-06-21 00:42:55', '2025-06-21 00:42:55'),
(4249, '9f34afdc-b788-4d5c-8178-8b599bcfb8c3', 2, 3, 1235, 'charge_category.charge_category_details', 'messages', 'تفاصيل فئة الشحن', 'active', NULL, NULL, '2025-06-21 00:42:55', '2025-06-21 00:42:55'),
(4250, '9f34afdc-bb1b-4b20-94fb-977b8aededaf', 2, 3, 1236, 'charge_category.select_charge_type', 'messages', 'حدد نوع الفئة', 'active', NULL, NULL, '2025-06-21 00:42:55', '2025-06-21 00:42:55'),
(4251, '9f34afdc-be9e-4c83-b667-43f949410041', 2, 3, 1237, 'charge_filter.investigation', 'messages', 'تحقيق', 'active', NULL, NULL, '2025-06-21 00:42:55', '2025-06-21 00:42:55'),
(4252, '9f34afdc-c206-4b31-aced-9627761f77bc', 2, 3, 1238, 'charge_filter.procedure', 'messages', 'إجراء', 'active', NULL, NULL, '2025-06-21 00:42:55', '2025-06-21 00:42:55'),
(4253, '9f34afdc-c584-48a9-bac2-7b6eb858a295', 2, 3, 1239, 'charge_filter.supplier', 'messages', 'المورد', 'active', NULL, NULL, '2025-06-21 00:42:55', '2025-06-21 00:42:55'),
(4254, '9f34afdc-c905-450e-9558-6c8c31dbfd7f', 2, 3, 1240, 'charge_filter.operation_theater', 'messages', 'غرفة عمليات', 'active', NULL, NULL, '2025-06-21 00:42:55', '2025-06-21 00:42:55'),
(4255, '9f34afdc-ccb8-467a-b1e6-fefa1a33aeb5', 2, 3, 1241, 'charge_filter.others', 'messages', 'آحرون', 'active', NULL, NULL, '2025-06-21 00:42:55', '2025-06-21 00:42:55'),
(4256, '9f34afdc-d03b-471c-bc1a-fe0647ef181e', 2, 3, 1242, 'charge.new_charge', 'messages', 'تهمة جديدة', 'active', NULL, NULL, '2025-06-21 00:42:55', '2025-06-21 00:42:55'),
(4257, '9f34afdc-d3bc-4dfe-b955-6415a3b09d23', 2, 3, 1243, 'charge.edit_charge', 'messages', 'تحرير المسؤول', 'active', NULL, NULL, '2025-06-21 00:42:56', '2025-06-21 00:42:56'),
(4258, '9f34afdc-d72e-4740-bbe9-6f15fe0191a9', 2, 3, 1244, 'charge.charge_details', 'messages', 'تفاصيل الرسوم', 'active', NULL, NULL, '2025-06-21 00:42:56', '2025-06-21 00:42:56'),
(4259, '9f34afdc-da9e-4e40-9753-742c0cb20e1c', 2, 3, 1245, 'charge.charge_category', 'messages', 'فئة الشحن', 'active', NULL, NULL, '2025-06-21 00:42:56', '2025-06-21 00:42:56'),
(4260, '9f34afdc-de16-441c-90b1-1a82f2a6be9b', 2, 3, 1246, 'charge.standard_charge', 'messages', 'المسؤول القياسي', 'active', NULL, NULL, '2025-06-21 00:42:56', '2025-06-21 00:42:56'),
(4261, '9f34afdc-e181-4380-82e0-2206c96d0cdb', 2, 3, 1247, 'charge.code', 'messages', 'الشفرة', 'active', NULL, NULL, '2025-06-21 00:42:56', '2025-06-21 00:42:56'),
(4262, '9f34afdc-e503-4d1e-9432-9cab5da425df', 2, 3, 1248, 'radiology_category.name', 'messages', 'اسم', 'active', NULL, NULL, '2025-06-21 00:42:56', '2025-06-21 00:42:56'),
(4263, '9f34afdc-e86c-410a-b7db-9800e8a038f0', 2, 3, 1249, 'radiology_category.radiology_categories', 'messages', 'فئات الأشعة', 'active', NULL, NULL, '2025-06-21 00:42:56', '2025-06-21 00:42:56'),
(4264, '9f34afdc-ebe9-49b7-ab80-8d28157707b7', 2, 3, 1250, 'radiology_category.new_radiology_category', 'messages', 'فئة الأشعة الجديدة', 'active', NULL, NULL, '2025-06-21 00:42:56', '2025-06-21 00:42:56'),
(4265, '9f34afdc-ef73-452d-ba6a-d856b45a2558', 2, 3, 1251, 'radiology_category.edit_radiology_category', 'messages', 'تحرير فئة الأشعة', 'active', NULL, NULL, '2025-06-21 00:42:56', '2025-06-21 00:42:56'),
(4266, '9f34afdc-f35a-4255-bae4-8e753ded6207', 2, 3, 1252, 'pathology_category.pathology_categories', 'messages', 'فئات علم الأمراض', 'active', NULL, NULL, '2025-06-21 00:42:56', '2025-06-21 00:42:56'),
(4267, '9f34afdc-f6dc-4dac-9b0b-d2b2cf7616c1', 2, 3, 1254, 'pathology_category.new_pathology_category', 'messages', 'فئة علم الأمراض الجديدة', 'active', NULL, NULL, '2025-06-21 00:42:56', '2025-06-21 00:42:56'),
(4268, '9f34afdc-fa97-4cfe-b82c-095233f748cd', 2, 3, 1255, 'pathology_category.edit_pathology_category', 'messages', 'تحرير فئة علم الأمراض', 'active', NULL, NULL, '2025-06-21 00:42:56', '2025-06-21 00:42:56'),
(4269, '9f34afdc-fe10-41ca-8416-067f101bfe63', 2, 3, 1256, 'pathology_category.name', 'messages', 'اسم', 'active', NULL, NULL, '2025-06-21 00:42:56', '2025-06-21 00:42:56'),
(4270, '9f34afdd-017c-426d-a1ac-c4440c2731f9', 2, 3, 1253, 'pathology_category.select_charge_category', 'messages', 'حدد فئة الشحن', 'active', NULL, NULL, '2025-06-21 00:42:56', '2025-06-21 00:42:56'),
(4271, '9f34afdd-0514-4725-a660-95ed81b1b658', 2, 3, 1257, 'radiology_test.radiology_tests', 'messages', 'اختبارات الأشعة', 'active', NULL, NULL, '2025-06-21 00:42:56', '2025-06-21 00:42:56'),
(4272, '9f34afdd-08a3-47a6-bef4-b97ff0c6c5a8', 2, 3, 1258, 'radiology_test.new_radiology_test', 'messages', 'اختبار أشعة جديد', 'active', NULL, NULL, '2025-06-21 00:42:56', '2025-06-21 00:42:56'),
(4273, '9f34afdd-0c50-4128-85b4-906026517193', 2, 3, 1259, 'radiology_test.edit_radiology_test', 'messages', 'تحرير اختبار الأشعة', 'active', NULL, NULL, '2025-06-21 00:42:56', '2025-06-21 00:42:56'),
(4274, '9f34afdd-0fc6-4e88-89a9-102fcb9a5498', 2, 3, 1260, 'radiology_test.radiology_test_details', 'messages', 'تفاصيل اختبار الأشعة', 'active', NULL, NULL, '2025-06-21 00:42:56', '2025-06-21 00:42:56'),
(4275, '9f34afdd-1360-4041-b21f-1efdb5e1dd85', 2, 3, 1261, 'radiology_test.test_name', 'messages', 'اسم الاختبار', 'active', NULL, NULL, '2025-06-21 00:42:56', '2025-06-21 00:42:56'),
(4276, '9f34afdd-16f7-4a3b-8c9b-5e9dce66ebf2', 2, 3, 1262, 'radiology_test.short_name', 'messages', 'اسم قصير', 'active', NULL, NULL, '2025-06-21 00:42:56', '2025-06-21 00:42:56'),
(4277, '9f34afdd-1a7a-40bb-a3f6-a99476d52f92', 2, 3, 1263, 'radiology_test.test_type', 'messages', 'نوع الاختبار', 'active', NULL, NULL, '2025-06-21 00:42:56', '2025-06-21 00:42:56'),
(4278, '9f34afdd-1e0b-4486-8e6f-9455e4792d16', 2, 3, 1264, 'radiology_test.category_name', 'messages', 'اسم التصنيف', 'active', NULL, NULL, '2025-06-21 00:42:56', '2025-06-21 00:42:56'),
(4279, '9f34afdd-2188-49e6-8933-f04195927b74', 2, 3, 1265, 'radiology_test.subcategory', 'messages', 'تصنيف فرعي', 'active', NULL, NULL, '2025-06-21 00:42:56', '2025-06-21 00:42:56'),
(4280, '9f34afdd-24fe-41e2-b397-5551601fbcff', 2, 3, 1266, 'radiology_test.report_days', 'messages', 'أيام التقرير', 'active', NULL, NULL, '2025-06-21 00:42:56', '2025-06-21 00:42:56'),
(4281, '9f34afdd-287b-4aa1-9096-b7379ff53d5b', 2, 3, 1267, 'radiology_test.charge_category', 'messages', 'فئة الشحن', 'active', NULL, NULL, '2025-06-21 00:42:56', '2025-06-21 00:42:56'),
(4282, '9f34afdd-2c11-4dcb-b77c-fdc980c75147', 2, 3, 1268, 'radiology_test.standard_charge', 'messages', 'المسؤول القياسي', 'active', NULL, NULL, '2025-06-21 00:42:56', '2025-06-21 00:42:56'),
(4283, '9f34afdd-2f91-488b-aa7a-4266c77b60e7', 2, 3, 1269, 'doctor_opd_charge.new_doctor_opd_charge', 'messages', 'طبيب جديد رسوم OPD', 'active', NULL, NULL, '2025-06-21 00:42:56', '2025-06-21 00:42:56'),
(4284, '9f34afdd-333a-48eb-a14c-1f588fbe0641', 2, 3, 1270, 'doctor_opd_charge.edit_doctor_opd_charge', 'messages', 'تحرير تهمة طبيب OPD', 'active', NULL, NULL, '2025-06-21 00:42:56', '2025-06-21 00:42:56'),
(4285, '9f34afdd-368b-4827-a5ef-bb082b6d56a6', 2, 3, 1271, 'doctor_opd_charge.doctor_name', 'messages', 'اسم الطبيب', 'active', NULL, NULL, '2025-06-21 00:42:56', '2025-06-21 00:42:56'),
(4286, '9f34afdd-3a0c-4cfe-9396-7a0154399ae3', 2, 3, 1272, 'doctor_opd_charge.standard_charge', 'messages', 'رسوم العيادات الخارجية للطبيب', 'active', NULL, NULL, '2025-06-21 00:42:56', '2025-06-21 00:42:56'),
(4287, '9f34afdd-3d8c-409f-8074-718616653287', 2, 3, 1273, 'doctor_opd_charge.doctor', 'messages', 'طبيب', 'active', NULL, NULL, '2025-06-21 00:42:56', '2025-06-21 00:42:56'),
(4288, '9f34afdd-4129-4b8d-ab67-1f0cc8b43532', 2, 3, 1274, 'pathology_test.pathology_tests', 'messages', 'اختبارات علم الأمراض', 'active', NULL, NULL, '2025-06-21 00:42:56', '2025-06-21 00:42:56'),
(4289, '9f34afdd-44db-4120-bc03-3fedd83b8bcb', 2, 3, 1275, 'pathology_test.new_pathology_test', 'messages', 'اختبار باثولوجي جديد', 'active', NULL, NULL, '2025-06-21 00:42:56', '2025-06-21 00:42:56'),
(4290, '9f34afdd-4879-4aae-9fcd-1be5ba449f8e', 2, 3, 1276, 'pathology_test.edit_pathology_test', 'messages', 'تحرير اختبار علم الأمراض', 'active', NULL, NULL, '2025-06-21 00:42:56', '2025-06-21 00:42:56'),
(4291, '9f34afdd-4bf8-4cfb-af12-21ab30ccb069', 2, 3, 1277, 'pathology_test.pathology_test_details', 'messages', 'تفاصيل اختبار علم الأمراض', 'active', NULL, NULL, '2025-06-21 00:42:56', '2025-06-21 00:42:56'),
(4292, '9f34afdd-4f7c-49d1-9982-95985730040f', 2, 3, 1278, 'pathology_test.test_name', 'messages', 'اسم الاختبار', 'active', NULL, NULL, '2025-06-21 00:42:56', '2025-06-21 00:42:56'),
(4293, '9f34afdd-530f-4962-9a15-960d5066009b', 2, 3, 1279, 'pathology_test.short_name', 'messages', 'اسم قصير', 'active', NULL, NULL, '2025-06-21 00:42:56', '2025-06-21 00:42:56'),
(4294, '9f34afdd-56a7-4d8e-b30f-7b52740659ef', 2, 3, 1280, 'pathology_test.test_type', 'messages', 'نوع الاختبار', 'active', NULL, NULL, '2025-06-21 00:42:56', '2025-06-21 00:42:56'),
(4295, '9f34afdd-5a6c-4d2a-b659-e012a5763706', 2, 3, 1281, 'pathology_test.category_name', 'messages', 'اسم التصنيف', 'active', NULL, NULL, '2025-06-21 00:42:56', '2025-06-21 00:42:56'),
(4296, '9f34afdd-5f48-4aca-a581-9418829394c5', 2, 3, 1282, 'pathology_test.unit', 'messages', 'وحدة', 'active', NULL, NULL, '2025-06-21 00:42:56', '2025-06-21 00:42:56'),
(4297, '9f34afdd-62e1-4c08-9fd0-096149c47727', 2, 3, 1283, 'pathology_test.subcategory', 'messages', 'تصنيف فرعي', 'active', NULL, NULL, '2025-06-21 00:42:56', '2025-06-21 00:42:56'),
(4298, '9f34afdd-6664-470b-9036-0c8e00ed848c', 2, 3, 1284, 'pathology_test.method', 'messages', 'طريقة', 'active', NULL, NULL, '2025-06-21 00:42:56', '2025-06-21 00:42:56'),
(4299, '9f34afdd-6a24-473b-8a75-b69ec4c38f37', 2, 3, 1285, 'pathology_test.report_days', 'messages', 'أيام التقرير', 'active', NULL, NULL, '2025-06-21 00:42:56', '2025-06-21 00:42:56'),
(4300, '9f34afdd-6df3-4908-afc7-fbf581f8dfb4', 2, 3, 1286, 'pathology_test.charge_category', 'messages', 'فئة الشحن', 'active', NULL, NULL, '2025-06-21 00:42:56', '2025-06-21 00:42:56');
INSERT INTO `ltu_phrases` (`id`, `uuid`, `translation_id`, `translation_file_id`, `phrase_id`, `key`, `group`, `value`, `status`, `parameters`, `note`, `created_at`, `updated_at`) VALUES
(4301, '9f34afdd-71a4-405b-94af-e47d294a82c4', 2, 3, 1287, 'pathology_test.standard_charge', 'messages', 'المسؤول القياسي', 'active', NULL, NULL, '2025-06-21 00:42:56', '2025-06-21 00:42:56'),
(4302, '9f34afdd-7560-4026-89ec-6247f97ce3eb', 2, 3, 1288, 'expense_filter.building_rent', 'messages', 'إيجار المباني', 'active', NULL, NULL, '2025-06-21 00:42:56', '2025-06-21 00:42:56'),
(4303, '9f34afdd-7922-451a-a06f-353756381a84', 2, 3, 1289, 'expense_filter.equipments', 'messages', 'المعدات', 'active', NULL, NULL, '2025-06-21 00:42:56', '2025-06-21 00:42:56'),
(4304, '9f34afdd-7cc9-4e26-9843-6b2cc40dfe9e', 2, 3, 1290, 'expense_filter.electricity_bill', 'messages', 'فاتورة الكهرباء', 'active', NULL, NULL, '2025-06-21 00:42:56', '2025-06-21 00:42:56'),
(4305, '9f34afdd-8058-4d58-b131-690ead690c57', 2, 3, 1291, 'expense_filter.telephone_bill', 'messages', 'فاتورة الهاتف', 'active', NULL, NULL, '2025-06-21 00:42:56', '2025-06-21 00:42:56'),
(4306, '9f34afdd-8418-427d-82d5-a7a4d72fa70b', 2, 3, 1292, 'expense_filter.power_generator_fuel_charge', 'messages', 'شحن وقود مولد الطاقة', 'active', NULL, NULL, '2025-06-21 00:42:56', '2025-06-21 00:42:56'),
(4307, '9f34afdd-87e5-47e4-808d-eb10c15d8b90', 2, 3, 1293, 'expense_filter.tea_expense', 'messages', 'نفقات الشاي', 'active', NULL, NULL, '2025-06-21 00:42:56', '2025-06-21 00:42:56'),
(4308, '9f34afdd-8bbb-460b-9ec0-01c7db98f768', 2, 3, 1294, 'expense.new_expense', 'messages', 'نفقة جديدة', 'active', NULL, NULL, '2025-06-21 00:42:56', '2025-06-21 00:42:56'),
(4309, '9f34afdd-8f82-4df6-9e28-9296ca3fe2cd', 2, 3, 1295, 'expense.edit_expense', 'messages', 'تحرير المصاريف', 'active', NULL, NULL, '2025-06-21 00:42:56', '2025-06-21 00:42:56'),
(4310, '9f34afdd-9361-4e14-9174-a5f7007b7182', 2, 3, 1296, 'expense.expense_head', 'messages', 'رئيس المصاريف', 'active', NULL, NULL, '2025-06-21 00:42:56', '2025-06-21 00:42:56'),
(4311, '9f34afdd-973d-442c-bc3c-b310b17999f9', 2, 3, 1297, 'expense.name', 'messages', 'اسم', 'active', NULL, NULL, '2025-06-21 00:42:56', '2025-06-21 00:42:56'),
(4312, '9f34afdd-9af9-4404-88f5-cf04d16f657b', 2, 3, 1298, 'expense.date', 'messages', 'تاريخ', 'active', NULL, NULL, '2025-06-21 00:42:56', '2025-06-21 00:42:56'),
(4313, '9f34afdd-9e94-477a-a036-22212cce7c9f', 2, 3, 1299, 'expense.invoice_number', 'messages', 'رقم الفاتورة', 'active', NULL, NULL, '2025-06-21 00:42:56', '2025-06-21 00:42:56'),
(4314, '9f34afdd-a26d-4026-8f2c-d16fcb0caf78', 2, 3, 1300, 'expense.amount', 'messages', 'كمية', 'active', NULL, NULL, '2025-06-21 00:42:56', '2025-06-21 00:42:56'),
(4315, '9f34afdd-a62b-44d6-bbfc-a77fdf6d2beb', 2, 3, 1301, 'expense.attachment', 'messages', 'المرفق', 'active', NULL, NULL, '2025-06-21 00:42:56', '2025-06-21 00:42:56'),
(4316, '9f34afdd-a9d7-4c91-9dd9-ae9b98acbdea', 2, 3, 1302, 'expense.description', 'messages', 'وصف', 'active', NULL, NULL, '2025-06-21 00:42:56', '2025-06-21 00:42:56'),
(4317, '9f34afdd-ae0e-4f09-a772-e3f3563d1a45', 2, 3, 1303, 'expense.choose', 'messages', 'أختر', 'active', NULL, NULL, '2025-06-21 00:42:56', '2025-06-21 00:42:56'),
(4318, '9f34afdd-b24e-4162-9e3a-99e770ebe748', 2, 3, 1304, 'expense.download', 'messages', 'تحميل', 'active', NULL, NULL, '2025-06-21 00:42:56', '2025-06-21 00:42:56'),
(4319, '9f34afdd-b667-4741-a40d-2aee3e91524c', 2, 3, 1305, 'expense.select_expense_head', 'messages', 'حدد رأس النفقات', 'active', NULL, NULL, '2025-06-21 00:42:56', '2025-06-21 00:42:56'),
(4320, '9f34afdd-ba3b-4b3b-9aeb-4a6507381f41', 2, 3, 1306, 'expense.expense_details', 'messages', 'تفاصيل المصاريف', 'active', NULL, NULL, '2025-06-21 00:42:56', '2025-06-21 00:42:56'),
(4321, '9f34afdd-be1f-4296-8e6b-05b796468e25', 2, 3, 1307, 'expense.document_error', 'messages', 'يجب أن تكون الوثيقة من نوع: jpeg، jpg، png، pdf، doc، docx.', 'active', NULL, NULL, '2025-06-21 00:42:56', '2025-06-21 00:42:56'),
(4322, '9f34afdd-c21e-4c3a-ac8d-070a7e696666', 2, 3, 1308, 'income_filter.canteen_rate', 'messages', 'إيجار مقصف', 'active', NULL, NULL, '2025-06-21 00:42:56', '2025-06-21 00:42:56'),
(4323, '9f34afdd-c5cb-472f-bd75-a0ca07dcdce8', 2, 3, 1309, 'income_filter.hospital_charges', 'messages', 'رسوم المستشفى', 'active', NULL, NULL, '2025-06-21 00:42:56', '2025-06-21 00:42:56'),
(4324, '9f34afdd-c992-4b0c-9b69-07edb79f8ddf', 2, 3, 1310, 'income_filter.special_campaign', 'messages', 'حملة خاصة', 'active', NULL, NULL, '2025-06-21 00:42:56', '2025-06-21 00:42:56'),
(4325, '9f34afdd-cd36-4abe-9299-be83e04cbb3e', 2, 3, 1311, 'income_filter.vehicle_stand_charge', 'messages', 'شحن حامل السيارة', 'active', NULL, NULL, '2025-06-21 00:42:56', '2025-06-21 00:42:56'),
(4326, '9f34afdd-d10e-45d1-8e10-eeb0b89338c8', 2, 3, 1312, 'incomes.incomes', 'messages', 'الدخل', 'active', NULL, NULL, '2025-06-21 00:42:56', '2025-06-21 00:42:56'),
(4327, '9f34afdd-d4f5-447a-a4ba-9c1135e66543', 2, 3, 1313, 'incomes.new_income', 'messages', 'دخل جديد', 'active', NULL, NULL, '2025-06-21 00:42:56', '2025-06-21 00:42:56'),
(4328, '9f34afdd-d8b6-4e1a-a6f8-e8aa52dd0838', 2, 3, 1314, 'incomes.edit_income', 'messages', 'تحرير الدخل', 'active', NULL, NULL, '2025-06-21 00:42:56', '2025-06-21 00:42:56'),
(4329, '9f34afdd-dc72-4fee-87ca-f28e3c13b667', 2, 3, 1315, 'incomes.income_head', 'messages', 'رئيس الدخل', 'active', NULL, NULL, '2025-06-21 00:42:56', '2025-06-21 00:42:56'),
(4330, '9f34afdd-e024-45dc-89a5-4fb56d19d5b3', 2, 3, 1316, 'incomes.name', 'messages', 'اسم', 'active', NULL, NULL, '2025-06-21 00:42:56', '2025-06-21 00:42:56'),
(4331, '9f34afdd-e3d1-4139-9ecd-8b8bb6bcbe9f', 2, 3, 1317, 'incomes.date', 'messages', 'تاريخ', 'active', NULL, NULL, '2025-06-21 00:42:56', '2025-06-21 00:42:56'),
(4332, '9f34afdd-e7fd-4dff-8ac1-128ffacba407', 2, 3, 1318, 'incomes.invoice_number', 'messages', 'رقم الفاتورة', 'active', NULL, NULL, '2025-06-21 00:42:56', '2025-06-21 00:42:56'),
(4333, '9f34afdd-ebc4-443d-962c-8d0402790aa2', 2, 3, 1319, 'incomes.amount', 'messages', 'كمية', 'active', NULL, NULL, '2025-06-21 00:42:56', '2025-06-21 00:42:56'),
(4334, '9f34afdd-ef63-4a9e-9a99-0eb44eb3d427', 2, 3, 1320, 'incomes.attachment', 'messages', 'المرفق', 'active', NULL, NULL, '2025-06-21 00:42:56', '2025-06-21 00:42:56'),
(4335, '9f34afdd-f48e-4d92-b05a-2b3e1e8c7487', 2, 3, 1321, 'incomes.description', 'messages', 'وصف', 'active', NULL, NULL, '2025-06-21 00:42:56', '2025-06-21 00:42:56'),
(4336, '9f34afdd-f85c-4a13-830c-e709c30718a0', 2, 3, 1322, 'incomes.choose', 'messages', 'أختر', 'active', NULL, NULL, '2025-06-21 00:42:56', '2025-06-21 00:42:56'),
(4337, '9f34afdd-fc13-47df-bbce-a7b648814c71', 2, 3, 1323, 'incomes.download', 'messages', 'تحميل', 'active', NULL, NULL, '2025-06-21 00:42:56', '2025-06-21 00:42:56'),
(4338, '9f34afde-0024-42c0-bff2-b4e6adb21811', 2, 3, 1324, 'incomes.select_income_head', 'messages', 'حدد رأس الدخل', 'active', NULL, NULL, '2025-06-21 00:42:56', '2025-06-21 00:42:56'),
(4339, '9f34afde-0404-462a-95b0-2953f5f263c6', 2, 3, 1325, 'incomes.income_details', 'messages', 'تفاصيل الدخل', 'active', NULL, NULL, '2025-06-21 00:42:56', '2025-06-21 00:42:56'),
(4340, '9f34afde-07c1-46d4-a534-14fd7b1f8c4c', 2, 3, 1326, 'incomes.document_error', 'messages', 'يجب أن تكون الوثيقة من نوع: jpeg، jpg، png، pdf، doc، docx.', 'active', NULL, NULL, '2025-06-21 00:42:56', '2025-06-21 00:42:56'),
(4341, '9f34afde-0b99-4ee9-8cbe-574ed1f53c0d', 2, 3, 1327, 'bed_status.bed_status', 'messages', 'حالة السرير', 'active', NULL, NULL, '2025-06-21 00:42:56', '2025-06-21 00:42:56'),
(4342, '9f34afde-0feb-44da-8a9c-b5a42c60d2fd', 2, 3, 1328, 'bed_status.assigned_beds', 'messages', 'أسرة مخصصة', 'active', NULL, NULL, '2025-06-21 00:42:56', '2025-06-21 00:42:56'),
(4343, '9f34afde-13f5-45d1-bec2-064c9b3e6e99', 2, 3, 1329, 'bed_status.available_beds', 'messages', 'الأسرة المتاحة', 'active', NULL, NULL, '2025-06-21 00:42:56', '2025-06-21 00:42:56'),
(4344, '9f34afde-17be-4eff-9063-9cb0155484ba', 2, 3, 1330, 'bed_status.bed_name', 'messages', 'اسم السرير', 'active', NULL, NULL, '2025-06-21 00:42:56', '2025-06-21 00:42:56'),
(4345, '9f34afde-1b9c-4bb5-bd49-8877a5b8512d', 2, 3, 1331, 'bed_status.patient_name', 'messages', 'اسم المريض', 'active', NULL, NULL, '2025-06-21 00:42:56', '2025-06-21 00:42:56'),
(4346, '9f34afde-1f6b-403b-8b9b-76b06b566c64', 2, 3, 1332, 'bed_status.phone', 'messages', 'هاتف', 'active', NULL, NULL, '2025-06-21 00:42:56', '2025-06-21 00:42:56'),
(4347, '9f34afde-233b-461c-8962-8aeedd6223ec', 2, 3, 1333, 'bed_status.admission_date', 'messages', 'تاريخ القبول', 'active', NULL, NULL, '2025-06-21 00:42:56', '2025-06-21 00:42:56'),
(4348, '9f34afde-26fd-479c-ae2e-4b4580e741ea', 2, 3, 1334, 'bed_status.gender', 'messages', 'جنس', 'active', NULL, NULL, '2025-06-21 00:42:56', '2025-06-21 00:42:56'),
(4349, '9f34afde-2b27-41a3-8baa-4f8b2b2a3790', 2, 3, 1335, 'message.message', 'messages', 'رسالة', 'active', NULL, NULL, '2025-06-21 00:42:56', '2025-06-21 00:42:56'),
(4350, '9f34afde-2f39-4c82-bc54-8e1518de15d4', 2, 3, 1336, 'message.messages', 'messages', 'الرسائل', 'active', NULL, NULL, '2025-06-21 00:42:56', '2025-06-21 00:42:56'),
(4351, '9f34afde-3362-41a5-9ae7-7bd9e8d33a6f', 2, 3, 1337, 'message.send_to', 'messages', 'ارسل إلى', 'active', NULL, NULL, '2025-06-21 00:42:56', '2025-06-21 00:42:56'),
(4352, '9f34afde-3779-49bd-b955-dc4c180fff8b', 2, 3, 1338, 'message.subject', 'messages', 'موضوع', 'active', NULL, NULL, '2025-06-21 00:42:56', '2025-06-21 00:42:56'),
(4353, '9f34afde-3fc6-4d63-a9d5-cd5508acd63c', 2, 3, 1339, 'message.new_message', 'messages', 'رسالة جديدة', 'active', NULL, NULL, '2025-06-21 00:42:56', '2025-06-21 00:42:56'),
(4354, '9f34afde-43b1-4217-b1df-314817c94e39', 2, 3, 1340, 'message.messages_details', 'messages', 'تفاصيل الرسالة', 'active', NULL, NULL, '2025-06-21 00:42:56', '2025-06-21 00:42:56'),
(4355, '9f34afde-477b-4630-9658-e4eea09f760e', 2, 3, 1341, 'message.sender_name', 'messages', 'اسم المرسل', 'active', NULL, NULL, '2025-06-21 00:42:56', '2025-06-21 00:42:56'),
(4356, '9f34afde-4b81-4fe4-b641-bad7ed4ab21a', 2, 3, 1342, 'message.date', 'messages', 'تاريخ', 'active', NULL, NULL, '2025-06-21 00:42:56', '2025-06-21 00:42:56'),
(4357, '9f34afde-4f5c-447f-bb0a-e8572554a995', 2, 3, 1343, 'message.select_user', 'messages', 'اختر المستخدم', 'active', NULL, NULL, '2025-06-21 00:42:56', '2025-06-21 00:42:56'),
(4358, '9f34afde-545e-4781-b62f-d3121362a2b3', 2, 3, 1344, 'sms.sms', 'messages', 'سامس', 'active', NULL, NULL, '2025-06-21 00:42:56', '2025-06-21 00:42:56'),
(4359, '9f34afde-5872-4cb7-902b-02daf1d91207', 2, 3, 1345, 'sms.new_sms', 'messages', 'رسائل جديدة', 'active', NULL, NULL, '2025-06-21 00:42:57', '2025-06-21 00:42:57'),
(4360, '9f34afde-5c31-4e39-bb1f-350c19c1012a', 2, 3, 1346, 'sms.send_to', 'messages', 'ارسل إلى', 'active', NULL, NULL, '2025-06-21 00:42:57', '2025-06-21 00:42:57'),
(4361, '9f34afde-6038-49a4-9b43-db192a714059', 2, 3, 1347, 'sms.phone_number', 'messages', 'رقم الهاتف', 'active', NULL, NULL, '2025-06-21 00:42:57', '2025-06-21 00:42:57'),
(4362, '9f34afde-6403-4646-ae1c-5be91595c9be', 2, 3, 1348, 'sms.send_by', 'messages', 'أرسل بواسطة', 'active', NULL, NULL, '2025-06-21 00:42:57', '2025-06-21 00:42:57'),
(4363, '9f34afde-680c-41c2-86c7-540e1b340476', 2, 3, 1349, 'sms.message', 'messages', 'رسالة', 'active', NULL, NULL, '2025-06-21 00:42:57', '2025-06-21 00:42:57'),
(4364, '9f34afde-6be3-48da-a6bd-ff05cc990900', 2, 3, 1350, 'sms.sms_details', 'messages', 'تفاصيل الرسائل القصيرة', 'active', NULL, NULL, '2025-06-21 00:42:57', '2025-06-21 00:42:57'),
(4365, '9f34afde-6f9e-4e6d-b769-214fe931df03', 2, 3, 1351, 'sms.date', 'messages', 'تاريخ', 'active', NULL, NULL, '2025-06-21 00:42:57', '2025-06-21 00:42:57'),
(4366, '9f34afde-736a-4afa-93e0-3ee605ddc44a', 2, 3, 1352, 'sms.send', 'messages', 'إرسال', 'active', NULL, NULL, '2025-06-21 00:42:57', '2025-06-21 00:42:57'),
(4367, '9f34afde-775f-42de-bd20-f835554f3986', 2, 3, 1353, 'sms.role', 'messages', 'وظيفة', 'active', NULL, NULL, '2025-06-21 00:42:57', '2025-06-21 00:42:57'),
(4368, '9f34afde-7b3d-4390-9e2d-3a7076e3e7eb', 2, 3, 1355, 'sms.send_sms_by_number_directly', 'messages', 'إرسال الرسائل القصيرة بالرقم مباشرة', 'active', NULL, NULL, '2025-06-21 00:42:57', '2025-06-21 00:42:57'),
(4369, '9f34afde-7f01-48ae-a2ad-8372df3f22e4', 2, 3, 1356, 'sms.only_user_with_registered_phone_will_display', 'messages', '(سيتم عرض المستخدمين الذين لديهم هاتف مسجل فقط.)', 'active', NULL, NULL, '2025-06-21 00:42:57', '2025-06-21 00:42:57'),
(4370, '9f34afde-82d6-4b53-9645-6596674e7f12', 2, 3, 1357, 'sms.sms_mail', 'messages', 'الرسائل القصيرة / البريد', 'active', NULL, NULL, '2025-06-21 00:42:57', '2025-06-21 00:42:57'),
(4371, '9f34afde-86ba-4713-9d2d-51f69a0d1cbf', 2, 3, 1354, 'sms.select_role', 'messages', 'اختر الدور', 'active', NULL, NULL, '2025-06-21 00:42:57', '2025-06-21 00:42:57'),
(4372, '9f34afde-8ac2-4c17-ac4a-4b8a30e5dd41', 2, 3, 1358, 'patient_diagnosis_test.diagnosis', 'messages', 'التشخيص', 'active', NULL, NULL, '2025-06-21 00:42:57', '2025-06-21 00:42:57'),
(4373, '9f34afde-8e9e-454b-8b91-52e8a6119e6e', 2, 3, 1359, 'patient_diagnosis_test.diagnosis_test', 'messages', 'اختبارات التشخيص', 'active', NULL, NULL, '2025-06-21 00:42:57', '2025-06-21 00:42:57'),
(4374, '9f34afde-927b-449f-a145-df0bf8d06327', 2, 3, 1360, 'patient_diagnosis_test.patient_diagnosis_test', 'messages', 'اختبارات تشخيص المرضى', 'active', NULL, NULL, '2025-06-21 00:42:57', '2025-06-21 00:42:57'),
(4375, '9f34afde-9669-485a-911e-4ef63178160b', 2, 3, 1361, 'patient_diagnosis_test.report_number', 'messages', 'رقم التقرير', 'active', NULL, NULL, '2025-06-21 00:42:57', '2025-06-21 00:42:57'),
(4376, '9f34afde-9a3a-4cc3-b038-8322b2072008', 2, 3, 1362, 'patient_diagnosis_test.patient', 'messages', 'صبور', 'active', NULL, NULL, '2025-06-21 00:42:57', '2025-06-21 00:42:57'),
(4377, '9f34afde-9dfa-4b7d-96bb-3d22539c5a43', 2, 3, 1363, 'patient_diagnosis_test.doctor', 'messages', 'طبيب', 'active', NULL, NULL, '2025-06-21 00:42:57', '2025-06-21 00:42:57'),
(4378, '9f34afde-a1df-4c0e-bfc8-e793f4ec21de', 2, 3, 1364, 'patient_diagnosis_test.created_at', 'messages', 'أنشئت في', 'active', NULL, NULL, '2025-06-21 00:42:57', '2025-06-21 00:42:57'),
(4379, '9f34afde-a5bc-4ccc-95d5-f25e0a11a0c4', 2, 3, 1365, 'patient_diagnosis_test.action', 'messages', 'عمل', 'active', NULL, NULL, '2025-06-21 00:42:57', '2025-06-21 00:42:57'),
(4380, '9f34afde-a9b9-4d3f-a960-2573985e7edb', 2, 3, 1366, 'patient_diagnosis_test.new_patient_diagnosis_test', 'messages', 'اختبار تشخيص المريض الجديد', 'active', NULL, NULL, '2025-06-21 00:42:57', '2025-06-21 00:42:57'),
(4381, '9f34afde-ad88-4e33-a893-26f6cf05b5bc', 2, 3, 1367, 'patient_diagnosis_test.edit_patient_diagnosis_test', 'messages', 'تحرير اختبار تشخيص المريض', 'active', NULL, NULL, '2025-06-21 00:42:57', '2025-06-21 00:42:57'),
(4382, '9f34afde-b197-4d2c-9499-c74e95f3ab69', 2, 3, 1368, 'patient_diagnosis_test.create_patient_diagnosis_test', 'messages', 'إنشاء اختبار تشخيص المريض', 'active', NULL, NULL, '2025-06-21 00:42:57', '2025-06-21 00:42:57'),
(4383, '9f34afde-b575-41e6-8a6f-f5ab55cd7390', 2, 3, 1369, 'patient_diagnosis_test.patient_diagnosis_test_details', 'messages', 'تفاصيل اختبار تشخيص المريض', 'active', NULL, NULL, '2025-06-21 00:42:57', '2025-06-21 00:42:57'),
(4384, '9f34afde-b950-4c7d-9871-879d8974b004', 2, 3, 1370, 'patient_diagnosis_test.diagnosis_category', 'messages', 'فئة التشخيص', 'active', NULL, NULL, '2025-06-21 00:42:57', '2025-06-21 00:42:57'),
(4385, '9f34afde-bd28-42d0-a02b-251bf08648ec', 2, 3, 1371, 'patient_diagnosis_test.add_other_diagnosis_property', 'messages', 'أضف خاصية تشخيص أخرى', 'active', NULL, NULL, '2025-06-21 00:42:57', '2025-06-21 00:42:57'),
(4386, '9f34afde-c102-4542-bfc1-91d0f102cb06', 2, 3, 1372, 'patient_diagnosis_test.other_diagnosis_property', 'messages', 'خاصية التشخيص الأخرى', 'active', NULL, NULL, '2025-06-21 00:42:57', '2025-06-21 00:42:57'),
(4387, '9f34afde-c500-4761-8ad7-366a9589fa2a', 2, 3, 1373, 'patient_diagnosis_test.diagnosis_property_name', 'messages', 'اسم خاصية التشخيص', 'active', NULL, NULL, '2025-06-21 00:42:57', '2025-06-21 00:42:57'),
(4388, '9f34afde-c96e-4c1b-a1b9-cd4328aaed09', 2, 3, 1374, 'patient_diagnosis_test.diagnosis_property_value', 'messages', 'تشخيص قيمة العقار', 'active', NULL, NULL, '2025-06-21 00:42:57', '2025-06-21 00:42:57'),
(4389, '9f34afde-cdcc-4f73-9094-96ce6fb01ddd', 2, 3, 1375, 'patient_diagnosis_test.patient_name', 'messages', 'اسم المريض', 'active', NULL, NULL, '2025-06-21 00:42:57', '2025-06-21 00:42:57'),
(4390, '9f34afde-d196-45be-b2ea-6be5215ef59d', 2, 3, 1376, 'patient_diagnosis_test.doctor_name', 'messages', 'اسم الطبيب', 'active', NULL, NULL, '2025-06-21 00:42:57', '2025-06-21 00:42:57'),
(4391, '9f34afde-d5ab-4816-b4e3-6e33fec34ad9', 2, 3, 1377, 'patient_diagnosis_test.age', 'messages', 'سن', 'active', NULL, NULL, '2025-06-21 00:42:57', '2025-06-21 00:42:57'),
(4392, '9f34afde-da27-4063-90d3-823c44eb99ce', 2, 3, 1378, 'patient_diagnosis_test.height', 'messages', 'ارتفاع', 'active', NULL, NULL, '2025-06-21 00:42:57', '2025-06-21 00:42:57'),
(4393, '9f34afde-de3d-4cad-be58-dde1ab12df75', 2, 3, 1379, 'patient_diagnosis_test.weight', 'messages', 'وزن', 'active', NULL, NULL, '2025-06-21 00:42:57', '2025-06-21 00:42:57'),
(4394, '9f34afde-e230-4984-959d-9d46aabf829a', 2, 3, 1380, 'patient_diagnosis_test.average_glucose', 'messages', 'متوسط الجلوكوز', 'active', NULL, NULL, '2025-06-21 00:42:57', '2025-06-21 00:42:57'),
(4395, '9f34afde-e603-43fd-9cbb-3a1b8b4df183', 2, 3, 1381, 'patient_diagnosis_test.fasting_blood_sugar', 'messages', 'سكر الدم الصائم', 'active', NULL, NULL, '2025-06-21 00:42:57', '2025-06-21 00:42:57'),
(4396, '9f34afde-ea10-4a33-97fb-8188f99c8e3e', 2, 3, 1382, 'patient_diagnosis_test.urine_sugar', 'messages', 'سكر البول', 'active', NULL, NULL, '2025-06-21 00:42:57', '2025-06-21 00:42:57'),
(4397, '9f34afde-ee1c-4fbe-becb-673e308c1580', 2, 3, 1383, 'patient_diagnosis_test.blood_pressure', 'messages', 'ضغط الدم', 'active', NULL, NULL, '2025-06-21 00:42:57', '2025-06-21 00:42:57'),
(4398, '9f34afde-f20d-4f49-af01-0dbe178f0c42', 2, 3, 1384, 'patient_diagnosis_test.diabetes', 'messages', 'السكري', 'active', NULL, NULL, '2025-06-21 00:42:57', '2025-06-21 00:42:57'),
(4399, '9f34afde-f5e3-4ff0-99ae-8b9b62b64547', 2, 3, 1385, 'patient_diagnosis_test.cholesterol', 'messages', 'الكوليسترول', 'active', NULL, NULL, '2025-06-21 00:42:57', '2025-06-21 00:42:57'),
(4400, '9f34afde-f9c6-47bc-a420-604636bb5c51', 2, 3, 1386, 'patient_diagnosis_test.print_diagnosis_test', 'messages', 'اختبار تشخيص الطباعة', 'active', NULL, NULL, '2025-06-21 00:42:57', '2025-06-21 00:42:57'),
(4401, '9f34afde-fdaa-46ac-b4c0-565154b0531f', 2, 3, 1387, 'patient_diagnosis_test.select_diagnosis_cat', 'messages', 'حدد فئة التشخيص', 'active', NULL, NULL, '2025-06-21 00:42:57', '2025-06-21 00:42:57'),
(4402, '9f34afdf-01a8-41af-84f3-2093f406d41f', 2, 3, 1388, 'patient_diagnosis_test.patient_unique', 'messages', 'تم استخدام اسم المريض بالفعل.', 'active', NULL, NULL, '2025-06-21 00:42:57', '2025-06-21 00:42:57'),
(4403, '9f34afdf-0592-4155-89ef-843d3e366fa4', 2, 3, 1389, 'patient_diagnosis_test.report_generated', 'messages', 'تم إنشاء التقرير', 'active', NULL, NULL, '2025-06-21 00:42:57', '2025-06-21 00:42:57'),
(4404, '9f34afdf-094e-4fe9-975e-c485268c2be9', 2, 3, 1390, 'diagnosis_category.diagnosis_category', 'messages', 'فئة التشخيص', 'active', NULL, NULL, '2025-06-21 00:42:57', '2025-06-21 00:42:57'),
(4405, '9f34afdf-0d07-4424-aa75-3d0391009f20', 2, 3, 1391, 'diagnosis_category.diagnosis_category_details', 'messages', 'تفاصيل فئة التشخيص', 'active', NULL, NULL, '2025-06-21 00:42:57', '2025-06-21 00:42:57'),
(4406, '9f34afdf-10f9-4616-af35-b6f37645f75b', 2, 3, 1392, 'diagnosis_category.diagnosis_categories', 'messages', 'فئة التشخيص', 'active', NULL, NULL, '2025-06-21 00:42:57', '2025-06-21 00:42:57'),
(4407, '9f34afdf-14cf-4dc6-8d71-4442b20a1afd', 2, 3, 1393, 'diagnosis_category.new_diagnosis_category', 'messages', 'فئة التشخيص الجديدة', 'active', NULL, NULL, '2025-06-21 00:42:57', '2025-06-21 00:42:57'),
(4408, '9f34afdf-189d-45c3-b0ee-993af4dd78f0', 2, 3, 1394, 'diagnosis_category.description', 'messages', 'وصف', 'active', NULL, NULL, '2025-06-21 00:42:57', '2025-06-21 00:42:57'),
(4409, '9f34afdf-1c8a-43f7-8ec7-431c846b203c', 2, 3, 1395, 'diagnosis_category.category_name', 'messages', 'اسم التصنيف', 'active', NULL, NULL, '2025-06-21 00:42:57', '2025-06-21 00:42:57'),
(4410, '9f34afdf-2065-4b15-ae87-3b8fe1f0f0fe', 2, 3, 1396, 'diagnosis_category.edit_diagnosis_category', 'messages', 'تحرير فئة التشخيص', 'active', NULL, NULL, '2025-06-21 00:42:57', '2025-06-21 00:42:57'),
(4411, '9f34afdf-2429-421e-a6e1-dd45713b01cc', 2, 3, 1397, 'item_category.item_category', 'messages', 'العنصر فئة', 'active', NULL, NULL, '2025-06-21 00:42:57', '2025-06-21 00:42:57'),
(4412, '9f34afdf-282e-4717-8b8c-9441896c61df', 2, 3, 1398, 'item_category.item_categories', 'messages', 'فئات العناصر', 'active', NULL, NULL, '2025-06-21 00:42:57', '2025-06-21 00:42:57'),
(4413, '9f34afdf-2c22-492a-af33-dad8944619de', 2, 3, 1399, 'item_category.new_item_category', 'messages', 'فئة عنصر جديد', 'active', NULL, NULL, '2025-06-21 00:42:57', '2025-06-21 00:42:57'),
(4414, '9f34afdf-300b-4972-8e6b-4197af738c8c', 2, 3, 1400, 'item_category.edit_item_category', 'messages', 'تحرير فئة العنصر', 'active', NULL, NULL, '2025-06-21 00:42:57', '2025-06-21 00:42:57'),
(4415, '9f34afdf-33de-42cf-9db9-2f108983c22e', 2, 3, 1401, 'item_category.name', 'messages', 'اسم', 'active', NULL, NULL, '2025-06-21 00:42:57', '2025-06-21 00:42:57'),
(4416, '9f34afdf-37d0-426b-bd12-a5a904791281', 2, 3, 1402, 'item.item', 'messages', 'بند', 'active', NULL, NULL, '2025-06-21 00:42:57', '2025-06-21 00:42:57'),
(4417, '9f34afdf-3bc6-4a18-a909-f6bef1121165', 2, 3, 1403, 'item.items', 'messages', 'العناصر', 'active', NULL, NULL, '2025-06-21 00:42:57', '2025-06-21 00:42:57'),
(4418, '9f34afdf-3f96-4427-828e-d42aba215827', 2, 3, 1404, 'item.new_item', 'messages', 'عنصر جديد', 'active', NULL, NULL, '2025-06-21 00:42:57', '2025-06-21 00:42:57'),
(4419, '9f34afdf-43aa-4a46-9768-1299f4687950', 2, 3, 1405, 'item.edit_item', 'messages', 'تعديل عنصر', 'active', NULL, NULL, '2025-06-21 00:42:57', '2025-06-21 00:42:57'),
(4420, '9f34afdf-478a-4a97-8473-717e2036442e', 2, 3, 1406, 'item.item_details', 'messages', 'تفاصيل العنصر', 'active', NULL, NULL, '2025-06-21 00:42:57', '2025-06-21 00:42:57'),
(4421, '9f34afdf-4ce3-4102-8823-fc4ba776d6c5', 2, 3, 1407, 'item.name', 'messages', 'اسم', 'active', NULL, NULL, '2025-06-21 00:42:57', '2025-06-21 00:42:57'),
(4422, '9f34afdf-5108-4087-bd83-452813bd1af1', 2, 3, 1408, 'item.item_category', 'messages', 'العنصر فئة', 'active', NULL, NULL, '2025-06-21 00:42:57', '2025-06-21 00:42:57'),
(4423, '9f34afdf-553d-472b-8f3f-a9dd34dc6ee8', 2, 3, 1409, 'item.unit', 'messages', 'وحدة', 'active', NULL, NULL, '2025-06-21 00:42:57', '2025-06-21 00:42:57'),
(4424, '9f34afdf-594e-4567-bf59-61cc1ac163dc', 2, 3, 1410, 'item.description', 'messages', 'وصف', 'active', NULL, NULL, '2025-06-21 00:42:57', '2025-06-21 00:42:57'),
(4425, '9f34afdf-5d2a-41fc-a7cc-48104e52ccb6', 2, 3, 1411, 'item.available_quantity', 'messages', 'الكمية المتوفرة', 'active', NULL, NULL, '2025-06-21 00:42:57', '2025-06-21 00:42:57'),
(4426, '9f34afdf-6171-4e14-adb3-c5025a8ddc95', 2, 3, 1412, 'item.select_item_category', 'messages', 'حدد فئة العنصر', 'active', NULL, NULL, '2025-06-21 00:42:57', '2025-06-21 00:42:57'),
(4427, '9f34afdf-6559-4513-abb2-d72cea5adcf1', 2, 3, 1413, 'item_stock.item_stock', 'messages', 'عنصر المخزون', 'active', NULL, NULL, '2025-06-21 00:42:57', '2025-06-21 00:42:57'),
(4428, '9f34afdf-6947-49d9-b599-267542ea0b1e', 2, 3, 1414, 'item_stock.item_stocks', 'messages', 'مخزون البند', 'active', NULL, NULL, '2025-06-21 00:42:57', '2025-06-21 00:42:57'),
(4429, '9f34afdf-6d3e-4c77-881c-9ceeedd7c903', 2, 3, 1415, 'item_stock.new_item_stock', 'messages', 'مخزون عنصر جديد', 'active', NULL, NULL, '2025-06-21 00:42:57', '2025-06-21 00:42:57'),
(4430, '9f34afdf-7135-4997-86b0-9311afacd129', 2, 3, 1416, 'item_stock.edit_item_stock', 'messages', 'تحرير مخزون العنصر', 'active', NULL, NULL, '2025-06-21 00:42:57', '2025-06-21 00:42:57'),
(4431, '9f34afdf-752c-4bcd-ab97-052ea502dabb', 2, 3, 1417, 'item_stock.item_stock_details', 'messages', 'تفاصيل مخزون العنصر', 'active', NULL, NULL, '2025-06-21 00:42:57', '2025-06-21 00:42:57'),
(4432, '9f34afdf-7919-41e6-9983-482c419d4c49', 2, 3, 1418, 'item_stock.item_category', 'messages', 'العنصر فئة', 'active', NULL, NULL, '2025-06-21 00:42:57', '2025-06-21 00:42:57'),
(4433, '9f34afdf-7d30-4e25-9c65-9d2c27f57146', 2, 3, 1419, 'item_stock.item', 'messages', 'بند', 'active', NULL, NULL, '2025-06-21 00:42:57', '2025-06-21 00:42:57'),
(4434, '9f34afdf-8122-40dc-b6ee-228ea765404c', 2, 3, 1420, 'item_stock.supplier_name', 'messages', 'اسم المورد', 'active', NULL, NULL, '2025-06-21 00:42:57', '2025-06-21 00:42:57'),
(4435, '9f34afdf-84fe-47d3-a780-e1837b225ed9', 2, 3, 1421, 'item_stock.store_name', 'messages', 'اسم المتجر', 'active', NULL, NULL, '2025-06-21 00:42:57', '2025-06-21 00:42:57'),
(4436, '9f34afdf-8903-40d6-8a4a-bf5bbad03f92', 2, 3, 1422, 'item_stock.quantity', 'messages', 'ةكمية', 'active', NULL, NULL, '2025-06-21 00:42:57', '2025-06-21 00:42:57'),
(4437, '9f34afdf-8cd5-4714-8e02-ce2026567d0c', 2, 3, 1423, 'item_stock.purchase_price', 'messages', 'سعر الشراء', 'active', NULL, NULL, '2025-06-21 00:42:57', '2025-06-21 00:42:57'),
(4438, '9f34afdf-90b3-40b0-bc73-c0cc97ab013f', 2, 3, 1424, 'item_stock.description', 'messages', 'وصف', 'active', NULL, NULL, '2025-06-21 00:42:57', '2025-06-21 00:42:57'),
(4439, '9f34afdf-9486-4148-a07d-d791a39d4d8f', 2, 3, 1425, 'item_stock.attachment', 'messages', 'المرفق', 'active', NULL, NULL, '2025-06-21 00:42:57', '2025-06-21 00:42:57'),
(4440, '9f34afdf-98e2-44b6-9d9b-9ac235d0f0fe', 2, 3, 1426, 'issued_item.issued_item', 'messages', 'البند المصدر', 'active', NULL, NULL, '2025-06-21 00:42:57', '2025-06-21 00:42:57'),
(4441, '9f34afdf-9d2a-4d5f-b225-06d75be52dce', 2, 3, 1427, 'issued_item.issued_items', 'messages', 'العناصر المصدرة', 'active', NULL, NULL, '2025-06-21 00:42:57', '2025-06-21 00:42:57'),
(4442, '9f34afdf-a129-400b-b405-09e105fa515f', 2, 3, 1428, 'issued_item.new_issued_item', 'messages', 'عنصر جديد صادر', 'active', NULL, NULL, '2025-06-21 00:42:57', '2025-06-21 00:42:57'),
(4443, '9f34afdf-a5b5-4cd1-b15d-16d05915e6f1', 2, 3, 1429, 'issued_item.edit_issued_item', 'messages', 'تحرير العنصر الذي تم إصداره', 'active', NULL, NULL, '2025-06-21 00:42:57', '2025-06-21 00:42:57'),
(4444, '9f34afdf-a989-4dd8-acb5-d73cd6d2d662', 2, 3, 1430, 'issued_item.issued_item_details', 'messages', 'تفاصيل الأصناف المصدرة', 'active', NULL, NULL, '2025-06-21 00:42:57', '2025-06-21 00:42:57'),
(4445, '9f34afdf-ad71-4f78-8846-2b937d3208ad', 2, 3, 1431, 'issued_item.department_id', 'messages', 'نوع المستخدم', 'active', NULL, NULL, '2025-06-21 00:42:57', '2025-06-21 00:42:57'),
(4446, '9f34afdf-b13b-4424-bc31-cf5f0e7e0fd0', 2, 3, 1432, 'issued_item.user_id', 'messages', 'إصدار ل', 'active', NULL, NULL, '2025-06-21 00:42:57', '2025-06-21 00:42:57'),
(4447, '9f34afdf-b6ac-464d-9fc3-01be31171108', 2, 3, 1433, 'issued_item.issued_by', 'messages', 'إصدار بواسطة', 'active', NULL, NULL, '2025-06-21 00:42:57', '2025-06-21 00:42:57'),
(4448, '9f34afdf-baa5-43a3-946e-5bca251c97dc', 2, 3, 1434, 'issued_item.issued_for', 'messages', 'قضية ل', 'active', NULL, NULL, '2025-06-21 00:42:57', '2025-06-21 00:42:57'),
(4449, '9f34afdf-beb7-480c-b050-62b67c6b0470', 2, 3, 1435, 'issued_item.issued_date', 'messages', 'تاريخ الاصدار', 'active', NULL, NULL, '2025-06-21 00:42:57', '2025-06-21 00:42:57'),
(4450, '9f34afdf-c29d-4eb7-84ea-999258413009', 2, 3, 1436, 'issued_item.return_date', 'messages', 'تاريخ العودة', 'active', NULL, NULL, '2025-06-21 00:42:57', '2025-06-21 00:42:57'),
(4451, '9f34afdf-c696-4348-8dea-b577a1790253', 2, 3, 1437, 'issued_item.item_category', 'messages', 'العنصر فئة', 'active', NULL, NULL, '2025-06-21 00:42:57', '2025-06-21 00:42:57'),
(4452, '9f34afdf-ca9f-4f20-b6af-c9613ef72444', 2, 3, 1438, 'issued_item.item', 'messages', 'بند', 'active', NULL, NULL, '2025-06-21 00:42:57', '2025-06-21 00:42:57'),
(4453, '9f34afdf-cf0b-4f9e-9781-0e525aff2c07', 2, 3, 1439, 'issued_item.quantity', 'messages', 'كمية', 'active', NULL, NULL, '2025-06-21 00:42:57', '2025-06-21 00:42:57'),
(4454, '9f34afdf-d307-41df-acd5-c4cb3656de5f', 2, 3, 1440, 'issued_item.description', 'messages', 'وصف', 'active', NULL, NULL, '2025-06-21 00:42:57', '2025-06-21 00:42:57'),
(4455, '9f34afdf-d703-4a1f-ab4f-57c132a9aba0', 2, 3, 1441, 'issued_item.available_quantity', 'messages', 'الكمية المتوفرة', 'active', NULL, NULL, '2025-06-21 00:42:57', '2025-06-21 00:42:57'),
(4456, '9f34afdf-dafd-4b9e-9b21-195a60b82f5a', 2, 3, 1442, 'issued_item.item_return', 'messages', 'إرجاع البند', 'active', NULL, NULL, '2025-06-21 00:42:57', '2025-06-21 00:42:57'),
(4457, '9f34afdf-defd-4a93-99b6-94fa38357823', 2, 3, 1443, 'issued_item.item_returned', 'messages', 'عاد', 'active', NULL, NULL, '2025-06-21 00:42:58', '2025-06-21 00:42:58'),
(4458, '9f34afdf-e313-4e19-9fda-0fc2cafeef3b', 2, 3, 1444, 'issued_item.select_user_type', 'messages', 'حدد نوع المستخدم', 'active', NULL, NULL, '2025-06-21 00:42:58', '2025-06-21 00:42:58'),
(4459, '9f34afdf-e713-4689-b601-9384ed21e291', 2, 3, 1445, 'issued_item.qty_cannot_be_zero', 'messages', 'لا يمكن أن تكون الكمية صفرًا.', 'active', NULL, NULL, '2025-06-21 00:42:58', '2025-06-21 00:42:58'),
(4460, '9f34afdf-eae2-4e83-8816-993ded69bbbd', 2, 3, 1446, 'issued_item.qty_must_be_less_than_available_qty', 'messages', 'يجب أن تكون الكمية أقل من الكمية المتاحة.', 'active', NULL, NULL, '2025-06-21 00:42:58', '2025-06-21 00:42:58'),
(4461, '9f34afdf-eea3-4836-94aa-900df9325bd8', 2, 3, 1447, 'issued_item.are_you_sure_want_to_return_this_item', 'messages', 'هل أنت متأكد من أنك تريد إرجاع هذا العنصر', 'active', NULL, NULL, '2025-06-21 00:42:58', '2025-06-21 00:42:58'),
(4462, '9f34afdf-f282-4401-910b-61d928e64fc7', 2, 3, 1448, 'ipd_patient.ipd_patient', 'messages', 'مريض IPD', 'active', NULL, NULL, '2025-06-21 00:42:58', '2025-06-21 00:42:58'),
(4463, '9f34afdf-f6a4-4a70-8cf7-40de39d6a2ef', 2, 3, 1449, 'ipd_patient.ipd_patients', 'messages', 'مرضى IPD', 'active', NULL, NULL, '2025-06-21 00:42:58', '2025-06-21 00:42:58'),
(4464, '9f34afdf-fa97-41cc-b820-93d57b3555d5', 2, 3, 1450, 'ipd_patient.new_ipd_patient', 'messages', 'مريض IPD الجديد', 'active', NULL, NULL, '2025-06-21 00:42:58', '2025-06-21 00:42:58'),
(4465, '9f34afdf-fe57-4370-b4c5-24e1f332e408', 2, 3, 1451, 'ipd_patient.edit_ipd_patient', 'messages', 'تحرير المريض IPD', 'active', NULL, NULL, '2025-06-21 00:42:58', '2025-06-21 00:42:58'),
(4466, '9f34afe0-023a-47f2-9b4d-f7b520e94ea8', 2, 3, 1452, 'ipd_patient.ipd_patient_details', 'messages', 'تفاصيل المريض IPD', 'active', NULL, NULL, '2025-06-21 00:42:58', '2025-06-21 00:42:58'),
(4467, '9f34afe0-060e-4983-a0f1-15e7014add18', 2, 3, 1453, 'ipd_patient.patient_id', 'messages', 'صبور', 'active', NULL, NULL, '2025-06-21 00:42:58', '2025-06-21 00:42:58'),
(4468, '9f34afe0-09ec-4117-9d94-ac412fe56552', 2, 3, 1454, 'ipd_patient.ipd_number', 'messages', 'IPD لا', 'active', NULL, NULL, '2025-06-21 00:42:58', '2025-06-21 00:42:58'),
(4469, '9f34afe0-0dec-4a3a-bc3f-1277810b0d53', 2, 3, 1455, 'ipd_patient.height', 'messages', 'ارتفاع', 'active', NULL, NULL, '2025-06-21 00:42:58', '2025-06-21 00:42:58'),
(4470, '9f34afe0-11b5-4c2d-b200-ca7465f87df5', 2, 3, 1456, 'ipd_patient.weight', 'messages', 'وزن', 'active', NULL, NULL, '2025-06-21 00:42:58', '2025-06-21 00:42:58'),
(4471, '9f34afe0-159f-4df0-9496-384494f61829', 2, 3, 1457, 'ipd_patient.bp', 'messages', 'ضغط الدم', 'active', NULL, NULL, '2025-06-21 00:42:58', '2025-06-21 00:42:58'),
(4472, '9f34afe0-1969-43c3-b4dd-f540c1df733c', 2, 3, 1458, 'ipd_patient.symptoms', 'messages', 'الأعراض', 'active', NULL, NULL, '2025-06-21 00:42:58', '2025-06-21 00:42:58'),
(4473, '9f34afe0-1d75-458b-aad0-3cc421ffaf65', 2, 3, 1459, 'ipd_patient.notes', 'messages', 'ملاحظات', 'active', NULL, NULL, '2025-06-21 00:42:58', '2025-06-21 00:42:58'),
(4474, '9f34afe0-214a-41e2-a81f-aec02184fcde', 2, 3, 1460, 'ipd_patient.admission_date', 'messages', 'تاريخ القبول', 'active', NULL, NULL, '2025-06-21 00:42:58', '2025-06-21 00:42:58'),
(4475, '9f34afe0-2513-4552-b059-4007e5387906', 2, 3, 1461, 'ipd_patient.case_id', 'messages', 'قضية', 'active', NULL, NULL, '2025-06-21 00:42:58', '2025-06-21 00:42:58'),
(4476, '9f34afe0-28f5-459d-a98b-be1dbfc072d8', 2, 3, 1462, 'ipd_patient.is_old_patient', 'messages', 'مريض قديم', 'active', NULL, NULL, '2025-06-21 00:42:58', '2025-06-21 00:42:58'),
(4477, '9f34afe0-2cb2-45a3-912e-6024a20c76b9', 2, 3, 1463, 'ipd_patient.doctor_id', 'messages', 'طبيب', 'active', NULL, NULL, '2025-06-21 00:42:58', '2025-06-21 00:42:58'),
(4478, '9f34afe0-30aa-4058-a29a-1f95d746d744', 2, 3, 1464, 'ipd_patient.bed_type_id', 'messages', 'نوع السرير', 'active', NULL, NULL, '2025-06-21 00:42:58', '2025-06-21 00:42:58'),
(4479, '9f34afe0-3471-43a6-8310-ee16c2feed29', 2, 3, 1465, 'ipd_patient.bed_id', 'messages', 'السرير', 'active', NULL, NULL, '2025-06-21 00:42:58', '2025-06-21 00:42:58'),
(4480, '9f34afe0-3876-4276-88f4-49f30ec8dcc3', 2, 3, 1466, 'ipd_patient.bill_status', 'messages', 'حالة الفاتورة', 'active', NULL, NULL, '2025-06-21 00:42:58', '2025-06-21 00:42:58'),
(4481, '9f34afe0-3c78-4482-b32f-6ebd8fbde015', 2, 3, 1467, 'ipd_patient.choose_case', 'messages', 'إختر حالة', 'active', NULL, NULL, '2025-06-21 00:42:58', '2025-06-21 00:42:58'),
(4482, '9f34afe0-406c-4f51-958c-2c44c2e85d26', 2, 3, 1468, 'ipd_patient.discharged', 'messages', 'مفرغ', 'active', NULL, NULL, '2025-06-21 00:42:58', '2025-06-21 00:42:58'),
(4483, '9f34afe0-458f-4966-9a19-8ecaff7f7178', 2, 3, 1469, 'ipd_patient.discharge_patient', 'messages', 'تفريغ المريض', 'active', NULL, NULL, '2025-06-21 00:42:58', '2025-06-21 00:42:58'),
(4484, '9f34afe0-4987-4290-be62-1770c1a20edf', 2, 3, 1470, 'ipd_patient.please_select_applied_date', 'messages', 'الرجاء تحديد تاريخ التطبيق', 'active', NULL, NULL, '2025-06-21 00:42:58', '2025-06-21 00:42:58'),
(4485, '9f34afe0-4d8a-4515-b875-6eb2ebcd9510', 2, 3, 1471, 'ipd_patient.please_select_instruction_date', 'messages', 'الرجاء تحديد تاريخ التعليمات', 'active', NULL, NULL, '2025-06-21 00:42:58', '2025-06-21 00:42:58'),
(4486, '9f34afe0-5159-4984-8691-66b31513db68', 2, 3, 1472, 'ipd_patient.please_enter_instruction', 'messages', 'الرجاء إدخال التعليمات', 'active', NULL, NULL, '2025-06-21 00:42:58', '2025-06-21 00:42:58'),
(4487, '9f34afe0-5555-4b0a-b9e9-d0fff4cfa340', 2, 3, 1473, 'ipd_patient_diagnosis.new_ipd_diagnosis', 'messages', 'أضف التشخيص', 'active', NULL, NULL, '2025-06-21 00:42:58', '2025-06-21 00:42:58'),
(4488, '9f34afe0-5953-4924-92bb-04714906bd17', 2, 3, 1474, 'ipd_patient_diagnosis.edit_ipd_diagnosis', 'messages', 'تحرير التشخيص', 'active', NULL, NULL, '2025-06-21 00:42:58', '2025-06-21 00:42:58'),
(4489, '9f34afe0-5d54-43d7-837a-32cbc15d6630', 2, 3, 1475, 'ipd_patient_diagnosis.report_type', 'messages', 'نوع التقرير', 'active', NULL, NULL, '2025-06-21 00:42:58', '2025-06-21 00:42:58'),
(4490, '9f34afe0-6151-4feb-b4d7-b5f255e23115', 2, 3, 1476, 'ipd_patient_diagnosis.report_date', 'messages', 'تاريخ التقرير', 'active', NULL, NULL, '2025-06-21 00:42:58', '2025-06-21 00:42:58'),
(4491, '9f34afe0-6544-4f33-8a3a-e1ebadfe8224', 2, 3, 1477, 'ipd_patient_diagnosis.document', 'messages', 'وثيقة', 'active', NULL, NULL, '2025-06-21 00:42:58', '2025-06-21 00:42:58'),
(4492, '9f34afe0-6931-4916-adfa-111376acdfd2', 2, 3, 1478, 'ipd_patient_diagnosis.description', 'messages', 'وصف', 'active', NULL, NULL, '2025-06-21 00:42:58', '2025-06-21 00:42:58'),
(4493, '9f34afe0-6d29-4d73-9967-f4ba1635884b', 2, 3, 1479, 'ipd_patient_consultant_register.new_consultant_register', 'messages', 'أضف تعليمات استشاري', 'active', NULL, NULL, '2025-06-21 00:42:58', '2025-06-21 00:42:58'),
(4494, '9f34afe0-7121-4e33-a6c1-a4cfc48fc354', 2, 3, 1480, 'ipd_patient_consultant_register.edit_consultant_register', 'messages', 'تحرير تعليمات المستشار', 'active', NULL, NULL, '2025-06-21 00:42:58', '2025-06-21 00:42:58'),
(4495, '9f34afe0-74ff-48ac-91a8-84d1c2032ff9', 2, 3, 1481, 'ipd_patient_consultant_register.applied_date', 'messages', 'تاريخ التطبيق', 'active', NULL, NULL, '2025-06-21 00:42:58', '2025-06-21 00:42:58'),
(4496, '9f34afe0-78f3-49ee-9ad5-63cb28bc313e', 2, 3, 1482, 'ipd_patient_consultant_register.doctor_id', 'messages', 'طبيب', 'active', NULL, NULL, '2025-06-21 00:42:58', '2025-06-21 00:42:58'),
(4497, '9f34afe0-7ce3-41d0-b705-9f5dda28870c', 2, 3, 1483, 'ipd_patient_consultant_register.instruction', 'messages', 'تعليمات', 'active', NULL, NULL, '2025-06-21 00:42:58', '2025-06-21 00:42:58'),
(4498, '9f34afe0-80ac-4ecf-87cb-41c6727ad3cd', 2, 3, 1484, 'ipd_patient_consultant_register.instruction_date', 'messages', 'تاريخ التعليمات', 'active', NULL, NULL, '2025-06-21 00:42:58', '2025-06-21 00:42:58'),
(4499, '9f34afe0-84ab-4278-ab5e-d8a75b386d2e', 2, 3, 1485, 'ipd_patient_charges.new_charge', 'messages', 'أضف الرسوم', 'active', NULL, NULL, '2025-06-21 00:42:58', '2025-06-21 00:42:58'),
(4500, '9f34afe0-889c-4572-9768-f33ca87aabf6', 2, 3, 1486, 'ipd_patient_charges.edit_charge', 'messages', 'تحرير الرسوم', 'active', NULL, NULL, '2025-06-21 00:42:58', '2025-06-21 00:42:58'),
(4501, '9f34afe0-8cad-40ce-a9dd-194dfcc2c25e', 2, 3, 1487, 'ipd_patient_charges.date', 'messages', 'تاريخ', 'active', NULL, NULL, '2025-06-21 00:42:58', '2025-06-21 00:42:58'),
(4502, '9f34afe0-9095-49d8-993f-ea97c4c13211', 2, 3, 1488, 'ipd_patient_charges.charge_type_id', 'messages', 'نوع التهمة', 'active', NULL, NULL, '2025-06-21 00:42:58', '2025-06-21 00:42:58'),
(4503, '9f34afe0-9472-47a0-9aab-2d0b856a73d3', 2, 3, 1489, 'ipd_patient_charges.charge_category_id', 'messages', 'فئة الشحن', 'active', NULL, NULL, '2025-06-21 00:42:58', '2025-06-21 00:42:58'),
(4504, '9f34afe0-9888-4e65-a129-951ce7dd9858', 2, 3, 1490, 'ipd_patient_charges.charge_id', 'messages', 'الشفرة', 'active', NULL, NULL, '2025-06-21 00:42:58', '2025-06-21 00:42:58'),
(4505, '9f34afe0-9c54-40ac-83df-95df5bf6fe0c', 2, 3, 1491, 'ipd_patient_charges.standard_charge', 'messages', 'الشحن القياسي', 'active', NULL, NULL, '2025-06-21 00:42:58', '2025-06-21 00:42:58'),
(4506, '9f34afe0-a047-4459-b97e-6f125e8dce40', 2, 3, 1492, 'ipd_patient_charges.applied_charge', 'messages', 'الرسوم التطبيقية', 'active', NULL, NULL, '2025-06-21 00:42:58', '2025-06-21 00:42:58'),
(4507, '9f34afe0-a428-4be4-b691-5b7293bb0582', 2, 3, 1493, 'ipd_patient_prescription.ipd_no', 'messages', 'IPD لا', 'active', NULL, NULL, '2025-06-21 00:42:58', '2025-06-21 00:42:58'),
(4508, '9f34afe0-a816-4983-862e-8a8a5e1508f1', 2, 3, 1494, 'ipd_patient_prescription.header_note', 'messages', 'ملاحظة رأس', 'active', NULL, NULL, '2025-06-21 00:42:58', '2025-06-21 00:42:58'),
(4509, '9f34afe0-abf6-4751-aefe-81cf26e1be18', 2, 3, 1495, 'ipd_patient_prescription.footer_note', 'messages', 'ملاحظة التذييل', 'active', NULL, NULL, '2025-06-21 00:42:58', '2025-06-21 00:42:58'),
(4510, '9f34afe0-afd0-43c4-9663-9e8381579e79', 2, 3, 1496, 'ipd_patient_prescription.new_prescription', 'messages', 'إضافة وصفة طبية', 'active', NULL, NULL, '2025-06-21 00:42:58', '2025-06-21 00:42:58'),
(4511, '9f34afe0-b3bc-43e0-9da0-f4b209d6f25b', 2, 3, 1497, 'ipd_patient_prescription.edit_prescription', 'messages', 'تحرير الوصفة الطبية', 'active', NULL, NULL, '2025-06-21 00:42:58', '2025-06-21 00:42:58'),
(4512, '9f34afe0-b794-4b01-b35e-3d06a2ac3c6b', 2, 3, 1498, 'ipd_patient_prescription.prescription_details', 'messages', 'تفاصيل الوصفة', 'active', NULL, NULL, '2025-06-21 00:42:58', '2025-06-21 00:42:58'),
(4513, '9f34afe0-bb93-488b-a139-6d45df73f867', 2, 3, 1499, 'ipd_patient_prescription.category_id', 'messages', 'فئة الطب', 'active', NULL, NULL, '2025-06-21 00:42:58', '2025-06-21 00:42:58'),
(4514, '9f34afe0-bfaa-4172-961a-44ffa3fb39ab', 2, 3, 1500, 'ipd_patient_prescription.medicine_id', 'messages', 'الدواء', 'active', NULL, NULL, '2025-06-21 00:42:58', '2025-06-21 00:42:58'),
(4515, '9f34afe0-c394-43db-b06d-50f4a5427bcc', 2, 3, 1501, 'ipd_patient_prescription.dosage', 'messages', 'الجرعة', 'active', NULL, NULL, '2025-06-21 00:42:58', '2025-06-21 00:42:58'),
(4516, '9f34afe0-c77e-4360-8670-55ac295600ec', 2, 3, 1502, 'ipd_patient_prescription.instruction', 'messages', 'تعليمات', 'active', NULL, NULL, '2025-06-21 00:42:58', '2025-06-21 00:42:58'),
(4517, '9f34afe0-cb74-4ef8-9be6-b3c4fe3810f4', 2, 3, 1503, 'ipd_patient_prescription.print_prescription', 'messages', 'وصفة طبية مطبوعة', 'active', NULL, NULL, '2025-06-21 00:42:58', '2025-06-21 00:42:58'),
(4518, '9f34afe0-cf88-49c3-8e3b-d1c5ffd45a72', 2, 3, 1504, 'ipd_patient_timeline.new_ipd_timeline', 'messages', 'أضف الجدول الزمني', 'active', NULL, NULL, '2025-06-21 00:42:58', '2025-06-21 00:42:58'),
(4519, '9f34afe0-d38b-4ac7-b20e-53771f287d99', 2, 3, 1505, 'ipd_patient_timeline.edit_ipd_timeline', 'messages', 'تحرير الجدول الزمني', 'active', NULL, NULL, '2025-06-21 00:42:58', '2025-06-21 00:42:58'),
(4520, '9f34afe0-d77d-499f-93de-3465795d9d9f', 2, 3, 1506, 'ipd_patient_timeline.title', 'messages', 'عنوان', 'active', NULL, NULL, '2025-06-21 00:42:58', '2025-06-21 00:42:58'),
(4521, '9f34afe0-db96-45b1-a95d-10293ac28b5e', 2, 3, 1507, 'ipd_patient_timeline.date', 'messages', 'تاريخ', 'active', NULL, NULL, '2025-06-21 00:42:58', '2025-06-21 00:42:58'),
(4522, '9f34afe0-df8c-49b7-85e0-6c9732a8df63', 2, 3, 1508, 'ipd_patient_timeline.description', 'messages', 'وصف', 'active', NULL, NULL, '2025-06-21 00:42:58', '2025-06-21 00:42:58'),
(4523, '9f34afe0-e37d-4db5-b57e-af4e0111468c', 2, 3, 1509, 'ipd_patient_timeline.document', 'messages', 'وثيقة', 'active', NULL, NULL, '2025-06-21 00:42:58', '2025-06-21 00:42:58'),
(4524, '9f34afe0-e792-4b8f-8bfb-c18f37a98b96', 2, 3, 1510, 'ipd_patient_timeline.visible_to_person', 'messages', 'مرئي للشخص', 'active', NULL, NULL, '2025-06-21 00:42:58', '2025-06-21 00:42:58'),
(4525, '9f34afe0-eb9e-4afc-8375-02dac45b2982', 2, 3, 1511, 'ipd_patient_timeline.no_timeline_found', 'messages', 'لم يتم العثور على خط زمني', 'active', NULL, NULL, '2025-06-21 00:42:58', '2025-06-21 00:42:58'),
(4526, '9f34afe0-ef9a-441e-9301-6f8d3a03cce0', 2, 3, 1512, 'ipd_payments.add_ipd_payment', 'messages', 'إضافة دفع Ipd', 'active', NULL, NULL, '2025-06-21 00:42:58', '2025-06-21 00:42:58'),
(4527, '9f34afe0-f39b-49fd-ac48-09481aa62a1e', 2, 3, 1513, 'ipd_payments.edit_ipd_payment', 'messages', 'تحرير دفع IPD', 'active', NULL, NULL, '2025-06-21 00:42:58', '2025-06-21 00:42:58'),
(4528, '9f34afe0-f78d-4c7c-8db8-e1dce71f8eef', 2, 3, 1514, 'ipd_payments.select_payment_mode', 'messages', 'حدد وضع الدفع', 'active', NULL, NULL, '2025-06-21 00:42:58', '2025-06-21 00:42:58'),
(4529, '9f34afe0-fb81-4fb5-8bd0-daa4faac3f4f', 2, 3, 1515, 'ipd_payments.payment_mode', 'messages', 'طريقة الدفع', 'active', NULL, NULL, '2025-06-21 00:42:58', '2025-06-21 00:42:58'),
(4530, '9f34afe0-ff62-4ba6-82e2-ad1b15d35bbe', 2, 3, 1516, 'ipd_payments.make_payment', 'messages', 'قم بالدفع', 'active', NULL, NULL, '2025-06-21 00:42:58', '2025-06-21 00:42:58'),
(4531, '9f34afe1-0381-4e13-a5e6-fe2f90ce251f', 2, 3, 1517, 'ipd_bill.paid_amount', 'messages', 'المبلغ المدفوع', 'active', NULL, NULL, '2025-06-21 00:42:58', '2025-06-21 00:42:58'),
(4532, '9f34afe1-077d-4c4a-989e-49902dd057f7', 2, 3, 1518, 'ipd_bill.total_charges', 'messages', 'الكلفة الاجماليه', 'active', NULL, NULL, '2025-06-21 00:42:58', '2025-06-21 00:42:58'),
(4533, '9f34afe1-0b6e-4e04-b973-4f395520afda', 2, 3, 1519, 'ipd_bill.gross_total', 'messages', 'المجموع الكلي', 'active', NULL, NULL, '2025-06-21 00:42:58', '2025-06-21 00:42:58'),
(4534, '9f34afe1-0f6c-48c2-92ee-5377b12c961e', 2, 3, 1520, 'ipd_bill.discount_in_percentage', 'messages', 'نسبة الخصم', 'active', NULL, NULL, '2025-06-21 00:42:58', '2025-06-21 00:42:58'),
(4535, '9f34afe1-137a-4286-8ead-caed5a24de0a', 2, 3, 1521, 'ipd_bill.discount_in_number', 'messages', 'الخصم في العدد', 'active', NULL, NULL, '2025-06-21 00:42:58', '2025-06-21 00:42:58'),
(4536, '9f34afe1-1770-4752-934d-d08c2d4ad9ad', 2, 3, 1522, 'ipd_bill.tax_in_percentage', 'messages', 'الضريبة بالنسبة المئوية', 'active', NULL, NULL, '2025-06-21 00:42:58', '2025-06-21 00:42:58'),
(4537, '9f34afe1-1b5d-415f-af09-b380e9b00c09', 2, 3, 1523, 'ipd_bill.tax_in_number', 'messages', 'رقم الضريبة', 'active', NULL, NULL, '2025-06-21 00:42:58', '2025-06-21 00:42:58'),
(4538, '9f34afe1-1f7e-4a12-a995-922184128fd5', 2, 3, 1524, 'ipd_bill.other_charges', 'messages', 'رسوم أخرى', 'active', NULL, NULL, '2025-06-21 00:42:58', '2025-06-21 00:42:58'),
(4539, '9f34afe1-2398-47f8-a179-d269d590a698', 2, 3, 1525, 'ipd_bill.net_payable_amount', 'messages', 'صافي المبلغ المستحق', 'active', NULL, NULL, '2025-06-21 00:42:58', '2025-06-21 00:42:58'),
(4540, '9f34afe1-2792-474b-aaeb-a0a670933fc2', 2, 3, 1526, 'ipd_bill.discharge_patient', 'messages', 'الخروج من المريض', 'active', NULL, NULL, '2025-06-21 00:42:58', '2025-06-21 00:42:58'),
(4541, '9f34afe1-2baf-42c1-927c-0578ca59a389', 2, 3, 1527, 'opd_patient.opd_patient', 'messages', 'مريض العيادات الخارجية', 'active', NULL, NULL, '2025-06-21 00:42:58', '2025-06-21 00:42:58'),
(4542, '9f34afe1-311a-4e99-aa18-45fd827f904e', 2, 3, 1528, 'opd_patient.opd_patients', 'messages', 'مرضى العيادات الخارجية', 'active', NULL, NULL, '2025-06-21 00:42:58', '2025-06-21 00:42:58'),
(4543, '9f34afe1-3529-41ff-89e5-b87cba82ef4a', 2, 3, 1529, 'opd_patient.new_opd_patient', 'messages', 'مريض العيادات الخارجية الجديد', 'active', NULL, NULL, '2025-06-21 00:42:58', '2025-06-21 00:42:58'),
(4544, '9f34afe1-3929-4a0b-a29e-df76ca57a789', 2, 3, 1530, 'opd_patient.edit_opd_patient', 'messages', 'تحرير مريض العيادات الخارجية', 'active', NULL, NULL, '2025-06-21 00:42:58', '2025-06-21 00:42:58'),
(4545, '9f34afe1-3e4f-4cb1-8430-599e1803c65e', 2, 3, 1531, 'opd_patient.opd_patient_details', 'messages', 'تفاصيل مريض العيادات الخارجية', 'active', NULL, NULL, '2025-06-21 00:42:58', '2025-06-21 00:42:58'),
(4546, '9f34afe1-4268-4f16-a967-fc0a6ab80da0', 2, 3, 1532, 'opd_patient.opd_number', 'messages', 'العيادات الخارجية لا', 'active', NULL, NULL, '2025-06-21 00:42:58', '2025-06-21 00:42:58'),
(4547, '9f34afe1-4640-4f78-a50d-04211f9a0e78', 2, 3, 1533, 'opd_patient.appointment_date', 'messages', 'تاريخ الموعد', 'active', NULL, NULL, '2025-06-21 00:42:58', '2025-06-21 00:42:58'),
(4548, '9f34afe1-4a41-4092-a87b-c676d7837a35', 2, 3, 1534, 'opd_patient.visits', 'messages', 'الزيارات', 'active', NULL, NULL, '2025-06-21 00:42:58', '2025-06-21 00:42:58'),
(4549, '9f34afe1-4e31-440a-9980-19d8e59f3938', 2, 3, 1535, 'opd_patient.revisits', 'messages', 'إعادة النظر', 'active', NULL, NULL, '2025-06-21 00:42:58', '2025-06-21 00:42:58'),
(4550, '9f34afe1-5226-473e-9207-51b1f3c6b282', 2, 3, 1536, 'opd_patient.total_visits', 'messages', 'إجمالي عدد الزيارات', 'active', NULL, NULL, '2025-06-21 00:42:58', '2025-06-21 00:42:58'),
(4551, '9f34afe1-570f-4166-a7fa-f232c5190358', 2, 3, NULL, 'opd_patient.opd_doctor_charge', 'messages', 'رسوم طبيب العيادات الخارجية', 'active', NULL, NULL, '2025-06-21 00:42:58', '2025-06-21 00:42:58'),
(4552, '9f34afe1-5b13-4840-9fea-b21c76c45c21', 2, 3, 1537, 'opd_payments.add_opd_payment', 'messages', 'إضافة دفع Opd', 'active', NULL, NULL, '2025-06-21 00:42:58', '2025-06-21 00:42:58'),
(4553, '9f34afe1-5f0c-47a6-8667-1cf90b882efa', 2, 3, 1538, 'opd_payments.edit_opd_payment', 'messages', 'تحرير دفع Opd', 'active', NULL, NULL, '2025-06-21 00:42:58', '2025-06-21 00:42:58'),
(4554, '9f34afe1-632f-4dc4-8990-0fff1ef77054', 2, 3, 1539, 'opd_payments.payment_mode', 'messages', 'طريقة الدفع', 'active', NULL, NULL, '2025-06-21 00:42:58', '2025-06-21 00:42:58'),
(4555, '9f34afe1-672a-43dc-b629-7826d972941e', 2, 3, 1540, 'opd_payments.make_payment', 'messages', 'قم بالدفع', 'active', NULL, NULL, '2025-06-21 00:42:59', '2025-06-21 00:42:59'),
(4556, '9f34afe1-6b1a-4b96-905f-8f4f098e0e33', 2, 3, 1541, 'opd_payments.choose_payment', 'messages', 'اختر الدفع', 'active', NULL, NULL, '2025-06-21 00:42:59', '2025-06-21 00:42:59'),
(4557, '9f34afe1-6f09-476b-bd32-e8a5936ae1e8', 2, 3, 1542, 'call_log.new', 'messages', 'سجل المكالمات الجديد', 'active', NULL, NULL, '2025-06-21 00:42:59', '2025-06-21 00:42:59'),
(4558, '9f34afe1-7305-4b1f-91f1-2591f253807a', 2, 3, 1543, 'call_log.edit', 'messages', 'تحرير سجل المكالمات', 'active', NULL, NULL, '2025-06-21 00:42:59', '2025-06-21 00:42:59'),
(4559, '9f34afe1-76ec-4f11-a680-940e8d4ac13b', 2, 3, 1544, 'call_log.name', 'messages', 'اسم', 'active', NULL, NULL, '2025-06-21 00:42:59', '2025-06-21 00:42:59'),
(4560, '9f34afe1-7ae2-4646-942f-ba6a5a8b6385', 2, 3, 1545, 'call_log.phone', 'messages', 'هاتف', 'active', NULL, NULL, '2025-06-21 00:42:59', '2025-06-21 00:42:59'),
(4561, '9f34afe1-7eed-46e5-a40d-0e71ced51052', 2, 3, 1546, 'call_log.received_on', 'messages', 'وردت في', 'active', NULL, NULL, '2025-06-21 00:42:59', '2025-06-21 00:42:59'),
(4562, '9f34afe1-83df-4ed5-bde8-157354ec8393', 2, 3, NULL, 'call_log.description', 'messages', 'وصف', 'active', NULL, NULL, '2025-06-21 00:42:59', '2025-06-21 00:42:59'),
(4563, '9f34afe1-87f9-45e9-8068-2f94db634ac4', 2, 3, 1547, 'call_log.follow_up_date', 'messages', 'متابعة التاريخ', 'active', NULL, NULL, '2025-06-21 00:42:59', '2025-06-21 00:42:59'),
(4564, '9f34afe1-8c47-41f9-96a5-d941f029f4c8', 2, 3, 1548, 'call_log.note', 'messages', 'ملحوظة', 'active', NULL, NULL, '2025-06-21 00:42:59', '2025-06-21 00:42:59'),
(4565, '9f34afe1-9047-4d5a-9193-f6d49707852d', 2, 3, 1549, 'call_log.call_type', 'messages', 'نوع الاتصال', 'active', NULL, NULL, '2025-06-21 00:42:59', '2025-06-21 00:42:59'),
(4566, '9f34afe1-9455-41de-af48-17a86c3fda72', 2, 3, 1550, 'call_log.incoming', 'messages', 'واردة', 'active', NULL, NULL, '2025-06-21 00:42:59', '2025-06-21 00:42:59'),
(4567, '9f34afe1-984b-4fbd-a119-a4bb59755b3f', 2, 3, 1551, 'call_log.outgoing', 'messages', 'منفتح', 'active', NULL, NULL, '2025-06-21 00:42:59', '2025-06-21 00:42:59'),
(4568, '9f34afe1-9c61-4a41-995f-976995549142', 2, 3, 1552, 'visitor_filter.visit', 'messages', 'يزور', 'active', NULL, NULL, '2025-06-21 00:42:59', '2025-06-21 00:42:59'),
(4569, '9f34afe1-a06c-4362-bca6-ccef4f655a10', 2, 3, 1553, 'visitor_filter.enquiry', 'messages', 'سؤال', 'active', NULL, NULL, '2025-06-21 00:42:59', '2025-06-21 00:42:59'),
(4570, '9f34afe1-a466-4e02-9671-f5f0e3a4be3e', 2, 3, 1554, 'visitor_filter.seminar', 'messages', 'ندوة', 'active', NULL, NULL, '2025-06-21 00:42:59', '2025-06-21 00:42:59');
INSERT INTO `ltu_phrases` (`id`, `uuid`, `translation_id`, `translation_file_id`, `phrase_id`, `key`, `group`, `value`, `status`, `parameters`, `note`, `created_at`, `updated_at`) VALUES
(4571, '9f34afe1-a882-4bc5-8100-dbcc12a18293', 2, 3, 1555, 'visitor.new', 'messages', 'زائر جديد', 'active', NULL, NULL, '2025-06-21 00:42:59', '2025-06-21 00:42:59'),
(4572, '9f34afe1-ac71-411e-a1bc-f49c96995e24', 2, 3, 1556, 'visitor.edit', 'messages', 'تحرير الزائر', 'active', NULL, NULL, '2025-06-21 00:42:59', '2025-06-21 00:42:59'),
(4573, '9f34afe1-b05c-4463-a4cd-67487c754b7e', 2, 3, 1557, 'visitor.name', 'messages', 'اسم', 'active', NULL, NULL, '2025-06-21 00:42:59', '2025-06-21 00:42:59'),
(4574, '9f34afe1-b471-4019-b1b0-d8d8264562de', 2, 3, 1558, 'visitor.purpose', 'messages', 'غرض', 'active', NULL, NULL, '2025-06-21 00:42:59', '2025-06-21 00:42:59'),
(4575, '9f34afe1-b865-4644-bf5a-85452a928ec3', 2, 3, 1559, 'visitor.phone', 'messages', 'هاتف', 'active', NULL, NULL, '2025-06-21 00:42:59', '2025-06-21 00:42:59'),
(4576, '9f34afe1-bca0-43cb-9112-b8df70fca5c2', 2, 3, 1560, 'visitor.id_card', 'messages', 'بطاقة التعريف', 'active', NULL, NULL, '2025-06-21 00:42:59', '2025-06-21 00:42:59'),
(4577, '9f34afe1-c082-4a9b-afd8-48504de276b1', 2, 3, 1561, 'visitor.number_of_person', 'messages', 'عدد الأشخاص', 'active', NULL, NULL, '2025-06-21 00:42:59', '2025-06-21 00:42:59'),
(4578, '9f34afe1-c489-4f34-ab3f-9bdebbe2baf4', 2, 3, 1562, 'visitor.date', 'messages', 'تاريخ', 'active', NULL, NULL, '2025-06-21 00:42:59', '2025-06-21 00:42:59'),
(4579, '9f34afe1-c87e-49f3-99c3-0c81b5047e41', 2, 3, 1563, 'visitor.in_time', 'messages', 'في الوقت المناسب', 'active', NULL, NULL, '2025-06-21 00:42:59', '2025-06-21 00:42:59'),
(4580, '9f34afe1-cc8e-487e-ae91-3ea6f38f4219', 2, 3, 1564, 'visitor.out_time', 'messages', 'وقت خروج', 'active', NULL, NULL, '2025-06-21 00:42:59', '2025-06-21 00:42:59'),
(4581, '9f34afe1-d094-4a37-9a0e-a185ef252dfa', 2, 3, 1565, 'visitor.note', 'messages', 'ملحوظة', 'active', NULL, NULL, '2025-06-21 00:42:59', '2025-06-21 00:42:59'),
(4582, '9f34afe1-d4a5-49f7-a3f6-92ef6ceb7970', 2, 3, 1566, 'visitor.select_purpose', 'messages', 'حدد الغرض', 'active', NULL, NULL, '2025-06-21 00:42:59', '2025-06-21 00:42:59'),
(4583, '9f34afe1-d8bf-4578-8e58-b3c097f21a7c', 2, 3, 1567, 'postal.new_receive', 'messages', 'استلام جديد', 'active', NULL, NULL, '2025-06-21 00:42:59', '2025-06-21 00:42:59'),
(4584, '9f34afe1-dcd5-4452-a097-ff56a0edcda8', 2, 3, 1568, 'postal.new_dispatch', 'messages', 'ديسباتش جديد', 'active', NULL, NULL, '2025-06-21 00:42:59', '2025-06-21 00:42:59'),
(4585, '9f34afe1-e0e8-4c05-9025-34b8a783f819', 2, 3, 1569, 'postal.dispatch', 'messages', 'إيفاد', 'active', NULL, NULL, '2025-06-21 00:42:59', '2025-06-21 00:42:59'),
(4586, '9f34afe1-e58b-4ff9-8ba6-df491633b477', 2, 3, 1570, 'postal.receive', 'messages', 'تسلم', 'active', NULL, NULL, '2025-06-21 00:42:59', '2025-06-21 00:42:59'),
(4587, '9f34afe1-e9bf-421d-a0b2-1aaeb95fdde3', 2, 3, 1571, 'postal.edit_receive', 'messages', 'تحرير تلقي', 'active', NULL, NULL, '2025-06-21 00:42:59', '2025-06-21 00:42:59'),
(4588, '9f34afe1-ede9-467b-9c87-b2ce897208be', 2, 3, 1572, 'postal.edit_dispatch', 'messages', 'تحرير الإرسال', 'active', NULL, NULL, '2025-06-21 00:42:59', '2025-06-21 00:42:59'),
(4589, '9f34afe1-f1e8-4aae-86cf-e391034440c8', 2, 3, 1573, 'postal.to_title', 'messages', 'إلى العنوان', 'active', NULL, NULL, '2025-06-21 00:42:59', '2025-06-21 00:42:59'),
(4590, '9f34afe1-f5f5-4ac3-a818-1d4c24a3e41e', 2, 3, 1574, 'postal.from_title', 'messages', 'من العنوان', 'active', NULL, NULL, '2025-06-21 00:42:59', '2025-06-21 00:42:59'),
(4591, '9f34afe1-f9f7-4e73-8bcb-2cf1b715f447', 2, 3, 1575, 'postal.reference_no', 'messages', 'رقم المرجع', 'active', NULL, NULL, '2025-06-21 00:42:59', '2025-06-21 00:42:59'),
(4592, '9f34afe1-fe09-4b86-83e9-18d8732aeec7', 2, 3, 1576, 'postal.date', 'messages', 'تاريخ', 'active', NULL, NULL, '2025-06-21 00:42:59', '2025-06-21 00:42:59'),
(4593, '9f34afe2-0209-429e-9743-72a838b14e5c', 2, 3, 1577, 'postal.address', 'messages', 'عنوان', 'active', NULL, NULL, '2025-06-21 00:42:59', '2025-06-21 00:42:59'),
(4594, '9f34afe2-063d-4744-9023-12a22160b07e', 2, 3, 1578, 'testimonial.new_testimonial', 'messages', 'شهادة جديدة', 'active', NULL, NULL, '2025-06-21 00:42:59', '2025-06-21 00:42:59'),
(4595, '9f34afe2-0a57-49ed-a03d-0381976bbe2e', 2, 3, 1579, 'testimonial.edit_testimonial', 'messages', 'تحرير شهادة', 'active', NULL, NULL, '2025-06-21 00:42:59', '2025-06-21 00:42:59'),
(4596, '9f34afe2-0e60-4687-9799-ca2fa5326702', 2, 3, 1580, 'testimonial.name', 'messages', 'اسم', 'active', NULL, NULL, '2025-06-21 00:42:59', '2025-06-21 00:42:59'),
(4597, '9f34afe2-1287-41eb-b47f-3dd93201e174', 2, 3, 1583, 'testimonial.position', 'messages', 'موقع', 'active', NULL, NULL, '2025-06-21 00:42:59', '2025-06-21 00:42:59'),
(4598, '9f34afe2-169b-44a2-aa04-12f99e7fb6b0', 2, 3, 1581, 'testimonial.description', 'messages', 'وصف', 'active', NULL, NULL, '2025-06-21 00:42:59', '2025-06-21 00:42:59'),
(4599, '9f34afe2-1aa2-4f64-950e-ecc5b10e0f55', 2, 3, 1584, 'testimonial.show_testimonial', 'messages', 'عرض شهادة', 'active', NULL, NULL, '2025-06-21 00:42:59', '2025-06-21 00:42:59'),
(4600, '9f34afe2-1eac-471d-bbc9-2ae0725f5832', 2, 3, 1582, 'testimonial.profile_error', 'messages', 'يجب أن يكون الملف من النوع: jpg، jpeg، png.', 'active', NULL, NULL, '2025-06-21 00:42:59', '2025-06-21 00:42:59'),
(4601, '9f34afe2-22d2-4d10-af1f-3dd06528b1fc', 2, 3, 1585, 'blood_donation.new_blood_donation', 'messages', 'التبرع بالدم الجديد', 'active', NULL, NULL, '2025-06-21 00:42:59', '2025-06-21 00:42:59'),
(4602, '9f34afe2-2704-4d37-aa7c-756ae61ae5a3', 2, 3, 1586, 'blood_donation.edit_blood_donation', 'messages', 'تحرير التبرع بالدم', 'active', NULL, NULL, '2025-06-21 00:42:59', '2025-06-21 00:42:59'),
(4603, '9f34afe2-2b29-4f43-ae24-501e811bae85', 2, 3, 1587, 'blood_donation.donor_name', 'messages', 'اسم المتبرع', 'active', NULL, NULL, '2025-06-21 00:42:59', '2025-06-21 00:42:59'),
(4604, '9f34afe2-314f-48e5-ba1f-3bd45b761203', 2, 3, 1588, 'blood_donation.bags', 'messages', 'أكياس', 'active', NULL, NULL, '2025-06-21 00:42:59', '2025-06-21 00:42:59'),
(4605, '9f34afe2-3618-448d-a695-bcb7e50f97a6', 2, 3, 1589, 'blood_issue.new_blood_issue', 'messages', 'قضية دم جديدة', 'active', NULL, NULL, '2025-06-21 00:42:59', '2025-06-21 00:42:59'),
(4606, '9f34afe2-3b96-42a1-a8bf-5025b10abbdd', 2, 3, 1590, 'blood_issue.edit_blood_issue', 'messages', 'تحرير قضية الدم', 'active', NULL, NULL, '2025-06-21 00:42:59', '2025-06-21 00:42:59'),
(4607, '9f34afe2-4098-4138-a5eb-4539183e3642', 2, 3, 1591, 'blood_issue.issue_date', 'messages', 'تاريخ الاصدار', 'active', NULL, NULL, '2025-06-21 00:42:59', '2025-06-21 00:42:59'),
(4608, '9f34afe2-46ea-4b49-a5ad-8fa7a90c8f9b', 2, 3, 1592, 'blood_issue.patient_name', 'messages', 'اسم المريض', 'active', NULL, NULL, '2025-06-21 00:42:59', '2025-06-21 00:42:59'),
(4609, '9f34afe2-4b5e-419c-a000-db49813a93d4', 2, 3, 1593, 'blood_issue.doctor_name', 'messages', 'اسم الطبيب', 'active', NULL, NULL, '2025-06-21 00:42:59', '2025-06-21 00:42:59'),
(4610, '9f34afe2-4fae-412f-8396-e0c95473f64f', 2, 3, 1594, 'blood_issue.donor_name', 'messages', 'اسم المتبرع', 'active', NULL, NULL, '2025-06-21 00:42:59', '2025-06-21 00:42:59'),
(4611, '9f34afe2-5425-495e-9e65-be2a7e558546', 2, 3, 1595, 'blood_issue.amount', 'messages', 'كمية', 'active', NULL, NULL, '2025-06-21 00:42:59', '2025-06-21 00:42:59'),
(4612, '9f34afe2-587b-4d83-b392-9a22c54177a8', 2, 3, 1596, 'blood_issue.remarks', 'messages', 'ملاحظات', 'active', NULL, NULL, '2025-06-21 00:42:59', '2025-06-21 00:42:59'),
(4613, '9f34afe2-5d52-4076-95df-a81ed289f452', 2, 3, 1597, 'notification.notifications', 'messages', 'إشعارات', 'active', NULL, NULL, '2025-06-21 00:42:59', '2025-06-21 00:42:59'),
(4614, '9f34afe2-61b9-4f4d-b6c8-3d5a761cb3c1', 2, 3, 1598, 'notification.mark_all_as_read', 'messages', 'اشر عليها بانها قرات', 'active', NULL, NULL, '2025-06-21 00:42:59', '2025-06-21 00:42:59'),
(4615, '9f34afe2-6601-4296-88ad-17c2d88149f6', 2, 3, 1599, 'notification.you_don`t_have_any_new_notification', 'messages', 'ليس لديك أي إخطار جديد', 'active', NULL, NULL, '2025-06-21 00:42:59', '2025-06-21 00:42:59'),
(4616, '9f34afe2-6a63-4a73-b649-226f86ac581a', 2, 3, 1600, 'live_consultation_filter.awaited', 'messages', 'منتظر', 'active', NULL, NULL, '2025-06-21 00:42:59', '2025-06-21 00:42:59'),
(4617, '9f34afe2-6e8d-445d-a203-70aa27d9e739', 2, 3, 1601, 'live_consultation_filter.cancelled', 'messages', 'ألغيت', 'active', NULL, NULL, '2025-06-21 00:42:59', '2025-06-21 00:42:59'),
(4618, '9f34afe2-7311-4ee3-9e24-83080641646a', 2, 3, 1602, 'live_consultation_filter.finished', 'messages', 'انتهى', 'active', NULL, NULL, '2025-06-21 00:42:59', '2025-06-21 00:42:59'),
(4619, '9f34afe2-77bd-4ed5-9335-ab69addb595b', 2, 3, 1603, 'live_consultation.new_live_consultation', 'messages', 'استشارة مباشرة جديدة', 'active', NULL, NULL, '2025-06-21 00:42:59', '2025-06-21 00:42:59'),
(4620, '9f34afe2-7c08-4c5b-a45a-60a5f21cf66d', 2, 3, 1604, 'live_consultation.consultation_title', 'messages', 'عنوان الاستشارة', 'active', NULL, NULL, '2025-06-21 00:42:59', '2025-06-21 00:42:59'),
(4621, '9f34afe2-806f-4caa-9a80-d33971874077', 2, 3, 1605, 'live_consultation.consultation_date', 'messages', 'تاريخ الاستشارة', 'active', NULL, NULL, '2025-06-21 00:42:59', '2025-06-21 00:42:59'),
(4622, '9f34afe2-850b-48ac-9f0f-5ac7cd9299db', 2, 3, 1606, 'live_consultation.consultation_duration_minutes', 'messages', 'دقائق مدة الاستشارة', 'active', NULL, NULL, '2025-06-21 00:42:59', '2025-06-21 00:42:59'),
(4623, '9f34afe2-8958-40b9-991b-95d5ab403dfc', 2, 3, 1607, 'live_consultation.client_video', 'messages', 'فيديو العميل', 'active', NULL, NULL, '2025-06-21 00:42:59', '2025-06-21 00:42:59'),
(4624, '9f34afe2-8db4-4876-9dcd-c34a5ec28ce5', 2, 3, 1608, 'live_consultation.host_video', 'messages', 'استضافة الفيديو', 'active', NULL, NULL, '2025-06-21 00:42:59', '2025-06-21 00:42:59'),
(4625, '9f34afe2-924d-4efa-a487-7e6423cba797', 2, 3, 1609, 'live_consultation.enable', 'messages', 'ممكن', 'active', NULL, NULL, '2025-06-21 00:42:59', '2025-06-21 00:42:59'),
(4626, '9f34afe2-968a-40ec-9b67-145aee0ac5ed', 2, 3, 1610, 'live_consultation.disabled', 'messages', 'معاق', 'active', NULL, NULL, '2025-06-21 00:42:59', '2025-06-21 00:42:59'),
(4627, '9f34afe2-9b52-4df5-a188-91ae1cbddc87', 2, 3, 1611, 'live_consultation.type', 'messages', 'نوع', 'active', NULL, NULL, '2025-06-21 00:42:59', '2025-06-21 00:42:59'),
(4628, '9f34afe2-9fb8-4fcc-9098-ccca2a1a76c5', 2, 3, 1612, 'live_consultation.type_number', 'messages', 'نوع الرقم', 'active', NULL, NULL, '2025-06-21 00:42:59', '2025-06-21 00:42:59'),
(4629, '9f34afe2-a409-4af5-924e-2d535a910b3c', 2, 3, 1613, 'live_consultation.created_by', 'messages', 'انشأ من قبل', 'active', NULL, NULL, '2025-06-21 00:42:59', '2025-06-21 00:42:59'),
(4630, '9f34afe2-a8b2-4613-b4a6-af0ad814b247', 2, 3, 1614, 'live_consultation.created_for', 'messages', 'خلقت ل', 'active', NULL, NULL, '2025-06-21 00:42:59', '2025-06-21 00:42:59'),
(4631, '9f34afe2-acfd-4662-b82e-305356012727', 2, 3, 1621, 'live_consultation.edit_live_meeting', 'messages', 'تحرير الاجتماع المباشر', 'active', NULL, NULL, '2025-06-21 00:42:59', '2025-06-21 00:42:59'),
(4632, '9f34afe2-b14f-4001-8801-dbeebb86687e', 2, 3, 1620, 'live_consultation.join_now', 'messages', 'نضم الان', 'active', NULL, NULL, '2025-06-21 00:42:59', '2025-06-21 00:42:59'),
(4633, '9f34afe2-b591-4689-a89b-9e40b9405852', 2, 3, 1615, 'live_consultation.new_live_meeting', 'messages', 'لقاء مباشر جديد', 'active', NULL, NULL, '2025-06-21 00:42:59', '2025-06-21 00:42:59'),
(4634, '9f34afe2-b9f5-4756-b95f-b0e782349f1d', 2, 3, 1616, 'live_consultation.staff_list', 'messages', 'قائمة موظف', 'active', NULL, NULL, '2025-06-21 00:42:59', '2025-06-21 00:42:59'),
(4635, '9f34afe2-be45-44b9-9831-cae2997c046f', 2, 3, 1622, 'live_consultation.add_credential', 'messages', 'أضف بيانات الاعتماد', 'active', NULL, NULL, '2025-06-21 00:42:59', '2025-06-21 00:42:59'),
(4636, '9f34afe2-c28e-4691-b670-4ac3cb50b1ed', 2, 3, 1617, 'live_consultation.edit_live_consultation', 'messages', 'تحرير الاستشارة المباشرة', 'active', NULL, NULL, '2025-06-21 00:42:59', '2025-06-21 00:42:59'),
(4637, '9f34afe2-c6d7-4762-a585-3a286bf62aa0', 2, 3, 1618, 'live_consultation.duration', 'messages', 'المدة (بالدقائق)', 'active', NULL, NULL, '2025-06-21 00:42:59', '2025-06-21 00:42:59'),
(4638, '9f34afe2-cb18-4e0a-aa67-bc1cd33dcb62', 2, 3, 1623, 'live_consultation.zoom_api_key', 'messages', 'تكبير مفتاح واجهة برمجة التطبيقات', 'active', NULL, NULL, '2025-06-21 00:42:59', '2025-06-21 00:42:59'),
(4639, '9f34afe2-cf75-4eda-80e2-1cd62c3e3577', 2, 3, 1624, 'live_consultation.zoom_api_secret', 'messages', 'تكبير واجهة برمجة التطبيقات السري', 'active', NULL, NULL, '2025-06-21 00:42:59', '2025-06-21 00:42:59'),
(4640, '9f34afe2-d3c2-4b85-b31b-a5c6b7796a86', 2, 3, 1625, 'live_consultation.how_to_generate_Oauth_credentials', 'messages', 'كيفية إنشاء بيانات اعتماد OAuth', 'active', NULL, NULL, '2025-06-21 00:42:59', '2025-06-21 00:42:59'),
(4641, '9f34afe2-d807-4b04-b39a-fa0a4a19e315', 2, 3, 1626, 'live_consultation.select_platform', 'messages', 'حدد المنصة', 'active', NULL, NULL, '2025-06-21 00:42:59', '2025-06-21 00:42:59'),
(4642, '9f34afe2-dc53-4b03-8b79-d3f6a9676769', 2, 3, 1619, 'live_consultation.start_now', 'messages', 'ابدأ الآن', 'active', NULL, NULL, '2025-06-21 00:42:59', '2025-06-21 00:42:59'),
(4643, '9f34afe2-e091-40b1-a1c4-7e573ddeebd5', 2, 3, 1627, 'vaccination.vaccinations', 'messages', 'التطعيمات', 'active', NULL, NULL, '2025-06-21 00:42:59', '2025-06-21 00:42:59'),
(4644, '9f34afe2-e4d4-4e36-becf-bb45ec12db97', 2, 3, 1628, 'vaccination.new_vaccination', 'messages', 'تطعيم جديد', 'active', NULL, NULL, '2025-06-21 00:42:59', '2025-06-21 00:42:59'),
(4645, '9f34afe2-e934-4462-998b-a7f049b0ad3f', 2, 3, 1629, 'vaccination.edit_vaccination', 'messages', 'تحرير التطعيم', 'active', NULL, NULL, '2025-06-21 00:42:59', '2025-06-21 00:42:59'),
(4646, '9f34afe2-edac-4e10-9678-63862d32a4be', 2, 3, 1631, 'vaccination.name', 'messages', 'اسم', 'active', NULL, NULL, '2025-06-21 00:43:00', '2025-06-21 00:43:00'),
(4647, '9f34afe2-f214-4a3b-980c-e0edd14c2b3b', 2, 3, 1632, 'vaccination.manufactured_by', 'messages', 'صنع بواسطة', 'active', NULL, NULL, '2025-06-21 00:43:00', '2025-06-21 00:43:00'),
(4648, '9f34afe2-f82f-4ac7-9b67-ebbe93533289', 2, 3, 1633, 'vaccination.brand', 'messages', 'ماركة', 'active', NULL, NULL, '2025-06-21 00:43:00', '2025-06-21 00:43:00'),
(4649, '9f34afe2-fc65-4f49-9109-fa66d2d1dfe6', 2, 3, 1634, 'vaccination.vaccinated', 'messages', 'تلقيح', 'active', NULL, NULL, '2025-06-21 00:43:00', '2025-06-21 00:43:00'),
(4650, '9f34afe3-00a4-426e-a68a-9008e903052f', 2, 3, 1630, 'vaccination.select_vaccination', 'messages', 'اختر التطعيم', 'active', NULL, NULL, '2025-06-21 00:43:00', '2025-06-21 00:43:00'),
(4651, '9f34afe3-04d3-4f87-af02-1fc70c7094a9', 2, 3, 1635, 'vaccinated_patient.patient', 'messages', 'مريض', 'active', NULL, NULL, '2025-06-21 00:43:00', '2025-06-21 00:43:00'),
(4652, '9f34afe3-08fc-4016-9e25-54538ef597dc', 2, 3, 1636, 'vaccinated_patient.vaccination', 'messages', 'تلقيح', 'active', NULL, NULL, '2025-06-21 00:43:00', '2025-06-21 00:43:00'),
(4653, '9f34afe3-0d25-42c0-9eb9-a813a29d1fd2', 2, 3, 1637, 'vaccinated_patient.vaccination_name', 'messages', 'اسم التطعيم', 'active', NULL, NULL, '2025-06-21 00:43:00', '2025-06-21 00:43:00'),
(4654, '9f34afe3-1137-4569-a013-91236720a5c9', 2, 3, 1638, 'vaccinated_patient.serial_no', 'messages', 'الرقم التسلسلي', 'active', NULL, NULL, '2025-06-21 00:43:00', '2025-06-21 00:43:00'),
(4655, '9f34afe3-1556-4340-91c3-59dd154c3983', 2, 3, 1639, 'vaccinated_patient.does_no', 'messages', 'جرعة لا', 'active', NULL, NULL, '2025-06-21 00:43:00', '2025-06-21 00:43:00'),
(4656, '9f34afe3-197b-4ba6-8d8a-a6a36a6285c6', 2, 3, 1640, 'vaccinated_patient.dose_given_date', 'messages', 'تاريخ إعطاء الجرعة', 'active', NULL, NULL, '2025-06-21 00:43:00', '2025-06-21 00:43:00'),
(4657, '9f34afe3-1d9d-42de-8b03-ceeab05b9961', 2, 3, 1641, 'vaccinated_patient.description', 'messages', 'وصف', 'active', NULL, NULL, '2025-06-21 00:43:00', '2025-06-21 00:43:00'),
(4658, '9f34afe3-21f6-4701-ab5a-1123e78ca811', 2, 3, 1642, 'vaccinated_patient.add_vaccinate_patient', 'messages', 'اضافة لقاح للمريض', 'active', NULL, NULL, '2025-06-21 00:43:00', '2025-06-21 00:43:00'),
(4659, '9f34afe3-2635-4485-87b5-629fbd4b2cc7', 2, 3, 1643, 'vaccinated_patient.new_vaccinate_patient', 'messages', 'لقاح جديد للمريض', 'active', NULL, NULL, '2025-06-21 00:43:00', '2025-06-21 00:43:00'),
(4660, '9f34afe3-2a83-45b8-8e22-93223b19a2f3', 2, 3, 1644, 'vaccinated_patient.edit_vaccinate_patient', 'messages', 'تحرير لقاح المريض', 'active', NULL, NULL, '2025-06-21 00:43:00', '2025-06-21 00:43:00'),
(4661, '9f34afe3-2ead-4219-b45c-c0176ca16d5c', 2, 3, 1645, 'vaccinated_patient.vaccine', 'messages', 'مصل', 'active', NULL, NULL, '2025-06-21 00:43:00', '2025-06-21 00:43:00'),
(4662, '9f34afe3-3301-45c5-a27e-b4346880ae59', 2, 3, 1646, 'vaccinated_patient.vaccinate_patient', 'messages', 'تطعيم المريض', 'active', NULL, NULL, '2025-06-21 00:43:00', '2025-06-21 00:43:00'),
(4663, '9f34afe3-3756-4b77-8226-c8d01198dd21', 2, 3, 1647, 'front_setting.front_setting_details', 'messages', 'تفاصيل الإعداد الأمامي', 'active', NULL, NULL, '2025-06-21 00:43:00', '2025-06-21 00:43:00'),
(4664, '9f34afe3-3bd2-4b61-81cd-b2b7e6119939', 2, 3, 1648, 'front_setting.about_us_details', 'messages', 'من نحن التفاصيل', 'active', NULL, NULL, '2025-06-21 00:43:00', '2025-06-21 00:43:00'),
(4665, '9f34afe3-401d-462c-abff-c5460adf8fa3', 2, 3, 1649, 'front_setting.appointment_details', 'messages', 'تفاصيل الموعد', 'active', NULL, NULL, '2025-06-21 00:43:00', '2025-06-21 00:43:00'),
(4666, '9f34afe3-4472-4bca-81e9-1d25b1781a86', 2, 3, 1650, 'front_setting.terms_condition_details', 'messages', 'تفاصيل الشروط والأحكام', 'active', NULL, NULL, '2025-06-21 00:43:00', '2025-06-21 00:43:00'),
(4667, '9f34afe3-48b2-414a-a79e-e9ee17a4acfa', 2, 3, 1651, 'front_setting.about_us_title', 'messages', 'لقب', 'active', NULL, NULL, '2025-06-21 00:43:00', '2025-06-21 00:43:00'),
(4668, '9f34afe3-4d03-4425-8ed1-e7b90a7f6d64', 2, 3, 1652, 'front_setting.about_us_mission', 'messages', 'مهمة', 'active', NULL, NULL, '2025-06-21 00:43:00', '2025-06-21 00:43:00'),
(4669, '9f34afe3-513b-487c-aee8-2f6f7202697b', 2, 3, 1653, 'front_setting.about_us_image', 'messages', 'صورة', 'active', NULL, NULL, '2025-06-21 00:43:00', '2025-06-21 00:43:00'),
(4670, '9f34afe3-56b5-4429-a17d-f3a936c33cca', 2, 3, 1654, 'front_setting.about_us_description', 'messages', 'وصف', 'active', NULL, NULL, '2025-06-21 00:43:00', '2025-06-21 00:43:00'),
(4671, '9f34afe3-5b2b-45c1-8a82-08535f39b877', 2, 3, 1655, 'front_setting.home_page_image', 'messages', 'صورة الصفحة الرئيسية', 'active', NULL, NULL, '2025-06-21 00:43:00', '2025-06-21 00:43:00'),
(4672, '9f34afe3-5f6a-4133-86c4-f647d0f03c98', 2, 3, 1656, 'front_setting.home_page_title', 'messages', 'عنوان الصفحة الرئيسية', 'active', NULL, NULL, '2025-06-21 00:43:00', '2025-06-21 00:43:00'),
(4673, '9f34afe3-63d2-4537-9c3f-e271ac2768cd', 2, 3, 1657, 'front_setting.home_page_description', 'messages', 'وصف الصفحة الرئيسية', 'active', NULL, NULL, '2025-06-21 00:43:00', '2025-06-21 00:43:00'),
(4674, '9f34afe3-67f4-433c-a425-686aa07b10de', 2, 3, 1658, 'front_setting.home_page_box_title', 'messages', 'عنوان مربع الصفحة الرئيسية', 'active', NULL, NULL, '2025-06-21 00:43:00', '2025-06-21 00:43:00'),
(4675, '9f34afe3-6c88-4e9a-8127-ca6666f272a0', 2, 3, 1659, 'front_setting.home_page_box_description', 'messages', 'وصف مربع الصفحة الرئيسية', 'active', NULL, NULL, '2025-06-21 00:43:00', '2025-06-21 00:43:00'),
(4676, '9f34afe3-712b-4da5-9229-255c44288f6f', 2, 3, 1660, 'front_setting.home_page_experience', 'messages', 'تجربة الصفحة الرئيسية', 'active', NULL, NULL, '2025-06-21 00:43:00', '2025-06-21 00:43:00'),
(4677, '9f34afe3-7580-4cc4-9a12-eba64902f855', 2, 3, 1661, 'front_setting.home_page_step_1_title', 'messages', 'الصفحة الرئيسية الخطوة 1 العنوان', 'active', NULL, NULL, '2025-06-21 00:43:00', '2025-06-21 00:43:00'),
(4678, '9f34afe3-79b9-4785-909c-054da2135bbb', 2, 3, 1662, 'front_setting.home_page_step_1_description', 'messages', 'الصفحة الرئيسية الخطوة 1 الوصف', 'active', NULL, NULL, '2025-06-21 00:43:00', '2025-06-21 00:43:00'),
(4679, '9f34afe3-7df7-4602-840d-f8b643995560', 2, 3, 1663, 'front_setting.home_page_step_2_title', 'messages', 'الصفحة الرئيسية الخطوة 2 العنوان', 'active', NULL, NULL, '2025-06-21 00:43:00', '2025-06-21 00:43:00'),
(4680, '9f34afe3-826f-4f1c-8b56-2c1fcd98de20', 2, 3, 1664, 'front_setting.home_page_step_2_description', 'messages', 'الصفحة الرئيسية الخطوة 2 الوصف', 'active', NULL, NULL, '2025-06-21 00:43:00', '2025-06-21 00:43:00'),
(4681, '9f34afe3-86c1-407c-a994-966ba8305460', 2, 3, 1665, 'front_setting.home_page_step_3_title', 'messages', 'الصفحة الرئيسية الخطوة 3 العنوان', 'active', NULL, NULL, '2025-06-21 00:43:00', '2025-06-21 00:43:00'),
(4682, '9f34afe3-8b27-4cc2-85b9-a075572531b9', 2, 3, 1666, 'front_setting.home_page_step_3_description', 'messages', 'الصفحة الرئيسية الخطوة 3 الوصف', 'active', NULL, NULL, '2025-06-21 00:43:00', '2025-06-21 00:43:00'),
(4683, '9f34afe3-8f99-4f94-8700-3d019cf0d36f', 2, 3, 1667, 'front_setting.home_page_step_4_title', 'messages', 'الصفحة الرئيسية الخطوة 4 العنوان', 'active', NULL, NULL, '2025-06-21 00:43:00', '2025-06-21 00:43:00'),
(4684, '9f34afe3-93c8-4e18-907b-7fb48a0f11e4', 2, 3, 1668, 'front_setting.home_page_step_4_description', 'messages', 'الصفحة الرئيسية الخطوة 4 الوصف', 'active', NULL, NULL, '2025-06-21 00:43:00', '2025-06-21 00:43:00'),
(4685, '9f34afe3-9841-4cea-90e6-188c4c630879', 2, 3, 1669, 'front_setting.terms_conditions', 'messages', 'البنود و الظروف', 'active', NULL, NULL, '2025-06-21 00:43:00', '2025-06-21 00:43:00'),
(4686, '9f34afe3-9ccb-4718-8792-a5911623a03d', 2, 3, 1670, 'front_setting.privacy_policy', 'messages', 'سياسة خاصة', 'active', NULL, NULL, '2025-06-21 00:43:00', '2025-06-21 00:43:00'),
(4687, '9f34afe3-a159-4484-a6d1-d6ad54fba101', 2, 3, 1671, 'front_setting.home_page_certified_doctor_image', 'messages', 'الصفحة الرئيسية صورة طبيب معتمد', 'active', NULL, NULL, '2025-06-21 00:43:00', '2025-06-21 00:43:00'),
(4688, '9f34afe3-a5b8-4c47-879a-16bd666072c9', 2, 3, 1672, 'front_setting.home_page_certified_doctor_text', 'messages', 'الصفحة الرئيسية نص طبيب معتمد', 'active', NULL, NULL, '2025-06-21 00:43:00', '2025-06-21 00:43:00'),
(4689, '9f34afe3-aa0f-4233-9b6b-7d7971128caa', 2, 3, 1673, 'front_setting.home_page_certified_doctor_title', 'messages', 'الصفحة الرئيسية لقب طبيب معتمد', 'active', NULL, NULL, '2025-06-21 00:43:00', '2025-06-21 00:43:00'),
(4690, '9f34afe3-ae64-404f-94d5-293c74e719bf', 2, 3, 1674, 'front_setting.home_page_certified_doctor_description', 'messages', 'الصفحة الرئيسية وصف الطبيب المعتمد', 'active', NULL, NULL, '2025-06-21 00:43:00', '2025-06-21 00:43:00'),
(4691, '9f34afe3-b2a9-4575-b178-047ac5a3b056', 2, 3, 1675, 'front_setting.home_page_certified_box_title', 'messages', 'عنوان مربع معتمد للصفحة الرئيسية', 'active', NULL, NULL, '2025-06-21 00:43:00', '2025-06-21 00:43:00'),
(4692, '9f34afe3-b72a-4eb4-b430-a7916ae1a5e4', 2, 3, 1676, 'front_setting.home_page_certified_box_description', 'messages', 'وصف مربع معتمد للصفحة الرئيسية', 'active', NULL, NULL, '2025-06-21 00:43:00', '2025-06-21 00:43:00'),
(4693, '9f34afe3-bb90-41e4-8f36-c700f25dbf60', 2, 3, 1677, 'change_password.change_password', 'messages', 'تغيير كلمة المرور', 'active', NULL, NULL, '2025-06-21 00:43:00', '2025-06-21 00:43:00'),
(4694, '9f34afe3-c004-4a80-8d68-beffac6e5938', 2, 3, 1678, 'change_password.current_password', 'messages', 'كلمة السر الحالية', 'active', NULL, NULL, '2025-06-21 00:43:00', '2025-06-21 00:43:00'),
(4695, '9f34afe3-c469-49b4-963c-ce3bd0daf989', 2, 3, 1679, 'change_password.new_password', 'messages', 'كلمة السر الجديدة', 'active', NULL, NULL, '2025-06-21 00:43:00', '2025-06-21 00:43:00'),
(4696, '9f34afe3-c8b6-4f74-8899-b039df40aa3a', 2, 3, 1680, 'change_password.confirm_password', 'messages', 'تأكيد كلمة المرور', 'active', NULL, NULL, '2025-06-21 00:43:00', '2025-06-21 00:43:00'),
(4697, '9f34afe3-cd15-4e4a-86b9-c2eb4f4e563e', 2, 3, 1681, 'change_password.enter_your_current_password', 'messages', 'أدخل كلمة المرور الحالية الخاصة بك', 'active', NULL, NULL, '2025-06-21 00:43:00', '2025-06-21 00:43:00'),
(4698, '9f34afe3-d157-4eff-b723-1d774bea9340', 2, 3, 1682, 'change_password.enter_a_new_password', 'messages', 'أدخل كلمة مرور جديدة', 'active', NULL, NULL, '2025-06-21 00:43:00', '2025-06-21 00:43:00'),
(4699, '9f34afe3-d580-481e-aeb4-9e398d8bc8a5', 2, 3, 1683, 'change_password.confirm_your_new_password', 'messages', 'قم بتأكيد كلمة المرور الجديدة', 'active', NULL, NULL, '2025-06-21 00:43:00', '2025-06-21 00:43:00'),
(4700, '9f34afe3-d9ae-492a-80e8-8791e8d62783', 2, 3, 1686, 'web_home.home', 'messages', 'الصفحة الرئيسية', 'active', NULL, NULL, '2025-06-21 00:43:00', '2025-06-21 00:43:00'),
(4701, '9f34afe3-de07-4d90-a4ee-5f4c47799d4e', 2, 3, 1687, 'web_home.services', 'messages', 'خدمات', 'active', NULL, NULL, '2025-06-21 00:43:00', '2025-06-21 00:43:00'),
(4702, '9f34afe3-e239-441f-94c5-e9d16bb0cd60', 2, 3, 1688, 'web_home.doctors', 'messages', 'الأطباء', 'active', NULL, NULL, '2025-06-21 00:43:00', '2025-06-21 00:43:00'),
(4703, '9f34afe3-e681-4322-a957-5386fd13782f', 2, 3, 1689, 'web_home.about_us', 'messages', 'معلومات عنا', 'active', NULL, NULL, '2025-06-21 00:43:00', '2025-06-21 00:43:00'),
(4704, '9f34afe3-eae6-4b07-b71d-a81eafd3c343', 2, 3, 1690, 'web_home.contact', 'messages', 'اتصل', 'active', NULL, NULL, '2025-06-21 00:43:00', '2025-06-21 00:43:00'),
(4705, '9f34afe3-ef20-4f92-b410-edccf4edf2f2', 2, 3, 1691, 'web_home.make_appointment', 'messages', 'حدد موعدا', 'active', NULL, NULL, '2025-06-21 00:43:00', '2025-06-21 00:43:00'),
(4706, '9f34afe3-f3a2-42f8-a3fa-649b8aab605d', 2, 3, 1692, 'web_home.working_hours', 'messages', 'ساعات العمل', 'active', NULL, NULL, '2025-06-21 00:43:00', '2025-06-21 00:43:00'),
(4707, '9f34afe3-f7ef-47ae-a2b5-bb5562073703', 2, 3, 1693, 'web_home.testimonials', 'messages', 'الشهادات', 'active', NULL, NULL, '2025-06-21 00:43:00', '2025-06-21 00:43:00'),
(4708, '9f34afe3-fc1e-4e72-8df6-616b5dfc9a5b', 2, 3, 1694, 'web_home.terms_of_service', 'messages', 'شروط الخدمة', 'active', NULL, NULL, '2025-06-21 00:43:00', '2025-06-21 00:43:00'),
(4709, '9f34afe4-0040-40c0-938b-732065b9efe2', 2, 3, 1695, 'web_home.privacy_policy', 'messages', 'سياسة خاصة', 'active', NULL, NULL, '2025-06-21 00:43:00', '2025-06-21 00:43:00'),
(4710, '9f34afe4-0461-4064-85cf-29ef8d03bb55', 2, 3, 1696, 'web_home.patients', 'messages', 'مرضى', 'active', NULL, NULL, '2025-06-21 00:43:00', '2025-06-21 00:43:00'),
(4711, '9f34afe4-08f0-4767-92fd-cdb889188d60', 2, 3, 1697, 'web_home.years_experience', 'messages', 'سنوات خبرة', 'active', NULL, NULL, '2025-06-21 00:43:00', '2025-06-21 00:43:00'),
(4712, '9f34afe4-0d37-47c3-a7b5-be03794410ea', 2, 3, 1698, 'web_home.sign_up', 'messages', 'اشتراك', 'active', NULL, NULL, '2025-06-21 00:43:00', '2025-06-21 00:43:00'),
(4713, '9f34afe4-11cc-48f5-9dab-8d97b34dd1fc', 2, 3, 1699, 'web_home.available_doctors', 'messages', 'الأطباء المتاحون', 'active', NULL, NULL, '2025-06-21 00:43:00', '2025-06-21 00:43:00'),
(4714, '9f34afe4-1658-4dbb-9133-e30b19d9d01d', 2, 3, 1700, 'web_home.select_doctors', 'messages', 'حدد الأطباء', 'active', NULL, NULL, '2025-06-21 00:43:00', '2025-06-21 00:43:00'),
(4715, '9f34afe4-1ae9-48a5-a4d4-d328ce44e9f0', 2, 3, 1701, 'web_home.contact_doctors', 'messages', 'اتصل بالطبيب', 'active', NULL, NULL, '2025-06-21 00:43:00', '2025-06-21 00:43:00'),
(4716, '9f34afe4-1f5f-4d2d-bc6f-0ae3e22c7141', 2, 3, 1702, 'web_home.contact_hospital', 'messages', 'اتصل بالمستشفى', 'active', NULL, NULL, '2025-06-21 00:43:00', '2025-06-21 00:43:00'),
(4717, '9f34afe4-239f-42bc-978f-e0ab8bf3c61e', 2, 3, 1703, 'web_home.easy_solutions', 'messages', 'حلول سهلة', 'active', NULL, NULL, '2025-06-21 00:43:00', '2025-06-21 00:43:00'),
(4718, '9f34afe4-27f6-4435-bb24-1fc234084bec', 2, 3, 1704, 'web_home.4_easy_step_and_get_the_world_best_treatment', 'messages', '4 خطوات سهلة واحصل على أفضل علاج في العالم', 'active', NULL, NULL, '2025-06-21 00:43:00', '2025-06-21 00:43:00'),
(4719, '9f34afe4-2c38-4817-b896-f821bd10dd25', 2, 3, 1705, 'web_home.book_an_appointment', 'messages', 'احجز موعدًا', 'active', NULL, NULL, '2025-06-21 00:43:00', '2025-06-21 00:43:00'),
(4720, '9f34afe4-30bc-48a3-8a43-c74cf7d4284e', 2, 3, 1706, 'web_home.select_doctor', 'messages', 'اختر دكتور', 'active', NULL, NULL, '2025-06-21 00:43:00', '2025-06-21 00:43:00'),
(4721, '9f34afe4-357d-4f4b-875d-4feab5a8ae89', 2, 3, 1707, 'web_home.book_now', 'messages', 'احجز الآن', 'active', NULL, NULL, '2025-06-21 00:43:00', '2025-06-21 00:43:00'),
(4722, '9f34afe4-39fc-40da-a87c-2a20c8c0721b', 2, 3, 1708, 'web_home.patients_beds', 'messages', 'أسرة المرضى', 'active', NULL, NULL, '2025-06-21 00:43:00', '2025-06-21 00:43:00'),
(4723, '9f34afe4-3e7e-4926-9f23-84d40b8c42be', 2, 3, 1709, 'web_home.doctors_nurses', 'messages', 'أطباء وممرضات', 'active', NULL, NULL, '2025-06-21 00:43:00', '2025-06-21 00:43:00'),
(4724, '9f34afe4-42b9-4fff-81fe-44924330e38d', 2, 3, 1710, 'web_home.happy_patients', 'messages', 'مرضى سعداء', 'active', NULL, NULL, '2025-06-21 00:43:00', '2025-06-21 00:43:00'),
(4725, '9f34afe4-4717-4131-81f6-8a2732119c7f', 2, 3, 1711, 'web_home.book_appointment', 'messages', 'موعد الكتاب', 'active', NULL, NULL, '2025-06-21 00:43:00', '2025-06-21 00:43:00'),
(4726, '9f34afe4-4b88-4553-9222-67aec533ad68', 2, 3, 1712, 'web_home.our_services', 'messages', 'خدماتنا', 'active', NULL, NULL, '2025-06-21 00:43:00', '2025-06-21 00:43:00'),
(4727, '9f34afe4-4fce-4dda-b02a-6dcbf241d5cb', 2, 3, 1713, 'web_home.we_offer_different_services_to_improve_your_health', 'messages', 'نحن نقدم خدمات مختلفة لتحسين صحتك', 'active', NULL, NULL, '2025-06-21 00:43:00', '2025-06-21 00:43:00'),
(4728, '9f34afe4-543a-40cb-834b-2584047e533b', 2, 3, 1714, 'web_home.professional_doctors', 'messages', 'أطباء متخصصون', 'active', NULL, NULL, '2025-06-21 00:43:00', '2025-06-21 00:43:00'),
(4729, '9f34afe4-58c2-4030-ab87-4bcd84fa02dd', 2, 3, 1715, 'web_home.we_are_experienced_healthcare_professionals', 'messages', 'نحن متخصصون في مجال الرعاية الصحية من ذوي الخبرة', 'active', NULL, NULL, '2025-06-21 00:43:00', '2025-06-21 00:43:00'),
(4730, '9f34afe4-5d23-4ca0-89f7-e29c546d162a', 2, 3, 1716, 'web_home.our_testimonials', 'messages', 'شهاداتنا', 'active', NULL, NULL, '2025-06-21 00:43:00', '2025-06-21 00:43:00'),
(4731, '9f34afe4-619a-4d12-b6f0-ed318db98468', 2, 3, 1717, 'web_home.what_our_patient_say_about_medical_treatments', 'messages', 'ماذا يقول مرضانا عن علاجاتنا الطبية', 'active', NULL, NULL, '2025-06-21 00:43:00', '2025-06-21 00:43:00'),
(4732, '9f34afe4-6646-424e-9dda-6c63954a7037', 2, 3, 1718, 'web_contact.call_today', 'messages', 'الدعوة اليوم', 'active', NULL, NULL, '2025-06-21 00:43:00', '2025-06-21 00:43:00'),
(4733, '9f34afe4-6be1-4adc-af27-6661c30fd256', 2, 3, 1719, 'web_contact.open_hours', 'messages', 'ساعات مفتوحة', 'active', NULL, NULL, '2025-06-21 00:43:00', '2025-06-21 00:43:00'),
(4734, '9f34afe4-7051-451c-873a-8d26b233cd66', 2, 3, 1720, 'web_contact.our_location', 'messages', 'موقعنا', 'active', NULL, NULL, '2025-06-21 00:43:00', '2025-06-21 00:43:00'),
(4735, '9f34afe4-74a7-4f22-af66-98a8ba466311', 2, 3, 1721, 'web_contact.send_us_a_message', 'messages', 'أرسل لنا رسالة', 'active', NULL, NULL, '2025-06-21 00:43:01', '2025-06-21 00:43:01'),
(4736, '9f34afe4-7929-4a0f-9e9f-b11fd2499dab', 2, 3, 1722, 'web_contact.your_name', 'messages', 'اسمك', 'active', NULL, NULL, '2025-06-21 00:43:01', '2025-06-21 00:43:01'),
(4737, '9f34afe4-7fe5-4a5a-85b9-38b522303b46', 2, 3, 1723, 'web_contact.your_email', 'messages', 'بريدك الالكتروني', 'active', NULL, NULL, '2025-06-21 00:43:01', '2025-06-21 00:43:01'),
(4738, '9f34afe4-84e5-454f-833f-7fec5f8c4e13', 2, 3, 1724, 'web_contact.phone_number', 'messages', 'رقم الهاتف', 'active', NULL, NULL, '2025-06-21 00:43:01', '2025-06-21 00:43:01'),
(4739, '9f34afe4-8967-4dac-83d1-a51f07afb193', 2, 3, 1725, 'web_contact.select_enquiry', 'messages', 'حدد الاستفسار', 'active', NULL, NULL, '2025-06-21 00:43:01', '2025-06-21 00:43:01'),
(4740, '9f34afe4-8e1d-4482-8c88-5afb48bfc6b9', 2, 3, 1726, 'web_contact.your_message', 'messages', 'رسالتك', 'active', NULL, NULL, '2025-06-21 00:43:01', '2025-06-21 00:43:01'),
(4741, '9f34afe4-92fa-4d1b-b35f-7b200dd7c6ea', 2, 3, 1727, 'web_contact.send_message', 'messages', 'أرسل رسالة', 'active', NULL, NULL, '2025-06-21 00:43:01', '2025-06-21 00:43:01'),
(4742, '9f34afe4-97e6-4dab-bb4e-3bd1293fbac2', 2, 3, 1728, 'web_contact.enter_your_name', 'messages', 'أدخل أسمك', 'active', NULL, NULL, '2025-06-21 00:43:01', '2025-06-21 00:43:01'),
(4743, '9f34afe4-9c5d-42f0-8867-8c09a752395d', 2, 3, 1729, 'web_contact.enter_your_email', 'messages', 'أدخل بريدك الإلكتروني', 'active', NULL, NULL, '2025-06-21 00:43:01', '2025-06-21 00:43:01'),
(4744, '9f34afe4-a0e5-4b62-80a6-e923ccc67fe3', 2, 3, 1730, 'web_contact.contact_no', 'messages', 'رقم الاتصال', 'active', NULL, NULL, '2025-06-21 00:43:01', '2025-06-21 00:43:01'),
(4745, '9f34afe4-a5a5-4d25-975b-8d5ac23c3dfa', 2, 3, 1731, 'web_contact.please_enter_your_phone_number', 'messages', 'يرجى إدخال رقم الهاتف الخاص بك', 'active', NULL, NULL, '2025-06-21 00:43:01', '2025-06-21 00:43:01'),
(4746, '9f34afe4-aa88-444b-ac73-17e3b0abbe82', 2, 3, 1733, 'web_contact.write_your_message', 'messages', 'اكتب رسالتك', 'active', NULL, NULL, '2025-06-21 00:43:01', '2025-06-21 00:43:01'),
(4747, '9f34afe4-af42-4518-8a6a-dd5052927f7f', 2, 3, 1734, 'web_contact.type_your_message', 'messages', 'اكتب رسالتك', 'active', NULL, NULL, '2025-06-21 00:43:01', '2025-06-21 00:43:01'),
(4748, '9f34afe4-b4ae-4b56-8e0c-371ad32e888c', 2, 3, 1732, 'web_contact.enter_your_phone_number', 'messages', 'أدخل رقم هاتفك', 'active', NULL, NULL, '2025-06-21 00:43:01', '2025-06-21 00:43:01'),
(4749, '9f34afe4-bae3-410d-af5e-94610c8c4952', 2, 3, 1735, 'web_contact.get_in_touch', 'messages', 'تواصل معنا وأخبرنا كيف يمكننا المساعدة. املأ النموذج وسنتواصل معك في أقرب وقت ممكن.\n', 'active', NULL, NULL, '2025-06-21 00:43:01', '2025-06-21 00:43:01'),
(4750, '9f34afe4-c127-4d6f-b461-b3ee13504e34', 2, 3, 1736, 'web_menu.about', 'messages', 'عن', 'active', NULL, NULL, '2025-06-21 00:43:01', '2025-06-21 00:43:01'),
(4751, '9f34afe4-c5a8-4b58-b805-8c86814ed715', 2, 3, 1737, 'web_menu.our_features', 'messages', 'ميزاتنا', 'active', NULL, NULL, '2025-06-21 00:43:01', '2025-06-21 00:43:01'),
(4752, '9f34afe4-ca0a-495c-837f-4aeeb74349bd', 2, 3, 1738, 'web_menu.appointment', 'messages', 'ميعاد', 'active', NULL, NULL, '2025-06-21 00:43:01', '2025-06-21 00:43:01'),
(4753, '9f34afe4-ce95-408d-ad7f-fed9b6b272ec', 2, 3, 1739, 'web_menu.working_hours', 'messages', 'ساعات العمل', 'active', NULL, NULL, '2025-06-21 00:43:01', '2025-06-21 00:43:01'),
(4754, '9f34afe4-d33f-4578-97da-01cba54b3f72', 2, 3, 1740, 'web_menu.login', 'messages', 'تسجيل الدخول', 'active', NULL, NULL, '2025-06-21 00:43:01', '2025-06-21 00:43:01'),
(4755, '9f34afe4-d7b4-4423-b3ea-52fce56439bc', 2, 3, 1741, 'web_menu.useful_link', 'messages', 'رابط مفيد', 'active', NULL, NULL, '2025-06-21 00:43:01', '2025-06-21 00:43:01'),
(4756, '9f34afe4-dc33-469b-a013-ff572463554c', 2, 3, 1742, 'web_menu.contact_information', 'messages', 'معلومات للتواصل', 'active', NULL, NULL, '2025-06-21 00:43:01', '2025-06-21 00:43:01'),
(4757, '9f34afe4-e0d0-4f10-87af-2e82695a0cd5', 2, 3, 1743, 'web_menu.copyright', 'messages', 'حقوق النشر', 'active', NULL, NULL, '2025-06-21 00:43:01', '2025-06-21 00:43:01'),
(4758, '9f34afe4-e52a-4cea-b731-db4fd284d31c', 2, 3, 1744, 'web_menu.all_rights_reserved_by', 'messages', 'جميع الحقوق محفوظة', 'active', NULL, NULL, '2025-06-21 00:43:01', '2025-06-21 00:43:01'),
(4759, '9f34afe4-eb52-47b1-aecb-10030a3d2f30', 2, 3, 1745, 'web_menu.all_rights_reserved', 'messages', 'كل الحقوق محفوظة', 'active', NULL, NULL, '2025-06-21 00:43:01', '2025-06-21 00:43:01'),
(4760, '9f34afe4-efe9-47e4-bdb1-a512171d2d26', 2, 3, 1746, 'web_appointment.make_an_appointment', 'messages', 'إحجز موعد', 'active', NULL, NULL, '2025-06-21 00:43:01', '2025-06-21 00:43:01'),
(4761, '9f34afe4-f480-4bf4-88f0-c54112d6c295', 2, 3, 1747, 'web_appointment.call_now_and_get_a_free_consulting', 'messages', 'اتصل الآن واحصل على استشارة مجانية', 'active', NULL, NULL, '2025-06-21 00:43:01', '2025-06-21 00:43:01'),
(4762, '9f34afe4-f935-466f-b225-b719c8d40ae3', 2, 3, 1748, 'web_appointment.enter_your_first_name', 'messages', 'أدخل اسمك الأول', 'active', NULL, NULL, '2025-06-21 00:43:01', '2025-06-21 00:43:01'),
(4763, '9f34afe4-fda8-4125-97e4-0900ef4fb45f', 2, 3, 1749, 'web_appointment.enter_your_last_name', 'messages', 'أدخل اسمك الأخير', 'active', NULL, NULL, '2025-06-21 00:43:01', '2025-06-21 00:43:01'),
(4764, '9f34afe5-0224-4f32-a0c6-5b4e85a7ce40', 2, 3, 1750, 'web_appointment.enter_your_password', 'messages', 'ادخل رقمك السري', 'active', NULL, NULL, '2025-06-21 00:43:01', '2025-06-21 00:43:01'),
(4765, '9f34afe5-06d3-4da2-b7da-04e367ff203b', 2, 3, 1751, 'web_appointment.enter_confirm_password', 'messages', 'أدخل تأكيد كلمة المرور', 'active', NULL, NULL, '2025-06-21 00:43:01', '2025-06-21 00:43:01'),
(4766, '9f34afe5-0b53-40c1-8a77-b1e6a00e1108', 2, 3, 1752, 'web_appointment.select_department', 'messages', 'حدد القسم', 'active', NULL, NULL, '2025-06-21 00:43:01', '2025-06-21 00:43:01'),
(4767, '9f34afe5-1008-4ad1-b5da-dded956d0895', 2, 3, 1753, 'web_appointment.select_doctor', 'messages', 'اختر دكتور', 'active', NULL, NULL, '2025-06-21 00:43:01', '2025-06-21 00:43:01'),
(4768, '9f34afe5-1466-4b85-9e2b-cca3183eec74', 2, 3, 1754, 'web_appointment.enter_description', 'messages', 'أدخل الوصف', 'active', NULL, NULL, '2025-06-21 00:43:01', '2025-06-21 00:43:01'),
(4769, '9f34afe5-1919-4c8b-9df7-7e701a2a7f23', 2, 3, 1755, 'web_appointment.select_time', 'messages', 'حدد الوقت', 'active', NULL, NULL, '2025-06-21 00:43:01', '2025-06-21 00:43:01'),
(4770, '9f34afe5-1e06-41a3-8b36-5723f36f57e8', 2, 3, 1756, 'web_appointment.select_date', 'messages', 'حدد تاريخ', 'active', NULL, NULL, '2025-06-21 00:43:01', '2025-06-21 00:43:01'),
(4771, '9f34afe5-22a6-4153-94c5-aa266ca6feeb', 2, 3, 1757, 'web_working_hours.opening_hours', 'messages', 'ساعات العمل', 'active', NULL, NULL, '2025-06-21 00:43:01', '2025-06-21 00:43:01'),
(4772, '9f34afe5-274d-4cfd-a876-33a328c0d2c4', 2, 3, 1758, 'web_working_hours.no_yet_opening_hours', 'messages', 'لا توجد ساعات عمل بعد', 'active', NULL, NULL, '2025-06-21 00:43:01', '2025-06-21 00:43:01'),
(4773, '9f34afe5-2bd1-47b8-bc5b-909ef8e26482', 2, 3, 1786, 'subscription_plans.make_default', 'messages', 'جعل الافتراضي', 'active', NULL, NULL, '2025-06-21 00:43:01', '2025-06-21 00:43:01'),
(4774, '9f34afe5-30d4-4d28-9f22-6b907ddb7c31', 2, 3, 1784, 'subscription_plans.start_date', 'messages', 'تاريخ البدء', 'active', NULL, NULL, '2025-06-21 00:43:01', '2025-06-21 00:43:01'),
(4775, '9f34afe5-352e-4e84-8319-3d5e7ec89fb2', 2, 3, 1785, 'subscription_plans.end_date', 'messages', 'تنتهي صلاحيته في', 'active', NULL, NULL, '2025-06-21 00:43:01', '2025-06-21 00:43:01'),
(4776, '9f34afe5-399f-4c0f-a426-0a3b800c4984', 2, 3, 1760, 'subscription_plans.add_subscription_plan', 'messages', 'إضافة خطة الاشتراك', 'active', NULL, NULL, '2025-06-21 00:43:01', '2025-06-21 00:43:01'),
(4777, '9f34afe5-3e66-4a89-861c-29714176a727', 2, 3, 1761, 'subscription_plans.name', 'messages', 'اسم', 'active', NULL, NULL, '2025-06-21 00:43:01', '2025-06-21 00:43:01'),
(4778, '9f34afe5-42e2-4f1f-a1ac-6dd2e43a6c15', 2, 3, 1762, 'subscription_plans.currency', 'messages', 'عملة', 'active', NULL, NULL, '2025-06-21 00:43:01', '2025-06-21 00:43:01'),
(4779, '9f34afe5-47a8-4974-830f-938211f23f99', 2, 3, 1763, 'subscription_plans.price', 'messages', 'سعر', 'active', NULL, NULL, '2025-06-21 00:43:01', '2025-06-21 00:43:01'),
(4780, '9f34afe5-4c4b-49aa-973b-6f659c9a8c7e', 2, 3, 1764, 'subscription_plans.valid_until', 'messages', 'صالح حتى', 'active', NULL, NULL, '2025-06-21 00:43:01', '2025-06-21 00:43:01'),
(4781, '9f34afe5-516a-4040-842e-2167f2dfc1bd', 2, 3, 1765, 'subscription_plans.edit_subscription_plan', 'messages', 'تحرير خطة الاشتراك', 'active', NULL, NULL, '2025-06-21 00:43:01', '2025-06-21 00:43:01'),
(4782, '9f34afe5-5625-4f7d-967d-f49410de0881', 2, 3, 1766, 'subscription_plans.plan_type', 'messages', 'نوع الخطة', 'active', NULL, NULL, '2025-06-21 00:43:01', '2025-06-21 00:43:01'),
(4783, '9f34afe5-5af9-4709-b943-a47322cf8775', 2, 3, 1767, 'subscription_plans.active_plan', 'messages', 'الخطط النشطة', 'active', NULL, NULL, '2025-06-21 00:43:01', '2025-06-21 00:43:01'),
(4784, '9f34afe5-5f68-4b88-a07b-6b7856fc40a1', 2, 3, 1768, 'subscription_plans.valid_until_tooltip', 'messages', 'إذا كنت تدخل 1 ونوع الخطة هو عام ، فسيتم اعتباره عامًا واحدًا للشهر.', 'active', NULL, NULL, '2025-06-21 00:43:01', '2025-06-21 00:43:01'),
(4785, '9f34afe5-6488-4002-abf9-606594358d96', 2, 3, 1769, 'subscription_plans.trail_plan', 'messages', 'خطة المسار', 'active', NULL, NULL, '2025-06-21 00:43:01', '2025-06-21 00:43:01'),
(4786, '9f34afe5-693a-42f8-be32-2c3d6c06245b', 2, 3, 1770, 'subscription_plans.trail_plan_text', 'messages', 'خطة المسار لها سعر صفر والعملة بالدولار الأمريكي سارية حتى (بالأيام) افتراضيًا.', 'active', NULL, NULL, '2025-06-21 00:43:01', '2025-06-21 00:43:01'),
(4787, '9f34afe5-6e38-43f2-9a7d-1299004a091f', 2, 3, 1779, 'subscription_plans.plan_features', 'messages', 'ميزات الخطة', 'active', NULL, NULL, '2025-06-21 00:43:01', '2025-06-21 00:43:01'),
(4788, '9f34afe5-732e-4776-8481-032b73a56080', 2, 3, 1780, 'subscription_plans.select_all', 'messages', 'اختر الكل', 'active', NULL, NULL, '2025-06-21 00:43:01', '2025-06-21 00:43:01'),
(4789, '9f34afe5-77f7-4a67-873e-848efb8828ad', 2, 3, 1781, 'subscription_plans.default_plan_text_one', 'messages', 'تحتوي هذه القائمة على ملفات', 'active', NULL, NULL, '2025-06-21 00:43:01', '2025-06-21 00:43:01'),
(4790, '9f34afe5-7cc3-4145-8c93-15dfd6c862cd', 2, 3, 1782, 'subscription_plans.default_plan_text_two', 'messages', 'القوائم الفرعية.', 'active', NULL, NULL, '2025-06-21 00:43:01', '2025-06-21 00:43:01'),
(4791, '9f34afe5-8191-43a5-aed3-003b605113a6', 2, 3, 1771, 'subscription_plans.payment_type', 'messages', 'اختر نوع الدفع', 'active', NULL, NULL, '2025-06-21 00:43:01', '2025-06-21 00:43:01'),
(4792, '9f34afe5-8671-42fe-8427-e8e139f975a0', 2, 3, 1772, 'subscription_plans.transactions', 'messages', 'المعاملات', 'active', NULL, NULL, '2025-06-21 00:43:01', '2025-06-21 00:43:01'),
(4793, '9f34afe5-8b05-45f5-a088-128c56af0659', 2, 3, 1773, 'subscription_plans.transaction_details', 'messages', 'تفاصيل الصفقة', 'active', NULL, NULL, '2025-06-21 00:43:01', '2025-06-21 00:43:01'),
(4794, '9f34afe5-8fa5-43ce-8815-cd55c4332ed1', 2, 3, 1774, 'subscription_plans.plan_name', 'messages', 'اسم الخطة', 'active', NULL, NULL, '2025-06-21 00:43:01', '2025-06-21 00:43:01'),
(4795, '9f34afe5-9567-401c-9a83-2ed525b61369', 2, 3, 1775, 'subscription_plans.transaction_date', 'messages', 'تاريخ الصفقة', 'active', NULL, NULL, '2025-06-21 00:43:01', '2025-06-21 00:43:01'),
(4796, '9f34afe5-99e6-4388-b2c3-7f64c81c88d2', 2, 3, 1776, 'subscription_plans.payment_method', 'messages', 'طريقة الدفع او السداد', 'active', NULL, NULL, '2025-06-21 00:43:01', '2025-06-21 00:43:01'),
(4797, '9f34afe5-9ec0-48ff-88a1-32447f9ada7d', 2, 3, 1777, 'subscription_plans.amount', 'messages', 'كمية', 'active', NULL, NULL, '2025-06-21 00:43:01', '2025-06-21 00:43:01'),
(4798, '9f34afe5-a346-404d-8c2c-eb7db5d64988', 2, 3, 1778, 'subscription_plans.free_plan', 'messages', 'خطة مجانية', 'active', NULL, NULL, '2025-06-21 00:43:01', '2025-06-21 00:43:01'),
(4799, '9f34afe5-a804-4cc2-a564-344fd2d24f47', 2, 3, 1783, 'subscription_plans.view_subscription_plan', 'messages', 'تفاصيل خطة الاشتراك', 'active', NULL, NULL, '2025-06-21 00:43:01', '2025-06-21 00:43:01'),
(4800, '9f34afe5-acbd-49e7-9697-7cab93137191', 2, 3, 1788, 'subscription_plans.subscription_plans', 'messages', 'خطط الاشتراك', 'active', NULL, NULL, '2025-06-21 00:43:01', '2025-06-21 00:43:01'),
(4801, '9f34afe5-b177-4546-a940-4868658faf82', 2, 3, 1794, 'subscription_plans.transaction', 'messages', 'عملية', 'active', NULL, NULL, '2025-06-21 00:43:01', '2025-06-21 00:43:01'),
(4802, '9f34afe5-b623-4aa9-a070-8a0bdb7853d9', 2, 3, 1795, 'subscription_plans.frequency', 'messages', 'تكرر', 'active', NULL, NULL, '2025-06-21 00:43:01', '2025-06-21 00:43:01'),
(4803, '9f34afe5-badb-4525-9f7d-2d960bc5c6cf', 2, 3, 1796, 'subscription_plans.trail_end_date', 'messages', 'تاريخ انتهاء النسخة التجريبية', 'active', NULL, NULL, '2025-06-21 00:43:01', '2025-06-21 00:43:01'),
(4804, '9f34afe5-c0ac-4bdb-b518-254f355d4d17', 2, 3, NULL, 'subscription_plans.transaction_id', 'messages', 'رقم المعاملة', 'active', NULL, NULL, '2025-06-21 00:43:01', '2025-06-21 00:43:01'),
(4805, '9f34afe5-c572-491a-96d1-5b8bd5d0c939', 2, 3, 1797, 'subscription_plans.payment', 'messages', 'دفع', 'active', NULL, NULL, '2025-06-21 00:43:01', '2025-06-21 00:43:01'),
(4806, '9f34afe5-ca01-4a63-af31-d09cc7bf59eb', 2, 3, 1798, 'subscription_plans.enter_plan_name', 'messages', 'أدخل اسم الخطة', 'active', NULL, NULL, '2025-06-21 00:43:01', '2025-06-21 00:43:01'),
(4807, '9f34afe5-ce78-432a-990b-da3823cf72e2', 2, 3, 1799, 'subscription_plans.select_currency', 'messages', 'اختر العملة', 'active', NULL, NULL, '2025-06-21 00:43:01', '2025-06-21 00:43:01'),
(4808, '9f34afe5-d318-4d6b-bdad-0dbc0d12179f', 2, 3, 1800, 'subscription_plans.enter_price', 'messages', 'أدخل السعر', 'active', NULL, NULL, '2025-06-21 00:43:01', '2025-06-21 00:43:01'),
(4809, '9f34afe5-d7bd-4d60-b0a1-52f45fbc7dbb', 2, 3, 1801, 'subscription_plans.enter_trial_day', 'messages', 'أدخل أيام التجربة', 'active', NULL, NULL, '2025-06-21 00:43:01', '2025-06-21 00:43:01'),
(4810, '9f34afe5-dbf4-428d-b22f-93a6870ba68c', 2, 3, 1759, 'subscription_plans.select_plan_type', 'messages', 'حدد نوع الخطة', 'active', NULL, NULL, '2025-06-21 00:43:01', '2025-06-21 00:43:01'),
(4811, '9f34afe5-e063-470c-ba3c-225979bc2afe', 2, 3, 1789, 'subscription_plans.remaining_balance', 'messages', 'الرصيد المتبقي', 'active', NULL, NULL, '2025-06-21 00:43:01', '2025-06-21 00:43:01'),
(4812, '9f34afe5-e4dc-496d-a4c7-420065a9f5e4', 2, 3, 1790, 'subscription_plans.amount_to_pay', 'messages', 'المبلغ المطلوب دفعه', 'active', NULL, NULL, '2025-06-21 00:43:01', '2025-06-21 00:43:01'),
(4813, '9f34afe5-e976-492d-a5bd-2438a3cea55a', 2, 3, 1791, 'subscription_plans.used_days', 'messages', 'أيام مستعملة', 'active', NULL, NULL, '2025-06-21 00:43:01', '2025-06-21 00:43:01'),
(4814, '9f34afe5-edea-45ee-8c51-b53879de8562', 2, 3, 1792, 'subscription_plans.total_extra_days', 'messages', 'إجمالي الأيام الإضافية', 'active', NULL, NULL, '2025-06-21 00:43:01', '2025-06-21 00:43:01'),
(4815, '9f34afe5-f25a-4717-9312-de52ceccfe1c', 2, 3, 1793, 'subscription_plans.pay_or_switch_plan', 'messages', 'خطة الدفع / التبديل', 'active', NULL, NULL, '2025-06-21 00:43:01', '2025-06-21 00:43:01'),
(4816, '9f34afe5-f6f8-4622-89a4-e4ac652aeddd', 2, 3, 1787, 'subscription_plans.default_plan', 'messages', 'الخطة الافتراضية', 'active', NULL, NULL, '2025-06-21 00:43:01', '2025-06-21 00:43:01'),
(4817, '9f34afe5-fb9a-4172-a349-ea7868e28f81', 2, 3, 1802, 'subscription_pricing_plans.subscription_pricing_plan', 'messages', 'خطة تسعير الاشتراك', 'active', NULL, NULL, '2025-06-21 00:43:02', '2025-06-21 00:43:02'),
(4818, '9f34afe6-0049-4e24-9c27-0f8dbc7af482', 2, 3, 1803, 'subscription_pricing_plans.choose_plan', 'messages', 'اختر الخطة', 'active', NULL, NULL, '2025-06-21 00:43:02', '2025-06-21 00:43:02'),
(4819, '9f34afe6-04c7-47ce-9876-f2b24b850caf', 2, 3, 1804, 'subscription_pricing_plans.week', 'messages', 'أسبوع', 'active', NULL, NULL, '2025-06-21 00:43:02', '2025-06-21 00:43:02'),
(4820, '9f34afe6-0966-4446-a8a9-55d3b4ff07bf', 2, 3, 1805, 'subscription_pricing_plans.month', 'messages', 'شهر', 'active', NULL, NULL, '2025-06-21 00:43:02', '2025-06-21 00:43:02'),
(4821, '9f34afe6-0e0d-4474-b4d5-7f61f581473d', 2, 3, 1806, 'subscription_pricing_plans.year', 'messages', 'عام', 'active', NULL, NULL, '2025-06-21 00:43:02', '2025-06-21 00:43:02'),
(4822, '9f34afe6-1294-450c-8499-84e203777b05', 2, 3, 1807, 'subscription_pricing_plans.has_been_subscribed', 'messages', 'تم الاشتراك', 'active', NULL, NULL, '2025-06-21 00:43:02', '2025-06-21 00:43:02'),
(4823, '9f34afe6-1726-41e6-a378-32ed601315fb', 2, 3, 1809, 'subscription_pricing_plans.currently_active', 'messages', 'نشط حاليا', 'active', NULL, NULL, '2025-06-21 00:43:02', '2025-06-21 00:43:02'),
(4824, '9f34afe6-1bbb-4b39-bbe1-0c31b0755d6a', 2, 3, 1810, 'subscription_pricing_plans.renew_plan', 'messages', 'تجديد الخطة', 'active', NULL, NULL, '2025-06-21 00:43:02', '2025-06-21 00:43:02'),
(4825, '9f34afe6-2059-4f6b-a9eb-7d8a1c5192d2', 2, 3, 1811, 'subscription_pricing_plans.no_pricing_plan_found', 'messages', 'لم نتمكن من العثور على أي خطة اشتراك', 'active', NULL, NULL, '2025-06-21 00:43:02', '2025-06-21 00:43:02'),
(4826, '9f34afe6-24f7-48ad-a953-16cb6cacbf92', 2, 3, 1812, 'subscription_pricing_plans.renew_free_plan', 'messages', 'لا يمكن تجديد / اختيار الباقة المجانية مرة أخرى', 'active', NULL, NULL, '2025-06-21 00:43:02', '2025-06-21 00:43:02'),
(4827, '9f34afe6-2974-4248-91c3-00e2d7f3e427', 2, 3, 1813, 'subscription_pricing_plans.proceed_to_payment', 'messages', 'الشروع في دفع', 'active', NULL, NULL, '2025-06-21 00:43:02', '2025-06-21 00:43:02'),
(4828, '9f34afe6-2e01-47f6-8fae-6279103786d3', 2, 3, 1814, 'subscription_pricing_plans.switch_plan', 'messages', 'خطة التبديل', 'active', NULL, NULL, '2025-06-21 00:43:02', '2025-06-21 00:43:02'),
(4829, '9f34afe6-3273-4489-90d5-adf589193c58', 2, 3, 1808, 'subscription_pricing_plans.has_already_been_subscribed', 'messages', 'مشترك بالفعل', 'active', NULL, NULL, '2025-06-21 00:43:02', '2025-06-21 00:43:02'),
(4830, '9f34afe6-36f9-4bab-bdaf-a297a6fd32cd', 2, 3, 1815, 'landing_cms.landing_cms', 'messages', 'هبوط نظام إدارة المحتوى', 'active', NULL, NULL, '2025-06-21 00:43:02', '2025-06-21 00:43:02'),
(4831, '9f34afe6-3b70-4ba4-8c50-4fe90f250a2d', 2, 3, 1816, 'landing_cms.section_one', 'messages', 'القسم الاول', 'active', NULL, NULL, '2025-06-21 00:43:02', '2025-06-21 00:43:02'),
(4832, '9f34afe6-3fdf-4f43-b258-78e53215da31', 2, 3, 1817, 'landing_cms.text_main', 'messages', 'نص رئيسي', 'active', NULL, NULL, '2025-06-21 00:43:02', '2025-06-21 00:43:02');
INSERT INTO `ltu_phrases` (`id`, `uuid`, `translation_id`, `translation_file_id`, `phrase_id`, `key`, `group`, `value`, `status`, `parameters`, `note`, `created_at`, `updated_at`) VALUES
(4833, '9f34afe6-4453-480f-a3b4-b7d8c4c11062', 2, 3, 1818, 'landing_cms.text_secondary', 'messages', 'نص ثانوي', 'active', NULL, NULL, '2025-06-21 00:43:02', '2025-06-21 00:43:02'),
(4834, '9f34afe6-48db-42fa-9ba4-3c09b2d536c5', 2, 3, 1819, 'landing_cms.image', 'messages', 'صورة', 'active', NULL, NULL, '2025-06-21 00:43:02', '2025-06-21 00:43:02'),
(4835, '9f34afe6-4da0-48b6-9d3a-73bd66cbe1d9', 2, 3, 1820, 'landing_cms.section_two', 'messages', 'القسم الثاني', 'active', NULL, NULL, '2025-06-21 00:43:02', '2025-06-21 00:43:02'),
(4836, '9f34afe6-5210-45dc-87ce-6103be791c81', 2, 3, 1821, 'landing_cms.card_one_image', 'messages', 'صورة البطاقة الأولى', 'active', NULL, NULL, '2025-06-21 00:43:02', '2025-06-21 00:43:02'),
(4837, '9f34afe6-56c4-4cd6-a52a-e65f846a30db', 2, 3, 1822, 'landing_cms.card_one_text', 'messages', 'نص البطاقة الأولى', 'active', NULL, NULL, '2025-06-21 00:43:02', '2025-06-21 00:43:02'),
(4838, '9f34afe6-5b46-4ae3-91f9-6ff97b5adf56', 2, 3, 1823, 'landing_cms.card_one_text_secondary', 'messages', 'نص البطاقة الأولى الثانوية', 'active', NULL, NULL, '2025-06-21 00:43:02', '2025-06-21 00:43:02'),
(4839, '9f34afe6-5fda-4ed8-a85b-95bc1ee7c870', 2, 3, 1824, 'landing_cms.card_two_image', 'messages', 'صورة البطاقة الثانية', 'active', NULL, NULL, '2025-06-21 00:43:02', '2025-06-21 00:43:02'),
(4840, '9f34afe6-645b-43e5-9e42-e475ca39d1fa', 2, 3, 1825, 'landing_cms.card_two_text', 'messages', 'نص البطاقة الثانية', 'active', NULL, NULL, '2025-06-21 00:43:02', '2025-06-21 00:43:02'),
(4841, '9f34afe6-68e7-4051-936a-b7927e782bec', 2, 3, 1826, 'landing_cms.card_two_text_secondary', 'messages', 'نص البطاقة الثانية الثانوية', 'active', NULL, NULL, '2025-06-21 00:43:02', '2025-06-21 00:43:02'),
(4842, '9f34afe6-6d5e-4152-bb62-1400897321db', 2, 3, 1827, 'landing_cms.card_third_image', 'messages', 'الصورة الثالثة للبطاقة', 'active', NULL, NULL, '2025-06-21 00:43:02', '2025-06-21 00:43:02'),
(4843, '9f34afe6-71d2-4997-a0e0-3e808930e8d6', 2, 3, 1828, 'landing_cms.card_third_text', 'messages', 'النص الثالث للبطاقة', 'active', NULL, NULL, '2025-06-21 00:43:02', '2025-06-21 00:43:02'),
(4844, '9f34afe6-7666-41dd-918b-86dc28130794', 2, 3, 1829, 'landing_cms.card_third_text_secondary', 'messages', 'البطاقة الثالثة للنص الثانوي', 'active', NULL, NULL, '2025-06-21 00:43:02', '2025-06-21 00:43:02'),
(4845, '9f34afe6-7b31-4c91-b781-6452cf1a302c', 2, 3, 1830, 'landing_cms.section_three', 'messages', 'القسم الثالث', 'active', NULL, NULL, '2025-06-21 00:43:02', '2025-06-21 00:43:02'),
(4846, '9f34afe6-7fcb-4313-a25f-4dd3699a1b04', 2, 3, 1831, 'landing_cms.text_one', 'messages', 'نص واحد', 'active', NULL, NULL, '2025-06-21 00:43:02', '2025-06-21 00:43:02'),
(4847, '9f34afe6-8450-4afe-868d-31a789ec0793', 2, 3, 1832, 'landing_cms.text_two', 'messages', 'النص الثاني', 'active', NULL, NULL, '2025-06-21 00:43:02', '2025-06-21 00:43:02'),
(4848, '9f34afe6-88f6-4c32-b36e-c6b0ead3070e', 2, 3, 1833, 'landing_cms.text_three', 'messages', 'نص ثلاثة', 'active', NULL, NULL, '2025-06-21 00:43:02', '2025-06-21 00:43:02'),
(4849, '9f34afe6-8d6e-4d73-88a1-88cd98700f0d', 2, 3, 1834, 'landing_cms.text_four', 'messages', 'نص أربعة', 'active', NULL, NULL, '2025-06-21 00:43:02', '2025-06-21 00:43:02'),
(4850, '9f34afe6-91e8-4ce5-9576-ee04c6e04c17', 2, 3, 1835, 'landing_cms.text_five', 'messages', 'نص خمسة', 'active', NULL, NULL, '2025-06-21 00:43:02', '2025-06-21 00:43:02'),
(4851, '9f34afe6-9661-4ddb-a896-aaa2aede1951', 2, 3, 1836, 'landing_cms.section_four', 'messages', 'القسم الرابع', 'active', NULL, NULL, '2025-06-21 00:43:02', '2025-06-21 00:43:02'),
(4852, '9f34afe6-9ad4-41e8-afe5-d6430df41f55', 2, 3, 1837, 'landing_cms.card_three_image', 'messages', 'صورة البطاقة الثالثة', 'active', NULL, NULL, '2025-06-21 00:43:02', '2025-06-21 00:43:02'),
(4853, '9f34afe6-9f85-4d4a-9e4c-d5d1e779d041', 2, 3, 1838, 'landing_cms.card_three_text', 'messages', 'نص البطاقة الثالثة', 'active', NULL, NULL, '2025-06-21 00:43:02', '2025-06-21 00:43:02'),
(4854, '9f34afe6-a3eb-4b02-accc-f42825dbe97d', 2, 3, 1839, 'landing_cms.card_three_text_secondary', 'messages', 'نص البطاقة الثالثة الثانوية', 'active', NULL, NULL, '2025-06-21 00:43:02', '2025-06-21 00:43:02'),
(4855, '9f34afe6-a9c6-4efc-8f0a-07d56d159412', 2, 3, 1840, 'landing_cms.card_four_image', 'messages', 'صورة البطاقة الرابعة', 'active', NULL, NULL, '2025-06-21 00:43:02', '2025-06-21 00:43:02'),
(4856, '9f34afe6-ae74-40bc-a024-a15296bf1700', 2, 3, 1841, 'landing_cms.card_four_text', 'messages', 'نص البطاقة الرابعة', 'active', NULL, NULL, '2025-06-21 00:43:02', '2025-06-21 00:43:02'),
(4857, '9f34afe6-b2e1-4945-afd2-05f7cd3469d4', 2, 3, 1842, 'landing_cms.card_four_text_secondary', 'messages', 'نص البطاقة الرابعة الثانوية', 'active', NULL, NULL, '2025-06-21 00:43:02', '2025-06-21 00:43:02'),
(4858, '9f34afe6-b8ad-4fb4-8916-334a6e6a72cd', 2, 3, 1843, 'landing_cms.card_five_image', 'messages', 'صورة البطاقة الخامسة', 'active', NULL, NULL, '2025-06-21 00:43:02', '2025-06-21 00:43:02'),
(4859, '9f34afe6-bd17-4e23-95fd-e6a615e8c5ad', 2, 3, 1844, 'landing_cms.card_five_text', 'messages', 'نص البطاقة الخامسة', 'active', NULL, NULL, '2025-06-21 00:43:02', '2025-06-21 00:43:02'),
(4860, '9f34afe6-c1a2-4b77-9d91-48857f67e998', 2, 3, 1845, 'landing_cms.card_five_text_secondary', 'messages', 'نص البطاقة الخامسة الثانوية', 'active', NULL, NULL, '2025-06-21 00:43:02', '2025-06-21 00:43:02'),
(4861, '9f34afe6-c650-4dae-83ea-106adf2dd90d', 2, 3, 1846, 'landing_cms.card_six_image', 'messages', 'صورة البطاقة السادسة', 'active', NULL, NULL, '2025-06-21 00:43:02', '2025-06-21 00:43:02'),
(4862, '9f34afe6-cad7-43a0-9228-e0f37e562f4f', 2, 3, 1847, 'landing_cms.card_six_text', 'messages', 'نص البطاقة السادسة', 'active', NULL, NULL, '2025-06-21 00:43:02', '2025-06-21 00:43:02'),
(4863, '9f34afe6-cf43-4b97-8100-790a308e432a', 2, 3, 1848, 'landing_cms.card_six_text_secondary', 'messages', 'نص البطاقة السادسة الثانوية', 'active', NULL, NULL, '2025-06-21 00:43:02', '2025-06-21 00:43:02'),
(4864, '9f34afe6-d3a4-4e8a-a6d1-574a149b12ff', 2, 3, 1849, 'landing_cms.section_five', 'messages', 'القسم الخامس', 'active', NULL, NULL, '2025-06-21 00:43:02', '2025-06-21 00:43:02'),
(4865, '9f34afe6-d817-4db1-822c-8b8383abbbdc', 2, 3, 1850, 'landing_cms.main_image', 'messages', 'الصورة الرئيسية', 'active', NULL, NULL, '2025-06-21 00:43:02', '2025-06-21 00:43:02'),
(4866, '9f34afe6-dc84-4238-8d76-2d21667344f0', 2, 3, 1851, 'landing_cms.card_one_number', 'messages', 'البطاقة رقم واحد', 'active', NULL, NULL, '2025-06-21 00:43:02', '2025-06-21 00:43:02'),
(4867, '9f34afe6-e11e-4580-810e-0c9f09963cf5', 2, 3, 1852, 'landing_cms.card_two_number', 'messages', 'رقم البطاقة الثانية', 'active', NULL, NULL, '2025-06-21 00:43:02', '2025-06-21 00:43:02'),
(4868, '9f34afe6-e595-4b3a-850b-e717d5eff2bd', 2, 3, 1853, 'landing_cms.card_three_number', 'messages', 'رقم البطاقة الثالثة', 'active', NULL, NULL, '2025-06-21 00:43:02', '2025-06-21 00:43:02'),
(4869, '9f34afe6-ea30-4079-b67f-d50df39ef03a', 2, 3, 1854, 'landing_cms.card_four_number', 'messages', 'رقم البطاقة الرابعة', 'active', NULL, NULL, '2025-06-21 00:43:02', '2025-06-21 00:43:02'),
(4870, '9f34afe6-ef10-4098-884f-6cd25d4619a2', 2, 3, 1855, 'landing_cms.about_us', 'messages', 'معلومات عنا', 'active', NULL, NULL, '2025-06-21 00:43:02', '2025-06-21 00:43:02'),
(4871, '9f34afe6-f39b-4903-a037-6b02f4467444', 2, 3, 1856, 'landing_cms.main_img_one', 'messages', 'الصورة الرئيسية الأولى', 'active', NULL, NULL, '2025-06-21 00:43:02', '2025-06-21 00:43:02'),
(4872, '9f34afe6-f84b-4ce7-8e61-aca3757dc539', 2, 3, 1857, 'landing_cms.main_img_two', 'messages', 'الصورة الرئيسية الثانية', 'active', NULL, NULL, '2025-06-21 00:43:02', '2025-06-21 00:43:02'),
(4873, '9f34afe6-fcbd-4906-bff2-096ca50aee22', 2, 3, 1858, 'subscribe.subscribers', 'messages', 'مشتركين', 'active', NULL, NULL, '2025-06-21 00:43:02', '2025-06-21 00:43:02'),
(4874, '9f34afe7-012a-4f7b-a52d-29c1ca22c8ff', 2, 3, 1859, 'footer_setting.footer_settings', 'messages', 'إعدادات التذييل', 'active', NULL, NULL, '2025-06-21 00:43:02', '2025-06-21 00:43:02'),
(4875, '9f34afe7-05aa-41d6-aeec-0fa2f8045469', 2, 3, 1860, 'footer_setting.footer_text', 'messages', 'نص التذييل', 'active', NULL, NULL, '2025-06-21 00:43:02', '2025-06-21 00:43:02'),
(4876, '9f34afe7-0a4a-4bd2-94ce-f614740a4b77', 2, 3, 1861, 'footer_setting.address', 'messages', 'عنوان', 'active', NULL, NULL, '2025-06-21 00:43:02', '2025-06-21 00:43:02'),
(4877, '9f34afe7-0eb0-4144-90b9-2e58c33b7b02', 2, 3, 1862, 'landing.subscribe_our_newsletter', 'messages', 'اشترك في النشرة الإخبارية لدينا', 'active', NULL, NULL, '2025-06-21 00:43:02', '2025-06-21 00:43:02'),
(4878, '9f34afe7-1320-46e1-be8e-1d617b0c1f82', 2, 3, 1863, 'landing.subscribe', 'messages', 'الإشتراك', 'active', NULL, NULL, '2025-06-21 00:43:02', '2025-06-21 00:43:02'),
(4879, '9f34afe7-17d4-43bf-bf28-b3a9b071e8af', 2, 3, 1864, 'landing.usefull_link', 'messages', 'رابط مفيد', 'active', NULL, NULL, '2025-06-21 00:43:02', '2025-06-21 00:43:02'),
(4880, '9f34afe7-1c3d-48ba-9492-03a84ba47ba3', 2, 3, 1865, 'landing.faqs', 'messages', 'أسئلة وأجوبة', 'active', NULL, NULL, '2025-06-21 00:43:02', '2025-06-21 00:43:02'),
(4881, '9f34afe7-20b2-429d-819d-642df9b0bbb9', 2, 3, 1866, 'landing.about', 'messages', 'عن', 'active', NULL, NULL, '2025-06-21 00:43:02', '2025-06-21 00:43:02'),
(4882, '9f34afe7-251c-44b8-8719-6dbfa3b21c60', 2, 3, 1867, 'landing.home', 'messages', 'الصفحة الرئيسية', 'active', NULL, NULL, '2025-06-21 00:43:02', '2025-06-21 00:43:02'),
(4883, '9f34afe7-29a3-43fe-a6aa-f0964aa8806a', 2, 3, 1868, 'landing.pricing', 'messages', 'التسعير', 'active', NULL, NULL, '2025-06-21 00:43:02', '2025-06-21 00:43:02'),
(4884, '9f34afe7-2e11-407a-817a-e0f38d8c3f12', 2, 3, 1869, 'landing.get_in_touch', 'messages', 'ابقى على تواصل', 'active', NULL, NULL, '2025-06-21 00:43:02', '2025-06-21 00:43:02'),
(4885, '9f34afe7-329e-4b0f-8009-7e4886ce70fc', 2, 3, 1870, 'landing.all_rights_reserved', 'messages', 'جميع الحقوق محفوظة', 'active', NULL, NULL, '2025-06-21 00:43:02', '2025-06-21 00:43:02'),
(4886, '9f34afe7-371d-4e0a-8530-6819faa4a57b', 2, 3, 1871, 'landing.call', 'messages', 'مكالمة', 'active', NULL, NULL, '2025-06-21 00:43:02', '2025-06-21 00:43:02'),
(4887, '9f34afe7-3ba7-42b8-b746-ad061c060d0e', 2, 3, 1872, 'landing.choose_your_pricing_plan', 'messages', 'اختر خطة التسعير الخاصة بك', 'active', NULL, NULL, '2025-06-21 00:43:02', '2025-06-21 00:43:02'),
(4888, '9f34afe7-4079-4219-bfa7-4a6fa9a4cd0c', 2, 3, 1873, 'landing.enquiry', 'messages', 'سؤال', 'active', NULL, NULL, '2025-06-21 00:43:02', '2025-06-21 00:43:02'),
(4889, '9f34afe7-4527-4290-952b-896fa316a644', 2, 3, 1874, 'faqs.faqs', 'messages', 'الأسئلة الشائعة', 'active', NULL, NULL, '2025-06-21 00:43:02', '2025-06-21 00:43:02'),
(4890, '9f34afe7-49a3-4399-bb51-e972e88c3a74', 2, 3, 1875, 'faqs.add_faqs', 'messages', 'أضف التعليمات', 'active', NULL, NULL, '2025-06-21 00:43:02', '2025-06-21 00:43:02'),
(4891, '9f34afe7-4e16-4099-ab15-4799634ca3a1', 2, 3, 1876, 'faqs.edit_faqs', 'messages', 'تحرير التعليمات', 'active', NULL, NULL, '2025-06-21 00:43:02', '2025-06-21 00:43:02'),
(4892, '9f34afe7-5273-47f3-83d9-d407b4d94685', 2, 3, 1877, 'faqs.question', 'messages', 'سؤال', 'active', NULL, NULL, '2025-06-21 00:43:02', '2025-06-21 00:43:02'),
(4893, '9f34afe7-56f9-4c36-be67-98370cc48a9e', 2, 3, 1878, 'faqs.answer', 'messages', 'إجابة', 'active', NULL, NULL, '2025-06-21 00:43:02', '2025-06-21 00:43:02'),
(4894, '9f34afe7-5b81-4117-b72f-5475eaa4f787', 2, 3, 1879, 'faqs.show', 'messages', 'إظهار الأسئلة الشائعة', 'active', NULL, NULL, '2025-06-21 00:43:02', '2025-06-21 00:43:02'),
(4895, '9f34afe7-6015-4a6b-b760-9c80468baa52', 2, 3, 1884, 'hospitals_list.hospital_name', 'messages', 'اسم المستشفى', 'active', NULL, NULL, '2025-06-21 00:43:02', '2025-06-21 00:43:02'),
(4896, '9f34afe7-64ca-492a-ae47-c484421e84a5', 2, 3, 1885, 'hospitals_list.hospital_username', 'messages', 'اسم مستخدم المستشفى', 'active', NULL, NULL, '2025-06-21 00:43:02', '2025-06-21 00:43:02'),
(4897, '9f34afe7-6964-4bab-ab89-94715cf5ffe4', 2, 3, 1886, 'hospitals_list.add_new_hospital', 'messages', 'إضافة مستشفى جديد', 'active', NULL, NULL, '2025-06-21 00:43:02', '2025-06-21 00:43:02'),
(4898, '9f34afe7-6e05-437f-b4f8-6e2d0508182f', 2, 3, 1887, 'hospitals_list.edit_hospital', 'messages', 'تحرير المستشفى', 'active', NULL, NULL, '2025-06-21 00:43:02', '2025-06-21 00:43:02'),
(4899, '9f34afe7-7281-429c-be7c-f9f9e8633b26', 2, 3, 1888, 'hospitals_list.new_hospital', 'messages', 'مستشفى جديد', 'active', NULL, NULL, '2025-06-21 00:43:02', '2025-06-21 00:43:02'),
(4900, '9f34afe7-7717-4c2d-9d23-077fdde1f31d', 2, 3, 1891, 'subscription.subscription', 'messages', 'الاشتراك', 'active', NULL, NULL, '2025-06-21 00:43:02', '2025-06-21 00:43:02'),
(4901, '9f34afe7-7bbc-4bae-8ed9-97b30f473b9f', 2, 3, 1892, 'subscription.subscriptions', 'messages', 'الاشتراكات', 'active', NULL, NULL, '2025-06-21 00:43:02', '2025-06-21 00:43:02'),
(4902, '9f34afe7-8091-4bb1-b676-fb179119828b', 2, 3, 1893, 'subscription.subscription_details', 'messages', 'تفاصيل الاشتراك', 'active', NULL, NULL, '2025-06-21 00:43:03', '2025-06-21 00:43:03'),
(4903, '9f34afe7-853f-4a4a-86eb-acbeb35c727b', 2, 3, 1894, 'subscription.edit_subscription', 'messages', 'تحرير الاشتراك', 'active', NULL, NULL, '2025-06-21 00:43:03', '2025-06-21 00:43:03'),
(4904, '9f34afe7-89f6-4caa-a3ef-d4e33ad45e68', 2, 3, 1895, 'subscription.payment_approved', 'messages', 'تمت الموافقة على الدفع', 'active', NULL, NULL, '2025-06-21 00:43:03', '2025-06-21 00:43:03'),
(4905, '9f34afe7-8ebd-4297-8533-e8eb9b1f20f6', 2, 3, 1896, 'subscription.approved', 'messages', 'وافق', 'active', NULL, NULL, '2025-06-21 00:43:03', '2025-06-21 00:43:03'),
(4906, '9f34afe7-9391-4a16-9e2d-fa628520bc92', 2, 3, 1897, 'subscription.denied', 'messages', 'رفض', 'active', NULL, NULL, '2025-06-21 00:43:03', '2025-06-21 00:43:03'),
(4907, '9f34afe7-9846-483b-878c-303053113e11', 2, 3, 1889, 'subscription.month', 'messages', 'شهر', 'active', NULL, NULL, '2025-06-21 00:43:03', '2025-06-21 00:43:03'),
(4908, '9f34afe7-9cf1-492d-8ba4-adb060c4e132', 2, 3, 1890, 'subscription.year', 'messages', 'سنة', 'active', NULL, NULL, '2025-06-21 00:43:03', '2025-06-21 00:43:03'),
(4909, '9f34afe7-a1cd-4f7f-83c2-fd4a8b32b40f', 2, 3, 1898, 'subscription.select_manual_payment', 'messages', 'حدد الدفع اليدوي', 'active', NULL, NULL, '2025-06-21 00:43:03', '2025-06-21 00:43:03'),
(4910, '9f34afe7-a683-4cb4-9842-b56dff308f3f', 2, 3, 1899, 'subscription.waiting_for_approval', 'messages', 'بانتظار الموافقة', 'active', NULL, NULL, '2025-06-21 00:43:03', '2025-06-21 00:43:03'),
(4911, '9f34afe7-ab41-486e-af07-1e86e4b2f3e5', 2, 3, 1900, 'subscription.cash_payment_done', 'messages', 'تم الدفع الخاص بك وسيتم تنشيط اشتراكك بمجرد موافقة المسؤول على معاملتك.', 'active', NULL, NULL, '2025-06-21 00:43:03', '2025-06-21 00:43:03'),
(4912, '9f34afe7-afdf-4057-bd60-9d4ba4048207', 2, 3, 1901, 'delete.accountant', 'messages', 'محاسب', 'active', NULL, NULL, '2025-06-21 00:43:03', '2025-06-21 00:43:03'),
(4913, '9f34afe7-b494-40a3-b3c7-de6a41044464', 2, 3, 1902, 'delete.account', 'messages', 'الحساب', 'active', NULL, NULL, '2025-06-21 00:43:03', '2025-06-21 00:43:03'),
(4914, '9f34afe7-b997-4677-aa1f-0f892b2122e3', 2, 3, 1903, 'delete.advanced_payment', 'messages', 'دفع', 'active', NULL, NULL, '2025-06-21 00:43:03', '2025-06-21 00:43:03'),
(4915, '9f34afe7-be64-41ea-97bf-b9d1232b8de7', 2, 3, 1904, 'delete.ambulance_call', 'messages', 